/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.documentation;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.DocumentationTargetProvider;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.TextRangeAndMarkupContent;
import com.intellij.platform.lsp.impl.documentation.LspDocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/lsp/impl/documentation/LspDocumentationTargetProvider;", "Lcom/intellij/platform/backend/documentation/DocumentationTargetProvider;", "()V", "documentationTargets", "", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDocumentationTargetProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDocumentationTargetProvider.kt\ncom/intellij/platform/lsp/impl/documentation/LspDocumentationTargetProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n1603#2,9:71\n1855#2:80\n1856#2:83\n1612#2:84\n1#3:81\n1#3:82\n*S KotlinDebug\n*F\n+ 1 LspDocumentationTargetProvider.kt\ncom/intellij/platform/lsp/impl/documentation/LspDocumentationTargetProvider\n*L\n29#1:71,9\n29#1:80\n29#1:83\n29#1:84\n29#1:82\n*E\n"})
public final class LspDocumentationTargetProvider
implements DocumentationTargetProvider {
    @NotNull
    public List<DocumentationTarget> documentationTargets(@NotNull PsiFile psiFile, int offset) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (project2.isDefault()) {
            return CollectionsKt.emptyList();
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
        PsiFile psiFile2 = injectedLanguageManager.getTopLevelFile((PsiElement)psiFile);
        int n2 = injectedLanguageManager.injectedToHost((PsiElement)psiFile, offset);
        VirtualFile virtualFile = psiFile2.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project2).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            LspDocumentationTarget lspDocumentationTarget;
            Object t2;
            Object t3 = t2 = iterator.next();
            boolean bl5 = false;
            LspServerImpl lspServerImpl = (LspServerImpl)t3;
            boolean bl6 = false;
            if (!lspServerImpl.getDescriptor().getLspHoverSupport()) {
                lspDocumentationTarget = null;
            } else if (!lspServerImpl.supportsHover$intellij_platform_lsp_impl()) {
                lspDocumentationTarget = null;
            } else {
                int n3 = 300;
                if (lspServerImpl.getRequestExecutor().getHoverInformation(virtualFile2, n2, n3) != null) {
                    TextRangeAndMarkupContent textRangeAndMarkupContent;
                    TextRange textRange;
                    boolean bl7 = false;
                    TextRange textRange2 = textRange = textRangeAndMarkupContent.getTextRange();
                    boolean bl8 = false;
                    TextRange textRange3 = textRange2.getLength() > 0 && textRange2.getEndOffset() <= psiFile2.getTextLength() ? textRange : null;
                    String string = textRange3 != null ? textRange3.substring(psiFile2.getText()) : null;
                    lspDocumentationTarget = new LspDocumentationTarget(string, textRangeAndMarkupContent.getMarkupContent(), project2);
                } else {
                    lspDocumentationTarget = null;
                }
            }
            if (lspDocumentationTarget == null) continue;
            LspDocumentationTarget lspDocumentationTarget2 = lspDocumentationTarget;
            boolean bl9 = false;
            collection.add(lspDocumentationTarget2);
        }
        return (List)collection;
    }
}

