/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.impl.completion.LspCompletionItemInsertHandlerKt;
import com.intellij.platform.lsp.impl.completion.SnippetToTemplateConverter;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.InsertReplaceEdit;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()V", "C", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "lookupElement", "handleInsert", "W", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspCompletionItemInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspCompletionItemInsertHandler.kt\ncom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1#2:180\n766#3:181\n857#3,2:182\n*S KotlinDebug\n*F\n+ 1 LspCompletionItemInsertHandler.kt\ncom/intellij/platform/lsp/impl/completion/LspCompletionItemInsertHandler\n*L\n36#1:181\n36#1:182,2\n*E\n"})
public final class LspCompletionItemInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final LspCompletionItemInsertHandler INSTANCE = new LspCompletionItemInsertHandler();

    private LspCompletionItemInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement lookupElement) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
            this.C(context2, lookupElement);
            LookupElementDecorator lookupElementDecorator = lookupElement instanceof LookupElementDecorator ? (LookupElementDecorator)lookupElement : null;
            if (lookupElementDecorator != null && (lookupElementDecorator = lookupElementDecorator.getDelegate()) != null) {
                lookupElementDecorator.handleInsert(context2);
            }
            this.W(context2, lookupElement);
            CompletionItem completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
            if (completionItem == null || (completionItem = completionItem.getCommand()) == null) break block2;
            CompletionItem completionItem2 = completionItem;
            boolean bl2 = false;
            LspServer lspServer = LspCompletionItemInsertHandlerKt.access$getLspServer(lookupElement);
            Object object = lspServer;
            if (object != null && (object = object.getDescriptor()) != null && (object = ((LspServerDescriptor)object).getLspCommandsSupport()) != null) {
                VirtualFile virtualFile = context2.getFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                ((LspCommandsSupport)object).executeCommand(lspServer, virtualFile, (Command)completionItem2);
            }
        }
    }

    private final void C(InsertionContext insertionContext, LookupElement lookupElement) {
        Range range;
        CompletionItem completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
        List list = completionItem != null ? completionItem.getAdditionalTextEdits() : null;
        if (list == null) {
            return;
        }
        List list2 = list;
        CompletionItem completionItem2 = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
        if (completionItem2 != null && (completionItem2 = completionItem2.getTextEdit()) != null) {
            CompletionItem completionItem3 = completionItem2;
            boolean bl2 = false;
            range = completionItem3.isLeft() ? ((TextEdit)completionItem3.getLeft()).getRange() : ((InsertReplaceEdit)completionItem3.getRight()).getInsert();
        } else {
            range = null;
        }
        if (range == null) {
            return;
        }
        Range range2 = range;
        Iterable iterable = list2;
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl4 = false;
        for (Object t2 : iterable2) {
            TextEdit textEdit = (TextEdit)t2;
            boolean bl5 = false;
            boolean bl6 = range2.getStart().getLine() - textEdit.getRange().getStart().getLine() > 0 || range2.getStart().getCharacter() - textEdit.getRange().getStart().getCharacter() > 0;
            if (!bl6) continue;
            collection.add(t2);
        }
        List list3 = (List)collection;
        boolean bl7 = false;
        Document document = insertionContext.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Lsp4jUtilKt.applyTextEdits(document, list3);
    }

    private final void W(InsertionContext insertionContext, LookupElement lookupElement) {
        CompletionItem completionItem = LspCompletionItemInsertHandlerKt.access$getLsp4jCompletionItem(lookupElement);
        if ((completionItem != null ? completionItem.getInsertTextFormat() : null) != InsertTextFormat.Snippet) {
            return;
        }
        insertionContext.getDocument().replaceString(insertionContext.getStartOffset(), insertionContext.getTailOffset(), (CharSequence)"");
        TemplateManager templateManager = TemplateManager.getInstance((Project)insertionContext.getProject());
        Editor editor = insertionContext.getEditor();
        Project project = insertionContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        templateManager.runTemplate(editor, new SnippetToTemplateConverter(project, string).computeTemplate$intellij_platform_lsp_impl());
    }
}

