/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api.customization;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionDisabled;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DeleteFile;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J$\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eH\u0015J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u001c\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010)\u001a\u00020\u000f2\b\b\u0002\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\u000fJ\b\u0010-\u001a\u00020\u000fH\u0016J\u001e\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0006\u0010/\u001a\u00020\u001dH\u0002J!\u00100\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00101\u001a\u00020'H\u0096\u0002J\u0010\u00100\u001a\u00020\u00142\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0018\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u0010H\u0002J\u0006\u00105\u001a\u00020\u0012J \u00105\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u00101\u001a\u00020'H\u0016J\b\u00106\u001a\u00020\u0014H\u0003J\u0006\u00107\u001a\u00020\u0012R\u0014\u0010\u0007\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/platform/lsp/api/customization/LspIntentionAction;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "lspServer", "Lcom/intellij/platform/lsp/api/LspServer;", "initialCodeAction", "Lorg/eclipse/lsp4j/CodeAction;", "(Lcom/intellij/platform/lsp/api/LspServer;Lorg/eclipse/lsp4j/CodeAction;)V", "codeAction", "C", "()Lorg/eclipse/lsp4j/CodeAction;", "getLspServer", "()Lcom/intellij/platform/lsp/api/LspServer;", "resolvedCodeAction", "uriToDocumentMap", "", "", "Lcom/intellij/openapi/editor/Document;", "uriToDocumentMapInitialized", "", "C", "", "commandsSupport", "Lcom/intellij/platform/lsp/api/customization/LspCommandsSupport;", "command", "Lorg/eclipse/lsp4j/Command;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "applyWorkspaceEdit", "workspaceEdit", "Lorg/eclipse/lsp4j/WorkspaceEdit;", "C", "Lorg/eclipse/lsp4j/CreateFile;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "nonPhysicalFile", "Lcom/intellij/psi/PsiFile;", "C", "documentUri", "version", "", "getFamilyName", "getText", "C", "edit", "invoke", "psiFile", "C", "nonPhysicalDocument", "physicalDocument", "isAvailable", "C", "startInWriteAction", "intellij.platform.lsp"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLspIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,272:1\n1#2:273\n125#3:274\n152#3,3:275\n1855#4,2:278\n1747#4,3:280\n1855#4:283\n1856#4:285\n1855#4,2:289\n1855#4,2:291\n1855#4,2:297\n1855#4,2:299\n23#5:284\n23#5:286\n23#5:287\n23#5:288\n23#5:293\n23#5:294\n23#5:295\n23#5:296\n*S KotlinDebug\n*F\n+ 1 LspIntentionAction.kt\ncom/intellij/platform/lsp/api/customization/LspIntentionAction\n*L\n93#1:274\n93#1:275,3\n115#1:278,2\n124#1:280,3\n129#1:283\n129#1:285\n187#1:289,2\n196#1:291,2\n256#1:297,2\n263#1:299,2\n133#1:284\n160#1:286\n174#1:287\n180#1:288\n216#1:293\n221#1:294\n227#1:295\n233#1:296\n*E\n"})
public class LspIntentionAction
implements IntentionAction {
    @NotNull
    private final LspServer lspServer;
    @NotNull
    private final CodeAction initialCodeAction;
    @Nullable
    private CodeAction resolvedCodeAction;
    private boolean uriToDocumentMapInitialized;
    @Nullable
    private Map<String, ? extends Document> uriToDocumentMap;

    public LspIntentionAction(@NotNull LspServer lspServer, @NotNull CodeAction initialCodeAction) {
        InitializeResult initializeResult;
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        Intrinsics.checkNotNullParameter((Object)initialCodeAction, (String)"initialCodeAction");
        this.lspServer = lspServer;
        this.initialCodeAction = initialCodeAction;
        this.resolvedCodeAction = this.initialCodeAction.getEdit() != null || !((initializeResult = this.lspServer.getInitializeResult()) != null && (initializeResult = initializeResult.getCapabilities()) != null && (initializeResult = initializeResult.getCodeActionProvider()) != null && (initializeResult = (CodeActionOptions)initializeResult.getRight()) != null ? Intrinsics.areEqual((Object)initializeResult.getResolveProvider(), (Object)true) : false) ? this.initialCodeAction : null;
    }

    @NotNull
    protected final LspServer getLspServer() {
        return this.lspServer;
    }

    private final CodeAction C() {
        CodeAction codeAction = this.resolvedCodeAction;
        if (codeAction == null) {
            codeAction = this.initialCodeAction;
        }
        return codeAction;
    }

    @NotNull
    public final String getFamilyName() {
        return "";
    }

    public final boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        String string = this.C().getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.isAvailable();
    }

    public final boolean isAvailable() {
        CodeActionDisabled codeActionDisabled = this.C().getDisabled();
        if (codeActionDisabled != null) {
            CodeActionDisabled codeActionDisabled2 = codeActionDisabled;
            boolean bl2 = false;
            return false;
        }
        this.C();
        if (!this.uriToDocumentMapInitialized) {
            Map<String, Document> map;
            if (this.C().getEdit() != null) {
                WorkspaceEdit workspaceEdit = this.C().getEdit();
                Intrinsics.checkNotNullExpressionValue((Object)workspaceEdit, (String)"getEdit(...)");
                map = this.C(workspaceEdit);
            } else {
                map = MapsKt.emptyMap();
            }
            this.uriToDocumentMap = map;
            this.uriToDocumentMapInitialized = true;
        }
        return this.uriToDocumentMap != null && (this.C().getEdit() != null || this.C().getCommand() != null);
    }

    @RequiresBackgroundThread
    private final void C() {
        if (this.resolvedCodeAction != null) {
            return;
        }
        CodeAction codeAction = (CodeAction)LspServer.sendRequestSync$default(this.lspServer, 0, (Function1)new Function1<LanguageServer, CompletableFuture<CodeAction>>(this){
            final /* synthetic */ LspIntentionAction this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<CodeAction> invoke(@NotNull LanguageServer it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                CompletableFuture completableFuture = it2.getTextDocumentService().resolveCodeAction(LspIntentionAction.access$getCodeAction(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"resolveCodeAction(...)");
                return completableFuture;
            }
        }, 1, null);
        CodeAction codeAction2 = codeAction;
        if (codeAction2 == null) {
            codeAction2 = this.initialCodeAction;
        }
        this.resolvedCodeAction = codeAction2;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.invoke(psiFile.getVirtualFile());
    }

    public final void invoke(@Nullable VirtualFile contextFile) {
        block7: {
            Map<String, ? extends Document> map;
            block6: {
                Map<String, ? extends Document> map2 = this.uriToDocumentMap;
                if (map2 == null) {
                    return;
                }
                Map<String, ? extends Document> map3 = map = map2;
                boolean bl2 = false;
                Map<String, ? extends Document> map4 = map3;
                Collection collection = new ArrayList(map3.size());
                boolean bl3 = false;
                Iterator<Map.Entry<String, ? extends Document>> iterator = map4.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ? extends Document> entry;
                    Map.Entry<String, ? extends Document> entry2 = entry = iterator.next();
                    Collection collection2 = collection;
                    boolean bl4 = false;
                    collection2.add(FileDocumentManager.getInstance().getFile(entry2.getValue()));
                }
                List list = (List)collection;
                if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(this.lspServer.getProject(), (Collection)list)) {
                    return;
                }
                Object object = this.C().getEdit();
                if (object != null && (object = object.getChanges()) != null ? !object.isEmpty() : false) break block6;
                Object object2 = this.C().getEdit();
                boolean bl5 = object2 != null && (object2 = object2.getDocumentChanges()) != null ? !((Collection)object2).isEmpty() : false;
                if (!bl5) break block7;
            }
            WriteAction.run(() -> LspIntentionAction.C(this, map));
        }
        this.C(this.lspServer.getDescriptor().getLspCommandsSupport(), this.C().getCommand(), contextFile);
    }

    private final void C(LspCommandsSupport lspCommandsSupport, Command command, VirtualFile virtualFile) {
        if (lspCommandsSupport != null && command != null && virtualFile != null) {
            lspCommandsSupport.executeCommand(this.lspServer, virtualFile, command);
        }
    }

    @RequiresWriteLock
    protected void applyWorkspaceEdit(@NotNull WorkspaceEdit workspaceEdit, @NotNull Map<String, ? extends Document> uriToDocumentMap) {
        block14: {
            boolean bl2;
            boolean bl3;
            Iterable iterable;
            List list;
            Map map;
            block13: {
                Intrinsics.checkNotNullParameter((Object)workspaceEdit, (String)"workspaceEdit");
                Intrinsics.checkNotNullParameter(uriToDocumentMap, (String)"uriToDocumentMap");
                Map map2 = workspaceEdit.getChanges();
                if (map2 != null) {
                    Map map3 = map2;
                    boolean bl4 = false;
                    Iterable iterable2 = map3.entrySet();
                    boolean bl5 = false;
                    for (Object object : iterable2) {
                        Document document;
                        Map.Entry entry = (Map.Entry)object;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull((Object)uriToDocumentMap.get(entry.getKey()));
                        Object v2 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                        if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                        return;
                    }
                }
                map = new LinkedHashMap();
                List list2 = workspaceEdit.getDocumentChanges();
                if (list2 == null) break block14;
                list = list2;
                boolean bl7 = false;
                iterable = list;
                bl3 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Map.Entry entry : iterable) {
                        Either either = (Either)entry;
                        boolean bl8 = false;
                        if (!(either.isRight() && !(either.getRight() instanceof CreateFile))) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            iterable = list;
            bl3 = false;
            for (Map.Entry entry : iterable) {
                boolean bl9;
                LspIntentionAction lspIntentionAction;
                Document document;
                boolean bl10;
                TextDocumentEdit textDocumentEdit;
                TextDocumentEdit textDocumentEdit2;
                Either either = (Either)entry;
                boolean bl11 = false;
                TextDocumentEdit textDocumentEdit3 = textDocumentEdit2 = (TextDocumentEdit)either.getLeft();
                if (textDocumentEdit3 != null) {
                    Intrinsics.checkNotNull((Object)textDocumentEdit3);
                    textDocumentEdit = textDocumentEdit2;
                    bl10 = false;
                    Document document2 = uriToDocumentMap.get(textDocumentEdit.getTextDocument().getUri());
                    if (document2 == null) {
                        document2 = (Document)map.get(textDocumentEdit.getTextDocument().getUri());
                    }
                    if ((document = document2) == null) {
                        lspIntentionAction = this;
                        bl9 = false;
                        Logger logger = Logger.getInstance(LspIntentionAction.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("No Document for " + textDocumentEdit.getTextDocument().getUri());
                        return;
                    }
                    List list3 = textDocumentEdit.getEdits();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEdits(...)");
                    if (!Lsp4jUtilKt.applyTextEdits(document, list3)) {
                        return;
                    }
                }
                TextDocumentEdit textDocumentEdit4 = textDocumentEdit2 = (ResourceOperation)either.getRight();
                if (textDocumentEdit4 == null) continue;
                Intrinsics.checkNotNull((Object)textDocumentEdit4);
                textDocumentEdit = textDocumentEdit2;
                bl10 = false;
                document = textDocumentEdit;
                if (document instanceof CreateFile) {
                    if (this.C((CreateFile)textDocumentEdit) != null) {
                        bl9 = false;
                        Map map4 = map;
                        String string = ((CreateFile)textDocumentEdit).getUri();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
                        map4.put(string, lspIntentionAction);
                    }
                    continue;
                }
                if (!(document instanceof DeleteFile) && !(document instanceof RenameFile)) continue;
            }
        }
    }

    private final Document C(CreateFile createFile) {
        Document document;
        VirtualFile virtualFile;
        String string = createFile.getUri();
        String string2 = PathUtil.getParentPath((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getParentPath(...)");
        String string3 = string2;
        VirtualFile virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        while (virtualFile2 == null && !(((CharSequence)string3).length() == 0)) {
            Intrinsics.checkNotNullExpressionValue((Object)PathUtil.getParentPath((String)string3), (String)"getParentPath(...)");
            virtualFile2 = this.lspServer.getDescriptor().findFileByUri(string3);
        }
        if (virtualFile2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Ignoring CreateFile(" + string + "): base directory not found");
            return null;
        }
        Intrinsics.checkNotNull((Object)string);
        String string4 = string.substring(string3.length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        String string5 = string4;
        String string6 = PathUtil.getFileName((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getFileName(...)");
        String string7 = string6;
        String string8 = PathUtil.getParentPath((String)string5);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getParentPath(...)");
        String string9 = string8;
        VirtualFile virtualFile3 = virtualFile = ((CharSequence)string9).length() == 0 ? virtualFile2 : VfsUtil.createDirectoryIfMissing((String)(virtualFile2.getPath() + "/" + string9));
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl3 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to create parent directory for CreateFile(" + string + ")");
            return null;
        }
        VirtualFile virtualFile4 = virtualFile.createChildData((Object)this, string7);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"createChildData(...)");
        VirtualFile virtualFile5 = virtualFile4;
        Document document2 = document = FileDocumentManager.getInstance().getDocument(virtualFile5);
        boolean bl4 = false;
        if (document2 == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl5 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No Document for created file " + virtualFile5.getPath());
        }
        return document;
    }

    private final Map<String, Document> C(WorkspaceEdit workspaceEdit) {
        Map map;
        block7: {
            map = new LinkedHashMap();
            Map map2 = workspaceEdit.getChanges();
            if (map2 != null) {
                Map map3 = map2;
                boolean bl2 = false;
                Iterable iterable = map3.keySet();
                boolean bl3 = false;
                for (Object object : iterable) {
                    Document document;
                    String string = (String)object;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)string);
                    if (LspIntentionAction.getDocument$default(this, string, 0, 2, null) == null) {
                        return null;
                    }
                    map.put(string, document);
                }
            }
            Set set = new LinkedHashSet();
            List list = workspaceEdit.getDocumentChanges();
            if (list == null) break block7;
            List list2 = list;
            boolean bl5 = false;
            Iterable iterable = list2;
            boolean bl6 = false;
            for (String string : iterable) {
                TextDocumentEdit textDocumentEdit;
                Either either = (Either)string;
                boolean bl7 = false;
                TextDocumentEdit textDocumentEdit2 = textDocumentEdit = (TextDocumentEdit)either.getLeft();
                if (textDocumentEdit2 != null) {
                    Intrinsics.checkNotNull((Object)textDocumentEdit2);
                    TextDocumentEdit textDocumentEdit3 = textDocumentEdit;
                    boolean bl8 = false;
                    String string2 = textDocumentEdit3.getTextDocument().getUri();
                    if (!set.contains(string2)) {
                        Document document;
                        Integer n2 = textDocumentEdit3.getTextDocument().getVersion();
                        Intrinsics.checkNotNull((Object)string2);
                        Integer n3 = n2;
                        if (this.C(string2, n3 != null ? n3 : -1) == null) {
                            return null;
                        }
                        map.put(string2, document);
                    }
                }
                Object object = either.getRight();
                Object object2 = object instanceof CreateFile ? (CreateFile)object : null;
                if (object2 == null || (object2 = (object = object2.getUri())) == null) continue;
                Intrinsics.checkNotNull((Object)object2);
                Object object3 = object;
                boolean bl9 = false;
                set.add(object3);
            }
        }
        return map;
    }

    private final Document C(String string, int n2) {
        VirtualFile virtualFile = this.lspServer.getDescriptor().findFileByUri(string);
        if (virtualFile == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl2 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File not found: " + string);
            return null;
        }
        if (!ProjectFileIndex.getInstance((Project)this.lspServer.getProject()).isInContent(virtualFile)) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl3 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("File is not within the project content: " + string);
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl4 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Document not found for file: " + virtualFile);
            return null;
        }
        int n3 = this.lspServer.getDocumentVersion(document);
        if (n2 != -1 && n3 != n2) {
            LspIntentionAction lspIntentionAction = this;
            boolean bl5 = false;
            Logger logger = Logger.getInstance(LspIntentionAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Ignoring CodeAction for document version " + n2 + " (" + virtualFile.getName() + "); current document version: " + n3);
            return null;
        }
        return document;
    }

    static /* synthetic */ Document getDocument$default(LspIntentionAction lspIntentionAction, String string, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDocument");
        }
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return lspIntentionAction.C(string, n2);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile nonPhysicalFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)nonPhysicalFile, (String)"nonPhysicalFile");
        Map<String, ? extends Document> map = this.uriToDocumentMap;
        if (map == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Map<String, ? extends Document> map2 = map;
        PsiFile psiFile = nonPhysicalFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document2 = document;
        if (!map2.containsValue(document2)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        Document document3 = nonPhysicalFile.getViewProvider().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
        this.C(document3, document2);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    private final void C(Document document, Document document2) {
        block5: {
            boolean bl2;
            Map.Entry entry;
            boolean bl3;
            Iterable iterable;
            boolean bl4;
            Object object;
            Map<String, ? extends Document> map = this.uriToDocumentMap;
            if (map == null) {
                return;
            }
            Map<String, ? extends Document> map2 = map;
            WorkspaceEdit workspaceEdit = this.C().getEdit();
            if (workspaceEdit == null) {
                return;
            }
            WorkspaceEdit workspaceEdit2 = workspaceEdit;
            Map map3 = workspaceEdit2.getChanges();
            if (map3 != null) {
                object = map3;
                bl4 = false;
                iterable = object.entrySet();
                bl3 = false;
                for (Object t2 : iterable) {
                    entry = (Map.Entry)t2;
                    bl2 = false;
                    if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(entry.getKey()))) continue;
                    Object v2 = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
                    if (Lsp4jUtilKt.applyTextEdits(document, (List)v2)) continue;
                    return;
                }
            }
            List list = workspaceEdit2.getDocumentChanges();
            if (list == null) break block5;
            object = list;
            bl4 = false;
            iterable = (Iterable)object;
            bl3 = false;
            for (Object t2 : iterable) {
                TextDocumentEdit textDocumentEdit;
                entry = (Either)t2;
                bl2 = false;
                TextDocumentEdit textDocumentEdit2 = textDocumentEdit = (TextDocumentEdit)entry.getLeft();
                if (textDocumentEdit2 == null) continue;
                Intrinsics.checkNotNull((Object)textDocumentEdit2);
                TextDocumentEdit textDocumentEdit3 = textDocumentEdit;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)document2, (Object)map2.get(textDocumentEdit3.getTextDocument().getUri()))) continue;
                List list2 = textDocumentEdit3.getEdits();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEdits(...)");
                if (Lsp4jUtilKt.applyTextEdits(document, list2)) continue;
                return;
            }
        }
    }

    private static final void C(LspIntentionAction lspIntentionAction, Map map) {
        Intrinsics.checkNotNullParameter((Object)lspIntentionAction, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)map, (String)"$uriToDocumentMap");
        WorkspaceEdit workspaceEdit = lspIntentionAction.C().getEdit();
        Intrinsics.checkNotNullExpressionValue((Object)workspaceEdit, (String)"getEdit(...)");
        lspIntentionAction.applyWorkspaceEdit(workspaceEdit, map);
    }

    public static final /* synthetic */ CodeAction access$getCodeAction(LspIntentionAction $this) {
        return $this.C();
    }
}

