/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlPathModelKt;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolverManager;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.url.references.UrlPathSegmentPresentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CancellationCheck;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.LazyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=UrlPathSegmentPresentationProvider.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 <2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001<B\u0017\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020\tH\u0016J\b\u0010%\u001a\u00020\tH\u0016J\u0013\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\tH\u0016J\b\u0010-\u001a\u00020\tH\u0016J9\u0010.\u001a\b\u0012\u0004\u0012\u0002H00/\"\u0004\b\u0000\u001002\u001e\u00101\u001a\u001a\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e04\u0012\u0004\u0012\u0002H002H\u0000\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\tH\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u00022\u0006\u0010:\u001a\u00020)H\u0016J\b\u0010;\u001a\u00020)H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001b\u001a\u0004\b\u001f\u0010 R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;", "Lcom/intellij/pom/PomRenameableTarget;", "", "context", "Lcom/intellij/microservices/url/references/UrlPathContext;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/microservices/url/references/UrlPathContext;Lcom/intellij/openapi/project/Project;)V", "isAtEnd", "", "(Lcom/intellij/microservices/url/references/UrlPathContext;ZLcom/intellij/openapi/project/Project;)V", "getContext", "()Lcom/intellij/microservices/url/references/UrlPathContext;", "lastPathSegment", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "C", "()Lcom/intellij/microservices/url/UrlPath$PathSegment;", "navigatablePsiElement", "Lcom/intellij/psi/NavigatablePsiElement;", "getNavigatablePsiElement", "()Lcom/intellij/psi/NavigatablePsiElement;", "pathValues", "", "Lcom/intellij/microservices/url/UrlPath;", "getPathValues", "()Ljava/util/List;", "pathValues$delegate", "Lkotlin/Lazy;", "resolvedTargets", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getResolvedTargets", "()Ljava/util/Set;", "resolvedTargets$delegate", "urlResolver", "Lcom/intellij/microservices/url/UrlResolverManager;", "canNavigate", "canNavigateToSource", "equals", "other", "getName", "", "hashCode", "", "isValid", "isWritable", "mapVariants", "Lkotlin/sequences/Sequence;", "T", "handler", "Lkotlin/Function2;", "Lcom/intellij/microservices/url/UrlResolveRequest;", "", "mapVariants$intellij_microservices", "navigate", "", "requestFocus", "setName", "newName", "toString", "Companion", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathReferenceUnifiedPomTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathReferenceUnifiedPomTarget.kt\ncom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReferenceResolveUtils.kt\ncom/intellij/microservices/utils/ReferenceResolveUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n13#2:109\n13#2:124\n13#3,8:110\n1611#4:118\n1855#4:119\n1856#4:121\n1612#4:122\n1603#4,9:125\n1855#4:134\n1856#4:136\n1612#4:137\n1726#4,3:138\n1611#4:141\n1855#4:142\n1856#4:145\n1612#4:146\n1611#4:147\n1855#4:148\n1856#4:150\n1612#4:151\n1747#4,3:152\n1#5:120\n1#5:123\n1#5:135\n1#5:143\n1#5:144\n1#5:149\n*S KotlinDebug\n*F\n+ 1 UrlPathReferenceUnifiedPomTarget.kt\ncom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget\n*L\n26#1:109\n54#1:124\n33#1:110,8\n49#1:118\n49#1:119\n49#1:121\n49#1:122\n81#1:125,9\n81#1:134\n81#1:136\n81#1:137\n82#1:138,3\n91#1:141\n91#1:142\n91#1:145\n91#1:146\n92#1:147\n92#1:148\n92#1:150\n92#1:151\n95#1:152,3\n49#1:120\n81#1:135\n91#1:144\n92#1:149\n*E\n"})
public final class UrlPathReferenceUnifiedPomTarget
implements PomRenameableTarget<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlPathContext context;
    private final boolean isAtEnd;
    @NotNull
    private final UrlResolverManager urlResolver;
    @NotNull
    private final Lazy resolvedTargets$delegate;
    @NotNull
    private final Lazy pathValues$delegate;

    public UrlPathReferenceUnifiedPomTarget(@NotNull UrlPathContext context2, boolean isAtEnd, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.context = context2;
        this.isAtEnd = isAtEnd;
        if (ApplicationManager.getApplication().isUnitTestMode() && CollectionsKt.none((Iterable)this.context.getSelfPaths())) {
            boolean bl2 = false;
            Logger logger = Logger.getInstance(UrlPathReferenceUnifiedPomTarget.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("UrlPathReferenceUnifiedPomTarget for empty contextProvider should not be created");
        }
        this.urlResolver = UrlResolverManager.Companion.getInstance(project);
        String string = MicroservicesBundle.message("microservices.resolving.reference", new Object[0]);
        boolean bl3 = false;
        this.resolvedTargets$delegate = LazyKt.lazyPub((Function0)((Function0)new Function0<Set<? extends UrlTargetInfo>>(string, this){
            final /* synthetic */ String $statusMessage;
            final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
            {
                this.$statusMessage = $statusMessage;
                this.this$0 = urlPathReferenceUnifiedPomTarget;
                super(0);
            }

            public final Set<? extends UrlTargetInfo> invoke() {
                Object object;
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    object = ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(this.this$0){
                        final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
                        {
                            this.this$0 = urlPathReferenceUnifiedPomTarget;
                        }

                        public final T compute() {
                            return (T)ReadAction.compute((ThrowableComputable)new ThrowableComputable(this.this$0){
                                final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
                                {
                                    this.this$0 = urlPathReferenceUnifiedPomTarget;
                                }

                                public final T compute() {
                                    return (T)CancellationCheck.Companion.runWithCancellationCheck((Function0)new Function0<T>(this.this$0){
                                        final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
                                        {
                                            this.this$0 = urlPathReferenceUnifiedPomTarget;
                                            super(0);
                                        }

                                        public final T invoke() {
                                            boolean bl2 = false;
                                            UrlPathContext urlPathContext = UrlPathReferenceUnifiedPomTarget.access$isAtEnd$p(this.this$0) ? this.this$0.getContext() : this.this$0.getContext().subContext(new UrlPath(CollectionsKt.listOf((Object)UrlPath.PathSegment.Undefined.INSTANCE)));
                                            return (T)UrlPathModelKt.filterBestUrlPathMatches$default(SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(urlPathContext.getResolveRequests()), (Function1)((Function1)new Function1<UrlResolveRequest, Sequence<? extends UrlTargetInfo>>(this.this$0){
                                                final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(1);
                                                }

                                                @NotNull
                                                public final Sequence<UrlTargetInfo> invoke(@NotNull UrlResolveRequest it2) {
                                                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                                                    return CollectionsKt.asSequence(UrlPathReferenceUnifiedPomTarget.access$getUrlResolver$p(this.this$0).resolve(it2));
                                                }
                                            }))), null, 2, null);
                                        }
                                    });
                                }
                            });
                        }
                    }, this.$statusMessage, true, null);
                } else {
                    boolean bl2 = false;
                    UrlPathContext urlPathContext = UrlPathReferenceUnifiedPomTarget.access$isAtEnd$p(this.this$0) ? this.this$0.getContext() : this.this$0.getContext().subContext(new UrlPath(CollectionsKt.listOf((Object)UrlPath.PathSegment.Undefined.INSTANCE)));
                    object = UrlPathModelKt.filterBestUrlPathMatches$default(SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(urlPathContext.getResolveRequests()), (Function1)((Function1)new /* invalid duplicate definition of identical inner class */))), null, 2, null);
                }
                return object;
            }
        }));
        this.pathValues$delegate = kotlin.LazyKt.lazy((Function0)((Function0)new Function0<List<? extends UrlPath>>(this){
            final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<UrlPath> invoke() {
                Iterable<UrlResolveRequest> iterable = this.this$0.getContext().getResolveRequests();
                boolean bl2 = false;
                Iterable<UrlResolveRequest> iterable2 = iterable;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault(iterable, (int)10));
                boolean bl3 = false;
                Iterator<UrlResolveRequest> iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    UrlResolveRequest urlResolveRequest;
                    UrlResolveRequest urlResolveRequest2 = urlResolveRequest = iterator.next();
                    Collection collection2 = collection;
                    boolean bl4 = false;
                    collection2.add(urlResolveRequest2.getPath());
                }
                return (List)collection;
            }
        }));
    }

    @NotNull
    public final UrlPathContext getContext() {
        return this.context;
    }

    public UrlPathReferenceUnifiedPomTarget(@NotNull UrlPathContext context2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(context2, true, project);
    }

    @NotNull
    public final Set<UrlTargetInfo> getResolvedTargets() {
        Lazy lazy = this.resolvedTargets$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final List<UrlPath> getPathValues() {
        Lazy lazy = this.pathValues$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final <T> Sequence<T> mapVariants$intellij_microservices(@NotNull Function2<? super UrlResolveRequest, ? super Iterable<? extends UrlTargetInfo>, ? extends T> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(this.context.getResolveRequests()), (Function1)new Function1<UrlResolveRequest, T>(handler, this){
            final /* synthetic */ Function2<UrlResolveRequest, Iterable<? extends UrlTargetInfo>, T> $handler;
            final /* synthetic */ UrlPathReferenceUnifiedPomTarget this$0;
            {
                this.$handler = $handler;
                this.this$0 = $receiver;
                super(1);
            }

            public final T invoke(@NotNull UrlResolveRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return (T)this.$handler.invoke((Object)request, UrlPathReferenceUnifiedPomTarget.access$getUrlResolver$p(this.this$0).getVariants(request));
            }
        });
    }

    @Nullable
    public final NavigatablePsiElement getNavigatablePsiElement() {
        NavigatablePsiElement navigatablePsiElement;
        boolean bl2;
        Object object;
        Iterable iterable = this.getResolvedTargets();
        Collection collection = new HashSet();
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        boolean bl4 = false;
        Iterator iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            PsiElement psiElement;
            Object t2 = object = iterator.next();
            bl2 = false;
            UrlTargetInfo urlTargetInfo = (UrlTargetInfo)t2;
            boolean bl5 = false;
            if (urlTargetInfo.resolveToPsiElement() == null) continue;
            boolean bl6 = false;
            collection.add(psiElement);
        }
        PsiElement psiElement = (PsiElement)CollectionsKt.singleOrNull((Iterable)collection);
        if (psiElement != null && (iterable = psiElement.getNavigationElement()) != null) {
            Iterable iterable3 = iterable;
            boolean bl7 = false;
            navigatablePsiElement = iterable3 instanceof NavigatablePsiElement ? (NavigatablePsiElement)iterable3 : null;
            if (navigatablePsiElement == null) {
                UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = this;
                boolean bl8 = false;
                object = ApplicationManager.getApplication();
                boolean bl9 = false;
                boolean bl10 = object.isInternal() || object.isUnitTestMode();
                if (bl10) {
                    bl2 = false;
                    Logger logger = Logger.getInstance(UrlPathReferenceUnifiedPomTarget.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("non-navigatable navigation element: " + (PsiElement)iterable3 + " resolvedTargets = " + urlPathReferenceUnifiedPomTarget.getResolvedTargets());
                }
                navigatablePsiElement = null;
            }
        } else {
            navigatablePsiElement = null;
        }
        return navigatablePsiElement;
    }

    public void navigate(boolean requestFocus) {
        block0: {
            NavigatablePsiElement navigatablePsiElement = this.getNavigatablePsiElement();
            if (navigatablePsiElement == null) break block0;
            navigatablePsiElement.navigate(requestFocus);
        }
    }

    @Nullable
    public Object setName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return null;
    }

    public boolean canNavigate() {
        NavigatablePsiElement navigatablePsiElement = this.getNavigatablePsiElement();
        return navigatablePsiElement != null ? navigatablePsiElement.canNavigate() : false;
    }

    private final UrlPath.PathSegment C() {
        Object object = (UrlPath)CollectionsKt.firstOrNull(this.getPathValues());
        return object != null && (object = ((UrlPath)object).getSegments()) != null ? (UrlPath.PathSegment)CollectionsKt.lastOrNull((List)object) : null;
    }

    @NotNull
    public String getName() {
        UrlPath.PathSegment pathSegment = this.C();
        if (pathSegment == null) {
            pathSegment = UrlPath.PathSegment.Undefined.INSTANCE;
        }
        return UrlPath.FULL_PATH_VARIABLE_PRESENTATION.patternMatch(pathSegment);
    }

    public boolean canNavigateToSource() {
        NavigatablePsiElement navigatablePsiElement = this.getNavigatablePsiElement();
        return navigatablePsiElement != null ? navigatablePsiElement.canNavigateToSource() : false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isWritable() {
        boolean bl2;
        block5: {
            if (!(this.C() instanceof UrlPath.PathSegment.Exact)) {
                return false;
            }
            Iterable iterable = this.getResolvedTargets();
            boolean bl3 = false;
            Iterable iterable2 = iterable;
            Collection collection2 = new ArrayList();
            boolean bl4 = false;
            Iterable iterable3 = iterable2;
            boolean bl5 = false;
            Iterator iterator = iterable3.iterator();
            while (iterator.hasNext()) {
                PsiElement psiElement;
                Object t2;
                Object t3 = t2 = iterator.next();
                boolean bl6 = false;
                UrlTargetInfo urlTargetInfo = (UrlTargetInfo)t3;
                boolean bl7 = false;
                if (urlTargetInfo.resolveToPsiElement() == null) continue;
                boolean bl8 = false;
                collection2.add(psiElement);
            }
            iterable = (List)collection2;
            bl3 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl2 = true;
            } else {
                for (Collection collection2 : iterable) {
                    PsiElement psiElement = (PsiElement)collection2;
                    boolean bl9 = false;
                    PsiElement psiElement2 = psiElement.getNavigationElement();
                    if (psiElement2 != null ? psiElement2.isWritable() : false) continue;
                    bl2 = false;
                    break block5;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl2;
        block16: {
            String string;
            Object object;
            Object object2;
            if (this == other) {
                return true;
            }
            Object object3 = other;
            if (!Intrinsics.areEqual(this.getClass(), object3 != null ? object3.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget");
            UrlPathReferenceUnifiedPomTarget cfr_ignored_0 = (UrlPathReferenceUnifiedPomTarget)other;
            Set set = this.context.getResolveRequests();
            Iterable<Object> iterable = new LinkedHashSet();
            boolean bl3 = false;
            Set set2 = set;
            boolean bl4 = false;
            Iterator<UrlResolveRequest> iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string2;
                object = object2 = iterator.next();
                boolean bl5 = false;
                UrlResolveRequest urlResolveRequest = object;
                boolean bl6 = false;
                if (urlResolveRequest.getSchemeHint() != null) {
                    String string3;
                    string = string3;
                    boolean bl7 = false;
                    string2 = !StringsKt.isBlank((CharSequence)string) ? string3 : null;
                } else {
                    string2 = null;
                }
                if (string2 == null) continue;
                String string4 = string2;
                boolean bl8 = false;
                iterable.add(string4);
            }
            Set set3 = (Set)iterable;
            iterable = ((UrlPathReferenceUnifiedPomTarget)other).context.getResolveRequests();
            Collection collection = new LinkedHashSet();
            boolean bl9 = false;
            Object object42 = iterable;
            boolean bl10 = false;
            object2 = object42.iterator();
            while (object2.hasNext()) {
                String string5;
                object = object2.next();
                UrlResolveRequest urlResolveRequest = object;
                boolean bl11 = false;
                UrlResolveRequest urlResolveRequest2 = urlResolveRequest;
                boolean bl12 = false;
                if (urlResolveRequest2.getSchemeHint() != null) {
                    String string6 = string;
                    boolean bl13 = false;
                    string5 = !StringsKt.isBlank((CharSequence)string6) ? string : null;
                } else {
                    string5 = null;
                }
                if (string5 == null) continue;
                String string7 = string5;
                boolean bl14 = false;
                collection.add(string7);
            }
            set = (Set)collection;
            if (!UrlPathModelKt.compatibleSchemes(set3, set)) {
                return false;
            }
            iterable = this.getPathValues();
            boolean bl15 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl2 = false;
            } else {
                for (Object object42 : iterable) {
                    boolean bl16;
                    block15: {
                        UrlPath urlPath = (UrlPath)object42;
                        boolean bl17 = false;
                        object = ((UrlPathReferenceUnifiedPomTarget)other).getPathValues();
                        boolean bl18 = false;
                        if (object instanceof Collection && ((Collection)object).isEmpty()) {
                            bl16 = false;
                        } else {
                            Iterator iterator2 = object.iterator();
                            while (iterator2.hasNext()) {
                                Object t2 = iterator2.next();
                                UrlPath urlPath2 = (UrlPath)t2;
                                boolean bl19 = false;
                                if (!urlPath.isCompatibleWith(urlPath2)) continue;
                                bl16 = true;
                                break block15;
                            }
                            bl16 = false;
                        }
                    }
                    if (!bl16) continue;
                    bl2 = true;
                    break block16;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    public int hashCode() {
        return ((Object)this.context.getSelfPaths()).hashCode();
    }

    @NotNull
    public String toString() {
        return "URLPathReferenceUnifiedPomTarget(" + this.context.getResolveRequests() + ")";
    }

    @JvmStatic
    @Nullable
    public static final UrlPathReferenceUnifiedPomTarget getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
        return Companion.getFromPomTargetPsiElement(psiElement);
    }

    public static final /* synthetic */ UrlResolverManager access$getUrlResolver$p(UrlPathReferenceUnifiedPomTarget $this) {
        return $this.urlResolver;
    }

    public static final /* synthetic */ boolean access$isAtEnd$p(UrlPathReferenceUnifiedPomTarget $this) {
        return $this.isAtEnd;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget$Companion;", "", "()V", "getFromPomTargetPsiElement", "Lcom/intellij/microservices/url/references/UrlPathReferenceUnifiedPomTarget;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final UrlPathReferenceUnifiedPomTarget getFromPomTargetPsiElement(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            PomTargetPsiElement pomTargetPsiElement = psiElement instanceof PomTargetPsiElement ? (PomTargetPsiElement)psiElement : null;
            PomTarget pomTarget = pomTargetPsiElement != null ? pomTargetPsiElement.getTarget() : null;
            return pomTarget instanceof UrlPathReferenceUnifiedPomTarget ? (UrlPathReferenceUnifiedPomTarget)pomTarget : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

