/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea.cloudConfig;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cloudconfig.ETagStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class ETagStorageImpl
implements ETagStorage {
    private static final Logger LOG = Logger.getInstance(ETagStorageImpl.class);
    private final Path myFile = PathManager.getConfigDir().resolve("jba_config/caches/tags");
    private final Map<String, String> myTags = new HashMap<String, String>();

    public ETagStorageImpl() {
        try {
            Iterator<String> iterator = Files.readAllLines(this.myFile).iterator();
            while (iterator.hasNext()) {
                this.myTags.put(iterator.next(), iterator.next());
            }
        }
        catch (NoSuchFileException | NoSuchElementException exception) {
        }
        catch (IOException iOException) {
            LOG.error((Throwable)iOException);
        }
    }

    public void clear() {
        PathKt.delete((Path)this.myFile);
        this.myTags.clear();
    }

    public String get(String file2) {
        return this.myTags.get(file2);
    }

    public void store(String file2, String tag) {
        this.myTags.put(file2, tag);
        try {
            FileUtil.writeToFile((File)this.myFile.toFile(), (String)StringUtil.join(this.myTags.entrySet(), entry -> (String)entry.getKey() + "\n" + (String)entry.getValue(), (String)"\n"));
        }
        catch (IOException iOException) {
            LOG.error((Throwable)iOException);
        }
    }

    public void remove(String path) {
        this.myTags.remove(path);
    }
}

