/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEditorAnnotatorImpl;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.util.Function;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEngine {
    public static final ExtensionPointName<CoverageEngine> EP_NAME = ExtensionPointName.create((String)"com.intellij.coverageEngine");

    @NlsActions.ActionText
    public abstract String getPresentableText();

    public abstract boolean isApplicableTo(@NotNull RunConfigurationBase<?> var1);

    @NotNull
    public abstract CoverageEnabledConfiguration createCoverageEnabledConfiguration(@NotNull RunConfigurationBase<?> var1);

    @Nullable
    public final CoverageSuite createCoverageSuite(@NotNull String name, @NotNull Project project, @NotNull CoverageRunner runner, @NotNull CoverageFileProvider fileProvider, long timestamp) {
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(1);
        }
        if (runner == null) {
            CoverageEngine.$$$reportNull$$$0(2);
        }
        if (fileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(3);
        }
        return this.createCoverageSuite(runner, name, fileProvider, null, timestamp, null, false, false, false, project);
    }

    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageEnabledConfiguration config) {
        CoverageRunner runner;
        if (config == null) {
            CoverageEngine.$$$reportNull$$$0(4);
        }
        if ((runner = config.getCoverageRunner()) == null) {
            return null;
        }
        return this.createCoverageSuite(runner, config.createSuiteName(), config.createFileProvider(), config);
    }

    @Deprecated
    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, String @Nullable [] var4, long var5, @Nullable String var7, boolean var8, boolean var9, boolean var10, Project var11);

    @Deprecated
    @Nullable
    public abstract CoverageSuite createCoverageSuite(@NotNull CoverageRunner var1, @NotNull String var2, @NotNull CoverageFileProvider var3, @NotNull CoverageEnabledConfiguration var4);

    @Nullable
    public abstract CoverageSuite createEmptyCoverageSuite(@NotNull CoverageRunner var1);

    @NotNull
    public abstract CoverageAnnotator getCoverageAnnotator(Project var1);

    public boolean coverageEditorHighlightingApplicableTo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(5);
        }
        return true;
    }

    public boolean acceptedByFilters(@NotNull PsiFile psiFile, @NotNull CoverageSuitesBundle suite2) {
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(6);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(7);
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public Set<File> getCorrespondingOutputFiles(@NotNull PsiFile srcFile, @Nullable Module module, @NotNull CoverageSuitesBundle suite2) {
        VirtualFile virtualFile;
        if (srcFile == null) {
            CoverageEngine.$$$reportNull$$$0(8);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(9);
        }
        Set<File> set = (virtualFile = srcFile.getVirtualFile()) == null ? Collections.emptySet() : Collections.singleton(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile));
        if (set == null) {
            CoverageEngine.$$$reportNull$$$0(10);
        }
        return set;
    }

    @ApiStatus.Internal
    public boolean recompileProjectAndRerunAction(@NotNull Module module, @NotNull CoverageSuitesBundle suite2, @NotNull Runnable chooseSuiteAction) {
        if (module == null) {
            CoverageEngine.$$$reportNull$$$0(11);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(12);
        }
        if (chooseSuiteAction == null) {
            CoverageEngine.$$$reportNull$$$0(13);
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected String getQualifiedName(@NotNull File outputFile, @NotNull PsiFile sourceFile) {
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(14);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    public Set<String> getQualifiedNames(@NotNull PsiFile sourceFile) {
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(16);
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            CoverageEngine.$$$reportNull$$$0(17);
        }
        return set;
    }

    @ApiStatus.Internal
    public boolean includeUntouchedFileInCoverage(@NotNull String qualifiedName, @NotNull File outputFile, @NotNull PsiFile sourceFile, @NotNull CoverageSuitesBundle suite2) {
        if (qualifiedName == null) {
            CoverageEngine.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            CoverageEngine.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            CoverageEngine.$$$reportNull$$$0(20);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(21);
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public List<Integer> collectSrcLinesForUntouchedFile(@NotNull File classFile, @NotNull CoverageSuitesBundle suite2) {
        if (classFile == null) {
            CoverageEngine.$$$reportNull$$$0(22);
        }
        if (suite2 == null) {
            CoverageEngine.$$$reportNull$$$0(23);
        }
        return null;
    }

    @ApiStatus.Internal
    public String generateBriefReport(@NotNull Editor editor, @NotNull PsiFile psiFile, int lineNumber, int startOffset, int endOffset, @Nullable LineData lineData) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(24);
        }
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(25);
        }
        int hits = lineData == null ? 0 : lineData.getHits();
        return CoverageBundle.message("hits.title", hits);
    }

    @ApiStatus.Internal
    public String generateBriefReport(@NotNull CoverageSuitesBundle bundle, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull TextRange range, @Nullable LineData lineData) {
        if (bundle == null) {
            CoverageEngine.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(27);
        }
        if (psiFile == null) {
            CoverageEngine.$$$reportNull$$$0(28);
        }
        if (range == null) {
            CoverageEngine.$$$reportNull$$$0(29);
        }
        int lineNumber = editor.getDocument().getLineNumber(range.getStartOffset());
        return this.generateBriefReport(editor, psiFile, lineNumber, range.getStartOffset(), range.getEndOffset(), lineData);
    }

    public boolean isReportGenerationAvailable(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(30);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(31);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(32);
        }
        return false;
    }

    public void generateReport(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(33);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(34);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(35);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public ExportToHTMLDialog createGenerateReportDialog(@NotNull Project project, @NotNull DataContext dataContext, @NotNull CoverageSuitesBundle currentSuite) {
        String path;
        VirtualFile file;
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(36);
        }
        if (dataContext == null) {
            CoverageEngine.$$$reportNull$$$0(37);
        }
        if (currentSuite == null) {
            CoverageEngine.$$$reportNull$$$0(38);
        }
        ExportToHTMLDialog dialog = new ExportToHTMLDialog(project, true);
        dialog.setTitle(CoverageBundle.message("generate.coverage.report.for", currentSuite.getPresentableName()));
        ExportToHTMLSettings settings = ExportToHTMLSettings.getInstance((Project)project);
        if (StringUtil.isEmpty((String)settings.OUTPUT_DIRECTORY) && (file = ProjectUtil.guessProjectDir((Project)project)) != null && (path = file.getCanonicalPath()) != null) {
            settings.OUTPUT_DIRECTORY = FileUtil.toSystemDependentName((String)path) + File.separator + "htmlReport";
        }
        ExportToHTMLDialog exportToHTMLDialog = dialog;
        if (exportToHTMLDialog == null) {
            CoverageEngine.$$$reportNull$$$0(39);
        }
        return exportToHTMLDialog;
    }

    @ApiStatus.Internal
    public boolean coverageProjectViewStatisticsApplicableTo(VirtualFile fileOrDir) {
        return false;
    }

    @ApiStatus.Internal
    protected Object @NotNull [] postProcessExecutableLines(Object @NotNull [] lines, @NotNull Editor editor) {
        if (editor == null) {
            CoverageEngine.$$$reportNull$$$0(40);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(41);
        }
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(42);
        }
        return lines;
    }

    @ApiStatus.Internal
    public CoverageLineMarkerRenderer getLineMarkerRenderer(int lineNumber, @Nullable String className, @NotNull TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (lines == null) {
            CoverageEngine.$$$reportNull$$$0(43);
        }
        if (coverageSuite == null) {
            CoverageEngine.$$$reportNull$$$0(44);
        }
        return CoverageLineMarkerRenderer.getRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    @ApiStatus.Internal
    protected boolean isGeneratedCode(Project project, String qualifiedName, Object lineData) {
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public CoverageEditorAnnotator createSrcFileAnnotator(PsiFile file, Editor editor) {
        return new CoverageEditorAnnotatorImpl(file, editor);
    }

    @ApiStatus.Internal
    @NlsContexts.TabTitle
    public static String getEditorTitle() {
        return CoverageBundle.message("coverage.tab.title", new Object[0]);
    }

    @Deprecated
    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle, CoverageViewManager.StateBean stateBean) {
        return this.createCoverageViewExtension(project, suiteBundle);
    }

    public CoverageViewExtension createCoverageViewExtension(Project project, CoverageSuitesBundle suiteBundle) {
        return null;
    }

    public boolean isInLibraryClasses(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibraryClasses(file) && !projectFileIndex.isInSource(file));
    }

    @ApiStatus.Internal
    protected boolean isInLibrarySource(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return (Boolean)ReadAction.compute(() -> projectFileIndex.isInLibrarySource(file));
    }

    @ApiStatus.Internal
    public boolean canHavePerTestCoverage(@NotNull RunConfigurationBase<?> conf) {
        if (conf == null) {
            CoverageEngine.$$$reportNull$$$0(45);
        }
        return false;
    }

    @ApiStatus.Internal
    public Set<String> getTestsForLine(Project project, CoverageSuitesBundle bundle, String classFQName, int lineNumber) {
        return Collections.emptySet();
    }

    @ApiStatus.Internal
    public boolean wasTestDataCollected(Project project, CoverageSuitesBundle bundle) {
        return false;
    }

    @ApiStatus.Internal
    public List<PsiElement> findTestsByNames(String @NotNull [] testNames, @NotNull Project project) {
        if (project == null) {
            CoverageEngine.$$$reportNull$$$0(46);
        }
        if (testNames == null) {
            CoverageEngine.$$$reportNull$$$0(47);
        }
        return Collections.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public String getTestMethodName(@NotNull PsiElement element, @NotNull AbstractTestProxy testProxy) {
        if (element == null) {
            CoverageEngine.$$$reportNull$$$0(48);
        }
        if (testProxy == null) {
            CoverageEngine.$$$reportNull$$$0(49);
        }
        return null;
    }

    @ApiStatus.Internal
    public void collectTestLines(List<String> sanitizedTestNames, CoverageSuite suite2, Map<String, Set<Integer>> trace) {
    }

    @ApiStatus.Internal
    protected void deleteAssociatedTraces(CoverageSuite suite2) {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public CoverageSuite createCoverageSuite(@NotNull CoverageRunner covRunner, @NotNull String name, @NotNull CoverageFileProvider coverageDataFileProvider, String @Nullable [] filters, long lastCoverageTimeStamp, @Nullable String suiteToMerge, boolean coverageByTestEnabled, boolean branchCoverage, boolean bl) {
        void trackTestFolders;
        if (covRunner == null) {
            CoverageEngine.$$$reportNull$$$0(50);
        }
        if (name == null) {
            CoverageEngine.$$$reportNull$$$0(51);
        }
        if (coverageDataFileProvider == null) {
            CoverageEngine.$$$reportNull$$$0(52);
        }
        return this.createCoverageSuite(covRunner, name, coverageDataFileProvider, filters, lastCoverageTimeStamp, suiteToMerge, coverageByTestEnabled, branchCoverage, (boolean)trackTestFolders, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 17, 39, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 30: 
            case 33: 
            case 36: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 10: 
            case 17: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooseSuiteAction";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFile";
                break;
            }
            case 24: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testNames";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testProxy";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "covRunner";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageDataFileProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageEngine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrespondingOutputFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerateReportDialog";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessExecutableLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCoverageSuite";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "coverageEditorHighlightingApplicableTo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptedByFilters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCorrespondingOutputFiles";
                break;
            }
            case 10: 
            case 17: 
            case 39: 
            case 42: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "recompileProjectAndRerunAction";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNames";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "includeUntouchedFileInCoverage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectSrcLinesForUntouchedFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateBriefReport";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isReportGenerationAvailable";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateReport";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createGenerateReportDialog";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "postProcessExecutableLines";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerRenderer";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "canHavePerTestCoverage";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findTestsByNames";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 17, 39, 42 -> new IllegalStateException(string);
        };
    }
}

