/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.api.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.data.GitLabAccessLevel;
import org.jetbrains.plugins.gitlab.api.dto.GitLabMemberDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMemberDTODeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMemberDTO;", "()V", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "parseAccessLevel", "Lorg/jetbrains/plugins/gitlab/api/data/GitLabAccessLevel;", "accessLevel", "", "Companion", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMemberDTO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMemberDTO.kt\norg/jetbrains/plugins/gitlab/api/dto/GitLabMemberDTODeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n1#2:51\n13#3:52\n*S KotlinDebug\n*F\n+ 1 GitLabMemberDTO.kt\norg/jetbrains/plugins/gitlab/api/dto/GitLabMemberDTODeserializer\n*L\n48#1:52\n*E\n"})
public final class GitLabMemberDTODeserializer
extends StdDeserializer<GitLabMemberDTO> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public GitLabMemberDTODeserializer() {
        super(GitLabMemberDTO.class);
    }

    @Nullable
    public GitLabMemberDTO deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext context) {
        GitLabMemberDTO gitLabMemberDTO;
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ObjectCodec codec = jsonParser.getCodec();
        TreeNode treeNode = codec.readTree(jsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
        JsonNode node = (JsonNode)treeNode;
        if (node.isEmpty()) {
            gitLabMemberDTO = null;
        } else {
            String string = node.get("id").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            String id = string;
            Object object = codec.treeToValue((TreeNode)node.get("user"), GitLabUserDTO.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"treeToValue(...)");
            GitLabUserDTO user2 = (GitLabUserDTO)object;
            String p0 = node.get("accessLevel").get("stringValue").asText();
            boolean bl = false;
            GitLabAccessLevel accessLevel = this.parseAccessLevel(p0);
            gitLabMemberDTO = new GitLabMemberDTO(id, user2, accessLevel);
        }
        return gitLabMemberDTO;
    }

    private final GitLabAccessLevel parseAccessLevel(String accessLevel) {
        GitLabAccessLevel gitLabAccessLevel;
        try {
            gitLabAccessLevel = GitLabAccessLevel.valueOf(accessLevel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.error("Unable to parse access level");
            gitLabAccessLevel = GitLabAccessLevel.NO_ACCESS;
        }
        return gitLabAccessLevel;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitLabMemberDTO.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMemberDTODeserializer$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

