/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.GlobalVariablesHolder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import java.awt.Component;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/console/JavaScriptDebuggerConsoleExecuteActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "getConsolePrinter", "()Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "globalVariables", "Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "getGlobalVariables", "()Lcom/intellij/javascript/debugger/GlobalVariablesHolder;", "globalVariables$delegate", "Lkotlin/Lazy;", "localVariables", "Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "getLocalVariables", "()Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "vmSupplier", "Lkotlin/Function0;", "Lorg/jetbrains/debugger/Vm;", "execute", "", "text", "", "console", "Lcom/intellij/execution/console/LanguageConsoleView;", "isEmptyCommandExecutionAllowed", "", "runExecuteAction", "consoleView", "Companion", "intellij.javascript.debugger"})
public final class JavaScriptDebuggerConsoleExecuteActionHandler
extends BaseConsoleExecuteActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final Function0<Vm> vmSupplier;
    @NotNull
    private final LocalVariablesHolder localVariables;
    @NotNull
    private final Lazy globalVariables$delegate;
    @NotNull
    private static final Key<Object> STRING_KEY = new Key("JS_DEBUG_STRING");
    @NotNull
    private static final Key<Object> NUMBER_KEY = new Key("JS_DEBUG_NUMBER");
    @NotNull
    private static final Key<Object> KEYWORD_KEY = new Key("JS_DEBUG_KEYWORD");

    public JavaScriptDebuggerConsoleExecuteActionHandler(final @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull CoroutineScope coroutineScope, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        super(true);
        this.coroutineScope = coroutineScope;
        this.consolePrinter = consolePrinter;
        this.vmSupplier = (Function0)new PropertyReference0Impl(debugProcess.getConnection()){

            @Nullable
            public Object get() {
                return ((VmConnection)this.receiver).getVm();
            }
        };
        this.localVariables = new LocalVariablesHolder(() -> JavaScriptDebuggerConsoleExecuteActionHandler.localVariables$lambda$0(this.vmSupplier));
        this.globalVariables$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GlobalVariablesHolder>(this){
            final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GlobalVariablesHolder invoke() {
                GlobalVariablesHolder holder = new GlobalVariablesHolder(() -> globalVariables.2.invoke$lambda$0(JavaScriptDebuggerConsoleExecuteActionHandler.access$getVmSupplier$p(this.this$0)));
                holder.update();
                return holder;
            }

            private static final Vm invoke$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Vm)$tmp0.invoke();
            }
        }));
        debugProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void stackFrameChanged() {
                this.updateConsoleContext();
            }

            private final void updateConsoleContext() {
                this.getLocalVariables().setCallFrame(null);
                XDebugSession session2 = debugProcess.getSession();
                ConsoleView consoleView = debugProcess.getJSConsoleView(false);
                LanguageConsoleView languageConsoleView = consoleView instanceof LanguageConsoleView ? (LanguageConsoleView)consoleView : null;
                if (languageConsoleView == null) {
                    return;
                }
                LanguageConsoleView consoleView2 = languageConsoleView;
                XSourcePosition position = session2.getCurrentPosition();
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(session2, consoleView2, position){
                    final /* synthetic */ XDebugSession $session;
                    final /* synthetic */ LanguageConsoleView $consoleView;
                    final /* synthetic */ XSourcePosition $position;
                    {
                        this.$session = $session;
                        this.$consoleView = $consoleView;
                        this.$position = $position;
                        super(0);
                    }

                    public final void invoke() {
                        if (this.$session.getProject().isDisposed()) {
                            return;
                        }
                        PsiFile psiFile = this.$consoleView.getFile();
                        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl");
                        JSExpressionCodeFragmentImpl consolePsiFile = (JSExpressionCodeFragmentImpl)psiFile;
                        if (this.$position == null || this.$position.getOffset() < 0) {
                            consolePsiFile.setContext(null);
                        } else {
                            PsiFile contextPsiFile;
                            PsiFile psiFile2 = contextPsiFile = PsiManager.getInstance((Project)this.$session.getProject()).findFile(this.$position.getFile());
                            PsiElement context = psiFile2 != null ? psiFile2.findElementAt(this.$position.getOffset()) : null;
                            consolePsiFile.setContext(context);
                        }
                    }
                }));
            }

            public void sessionStopped() {
                this.updateConsoleContext();
            }

            public void sessionResumed() {
                this.updateConsoleContext();
            }

            public void sessionPaused() {
                this.updateConsoleContext();
            }
        });
    }

    @NotNull
    public final ConsolePrinter getConsolePrinter() {
        return this.consolePrinter;
    }

    @NotNull
    public final LocalVariablesHolder getLocalVariables() {
        return this.localVariables;
    }

    @NotNull
    public final GlobalVariablesHolder getGlobalVariables() {
        Lazy lazy = this.globalVariables$delegate;
        return (GlobalVariablesHolder)lazy.getValue();
    }

    public boolean isEmptyCommandExecutionAllowed() {
        return false;
    }

    public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        if (!(consoleView instanceof WebConsoleView)) {
            super.runExecuteAction(consoleView);
            return;
        }
        this.beforeExecution(consoleView);
        String text = WebConsoleView.printInputFromExecutionEditor$default((WebConsoleView)consoleView, false, false, 3, null);
        UndoManager undoManager = UndoManager.getInstance((Project)consoleView.getProject());
        Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        ((UndoManagerImpl)undoManager).invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)consoleView.getCurrentEditor().getDocument()));
        ConsoleHistoryController.addToHistory((LanguageConsoleView)consoleView, (String)text);
        this.execute(text, consoleView);
    }

    public void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)console.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        XDebugSession xDebugSession = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext2);
        if (xDebugSession == null) {
            return;
        }
        XDebugSession session2 = xDebugSession;
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<*>");
        JavaScriptDebugProcess debugProcess = (JavaScriptDebugProcess)xDebugProcess;
        XStackFrame xStackFrame = session2.getCurrentStackFrame();
        CallFrameView currentCallFrame = xStackFrame instanceof CallFrameView ? (CallFrameView)xStackFrame : null;
        Vm vm = debugProcess.getActiveOrMainVm();
        Intrinsics.checkNotNull((Object)vm);
        Vm vm2 = vm;
        if (console instanceof WebConsoleView) {
            XDebuggerEvaluator.XEvaluationCallback callback2 = new XDebuggerEvaluator.XEvaluationCallback(this, vm2, currentCallFrame, session2, debugProcess){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ Vm $vm;
                final /* synthetic */ CallFrameView $currentCallFrame;
                final /* synthetic */ XDebugSession $session;
                final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                {
                    this.this$0 = $receiver;
                    this.$vm = $vm;
                    this.$currentCallFrame = $currentCallFrame;
                    this.$session = $session;
                    this.$debugProcess = $debugProcess;
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, errorMessage, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ String $errorMessage;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$errorMessage = $errorMessage;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function1<? super ConsoleMessageBuilder, Unit>)((Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$errorMessage){
                                        final /* synthetic */ String $errorMessage;
                                        {
                                            this.$errorMessage = $errorMessage;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                            Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                            JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$errorHandler($this$submitMessage, this.$errorMessage);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }

                public void evaluated(@NotNull XValue result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, result, this.$currentCallFrame, this.$session, this.$debugProcess, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ XValue $result;
                        final /* synthetic */ CallFrameView $currentCallFrame;
                        final /* synthetic */ XDebugSession $session;
                        final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$result = $result;
                            this.$currentCallFrame = $currentCallFrame;
                            this.$session = $session;
                            this.$debugProcess = $debugProcess;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function1<? super ConsoleMessageBuilder, Unit>)((Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$result, this.this$0, this.$currentCallFrame, this.$session, this.$debugProcess){
                                        final /* synthetic */ XValue $result;
                                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                                        final /* synthetic */ CallFrameView $currentCallFrame;
                                        final /* synthetic */ XDebugSession $session;
                                        final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                                        {
                                            this.$result = $result;
                                            this.this$0 = $receiver;
                                            this.$currentCallFrame = $currentCallFrame;
                                            this.$session = $session;
                                            this.$debugProcess = $debugProcess;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                            Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                            JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$successHandler($this$submitMessage, this.this$0, this.$currentCallFrame, this.$session, this.$debugProcess);
                                            ConsoleMessageBuilder.printValue$default($this$submitMessage, this.$result, false, 2, null);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            };
            XDebuggerEvaluator xDebuggerEvaluator = debugProcess.getEvaluator();
            Intrinsics.checkNotNull((Object)xDebuggerEvaluator);
            xDebuggerEvaluator.evaluate(text, callback2, null);
        } else {
            CallFrameView callFrameView = currentCallFrame;
            if (callFrameView == null || (callFrameView = callFrameView.getEvaluateContext()) == null) {
                EvaluateContext evaluateContext = vm2.getEvaluateContext();
                callFrameView = evaluateContext;
                Intrinsics.checkNotNull((Object)evaluateContext);
            }
            EvaluateContext.evaluate$default((EvaluateContext)callFrameView, (String)text, null, (boolean)true, (Project)session2.getProject(), (int)2, null).onSuccess(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$2((Function1)new Function1<EvaluateResult, Unit>(this, vm2, debugProcess, text, console, currentCallFrame, session2){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ Vm $vm;
                final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                final /* synthetic */ String $text;
                final /* synthetic */ LanguageConsoleView $console;
                final /* synthetic */ CallFrameView $currentCallFrame;
                final /* synthetic */ XDebugSession $session;
                {
                    this.this$0 = $receiver;
                    this.$vm = $vm;
                    this.$debugProcess = $debugProcess;
                    this.$text = $text;
                    this.$console = $console;
                    this.$currentCallFrame = $currentCallFrame;
                    this.$session = $session;
                    super(1);
                }

                public final void invoke(EvaluateResult it) {
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, it, this.$debugProcess, this.$text, this.$console, this.$currentCallFrame, this.$session, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ EvaluateResult $it;
                        final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                        final /* synthetic */ String $text;
                        final /* synthetic */ LanguageConsoleView $console;
                        final /* synthetic */ CallFrameView $currentCallFrame;
                        final /* synthetic */ XDebugSession $session;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$it = $it;
                            this.$debugProcess = $debugProcess;
                            this.$text = $text;
                            this.$console = $console;
                            this.$currentCallFrame = $currentCallFrame;
                            this.$session = $session;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function1<? super ConsoleMessageBuilder, Unit>)((Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$it, this.$debugProcess, this.$text, this.$console, this.this$0, this.$currentCallFrame, this.$session){
                                        final /* synthetic */ EvaluateResult $it;
                                        final /* synthetic */ JavaScriptDebugProcess<?> $debugProcess;
                                        final /* synthetic */ String $text;
                                        final /* synthetic */ LanguageConsoleView $console;
                                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                                        final /* synthetic */ CallFrameView $currentCallFrame;
                                        final /* synthetic */ XDebugSession $session;
                                        {
                                            this.$it = $it;
                                            this.$debugProcess = $debugProcess;
                                            this.$text = $text;
                                            this.$console = $console;
                                            this.this$0 = $receiver;
                                            this.$currentCallFrame = $currentCallFrame;
                                            this.$session = $session;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                            Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                            if (this.$it.getWasThrown()) {
                                                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
                                                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
                                                ConsoleMessageBuilder.append$default($this$submitMessage, "\u200c", consoleViewContentType, null, 4, null);
                                                GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                                                Value value = this.$it.getValue();
                                                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
                                                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ERROR_OUTPUT");
                                                globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType2, (ConsoleView)this.$console);
                                                ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.ERROR_OUTPUT;
                                                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"ERROR_OUTPUT");
                                                ConsoleMessageBuilder.append$default($this$submitMessage, "\n", consoleViewContentType3, null, 4, null);
                                                return;
                                            }
                                            JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$successHandler($this$submitMessage, this.this$0, this.$currentCallFrame, this.$session, this.$debugProcess);
                                            GlobalEvaluator globalEvaluator = this.$debugProcess.getGlobalEvaluator();
                                            Value value = this.$it.getValue();
                                            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(JavaScriptDebuggerConsoleExecuteActionHandler.Companion.getValueKey(this.$it.getValue()));
                                            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
                                            globalEvaluator.printAndStoreValueToInspect(value, this.$text, consoleViewContentType, (ConsoleView)this.$console);
                                            ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.NORMAL_OUTPUT;
                                            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"NORMAL_OUTPUT");
                                            ConsoleMessageBuilder.append$default($this$submitMessage, "\n", consoleViewContentType4, null, 4, null);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }, arg_0)).onError(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$lambda$3((Function1)new Function1<Throwable, Unit>(this, vm2){
                final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                final /* synthetic */ Vm $vm;
                {
                    this.this$0 = $receiver;
                    this.$vm = $vm;
                    super(1);
                }

                public final void invoke(Throwable it) {
                    BuildersKt.launch$default((CoroutineScope)JavaScriptDebuggerConsoleExecuteActionHandler.access$getCoroutineScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$vm, it, null){
                        int label;
                        final /* synthetic */ JavaScriptDebuggerConsoleExecuteActionHandler this$0;
                        final /* synthetic */ Vm $vm;
                        final /* synthetic */ Throwable $it;
                        {
                            this.this$0 = $receiver;
                            this.$vm = $vm;
                            this.$it = $it;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.getConsolePrinter().submitMessage(this.$vm, true, (Function1<? super ConsoleMessageBuilder, Unit>)((Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$it){
                                        final /* synthetic */ Throwable $it;
                                        {
                                            this.$it = $it;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                            Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                            String string = this.$it.getMessage();
                                            Intrinsics.checkNotNull((Object)string);
                                            JavaScriptDebuggerConsoleExecuteActionHandler.access$execute$errorHandler($this$submitMessage, string);
                                        }
                                    }), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }, arg_0));
        }
    }

    private static final Vm localVariables$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Vm)$tmp0.invoke();
    }

    private static final void execute$successHandler$lambda$1(JavaScriptDebuggerConsoleExecuteActionHandler this$0, JavaScriptDebugProcess $debugProcess, Object it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
        this$0.localVariables.update();
        $debugProcess.getSession().rebuildViews();
    }

    private static final void execute$successHandler(ConsoleMessageBuilder $this$execute_u24successHandler, JavaScriptDebuggerConsoleExecuteActionHandler this$0, CallFrameView currentCallFrame, XDebugSession session2, JavaScriptDebugProcess<?> debugProcess) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        ConsoleMessageBuilder.startMessage$default($this$execute_u24successHandler, consoleViewContentType, MessageType.EVAL_OUT, null, 4, null);
        ConsoleMessageBuilder.append$default($this$execute_u24successHandler, "\u200c", null, null, 6, null);
        this$0.getGlobalVariables().update();
        boolean rebuildViewsRequested = false;
        if (Intrinsics.areEqual((Object)currentCallFrame, (Object)session2.getCurrentStackFrame()) && currentCallFrame != null) {
            CallFrame callFrame = currentCallFrame.getCallFrame();
            this$0.localVariables.setCallFrame(callFrame);
            Scope localScope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(callFrame);
            if (localScope != null) {
                rebuildViewsRequested = true;
                localScope.getVariablesHost().clearCaches().onSuccess(arg_0 -> JavaScriptDebuggerConsoleExecuteActionHandler.execute$successHandler$lambda$1(this$0, debugProcess, arg_0)).onError((Consumer)new RejectErrorReporter(session2, null, 2, null));
            }
        }
        if (!rebuildViewsRequested) {
            debugProcess.getSession().rebuildViews();
        }
    }

    private static final void execute$errorHandler(ConsoleMessageBuilder $this$execute_u24errorHandler, String errorMessage) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.startMessage$default($this$execute_u24errorHandler, consoleViewContentType, MessageType.EVAL_OUT, null, 4, null);
        ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, "\u200c", consoleViewContentType2, null, 4, null);
        ConsoleViewContentType consoleViewContentType3 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType3, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, errorMessage, consoleViewContentType3, null, 4, null);
        ConsoleViewContentType consoleViewContentType4 = ConsoleViewContentType.ERROR_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType4, (String)"ERROR_OUTPUT");
        ConsoleMessageBuilder.append$default($this$execute_u24errorHandler, "\n", consoleViewContentType4, null, 4, null);
    }

    private static final void execute$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void execute$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(JavaScriptDebuggerConsoleExecuteActionHandler $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ void access$execute$errorHandler(ConsoleMessageBuilder $receiver, String errorMessage) {
        JavaScriptDebuggerConsoleExecuteActionHandler.execute$errorHandler($receiver, errorMessage);
    }

    public static final /* synthetic */ void access$execute$successHandler(ConsoleMessageBuilder $receiver, JavaScriptDebuggerConsoleExecuteActionHandler this$0, CallFrameView currentCallFrame, XDebugSession session2, JavaScriptDebugProcess debugProcess) {
        JavaScriptDebuggerConsoleExecuteActionHandler.execute$successHandler($receiver, this$0, currentCallFrame, session2, debugProcess);
    }

    public static final /* synthetic */ Function0 access$getVmSupplier$p(JavaScriptDebuggerConsoleExecuteActionHandler $this) {
        return $this.vmSupplier;
    }

    static {
        ConsoleViewContentType.registerNewConsoleViewType(NUMBER_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        ConsoleViewContentType.registerNewConsoleViewType(STRING_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ConsoleViewContentType.registerNewConsoleViewType(KEYWORD_KEY, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u001e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001 \u000b*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00040\u00042\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/console/JavaScriptDebuggerConsoleExecuteActionHandler$Companion;", "", "()V", "KEYWORD_KEY", "Lcom/intellij/openapi/util/Key;", "getKEYWORD_KEY", "()Lcom/intellij/openapi/util/Key;", "NUMBER_KEY", "getNUMBER_KEY", "STRING_KEY", "getValueKey", "kotlin.jvm.PlatformType", "value", "Lorg/jetbrains/debugger/values/Value;", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Object> getNUMBER_KEY() {
            return NUMBER_KEY;
        }

        @NotNull
        public final Key<Object> getKEYWORD_KEY() {
            return KEYWORD_KEY;
        }

        public final Key<? extends Object> getValueKey(@NotNull Value value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1, 2 -> this.getNUMBER_KEY();
                case 3 -> STRING_KEY;
                case 4, 5, 6, 7 -> this.getKEYWORD_KEY();
                default -> ProcessOutputTypes.STDOUT;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ValueType.values().length];
                try {
                    nArray[ValueType.NUMBER.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.BIGINT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.STRING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.BOOLEAN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.UNDEFINED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.NULL.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ValueType.SYMBOL.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

