/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.export;

import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.fileActions.MarkdownFileActionsBaseDialog;
import org.intellij.plugins.markdown.fileActions.export.MarkdownExportProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0014J\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0019H\u0014J\f\u0010\u001a\u001a\u00020\u0012*\u00020\u0019H\u0014J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;", "Lorg/intellij/plugins/markdown/fileActions/MarkdownFileActionsBaseDialog;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestedFilePath", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "fileTypeSelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "selectedFileType", "supportedExportProviders", "", "getSupportedExportProviders", "()Ljava/util/List;", "doAction", "", "selectedFileUrl", "findFirstValidProvider", "getFileNameIfExist", "dir", "fileNameWithoutExtension", "createFileTypeField", "Lcom/intellij/ui/dsl/builder/Panel;", "createSettingsComponents", "validateFileType", "Lcom/intellij/openapi/ui/ValidationInfo;", "Lcom/intellij/ui/layout/ValidationInfoBuilder;", "combobox", "FileTypeRenderer", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownExportDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownExportDialog.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1#2:113\n1#2:124\n1603#3,9:114\n1855#3:123\n1856#3:125\n1612#3:126\n*S KotlinDebug\n*F\n+ 1 MarkdownExportDialog.kt\norg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog\n*L\n70#1:124\n70#1:114,9\n70#1:123\n70#1:125\n70#1:126\n*E\n"})
public final class MarkdownExportDialog
extends MarkdownFileActionsBaseDialog {
    private ComboBox<MarkdownExportProvider> fileTypeSelector;
    private MarkdownExportProvider selectedFileType;

    public MarkdownExportDialog(@NotNull VirtualFile targetFile, @NotNull String suggestedFilePath2, @NotNull Project project) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)suggestedFilePath2, (String)"suggestedFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, suggestedFilePath2, targetFile);
        this.setTitle(MarkdownBundle.message("markdown.export.from.docx.dialog.title", new Object[0]));
        this.setOKButtonText(MarkdownBundle.message("markdown.export.dialog.ok.button", new Object[0]));
        Action action = this.getOKAction();
        MarkdownExportProvider markdownExportProvider = this.selectedFileType;
        if (markdownExportProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
            markdownExportProvider = null;
        }
        action.setEnabled((charSequence = (CharSequence)markdownExportProvider.validate(project, targetFile)) == null || charSequence.length() == 0);
    }

    private final List<MarkdownExportProvider> getSupportedExportProviders() {
        return MarkdownExportProvider.Companion.getAllProviders();
    }

    @Override
    protected void doAction(@NotNull String selectedFileUrl) {
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)selectedFileUrl, (String)"selectedFileUrl");
            Iterable iterable = this.getSupportedExportProviders();
            for (Object t : iterable) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                MarkdownExportProvider markdownExportProvider = this.selectedFileType;
                if (markdownExportProvider == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
                    markdownExportProvider = null;
                }
                if (!Intrinsics.areEqual((Object)it, (Object)markdownExportProvider)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        MarkdownExportProvider markdownExportProvider = v1;
        if (markdownExportProvider == null) {
            return;
        }
        MarkdownExportProvider provider = markdownExportProvider;
        String outputFile = selectedFileUrl + "." + provider.getFormatDescription().getExtension();
        provider.exportFile(this.getProject(), this.getFile(), outputFile);
    }

    @Override
    @Nullable
    protected String getFileNameIfExist(@NotNull String dir, @NotNull String fileNameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutExtension, (String)"fileNameWithoutExtension");
        ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
            comboBox = null;
        }
        String fullName = fileNameWithoutExtension + "." + ((MarkdownExportProvider)comboBox.getItem()).getFormatDescription().getExtension();
        String[] stringArray = new String[]{dir, fullName};
        return FileUtil.exists((String)FileUtil.join((String[])stringArray)) ? fullName : null;
    }

    @Override
    protected void createFileTypeField(@NotNull Panel $this$createFileTypeField) {
        Intrinsics.checkNotNullParameter((Object)$this$createFileTypeField, (String)"<this>");
        Panel.row$default((Panel)$this$createFileTypeField, null, (Function1)((Function1)new Function1<Row, Unit>(this){
            final /* synthetic */ MarkdownExportDialog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                GraphProperty fileTypeProperty2 = new PropertyGraph(null, false, 3, null).lazyProperty((Function0)new Function0<MarkdownExportProvider>(this.this$0){
                    final /* synthetic */ MarkdownExportDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final MarkdownExportProvider invoke() {
                        MarkdownExportProvider markdownExportProvider = MarkdownExportDialog.access$getSelectedFileType$p(this.this$0);
                        if (markdownExportProvider == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"selectedFileType");
                            markdownExportProvider = null;
                        }
                        return markdownExportProvider;
                    }
                });
                fileTypeProperty2.afterChange((Function1)new Function1<MarkdownExportProvider, Unit>(this.this$0){
                    final /* synthetic */ MarkdownExportDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull MarkdownExportProvider it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        MarkdownExportDialog.access$setSelectedFileType$p(this.this$0, it);
                        CharSequence charSequence = it.validate(MarkdownExportDialog.access$getProject(this.this$0), MarkdownExportDialog.access$getFile(this.this$0));
                        MarkdownExportDialog.access$getOKAction(this.this$0).setEnabled(charSequence == null || charSequence.length() == 0);
                    }
                });
                MarkdownExportProvider markdownExportProvider = MarkdownExportDialog.access$findFirstValidProvider(this.this$0);
                if (markdownExportProvider == null) {
                    markdownExportProvider = (MarkdownExportProvider)CollectionsKt.first((List)MarkdownExportDialog.access$getSupportedExportProviders(this.this$0));
                }
                MarkdownExportDialog.access$setSelectedFileType$p(this.this$0, markdownExportProvider);
                String string = MarkdownBundle.message("markdown.export.dialog.filetype.label", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$row.label(string);
                MarkdownExportDialog.access$setFileTypeSelector$p(this.this$0, (ComboBox)ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)MarkdownExportDialog.access$getSupportedExportProviders(this.this$0), (ListCellRenderer)((Object)this.this$0.new FileTypeRenderer())), (ObservableMutableProperty)((ObservableMutableProperty)fileTypeProperty2)).validationOnApply((Function2)new Function2<ValidationInfoBuilder, ComboBox<MarkdownExportProvider>, ValidationInfo>(this.this$0){
                    final /* synthetic */ MarkdownExportDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    @Nullable
                    public final ValidationInfo invoke(@NotNull ValidationInfoBuilder $this$validationOnApply, @NotNull ComboBox<MarkdownExportProvider> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return MarkdownExportDialog.access$validateFileType(this.this$0, $this$validationOnApply, it);
                    }
                }).focused().getComponent());
            }
        }), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createSettingsComponents(@NotNull Panel $this$createSettingsComponents) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createSettingsComponents, (String)"<this>");
        Iterable $this$mapNotNull$iv = this.getSupportedExportProviders();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MarkdownExportProvider it = (MarkdownExportProvider)element$iv$iv;
            boolean bl2 = false;
            MarkdownExportProvider $this$createSettingsComponents_u24lambda_u242_u24lambda_u241 = it;
            boolean bl3 = false;
            VirtualFile file = VfsUtil.findFileByIoFile((File)new File(this.getSuggestedFilePath()), (boolean)true);
            if (file != null) {
                RowsRange rowsRange = $this$createSettingsComponents_u24lambda_u242_u24lambda_u241.createSettingsComponent($this$createSettingsComponents, this.getProject(), file);
                if (rowsRange != null) {
                    ComboBox<MarkdownExportProvider> comboBox = this.fileTypeSelector;
                    if (comboBox == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"fileTypeSelector");
                        comboBox = null;
                    }
                    rowsRange.visibleIf(ComponentPredicateKt.selectedValueIs((JComboBox)((JComboBox)comboBox), (Object)it));
                }
            }
            Unit it$iv$iv = Unit.INSTANCE;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final MarkdownExportProvider findFirstValidProvider() {
        Object v0;
        block1: {
            Iterable iterable = this.getSupportedExportProviders();
            for (Object t : iterable) {
                MarkdownExportProvider it = (MarkdownExportProvider)t;
                boolean bl = false;
                if (!(it.validate(this.getProject(), this.getFile()) == null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ValidationInfo validateFileType(ValidationInfoBuilder $this$validateFileType, ComboBox<MarkdownExportProvider> combobox) {
        ValidationInfo validationInfo;
        String errorMessage;
        MarkdownExportProvider provider = (MarkdownExportProvider)combobox.getItem();
        String string = errorMessage = provider.validate(this.getProject(), this.getFile());
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            validationInfo = $this$validateFileType.error(p0);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final /* synthetic */ MarkdownExportProvider access$getSelectedFileType$p(MarkdownExportDialog $this) {
        return $this.selectedFileType;
    }

    public static final /* synthetic */ void access$setSelectedFileType$p(MarkdownExportDialog $this, MarkdownExportProvider markdownExportProvider) {
        $this.selectedFileType = markdownExportProvider;
    }

    public static final /* synthetic */ Action access$getOKAction(MarkdownExportDialog $this) {
        return $this.getOKAction();
    }

    public static final /* synthetic */ MarkdownExportProvider access$findFirstValidProvider(MarkdownExportDialog $this) {
        return $this.findFirstValidProvider();
    }

    public static final /* synthetic */ List access$getSupportedExportProviders(MarkdownExportDialog $this) {
        return $this.getSupportedExportProviders();
    }

    public static final /* synthetic */ void access$setFileTypeSelector$p(MarkdownExportDialog $this, ComboBox comboBox) {
        $this.fileTypeSelector = comboBox;
    }

    public static final /* synthetic */ ValidationInfo access$validateFileType(MarkdownExportDialog $this, ValidationInfoBuilder $receiver, ComboBox combobox) {
        return $this.validateFileType($receiver, (ComboBox<MarkdownExportProvider>)combobox);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog$FileTypeRenderer;", "Lcom/intellij/ui/SimpleListCellRenderer;", "Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportProvider;", "(Lorg/intellij/plugins/markdown/fileActions/export/MarkdownExportDialog;)V", "customize", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.markdown"})
    private final class FileTypeRenderer
    extends SimpleListCellRenderer<MarkdownExportProvider> {
        public void customize(@NotNull JList<? extends MarkdownExportProvider> list2, @Nullable MarkdownExportProvider value, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            if (value == null) {
                return;
            }
            this.setText(value.getFormatDescription().getFormatName());
            String errorMessage = value.validate(MarkdownExportDialog.this.getProject(), MarkdownExportDialog.this.getFile());
            if (errorMessage != null) {
                this.setEnabled(false);
                this.setToolTipText(errorMessage);
            } else {
                this.setEnabled(true);
            }
        }
    }
}

