/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpCharImpl
extends RegExpElementImpl
implements RegExpChar {
    private static final TokenSet OCT_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.OCT_CHAR, RegExpTT.BAD_OCT_VALUE});
    private static final TokenSet HEX_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.HEX_CHAR, RegExpTT.BAD_HEX_VALUE});
    private static final TokenSet UNICODE_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.UNICODE_CHAR, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});

    public RegExpCharImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpChar.Type getType() {
        IElementType t = this.getNode().getFirstChildNode().getElementType();
        if (OCT_CHARS.contains(t)) {
            RegExpChar.Type type2 = RegExpChar.Type.OCT;
            if (type2 == null) {
                RegExpCharImpl.$$$reportNull$$$0(0);
            }
            return type2;
        }
        if (HEX_CHARS.contains(t)) {
            RegExpChar.Type type3 = RegExpChar.Type.HEX;
            if (type3 == null) {
                RegExpCharImpl.$$$reportNull$$$0(1);
            }
            return type3;
        }
        if (UNICODE_CHARS.contains(t)) {
            RegExpChar.Type type4 = RegExpChar.Type.UNICODE;
            if (type4 == null) {
                RegExpCharImpl.$$$reportNull$$$0(2);
            }
            return type4;
        }
        if (t == RegExpTT.NAMED_CHARACTER) {
            RegExpChar.Type type5 = RegExpChar.Type.NAMED;
            if (type5 == null) {
                RegExpCharImpl.$$$reportNull$$$0(3);
            }
            return type5;
        }
        if (t == RegExpTT.CTRL) {
            RegExpChar.Type type6 = RegExpChar.Type.CONTROL;
            if (type6 == null) {
                RegExpCharImpl.$$$reportNull$$$0(4);
            }
            return type6;
        }
        RegExpChar.Type type7 = RegExpChar.Type.CHAR;
        if (type7 == null) {
            RegExpCharImpl.$$$reportNull$$$0(5);
        }
        return type7;
    }

    @Override
    public int getValue() {
        int i;
        ASTNode node = this.getNode();
        IElementType type2 = node.getFirstChildNode().getElementType();
        if (type2 == RegExpTT.BAD_OCT_VALUE || type2 == RegExpTT.BAD_HEX_VALUE || type2 == RegExpTT.BAD_CHARACTER || type2 == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
            return -1;
        }
        String text2 = this.getUnescapedText();
        if (text2.length() == 1 && (type2 == RegExpTT.CHARACTER || type2 == RegExpTT.CTRL_CHARACTER)) {
            return text2.codePointAt(0);
        }
        if (type2 == RegExpTT.UNICODE_CHAR && (i = text2.indexOf(92, 1)) >= 0) {
            return Character.toCodePoint((char)RegExpCharImpl.unescapeChar(text2.substring(0, i)), (char)RegExpCharImpl.unescapeChar(text2.substring(i)));
        }
        return RegExpCharImpl.unescapeChar(text2);
    }

    public static int unescapeChar(String s) {
        int c = s.codePointAt(0);
        int length = s.length();
        if (length == 1 || c != 92) {
            return -1;
        }
        int codePoint = s.codePointAt(1);
        return switch (codePoint) {
            case 110 -> 10;
            case 114 -> 13;
            case 116 -> 9;
            case 97 -> 7;
            case 101 -> 27;
            case 102 -> 12;
            case 98 -> 8;
            case 99 -> {
                if (length != 3) {
                    yield -1;
                }
                yield s.codePointAt(2) ^ 0x40;
            }
            case 78 -> {
                if (length < 4 || s.charAt(2) != '{' || s.charAt(length - 1) != '}') {
                    yield -1;
                }
                yield UnicodeCharacterNames.getCodePoint(s.substring(3, length - 1));
            }
            case 120 -> {
                if (length <= 2) {
                    yield -1;
                }
                if (s.charAt(2) == '{') {
                    if (s.charAt(length - 1) != '}') {
                        yield -1;
                    }
                    yield RegExpCharImpl.parseNumber(s, 3, 16);
                }
                if (length == 3) {
                    yield RegExpCharImpl.parseNumber(s, 2, 16);
                }
                if (length == 4) {
                    yield RegExpCharImpl.parseNumber(s, 2, 16);
                }
                yield -1;
            }
            case 117 -> {
                if (length <= 2) {
                    yield 117;
                }
                if (s.charAt(2) == '{') {
                    if (s.charAt(length - 1) != '}') {
                        yield -1;
                    }
                    yield RegExpCharImpl.parseNumber(s, 3, 16);
                }
                if (length != 6) {
                    yield -1;
                }
                yield RegExpCharImpl.parseNumber(s, 2, 16);
            }
            case 48, 49, 50, 51, 52, 53, 54, 55 -> RegExpCharImpl.parseNumber(s, 1, 8);
            default -> codePoint;
        };
    }

    private static int parseNumber(String s, int offset, int radix) {
        int digit;
        int i;
        int sum2 = 0;
        for (i = offset; i < s.length() && (digit = Character.digit(s.charAt(i), radix)) >= 0; ++i) {
            if ((sum2 = sum2 * radix + digit) <= 0x10FFFF) continue;
            return -1;
        }
        if (i - offset <= 0) {
            return -1;
        }
        return sum2;
    }

    @Override
    public void accept(RegExpElementVisitor visitor2) {
        visitor2.visitRegExpChar(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
    }
}

