/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.ui.flat.EndpointsCursor;
import com.intellij.microservices.ui.flat.FlatEndpointItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u00c6\u0003J\u000e\u0010\u0018\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJP\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\b\b\u0002\u0010\n\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 0\u001fJ\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0013\u0010\n\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/microservices/ui/flat/FlatEndpointGroup;", "G", "", "E", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "provider", "Lcom/intellij/microservices/endpoints/EndpointsProvider;", "group", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;)V", "getGroup", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getModule", "()Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProvider", "()Lcom/intellij/microservices/endpoints/EndpointsProvider;", "component1", "component2", "component3", "component4", "copy", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/endpoints/EndpointsModuleEntity;Lcom/intellij/microservices/endpoints/EndpointsProvider;Ljava/lang/Object;)Lcom/intellij/microservices/ui/flat/FlatEndpointGroup;", "equals", "", "other", "getEndpoints", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/ui/flat/FlatEndpointItem;", "hashCode", "", "toString", "", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nEndpointsCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointsCursor.kt\ncom/intellij/microservices/ui/flat/FlatEndpointGroup\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,276:1\n13#2:277\n*S KotlinDebug\n*F\n+ 1 EndpointsCursor.kt\ncom/intellij/microservices/ui/flat/FlatEndpointGroup\n*L\n204#1:277\n*E\n"})
final class FlatEndpointGroup<G, E> {
    @NotNull
    private final Project project;
    @Nullable
    private final EndpointsModuleEntity module;
    @NotNull
    private final EndpointsProvider<G, E> provider;
    @NotNull
    private final G group;

    public FlatEndpointGroup(@NotNull Project project, @Nullable EndpointsModuleEntity module, @NotNull EndpointsProvider<G, E> provider, @NotNull G group) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        this.project = project;
        this.module = module;
        this.provider = provider;
        this.group = group;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final EndpointsModuleEntity getModule() {
        return this.module;
    }

    @NotNull
    public final EndpointsProvider<G, E> getProvider() {
        return this.provider;
    }

    @NotNull
    public final G getGroup() {
        return this.group;
    }

    @NotNull
    public final Sequence<FlatEndpointItem<G, E>> getEndpoints() {
        Iterable iterable;
        try {
            iterable = (Iterable)ProgressManager.getInstance().runProcess(() -> FlatEndpointGroup.getEndpoints$lambda$0(this), (ProgressIndicator)new EmptyProgressIndicator());
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw ex;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(EndpointsCursor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
            iterable = CollectionsKt.emptyList();
        }
        Iterable endpoints = iterable;
        Intrinsics.checkNotNull((Object)endpoints);
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)endpoints), (Function1)new Function1<E, FlatEndpointItem<G, E>>(this){
            final /* synthetic */ FlatEndpointGroup<G, E> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FlatEndpointItem<G, E> invoke(@NotNull E it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ItemPresentation presentation = this.this$0.getProvider().getEndpointPresentation(this.this$0.getGroup(), it);
                return new FlatEndpointItem<G, E>(this.this$0.getProject(), this.this$0.getModule(), this.this$0.getProvider(), this.this$0.getGroup(), it, presentation);
            }
        });
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @Nullable
    public final EndpointsModuleEntity component2() {
        return this.module;
    }

    @NotNull
    public final EndpointsProvider<G, E> component3() {
        return this.provider;
    }

    @NotNull
    public final G component4() {
        return this.group;
    }

    @NotNull
    public final FlatEndpointGroup<G, E> copy(@NotNull Project project, @Nullable EndpointsModuleEntity module, @NotNull EndpointsProvider<G, E> provider, @NotNull G group) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        return new FlatEndpointGroup<G, E>(project, module, provider, group);
    }

    public static /* synthetic */ FlatEndpointGroup copy$default(FlatEndpointGroup flatEndpointGroup, Project project, EndpointsModuleEntity endpointsModuleEntity, EndpointsProvider endpointsProvider, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            project = flatEndpointGroup.project;
        }
        if ((n & 2) != 0) {
            endpointsModuleEntity = flatEndpointGroup.module;
        }
        if ((n & 4) != 0) {
            endpointsProvider = flatEndpointGroup.provider;
        }
        if ((n & 8) != 0) {
            object = flatEndpointGroup.group;
        }
        return flatEndpointGroup.copy(project, endpointsModuleEntity, endpointsProvider, object);
    }

    @NotNull
    public String toString() {
        return "FlatEndpointGroup(project=" + this.project + ", module=" + this.module + ", provider=" + this.provider + ", group=" + this.group + ")";
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = result * 31 + (this.module == null ? 0 : this.module.hashCode());
        result = result * 31 + this.provider.hashCode();
        result = result * 31 + this.group.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlatEndpointGroup)) {
            return false;
        }
        FlatEndpointGroup flatEndpointGroup = (FlatEndpointGroup)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)flatEndpointGroup.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.module, (Object)flatEndpointGroup.module)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.provider, flatEndpointGroup.provider)) {
            return false;
        }
        return Intrinsics.areEqual(this.group, flatEndpointGroup.group);
    }

    private static final Iterable getEndpoints$lambda$0(FlatEndpointGroup this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.provider.getEndpoints(this$0.group);
    }
}

