/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.model;

import com.intellij.microservices.ui.diagrams.MsDiagramRelationship;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.ui.diagrams.model.MsDiagramRequestsKt;
import com.intellij.microservices.ui.diagrams.model.MsDiagramWebservice;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/intellij/microservices/ui/diagrams/model/RequestToWebservice;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramRequest;", "source", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "target", "targetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "pathReference", "Lcom/intellij/microservices/url/references/UrlPathReference;", "(Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;Lcom/intellij/microservices/url/UrlTargetInfo;Lcom/intellij/microservices/url/references/UrlPathReference;)V", "getPathReference", "()Lcom/intellij/microservices/url/references/UrlPathReference;", "getSource", "()Lcom/intellij/microservices/ui/diagrams/model/MsDiagramWebservice;", "getTarget", "getTargetInfo", "()Lcom/intellij/microservices/url/UrlTargetInfo;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "resolveToSourcePsiElement", "Lcom/intellij/psi/PsiElement;", "toRelationship", "Lcom/intellij/microservices/ui/diagrams/MsDiagramRelationship;", "toString", "", "intellij.microservices.ui"})
public final class RequestToWebservice
extends MsDiagramRequest {
    @NotNull
    private final MsDiagramWebservice source;
    @NotNull
    private final MsDiagramWebservice target;
    @NotNull
    private final UrlTargetInfo targetInfo;
    @NotNull
    private final UrlPathReference pathReference;

    public RequestToWebservice(@NotNull MsDiagramWebservice source2, @NotNull MsDiagramWebservice target, @NotNull UrlTargetInfo targetInfo, @NotNull UrlPathReference pathReference) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        Intrinsics.checkNotNullParameter((Object)pathReference, (String)"pathReference");
        super(null);
        this.source = source2;
        this.target = target;
        this.targetInfo = targetInfo;
        this.pathReference = pathReference;
    }

    @Override
    @NotNull
    public MsDiagramWebservice getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public MsDiagramWebservice getTarget() {
        return this.target;
    }

    @NotNull
    public final UrlTargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    @NotNull
    public final UrlPathReference getPathReference() {
        return this.pathReference;
    }

    @Override
    @NotNull
    public PsiElement resolveToSourcePsiElement() {
        PsiElement psiElement = this.pathReference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return psiElement;
    }

    @Override
    @NotNull
    public MsDiagramRelationship toRelationship() {
        return MsDiagramRequestsKt.access$urlRequestToRelationship(this.targetInfo);
    }

    @NotNull
    public final MsDiagramWebservice component1() {
        return this.source;
    }

    @NotNull
    public final MsDiagramWebservice component2() {
        return this.target;
    }

    @NotNull
    public final UrlTargetInfo component3() {
        return this.targetInfo;
    }

    @NotNull
    public final UrlPathReference component4() {
        return this.pathReference;
    }

    @NotNull
    public final RequestToWebservice copy(@NotNull MsDiagramWebservice source2, @NotNull MsDiagramWebservice target, @NotNull UrlTargetInfo targetInfo, @NotNull UrlPathReference pathReference) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)targetInfo, (String)"targetInfo");
        Intrinsics.checkNotNullParameter((Object)pathReference, (String)"pathReference");
        return new RequestToWebservice(source2, target, targetInfo, pathReference);
    }

    public static /* synthetic */ RequestToWebservice copy$default(RequestToWebservice requestToWebservice, MsDiagramWebservice msDiagramWebservice, MsDiagramWebservice msDiagramWebservice2, UrlTargetInfo urlTargetInfo2, UrlPathReference urlPathReference, int n, Object object) {
        if ((n & 1) != 0) {
            msDiagramWebservice = requestToWebservice.source;
        }
        if ((n & 2) != 0) {
            msDiagramWebservice2 = requestToWebservice.target;
        }
        if ((n & 4) != 0) {
            urlTargetInfo2 = requestToWebservice.targetInfo;
        }
        if ((n & 8) != 0) {
            urlPathReference = requestToWebservice.pathReference;
        }
        return requestToWebservice.copy(msDiagramWebservice, msDiagramWebservice2, urlTargetInfo2, urlPathReference);
    }

    @NotNull
    public String toString() {
        return "RequestToWebservice(source=" + this.source + ", target=" + this.target + ", targetInfo=" + this.targetInfo + ", pathReference=" + this.pathReference + ")";
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + this.target.hashCode();
        result = result * 31 + this.targetInfo.hashCode();
        result = result * 31 + this.pathReference.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestToWebservice)) {
            return false;
        }
        RequestToWebservice requestToWebservice = (RequestToWebservice)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)requestToWebservice.source)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.target, (Object)requestToWebservice.target)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetInfo, (Object)requestToWebservice.targetInfo)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pathReference, (Object)requestToWebservice.pathReference);
    }
}

