"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __reflectGet = Reflect.get;
var __pow = Math.pow;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a3, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a3, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a3, prop, b[prop]);
    }
  return a3;
};
var __spreadProps = (a3, b) => __defProps(a3, __getOwnPropDescs(b));
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};
var __superGet = (cls, obj, key) => __reflectGet(__getProtoOf(cls), key, obj);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// node_modules/vscode-languageserver/lib/common/utils/is.js
var require_is = __commonJS({
  "node_modules/vscode-languageserver/lib/common/utils/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.thenable = exports2.typedArray = exports2.stringArray = exports2.array = exports2.func = exports2.error = exports2.number = exports2.string = exports2.boolean = void 0;
    function boolean(value) {
      return value === true || value === false;
    }
    exports2.boolean = boolean;
    function string(value) {
      return typeof value === "string" || value instanceof String;
    }
    exports2.string = string;
    function number(value) {
      return typeof value === "number" || value instanceof Number;
    }
    exports2.number = number;
    function error(value) {
      return value instanceof Error;
    }
    exports2.error = error;
    function func(value) {
      return typeof value === "function";
    }
    exports2.func = func;
    function array(value) {
      return Array.isArray(value);
    }
    exports2.array = array;
    function stringArray(value) {
      return array(value) && value.every((elem) => string(elem));
    }
    exports2.stringArray = stringArray;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    exports2.typedArray = typedArray;
    function thenable(value) {
      return value && func(value.then);
    }
    exports2.thenable = thenable;
  }
});

// node_modules/vscode-jsonrpc/lib/common/is.js
var require_is2 = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.stringArray = exports2.array = exports2.func = exports2.error = exports2.number = exports2.string = exports2.boolean = void 0;
    function boolean(value) {
      return value === true || value === false;
    }
    exports2.boolean = boolean;
    function string(value) {
      return typeof value === "string" || value instanceof String;
    }
    exports2.string = string;
    function number(value) {
      return typeof value === "number" || value instanceof Number;
    }
    exports2.number = number;
    function error(value) {
      return value instanceof Error;
    }
    exports2.error = error;
    function func(value) {
      return typeof value === "function";
    }
    exports2.func = func;
    function array(value) {
      return Array.isArray(value);
    }
    exports2.array = array;
    function stringArray(value) {
      return array(value) && value.every((elem) => string(elem));
    }
    exports2.stringArray = stringArray;
  }
});

// node_modules/vscode-jsonrpc/lib/common/messages.js
var require_messages = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/messages.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Message = exports2.NotificationType9 = exports2.NotificationType8 = exports2.NotificationType7 = exports2.NotificationType6 = exports2.NotificationType5 = exports2.NotificationType4 = exports2.NotificationType3 = exports2.NotificationType2 = exports2.NotificationType1 = exports2.NotificationType0 = exports2.NotificationType = exports2.RequestType9 = exports2.RequestType8 = exports2.RequestType7 = exports2.RequestType6 = exports2.RequestType5 = exports2.RequestType4 = exports2.RequestType3 = exports2.RequestType2 = exports2.RequestType1 = exports2.RequestType = exports2.RequestType0 = exports2.AbstractMessageSignature = exports2.ParameterStructures = exports2.ResponseError = exports2.ErrorCodes = void 0;
    var is = require_is2();
    var ErrorCodes;
    (function(ErrorCodes2) {
      ErrorCodes2.ParseError = -32700;
      ErrorCodes2.InvalidRequest = -32600;
      ErrorCodes2.MethodNotFound = -32601;
      ErrorCodes2.InvalidParams = -32602;
      ErrorCodes2.InternalError = -32603;
      ErrorCodes2.jsonrpcReservedErrorRangeStart = -32099;
      ErrorCodes2.serverErrorStart = -32099;
      ErrorCodes2.MessageWriteError = -32099;
      ErrorCodes2.MessageReadError = -32098;
      ErrorCodes2.PendingResponseRejected = -32097;
      ErrorCodes2.ConnectionInactive = -32096;
      ErrorCodes2.ServerNotInitialized = -32002;
      ErrorCodes2.UnknownErrorCode = -32001;
      ErrorCodes2.jsonrpcReservedErrorRangeEnd = -32e3;
      ErrorCodes2.serverErrorEnd = -32e3;
    })(ErrorCodes || (exports2.ErrorCodes = ErrorCodes = {}));
    var ResponseError = class _ResponseError extends Error {
      constructor(code, message, data) {
        super(message);
        this.code = is.number(code) ? code : ErrorCodes.UnknownErrorCode;
        this.data = data;
        Object.setPrototypeOf(this, _ResponseError.prototype);
      }
      toJson() {
        const result = {
          code: this.code,
          message: this.message
        };
        if (this.data !== void 0) {
          result.data = this.data;
        }
        return result;
      }
    };
    exports2.ResponseError = ResponseError;
    var ParameterStructures = class _ParameterStructures {
      constructor(kind) {
        this.kind = kind;
      }
      static is(value) {
        return value === _ParameterStructures.auto || value === _ParameterStructures.byName || value === _ParameterStructures.byPosition;
      }
      toString() {
        return this.kind;
      }
    };
    exports2.ParameterStructures = ParameterStructures;
    ParameterStructures.auto = new ParameterStructures("auto");
    ParameterStructures.byPosition = new ParameterStructures("byPosition");
    ParameterStructures.byName = new ParameterStructures("byName");
    var AbstractMessageSignature = class {
      constructor(method, numberOfParams) {
        this.method = method;
        this.numberOfParams = numberOfParams;
      }
      get parameterStructures() {
        return ParameterStructures.auto;
      }
    };
    exports2.AbstractMessageSignature = AbstractMessageSignature;
    var RequestType0 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 0);
      }
    };
    exports2.RequestType0 = RequestType0;
    var RequestType = class extends AbstractMessageSignature {
      constructor(method, _parameterStructures = ParameterStructures.auto) {
        super(method, 1);
        this._parameterStructures = _parameterStructures;
      }
      get parameterStructures() {
        return this._parameterStructures;
      }
    };
    exports2.RequestType = RequestType;
    var RequestType1 = class extends AbstractMessageSignature {
      constructor(method, _parameterStructures = ParameterStructures.auto) {
        super(method, 1);
        this._parameterStructures = _parameterStructures;
      }
      get parameterStructures() {
        return this._parameterStructures;
      }
    };
    exports2.RequestType1 = RequestType1;
    var RequestType2 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 2);
      }
    };
    exports2.RequestType2 = RequestType2;
    var RequestType3 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 3);
      }
    };
    exports2.RequestType3 = RequestType3;
    var RequestType4 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 4);
      }
    };
    exports2.RequestType4 = RequestType4;
    var RequestType5 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 5);
      }
    };
    exports2.RequestType5 = RequestType5;
    var RequestType6 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 6);
      }
    };
    exports2.RequestType6 = RequestType6;
    var RequestType7 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 7);
      }
    };
    exports2.RequestType7 = RequestType7;
    var RequestType8 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 8);
      }
    };
    exports2.RequestType8 = RequestType8;
    var RequestType9 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 9);
      }
    };
    exports2.RequestType9 = RequestType9;
    var NotificationType = class extends AbstractMessageSignature {
      constructor(method, _parameterStructures = ParameterStructures.auto) {
        super(method, 1);
        this._parameterStructures = _parameterStructures;
      }
      get parameterStructures() {
        return this._parameterStructures;
      }
    };
    exports2.NotificationType = NotificationType;
    var NotificationType0 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 0);
      }
    };
    exports2.NotificationType0 = NotificationType0;
    var NotificationType1 = class extends AbstractMessageSignature {
      constructor(method, _parameterStructures = ParameterStructures.auto) {
        super(method, 1);
        this._parameterStructures = _parameterStructures;
      }
      get parameterStructures() {
        return this._parameterStructures;
      }
    };
    exports2.NotificationType1 = NotificationType1;
    var NotificationType2 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 2);
      }
    };
    exports2.NotificationType2 = NotificationType2;
    var NotificationType3 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 3);
      }
    };
    exports2.NotificationType3 = NotificationType3;
    var NotificationType4 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 4);
      }
    };
    exports2.NotificationType4 = NotificationType4;
    var NotificationType5 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 5);
      }
    };
    exports2.NotificationType5 = NotificationType5;
    var NotificationType6 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 6);
      }
    };
    exports2.NotificationType6 = NotificationType6;
    var NotificationType7 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 7);
      }
    };
    exports2.NotificationType7 = NotificationType7;
    var NotificationType8 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 8);
      }
    };
    exports2.NotificationType8 = NotificationType8;
    var NotificationType9 = class extends AbstractMessageSignature {
      constructor(method) {
        super(method, 9);
      }
    };
    exports2.NotificationType9 = NotificationType9;
    var Message;
    (function(Message2) {
      function isRequest(message) {
        const candidate = message;
        return candidate && is.string(candidate.method) && (is.string(candidate.id) || is.number(candidate.id));
      }
      Message2.isRequest = isRequest;
      function isNotification(message) {
        const candidate = message;
        return candidate && is.string(candidate.method) && message.id === void 0;
      }
      Message2.isNotification = isNotification;
      function isResponse(message) {
        const candidate = message;
        return candidate && (candidate.result !== void 0 || !!candidate.error) && (is.string(candidate.id) || is.number(candidate.id) || candidate.id === null);
      }
      Message2.isResponse = isResponse;
    })(Message || (exports2.Message = Message = {}));
  }
});

// node_modules/vscode-jsonrpc/lib/common/linkedMap.js
var require_linkedMap = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/linkedMap.js"(exports2) {
    "use strict";
    var _a3;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LRUCache = exports2.LinkedMap = exports2.Touch = void 0;
    var Touch;
    (function(Touch2) {
      Touch2.None = 0;
      Touch2.First = 1;
      Touch2.AsOld = Touch2.First;
      Touch2.Last = 2;
      Touch2.AsNew = Touch2.Last;
    })(Touch || (exports2.Touch = Touch = {}));
    var LinkedMap = class {
      constructor() {
        this[_a3] = "LinkedMap";
        this._map = /* @__PURE__ */ new Map();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state = 0;
      }
      clear() {
        this._map.clear();
        this._head = void 0;
        this._tail = void 0;
        this._size = 0;
        this._state++;
      }
      isEmpty() {
        return !this._head && !this._tail;
      }
      get size() {
        return this._size;
      }
      get first() {
        var _a4;
        return (_a4 = this._head) == null ? void 0 : _a4.value;
      }
      get last() {
        var _a4;
        return (_a4 = this._tail) == null ? void 0 : _a4.value;
      }
      has(key) {
        return this._map.has(key);
      }
      get(key, touch = Touch.None) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        if (touch !== Touch.None) {
          this.touch(item, touch);
        }
        return item.value;
      }
      set(key, value, touch = Touch.None) {
        let item = this._map.get(key);
        if (item) {
          item.value = value;
          if (touch !== Touch.None) {
            this.touch(item, touch);
          }
        } else {
          item = { key, value, next: void 0, previous: void 0 };
          switch (touch) {
            case Touch.None:
              this.addItemLast(item);
              break;
            case Touch.First:
              this.addItemFirst(item);
              break;
            case Touch.Last:
              this.addItemLast(item);
              break;
            default:
              this.addItemLast(item);
              break;
          }
          this._map.set(key, item);
          this._size++;
        }
        return this;
      }
      delete(key) {
        return !!this.remove(key);
      }
      remove(key) {
        const item = this._map.get(key);
        if (!item) {
          return void 0;
        }
        this._map.delete(key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      shift() {
        if (!this._head && !this._tail) {
          return void 0;
        }
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        const item = this._head;
        this._map.delete(item.key);
        this.removeItem(item);
        this._size--;
        return item.value;
      }
      forEach(callbackfn, thisArg) {
        const state = this._state;
        let current = this._head;
        while (current) {
          if (thisArg) {
            callbackfn.bind(thisArg)(current.value, current.key, this);
          } else {
            callbackfn(current.value, current.key, this);
          }
          if (this._state !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          current = current.next;
        }
      }
      keys() {
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]: () => {
            return iterator;
          },
          next: () => {
            if (this._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.key, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      values() {
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]: () => {
            return iterator;
          },
          next: () => {
            if (this._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.value, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      entries() {
        const state = this._state;
        let current = this._head;
        const iterator = {
          [Symbol.iterator]: () => {
            return iterator;
          },
          next: () => {
            if (this._state !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: [current.key, current.value], done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      [(_a3 = Symbol.toStringTag, Symbol.iterator)]() {
        return this.entries();
      }
      trimOld(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this._head;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this._map.delete(current.key);
          current = current.next;
          currentSize--;
        }
        this._head = current;
        this._size = currentSize;
        if (current) {
          current.previous = void 0;
        }
        this._state++;
      }
      addItemFirst(item) {
        if (!this._head && !this._tail) {
          this._tail = item;
        } else if (!this._head) {
          throw new Error("Invalid list");
        } else {
          item.next = this._head;
          this._head.previous = item;
        }
        this._head = item;
        this._state++;
      }
      addItemLast(item) {
        if (!this._head && !this._tail) {
          this._head = item;
        } else if (!this._tail) {
          throw new Error("Invalid list");
        } else {
          item.previous = this._tail;
          this._tail.next = item;
        }
        this._tail = item;
        this._state++;
      }
      removeItem(item) {
        if (item === this._head && item === this._tail) {
          this._head = void 0;
          this._tail = void 0;
        } else if (item === this._head) {
          if (!item.next) {
            throw new Error("Invalid list");
          }
          item.next.previous = void 0;
          this._head = item.next;
        } else if (item === this._tail) {
          if (!item.previous) {
            throw new Error("Invalid list");
          }
          item.previous.next = void 0;
          this._tail = item.previous;
        } else {
          const next = item.next;
          const previous = item.previous;
          if (!next || !previous) {
            throw new Error("Invalid list");
          }
          next.previous = previous;
          previous.next = next;
        }
        item.next = void 0;
        item.previous = void 0;
        this._state++;
      }
      touch(item, touch) {
        if (!this._head || !this._tail) {
          throw new Error("Invalid list");
        }
        if (touch !== Touch.First && touch !== Touch.Last) {
          return;
        }
        if (touch === Touch.First) {
          if (item === this._head) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._tail) {
            previous.next = void 0;
            this._tail = previous;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.previous = void 0;
          item.next = this._head;
          this._head.previous = item;
          this._head = item;
          this._state++;
        } else if (touch === Touch.Last) {
          if (item === this._tail) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this._head) {
            next.previous = void 0;
            this._head = next;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.next = void 0;
          item.previous = this._tail;
          this._tail.next = item;
          this._tail = item;
          this._state++;
        }
      }
      toJSON() {
        const data = [];
        this.forEach((value, key) => {
          data.push([key, value]);
        });
        return data;
      }
      fromJSON(data) {
        this.clear();
        for (const [key, value] of data) {
          this.set(key, value);
        }
      }
    };
    exports2.LinkedMap = LinkedMap;
    var LRUCache = class extends LinkedMap {
      constructor(limit, ratio = 1) {
        super();
        this._limit = limit;
        this._ratio = Math.min(Math.max(0, ratio), 1);
      }
      get limit() {
        return this._limit;
      }
      set limit(limit) {
        this._limit = limit;
        this.checkTrim();
      }
      get ratio() {
        return this._ratio;
      }
      set ratio(ratio) {
        this._ratio = Math.min(Math.max(0, ratio), 1);
        this.checkTrim();
      }
      get(key, touch = Touch.AsNew) {
        return super.get(key, touch);
      }
      peek(key) {
        return super.get(key, Touch.None);
      }
      set(key, value) {
        super.set(key, value, Touch.Last);
        this.checkTrim();
        return this;
      }
      checkTrim() {
        if (this.size > this._limit) {
          this.trimOld(Math.round(this._limit * this._ratio));
        }
      }
    };
    exports2.LRUCache = LRUCache;
  }
});

// node_modules/vscode-jsonrpc/lib/common/disposable.js
var require_disposable = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/disposable.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Disposable = void 0;
    var Disposable;
    (function(Disposable2) {
      function create(func) {
        return {
          dispose: func
        };
      }
      Disposable2.create = create;
    })(Disposable || (exports2.Disposable = Disposable = {}));
  }
});

// node_modules/vscode-jsonrpc/lib/common/ral.js
var require_ral = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/ral.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var _ral;
    function RAL() {
      if (_ral === void 0) {
        throw new Error(`No runtime abstraction layer installed`);
      }
      return _ral;
    }
    (function(RAL2) {
      function install(ral) {
        if (ral === void 0) {
          throw new Error(`No runtime abstraction layer provided`);
        }
        _ral = ral;
      }
      RAL2.install = install;
    })(RAL || (RAL = {}));
    exports2.default = RAL;
  }
});

// node_modules/vscode-jsonrpc/lib/common/events.js
var require_events = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/events.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Emitter = exports2.Event = void 0;
    var ral_1 = require_ral();
    var Event;
    (function(Event2) {
      const _disposable = { dispose() {
      } };
      Event2.None = function() {
        return _disposable;
      };
    })(Event || (exports2.Event = Event = {}));
    var CallbackList = class {
      add(callback, context = null, bucket) {
        if (!this._callbacks) {
          this._callbacks = [];
          this._contexts = [];
        }
        this._callbacks.push(callback);
        this._contexts.push(context);
        if (Array.isArray(bucket)) {
          bucket.push({ dispose: () => this.remove(callback, context) });
        }
      }
      remove(callback, context = null) {
        if (!this._callbacks) {
          return;
        }
        let foundCallbackWithDifferentContext = false;
        for (let i = 0, len = this._callbacks.length; i < len; i++) {
          if (this._callbacks[i] === callback) {
            if (this._contexts[i] === context) {
              this._callbacks.splice(i, 1);
              this._contexts.splice(i, 1);
              return;
            } else {
              foundCallbackWithDifferentContext = true;
            }
          }
        }
        if (foundCallbackWithDifferentContext) {
          throw new Error("When adding a listener with a context, you should remove it with the same context");
        }
      }
      invoke(...args) {
        if (!this._callbacks) {
          return [];
        }
        const ret = [], callbacks = this._callbacks.slice(0), contexts = this._contexts.slice(0);
        for (let i = 0, len = callbacks.length; i < len; i++) {
          try {
            ret.push(callbacks[i].apply(contexts[i], args));
          } catch (e) {
            (0, ral_1.default)().console.error(e);
          }
        }
        return ret;
      }
      isEmpty() {
        return !this._callbacks || this._callbacks.length === 0;
      }
      dispose() {
        this._callbacks = void 0;
        this._contexts = void 0;
      }
    };
    var Emitter = class _Emitter {
      constructor(_options) {
        this._options = _options;
      }
      /**
       * For the public to allow to subscribe
       * to events from this Emitter
       */
      get event() {
        if (!this._event) {
          this._event = (listener, thisArgs, disposables) => {
            if (!this._callbacks) {
              this._callbacks = new CallbackList();
            }
            if (this._options && this._options.onFirstListenerAdd && this._callbacks.isEmpty()) {
              this._options.onFirstListenerAdd(this);
            }
            this._callbacks.add(listener, thisArgs);
            const result = {
              dispose: () => {
                if (!this._callbacks) {
                  return;
                }
                this._callbacks.remove(listener, thisArgs);
                result.dispose = _Emitter._noop;
                if (this._options && this._options.onLastListenerRemove && this._callbacks.isEmpty()) {
                  this._options.onLastListenerRemove(this);
                }
              }
            };
            if (Array.isArray(disposables)) {
              disposables.push(result);
            }
            return result;
          };
        }
        return this._event;
      }
      /**
       * To be kept private to fire an event to
       * subscribers
       */
      fire(event) {
        if (this._callbacks) {
          this._callbacks.invoke.call(this._callbacks, event);
        }
      }
      dispose() {
        if (this._callbacks) {
          this._callbacks.dispose();
          this._callbacks = void 0;
        }
      }
    };
    exports2.Emitter = Emitter;
    Emitter._noop = function() {
    };
  }
});

// node_modules/vscode-jsonrpc/lib/common/cancellation.js
var require_cancellation = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/cancellation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CancellationTokenSource = exports2.CancellationToken = void 0;
    var ral_1 = require_ral();
    var Is2 = require_is2();
    var events_1 = require_events();
    var CancellationToken;
    (function(CancellationToken2) {
      CancellationToken2.None = Object.freeze({
        isCancellationRequested: false,
        onCancellationRequested: events_1.Event.None
      });
      CancellationToken2.Cancelled = Object.freeze({
        isCancellationRequested: true,
        onCancellationRequested: events_1.Event.None
      });
      function is(value) {
        const candidate = value;
        return candidate && (candidate === CancellationToken2.None || candidate === CancellationToken2.Cancelled || Is2.boolean(candidate.isCancellationRequested) && !!candidate.onCancellationRequested);
      }
      CancellationToken2.is = is;
    })(CancellationToken || (exports2.CancellationToken = CancellationToken = {}));
    var shortcutEvent = Object.freeze(function(callback, context) {
      const handle = (0, ral_1.default)().timer.setTimeout(callback.bind(context), 0);
      return { dispose() {
        handle.dispose();
      } };
    });
    var MutableToken = class {
      constructor() {
        this._isCancelled = false;
      }
      cancel() {
        if (!this._isCancelled) {
          this._isCancelled = true;
          if (this._emitter) {
            this._emitter.fire(void 0);
            this.dispose();
          }
        }
      }
      get isCancellationRequested() {
        return this._isCancelled;
      }
      get onCancellationRequested() {
        if (this._isCancelled) {
          return shortcutEvent;
        }
        if (!this._emitter) {
          this._emitter = new events_1.Emitter();
        }
        return this._emitter.event;
      }
      dispose() {
        if (this._emitter) {
          this._emitter.dispose();
          this._emitter = void 0;
        }
      }
    };
    var CancellationTokenSource = class {
      get token() {
        if (!this._token) {
          this._token = new MutableToken();
        }
        return this._token;
      }
      cancel() {
        if (!this._token) {
          this._token = CancellationToken.Cancelled;
        } else {
          this._token.cancel();
        }
      }
      dispose() {
        if (!this._token) {
          this._token = CancellationToken.None;
        } else if (this._token instanceof MutableToken) {
          this._token.dispose();
        }
      }
    };
    exports2.CancellationTokenSource = CancellationTokenSource;
  }
});

// node_modules/vscode-jsonrpc/lib/common/sharedArrayCancellation.js
var require_sharedArrayCancellation = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/sharedArrayCancellation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SharedArrayReceiverStrategy = exports2.SharedArraySenderStrategy = void 0;
    var cancellation_1 = require_cancellation();
    var CancellationState;
    (function(CancellationState2) {
      CancellationState2.Continue = 0;
      CancellationState2.Cancelled = 1;
    })(CancellationState || (CancellationState = {}));
    var SharedArraySenderStrategy = class {
      constructor() {
        this.buffers = /* @__PURE__ */ new Map();
      }
      enableCancellation(request) {
        if (request.id === null) {
          return;
        }
        const buffer = new SharedArrayBuffer(4);
        const data = new Int32Array(buffer, 0, 1);
        data[0] = CancellationState.Continue;
        this.buffers.set(request.id, buffer);
        request.$cancellationData = buffer;
      }
      sendCancellation(_conn, id) {
        return __async(this, null, function* () {
          const buffer = this.buffers.get(id);
          if (buffer === void 0) {
            return;
          }
          const data = new Int32Array(buffer, 0, 1);
          Atomics.store(data, 0, CancellationState.Cancelled);
        });
      }
      cleanup(id) {
        this.buffers.delete(id);
      }
      dispose() {
        this.buffers.clear();
      }
    };
    exports2.SharedArraySenderStrategy = SharedArraySenderStrategy;
    var SharedArrayBufferCancellationToken = class {
      constructor(buffer) {
        this.data = new Int32Array(buffer, 0, 1);
      }
      get isCancellationRequested() {
        return Atomics.load(this.data, 0) === CancellationState.Cancelled;
      }
      get onCancellationRequested() {
        throw new Error(`Cancellation over SharedArrayBuffer doesn't support cancellation events`);
      }
    };
    var SharedArrayBufferCancellationTokenSource = class {
      constructor(buffer) {
        this.token = new SharedArrayBufferCancellationToken(buffer);
      }
      cancel() {
      }
      dispose() {
      }
    };
    var SharedArrayReceiverStrategy = class {
      constructor() {
        this.kind = "request";
      }
      createCancellationTokenSource(request) {
        const buffer = request.$cancellationData;
        if (buffer === void 0) {
          return new cancellation_1.CancellationTokenSource();
        }
        return new SharedArrayBufferCancellationTokenSource(buffer);
      }
    };
    exports2.SharedArrayReceiverStrategy = SharedArrayReceiverStrategy;
  }
});

// node_modules/vscode-jsonrpc/lib/common/semaphore.js
var require_semaphore = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/semaphore.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Semaphore = void 0;
    var ral_1 = require_ral();
    var Semaphore = class {
      constructor(capacity = 1) {
        if (capacity <= 0) {
          throw new Error("Capacity must be greater than 0");
        }
        this._capacity = capacity;
        this._active = 0;
        this._waiting = [];
      }
      lock(thunk) {
        return new Promise((resolve, reject) => {
          this._waiting.push({ thunk, resolve, reject });
          this.runNext();
        });
      }
      get active() {
        return this._active;
      }
      runNext() {
        if (this._waiting.length === 0 || this._active === this._capacity) {
          return;
        }
        (0, ral_1.default)().timer.setImmediate(() => this.doRunNext());
      }
      doRunNext() {
        if (this._waiting.length === 0 || this._active === this._capacity) {
          return;
        }
        const next = this._waiting.shift();
        this._active++;
        if (this._active > this._capacity) {
          throw new Error(`To many thunks active`);
        }
        try {
          const result = next.thunk();
          if (result instanceof Promise) {
            result.then((value) => {
              this._active--;
              next.resolve(value);
              this.runNext();
            }, (err) => {
              this._active--;
              next.reject(err);
              this.runNext();
            });
          } else {
            this._active--;
            next.resolve(result);
            this.runNext();
          }
        } catch (err) {
          this._active--;
          next.reject(err);
          this.runNext();
        }
      }
    };
    exports2.Semaphore = Semaphore;
  }
});

// node_modules/vscode-jsonrpc/lib/common/messageReader.js
var require_messageReader = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/messageReader.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ReadableStreamMessageReader = exports2.AbstractMessageReader = exports2.MessageReader = void 0;
    var ral_1 = require_ral();
    var Is2 = require_is2();
    var events_1 = require_events();
    var semaphore_1 = require_semaphore();
    var MessageReader;
    (function(MessageReader2) {
      function is(value) {
        let candidate = value;
        return candidate && Is2.func(candidate.listen) && Is2.func(candidate.dispose) && Is2.func(candidate.onError) && Is2.func(candidate.onClose) && Is2.func(candidate.onPartialMessage);
      }
      MessageReader2.is = is;
    })(MessageReader || (exports2.MessageReader = MessageReader = {}));
    var AbstractMessageReader = class {
      constructor() {
        this.errorEmitter = new events_1.Emitter();
        this.closeEmitter = new events_1.Emitter();
        this.partialMessageEmitter = new events_1.Emitter();
      }
      dispose() {
        this.errorEmitter.dispose();
        this.closeEmitter.dispose();
      }
      get onError() {
        return this.errorEmitter.event;
      }
      fireError(error) {
        this.errorEmitter.fire(this.asError(error));
      }
      get onClose() {
        return this.closeEmitter.event;
      }
      fireClose() {
        this.closeEmitter.fire(void 0);
      }
      get onPartialMessage() {
        return this.partialMessageEmitter.event;
      }
      firePartialMessage(info) {
        this.partialMessageEmitter.fire(info);
      }
      asError(error) {
        if (error instanceof Error) {
          return error;
        } else {
          return new Error(`Reader received error. Reason: ${Is2.string(error.message) ? error.message : "unknown"}`);
        }
      }
    };
    exports2.AbstractMessageReader = AbstractMessageReader;
    var ResolvedMessageReaderOptions;
    (function(ResolvedMessageReaderOptions2) {
      function fromOptions(options) {
        var _a3;
        let charset;
        let result;
        let contentDecoder;
        const contentDecoders = /* @__PURE__ */ new Map();
        let contentTypeDecoder;
        const contentTypeDecoders = /* @__PURE__ */ new Map();
        if (options === void 0 || typeof options === "string") {
          charset = options != null ? options : "utf-8";
        } else {
          charset = (_a3 = options.charset) != null ? _a3 : "utf-8";
          if (options.contentDecoder !== void 0) {
            contentDecoder = options.contentDecoder;
            contentDecoders.set(contentDecoder.name, contentDecoder);
          }
          if (options.contentDecoders !== void 0) {
            for (const decoder of options.contentDecoders) {
              contentDecoders.set(decoder.name, decoder);
            }
          }
          if (options.contentTypeDecoder !== void 0) {
            contentTypeDecoder = options.contentTypeDecoder;
            contentTypeDecoders.set(contentTypeDecoder.name, contentTypeDecoder);
          }
          if (options.contentTypeDecoders !== void 0) {
            for (const decoder of options.contentTypeDecoders) {
              contentTypeDecoders.set(decoder.name, decoder);
            }
          }
        }
        if (contentTypeDecoder === void 0) {
          contentTypeDecoder = (0, ral_1.default)().applicationJson.decoder;
          contentTypeDecoders.set(contentTypeDecoder.name, contentTypeDecoder);
        }
        return { charset, contentDecoder, contentDecoders, contentTypeDecoder, contentTypeDecoders };
      }
      ResolvedMessageReaderOptions2.fromOptions = fromOptions;
    })(ResolvedMessageReaderOptions || (ResolvedMessageReaderOptions = {}));
    var ReadableStreamMessageReader = class extends AbstractMessageReader {
      constructor(readable, options) {
        super();
        this.readable = readable;
        this.options = ResolvedMessageReaderOptions.fromOptions(options);
        this.buffer = (0, ral_1.default)().messageBuffer.create(this.options.charset);
        this._partialMessageTimeout = 1e4;
        this.nextMessageLength = -1;
        this.messageToken = 0;
        this.readSemaphore = new semaphore_1.Semaphore(1);
      }
      set partialMessageTimeout(timeout) {
        this._partialMessageTimeout = timeout;
      }
      get partialMessageTimeout() {
        return this._partialMessageTimeout;
      }
      listen(callback) {
        this.nextMessageLength = -1;
        this.messageToken = 0;
        this.partialMessageTimer = void 0;
        this.callback = callback;
        const result = this.readable.onData((data) => {
          this.onData(data);
        });
        this.readable.onError((error) => this.fireError(error));
        this.readable.onClose(() => this.fireClose());
        return result;
      }
      onData(data) {
        try {
          this.buffer.append(data);
          while (true) {
            if (this.nextMessageLength === -1) {
              const headers = this.buffer.tryReadHeaders(true);
              if (!headers) {
                return;
              }
              const contentLength = headers.get("content-length");
              if (!contentLength) {
                this.fireError(new Error(`Header must provide a Content-Length property.
${JSON.stringify(Object.fromEntries(headers))}`));
                return;
              }
              const length = parseInt(contentLength);
              if (isNaN(length)) {
                this.fireError(new Error(`Content-Length value must be a number. Got ${contentLength}`));
                return;
              }
              this.nextMessageLength = length;
            }
            const body = this.buffer.tryReadBody(this.nextMessageLength);
            if (body === void 0) {
              this.setPartialMessageTimer();
              return;
            }
            this.clearPartialMessageTimer();
            this.nextMessageLength = -1;
            this.readSemaphore.lock(() => __async(this, null, function* () {
              const bytes = this.options.contentDecoder !== void 0 ? yield this.options.contentDecoder.decode(body) : body;
              const message = yield this.options.contentTypeDecoder.decode(bytes, this.options);
              this.callback(message);
            })).catch((error) => {
              this.fireError(error);
            });
          }
        } catch (error) {
          this.fireError(error);
        }
      }
      clearPartialMessageTimer() {
        if (this.partialMessageTimer) {
          this.partialMessageTimer.dispose();
          this.partialMessageTimer = void 0;
        }
      }
      setPartialMessageTimer() {
        this.clearPartialMessageTimer();
        if (this._partialMessageTimeout <= 0) {
          return;
        }
        this.partialMessageTimer = (0, ral_1.default)().timer.setTimeout((token, timeout) => {
          this.partialMessageTimer = void 0;
          if (token === this.messageToken) {
            this.firePartialMessage({ messageToken: token, waitingTime: timeout });
            this.setPartialMessageTimer();
          }
        }, this._partialMessageTimeout, this.messageToken, this._partialMessageTimeout);
      }
    };
    exports2.ReadableStreamMessageReader = ReadableStreamMessageReader;
  }
});

// node_modules/vscode-jsonrpc/lib/common/messageWriter.js
var require_messageWriter = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/messageWriter.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WriteableStreamMessageWriter = exports2.AbstractMessageWriter = exports2.MessageWriter = void 0;
    var ral_1 = require_ral();
    var Is2 = require_is2();
    var semaphore_1 = require_semaphore();
    var events_1 = require_events();
    var ContentLength = "Content-Length: ";
    var CRLF = "\r\n";
    var MessageWriter;
    (function(MessageWriter2) {
      function is(value) {
        let candidate = value;
        return candidate && Is2.func(candidate.dispose) && Is2.func(candidate.onClose) && Is2.func(candidate.onError) && Is2.func(candidate.write);
      }
      MessageWriter2.is = is;
    })(MessageWriter || (exports2.MessageWriter = MessageWriter = {}));
    var AbstractMessageWriter = class {
      constructor() {
        this.errorEmitter = new events_1.Emitter();
        this.closeEmitter = new events_1.Emitter();
      }
      dispose() {
        this.errorEmitter.dispose();
        this.closeEmitter.dispose();
      }
      get onError() {
        return this.errorEmitter.event;
      }
      fireError(error, message, count) {
        this.errorEmitter.fire([this.asError(error), message, count]);
      }
      get onClose() {
        return this.closeEmitter.event;
      }
      fireClose() {
        this.closeEmitter.fire(void 0);
      }
      asError(error) {
        if (error instanceof Error) {
          return error;
        } else {
          return new Error(`Writer received error. Reason: ${Is2.string(error.message) ? error.message : "unknown"}`);
        }
      }
    };
    exports2.AbstractMessageWriter = AbstractMessageWriter;
    var ResolvedMessageWriterOptions;
    (function(ResolvedMessageWriterOptions2) {
      function fromOptions(options) {
        var _a3, _b;
        if (options === void 0 || typeof options === "string") {
          return { charset: options != null ? options : "utf-8", contentTypeEncoder: (0, ral_1.default)().applicationJson.encoder };
        } else {
          return { charset: (_a3 = options.charset) != null ? _a3 : "utf-8", contentEncoder: options.contentEncoder, contentTypeEncoder: (_b = options.contentTypeEncoder) != null ? _b : (0, ral_1.default)().applicationJson.encoder };
        }
      }
      ResolvedMessageWriterOptions2.fromOptions = fromOptions;
    })(ResolvedMessageWriterOptions || (ResolvedMessageWriterOptions = {}));
    var WriteableStreamMessageWriter = class extends AbstractMessageWriter {
      constructor(writable, options) {
        super();
        this.writable = writable;
        this.options = ResolvedMessageWriterOptions.fromOptions(options);
        this.errorCount = 0;
        this.writeSemaphore = new semaphore_1.Semaphore(1);
        this.writable.onError((error) => this.fireError(error));
        this.writable.onClose(() => this.fireClose());
      }
      write(msg) {
        return __async(this, null, function* () {
          return this.writeSemaphore.lock(() => __async(this, null, function* () {
            const payload = this.options.contentTypeEncoder.encode(msg, this.options).then((buffer) => {
              if (this.options.contentEncoder !== void 0) {
                return this.options.contentEncoder.encode(buffer);
              } else {
                return buffer;
              }
            });
            return payload.then((buffer) => {
              const headers = [];
              headers.push(ContentLength, buffer.byteLength.toString(), CRLF);
              headers.push(CRLF);
              return this.doWrite(msg, headers, buffer);
            }, (error) => {
              this.fireError(error);
              throw error;
            });
          }));
        });
      }
      doWrite(msg, headers, data) {
        return __async(this, null, function* () {
          try {
            yield this.writable.write(headers.join(""), "ascii");
            return this.writable.write(data);
          } catch (error) {
            this.handleError(error, msg);
            return Promise.reject(error);
          }
        });
      }
      handleError(error, msg) {
        this.errorCount++;
        this.fireError(error, msg, this.errorCount);
      }
      end() {
        this.writable.end();
      }
    };
    exports2.WriteableStreamMessageWriter = WriteableStreamMessageWriter;
  }
});

// node_modules/vscode-jsonrpc/lib/common/messageBuffer.js
var require_messageBuffer = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/messageBuffer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AbstractMessageBuffer = void 0;
    var CR = 13;
    var LF = 10;
    var CRLF = "\r\n";
    var AbstractMessageBuffer = class {
      constructor(encoding = "utf-8") {
        this._encoding = encoding;
        this._chunks = [];
        this._totalLength = 0;
      }
      get encoding() {
        return this._encoding;
      }
      append(chunk) {
        const toAppend = typeof chunk === "string" ? this.fromString(chunk, this._encoding) : chunk;
        this._chunks.push(toAppend);
        this._totalLength += toAppend.byteLength;
      }
      tryReadHeaders(lowerCaseKeys = false) {
        if (this._chunks.length === 0) {
          return void 0;
        }
        let state = 0;
        let chunkIndex = 0;
        let offset = 0;
        let chunkBytesRead = 0;
        row:
          while (chunkIndex < this._chunks.length) {
            const chunk = this._chunks[chunkIndex];
            offset = 0;
            column:
              while (offset < chunk.length) {
                const value = chunk[offset];
                switch (value) {
                  case CR:
                    switch (state) {
                      case 0:
                        state = 1;
                        break;
                      case 2:
                        state = 3;
                        break;
                      default:
                        state = 0;
                    }
                    break;
                  case LF:
                    switch (state) {
                      case 1:
                        state = 2;
                        break;
                      case 3:
                        state = 4;
                        offset++;
                        break row;
                      default:
                        state = 0;
                    }
                    break;
                  default:
                    state = 0;
                }
                offset++;
              }
            chunkBytesRead += chunk.byteLength;
            chunkIndex++;
          }
        if (state !== 4) {
          return void 0;
        }
        const buffer = this._read(chunkBytesRead + offset);
        const result = /* @__PURE__ */ new Map();
        const headers = this.toString(buffer, "ascii").split(CRLF);
        if (headers.length < 2) {
          return result;
        }
        for (let i = 0; i < headers.length - 2; i++) {
          const header = headers[i];
          const index = header.indexOf(":");
          if (index === -1) {
            throw new Error(`Message header must separate key and value using ':'
${header}`);
          }
          const key = header.substr(0, index);
          const value = header.substr(index + 1).trim();
          result.set(lowerCaseKeys ? key.toLowerCase() : key, value);
        }
        return result;
      }
      tryReadBody(length) {
        if (this._totalLength < length) {
          return void 0;
        }
        return this._read(length);
      }
      get numberOfBytes() {
        return this._totalLength;
      }
      _read(byteCount) {
        if (byteCount === 0) {
          return this.emptyBuffer();
        }
        if (byteCount > this._totalLength) {
          throw new Error(`Cannot read so many bytes!`);
        }
        if (this._chunks[0].byteLength === byteCount) {
          const chunk = this._chunks[0];
          this._chunks.shift();
          this._totalLength -= byteCount;
          return this.asNative(chunk);
        }
        if (this._chunks[0].byteLength > byteCount) {
          const chunk = this._chunks[0];
          const result2 = this.asNative(chunk, byteCount);
          this._chunks[0] = chunk.slice(byteCount);
          this._totalLength -= byteCount;
          return result2;
        }
        const result = this.allocNative(byteCount);
        let resultOffset = 0;
        let chunkIndex = 0;
        while (byteCount > 0) {
          const chunk = this._chunks[chunkIndex];
          if (chunk.byteLength > byteCount) {
            const chunkPart = chunk.slice(0, byteCount);
            result.set(chunkPart, resultOffset);
            resultOffset += byteCount;
            this._chunks[chunkIndex] = chunk.slice(byteCount);
            this._totalLength -= byteCount;
            byteCount -= byteCount;
          } else {
            result.set(chunk, resultOffset);
            resultOffset += chunk.byteLength;
            this._chunks.shift();
            this._totalLength -= chunk.byteLength;
            byteCount -= chunk.byteLength;
          }
        }
        return result;
      }
    };
    exports2.AbstractMessageBuffer = AbstractMessageBuffer;
  }
});

// node_modules/vscode-jsonrpc/lib/common/connection.js
var require_connection = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/connection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createMessageConnection = exports2.ConnectionOptions = exports2.MessageStrategy = exports2.CancellationStrategy = exports2.CancellationSenderStrategy = exports2.CancellationReceiverStrategy = exports2.RequestCancellationReceiverStrategy = exports2.IdCancellationReceiverStrategy = exports2.ConnectionStrategy = exports2.ConnectionError = exports2.ConnectionErrors = exports2.LogTraceNotification = exports2.SetTraceNotification = exports2.TraceFormat = exports2.TraceValues = exports2.Trace = exports2.NullLogger = exports2.ProgressType = exports2.ProgressToken = void 0;
    var ral_1 = require_ral();
    var Is2 = require_is2();
    var messages_1 = require_messages();
    var linkedMap_1 = require_linkedMap();
    var events_1 = require_events();
    var cancellation_1 = require_cancellation();
    var CancelNotification;
    (function(CancelNotification2) {
      CancelNotification2.type = new messages_1.NotificationType("$/cancelRequest");
    })(CancelNotification || (CancelNotification = {}));
    var ProgressToken;
    (function(ProgressToken2) {
      function is(value) {
        return typeof value === "string" || typeof value === "number";
      }
      ProgressToken2.is = is;
    })(ProgressToken || (exports2.ProgressToken = ProgressToken = {}));
    var ProgressNotification;
    (function(ProgressNotification2) {
      ProgressNotification2.type = new messages_1.NotificationType("$/progress");
    })(ProgressNotification || (ProgressNotification = {}));
    var ProgressType = class {
      constructor() {
      }
    };
    exports2.ProgressType = ProgressType;
    var StarRequestHandler;
    (function(StarRequestHandler2) {
      function is(value) {
        return Is2.func(value);
      }
      StarRequestHandler2.is = is;
    })(StarRequestHandler || (StarRequestHandler = {}));
    exports2.NullLogger = Object.freeze({
      error: () => {
      },
      warn: () => {
      },
      info: () => {
      },
      log: () => {
      }
    });
    var Trace;
    (function(Trace2) {
      Trace2[Trace2["Off"] = 0] = "Off";
      Trace2[Trace2["Messages"] = 1] = "Messages";
      Trace2[Trace2["Compact"] = 2] = "Compact";
      Trace2[Trace2["Verbose"] = 3] = "Verbose";
    })(Trace || (exports2.Trace = Trace = {}));
    var TraceValues;
    (function(TraceValues2) {
      TraceValues2.Off = "off";
      TraceValues2.Messages = "messages";
      TraceValues2.Compact = "compact";
      TraceValues2.Verbose = "verbose";
    })(TraceValues || (exports2.TraceValues = TraceValues = {}));
    (function(Trace2) {
      function fromString(value) {
        if (!Is2.string(value)) {
          return Trace2.Off;
        }
        value = value.toLowerCase();
        switch (value) {
          case "off":
            return Trace2.Off;
          case "messages":
            return Trace2.Messages;
          case "compact":
            return Trace2.Compact;
          case "verbose":
            return Trace2.Verbose;
          default:
            return Trace2.Off;
        }
      }
      Trace2.fromString = fromString;
      function toString(value) {
        switch (value) {
          case Trace2.Off:
            return "off";
          case Trace2.Messages:
            return "messages";
          case Trace2.Compact:
            return "compact";
          case Trace2.Verbose:
            return "verbose";
          default:
            return "off";
        }
      }
      Trace2.toString = toString;
    })(Trace || (exports2.Trace = Trace = {}));
    var TraceFormat;
    (function(TraceFormat2) {
      TraceFormat2["Text"] = "text";
      TraceFormat2["JSON"] = "json";
    })(TraceFormat || (exports2.TraceFormat = TraceFormat = {}));
    (function(TraceFormat2) {
      function fromString(value) {
        if (!Is2.string(value)) {
          return TraceFormat2.Text;
        }
        value = value.toLowerCase();
        if (value === "json") {
          return TraceFormat2.JSON;
        } else {
          return TraceFormat2.Text;
        }
      }
      TraceFormat2.fromString = fromString;
    })(TraceFormat || (exports2.TraceFormat = TraceFormat = {}));
    var SetTraceNotification;
    (function(SetTraceNotification2) {
      SetTraceNotification2.type = new messages_1.NotificationType("$/setTrace");
    })(SetTraceNotification || (exports2.SetTraceNotification = SetTraceNotification = {}));
    var LogTraceNotification;
    (function(LogTraceNotification2) {
      LogTraceNotification2.type = new messages_1.NotificationType("$/logTrace");
    })(LogTraceNotification || (exports2.LogTraceNotification = LogTraceNotification = {}));
    var ConnectionErrors;
    (function(ConnectionErrors2) {
      ConnectionErrors2[ConnectionErrors2["Closed"] = 1] = "Closed";
      ConnectionErrors2[ConnectionErrors2["Disposed"] = 2] = "Disposed";
      ConnectionErrors2[ConnectionErrors2["AlreadyListening"] = 3] = "AlreadyListening";
    })(ConnectionErrors || (exports2.ConnectionErrors = ConnectionErrors = {}));
    var ConnectionError = class _ConnectionError extends Error {
      constructor(code, message) {
        super(message);
        this.code = code;
        Object.setPrototypeOf(this, _ConnectionError.prototype);
      }
    };
    exports2.ConnectionError = ConnectionError;
    var ConnectionStrategy;
    (function(ConnectionStrategy2) {
      function is(value) {
        const candidate = value;
        return candidate && Is2.func(candidate.cancelUndispatched);
      }
      ConnectionStrategy2.is = is;
    })(ConnectionStrategy || (exports2.ConnectionStrategy = ConnectionStrategy = {}));
    var IdCancellationReceiverStrategy;
    (function(IdCancellationReceiverStrategy2) {
      function is(value) {
        const candidate = value;
        return candidate && (candidate.kind === void 0 || candidate.kind === "id") && Is2.func(candidate.createCancellationTokenSource) && (candidate.dispose === void 0 || Is2.func(candidate.dispose));
      }
      IdCancellationReceiverStrategy2.is = is;
    })(IdCancellationReceiverStrategy || (exports2.IdCancellationReceiverStrategy = IdCancellationReceiverStrategy = {}));
    var RequestCancellationReceiverStrategy;
    (function(RequestCancellationReceiverStrategy2) {
      function is(value) {
        const candidate = value;
        return candidate && candidate.kind === "request" && Is2.func(candidate.createCancellationTokenSource) && (candidate.dispose === void 0 || Is2.func(candidate.dispose));
      }
      RequestCancellationReceiverStrategy2.is = is;
    })(RequestCancellationReceiverStrategy || (exports2.RequestCancellationReceiverStrategy = RequestCancellationReceiverStrategy = {}));
    var CancellationReceiverStrategy;
    (function(CancellationReceiverStrategy2) {
      CancellationReceiverStrategy2.Message = Object.freeze({
        createCancellationTokenSource(_) {
          return new cancellation_1.CancellationTokenSource();
        }
      });
      function is(value) {
        return IdCancellationReceiverStrategy.is(value) || RequestCancellationReceiverStrategy.is(value);
      }
      CancellationReceiverStrategy2.is = is;
    })(CancellationReceiverStrategy || (exports2.CancellationReceiverStrategy = CancellationReceiverStrategy = {}));
    var CancellationSenderStrategy;
    (function(CancellationSenderStrategy2) {
      CancellationSenderStrategy2.Message = Object.freeze({
        sendCancellation(conn, id) {
          return conn.sendNotification(CancelNotification.type, { id });
        },
        cleanup(_) {
        }
      });
      function is(value) {
        const candidate = value;
        return candidate && Is2.func(candidate.sendCancellation) && Is2.func(candidate.cleanup);
      }
      CancellationSenderStrategy2.is = is;
    })(CancellationSenderStrategy || (exports2.CancellationSenderStrategy = CancellationSenderStrategy = {}));
    var CancellationStrategy;
    (function(CancellationStrategy2) {
      CancellationStrategy2.Message = Object.freeze({
        receiver: CancellationReceiverStrategy.Message,
        sender: CancellationSenderStrategy.Message
      });
      function is(value) {
        const candidate = value;
        return candidate && CancellationReceiverStrategy.is(candidate.receiver) && CancellationSenderStrategy.is(candidate.sender);
      }
      CancellationStrategy2.is = is;
    })(CancellationStrategy || (exports2.CancellationStrategy = CancellationStrategy = {}));
    var MessageStrategy;
    (function(MessageStrategy2) {
      function is(value) {
        const candidate = value;
        return candidate && Is2.func(candidate.handleMessage);
      }
      MessageStrategy2.is = is;
    })(MessageStrategy || (exports2.MessageStrategy = MessageStrategy = {}));
    var ConnectionOptions;
    (function(ConnectionOptions2) {
      function is(value) {
        const candidate = value;
        return candidate && (CancellationStrategy.is(candidate.cancellationStrategy) || ConnectionStrategy.is(candidate.connectionStrategy) || MessageStrategy.is(candidate.messageStrategy));
      }
      ConnectionOptions2.is = is;
    })(ConnectionOptions || (exports2.ConnectionOptions = ConnectionOptions = {}));
    var ConnectionState;
    (function(ConnectionState2) {
      ConnectionState2[ConnectionState2["New"] = 1] = "New";
      ConnectionState2[ConnectionState2["Listening"] = 2] = "Listening";
      ConnectionState2[ConnectionState2["Closed"] = 3] = "Closed";
      ConnectionState2[ConnectionState2["Disposed"] = 4] = "Disposed";
    })(ConnectionState || (ConnectionState = {}));
    function createMessageConnection(messageReader, messageWriter, _logger, options) {
      const logger = _logger !== void 0 ? _logger : exports2.NullLogger;
      let sequenceNumber = 0;
      let notificationSequenceNumber = 0;
      let unknownResponseSequenceNumber = 0;
      const version = "2.0";
      let starRequestHandler = void 0;
      const requestHandlers = /* @__PURE__ */ new Map();
      let starNotificationHandler = void 0;
      const notificationHandlers = /* @__PURE__ */ new Map();
      const progressHandlers = /* @__PURE__ */ new Map();
      let timer;
      let messageQueue = new linkedMap_1.LinkedMap();
      let responsePromises = /* @__PURE__ */ new Map();
      let knownCanceledRequests = /* @__PURE__ */ new Set();
      let requestTokens = /* @__PURE__ */ new Map();
      let trace = Trace.Off;
      let traceFormat = TraceFormat.Text;
      let tracer;
      let state = ConnectionState.New;
      const errorEmitter = new events_1.Emitter();
      const closeEmitter = new events_1.Emitter();
      const unhandledNotificationEmitter = new events_1.Emitter();
      const unhandledProgressEmitter = new events_1.Emitter();
      const disposeEmitter = new events_1.Emitter();
      const cancellationStrategy = options && options.cancellationStrategy ? options.cancellationStrategy : CancellationStrategy.Message;
      function createRequestQueueKey(id) {
        if (id === null) {
          throw new Error(`Can't send requests with id null since the response can't be correlated.`);
        }
        return "req-" + id.toString();
      }
      function createResponseQueueKey(id) {
        if (id === null) {
          return "res-unknown-" + (++unknownResponseSequenceNumber).toString();
        } else {
          return "res-" + id.toString();
        }
      }
      function createNotificationQueueKey() {
        return "not-" + (++notificationSequenceNumber).toString();
      }
      function addMessageToQueue(queue, message) {
        if (messages_1.Message.isRequest(message)) {
          queue.set(createRequestQueueKey(message.id), message);
        } else if (messages_1.Message.isResponse(message)) {
          queue.set(createResponseQueueKey(message.id), message);
        } else {
          queue.set(createNotificationQueueKey(), message);
        }
      }
      function cancelUndispatched(_message) {
        return void 0;
      }
      function isListening() {
        return state === ConnectionState.Listening;
      }
      function isClosed() {
        return state === ConnectionState.Closed;
      }
      function isDisposed() {
        return state === ConnectionState.Disposed;
      }
      function closeHandler() {
        if (state === ConnectionState.New || state === ConnectionState.Listening) {
          state = ConnectionState.Closed;
          closeEmitter.fire(void 0);
        }
      }
      function readErrorHandler(error) {
        errorEmitter.fire([error, void 0, void 0]);
      }
      function writeErrorHandler(data) {
        errorEmitter.fire(data);
      }
      messageReader.onClose(closeHandler);
      messageReader.onError(readErrorHandler);
      messageWriter.onClose(closeHandler);
      messageWriter.onError(writeErrorHandler);
      function triggerMessageQueue() {
        if (timer || messageQueue.size === 0) {
          return;
        }
        timer = (0, ral_1.default)().timer.setImmediate(() => {
          timer = void 0;
          processMessageQueue();
        });
      }
      function handleMessage(message) {
        if (messages_1.Message.isRequest(message)) {
          handleRequest(message);
        } else if (messages_1.Message.isNotification(message)) {
          handleNotification(message);
        } else if (messages_1.Message.isResponse(message)) {
          handleResponse(message);
        } else {
          handleInvalidMessage(message);
        }
      }
      function processMessageQueue() {
        if (messageQueue.size === 0) {
          return;
        }
        const message = messageQueue.shift();
        try {
          const messageStrategy = options == null ? void 0 : options.messageStrategy;
          if (MessageStrategy.is(messageStrategy)) {
            messageStrategy.handleMessage(message, handleMessage);
          } else {
            handleMessage(message);
          }
        } finally {
          triggerMessageQueue();
        }
      }
      const callback = (message) => {
        try {
          if (messages_1.Message.isNotification(message) && message.method === CancelNotification.type.method) {
            const cancelId = message.params.id;
            const key = createRequestQueueKey(cancelId);
            const toCancel = messageQueue.get(key);
            if (messages_1.Message.isRequest(toCancel)) {
              const strategy = options == null ? void 0 : options.connectionStrategy;
              const response = strategy && strategy.cancelUndispatched ? strategy.cancelUndispatched(toCancel, cancelUndispatched) : cancelUndispatched(toCancel);
              if (response && (response.error !== void 0 || response.result !== void 0)) {
                messageQueue.delete(key);
                requestTokens.delete(cancelId);
                response.id = toCancel.id;
                traceSendingResponse(response, message.method, Date.now());
                messageWriter.write(response).catch(() => logger.error(`Sending response for canceled message failed.`));
                return;
              }
            }
            const cancellationToken = requestTokens.get(cancelId);
            if (cancellationToken !== void 0) {
              cancellationToken.cancel();
              traceReceivedNotification(message);
              return;
            } else {
              knownCanceledRequests.add(cancelId);
            }
          }
          addMessageToQueue(messageQueue, message);
        } finally {
          triggerMessageQueue();
        }
      };
      function handleRequest(requestMessage) {
        var _a3;
        if (isDisposed()) {
          return;
        }
        function reply(resultOrError, method, startTime2) {
          const message = {
            jsonrpc: version,
            id: requestMessage.id
          };
          if (resultOrError instanceof messages_1.ResponseError) {
            message.error = resultOrError.toJson();
          } else {
            message.result = resultOrError === void 0 ? null : resultOrError;
          }
          traceSendingResponse(message, method, startTime2);
          messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
        }
        function replyError(error, method, startTime2) {
          const message = {
            jsonrpc: version,
            id: requestMessage.id,
            error: error.toJson()
          };
          traceSendingResponse(message, method, startTime2);
          messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
        }
        function replySuccess(result, method, startTime2) {
          if (result === void 0) {
            result = null;
          }
          const message = {
            jsonrpc: version,
            id: requestMessage.id,
            result
          };
          traceSendingResponse(message, method, startTime2);
          messageWriter.write(message).catch(() => logger.error(`Sending response failed.`));
        }
        traceReceivedRequest(requestMessage);
        const element = requestHandlers.get(requestMessage.method);
        let type;
        let requestHandler;
        if (element) {
          type = element.type;
          requestHandler = element.handler;
        }
        const startTime = Date.now();
        if (requestHandler || starRequestHandler) {
          const tokenKey = (_a3 = requestMessage.id) != null ? _a3 : String(Date.now());
          const cancellationSource = IdCancellationReceiverStrategy.is(cancellationStrategy.receiver) ? cancellationStrategy.receiver.createCancellationTokenSource(tokenKey) : cancellationStrategy.receiver.createCancellationTokenSource(requestMessage);
          if (requestMessage.id !== null && knownCanceledRequests.has(requestMessage.id)) {
            cancellationSource.cancel();
          }
          if (requestMessage.id !== null) {
            requestTokens.set(tokenKey, cancellationSource);
          }
          try {
            let handlerResult;
            if (requestHandler) {
              if (requestMessage.params === void 0) {
                if (type !== void 0 && type.numberOfParams !== 0) {
                  replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines ${type.numberOfParams} params but received none.`), requestMessage.method, startTime);
                  return;
                }
                handlerResult = requestHandler(cancellationSource.token);
              } else if (Array.isArray(requestMessage.params)) {
                if (type !== void 0 && type.parameterStructures === messages_1.ParameterStructures.byName) {
                  replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines parameters by name but received parameters by position`), requestMessage.method, startTime);
                  return;
                }
                handlerResult = requestHandler(...requestMessage.params, cancellationSource.token);
              } else {
                if (type !== void 0 && type.parameterStructures === messages_1.ParameterStructures.byPosition) {
                  replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InvalidParams, `Request ${requestMessage.method} defines parameters by position but received parameters by name`), requestMessage.method, startTime);
                  return;
                }
                handlerResult = requestHandler(requestMessage.params, cancellationSource.token);
              }
            } else if (starRequestHandler) {
              handlerResult = starRequestHandler(requestMessage.method, requestMessage.params, cancellationSource.token);
            }
            const promise = handlerResult;
            if (!handlerResult) {
              requestTokens.delete(tokenKey);
              replySuccess(handlerResult, requestMessage.method, startTime);
            } else if (promise.then) {
              promise.then((resultOrError) => {
                requestTokens.delete(tokenKey);
                reply(resultOrError, requestMessage.method, startTime);
              }, (error) => {
                requestTokens.delete(tokenKey);
                if (error instanceof messages_1.ResponseError) {
                  replyError(error, requestMessage.method, startTime);
                } else if (error && Is2.string(error.message)) {
                  replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed with message: ${error.message}`), requestMessage.method, startTime);
                } else {
                  replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed unexpectedly without providing any details.`), requestMessage.method, startTime);
                }
              });
            } else {
              requestTokens.delete(tokenKey);
              reply(handlerResult, requestMessage.method, startTime);
            }
          } catch (error) {
            requestTokens.delete(tokenKey);
            if (error instanceof messages_1.ResponseError) {
              reply(error, requestMessage.method, startTime);
            } else if (error && Is2.string(error.message)) {
              replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed with message: ${error.message}`), requestMessage.method, startTime);
            } else {
              replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, `Request ${requestMessage.method} failed unexpectedly without providing any details.`), requestMessage.method, startTime);
            }
          }
        } else {
          replyError(new messages_1.ResponseError(messages_1.ErrorCodes.MethodNotFound, `Unhandled method ${requestMessage.method}`), requestMessage.method, startTime);
        }
      }
      function handleResponse(responseMessage) {
        if (isDisposed()) {
          return;
        }
        if (responseMessage.id === null) {
          if (responseMessage.error) {
            logger.error(`Received response message without id: Error is: 
${JSON.stringify(responseMessage.error, void 0, 4)}`);
          } else {
            logger.error(`Received response message without id. No further error information provided.`);
          }
        } else {
          const key = responseMessage.id;
          const responsePromise = responsePromises.get(key);
          traceReceivedResponse(responseMessage, responsePromise);
          if (responsePromise !== void 0) {
            responsePromises.delete(key);
            try {
              if (responseMessage.error) {
                const error = responseMessage.error;
                responsePromise.reject(new messages_1.ResponseError(error.code, error.message, error.data));
              } else if (responseMessage.result !== void 0) {
                responsePromise.resolve(responseMessage.result);
              } else {
                throw new Error("Should never happen.");
              }
            } catch (error) {
              if (error.message) {
                logger.error(`Response handler '${responsePromise.method}' failed with message: ${error.message}`);
              } else {
                logger.error(`Response handler '${responsePromise.method}' failed unexpectedly.`);
              }
            }
          }
        }
      }
      function handleNotification(message) {
        if (isDisposed()) {
          return;
        }
        let type = void 0;
        let notificationHandler;
        if (message.method === CancelNotification.type.method) {
          const cancelId = message.params.id;
          knownCanceledRequests.delete(cancelId);
          traceReceivedNotification(message);
          return;
        } else {
          const element = notificationHandlers.get(message.method);
          if (element) {
            notificationHandler = element.handler;
            type = element.type;
          }
        }
        if (notificationHandler || starNotificationHandler) {
          try {
            traceReceivedNotification(message);
            if (notificationHandler) {
              if (message.params === void 0) {
                if (type !== void 0) {
                  if (type.numberOfParams !== 0 && type.parameterStructures !== messages_1.ParameterStructures.byName) {
                    logger.error(`Notification ${message.method} defines ${type.numberOfParams} params but received none.`);
                  }
                }
                notificationHandler();
              } else if (Array.isArray(message.params)) {
                const params = message.params;
                if (message.method === ProgressNotification.type.method && params.length === 2 && ProgressToken.is(params[0])) {
                  notificationHandler({ token: params[0], value: params[1] });
                } else {
                  if (type !== void 0) {
                    if (type.parameterStructures === messages_1.ParameterStructures.byName) {
                      logger.error(`Notification ${message.method} defines parameters by name but received parameters by position`);
                    }
                    if (type.numberOfParams !== message.params.length) {
                      logger.error(`Notification ${message.method} defines ${type.numberOfParams} params but received ${params.length} arguments`);
                    }
                  }
                  notificationHandler(...params);
                }
              } else {
                if (type !== void 0 && type.parameterStructures === messages_1.ParameterStructures.byPosition) {
                  logger.error(`Notification ${message.method} defines parameters by position but received parameters by name`);
                }
                notificationHandler(message.params);
              }
            } else if (starNotificationHandler) {
              starNotificationHandler(message.method, message.params);
            }
          } catch (error) {
            if (error.message) {
              logger.error(`Notification handler '${message.method}' failed with message: ${error.message}`);
            } else {
              logger.error(`Notification handler '${message.method}' failed unexpectedly.`);
            }
          }
        } else {
          unhandledNotificationEmitter.fire(message);
        }
      }
      function handleInvalidMessage(message) {
        if (!message) {
          logger.error("Received empty message.");
          return;
        }
        logger.error(`Received message which is neither a response nor a notification message:
${JSON.stringify(message, null, 4)}`);
        const responseMessage = message;
        if (Is2.string(responseMessage.id) || Is2.number(responseMessage.id)) {
          const key = responseMessage.id;
          const responseHandler = responsePromises.get(key);
          if (responseHandler) {
            responseHandler.reject(new Error("The received response has neither a result nor an error property."));
          }
        }
      }
      function stringifyTrace(params) {
        if (params === void 0 || params === null) {
          return void 0;
        }
        switch (trace) {
          case Trace.Verbose:
            return JSON.stringify(params, null, 4);
          case Trace.Compact:
            return JSON.stringify(params);
          default:
            return void 0;
        }
      }
      function traceSendingRequest(message) {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if ((trace === Trace.Verbose || trace === Trace.Compact) && message.params) {
            data = `Params: ${stringifyTrace(message.params)}

`;
          }
          tracer.log(`Sending request '${message.method} - (${message.id})'.`, data);
        } else {
          logLSPMessage("send-request", message);
        }
      }
      function traceSendingNotification(message) {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if (trace === Trace.Verbose || trace === Trace.Compact) {
            if (message.params) {
              data = `Params: ${stringifyTrace(message.params)}

`;
            } else {
              data = "No parameters provided.\n\n";
            }
          }
          tracer.log(`Sending notification '${message.method}'.`, data);
        } else {
          logLSPMessage("send-notification", message);
        }
      }
      function traceSendingResponse(message, method, startTime) {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if (trace === Trace.Verbose || trace === Trace.Compact) {
            if (message.error && message.error.data) {
              data = `Error data: ${stringifyTrace(message.error.data)}

`;
            } else {
              if (message.result) {
                data = `Result: ${stringifyTrace(message.result)}

`;
              } else if (message.error === void 0) {
                data = "No result returned.\n\n";
              }
            }
          }
          tracer.log(`Sending response '${method} - (${message.id})'. Processing request took ${Date.now() - startTime}ms`, data);
        } else {
          logLSPMessage("send-response", message);
        }
      }
      function traceReceivedRequest(message) {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if ((trace === Trace.Verbose || trace === Trace.Compact) && message.params) {
            data = `Params: ${stringifyTrace(message.params)}

`;
          }
          tracer.log(`Received request '${message.method} - (${message.id})'.`, data);
        } else {
          logLSPMessage("receive-request", message);
        }
      }
      function traceReceivedNotification(message) {
        if (trace === Trace.Off || !tracer || message.method === LogTraceNotification.type.method) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if (trace === Trace.Verbose || trace === Trace.Compact) {
            if (message.params) {
              data = `Params: ${stringifyTrace(message.params)}

`;
            } else {
              data = "No parameters provided.\n\n";
            }
          }
          tracer.log(`Received notification '${message.method}'.`, data);
        } else {
          logLSPMessage("receive-notification", message);
        }
      }
      function traceReceivedResponse(message, responsePromise) {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        if (traceFormat === TraceFormat.Text) {
          let data = void 0;
          if (trace === Trace.Verbose || trace === Trace.Compact) {
            if (message.error && message.error.data) {
              data = `Error data: ${stringifyTrace(message.error.data)}

`;
            } else {
              if (message.result) {
                data = `Result: ${stringifyTrace(message.result)}

`;
              } else if (message.error === void 0) {
                data = "No result returned.\n\n";
              }
            }
          }
          if (responsePromise) {
            const error = message.error ? ` Request failed: ${message.error.message} (${message.error.code}).` : "";
            tracer.log(`Received response '${responsePromise.method} - (${message.id})' in ${Date.now() - responsePromise.timerStart}ms.${error}`, data);
          } else {
            tracer.log(`Received response ${message.id} without active response promise.`, data);
          }
        } else {
          logLSPMessage("receive-response", message);
        }
      }
      function logLSPMessage(type, message) {
        if (!tracer || trace === Trace.Off) {
          return;
        }
        const lspMessage = {
          isLSPMessage: true,
          type,
          message,
          timestamp: Date.now()
        };
        tracer.log(lspMessage);
      }
      function throwIfClosedOrDisposed() {
        if (isClosed()) {
          throw new ConnectionError(ConnectionErrors.Closed, "Connection is closed.");
        }
        if (isDisposed()) {
          throw new ConnectionError(ConnectionErrors.Disposed, "Connection is disposed.");
        }
      }
      function throwIfListening() {
        if (isListening()) {
          throw new ConnectionError(ConnectionErrors.AlreadyListening, "Connection is already listening");
        }
      }
      function throwIfNotListening() {
        if (!isListening()) {
          throw new Error("Call listen() first.");
        }
      }
      function undefinedToNull(param) {
        if (param === void 0) {
          return null;
        } else {
          return param;
        }
      }
      function nullToUndefined(param) {
        if (param === null) {
          return void 0;
        } else {
          return param;
        }
      }
      function isNamedParam(param) {
        return param !== void 0 && param !== null && !Array.isArray(param) && typeof param === "object";
      }
      function computeSingleParam(parameterStructures, param) {
        switch (parameterStructures) {
          case messages_1.ParameterStructures.auto:
            if (isNamedParam(param)) {
              return nullToUndefined(param);
            } else {
              return [undefinedToNull(param)];
            }
          case messages_1.ParameterStructures.byName:
            if (!isNamedParam(param)) {
              throw new Error(`Received parameters by name but param is not an object literal.`);
            }
            return nullToUndefined(param);
          case messages_1.ParameterStructures.byPosition:
            return [undefinedToNull(param)];
          default:
            throw new Error(`Unknown parameter structure ${parameterStructures.toString()}`);
        }
      }
      function computeMessageParams(type, params) {
        let result;
        const numberOfParams = type.numberOfParams;
        switch (numberOfParams) {
          case 0:
            result = void 0;
            break;
          case 1:
            result = computeSingleParam(type.parameterStructures, params[0]);
            break;
          default:
            result = [];
            for (let i = 0; i < params.length && i < numberOfParams; i++) {
              result.push(undefinedToNull(params[i]));
            }
            if (params.length < numberOfParams) {
              for (let i = params.length; i < numberOfParams; i++) {
                result.push(null);
              }
            }
            break;
        }
        return result;
      }
      const connection2 = {
        sendNotification: (type, ...args) => {
          throwIfClosedOrDisposed();
          let method;
          let messageParams;
          if (Is2.string(type)) {
            method = type;
            const first = args[0];
            let paramStart = 0;
            let parameterStructures = messages_1.ParameterStructures.auto;
            if (messages_1.ParameterStructures.is(first)) {
              paramStart = 1;
              parameterStructures = first;
            }
            let paramEnd = args.length;
            const numberOfParams = paramEnd - paramStart;
            switch (numberOfParams) {
              case 0:
                messageParams = void 0;
                break;
              case 1:
                messageParams = computeSingleParam(parameterStructures, args[paramStart]);
                break;
              default:
                if (parameterStructures === messages_1.ParameterStructures.byName) {
                  throw new Error(`Received ${numberOfParams} parameters for 'by Name' notification parameter structure.`);
                }
                messageParams = args.slice(paramStart, paramEnd).map((value) => undefinedToNull(value));
                break;
            }
          } else {
            const params = args;
            method = type.method;
            messageParams = computeMessageParams(type, params);
          }
          const notificationMessage = {
            jsonrpc: version,
            method,
            params: messageParams
          };
          traceSendingNotification(notificationMessage);
          return messageWriter.write(notificationMessage).catch((error) => {
            logger.error(`Sending notification failed.`);
            throw error;
          });
        },
        onNotification: (type, handler) => {
          throwIfClosedOrDisposed();
          let method;
          if (Is2.func(type)) {
            starNotificationHandler = type;
          } else if (handler) {
            if (Is2.string(type)) {
              method = type;
              notificationHandlers.set(type, { type: void 0, handler });
            } else {
              method = type.method;
              notificationHandlers.set(type.method, { type, handler });
            }
          }
          return {
            dispose: () => {
              if (method !== void 0) {
                notificationHandlers.delete(method);
              } else {
                starNotificationHandler = void 0;
              }
            }
          };
        },
        onProgress: (_type, token, handler) => {
          if (progressHandlers.has(token)) {
            throw new Error(`Progress handler for token ${token} already registered`);
          }
          progressHandlers.set(token, handler);
          return {
            dispose: () => {
              progressHandlers.delete(token);
            }
          };
        },
        sendProgress: (_type, token, value) => {
          return connection2.sendNotification(ProgressNotification.type, { token, value });
        },
        onUnhandledProgress: unhandledProgressEmitter.event,
        sendRequest: (type, ...args) => {
          throwIfClosedOrDisposed();
          throwIfNotListening();
          let method;
          let messageParams;
          let token = void 0;
          if (Is2.string(type)) {
            method = type;
            const first = args[0];
            const last = args[args.length - 1];
            let paramStart = 0;
            let parameterStructures = messages_1.ParameterStructures.auto;
            if (messages_1.ParameterStructures.is(first)) {
              paramStart = 1;
              parameterStructures = first;
            }
            let paramEnd = args.length;
            if (cancellation_1.CancellationToken.is(last)) {
              paramEnd = paramEnd - 1;
              token = last;
            }
            const numberOfParams = paramEnd - paramStart;
            switch (numberOfParams) {
              case 0:
                messageParams = void 0;
                break;
              case 1:
                messageParams = computeSingleParam(parameterStructures, args[paramStart]);
                break;
              default:
                if (parameterStructures === messages_1.ParameterStructures.byName) {
                  throw new Error(`Received ${numberOfParams} parameters for 'by Name' request parameter structure.`);
                }
                messageParams = args.slice(paramStart, paramEnd).map((value) => undefinedToNull(value));
                break;
            }
          } else {
            const params = args;
            method = type.method;
            messageParams = computeMessageParams(type, params);
            const numberOfParams = type.numberOfParams;
            token = cancellation_1.CancellationToken.is(params[numberOfParams]) ? params[numberOfParams] : void 0;
          }
          const id = sequenceNumber++;
          let disposable;
          if (token) {
            disposable = token.onCancellationRequested(() => {
              const p = cancellationStrategy.sender.sendCancellation(connection2, id);
              if (p === void 0) {
                logger.log(`Received no promise from cancellation strategy when cancelling id ${id}`);
                return Promise.resolve();
              } else {
                return p.catch(() => {
                  logger.log(`Sending cancellation messages for id ${id} failed`);
                });
              }
            });
          }
          const requestMessage = {
            jsonrpc: version,
            id,
            method,
            params: messageParams
          };
          traceSendingRequest(requestMessage);
          if (typeof cancellationStrategy.sender.enableCancellation === "function") {
            cancellationStrategy.sender.enableCancellation(requestMessage);
          }
          return new Promise((resolve, reject) => __async(this, null, function* () {
            const resolveWithCleanup = (r) => {
              resolve(r);
              cancellationStrategy.sender.cleanup(id);
              disposable == null ? void 0 : disposable.dispose();
            };
            const rejectWithCleanup = (r) => {
              reject(r);
              cancellationStrategy.sender.cleanup(id);
              disposable == null ? void 0 : disposable.dispose();
            };
            const responsePromise = { method, timerStart: Date.now(), resolve: resolveWithCleanup, reject: rejectWithCleanup };
            try {
              yield messageWriter.write(requestMessage);
              responsePromises.set(id, responsePromise);
            } catch (error) {
              logger.error(`Sending request failed.`);
              responsePromise.reject(new messages_1.ResponseError(messages_1.ErrorCodes.MessageWriteError, error.message ? error.message : "Unknown reason"));
              throw error;
            }
          }));
        },
        onRequest: (type, handler) => {
          throwIfClosedOrDisposed();
          let method = null;
          if (StarRequestHandler.is(type)) {
            method = void 0;
            starRequestHandler = type;
          } else if (Is2.string(type)) {
            method = null;
            if (handler !== void 0) {
              method = type;
              requestHandlers.set(type, { handler, type: void 0 });
            }
          } else {
            if (handler !== void 0) {
              method = type.method;
              requestHandlers.set(type.method, { type, handler });
            }
          }
          return {
            dispose: () => {
              if (method === null) {
                return;
              }
              if (method !== void 0) {
                requestHandlers.delete(method);
              } else {
                starRequestHandler = void 0;
              }
            }
          };
        },
        hasPendingResponse: () => {
          return responsePromises.size > 0;
        },
        trace: (_value, _tracer, sendNotificationOrTraceOptions) => __async(this, null, function* () {
          let _sendNotification = false;
          let _traceFormat = TraceFormat.Text;
          if (sendNotificationOrTraceOptions !== void 0) {
            if (Is2.boolean(sendNotificationOrTraceOptions)) {
              _sendNotification = sendNotificationOrTraceOptions;
            } else {
              _sendNotification = sendNotificationOrTraceOptions.sendNotification || false;
              _traceFormat = sendNotificationOrTraceOptions.traceFormat || TraceFormat.Text;
            }
          }
          trace = _value;
          traceFormat = _traceFormat;
          if (trace === Trace.Off) {
            tracer = void 0;
          } else {
            tracer = _tracer;
          }
          if (_sendNotification && !isClosed() && !isDisposed()) {
            yield connection2.sendNotification(SetTraceNotification.type, { value: Trace.toString(_value) });
          }
        }),
        onError: errorEmitter.event,
        onClose: closeEmitter.event,
        onUnhandledNotification: unhandledNotificationEmitter.event,
        onDispose: disposeEmitter.event,
        end: () => {
          messageWriter.end();
        },
        dispose: () => {
          if (isDisposed()) {
            return;
          }
          state = ConnectionState.Disposed;
          disposeEmitter.fire(void 0);
          const error = new messages_1.ResponseError(messages_1.ErrorCodes.PendingResponseRejected, "Pending response rejected since connection got disposed");
          for (const promise of responsePromises.values()) {
            promise.reject(error);
          }
          responsePromises = /* @__PURE__ */ new Map();
          requestTokens = /* @__PURE__ */ new Map();
          knownCanceledRequests = /* @__PURE__ */ new Set();
          messageQueue = new linkedMap_1.LinkedMap();
          if (Is2.func(messageWriter.dispose)) {
            messageWriter.dispose();
          }
          if (Is2.func(messageReader.dispose)) {
            messageReader.dispose();
          }
        },
        listen: () => {
          throwIfClosedOrDisposed();
          throwIfListening();
          state = ConnectionState.Listening;
          messageReader.listen(callback);
        },
        inspect: () => {
          (0, ral_1.default)().console.log("inspect");
        }
      };
      connection2.onNotification(LogTraceNotification.type, (params) => {
        if (trace === Trace.Off || !tracer) {
          return;
        }
        const verbose = trace === Trace.Verbose || trace === Trace.Compact;
        tracer.log(params.message, verbose ? params.verbose : void 0);
      });
      connection2.onNotification(ProgressNotification.type, (params) => {
        const handler = progressHandlers.get(params.token);
        if (handler) {
          handler(params.value);
        } else {
          unhandledProgressEmitter.fire(params);
        }
      });
      return connection2;
    }
    exports2.createMessageConnection = createMessageConnection;
  }
});

// node_modules/vscode-jsonrpc/lib/common/api.js
var require_api = __commonJS({
  "node_modules/vscode-jsonrpc/lib/common/api.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ProgressType = exports2.ProgressToken = exports2.createMessageConnection = exports2.NullLogger = exports2.ConnectionOptions = exports2.ConnectionStrategy = exports2.AbstractMessageBuffer = exports2.WriteableStreamMessageWriter = exports2.AbstractMessageWriter = exports2.MessageWriter = exports2.ReadableStreamMessageReader = exports2.AbstractMessageReader = exports2.MessageReader = exports2.SharedArrayReceiverStrategy = exports2.SharedArraySenderStrategy = exports2.CancellationToken = exports2.CancellationTokenSource = exports2.Emitter = exports2.Event = exports2.Disposable = exports2.LRUCache = exports2.Touch = exports2.LinkedMap = exports2.ParameterStructures = exports2.NotificationType9 = exports2.NotificationType8 = exports2.NotificationType7 = exports2.NotificationType6 = exports2.NotificationType5 = exports2.NotificationType4 = exports2.NotificationType3 = exports2.NotificationType2 = exports2.NotificationType1 = exports2.NotificationType0 = exports2.NotificationType = exports2.ErrorCodes = exports2.ResponseError = exports2.RequestType9 = exports2.RequestType8 = exports2.RequestType7 = exports2.RequestType6 = exports2.RequestType5 = exports2.RequestType4 = exports2.RequestType3 = exports2.RequestType2 = exports2.RequestType1 = exports2.RequestType0 = exports2.RequestType = exports2.Message = exports2.RAL = void 0;
    exports2.MessageStrategy = exports2.CancellationStrategy = exports2.CancellationSenderStrategy = exports2.CancellationReceiverStrategy = exports2.ConnectionError = exports2.ConnectionErrors = exports2.LogTraceNotification = exports2.SetTraceNotification = exports2.TraceFormat = exports2.TraceValues = exports2.Trace = void 0;
    var messages_1 = require_messages();
    Object.defineProperty(exports2, "Message", { enumerable: true, get: function() {
      return messages_1.Message;
    } });
    Object.defineProperty(exports2, "RequestType", { enumerable: true, get: function() {
      return messages_1.RequestType;
    } });
    Object.defineProperty(exports2, "RequestType0", { enumerable: true, get: function() {
      return messages_1.RequestType0;
    } });
    Object.defineProperty(exports2, "RequestType1", { enumerable: true, get: function() {
      return messages_1.RequestType1;
    } });
    Object.defineProperty(exports2, "RequestType2", { enumerable: true, get: function() {
      return messages_1.RequestType2;
    } });
    Object.defineProperty(exports2, "RequestType3", { enumerable: true, get: function() {
      return messages_1.RequestType3;
    } });
    Object.defineProperty(exports2, "RequestType4", { enumerable: true, get: function() {
      return messages_1.RequestType4;
    } });
    Object.defineProperty(exports2, "RequestType5", { enumerable: true, get: function() {
      return messages_1.RequestType5;
    } });
    Object.defineProperty(exports2, "RequestType6", { enumerable: true, get: function() {
      return messages_1.RequestType6;
    } });
    Object.defineProperty(exports2, "RequestType7", { enumerable: true, get: function() {
      return messages_1.RequestType7;
    } });
    Object.defineProperty(exports2, "RequestType8", { enumerable: true, get: function() {
      return messages_1.RequestType8;
    } });
    Object.defineProperty(exports2, "RequestType9", { enumerable: true, get: function() {
      return messages_1.RequestType9;
    } });
    Object.defineProperty(exports2, "ResponseError", { enumerable: true, get: function() {
      return messages_1.ResponseError;
    } });
    Object.defineProperty(exports2, "ErrorCodes", { enumerable: true, get: function() {
      return messages_1.ErrorCodes;
    } });
    Object.defineProperty(exports2, "NotificationType", { enumerable: true, get: function() {
      return messages_1.NotificationType;
    } });
    Object.defineProperty(exports2, "NotificationType0", { enumerable: true, get: function() {
      return messages_1.NotificationType0;
    } });
    Object.defineProperty(exports2, "NotificationType1", { enumerable: true, get: function() {
      return messages_1.NotificationType1;
    } });
    Object.defineProperty(exports2, "NotificationType2", { enumerable: true, get: function() {
      return messages_1.NotificationType2;
    } });
    Object.defineProperty(exports2, "NotificationType3", { enumerable: true, get: function() {
      return messages_1.NotificationType3;
    } });
    Object.defineProperty(exports2, "NotificationType4", { enumerable: true, get: function() {
      return messages_1.NotificationType4;
    } });
    Object.defineProperty(exports2, "NotificationType5", { enumerable: true, get: function() {
      return messages_1.NotificationType5;
    } });
    Object.defineProperty(exports2, "NotificationType6", { enumerable: true, get: function() {
      return messages_1.NotificationType6;
    } });
    Object.defineProperty(exports2, "NotificationType7", { enumerable: true, get: function() {
      return messages_1.NotificationType7;
    } });
    Object.defineProperty(exports2, "NotificationType8", { enumerable: true, get: function() {
      return messages_1.NotificationType8;
    } });
    Object.defineProperty(exports2, "NotificationType9", { enumerable: true, get: function() {
      return messages_1.NotificationType9;
    } });
    Object.defineProperty(exports2, "ParameterStructures", { enumerable: true, get: function() {
      return messages_1.ParameterStructures;
    } });
    var linkedMap_1 = require_linkedMap();
    Object.defineProperty(exports2, "LinkedMap", { enumerable: true, get: function() {
      return linkedMap_1.LinkedMap;
    } });
    Object.defineProperty(exports2, "LRUCache", { enumerable: true, get: function() {
      return linkedMap_1.LRUCache;
    } });
    Object.defineProperty(exports2, "Touch", { enumerable: true, get: function() {
      return linkedMap_1.Touch;
    } });
    var disposable_1 = require_disposable();
    Object.defineProperty(exports2, "Disposable", { enumerable: true, get: function() {
      return disposable_1.Disposable;
    } });
    var events_1 = require_events();
    Object.defineProperty(exports2, "Event", { enumerable: true, get: function() {
      return events_1.Event;
    } });
    Object.defineProperty(exports2, "Emitter", { enumerable: true, get: function() {
      return events_1.Emitter;
    } });
    var cancellation_1 = require_cancellation();
    Object.defineProperty(exports2, "CancellationTokenSource", { enumerable: true, get: function() {
      return cancellation_1.CancellationTokenSource;
    } });
    Object.defineProperty(exports2, "CancellationToken", { enumerable: true, get: function() {
      return cancellation_1.CancellationToken;
    } });
    var sharedArrayCancellation_1 = require_sharedArrayCancellation();
    Object.defineProperty(exports2, "SharedArraySenderStrategy", { enumerable: true, get: function() {
      return sharedArrayCancellation_1.SharedArraySenderStrategy;
    } });
    Object.defineProperty(exports2, "SharedArrayReceiverStrategy", { enumerable: true, get: function() {
      return sharedArrayCancellation_1.SharedArrayReceiverStrategy;
    } });
    var messageReader_1 = require_messageReader();
    Object.defineProperty(exports2, "MessageReader", { enumerable: true, get: function() {
      return messageReader_1.MessageReader;
    } });
    Object.defineProperty(exports2, "AbstractMessageReader", { enumerable: true, get: function() {
      return messageReader_1.AbstractMessageReader;
    } });
    Object.defineProperty(exports2, "ReadableStreamMessageReader", { enumerable: true, get: function() {
      return messageReader_1.ReadableStreamMessageReader;
    } });
    var messageWriter_1 = require_messageWriter();
    Object.defineProperty(exports2, "MessageWriter", { enumerable: true, get: function() {
      return messageWriter_1.MessageWriter;
    } });
    Object.defineProperty(exports2, "AbstractMessageWriter", { enumerable: true, get: function() {
      return messageWriter_1.AbstractMessageWriter;
    } });
    Object.defineProperty(exports2, "WriteableStreamMessageWriter", { enumerable: true, get: function() {
      return messageWriter_1.WriteableStreamMessageWriter;
    } });
    var messageBuffer_1 = require_messageBuffer();
    Object.defineProperty(exports2, "AbstractMessageBuffer", { enumerable: true, get: function() {
      return messageBuffer_1.AbstractMessageBuffer;
    } });
    var connection_1 = require_connection();
    Object.defineProperty(exports2, "ConnectionStrategy", { enumerable: true, get: function() {
      return connection_1.ConnectionStrategy;
    } });
    Object.defineProperty(exports2, "ConnectionOptions", { enumerable: true, get: function() {
      return connection_1.ConnectionOptions;
    } });
    Object.defineProperty(exports2, "NullLogger", { enumerable: true, get: function() {
      return connection_1.NullLogger;
    } });
    Object.defineProperty(exports2, "createMessageConnection", { enumerable: true, get: function() {
      return connection_1.createMessageConnection;
    } });
    Object.defineProperty(exports2, "ProgressToken", { enumerable: true, get: function() {
      return connection_1.ProgressToken;
    } });
    Object.defineProperty(exports2, "ProgressType", { enumerable: true, get: function() {
      return connection_1.ProgressType;
    } });
    Object.defineProperty(exports2, "Trace", { enumerable: true, get: function() {
      return connection_1.Trace;
    } });
    Object.defineProperty(exports2, "TraceValues", { enumerable: true, get: function() {
      return connection_1.TraceValues;
    } });
    Object.defineProperty(exports2, "TraceFormat", { enumerable: true, get: function() {
      return connection_1.TraceFormat;
    } });
    Object.defineProperty(exports2, "SetTraceNotification", { enumerable: true, get: function() {
      return connection_1.SetTraceNotification;
    } });
    Object.defineProperty(exports2, "LogTraceNotification", { enumerable: true, get: function() {
      return connection_1.LogTraceNotification;
    } });
    Object.defineProperty(exports2, "ConnectionErrors", { enumerable: true, get: function() {
      return connection_1.ConnectionErrors;
    } });
    Object.defineProperty(exports2, "ConnectionError", { enumerable: true, get: function() {
      return connection_1.ConnectionError;
    } });
    Object.defineProperty(exports2, "CancellationReceiverStrategy", { enumerable: true, get: function() {
      return connection_1.CancellationReceiverStrategy;
    } });
    Object.defineProperty(exports2, "CancellationSenderStrategy", { enumerable: true, get: function() {
      return connection_1.CancellationSenderStrategy;
    } });
    Object.defineProperty(exports2, "CancellationStrategy", { enumerable: true, get: function() {
      return connection_1.CancellationStrategy;
    } });
    Object.defineProperty(exports2, "MessageStrategy", { enumerable: true, get: function() {
      return connection_1.MessageStrategy;
    } });
    var ral_1 = require_ral();
    exports2.RAL = ral_1.default;
  }
});

// node_modules/vscode-jsonrpc/lib/node/ril.js
var require_ril = __commonJS({
  "node_modules/vscode-jsonrpc/lib/node/ril.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var util_1 = require("util");
    var api_1 = require_api();
    var MessageBuffer = class _MessageBuffer extends api_1.AbstractMessageBuffer {
      constructor(encoding = "utf-8") {
        super(encoding);
      }
      emptyBuffer() {
        return _MessageBuffer.emptyBuffer;
      }
      fromString(value, encoding) {
        return Buffer.from(value, encoding);
      }
      toString(value, encoding) {
        if (value instanceof Buffer) {
          return value.toString(encoding);
        } else {
          return new util_1.TextDecoder(encoding).decode(value);
        }
      }
      asNative(buffer, length) {
        if (length === void 0) {
          return buffer instanceof Buffer ? buffer : Buffer.from(buffer);
        } else {
          return buffer instanceof Buffer ? buffer.slice(0, length) : Buffer.from(buffer, 0, length);
        }
      }
      allocNative(length) {
        return Buffer.allocUnsafe(length);
      }
    };
    MessageBuffer.emptyBuffer = Buffer.allocUnsafe(0);
    var ReadableStreamWrapper = class {
      constructor(stream) {
        this.stream = stream;
      }
      onClose(listener) {
        this.stream.on("close", listener);
        return api_1.Disposable.create(() => this.stream.off("close", listener));
      }
      onError(listener) {
        this.stream.on("error", listener);
        return api_1.Disposable.create(() => this.stream.off("error", listener));
      }
      onEnd(listener) {
        this.stream.on("end", listener);
        return api_1.Disposable.create(() => this.stream.off("end", listener));
      }
      onData(listener) {
        this.stream.on("data", listener);
        return api_1.Disposable.create(() => this.stream.off("data", listener));
      }
    };
    var WritableStreamWrapper = class {
      constructor(stream) {
        this.stream = stream;
      }
      onClose(listener) {
        this.stream.on("close", listener);
        return api_1.Disposable.create(() => this.stream.off("close", listener));
      }
      onError(listener) {
        this.stream.on("error", listener);
        return api_1.Disposable.create(() => this.stream.off("error", listener));
      }
      onEnd(listener) {
        this.stream.on("end", listener);
        return api_1.Disposable.create(() => this.stream.off("end", listener));
      }
      write(data, encoding) {
        return new Promise((resolve, reject) => {
          const callback = (error) => {
            if (error === void 0 || error === null) {
              resolve();
            } else {
              reject(error);
            }
          };
          if (typeof data === "string") {
            this.stream.write(data, encoding, callback);
          } else {
            this.stream.write(data, callback);
          }
        });
      }
      end() {
        this.stream.end();
      }
    };
    var _ril = Object.freeze({
      messageBuffer: Object.freeze({
        create: (encoding) => new MessageBuffer(encoding)
      }),
      applicationJson: Object.freeze({
        encoder: Object.freeze({
          name: "application/json",
          encode: (msg, options) => {
            try {
              return Promise.resolve(Buffer.from(JSON.stringify(msg, void 0, 0), options.charset));
            } catch (err) {
              return Promise.reject(err);
            }
          }
        }),
        decoder: Object.freeze({
          name: "application/json",
          decode: (buffer, options) => {
            try {
              if (buffer instanceof Buffer) {
                return Promise.resolve(JSON.parse(buffer.toString(options.charset)));
              } else {
                return Promise.resolve(JSON.parse(new util_1.TextDecoder(options.charset).decode(buffer)));
              }
            } catch (err) {
              return Promise.reject(err);
            }
          }
        })
      }),
      stream: Object.freeze({
        asReadableStream: (stream) => new ReadableStreamWrapper(stream),
        asWritableStream: (stream) => new WritableStreamWrapper(stream)
      }),
      console,
      timer: Object.freeze({
        setTimeout(callback, ms, ...args) {
          const handle = setTimeout(callback, ms, ...args);
          return { dispose: () => clearTimeout(handle) };
        },
        setImmediate(callback, ...args) {
          const handle = setImmediate(callback, ...args);
          return { dispose: () => clearImmediate(handle) };
        },
        setInterval(callback, ms, ...args) {
          const handle = setInterval(callback, ms, ...args);
          return { dispose: () => clearInterval(handle) };
        }
      })
    });
    function RIL() {
      return _ril;
    }
    (function(RIL2) {
      function install() {
        api_1.RAL.install(_ril);
      }
      RIL2.install = install;
    })(RIL || (RIL = {}));
    exports2.default = RIL;
  }
});

// node_modules/vscode-jsonrpc/lib/node/main.js
var require_main = __commonJS({
  "node_modules/vscode-jsonrpc/lib/node/main.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createMessageConnection = exports2.createServerSocketTransport = exports2.createClientSocketTransport = exports2.createServerPipeTransport = exports2.createClientPipeTransport = exports2.generateRandomPipeName = exports2.StreamMessageWriter = exports2.StreamMessageReader = exports2.SocketMessageWriter = exports2.SocketMessageReader = exports2.PortMessageWriter = exports2.PortMessageReader = exports2.IPCMessageWriter = exports2.IPCMessageReader = void 0;
    var ril_1 = require_ril();
    ril_1.default.install();
    var path = require("path");
    var os = require("os");
    var crypto_1 = require("crypto");
    var net_1 = require("net");
    var api_1 = require_api();
    __exportStar(require_api(), exports2);
    var IPCMessageReader = class extends api_1.AbstractMessageReader {
      constructor(process2) {
        super();
        this.process = process2;
        let eventEmitter = this.process;
        eventEmitter.on("error", (error) => this.fireError(error));
        eventEmitter.on("close", () => this.fireClose());
      }
      listen(callback) {
        this.process.on("message", callback);
        return api_1.Disposable.create(() => this.process.off("message", callback));
      }
    };
    exports2.IPCMessageReader = IPCMessageReader;
    var IPCMessageWriter = class extends api_1.AbstractMessageWriter {
      constructor(process2) {
        super();
        this.process = process2;
        this.errorCount = 0;
        const eventEmitter = this.process;
        eventEmitter.on("error", (error) => this.fireError(error));
        eventEmitter.on("close", () => this.fireClose);
      }
      write(msg) {
        try {
          if (typeof this.process.send === "function") {
            this.process.send(msg, void 0, void 0, (error) => {
              if (error) {
                this.errorCount++;
                this.handleError(error, msg);
              } else {
                this.errorCount = 0;
              }
            });
          }
          return Promise.resolve();
        } catch (error) {
          this.handleError(error, msg);
          return Promise.reject(error);
        }
      }
      handleError(error, msg) {
        this.errorCount++;
        this.fireError(error, msg, this.errorCount);
      }
      end() {
      }
    };
    exports2.IPCMessageWriter = IPCMessageWriter;
    var PortMessageReader = class extends api_1.AbstractMessageReader {
      constructor(port) {
        super();
        this.onData = new api_1.Emitter();
        port.on("close", () => this.fireClose);
        port.on("error", (error) => this.fireError(error));
        port.on("message", (message) => {
          this.onData.fire(message);
        });
      }
      listen(callback) {
        return this.onData.event(callback);
      }
    };
    exports2.PortMessageReader = PortMessageReader;
    var PortMessageWriter = class extends api_1.AbstractMessageWriter {
      constructor(port) {
        super();
        this.port = port;
        this.errorCount = 0;
        port.on("close", () => this.fireClose());
        port.on("error", (error) => this.fireError(error));
      }
      write(msg) {
        try {
          this.port.postMessage(msg);
          return Promise.resolve();
        } catch (error) {
          this.handleError(error, msg);
          return Promise.reject(error);
        }
      }
      handleError(error, msg) {
        this.errorCount++;
        this.fireError(error, msg, this.errorCount);
      }
      end() {
      }
    };
    exports2.PortMessageWriter = PortMessageWriter;
    var SocketMessageReader = class extends api_1.ReadableStreamMessageReader {
      constructor(socket, encoding = "utf-8") {
        super((0, ril_1.default)().stream.asReadableStream(socket), encoding);
      }
    };
    exports2.SocketMessageReader = SocketMessageReader;
    var SocketMessageWriter = class extends api_1.WriteableStreamMessageWriter {
      constructor(socket, options) {
        super((0, ril_1.default)().stream.asWritableStream(socket), options);
        this.socket = socket;
      }
      dispose() {
        super.dispose();
        this.socket.destroy();
      }
    };
    exports2.SocketMessageWriter = SocketMessageWriter;
    var StreamMessageReader = class extends api_1.ReadableStreamMessageReader {
      constructor(readable, encoding) {
        super((0, ril_1.default)().stream.asReadableStream(readable), encoding);
      }
    };
    exports2.StreamMessageReader = StreamMessageReader;
    var StreamMessageWriter = class extends api_1.WriteableStreamMessageWriter {
      constructor(writable, options) {
        super((0, ril_1.default)().stream.asWritableStream(writable), options);
      }
    };
    exports2.StreamMessageWriter = StreamMessageWriter;
    var XDG_RUNTIME_DIR = process.env["XDG_RUNTIME_DIR"];
    var safeIpcPathLengths = /* @__PURE__ */ new Map([
      ["linux", 107],
      ["darwin", 103]
    ]);
    function generateRandomPipeName() {
      const randomSuffix = (0, crypto_1.randomBytes)(21).toString("hex");
      if (process.platform === "win32") {
        return `\\\\.\\pipe\\vscode-jsonrpc-${randomSuffix}-sock`;
      }
      let result;
      if (XDG_RUNTIME_DIR) {
        result = path.join(XDG_RUNTIME_DIR, `vscode-ipc-${randomSuffix}.sock`);
      } else {
        result = path.join(os.tmpdir(), `vscode-${randomSuffix}.sock`);
      }
      const limit = safeIpcPathLengths.get(process.platform);
      if (limit !== void 0 && result.length > limit) {
        (0, ril_1.default)().console.warn(`WARNING: IPC handle "${result}" is longer than ${limit} characters.`);
      }
      return result;
    }
    exports2.generateRandomPipeName = generateRandomPipeName;
    function createClientPipeTransport(pipeName, encoding = "utf-8") {
      let connectResolve;
      const connected = new Promise((resolve, _reject) => {
        connectResolve = resolve;
      });
      return new Promise((resolve, reject) => {
        let server = (0, net_1.createServer)((socket) => {
          server.close();
          connectResolve([
            new SocketMessageReader(socket, encoding),
            new SocketMessageWriter(socket, encoding)
          ]);
        });
        server.on("error", reject);
        server.listen(pipeName, () => {
          server.removeListener("error", reject);
          resolve({
            onConnected: () => {
              return connected;
            }
          });
        });
      });
    }
    exports2.createClientPipeTransport = createClientPipeTransport;
    function createServerPipeTransport(pipeName, encoding = "utf-8") {
      const socket = (0, net_1.createConnection)(pipeName);
      return [
        new SocketMessageReader(socket, encoding),
        new SocketMessageWriter(socket, encoding)
      ];
    }
    exports2.createServerPipeTransport = createServerPipeTransport;
    function createClientSocketTransport(port, encoding = "utf-8") {
      let connectResolve;
      const connected = new Promise((resolve, _reject) => {
        connectResolve = resolve;
      });
      return new Promise((resolve, reject) => {
        const server = (0, net_1.createServer)((socket) => {
          server.close();
          connectResolve([
            new SocketMessageReader(socket, encoding),
            new SocketMessageWriter(socket, encoding)
          ]);
        });
        server.on("error", reject);
        server.listen(port, "127.0.0.1", () => {
          server.removeListener("error", reject);
          resolve({
            onConnected: () => {
              return connected;
            }
          });
        });
      });
    }
    exports2.createClientSocketTransport = createClientSocketTransport;
    function createServerSocketTransport(port, encoding = "utf-8") {
      const socket = (0, net_1.createConnection)(port, "127.0.0.1");
      return [
        new SocketMessageReader(socket, encoding),
        new SocketMessageWriter(socket, encoding)
      ];
    }
    exports2.createServerSocketTransport = createServerSocketTransport;
    function isReadableStream(value) {
      const candidate = value;
      return candidate.read !== void 0 && candidate.addListener !== void 0;
    }
    function isWritableStream(value) {
      const candidate = value;
      return candidate.write !== void 0 && candidate.addListener !== void 0;
    }
    function createMessageConnection(input, output, logger, options) {
      if (!logger) {
        logger = api_1.NullLogger;
      }
      const reader = isReadableStream(input) ? new StreamMessageReader(input) : input;
      const writer = isWritableStream(output) ? new StreamMessageWriter(output) : output;
      if (api_1.ConnectionStrategy.is(options)) {
        options = { connectionStrategy: options };
      }
      return (0, api_1.createMessageConnection)(reader, writer, logger, options);
    }
    exports2.createMessageConnection = createMessageConnection;
  }
});

// node_modules/vscode-jsonrpc/node.js
var require_node = __commonJS({
  "node_modules/vscode-jsonrpc/node.js"(exports2, module2) {
    "use strict";
    module2.exports = require_main();
  }
});

// node_modules/vscode-languageserver-types/lib/umd/main.js
var require_main2 = __commonJS({
  "node_modules/vscode-languageserver-types/lib/umd/main.js"(exports2, module2) {
    "use strict";
    (function(factory) {
      if (typeof module2 === "object" && typeof module2.exports === "object") {
        var v = factory(require, exports2);
        if (v !== void 0)
          module2.exports = v;
      } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
      }
    })(function(require2, exports3) {
      "use strict";
      Object.defineProperty(exports3, "__esModule", { value: true });
      exports3.TextDocument = exports3.EOL = exports3.WorkspaceFolder = exports3.InlineCompletionContext = exports3.SelectedCompletionInfo = exports3.InlineCompletionTriggerKind = exports3.InlineCompletionList = exports3.InlineCompletionItem = exports3.StringValue = exports3.InlayHint = exports3.InlayHintLabelPart = exports3.InlayHintKind = exports3.InlineValueContext = exports3.InlineValueEvaluatableExpression = exports3.InlineValueVariableLookup = exports3.InlineValueText = exports3.SemanticTokens = exports3.SemanticTokenModifiers = exports3.SemanticTokenTypes = exports3.SelectionRange = exports3.DocumentLink = exports3.FormattingOptions = exports3.CodeLens = exports3.CodeAction = exports3.CodeActionContext = exports3.CodeActionTriggerKind = exports3.CodeActionKind = exports3.DocumentSymbol = exports3.WorkspaceSymbol = exports3.SymbolInformation = exports3.SymbolTag = exports3.SymbolKind = exports3.DocumentHighlight = exports3.DocumentHighlightKind = exports3.SignatureInformation = exports3.ParameterInformation = exports3.Hover = exports3.MarkedString = exports3.CompletionList = exports3.CompletionItem = exports3.CompletionItemLabelDetails = exports3.InsertTextMode = exports3.InsertReplaceEdit = exports3.CompletionItemTag = exports3.InsertTextFormat = exports3.CompletionItemKind = exports3.MarkupContent = exports3.MarkupKind = exports3.TextDocumentItem = exports3.OptionalVersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier = exports3.TextDocumentIdentifier = exports3.WorkspaceChange = exports3.WorkspaceEdit = exports3.DeleteFile = exports3.RenameFile = exports3.CreateFile = exports3.TextDocumentEdit = exports3.AnnotatedTextEdit = exports3.ChangeAnnotationIdentifier = exports3.ChangeAnnotation = exports3.TextEdit = exports3.Command = exports3.Diagnostic = exports3.CodeDescription = exports3.DiagnosticTag = exports3.DiagnosticSeverity = exports3.DiagnosticRelatedInformation = exports3.FoldingRange = exports3.FoldingRangeKind = exports3.ColorPresentation = exports3.ColorInformation = exports3.Color = exports3.LocationLink = exports3.Location = exports3.Range = exports3.Position = exports3.uinteger = exports3.integer = exports3.URI = exports3.DocumentUri = void 0;
      var DocumentUri2;
      (function(DocumentUri3) {
        function is(value) {
          return typeof value === "string";
        }
        DocumentUri3.is = is;
      })(DocumentUri2 || (exports3.DocumentUri = DocumentUri2 = {}));
      var URI3;
      (function(URI4) {
        function is(value) {
          return typeof value === "string";
        }
        URI4.is = is;
      })(URI3 || (exports3.URI = URI3 = {}));
      var integer2;
      (function(integer3) {
        integer3.MIN_VALUE = -2147483648;
        integer3.MAX_VALUE = 2147483647;
        function is(value) {
          return typeof value === "number" && integer3.MIN_VALUE <= value && value <= integer3.MAX_VALUE;
        }
        integer3.is = is;
      })(integer2 || (exports3.integer = integer2 = {}));
      var uinteger2;
      (function(uinteger3) {
        uinteger3.MIN_VALUE = 0;
        uinteger3.MAX_VALUE = 2147483647;
        function is(value) {
          return typeof value === "number" && uinteger3.MIN_VALUE <= value && value <= uinteger3.MAX_VALUE;
        }
        uinteger3.is = is;
      })(uinteger2 || (exports3.uinteger = uinteger2 = {}));
      var Position2;
      (function(Position3) {
        function create(line, character) {
          if (line === Number.MAX_VALUE) {
            line = uinteger2.MAX_VALUE;
          }
          if (character === Number.MAX_VALUE) {
            character = uinteger2.MAX_VALUE;
          }
          return { line, character };
        }
        Position3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.uinteger(candidate.line) && Is2.uinteger(candidate.character);
        }
        Position3.is = is;
      })(Position2 || (exports3.Position = Position2 = {}));
      var Range2;
      (function(Range3) {
        function create(one, two, three, four) {
          if (Is2.uinteger(one) && Is2.uinteger(two) && Is2.uinteger(three) && Is2.uinteger(four)) {
            return { start: Position2.create(one, two), end: Position2.create(three, four) };
          } else if (Position2.is(one) && Position2.is(two)) {
            return { start: one, end: two };
          } else {
            throw new Error("Range#create called with invalid arguments[".concat(one, ", ").concat(two, ", ").concat(three, ", ").concat(four, "]"));
          }
        }
        Range3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Position2.is(candidate.start) && Position2.is(candidate.end);
        }
        Range3.is = is;
      })(Range2 || (exports3.Range = Range2 = {}));
      var Location2;
      (function(Location3) {
        function create(uri, range) {
          return { uri, range };
        }
        Location3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Range2.is(candidate.range) && (Is2.string(candidate.uri) || Is2.undefined(candidate.uri));
        }
        Location3.is = is;
      })(Location2 || (exports3.Location = Location2 = {}));
      var LocationLink2;
      (function(LocationLink3) {
        function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
          return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
        }
        LocationLink3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Range2.is(candidate.targetRange) && Is2.string(candidate.targetUri) && Range2.is(candidate.targetSelectionRange) && (Range2.is(candidate.originSelectionRange) || Is2.undefined(candidate.originSelectionRange));
        }
        LocationLink3.is = is;
      })(LocationLink2 || (exports3.LocationLink = LocationLink2 = {}));
      var Color2;
      (function(Color3) {
        function create(red, green, blue, alpha) {
          return {
            red,
            green,
            blue,
            alpha
          };
        }
        Color3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.numberRange(candidate.red, 0, 1) && Is2.numberRange(candidate.green, 0, 1) && Is2.numberRange(candidate.blue, 0, 1) && Is2.numberRange(candidate.alpha, 0, 1);
        }
        Color3.is = is;
      })(Color2 || (exports3.Color = Color2 = {}));
      var ColorInformation2;
      (function(ColorInformation3) {
        function create(range, color) {
          return {
            range,
            color
          };
        }
        ColorInformation3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Range2.is(candidate.range) && Color2.is(candidate.color);
        }
        ColorInformation3.is = is;
      })(ColorInformation2 || (exports3.ColorInformation = ColorInformation2 = {}));
      var ColorPresentation2;
      (function(ColorPresentation3) {
        function create(label, textEdit, additionalTextEdits) {
          return {
            label,
            textEdit,
            additionalTextEdits
          };
        }
        ColorPresentation3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.string(candidate.label) && (Is2.undefined(candidate.textEdit) || TextEdit2.is(candidate)) && (Is2.undefined(candidate.additionalTextEdits) || Is2.typedArray(candidate.additionalTextEdits, TextEdit2.is));
        }
        ColorPresentation3.is = is;
      })(ColorPresentation2 || (exports3.ColorPresentation = ColorPresentation2 = {}));
      var FoldingRangeKind2;
      (function(FoldingRangeKind3) {
        FoldingRangeKind3.Comment = "comment";
        FoldingRangeKind3.Imports = "imports";
        FoldingRangeKind3.Region = "region";
      })(FoldingRangeKind2 || (exports3.FoldingRangeKind = FoldingRangeKind2 = {}));
      var FoldingRange2;
      (function(FoldingRange3) {
        function create(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
          var result = {
            startLine,
            endLine
          };
          if (Is2.defined(startCharacter)) {
            result.startCharacter = startCharacter;
          }
          if (Is2.defined(endCharacter)) {
            result.endCharacter = endCharacter;
          }
          if (Is2.defined(kind)) {
            result.kind = kind;
          }
          if (Is2.defined(collapsedText)) {
            result.collapsedText = collapsedText;
          }
          return result;
        }
        FoldingRange3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.uinteger(candidate.startLine) && Is2.uinteger(candidate.startLine) && (Is2.undefined(candidate.startCharacter) || Is2.uinteger(candidate.startCharacter)) && (Is2.undefined(candidate.endCharacter) || Is2.uinteger(candidate.endCharacter)) && (Is2.undefined(candidate.kind) || Is2.string(candidate.kind));
        }
        FoldingRange3.is = is;
      })(FoldingRange2 || (exports3.FoldingRange = FoldingRange2 = {}));
      var DiagnosticRelatedInformation2;
      (function(DiagnosticRelatedInformation3) {
        function create(location, message) {
          return {
            location,
            message
          };
        }
        DiagnosticRelatedInformation3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Location2.is(candidate.location) && Is2.string(candidate.message);
        }
        DiagnosticRelatedInformation3.is = is;
      })(DiagnosticRelatedInformation2 || (exports3.DiagnosticRelatedInformation = DiagnosticRelatedInformation2 = {}));
      var DiagnosticSeverity2;
      (function(DiagnosticSeverity3) {
        DiagnosticSeverity3.Error = 1;
        DiagnosticSeverity3.Warning = 2;
        DiagnosticSeverity3.Information = 3;
        DiagnosticSeverity3.Hint = 4;
      })(DiagnosticSeverity2 || (exports3.DiagnosticSeverity = DiagnosticSeverity2 = {}));
      var DiagnosticTag2;
      (function(DiagnosticTag3) {
        DiagnosticTag3.Unnecessary = 1;
        DiagnosticTag3.Deprecated = 2;
      })(DiagnosticTag2 || (exports3.DiagnosticTag = DiagnosticTag2 = {}));
      var CodeDescription2;
      (function(CodeDescription3) {
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.string(candidate.href);
        }
        CodeDescription3.is = is;
      })(CodeDescription2 || (exports3.CodeDescription = CodeDescription2 = {}));
      var Diagnostic2;
      (function(Diagnostic3) {
        function create(range, message, severity, code, source, relatedInformation) {
          var result = { range, message };
          if (Is2.defined(severity)) {
            result.severity = severity;
          }
          if (Is2.defined(code)) {
            result.code = code;
          }
          if (Is2.defined(source)) {
            result.source = source;
          }
          if (Is2.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
          }
          return result;
        }
        Diagnostic3.create = create;
        function is(value) {
          var _a3;
          var candidate = value;
          return Is2.defined(candidate) && Range2.is(candidate.range) && Is2.string(candidate.message) && (Is2.number(candidate.severity) || Is2.undefined(candidate.severity)) && (Is2.integer(candidate.code) || Is2.string(candidate.code) || Is2.undefined(candidate.code)) && (Is2.undefined(candidate.codeDescription) || Is2.string((_a3 = candidate.codeDescription) === null || _a3 === void 0 ? void 0 : _a3.href)) && (Is2.string(candidate.source) || Is2.undefined(candidate.source)) && (Is2.undefined(candidate.relatedInformation) || Is2.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation2.is));
        }
        Diagnostic3.is = is;
      })(Diagnostic2 || (exports3.Diagnostic = Diagnostic2 = {}));
      var Command2;
      (function(Command3) {
        function create(title, command) {
          var args = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
          }
          var result = { title, command };
          if (Is2.defined(args) && args.length > 0) {
            result.arguments = args;
          }
          return result;
        }
        Command3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.title) && Is2.string(candidate.command);
        }
        Command3.is = is;
      })(Command2 || (exports3.Command = Command2 = {}));
      var TextEdit2;
      (function(TextEdit3) {
        function replace(range, newText) {
          return { range, newText };
        }
        TextEdit3.replace = replace;
        function insert(position, newText) {
          return { range: { start: position, end: position }, newText };
        }
        TextEdit3.insert = insert;
        function del(range) {
          return { range, newText: "" };
        }
        TextEdit3.del = del;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.string(candidate.newText) && Range2.is(candidate.range);
        }
        TextEdit3.is = is;
      })(TextEdit2 || (exports3.TextEdit = TextEdit2 = {}));
      var ChangeAnnotation2;
      (function(ChangeAnnotation3) {
        function create(label, needsConfirmation, description) {
          var result = { label };
          if (needsConfirmation !== void 0) {
            result.needsConfirmation = needsConfirmation;
          }
          if (description !== void 0) {
            result.description = description;
          }
          return result;
        }
        ChangeAnnotation3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Is2.string(candidate.label) && (Is2.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is2.string(candidate.description) || candidate.description === void 0);
        }
        ChangeAnnotation3.is = is;
      })(ChangeAnnotation2 || (exports3.ChangeAnnotation = ChangeAnnotation2 = {}));
      var ChangeAnnotationIdentifier2;
      (function(ChangeAnnotationIdentifier3) {
        function is(value) {
          var candidate = value;
          return Is2.string(candidate);
        }
        ChangeAnnotationIdentifier3.is = is;
      })(ChangeAnnotationIdentifier2 || (exports3.ChangeAnnotationIdentifier = ChangeAnnotationIdentifier2 = {}));
      var AnnotatedTextEdit2;
      (function(AnnotatedTextEdit3) {
        function replace(range, newText, annotation) {
          return { range, newText, annotationId: annotation };
        }
        AnnotatedTextEdit3.replace = replace;
        function insert(position, newText, annotation) {
          return { range: { start: position, end: position }, newText, annotationId: annotation };
        }
        AnnotatedTextEdit3.insert = insert;
        function del(range, annotation) {
          return { range, newText: "", annotationId: annotation };
        }
        AnnotatedTextEdit3.del = del;
        function is(value) {
          var candidate = value;
          return TextEdit2.is(candidate) && (ChangeAnnotation2.is(candidate.annotationId) || ChangeAnnotationIdentifier2.is(candidate.annotationId));
        }
        AnnotatedTextEdit3.is = is;
      })(AnnotatedTextEdit2 || (exports3.AnnotatedTextEdit = AnnotatedTextEdit2 = {}));
      var TextDocumentEdit2;
      (function(TextDocumentEdit3) {
        function create(textDocument, edits) {
          return { textDocument, edits };
        }
        TextDocumentEdit3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && OptionalVersionedTextDocumentIdentifier2.is(candidate.textDocument) && Array.isArray(candidate.edits);
        }
        TextDocumentEdit3.is = is;
      })(TextDocumentEdit2 || (exports3.TextDocumentEdit = TextDocumentEdit2 = {}));
      var CreateFile2;
      (function(CreateFile3) {
        function create(uri, options, annotation) {
          var result = {
            kind: "create",
            uri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        CreateFile3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "create" && Is2.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is2.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is2.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier2.is(candidate.annotationId));
        }
        CreateFile3.is = is;
      })(CreateFile2 || (exports3.CreateFile = CreateFile2 = {}));
      var RenameFile2;
      (function(RenameFile3) {
        function create(oldUri, newUri, options, annotation) {
          var result = {
            kind: "rename",
            oldUri,
            newUri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        RenameFile3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "rename" && Is2.string(candidate.oldUri) && Is2.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is2.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is2.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier2.is(candidate.annotationId));
        }
        RenameFile3.is = is;
      })(RenameFile2 || (exports3.RenameFile = RenameFile2 = {}));
      var DeleteFile2;
      (function(DeleteFile3) {
        function create(uri, options, annotation) {
          var result = {
            kind: "delete",
            uri
          };
          if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        DeleteFile3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "delete" && Is2.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is2.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is2.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier2.is(candidate.annotationId));
        }
        DeleteFile3.is = is;
      })(DeleteFile2 || (exports3.DeleteFile = DeleteFile2 = {}));
      var WorkspaceEdit2;
      (function(WorkspaceEdit3) {
        function is(value) {
          var candidate = value;
          return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every(function(change) {
            if (Is2.string(change.kind)) {
              return CreateFile2.is(change) || RenameFile2.is(change) || DeleteFile2.is(change);
            } else {
              return TextDocumentEdit2.is(change);
            }
          }));
        }
        WorkspaceEdit3.is = is;
      })(WorkspaceEdit2 || (exports3.WorkspaceEdit = WorkspaceEdit2 = {}));
      var TextEditChangeImpl = (
        /** @class */
        function() {
          function TextEditChangeImpl2(edits, changeAnnotations) {
            this.edits = edits;
            this.changeAnnotations = changeAnnotations;
          }
          TextEditChangeImpl2.prototype.insert = function(position, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit2.insert(position, newText);
            } else if (ChangeAnnotationIdentifier2.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit2.insert(position, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit2.insert(position, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.replace = function(range, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit2.replace(range, newText);
            } else if (ChangeAnnotationIdentifier2.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit2.replace(range, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit2.replace(range, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.delete = function(range, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit2.del(range);
            } else if (ChangeAnnotationIdentifier2.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit2.del(range, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit2.del(range, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.add = function(edit) {
            this.edits.push(edit);
          };
          TextEditChangeImpl2.prototype.all = function() {
            return this.edits;
          };
          TextEditChangeImpl2.prototype.clear = function() {
            this.edits.splice(0, this.edits.length);
          };
          TextEditChangeImpl2.prototype.assertChangeAnnotations = function(value) {
            if (value === void 0) {
              throw new Error("Text edit change is not configured to manage change annotations.");
            }
          };
          return TextEditChangeImpl2;
        }()
      );
      var ChangeAnnotations = (
        /** @class */
        function() {
          function ChangeAnnotations2(annotations) {
            this._annotations = annotations === void 0 ? /* @__PURE__ */ Object.create(null) : annotations;
            this._counter = 0;
            this._size = 0;
          }
          ChangeAnnotations2.prototype.all = function() {
            return this._annotations;
          };
          Object.defineProperty(ChangeAnnotations2.prototype, "size", {
            get: function() {
              return this._size;
            },
            enumerable: false,
            configurable: true
          });
          ChangeAnnotations2.prototype.manage = function(idOrAnnotation, annotation) {
            var id;
            if (ChangeAnnotationIdentifier2.is(idOrAnnotation)) {
              id = idOrAnnotation;
            } else {
              id = this.nextId();
              annotation = idOrAnnotation;
            }
            if (this._annotations[id] !== void 0) {
              throw new Error("Id ".concat(id, " is already in use."));
            }
            if (annotation === void 0) {
              throw new Error("No annotation provided for id ".concat(id));
            }
            this._annotations[id] = annotation;
            this._size++;
            return id;
          };
          ChangeAnnotations2.prototype.nextId = function() {
            this._counter++;
            return this._counter.toString();
          };
          return ChangeAnnotations2;
        }()
      );
      var WorkspaceChange = (
        /** @class */
        function() {
          function WorkspaceChange2(workspaceEdit) {
            var _this = this;
            this._textEditChanges = /* @__PURE__ */ Object.create(null);
            if (workspaceEdit !== void 0) {
              this._workspaceEdit = workspaceEdit;
              if (workspaceEdit.documentChanges) {
                this._changeAnnotations = new ChangeAnnotations(workspaceEdit.changeAnnotations);
                workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                workspaceEdit.documentChanges.forEach(function(change) {
                  if (TextDocumentEdit2.is(change)) {
                    var textEditChange = new TextEditChangeImpl(change.edits, _this._changeAnnotations);
                    _this._textEditChanges[change.textDocument.uri] = textEditChange;
                  }
                });
              } else if (workspaceEdit.changes) {
                Object.keys(workspaceEdit.changes).forEach(function(key) {
                  var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                  _this._textEditChanges[key] = textEditChange;
                });
              }
            } else {
              this._workspaceEdit = {};
            }
          }
          Object.defineProperty(WorkspaceChange2.prototype, "edit", {
            /**
             * Returns the underlying {@link WorkspaceEdit} literal
             * use to be returned from a workspace edit operation like rename.
             */
            get: function() {
              this.initDocumentChanges();
              if (this._changeAnnotations !== void 0) {
                if (this._changeAnnotations.size === 0) {
                  this._workspaceEdit.changeAnnotations = void 0;
                } else {
                  this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                }
              }
              return this._workspaceEdit;
            },
            enumerable: false,
            configurable: true
          });
          WorkspaceChange2.prototype.getTextEditChange = function(key) {
            if (OptionalVersionedTextDocumentIdentifier2.is(key)) {
              this.initDocumentChanges();
              if (this._workspaceEdit.documentChanges === void 0) {
                throw new Error("Workspace edit is not configured for document changes.");
              }
              var textDocument = { uri: key.uri, version: key.version };
              var result = this._textEditChanges[textDocument.uri];
              if (!result) {
                var edits = [];
                var textDocumentEdit = {
                  textDocument,
                  edits
                };
                this._workspaceEdit.documentChanges.push(textDocumentEdit);
                result = new TextEditChangeImpl(edits, this._changeAnnotations);
                this._textEditChanges[textDocument.uri] = result;
              }
              return result;
            } else {
              this.initChanges();
              if (this._workspaceEdit.changes === void 0) {
                throw new Error("Workspace edit is not configured for normal text edit changes.");
              }
              var result = this._textEditChanges[key];
              if (!result) {
                var edits = [];
                this._workspaceEdit.changes[key] = edits;
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[key] = result;
              }
              return result;
            }
          };
          WorkspaceChange2.prototype.initDocumentChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._changeAnnotations = new ChangeAnnotations();
              this._workspaceEdit.documentChanges = [];
              this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
            }
          };
          WorkspaceChange2.prototype.initChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._workspaceEdit.changes = /* @__PURE__ */ Object.create(null);
            }
          };
          WorkspaceChange2.prototype.createFile = function(uri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation2.is(optionsOrAnnotation) || ChangeAnnotationIdentifier2.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = CreateFile2.create(uri, options);
            } else {
              id = ChangeAnnotationIdentifier2.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = CreateFile2.create(uri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.renameFile = function(oldUri, newUri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation2.is(optionsOrAnnotation) || ChangeAnnotationIdentifier2.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = RenameFile2.create(oldUri, newUri, options);
            } else {
              id = ChangeAnnotationIdentifier2.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = RenameFile2.create(oldUri, newUri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.deleteFile = function(uri, optionsOrAnnotation, options) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation2.is(optionsOrAnnotation) || ChangeAnnotationIdentifier2.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = DeleteFile2.create(uri, options);
            } else {
              id = ChangeAnnotationIdentifier2.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = DeleteFile2.create(uri, options, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          return WorkspaceChange2;
        }()
      );
      exports3.WorkspaceChange = WorkspaceChange;
      var TextDocumentIdentifier2;
      (function(TextDocumentIdentifier3) {
        function create(uri) {
          return { uri };
        }
        TextDocumentIdentifier3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.uri);
        }
        TextDocumentIdentifier3.is = is;
      })(TextDocumentIdentifier2 || (exports3.TextDocumentIdentifier = TextDocumentIdentifier2 = {}));
      var VersionedTextDocumentIdentifier2;
      (function(VersionedTextDocumentIdentifier3) {
        function create(uri, version) {
          return { uri, version };
        }
        VersionedTextDocumentIdentifier3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.uri) && Is2.integer(candidate.version);
        }
        VersionedTextDocumentIdentifier3.is = is;
      })(VersionedTextDocumentIdentifier2 || (exports3.VersionedTextDocumentIdentifier = VersionedTextDocumentIdentifier2 = {}));
      var OptionalVersionedTextDocumentIdentifier2;
      (function(OptionalVersionedTextDocumentIdentifier3) {
        function create(uri, version) {
          return { uri, version };
        }
        OptionalVersionedTextDocumentIdentifier3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.uri) && (candidate.version === null || Is2.integer(candidate.version));
        }
        OptionalVersionedTextDocumentIdentifier3.is = is;
      })(OptionalVersionedTextDocumentIdentifier2 || (exports3.OptionalVersionedTextDocumentIdentifier = OptionalVersionedTextDocumentIdentifier2 = {}));
      var TextDocumentItem2;
      (function(TextDocumentItem3) {
        function create(uri, languageId, version, text) {
          return { uri, languageId, version, text };
        }
        TextDocumentItem3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.uri) && Is2.string(candidate.languageId) && Is2.integer(candidate.version) && Is2.string(candidate.text);
        }
        TextDocumentItem3.is = is;
      })(TextDocumentItem2 || (exports3.TextDocumentItem = TextDocumentItem2 = {}));
      var MarkupKind2;
      (function(MarkupKind3) {
        MarkupKind3.PlainText = "plaintext";
        MarkupKind3.Markdown = "markdown";
        function is(value) {
          var candidate = value;
          return candidate === MarkupKind3.PlainText || candidate === MarkupKind3.Markdown;
        }
        MarkupKind3.is = is;
      })(MarkupKind2 || (exports3.MarkupKind = MarkupKind2 = {}));
      var MarkupContent2;
      (function(MarkupContent3) {
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(value) && MarkupKind2.is(candidate.kind) && Is2.string(candidate.value);
        }
        MarkupContent3.is = is;
      })(MarkupContent2 || (exports3.MarkupContent = MarkupContent2 = {}));
      var CompletionItemKind2;
      (function(CompletionItemKind3) {
        CompletionItemKind3.Text = 1;
        CompletionItemKind3.Method = 2;
        CompletionItemKind3.Function = 3;
        CompletionItemKind3.Constructor = 4;
        CompletionItemKind3.Field = 5;
        CompletionItemKind3.Variable = 6;
        CompletionItemKind3.Class = 7;
        CompletionItemKind3.Interface = 8;
        CompletionItemKind3.Module = 9;
        CompletionItemKind3.Property = 10;
        CompletionItemKind3.Unit = 11;
        CompletionItemKind3.Value = 12;
        CompletionItemKind3.Enum = 13;
        CompletionItemKind3.Keyword = 14;
        CompletionItemKind3.Snippet = 15;
        CompletionItemKind3.Color = 16;
        CompletionItemKind3.File = 17;
        CompletionItemKind3.Reference = 18;
        CompletionItemKind3.Folder = 19;
        CompletionItemKind3.EnumMember = 20;
        CompletionItemKind3.Constant = 21;
        CompletionItemKind3.Struct = 22;
        CompletionItemKind3.Event = 23;
        CompletionItemKind3.Operator = 24;
        CompletionItemKind3.TypeParameter = 25;
      })(CompletionItemKind2 || (exports3.CompletionItemKind = CompletionItemKind2 = {}));
      var InsertTextFormat2;
      (function(InsertTextFormat3) {
        InsertTextFormat3.PlainText = 1;
        InsertTextFormat3.Snippet = 2;
      })(InsertTextFormat2 || (exports3.InsertTextFormat = InsertTextFormat2 = {}));
      var CompletionItemTag2;
      (function(CompletionItemTag3) {
        CompletionItemTag3.Deprecated = 1;
      })(CompletionItemTag2 || (exports3.CompletionItemTag = CompletionItemTag2 = {}));
      var InsertReplaceEdit2;
      (function(InsertReplaceEdit3) {
        function create(newText, insert, replace) {
          return { newText, insert, replace };
        }
        InsertReplaceEdit3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is2.string(candidate.newText) && Range2.is(candidate.insert) && Range2.is(candidate.replace);
        }
        InsertReplaceEdit3.is = is;
      })(InsertReplaceEdit2 || (exports3.InsertReplaceEdit = InsertReplaceEdit2 = {}));
      var InsertTextMode2;
      (function(InsertTextMode3) {
        InsertTextMode3.asIs = 1;
        InsertTextMode3.adjustIndentation = 2;
      })(InsertTextMode2 || (exports3.InsertTextMode = InsertTextMode2 = {}));
      var CompletionItemLabelDetails2;
      (function(CompletionItemLabelDetails3) {
        function is(value) {
          var candidate = value;
          return candidate && (Is2.string(candidate.detail) || candidate.detail === void 0) && (Is2.string(candidate.description) || candidate.description === void 0);
        }
        CompletionItemLabelDetails3.is = is;
      })(CompletionItemLabelDetails2 || (exports3.CompletionItemLabelDetails = CompletionItemLabelDetails2 = {}));
      var CompletionItem2;
      (function(CompletionItem3) {
        function create(label) {
          return { label };
        }
        CompletionItem3.create = create;
      })(CompletionItem2 || (exports3.CompletionItem = CompletionItem2 = {}));
      var CompletionList2;
      (function(CompletionList3) {
        function create(items, isIncomplete) {
          return { items: items ? items : [], isIncomplete: !!isIncomplete };
        }
        CompletionList3.create = create;
      })(CompletionList2 || (exports3.CompletionList = CompletionList2 = {}));
      var MarkedString2;
      (function(MarkedString3) {
        function fromPlainText(plainText) {
          return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
        }
        MarkedString3.fromPlainText = fromPlainText;
        function is(value) {
          var candidate = value;
          return Is2.string(candidate) || Is2.objectLiteral(candidate) && Is2.string(candidate.language) && Is2.string(candidate.value);
        }
        MarkedString3.is = is;
      })(MarkedString2 || (exports3.MarkedString = MarkedString2 = {}));
      var Hover2;
      (function(Hover3) {
        function is(value) {
          var candidate = value;
          return !!candidate && Is2.objectLiteral(candidate) && (MarkupContent2.is(candidate.contents) || MarkedString2.is(candidate.contents) || Is2.typedArray(candidate.contents, MarkedString2.is)) && (value.range === void 0 || Range2.is(value.range));
        }
        Hover3.is = is;
      })(Hover2 || (exports3.Hover = Hover2 = {}));
      var ParameterInformation2;
      (function(ParameterInformation3) {
        function create(label, documentation) {
          return documentation ? { label, documentation } : { label };
        }
        ParameterInformation3.create = create;
      })(ParameterInformation2 || (exports3.ParameterInformation = ParameterInformation2 = {}));
      var SignatureInformation2;
      (function(SignatureInformation3) {
        function create(label, documentation) {
          var parameters = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
          }
          var result = { label };
          if (Is2.defined(documentation)) {
            result.documentation = documentation;
          }
          if (Is2.defined(parameters)) {
            result.parameters = parameters;
          } else {
            result.parameters = [];
          }
          return result;
        }
        SignatureInformation3.create = create;
      })(SignatureInformation2 || (exports3.SignatureInformation = SignatureInformation2 = {}));
      var DocumentHighlightKind2;
      (function(DocumentHighlightKind3) {
        DocumentHighlightKind3.Text = 1;
        DocumentHighlightKind3.Read = 2;
        DocumentHighlightKind3.Write = 3;
      })(DocumentHighlightKind2 || (exports3.DocumentHighlightKind = DocumentHighlightKind2 = {}));
      var DocumentHighlight2;
      (function(DocumentHighlight3) {
        function create(range, kind) {
          var result = { range };
          if (Is2.number(kind)) {
            result.kind = kind;
          }
          return result;
        }
        DocumentHighlight3.create = create;
      })(DocumentHighlight2 || (exports3.DocumentHighlight = DocumentHighlight2 = {}));
      var SymbolKind2;
      (function(SymbolKind3) {
        SymbolKind3.File = 1;
        SymbolKind3.Module = 2;
        SymbolKind3.Namespace = 3;
        SymbolKind3.Package = 4;
        SymbolKind3.Class = 5;
        SymbolKind3.Method = 6;
        SymbolKind3.Property = 7;
        SymbolKind3.Field = 8;
        SymbolKind3.Constructor = 9;
        SymbolKind3.Enum = 10;
        SymbolKind3.Interface = 11;
        SymbolKind3.Function = 12;
        SymbolKind3.Variable = 13;
        SymbolKind3.Constant = 14;
        SymbolKind3.String = 15;
        SymbolKind3.Number = 16;
        SymbolKind3.Boolean = 17;
        SymbolKind3.Array = 18;
        SymbolKind3.Object = 19;
        SymbolKind3.Key = 20;
        SymbolKind3.Null = 21;
        SymbolKind3.EnumMember = 22;
        SymbolKind3.Struct = 23;
        SymbolKind3.Event = 24;
        SymbolKind3.Operator = 25;
        SymbolKind3.TypeParameter = 26;
      })(SymbolKind2 || (exports3.SymbolKind = SymbolKind2 = {}));
      var SymbolTag2;
      (function(SymbolTag3) {
        SymbolTag3.Deprecated = 1;
      })(SymbolTag2 || (exports3.SymbolTag = SymbolTag2 = {}));
      var SymbolInformation2;
      (function(SymbolInformation3) {
        function create(name, kind, range, uri, containerName) {
          var result = {
            name,
            kind,
            location: { uri, range }
          };
          if (containerName) {
            result.containerName = containerName;
          }
          return result;
        }
        SymbolInformation3.create = create;
      })(SymbolInformation2 || (exports3.SymbolInformation = SymbolInformation2 = {}));
      var WorkspaceSymbol2;
      (function(WorkspaceSymbol3) {
        function create(name, kind, uri, range) {
          return range !== void 0 ? { name, kind, location: { uri, range } } : { name, kind, location: { uri } };
        }
        WorkspaceSymbol3.create = create;
      })(WorkspaceSymbol2 || (exports3.WorkspaceSymbol = WorkspaceSymbol2 = {}));
      var DocumentSymbol2;
      (function(DocumentSymbol3) {
        function create(name, detail, kind, range, selectionRange, children) {
          var result = {
            name,
            detail,
            kind,
            range,
            selectionRange
          };
          if (children !== void 0) {
            result.children = children;
          }
          return result;
        }
        DocumentSymbol3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is2.string(candidate.name) && Is2.number(candidate.kind) && Range2.is(candidate.range) && Range2.is(candidate.selectionRange) && (candidate.detail === void 0 || Is2.string(candidate.detail)) && (candidate.deprecated === void 0 || Is2.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
        }
        DocumentSymbol3.is = is;
      })(DocumentSymbol2 || (exports3.DocumentSymbol = DocumentSymbol2 = {}));
      var CodeActionKind2;
      (function(CodeActionKind3) {
        CodeActionKind3.Empty = "";
        CodeActionKind3.QuickFix = "quickfix";
        CodeActionKind3.Refactor = "refactor";
        CodeActionKind3.RefactorExtract = "refactor.extract";
        CodeActionKind3.RefactorInline = "refactor.inline";
        CodeActionKind3.RefactorRewrite = "refactor.rewrite";
        CodeActionKind3.Source = "source";
        CodeActionKind3.SourceOrganizeImports = "source.organizeImports";
        CodeActionKind3.SourceFixAll = "source.fixAll";
      })(CodeActionKind2 || (exports3.CodeActionKind = CodeActionKind2 = {}));
      var CodeActionTriggerKind2;
      (function(CodeActionTriggerKind3) {
        CodeActionTriggerKind3.Invoked = 1;
        CodeActionTriggerKind3.Automatic = 2;
      })(CodeActionTriggerKind2 || (exports3.CodeActionTriggerKind = CodeActionTriggerKind2 = {}));
      var CodeActionContext2;
      (function(CodeActionContext3) {
        function create(diagnostics, only, triggerKind) {
          var result = { diagnostics };
          if (only !== void 0 && only !== null) {
            result.only = only;
          }
          if (triggerKind !== void 0 && triggerKind !== null) {
            result.triggerKind = triggerKind;
          }
          return result;
        }
        CodeActionContext3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.typedArray(candidate.diagnostics, Diagnostic2.is) && (candidate.only === void 0 || Is2.typedArray(candidate.only, Is2.string)) && (candidate.triggerKind === void 0 || candidate.triggerKind === CodeActionTriggerKind2.Invoked || candidate.triggerKind === CodeActionTriggerKind2.Automatic);
        }
        CodeActionContext3.is = is;
      })(CodeActionContext2 || (exports3.CodeActionContext = CodeActionContext2 = {}));
      var CodeAction2;
      (function(CodeAction3) {
        function create(title, kindOrCommandOrEdit, kind) {
          var result = { title };
          var checkKind = true;
          if (typeof kindOrCommandOrEdit === "string") {
            checkKind = false;
            result.kind = kindOrCommandOrEdit;
          } else if (Command2.is(kindOrCommandOrEdit)) {
            result.command = kindOrCommandOrEdit;
          } else {
            result.edit = kindOrCommandOrEdit;
          }
          if (checkKind && kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        CodeAction3.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is2.string(candidate.title) && (candidate.diagnostics === void 0 || Is2.typedArray(candidate.diagnostics, Diagnostic2.is)) && (candidate.kind === void 0 || Is2.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command2.is(candidate.command)) && (candidate.isPreferred === void 0 || Is2.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit2.is(candidate.edit));
        }
        CodeAction3.is = is;
      })(CodeAction2 || (exports3.CodeAction = CodeAction2 = {}));
      var CodeLens2;
      (function(CodeLens3) {
        function create(range, data) {
          var result = { range };
          if (Is2.defined(data)) {
            result.data = data;
          }
          return result;
        }
        CodeLens3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Range2.is(candidate.range) && (Is2.undefined(candidate.command) || Command2.is(candidate.command));
        }
        CodeLens3.is = is;
      })(CodeLens2 || (exports3.CodeLens = CodeLens2 = {}));
      var FormattingOptions2;
      (function(FormattingOptions3) {
        function create(tabSize, insertSpaces) {
          return { tabSize, insertSpaces };
        }
        FormattingOptions3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.uinteger(candidate.tabSize) && Is2.boolean(candidate.insertSpaces);
        }
        FormattingOptions3.is = is;
      })(FormattingOptions2 || (exports3.FormattingOptions = FormattingOptions2 = {}));
      var DocumentLink2;
      (function(DocumentLink3) {
        function create(range, target, data) {
          return { range, target, data };
        }
        DocumentLink3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Range2.is(candidate.range) && (Is2.undefined(candidate.target) || Is2.string(candidate.target));
        }
        DocumentLink3.is = is;
      })(DocumentLink2 || (exports3.DocumentLink = DocumentLink2 = {}));
      var SelectionRange2;
      (function(SelectionRange3) {
        function create(range, parent) {
          return { range, parent };
        }
        SelectionRange3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Range2.is(candidate.range) && (candidate.parent === void 0 || SelectionRange3.is(candidate.parent));
        }
        SelectionRange3.is = is;
      })(SelectionRange2 || (exports3.SelectionRange = SelectionRange2 = {}));
      var SemanticTokenTypes2;
      (function(SemanticTokenTypes3) {
        SemanticTokenTypes3["namespace"] = "namespace";
        SemanticTokenTypes3["type"] = "type";
        SemanticTokenTypes3["class"] = "class";
        SemanticTokenTypes3["enum"] = "enum";
        SemanticTokenTypes3["interface"] = "interface";
        SemanticTokenTypes3["struct"] = "struct";
        SemanticTokenTypes3["typeParameter"] = "typeParameter";
        SemanticTokenTypes3["parameter"] = "parameter";
        SemanticTokenTypes3["variable"] = "variable";
        SemanticTokenTypes3["property"] = "property";
        SemanticTokenTypes3["enumMember"] = "enumMember";
        SemanticTokenTypes3["event"] = "event";
        SemanticTokenTypes3["function"] = "function";
        SemanticTokenTypes3["method"] = "method";
        SemanticTokenTypes3["macro"] = "macro";
        SemanticTokenTypes3["keyword"] = "keyword";
        SemanticTokenTypes3["modifier"] = "modifier";
        SemanticTokenTypes3["comment"] = "comment";
        SemanticTokenTypes3["string"] = "string";
        SemanticTokenTypes3["number"] = "number";
        SemanticTokenTypes3["regexp"] = "regexp";
        SemanticTokenTypes3["operator"] = "operator";
        SemanticTokenTypes3["decorator"] = "decorator";
      })(SemanticTokenTypes2 || (exports3.SemanticTokenTypes = SemanticTokenTypes2 = {}));
      var SemanticTokenModifiers2;
      (function(SemanticTokenModifiers3) {
        SemanticTokenModifiers3["declaration"] = "declaration";
        SemanticTokenModifiers3["definition"] = "definition";
        SemanticTokenModifiers3["readonly"] = "readonly";
        SemanticTokenModifiers3["static"] = "static";
        SemanticTokenModifiers3["deprecated"] = "deprecated";
        SemanticTokenModifiers3["abstract"] = "abstract";
        SemanticTokenModifiers3["async"] = "async";
        SemanticTokenModifiers3["modification"] = "modification";
        SemanticTokenModifiers3["documentation"] = "documentation";
        SemanticTokenModifiers3["defaultLibrary"] = "defaultLibrary";
      })(SemanticTokenModifiers2 || (exports3.SemanticTokenModifiers = SemanticTokenModifiers2 = {}));
      var SemanticTokens2;
      (function(SemanticTokens3) {
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
        }
        SemanticTokens3.is = is;
      })(SemanticTokens2 || (exports3.SemanticTokens = SemanticTokens2 = {}));
      var InlineValueText2;
      (function(InlineValueText3) {
        function create(range, text) {
          return { range, text };
        }
        InlineValueText3.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range2.is(candidate.range) && Is2.string(candidate.text);
        }
        InlineValueText3.is = is;
      })(InlineValueText2 || (exports3.InlineValueText = InlineValueText2 = {}));
      var InlineValueVariableLookup2;
      (function(InlineValueVariableLookup3) {
        function create(range, variableName, caseSensitiveLookup) {
          return { range, variableName, caseSensitiveLookup };
        }
        InlineValueVariableLookup3.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range2.is(candidate.range) && Is2.boolean(candidate.caseSensitiveLookup) && (Is2.string(candidate.variableName) || candidate.variableName === void 0);
        }
        InlineValueVariableLookup3.is = is;
      })(InlineValueVariableLookup2 || (exports3.InlineValueVariableLookup = InlineValueVariableLookup2 = {}));
      var InlineValueEvaluatableExpression2;
      (function(InlineValueEvaluatableExpression3) {
        function create(range, expression) {
          return { range, expression };
        }
        InlineValueEvaluatableExpression3.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Range2.is(candidate.range) && (Is2.string(candidate.expression) || candidate.expression === void 0);
        }
        InlineValueEvaluatableExpression3.is = is;
      })(InlineValueEvaluatableExpression2 || (exports3.InlineValueEvaluatableExpression = InlineValueEvaluatableExpression2 = {}));
      var InlineValueContext2;
      (function(InlineValueContext3) {
        function create(frameId, stoppedLocation) {
          return { frameId, stoppedLocation };
        }
        InlineValueContext3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Range2.is(value.stoppedLocation);
        }
        InlineValueContext3.is = is;
      })(InlineValueContext2 || (exports3.InlineValueContext = InlineValueContext2 = {}));
      var InlayHintKind2;
      (function(InlayHintKind3) {
        InlayHintKind3.Type = 1;
        InlayHintKind3.Parameter = 2;
        function is(value) {
          return value === 1 || value === 2;
        }
        InlayHintKind3.is = is;
      })(InlayHintKind2 || (exports3.InlayHintKind = InlayHintKind2 = {}));
      var InlayHintLabelPart2;
      (function(InlayHintLabelPart3) {
        function create(value) {
          return { value };
        }
        InlayHintLabelPart3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && (candidate.tooltip === void 0 || Is2.string(candidate.tooltip) || MarkupContent2.is(candidate.tooltip)) && (candidate.location === void 0 || Location2.is(candidate.location)) && (candidate.command === void 0 || Command2.is(candidate.command));
        }
        InlayHintLabelPart3.is = is;
      })(InlayHintLabelPart2 || (exports3.InlayHintLabelPart = InlayHintLabelPart2 = {}));
      var InlayHint2;
      (function(InlayHint3) {
        function create(position, label, kind) {
          var result = { position, label };
          if (kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        InlayHint3.create = create;
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && Position2.is(candidate.position) && (Is2.string(candidate.label) || Is2.typedArray(candidate.label, InlayHintLabelPart2.is)) && (candidate.kind === void 0 || InlayHintKind2.is(candidate.kind)) && candidate.textEdits === void 0 || Is2.typedArray(candidate.textEdits, TextEdit2.is) && (candidate.tooltip === void 0 || Is2.string(candidate.tooltip) || MarkupContent2.is(candidate.tooltip)) && (candidate.paddingLeft === void 0 || Is2.boolean(candidate.paddingLeft)) && (candidate.paddingRight === void 0 || Is2.boolean(candidate.paddingRight));
        }
        InlayHint3.is = is;
      })(InlayHint2 || (exports3.InlayHint = InlayHint2 = {}));
      var StringValue2;
      (function(StringValue3) {
        function createSnippet(value) {
          return { kind: "snippet", value };
        }
        StringValue3.createSnippet = createSnippet;
      })(StringValue2 || (exports3.StringValue = StringValue2 = {}));
      var InlineCompletionItem2;
      (function(InlineCompletionItem3) {
        function create(insertText, filterText, range, command) {
          return { insertText, filterText, range, command };
        }
        InlineCompletionItem3.create = create;
      })(InlineCompletionItem2 || (exports3.InlineCompletionItem = InlineCompletionItem2 = {}));
      var InlineCompletionList2;
      (function(InlineCompletionList3) {
        function create(items) {
          return { items };
        }
        InlineCompletionList3.create = create;
      })(InlineCompletionList2 || (exports3.InlineCompletionList = InlineCompletionList2 = {}));
      var InlineCompletionTriggerKind2;
      (function(InlineCompletionTriggerKind3) {
        InlineCompletionTriggerKind3.Invoked = 0;
        InlineCompletionTriggerKind3.Automatic = 1;
      })(InlineCompletionTriggerKind2 || (exports3.InlineCompletionTriggerKind = InlineCompletionTriggerKind2 = {}));
      var SelectedCompletionInfo2;
      (function(SelectedCompletionInfo3) {
        function create(range, text) {
          return { range, text };
        }
        SelectedCompletionInfo3.create = create;
      })(SelectedCompletionInfo2 || (exports3.SelectedCompletionInfo = SelectedCompletionInfo2 = {}));
      var InlineCompletionContext2;
      (function(InlineCompletionContext3) {
        function create(triggerKind, selectedCompletionInfo) {
          return { triggerKind, selectedCompletionInfo };
        }
        InlineCompletionContext3.create = create;
      })(InlineCompletionContext2 || (exports3.InlineCompletionContext = InlineCompletionContext2 = {}));
      var WorkspaceFolder2;
      (function(WorkspaceFolder3) {
        function is(value) {
          var candidate = value;
          return Is2.objectLiteral(candidate) && URI3.is(candidate.uri) && Is2.string(candidate.name);
        }
        WorkspaceFolder3.is = is;
      })(WorkspaceFolder2 || (exports3.WorkspaceFolder = WorkspaceFolder2 = {}));
      exports3.EOL = ["\n", "\r\n", "\r"];
      var TextDocument3;
      (function(TextDocument4) {
        function create(uri, languageId, version, content) {
          return new FullTextDocument3(uri, languageId, version, content);
        }
        TextDocument4.create = create;
        function is(value) {
          var candidate = value;
          return Is2.defined(candidate) && Is2.string(candidate.uri) && (Is2.undefined(candidate.languageId) || Is2.string(candidate.languageId)) && Is2.uinteger(candidate.lineCount) && Is2.func(candidate.getText) && Is2.func(candidate.positionAt) && Is2.func(candidate.offsetAt) ? true : false;
        }
        TextDocument4.is = is;
        function applyEdits2(document2, edits) {
          var text = document2.getText();
          var sortedEdits = mergeSort2(edits, function(a3, b) {
            var diff = a3.range.start.line - b.range.start.line;
            if (diff === 0) {
              return a3.range.start.character - b.range.start.character;
            }
            return diff;
          });
          var lastModifiedOffset = text.length;
          for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document2.offsetAt(e.range.start);
            var endOffset = document2.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
              text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            } else {
              throw new Error("Overlapping edit");
            }
            lastModifiedOffset = startOffset;
          }
          return text;
        }
        TextDocument4.applyEdits = applyEdits2;
        function mergeSort2(data, compare) {
          if (data.length <= 1) {
            return data;
          }
          var p = data.length / 2 | 0;
          var left = data.slice(0, p);
          var right = data.slice(p);
          mergeSort2(left, compare);
          mergeSort2(right, compare);
          var leftIdx = 0;
          var rightIdx = 0;
          var i = 0;
          while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
              data[i++] = left[leftIdx++];
            } else {
              data[i++] = right[rightIdx++];
            }
          }
          while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
          }
          while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
          }
          return data;
        }
      })(TextDocument3 || (exports3.TextDocument = TextDocument3 = {}));
      var FullTextDocument3 = (
        /** @class */
        function() {
          function FullTextDocument4(uri, languageId, version, content) {
            this._uri = uri;
            this._languageId = languageId;
            this._version = version;
            this._content = content;
            this._lineOffsets = void 0;
          }
          Object.defineProperty(FullTextDocument4.prototype, "uri", {
            get: function() {
              return this._uri;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument4.prototype, "languageId", {
            get: function() {
              return this._languageId;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument4.prototype, "version", {
            get: function() {
              return this._version;
            },
            enumerable: false,
            configurable: true
          });
          FullTextDocument4.prototype.getText = function(range) {
            if (range) {
              var start = this.offsetAt(range.start);
              var end = this.offsetAt(range.end);
              return this._content.substring(start, end);
            }
            return this._content;
          };
          FullTextDocument4.prototype.update = function(event, version) {
            this._content = event.text;
            this._version = version;
            this._lineOffsets = void 0;
          };
          FullTextDocument4.prototype.getLineOffsets = function() {
            if (this._lineOffsets === void 0) {
              var lineOffsets = [];
              var text = this._content;
              var isLineStart = true;
              for (var i = 0; i < text.length; i++) {
                if (isLineStart) {
                  lineOffsets.push(i);
                  isLineStart = false;
                }
                var ch = text.charAt(i);
                isLineStart = ch === "\r" || ch === "\n";
                if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
                  i++;
                }
              }
              if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
              }
              this._lineOffsets = lineOffsets;
            }
            return this._lineOffsets;
          };
          FullTextDocument4.prototype.positionAt = function(offset) {
            offset = Math.max(Math.min(offset, this._content.length), 0);
            var lineOffsets = this.getLineOffsets();
            var low = 0, high = lineOffsets.length;
            if (high === 0) {
              return Position2.create(0, offset);
            }
            while (low < high) {
              var mid = Math.floor((low + high) / 2);
              if (lineOffsets[mid] > offset) {
                high = mid;
              } else {
                low = mid + 1;
              }
            }
            var line = low - 1;
            return Position2.create(line, offset - lineOffsets[line]);
          };
          FullTextDocument4.prototype.offsetAt = function(position) {
            var lineOffsets = this.getLineOffsets();
            if (position.line >= lineOffsets.length) {
              return this._content.length;
            } else if (position.line < 0) {
              return 0;
            }
            var lineOffset = lineOffsets[position.line];
            var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
            return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
          };
          Object.defineProperty(FullTextDocument4.prototype, "lineCount", {
            get: function() {
              return this.getLineOffsets().length;
            },
            enumerable: false,
            configurable: true
          });
          return FullTextDocument4;
        }()
      );
      var Is2;
      (function(Is3) {
        var toString = Object.prototype.toString;
        function defined(value) {
          return typeof value !== "undefined";
        }
        Is3.defined = defined;
        function undefined2(value) {
          return typeof value === "undefined";
        }
        Is3.undefined = undefined2;
        function boolean(value) {
          return value === true || value === false;
        }
        Is3.boolean = boolean;
        function string(value) {
          return toString.call(value) === "[object String]";
        }
        Is3.string = string;
        function number(value) {
          return toString.call(value) === "[object Number]";
        }
        Is3.number = number;
        function numberRange(value, min, max) {
          return toString.call(value) === "[object Number]" && min <= value && value <= max;
        }
        Is3.numberRange = numberRange;
        function integer3(value) {
          return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
        }
        Is3.integer = integer3;
        function uinteger3(value) {
          return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
        }
        Is3.uinteger = uinteger3;
        function func(value) {
          return toString.call(value) === "[object Function]";
        }
        Is3.func = func;
        function objectLiteral(value) {
          return value !== null && typeof value === "object";
        }
        Is3.objectLiteral = objectLiteral;
        function typedArray(value, check) {
          return Array.isArray(value) && value.every(check);
        }
        Is3.typedArray = typedArray;
      })(Is2 || (Is2 = {}));
    });
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/messages.js
var require_messages2 = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/messages.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ProtocolNotificationType = exports2.ProtocolNotificationType0 = exports2.ProtocolRequestType = exports2.ProtocolRequestType0 = exports2.RegistrationType = exports2.MessageDirection = void 0;
    var vscode_jsonrpc_1 = require_main();
    var MessageDirection;
    (function(MessageDirection2) {
      MessageDirection2["clientToServer"] = "clientToServer";
      MessageDirection2["serverToClient"] = "serverToClient";
      MessageDirection2["both"] = "both";
    })(MessageDirection || (exports2.MessageDirection = MessageDirection = {}));
    var RegistrationType = class {
      constructor(method) {
        this.method = method;
      }
    };
    exports2.RegistrationType = RegistrationType;
    var ProtocolRequestType0 = class extends vscode_jsonrpc_1.RequestType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolRequestType0 = ProtocolRequestType0;
    var ProtocolRequestType = class extends vscode_jsonrpc_1.RequestType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolRequestType = ProtocolRequestType;
    var ProtocolNotificationType0 = class extends vscode_jsonrpc_1.NotificationType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolNotificationType0 = ProtocolNotificationType0;
    var ProtocolNotificationType = class extends vscode_jsonrpc_1.NotificationType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolNotificationType = ProtocolNotificationType;
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/utils/is.js
var require_is3 = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/utils/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.objectLiteral = exports2.typedArray = exports2.stringArray = exports2.array = exports2.func = exports2.error = exports2.number = exports2.string = exports2.boolean = void 0;
    function boolean(value) {
      return value === true || value === false;
    }
    exports2.boolean = boolean;
    function string(value) {
      return typeof value === "string" || value instanceof String;
    }
    exports2.string = string;
    function number(value) {
      return typeof value === "number" || value instanceof Number;
    }
    exports2.number = number;
    function error(value) {
      return value instanceof Error;
    }
    exports2.error = error;
    function func(value) {
      return typeof value === "function";
    }
    exports2.func = func;
    function array(value) {
      return Array.isArray(value);
    }
    exports2.array = array;
    function stringArray(value) {
      return array(value) && value.every((elem) => string(elem));
    }
    exports2.stringArray = stringArray;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    exports2.typedArray = typedArray;
    function objectLiteral(value) {
      return value !== null && typeof value === "object";
    }
    exports2.objectLiteral = objectLiteral;
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js
var require_protocol_implementation = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ImplementationRequest = void 0;
    var messages_1 = require_messages2();
    var ImplementationRequest;
    (function(ImplementationRequest2) {
      ImplementationRequest2.method = "textDocument/implementation";
      ImplementationRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      ImplementationRequest2.type = new messages_1.ProtocolRequestType(ImplementationRequest2.method);
    })(ImplementationRequest || (exports2.ImplementationRequest = ImplementationRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js
var require_protocol_typeDefinition = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypeDefinitionRequest = void 0;
    var messages_1 = require_messages2();
    var TypeDefinitionRequest;
    (function(TypeDefinitionRequest2) {
      TypeDefinitionRequest2.method = "textDocument/typeDefinition";
      TypeDefinitionRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      TypeDefinitionRequest2.type = new messages_1.ProtocolRequestType(TypeDefinitionRequest2.method);
    })(TypeDefinitionRequest || (exports2.TypeDefinitionRequest = TypeDefinitionRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolder.js
var require_protocol_workspaceFolder = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = void 0;
    var messages_1 = require_messages2();
    var WorkspaceFoldersRequest;
    (function(WorkspaceFoldersRequest2) {
      WorkspaceFoldersRequest2.method = "workspace/workspaceFolders";
      WorkspaceFoldersRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      WorkspaceFoldersRequest2.type = new messages_1.ProtocolRequestType0(WorkspaceFoldersRequest2.method);
    })(WorkspaceFoldersRequest || (exports2.WorkspaceFoldersRequest = WorkspaceFoldersRequest = {}));
    var DidChangeWorkspaceFoldersNotification;
    (function(DidChangeWorkspaceFoldersNotification2) {
      DidChangeWorkspaceFoldersNotification2.method = "workspace/didChangeWorkspaceFolders";
      DidChangeWorkspaceFoldersNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidChangeWorkspaceFoldersNotification2.type = new messages_1.ProtocolNotificationType(DidChangeWorkspaceFoldersNotification2.method);
    })(DidChangeWorkspaceFoldersNotification || (exports2.DidChangeWorkspaceFoldersNotification = DidChangeWorkspaceFoldersNotification = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js
var require_protocol_configuration = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ConfigurationRequest = void 0;
    var messages_1 = require_messages2();
    var ConfigurationRequest;
    (function(ConfigurationRequest2) {
      ConfigurationRequest2.method = "workspace/configuration";
      ConfigurationRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      ConfigurationRequest2.type = new messages_1.ProtocolRequestType(ConfigurationRequest2.method);
    })(ConfigurationRequest || (exports2.ConfigurationRequest = ConfigurationRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js
var require_protocol_colorProvider = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ColorPresentationRequest = exports2.DocumentColorRequest = void 0;
    var messages_1 = require_messages2();
    var DocumentColorRequest;
    (function(DocumentColorRequest2) {
      DocumentColorRequest2.method = "textDocument/documentColor";
      DocumentColorRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentColorRequest2.type = new messages_1.ProtocolRequestType(DocumentColorRequest2.method);
    })(DocumentColorRequest || (exports2.DocumentColorRequest = DocumentColorRequest = {}));
    var ColorPresentationRequest;
    (function(ColorPresentationRequest2) {
      ColorPresentationRequest2.method = "textDocument/colorPresentation";
      ColorPresentationRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      ColorPresentationRequest2.type = new messages_1.ProtocolRequestType(ColorPresentationRequest2.method);
    })(ColorPresentationRequest || (exports2.ColorPresentationRequest = ColorPresentationRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js
var require_protocol_foldingRange = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FoldingRangeRefreshRequest = exports2.FoldingRangeRequest = void 0;
    var messages_1 = require_messages2();
    var FoldingRangeRequest;
    (function(FoldingRangeRequest2) {
      FoldingRangeRequest2.method = "textDocument/foldingRange";
      FoldingRangeRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      FoldingRangeRequest2.type = new messages_1.ProtocolRequestType(FoldingRangeRequest2.method);
    })(FoldingRangeRequest || (exports2.FoldingRangeRequest = FoldingRangeRequest = {}));
    var FoldingRangeRefreshRequest;
    (function(FoldingRangeRefreshRequest2) {
      FoldingRangeRefreshRequest2.method = `workspace/foldingRange/refresh`;
      FoldingRangeRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      FoldingRangeRefreshRequest2.type = new messages_1.ProtocolRequestType0(FoldingRangeRefreshRequest2.method);
    })(FoldingRangeRefreshRequest || (exports2.FoldingRangeRefreshRequest = FoldingRangeRefreshRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js
var require_protocol_declaration = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeclarationRequest = void 0;
    var messages_1 = require_messages2();
    var DeclarationRequest;
    (function(DeclarationRequest2) {
      DeclarationRequest2.method = "textDocument/declaration";
      DeclarationRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DeclarationRequest2.type = new messages_1.ProtocolRequestType(DeclarationRequest2.method);
    })(DeclarationRequest || (exports2.DeclarationRequest = DeclarationRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js
var require_protocol_selectionRange = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SelectionRangeRequest = void 0;
    var messages_1 = require_messages2();
    var SelectionRangeRequest;
    (function(SelectionRangeRequest2) {
      SelectionRangeRequest2.method = "textDocument/selectionRange";
      SelectionRangeRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      SelectionRangeRequest2.type = new messages_1.ProtocolRequestType(SelectionRangeRequest2.method);
    })(SelectionRangeRequest || (exports2.SelectionRangeRequest = SelectionRangeRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js
var require_protocol_progress = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = void 0;
    var vscode_jsonrpc_1 = require_main();
    var messages_1 = require_messages2();
    var WorkDoneProgress;
    (function(WorkDoneProgress2) {
      WorkDoneProgress2.type = new vscode_jsonrpc_1.ProgressType();
      function is(value) {
        return value === WorkDoneProgress2.type;
      }
      WorkDoneProgress2.is = is;
    })(WorkDoneProgress || (exports2.WorkDoneProgress = WorkDoneProgress = {}));
    var WorkDoneProgressCreateRequest;
    (function(WorkDoneProgressCreateRequest2) {
      WorkDoneProgressCreateRequest2.method = "window/workDoneProgress/create";
      WorkDoneProgressCreateRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      WorkDoneProgressCreateRequest2.type = new messages_1.ProtocolRequestType(WorkDoneProgressCreateRequest2.method);
    })(WorkDoneProgressCreateRequest || (exports2.WorkDoneProgressCreateRequest = WorkDoneProgressCreateRequest = {}));
    var WorkDoneProgressCancelNotification;
    (function(WorkDoneProgressCancelNotification2) {
      WorkDoneProgressCancelNotification2.method = "window/workDoneProgress/cancel";
      WorkDoneProgressCancelNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      WorkDoneProgressCancelNotification2.type = new messages_1.ProtocolNotificationType(WorkDoneProgressCancelNotification2.method);
    })(WorkDoneProgressCancelNotification || (exports2.WorkDoneProgressCancelNotification = WorkDoneProgressCancelNotification = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js
var require_protocol_callHierarchy = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.CallHierarchyPrepareRequest = void 0;
    var messages_1 = require_messages2();
    var CallHierarchyPrepareRequest;
    (function(CallHierarchyPrepareRequest2) {
      CallHierarchyPrepareRequest2.method = "textDocument/prepareCallHierarchy";
      CallHierarchyPrepareRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CallHierarchyPrepareRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyPrepareRequest2.method);
    })(CallHierarchyPrepareRequest || (exports2.CallHierarchyPrepareRequest = CallHierarchyPrepareRequest = {}));
    var CallHierarchyIncomingCallsRequest;
    (function(CallHierarchyIncomingCallsRequest2) {
      CallHierarchyIncomingCallsRequest2.method = "callHierarchy/incomingCalls";
      CallHierarchyIncomingCallsRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CallHierarchyIncomingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyIncomingCallsRequest2.method);
    })(CallHierarchyIncomingCallsRequest || (exports2.CallHierarchyIncomingCallsRequest = CallHierarchyIncomingCallsRequest = {}));
    var CallHierarchyOutgoingCallsRequest;
    (function(CallHierarchyOutgoingCallsRequest2) {
      CallHierarchyOutgoingCallsRequest2.method = "callHierarchy/outgoingCalls";
      CallHierarchyOutgoingCallsRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CallHierarchyOutgoingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyOutgoingCallsRequest2.method);
    })(CallHierarchyOutgoingCallsRequest || (exports2.CallHierarchyOutgoingCallsRequest = CallHierarchyOutgoingCallsRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js
var require_protocol_semanticTokens = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.SemanticTokensRegistrationType = exports2.TokenFormat = void 0;
    var messages_1 = require_messages2();
    var TokenFormat;
    (function(TokenFormat2) {
      TokenFormat2.Relative = "relative";
    })(TokenFormat || (exports2.TokenFormat = TokenFormat = {}));
    var SemanticTokensRegistrationType;
    (function(SemanticTokensRegistrationType2) {
      SemanticTokensRegistrationType2.method = "textDocument/semanticTokens";
      SemanticTokensRegistrationType2.type = new messages_1.RegistrationType(SemanticTokensRegistrationType2.method);
    })(SemanticTokensRegistrationType || (exports2.SemanticTokensRegistrationType = SemanticTokensRegistrationType = {}));
    var SemanticTokensRequest;
    (function(SemanticTokensRequest2) {
      SemanticTokensRequest2.method = "textDocument/semanticTokens/full";
      SemanticTokensRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      SemanticTokensRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRequest2.method);
      SemanticTokensRequest2.registrationMethod = SemanticTokensRegistrationType.method;
    })(SemanticTokensRequest || (exports2.SemanticTokensRequest = SemanticTokensRequest = {}));
    var SemanticTokensDeltaRequest;
    (function(SemanticTokensDeltaRequest2) {
      SemanticTokensDeltaRequest2.method = "textDocument/semanticTokens/full/delta";
      SemanticTokensDeltaRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      SemanticTokensDeltaRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensDeltaRequest2.method);
      SemanticTokensDeltaRequest2.registrationMethod = SemanticTokensRegistrationType.method;
    })(SemanticTokensDeltaRequest || (exports2.SemanticTokensDeltaRequest = SemanticTokensDeltaRequest = {}));
    var SemanticTokensRangeRequest;
    (function(SemanticTokensRangeRequest2) {
      SemanticTokensRangeRequest2.method = "textDocument/semanticTokens/range";
      SemanticTokensRangeRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      SemanticTokensRangeRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRangeRequest2.method);
      SemanticTokensRangeRequest2.registrationMethod = SemanticTokensRegistrationType.method;
    })(SemanticTokensRangeRequest || (exports2.SemanticTokensRangeRequest = SemanticTokensRangeRequest = {}));
    var SemanticTokensRefreshRequest;
    (function(SemanticTokensRefreshRequest2) {
      SemanticTokensRefreshRequest2.method = `workspace/semanticTokens/refresh`;
      SemanticTokensRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      SemanticTokensRefreshRequest2.type = new messages_1.ProtocolRequestType0(SemanticTokensRefreshRequest2.method);
    })(SemanticTokensRefreshRequest || (exports2.SemanticTokensRefreshRequest = SemanticTokensRefreshRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js
var require_protocol_showDocument = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ShowDocumentRequest = void 0;
    var messages_1 = require_messages2();
    var ShowDocumentRequest;
    (function(ShowDocumentRequest2) {
      ShowDocumentRequest2.method = "window/showDocument";
      ShowDocumentRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      ShowDocumentRequest2.type = new messages_1.ProtocolRequestType(ShowDocumentRequest2.method);
    })(ShowDocumentRequest || (exports2.ShowDocumentRequest = ShowDocumentRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js
var require_protocol_linkedEditingRange = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LinkedEditingRangeRequest = void 0;
    var messages_1 = require_messages2();
    var LinkedEditingRangeRequest;
    (function(LinkedEditingRangeRequest2) {
      LinkedEditingRangeRequest2.method = "textDocument/linkedEditingRange";
      LinkedEditingRangeRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      LinkedEditingRangeRequest2.type = new messages_1.ProtocolRequestType(LinkedEditingRangeRequest2.method);
    })(LinkedEditingRangeRequest || (exports2.LinkedEditingRangeRequest = LinkedEditingRangeRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js
var require_protocol_fileOperations = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.DidRenameFilesNotification = exports2.WillRenameFilesRequest = exports2.DidCreateFilesNotification = exports2.WillCreateFilesRequest = exports2.FileOperationPatternKind = void 0;
    var messages_1 = require_messages2();
    var FileOperationPatternKind;
    (function(FileOperationPatternKind2) {
      FileOperationPatternKind2.file = "file";
      FileOperationPatternKind2.folder = "folder";
    })(FileOperationPatternKind || (exports2.FileOperationPatternKind = FileOperationPatternKind = {}));
    var WillCreateFilesRequest;
    (function(WillCreateFilesRequest2) {
      WillCreateFilesRequest2.method = "workspace/willCreateFiles";
      WillCreateFilesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WillCreateFilesRequest2.type = new messages_1.ProtocolRequestType(WillCreateFilesRequest2.method);
    })(WillCreateFilesRequest || (exports2.WillCreateFilesRequest = WillCreateFilesRequest = {}));
    var DidCreateFilesNotification;
    (function(DidCreateFilesNotification2) {
      DidCreateFilesNotification2.method = "workspace/didCreateFiles";
      DidCreateFilesNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidCreateFilesNotification2.type = new messages_1.ProtocolNotificationType(DidCreateFilesNotification2.method);
    })(DidCreateFilesNotification || (exports2.DidCreateFilesNotification = DidCreateFilesNotification = {}));
    var WillRenameFilesRequest;
    (function(WillRenameFilesRequest2) {
      WillRenameFilesRequest2.method = "workspace/willRenameFiles";
      WillRenameFilesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WillRenameFilesRequest2.type = new messages_1.ProtocolRequestType(WillRenameFilesRequest2.method);
    })(WillRenameFilesRequest || (exports2.WillRenameFilesRequest = WillRenameFilesRequest = {}));
    var DidRenameFilesNotification;
    (function(DidRenameFilesNotification2) {
      DidRenameFilesNotification2.method = "workspace/didRenameFiles";
      DidRenameFilesNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidRenameFilesNotification2.type = new messages_1.ProtocolNotificationType(DidRenameFilesNotification2.method);
    })(DidRenameFilesNotification || (exports2.DidRenameFilesNotification = DidRenameFilesNotification = {}));
    var DidDeleteFilesNotification;
    (function(DidDeleteFilesNotification2) {
      DidDeleteFilesNotification2.method = "workspace/didDeleteFiles";
      DidDeleteFilesNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidDeleteFilesNotification2.type = new messages_1.ProtocolNotificationType(DidDeleteFilesNotification2.method);
    })(DidDeleteFilesNotification || (exports2.DidDeleteFilesNotification = DidDeleteFilesNotification = {}));
    var WillDeleteFilesRequest;
    (function(WillDeleteFilesRequest2) {
      WillDeleteFilesRequest2.method = "workspace/willDeleteFiles";
      WillDeleteFilesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WillDeleteFilesRequest2.type = new messages_1.ProtocolRequestType(WillDeleteFilesRequest2.method);
    })(WillDeleteFilesRequest || (exports2.WillDeleteFilesRequest = WillDeleteFilesRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js
var require_protocol_moniker = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = void 0;
    var messages_1 = require_messages2();
    var UniquenessLevel;
    (function(UniquenessLevel2) {
      UniquenessLevel2.document = "document";
      UniquenessLevel2.project = "project";
      UniquenessLevel2.group = "group";
      UniquenessLevel2.scheme = "scheme";
      UniquenessLevel2.global = "global";
    })(UniquenessLevel || (exports2.UniquenessLevel = UniquenessLevel = {}));
    var MonikerKind;
    (function(MonikerKind2) {
      MonikerKind2.$import = "import";
      MonikerKind2.$export = "export";
      MonikerKind2.local = "local";
    })(MonikerKind || (exports2.MonikerKind = MonikerKind = {}));
    var MonikerRequest;
    (function(MonikerRequest2) {
      MonikerRequest2.method = "textDocument/moniker";
      MonikerRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      MonikerRequest2.type = new messages_1.ProtocolRequestType(MonikerRequest2.method);
    })(MonikerRequest || (exports2.MonikerRequest = MonikerRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.typeHierarchy.js
var require_protocol_typeHierarchy = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.typeHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypeHierarchySubtypesRequest = exports2.TypeHierarchySupertypesRequest = exports2.TypeHierarchyPrepareRequest = void 0;
    var messages_1 = require_messages2();
    var TypeHierarchyPrepareRequest;
    (function(TypeHierarchyPrepareRequest2) {
      TypeHierarchyPrepareRequest2.method = "textDocument/prepareTypeHierarchy";
      TypeHierarchyPrepareRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      TypeHierarchyPrepareRequest2.type = new messages_1.ProtocolRequestType(TypeHierarchyPrepareRequest2.method);
    })(TypeHierarchyPrepareRequest || (exports2.TypeHierarchyPrepareRequest = TypeHierarchyPrepareRequest = {}));
    var TypeHierarchySupertypesRequest;
    (function(TypeHierarchySupertypesRequest2) {
      TypeHierarchySupertypesRequest2.method = "typeHierarchy/supertypes";
      TypeHierarchySupertypesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      TypeHierarchySupertypesRequest2.type = new messages_1.ProtocolRequestType(TypeHierarchySupertypesRequest2.method);
    })(TypeHierarchySupertypesRequest || (exports2.TypeHierarchySupertypesRequest = TypeHierarchySupertypesRequest = {}));
    var TypeHierarchySubtypesRequest;
    (function(TypeHierarchySubtypesRequest2) {
      TypeHierarchySubtypesRequest2.method = "typeHierarchy/subtypes";
      TypeHierarchySubtypesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      TypeHierarchySubtypesRequest2.type = new messages_1.ProtocolRequestType(TypeHierarchySubtypesRequest2.method);
    })(TypeHierarchySubtypesRequest || (exports2.TypeHierarchySubtypesRequest = TypeHierarchySubtypesRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.inlineValue.js
var require_protocol_inlineValue = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.inlineValue.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlineValueRefreshRequest = exports2.InlineValueRequest = void 0;
    var messages_1 = require_messages2();
    var InlineValueRequest;
    (function(InlineValueRequest2) {
      InlineValueRequest2.method = "textDocument/inlineValue";
      InlineValueRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      InlineValueRequest2.type = new messages_1.ProtocolRequestType(InlineValueRequest2.method);
    })(InlineValueRequest || (exports2.InlineValueRequest = InlineValueRequest = {}));
    var InlineValueRefreshRequest;
    (function(InlineValueRefreshRequest2) {
      InlineValueRefreshRequest2.method = `workspace/inlineValue/refresh`;
      InlineValueRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      InlineValueRefreshRequest2.type = new messages_1.ProtocolRequestType0(InlineValueRefreshRequest2.method);
    })(InlineValueRefreshRequest || (exports2.InlineValueRefreshRequest = InlineValueRefreshRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.inlayHint.js
var require_protocol_inlayHint = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.inlayHint.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlayHintRefreshRequest = exports2.InlayHintResolveRequest = exports2.InlayHintRequest = void 0;
    var messages_1 = require_messages2();
    var InlayHintRequest;
    (function(InlayHintRequest2) {
      InlayHintRequest2.method = "textDocument/inlayHint";
      InlayHintRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      InlayHintRequest2.type = new messages_1.ProtocolRequestType(InlayHintRequest2.method);
    })(InlayHintRequest || (exports2.InlayHintRequest = InlayHintRequest = {}));
    var InlayHintResolveRequest;
    (function(InlayHintResolveRequest2) {
      InlayHintResolveRequest2.method = "inlayHint/resolve";
      InlayHintResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      InlayHintResolveRequest2.type = new messages_1.ProtocolRequestType(InlayHintResolveRequest2.method);
    })(InlayHintResolveRequest || (exports2.InlayHintResolveRequest = InlayHintResolveRequest = {}));
    var InlayHintRefreshRequest;
    (function(InlayHintRefreshRequest2) {
      InlayHintRefreshRequest2.method = `workspace/inlayHint/refresh`;
      InlayHintRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      InlayHintRefreshRequest2.type = new messages_1.ProtocolRequestType0(InlayHintRefreshRequest2.method);
    })(InlayHintRefreshRequest || (exports2.InlayHintRefreshRequest = InlayHintRefreshRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.diagnostic.js
var require_protocol_diagnostic = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.diagnostic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DiagnosticRefreshRequest = exports2.WorkspaceDiagnosticRequest = exports2.DocumentDiagnosticRequest = exports2.DocumentDiagnosticReportKind = exports2.DiagnosticServerCancellationData = void 0;
    var vscode_jsonrpc_1 = require_main();
    var Is2 = require_is3();
    var messages_1 = require_messages2();
    var DiagnosticServerCancellationData;
    (function(DiagnosticServerCancellationData2) {
      function is(value) {
        const candidate = value;
        return candidate && Is2.boolean(candidate.retriggerRequest);
      }
      DiagnosticServerCancellationData2.is = is;
    })(DiagnosticServerCancellationData || (exports2.DiagnosticServerCancellationData = DiagnosticServerCancellationData = {}));
    var DocumentDiagnosticReportKind;
    (function(DocumentDiagnosticReportKind2) {
      DocumentDiagnosticReportKind2.Full = "full";
      DocumentDiagnosticReportKind2.Unchanged = "unchanged";
    })(DocumentDiagnosticReportKind || (exports2.DocumentDiagnosticReportKind = DocumentDiagnosticReportKind = {}));
    var DocumentDiagnosticRequest;
    (function(DocumentDiagnosticRequest2) {
      DocumentDiagnosticRequest2.method = "textDocument/diagnostic";
      DocumentDiagnosticRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentDiagnosticRequest2.type = new messages_1.ProtocolRequestType(DocumentDiagnosticRequest2.method);
      DocumentDiagnosticRequest2.partialResult = new vscode_jsonrpc_1.ProgressType();
    })(DocumentDiagnosticRequest || (exports2.DocumentDiagnosticRequest = DocumentDiagnosticRequest = {}));
    var WorkspaceDiagnosticRequest;
    (function(WorkspaceDiagnosticRequest2) {
      WorkspaceDiagnosticRequest2.method = "workspace/diagnostic";
      WorkspaceDiagnosticRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WorkspaceDiagnosticRequest2.type = new messages_1.ProtocolRequestType(WorkspaceDiagnosticRequest2.method);
      WorkspaceDiagnosticRequest2.partialResult = new vscode_jsonrpc_1.ProgressType();
    })(WorkspaceDiagnosticRequest || (exports2.WorkspaceDiagnosticRequest = WorkspaceDiagnosticRequest = {}));
    var DiagnosticRefreshRequest;
    (function(DiagnosticRefreshRequest2) {
      DiagnosticRefreshRequest2.method = `workspace/diagnostic/refresh`;
      DiagnosticRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      DiagnosticRefreshRequest2.type = new messages_1.ProtocolRequestType0(DiagnosticRefreshRequest2.method);
    })(DiagnosticRefreshRequest || (exports2.DiagnosticRefreshRequest = DiagnosticRefreshRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.notebook.js
var require_protocol_notebook = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.notebook.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DidCloseNotebookDocumentNotification = exports2.DidSaveNotebookDocumentNotification = exports2.DidChangeNotebookDocumentNotification = exports2.NotebookCellArrayChange = exports2.DidOpenNotebookDocumentNotification = exports2.NotebookDocumentSyncRegistrationType = exports2.NotebookDocument = exports2.NotebookCell = exports2.ExecutionSummary = exports2.NotebookCellKind = void 0;
    var vscode_languageserver_types_1 = require_main2();
    var Is2 = require_is3();
    var messages_1 = require_messages2();
    var NotebookCellKind;
    (function(NotebookCellKind2) {
      NotebookCellKind2.Markup = 1;
      NotebookCellKind2.Code = 2;
      function is(value) {
        return value === 1 || value === 2;
      }
      NotebookCellKind2.is = is;
    })(NotebookCellKind || (exports2.NotebookCellKind = NotebookCellKind = {}));
    var ExecutionSummary;
    (function(ExecutionSummary2) {
      function create(executionOrder, success) {
        const result = { executionOrder };
        if (success === true || success === false) {
          result.success = success;
        }
        return result;
      }
      ExecutionSummary2.create = create;
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && vscode_languageserver_types_1.uinteger.is(candidate.executionOrder) && (candidate.success === void 0 || Is2.boolean(candidate.success));
      }
      ExecutionSummary2.is = is;
      function equals2(one, other) {
        if (one === other) {
          return true;
        }
        if (one === null || one === void 0 || other === null || other === void 0) {
          return false;
        }
        return one.executionOrder === other.executionOrder && one.success === other.success;
      }
      ExecutionSummary2.equals = equals2;
    })(ExecutionSummary || (exports2.ExecutionSummary = ExecutionSummary = {}));
    var NotebookCell;
    (function(NotebookCell2) {
      function create(kind, document2) {
        return { kind, document: document2 };
      }
      NotebookCell2.create = create;
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && NotebookCellKind.is(candidate.kind) && vscode_languageserver_types_1.DocumentUri.is(candidate.document) && (candidate.metadata === void 0 || Is2.objectLiteral(candidate.metadata));
      }
      NotebookCell2.is = is;
      function diff(one, two) {
        const result = /* @__PURE__ */ new Set();
        if (one.document !== two.document) {
          result.add("document");
        }
        if (one.kind !== two.kind) {
          result.add("kind");
        }
        if (one.executionSummary !== two.executionSummary) {
          result.add("executionSummary");
        }
        if ((one.metadata !== void 0 || two.metadata !== void 0) && !equalsMetadata(one.metadata, two.metadata)) {
          result.add("metadata");
        }
        if ((one.executionSummary !== void 0 || two.executionSummary !== void 0) && !ExecutionSummary.equals(one.executionSummary, two.executionSummary)) {
          result.add("executionSummary");
        }
        return result;
      }
      NotebookCell2.diff = diff;
      function equalsMetadata(one, other) {
        if (one === other) {
          return true;
        }
        if (one === null || one === void 0 || other === null || other === void 0) {
          return false;
        }
        if (typeof one !== typeof other) {
          return false;
        }
        if (typeof one !== "object") {
          return false;
        }
        const oneArray = Array.isArray(one);
        const otherArray = Array.isArray(other);
        if (oneArray !== otherArray) {
          return false;
        }
        if (oneArray && otherArray) {
          if (one.length !== other.length) {
            return false;
          }
          for (let i = 0; i < one.length; i++) {
            if (!equalsMetadata(one[i], other[i])) {
              return false;
            }
          }
        }
        if (Is2.objectLiteral(one) && Is2.objectLiteral(other)) {
          const oneKeys = Object.keys(one);
          const otherKeys = Object.keys(other);
          if (oneKeys.length !== otherKeys.length) {
            return false;
          }
          oneKeys.sort();
          otherKeys.sort();
          if (!equalsMetadata(oneKeys, otherKeys)) {
            return false;
          }
          for (let i = 0; i < oneKeys.length; i++) {
            const prop = oneKeys[i];
            if (!equalsMetadata(one[prop], other[prop])) {
              return false;
            }
          }
        }
        return true;
      }
    })(NotebookCell || (exports2.NotebookCell = NotebookCell = {}));
    var NotebookDocument;
    (function(NotebookDocument2) {
      function create(uri, notebookType, version, cells) {
        return { uri, notebookType, version, cells };
      }
      NotebookDocument2.create = create;
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && Is2.string(candidate.uri) && vscode_languageserver_types_1.integer.is(candidate.version) && Is2.typedArray(candidate.cells, NotebookCell.is);
      }
      NotebookDocument2.is = is;
    })(NotebookDocument || (exports2.NotebookDocument = NotebookDocument = {}));
    var NotebookDocumentSyncRegistrationType;
    (function(NotebookDocumentSyncRegistrationType2) {
      NotebookDocumentSyncRegistrationType2.method = "notebookDocument/sync";
      NotebookDocumentSyncRegistrationType2.messageDirection = messages_1.MessageDirection.clientToServer;
      NotebookDocumentSyncRegistrationType2.type = new messages_1.RegistrationType(NotebookDocumentSyncRegistrationType2.method);
    })(NotebookDocumentSyncRegistrationType || (exports2.NotebookDocumentSyncRegistrationType = NotebookDocumentSyncRegistrationType = {}));
    var DidOpenNotebookDocumentNotification;
    (function(DidOpenNotebookDocumentNotification2) {
      DidOpenNotebookDocumentNotification2.method = "notebookDocument/didOpen";
      DidOpenNotebookDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidOpenNotebookDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidOpenNotebookDocumentNotification2.method);
      DidOpenNotebookDocumentNotification2.registrationMethod = NotebookDocumentSyncRegistrationType.method;
    })(DidOpenNotebookDocumentNotification || (exports2.DidOpenNotebookDocumentNotification = DidOpenNotebookDocumentNotification = {}));
    var NotebookCellArrayChange;
    (function(NotebookCellArrayChange2) {
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && vscode_languageserver_types_1.uinteger.is(candidate.start) && vscode_languageserver_types_1.uinteger.is(candidate.deleteCount) && (candidate.cells === void 0 || Is2.typedArray(candidate.cells, NotebookCell.is));
      }
      NotebookCellArrayChange2.is = is;
      function create(start, deleteCount, cells) {
        const result = { start, deleteCount };
        if (cells !== void 0) {
          result.cells = cells;
        }
        return result;
      }
      NotebookCellArrayChange2.create = create;
    })(NotebookCellArrayChange || (exports2.NotebookCellArrayChange = NotebookCellArrayChange = {}));
    var DidChangeNotebookDocumentNotification;
    (function(DidChangeNotebookDocumentNotification2) {
      DidChangeNotebookDocumentNotification2.method = "notebookDocument/didChange";
      DidChangeNotebookDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidChangeNotebookDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidChangeNotebookDocumentNotification2.method);
      DidChangeNotebookDocumentNotification2.registrationMethod = NotebookDocumentSyncRegistrationType.method;
    })(DidChangeNotebookDocumentNotification || (exports2.DidChangeNotebookDocumentNotification = DidChangeNotebookDocumentNotification = {}));
    var DidSaveNotebookDocumentNotification;
    (function(DidSaveNotebookDocumentNotification2) {
      DidSaveNotebookDocumentNotification2.method = "notebookDocument/didSave";
      DidSaveNotebookDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidSaveNotebookDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidSaveNotebookDocumentNotification2.method);
      DidSaveNotebookDocumentNotification2.registrationMethod = NotebookDocumentSyncRegistrationType.method;
    })(DidSaveNotebookDocumentNotification || (exports2.DidSaveNotebookDocumentNotification = DidSaveNotebookDocumentNotification = {}));
    var DidCloseNotebookDocumentNotification;
    (function(DidCloseNotebookDocumentNotification2) {
      DidCloseNotebookDocumentNotification2.method = "notebookDocument/didClose";
      DidCloseNotebookDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidCloseNotebookDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidCloseNotebookDocumentNotification2.method);
      DidCloseNotebookDocumentNotification2.registrationMethod = NotebookDocumentSyncRegistrationType.method;
    })(DidCloseNotebookDocumentNotification || (exports2.DidCloseNotebookDocumentNotification = DidCloseNotebookDocumentNotification = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.inlineCompletion.js
var require_protocol_inlineCompletion = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.inlineCompletion.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlineCompletionRequest = void 0;
    var messages_1 = require_messages2();
    var InlineCompletionRequest;
    (function(InlineCompletionRequest2) {
      InlineCompletionRequest2.method = "textDocument/inlineCompletion";
      InlineCompletionRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      InlineCompletionRequest2.type = new messages_1.ProtocolRequestType(InlineCompletionRequest2.method);
    })(InlineCompletionRequest || (exports2.InlineCompletionRequest = InlineCompletionRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/protocol.js
var require_protocol = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/protocol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WorkspaceSymbolRequest = exports2.CodeActionResolveRequest = exports2.CodeActionRequest = exports2.DocumentSymbolRequest = exports2.DocumentHighlightRequest = exports2.ReferencesRequest = exports2.DefinitionRequest = exports2.SignatureHelpRequest = exports2.SignatureHelpTriggerKind = exports2.HoverRequest = exports2.CompletionResolveRequest = exports2.CompletionRequest = exports2.CompletionTriggerKind = exports2.PublishDiagnosticsNotification = exports2.WatchKind = exports2.RelativePattern = exports2.FileChangeType = exports2.DidChangeWatchedFilesNotification = exports2.WillSaveTextDocumentWaitUntilRequest = exports2.WillSaveTextDocumentNotification = exports2.TextDocumentSaveReason = exports2.DidSaveTextDocumentNotification = exports2.DidCloseTextDocumentNotification = exports2.DidChangeTextDocumentNotification = exports2.TextDocumentContentChangeEvent = exports2.DidOpenTextDocumentNotification = exports2.TextDocumentSyncKind = exports2.TelemetryEventNotification = exports2.LogMessageNotification = exports2.ShowMessageRequest = exports2.ShowMessageNotification = exports2.MessageType = exports2.DidChangeConfigurationNotification = exports2.ExitNotification = exports2.ShutdownRequest = exports2.InitializedNotification = exports2.InitializeErrorCodes = exports2.InitializeRequest = exports2.WorkDoneProgressOptions = exports2.TextDocumentRegistrationOptions = exports2.StaticRegistrationOptions = exports2.PositionEncodingKind = exports2.FailureHandlingKind = exports2.ResourceOperationKind = exports2.UnregistrationRequest = exports2.RegistrationRequest = exports2.DocumentSelector = exports2.NotebookCellTextDocumentFilter = exports2.NotebookDocumentFilter = exports2.TextDocumentFilter = void 0;
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.WillRenameFilesRequest = exports2.DidRenameFilesNotification = exports2.WillCreateFilesRequest = exports2.DidCreateFilesNotification = exports2.FileOperationPatternKind = exports2.LinkedEditingRangeRequest = exports2.ShowDocumentRequest = exports2.SemanticTokensRegistrationType = exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.TokenFormat = exports2.CallHierarchyPrepareRequest = exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = exports2.SelectionRangeRequest = exports2.DeclarationRequest = exports2.FoldingRangeRefreshRequest = exports2.FoldingRangeRequest = exports2.ColorPresentationRequest = exports2.DocumentColorRequest = exports2.ConfigurationRequest = exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = exports2.TypeDefinitionRequest = exports2.ImplementationRequest = exports2.ApplyWorkspaceEditRequest = exports2.ExecuteCommandRequest = exports2.PrepareRenameRequest = exports2.RenameRequest = exports2.PrepareSupportDefaultBehavior = exports2.DocumentOnTypeFormattingRequest = exports2.DocumentRangesFormattingRequest = exports2.DocumentRangeFormattingRequest = exports2.DocumentFormattingRequest = exports2.DocumentLinkResolveRequest = exports2.DocumentLinkRequest = exports2.CodeLensRefreshRequest = exports2.CodeLensResolveRequest = exports2.CodeLensRequest = exports2.WorkspaceSymbolResolveRequest = void 0;
    exports2.InlineCompletionRequest = exports2.DidCloseNotebookDocumentNotification = exports2.DidSaveNotebookDocumentNotification = exports2.DidChangeNotebookDocumentNotification = exports2.NotebookCellArrayChange = exports2.DidOpenNotebookDocumentNotification = exports2.NotebookDocumentSyncRegistrationType = exports2.NotebookDocument = exports2.NotebookCell = exports2.ExecutionSummary = exports2.NotebookCellKind = exports2.DiagnosticRefreshRequest = exports2.WorkspaceDiagnosticRequest = exports2.DocumentDiagnosticRequest = exports2.DocumentDiagnosticReportKind = exports2.DiagnosticServerCancellationData = exports2.InlayHintRefreshRequest = exports2.InlayHintResolveRequest = exports2.InlayHintRequest = exports2.InlineValueRefreshRequest = exports2.InlineValueRequest = exports2.TypeHierarchySupertypesRequest = exports2.TypeHierarchySubtypesRequest = exports2.TypeHierarchyPrepareRequest = void 0;
    var messages_1 = require_messages2();
    var vscode_languageserver_types_1 = require_main2();
    var Is2 = require_is3();
    var protocol_implementation_1 = require_protocol_implementation();
    Object.defineProperty(exports2, "ImplementationRequest", { enumerable: true, get: function() {
      return protocol_implementation_1.ImplementationRequest;
    } });
    var protocol_typeDefinition_1 = require_protocol_typeDefinition();
    Object.defineProperty(exports2, "TypeDefinitionRequest", { enumerable: true, get: function() {
      return protocol_typeDefinition_1.TypeDefinitionRequest;
    } });
    var protocol_workspaceFolder_1 = require_protocol_workspaceFolder();
    Object.defineProperty(exports2, "WorkspaceFoldersRequest", { enumerable: true, get: function() {
      return protocol_workspaceFolder_1.WorkspaceFoldersRequest;
    } });
    Object.defineProperty(exports2, "DidChangeWorkspaceFoldersNotification", { enumerable: true, get: function() {
      return protocol_workspaceFolder_1.DidChangeWorkspaceFoldersNotification;
    } });
    var protocol_configuration_1 = require_protocol_configuration();
    Object.defineProperty(exports2, "ConfigurationRequest", { enumerable: true, get: function() {
      return protocol_configuration_1.ConfigurationRequest;
    } });
    var protocol_colorProvider_1 = require_protocol_colorProvider();
    Object.defineProperty(exports2, "DocumentColorRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.DocumentColorRequest;
    } });
    Object.defineProperty(exports2, "ColorPresentationRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.ColorPresentationRequest;
    } });
    var protocol_foldingRange_1 = require_protocol_foldingRange();
    Object.defineProperty(exports2, "FoldingRangeRequest", { enumerable: true, get: function() {
      return protocol_foldingRange_1.FoldingRangeRequest;
    } });
    Object.defineProperty(exports2, "FoldingRangeRefreshRequest", { enumerable: true, get: function() {
      return protocol_foldingRange_1.FoldingRangeRefreshRequest;
    } });
    var protocol_declaration_1 = require_protocol_declaration();
    Object.defineProperty(exports2, "DeclarationRequest", { enumerable: true, get: function() {
      return protocol_declaration_1.DeclarationRequest;
    } });
    var protocol_selectionRange_1 = require_protocol_selectionRange();
    Object.defineProperty(exports2, "SelectionRangeRequest", { enumerable: true, get: function() {
      return protocol_selectionRange_1.SelectionRangeRequest;
    } });
    var protocol_progress_1 = require_protocol_progress();
    Object.defineProperty(exports2, "WorkDoneProgress", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgress;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCreateRequest", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCreateRequest;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCancelNotification", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCancelNotification;
    } });
    var protocol_callHierarchy_1 = require_protocol_callHierarchy();
    Object.defineProperty(exports2, "CallHierarchyIncomingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyIncomingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyOutgoingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyOutgoingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyPrepareRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyPrepareRequest;
    } });
    var protocol_semanticTokens_1 = require_protocol_semanticTokens();
    Object.defineProperty(exports2, "TokenFormat", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.TokenFormat;
    } });
    Object.defineProperty(exports2, "SemanticTokensRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensDeltaRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensDeltaRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRangeRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRangeRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRefreshRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRefreshRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRegistrationType", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRegistrationType;
    } });
    var protocol_showDocument_1 = require_protocol_showDocument();
    Object.defineProperty(exports2, "ShowDocumentRequest", { enumerable: true, get: function() {
      return protocol_showDocument_1.ShowDocumentRequest;
    } });
    var protocol_linkedEditingRange_1 = require_protocol_linkedEditingRange();
    Object.defineProperty(exports2, "LinkedEditingRangeRequest", { enumerable: true, get: function() {
      return protocol_linkedEditingRange_1.LinkedEditingRangeRequest;
    } });
    var protocol_fileOperations_1 = require_protocol_fileOperations();
    Object.defineProperty(exports2, "FileOperationPatternKind", { enumerable: true, get: function() {
      return protocol_fileOperations_1.FileOperationPatternKind;
    } });
    Object.defineProperty(exports2, "DidCreateFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidCreateFilesNotification;
    } });
    Object.defineProperty(exports2, "WillCreateFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillCreateFilesRequest;
    } });
    Object.defineProperty(exports2, "DidRenameFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidRenameFilesNotification;
    } });
    Object.defineProperty(exports2, "WillRenameFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillRenameFilesRequest;
    } });
    Object.defineProperty(exports2, "DidDeleteFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidDeleteFilesNotification;
    } });
    Object.defineProperty(exports2, "WillDeleteFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillDeleteFilesRequest;
    } });
    var protocol_moniker_1 = require_protocol_moniker();
    Object.defineProperty(exports2, "UniquenessLevel", { enumerable: true, get: function() {
      return protocol_moniker_1.UniquenessLevel;
    } });
    Object.defineProperty(exports2, "MonikerKind", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerKind;
    } });
    Object.defineProperty(exports2, "MonikerRequest", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerRequest;
    } });
    var protocol_typeHierarchy_1 = require_protocol_typeHierarchy();
    Object.defineProperty(exports2, "TypeHierarchyPrepareRequest", { enumerable: true, get: function() {
      return protocol_typeHierarchy_1.TypeHierarchyPrepareRequest;
    } });
    Object.defineProperty(exports2, "TypeHierarchySubtypesRequest", { enumerable: true, get: function() {
      return protocol_typeHierarchy_1.TypeHierarchySubtypesRequest;
    } });
    Object.defineProperty(exports2, "TypeHierarchySupertypesRequest", { enumerable: true, get: function() {
      return protocol_typeHierarchy_1.TypeHierarchySupertypesRequest;
    } });
    var protocol_inlineValue_1 = require_protocol_inlineValue();
    Object.defineProperty(exports2, "InlineValueRequest", { enumerable: true, get: function() {
      return protocol_inlineValue_1.InlineValueRequest;
    } });
    Object.defineProperty(exports2, "InlineValueRefreshRequest", { enumerable: true, get: function() {
      return protocol_inlineValue_1.InlineValueRefreshRequest;
    } });
    var protocol_inlayHint_1 = require_protocol_inlayHint();
    Object.defineProperty(exports2, "InlayHintRequest", { enumerable: true, get: function() {
      return protocol_inlayHint_1.InlayHintRequest;
    } });
    Object.defineProperty(exports2, "InlayHintResolveRequest", { enumerable: true, get: function() {
      return protocol_inlayHint_1.InlayHintResolveRequest;
    } });
    Object.defineProperty(exports2, "InlayHintRefreshRequest", { enumerable: true, get: function() {
      return protocol_inlayHint_1.InlayHintRefreshRequest;
    } });
    var protocol_diagnostic_1 = require_protocol_diagnostic();
    Object.defineProperty(exports2, "DiagnosticServerCancellationData", { enumerable: true, get: function() {
      return protocol_diagnostic_1.DiagnosticServerCancellationData;
    } });
    Object.defineProperty(exports2, "DocumentDiagnosticReportKind", { enumerable: true, get: function() {
      return protocol_diagnostic_1.DocumentDiagnosticReportKind;
    } });
    Object.defineProperty(exports2, "DocumentDiagnosticRequest", { enumerable: true, get: function() {
      return protocol_diagnostic_1.DocumentDiagnosticRequest;
    } });
    Object.defineProperty(exports2, "WorkspaceDiagnosticRequest", { enumerable: true, get: function() {
      return protocol_diagnostic_1.WorkspaceDiagnosticRequest;
    } });
    Object.defineProperty(exports2, "DiagnosticRefreshRequest", { enumerable: true, get: function() {
      return protocol_diagnostic_1.DiagnosticRefreshRequest;
    } });
    var protocol_notebook_1 = require_protocol_notebook();
    Object.defineProperty(exports2, "NotebookCellKind", { enumerable: true, get: function() {
      return protocol_notebook_1.NotebookCellKind;
    } });
    Object.defineProperty(exports2, "ExecutionSummary", { enumerable: true, get: function() {
      return protocol_notebook_1.ExecutionSummary;
    } });
    Object.defineProperty(exports2, "NotebookCell", { enumerable: true, get: function() {
      return protocol_notebook_1.NotebookCell;
    } });
    Object.defineProperty(exports2, "NotebookDocument", { enumerable: true, get: function() {
      return protocol_notebook_1.NotebookDocument;
    } });
    Object.defineProperty(exports2, "NotebookDocumentSyncRegistrationType", { enumerable: true, get: function() {
      return protocol_notebook_1.NotebookDocumentSyncRegistrationType;
    } });
    Object.defineProperty(exports2, "DidOpenNotebookDocumentNotification", { enumerable: true, get: function() {
      return protocol_notebook_1.DidOpenNotebookDocumentNotification;
    } });
    Object.defineProperty(exports2, "NotebookCellArrayChange", { enumerable: true, get: function() {
      return protocol_notebook_1.NotebookCellArrayChange;
    } });
    Object.defineProperty(exports2, "DidChangeNotebookDocumentNotification", { enumerable: true, get: function() {
      return protocol_notebook_1.DidChangeNotebookDocumentNotification;
    } });
    Object.defineProperty(exports2, "DidSaveNotebookDocumentNotification", { enumerable: true, get: function() {
      return protocol_notebook_1.DidSaveNotebookDocumentNotification;
    } });
    Object.defineProperty(exports2, "DidCloseNotebookDocumentNotification", { enumerable: true, get: function() {
      return protocol_notebook_1.DidCloseNotebookDocumentNotification;
    } });
    var protocol_inlineCompletion_1 = require_protocol_inlineCompletion();
    Object.defineProperty(exports2, "InlineCompletionRequest", { enumerable: true, get: function() {
      return protocol_inlineCompletion_1.InlineCompletionRequest;
    } });
    var TextDocumentFilter;
    (function(TextDocumentFilter2) {
      function is(value) {
        const candidate = value;
        return Is2.string(candidate) || (Is2.string(candidate.language) || Is2.string(candidate.scheme) || Is2.string(candidate.pattern));
      }
      TextDocumentFilter2.is = is;
    })(TextDocumentFilter || (exports2.TextDocumentFilter = TextDocumentFilter = {}));
    var NotebookDocumentFilter;
    (function(NotebookDocumentFilter2) {
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && (Is2.string(candidate.notebookType) || Is2.string(candidate.scheme) || Is2.string(candidate.pattern));
      }
      NotebookDocumentFilter2.is = is;
    })(NotebookDocumentFilter || (exports2.NotebookDocumentFilter = NotebookDocumentFilter = {}));
    var NotebookCellTextDocumentFilter;
    (function(NotebookCellTextDocumentFilter2) {
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && (Is2.string(candidate.notebook) || NotebookDocumentFilter.is(candidate.notebook)) && (candidate.language === void 0 || Is2.string(candidate.language));
      }
      NotebookCellTextDocumentFilter2.is = is;
    })(NotebookCellTextDocumentFilter || (exports2.NotebookCellTextDocumentFilter = NotebookCellTextDocumentFilter = {}));
    var DocumentSelector;
    (function(DocumentSelector2) {
      function is(value) {
        if (!Array.isArray(value)) {
          return false;
        }
        for (let elem of value) {
          if (!Is2.string(elem) && !TextDocumentFilter.is(elem) && !NotebookCellTextDocumentFilter.is(elem)) {
            return false;
          }
        }
        return true;
      }
      DocumentSelector2.is = is;
    })(DocumentSelector || (exports2.DocumentSelector = DocumentSelector = {}));
    var RegistrationRequest;
    (function(RegistrationRequest2) {
      RegistrationRequest2.method = "client/registerCapability";
      RegistrationRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      RegistrationRequest2.type = new messages_1.ProtocolRequestType(RegistrationRequest2.method);
    })(RegistrationRequest || (exports2.RegistrationRequest = RegistrationRequest = {}));
    var UnregistrationRequest;
    (function(UnregistrationRequest2) {
      UnregistrationRequest2.method = "client/unregisterCapability";
      UnregistrationRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      UnregistrationRequest2.type = new messages_1.ProtocolRequestType(UnregistrationRequest2.method);
    })(UnregistrationRequest || (exports2.UnregistrationRequest = UnregistrationRequest = {}));
    var ResourceOperationKind;
    (function(ResourceOperationKind2) {
      ResourceOperationKind2.Create = "create";
      ResourceOperationKind2.Rename = "rename";
      ResourceOperationKind2.Delete = "delete";
    })(ResourceOperationKind || (exports2.ResourceOperationKind = ResourceOperationKind = {}));
    var FailureHandlingKind;
    (function(FailureHandlingKind2) {
      FailureHandlingKind2.Abort = "abort";
      FailureHandlingKind2.Transactional = "transactional";
      FailureHandlingKind2.TextOnlyTransactional = "textOnlyTransactional";
      FailureHandlingKind2.Undo = "undo";
    })(FailureHandlingKind || (exports2.FailureHandlingKind = FailureHandlingKind = {}));
    var PositionEncodingKind;
    (function(PositionEncodingKind2) {
      PositionEncodingKind2.UTF8 = "utf-8";
      PositionEncodingKind2.UTF16 = "utf-16";
      PositionEncodingKind2.UTF32 = "utf-32";
    })(PositionEncodingKind || (exports2.PositionEncodingKind = PositionEncodingKind = {}));
    var StaticRegistrationOptions;
    (function(StaticRegistrationOptions2) {
      function hasId(value) {
        const candidate = value;
        return candidate && Is2.string(candidate.id) && candidate.id.length > 0;
      }
      StaticRegistrationOptions2.hasId = hasId;
    })(StaticRegistrationOptions || (exports2.StaticRegistrationOptions = StaticRegistrationOptions = {}));
    var TextDocumentRegistrationOptions;
    (function(TextDocumentRegistrationOptions2) {
      function is(value) {
        const candidate = value;
        return candidate && (candidate.documentSelector === null || DocumentSelector.is(candidate.documentSelector));
      }
      TextDocumentRegistrationOptions2.is = is;
    })(TextDocumentRegistrationOptions || (exports2.TextDocumentRegistrationOptions = TextDocumentRegistrationOptions = {}));
    var WorkDoneProgressOptions;
    (function(WorkDoneProgressOptions2) {
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && (candidate.workDoneProgress === void 0 || Is2.boolean(candidate.workDoneProgress));
      }
      WorkDoneProgressOptions2.is = is;
      function hasWorkDoneProgress(value) {
        const candidate = value;
        return candidate && Is2.boolean(candidate.workDoneProgress);
      }
      WorkDoneProgressOptions2.hasWorkDoneProgress = hasWorkDoneProgress;
    })(WorkDoneProgressOptions || (exports2.WorkDoneProgressOptions = WorkDoneProgressOptions = {}));
    var InitializeRequest;
    (function(InitializeRequest2) {
      InitializeRequest2.method = "initialize";
      InitializeRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      InitializeRequest2.type = new messages_1.ProtocolRequestType(InitializeRequest2.method);
    })(InitializeRequest || (exports2.InitializeRequest = InitializeRequest = {}));
    var InitializeErrorCodes;
    (function(InitializeErrorCodes2) {
      InitializeErrorCodes2.unknownProtocolVersion = 1;
    })(InitializeErrorCodes || (exports2.InitializeErrorCodes = InitializeErrorCodes = {}));
    var InitializedNotification;
    (function(InitializedNotification2) {
      InitializedNotification2.method = "initialized";
      InitializedNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      InitializedNotification2.type = new messages_1.ProtocolNotificationType(InitializedNotification2.method);
    })(InitializedNotification || (exports2.InitializedNotification = InitializedNotification = {}));
    var ShutdownRequest;
    (function(ShutdownRequest2) {
      ShutdownRequest2.method = "shutdown";
      ShutdownRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      ShutdownRequest2.type = new messages_1.ProtocolRequestType0(ShutdownRequest2.method);
    })(ShutdownRequest || (exports2.ShutdownRequest = ShutdownRequest = {}));
    var ExitNotification;
    (function(ExitNotification2) {
      ExitNotification2.method = "exit";
      ExitNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      ExitNotification2.type = new messages_1.ProtocolNotificationType0(ExitNotification2.method);
    })(ExitNotification || (exports2.ExitNotification = ExitNotification = {}));
    var DidChangeConfigurationNotification;
    (function(DidChangeConfigurationNotification2) {
      DidChangeConfigurationNotification2.method = "workspace/didChangeConfiguration";
      DidChangeConfigurationNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidChangeConfigurationNotification2.type = new messages_1.ProtocolNotificationType(DidChangeConfigurationNotification2.method);
    })(DidChangeConfigurationNotification || (exports2.DidChangeConfigurationNotification = DidChangeConfigurationNotification = {}));
    var MessageType;
    (function(MessageType2) {
      MessageType2.Error = 1;
      MessageType2.Warning = 2;
      MessageType2.Info = 3;
      MessageType2.Log = 4;
      MessageType2.Debug = 5;
    })(MessageType || (exports2.MessageType = MessageType = {}));
    var ShowMessageNotification;
    (function(ShowMessageNotification2) {
      ShowMessageNotification2.method = "window/showMessage";
      ShowMessageNotification2.messageDirection = messages_1.MessageDirection.serverToClient;
      ShowMessageNotification2.type = new messages_1.ProtocolNotificationType(ShowMessageNotification2.method);
    })(ShowMessageNotification || (exports2.ShowMessageNotification = ShowMessageNotification = {}));
    var ShowMessageRequest;
    (function(ShowMessageRequest2) {
      ShowMessageRequest2.method = "window/showMessageRequest";
      ShowMessageRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      ShowMessageRequest2.type = new messages_1.ProtocolRequestType(ShowMessageRequest2.method);
    })(ShowMessageRequest || (exports2.ShowMessageRequest = ShowMessageRequest = {}));
    var LogMessageNotification;
    (function(LogMessageNotification2) {
      LogMessageNotification2.method = "window/logMessage";
      LogMessageNotification2.messageDirection = messages_1.MessageDirection.serverToClient;
      LogMessageNotification2.type = new messages_1.ProtocolNotificationType(LogMessageNotification2.method);
    })(LogMessageNotification || (exports2.LogMessageNotification = LogMessageNotification = {}));
    var TelemetryEventNotification;
    (function(TelemetryEventNotification2) {
      TelemetryEventNotification2.method = "telemetry/event";
      TelemetryEventNotification2.messageDirection = messages_1.MessageDirection.serverToClient;
      TelemetryEventNotification2.type = new messages_1.ProtocolNotificationType(TelemetryEventNotification2.method);
    })(TelemetryEventNotification || (exports2.TelemetryEventNotification = TelemetryEventNotification = {}));
    var TextDocumentSyncKind;
    (function(TextDocumentSyncKind2) {
      TextDocumentSyncKind2.None = 0;
      TextDocumentSyncKind2.Full = 1;
      TextDocumentSyncKind2.Incremental = 2;
    })(TextDocumentSyncKind || (exports2.TextDocumentSyncKind = TextDocumentSyncKind = {}));
    var DidOpenTextDocumentNotification;
    (function(DidOpenTextDocumentNotification2) {
      DidOpenTextDocumentNotification2.method = "textDocument/didOpen";
      DidOpenTextDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidOpenTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidOpenTextDocumentNotification2.method);
    })(DidOpenTextDocumentNotification || (exports2.DidOpenTextDocumentNotification = DidOpenTextDocumentNotification = {}));
    var TextDocumentContentChangeEvent;
    (function(TextDocumentContentChangeEvent2) {
      function isIncremental(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
      }
      TextDocumentContentChangeEvent2.isIncremental = isIncremental;
      function isFull(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
      }
      TextDocumentContentChangeEvent2.isFull = isFull;
    })(TextDocumentContentChangeEvent || (exports2.TextDocumentContentChangeEvent = TextDocumentContentChangeEvent = {}));
    var DidChangeTextDocumentNotification;
    (function(DidChangeTextDocumentNotification2) {
      DidChangeTextDocumentNotification2.method = "textDocument/didChange";
      DidChangeTextDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidChangeTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidChangeTextDocumentNotification2.method);
    })(DidChangeTextDocumentNotification || (exports2.DidChangeTextDocumentNotification = DidChangeTextDocumentNotification = {}));
    var DidCloseTextDocumentNotification;
    (function(DidCloseTextDocumentNotification2) {
      DidCloseTextDocumentNotification2.method = "textDocument/didClose";
      DidCloseTextDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidCloseTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidCloseTextDocumentNotification2.method);
    })(DidCloseTextDocumentNotification || (exports2.DidCloseTextDocumentNotification = DidCloseTextDocumentNotification = {}));
    var DidSaveTextDocumentNotification;
    (function(DidSaveTextDocumentNotification2) {
      DidSaveTextDocumentNotification2.method = "textDocument/didSave";
      DidSaveTextDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidSaveTextDocumentNotification2.method);
    })(DidSaveTextDocumentNotification || (exports2.DidSaveTextDocumentNotification = DidSaveTextDocumentNotification = {}));
    var TextDocumentSaveReason;
    (function(TextDocumentSaveReason2) {
      TextDocumentSaveReason2.Manual = 1;
      TextDocumentSaveReason2.AfterDelay = 2;
      TextDocumentSaveReason2.FocusOut = 3;
    })(TextDocumentSaveReason || (exports2.TextDocumentSaveReason = TextDocumentSaveReason = {}));
    var WillSaveTextDocumentNotification;
    (function(WillSaveTextDocumentNotification2) {
      WillSaveTextDocumentNotification2.method = "textDocument/willSave";
      WillSaveTextDocumentNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      WillSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(WillSaveTextDocumentNotification2.method);
    })(WillSaveTextDocumentNotification || (exports2.WillSaveTextDocumentNotification = WillSaveTextDocumentNotification = {}));
    var WillSaveTextDocumentWaitUntilRequest;
    (function(WillSaveTextDocumentWaitUntilRequest2) {
      WillSaveTextDocumentWaitUntilRequest2.method = "textDocument/willSaveWaitUntil";
      WillSaveTextDocumentWaitUntilRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WillSaveTextDocumentWaitUntilRequest2.type = new messages_1.ProtocolRequestType(WillSaveTextDocumentWaitUntilRequest2.method);
    })(WillSaveTextDocumentWaitUntilRequest || (exports2.WillSaveTextDocumentWaitUntilRequest = WillSaveTextDocumentWaitUntilRequest = {}));
    var DidChangeWatchedFilesNotification;
    (function(DidChangeWatchedFilesNotification2) {
      DidChangeWatchedFilesNotification2.method = "workspace/didChangeWatchedFiles";
      DidChangeWatchedFilesNotification2.messageDirection = messages_1.MessageDirection.clientToServer;
      DidChangeWatchedFilesNotification2.type = new messages_1.ProtocolNotificationType(DidChangeWatchedFilesNotification2.method);
    })(DidChangeWatchedFilesNotification || (exports2.DidChangeWatchedFilesNotification = DidChangeWatchedFilesNotification = {}));
    var FileChangeType;
    (function(FileChangeType2) {
      FileChangeType2.Created = 1;
      FileChangeType2.Changed = 2;
      FileChangeType2.Deleted = 3;
    })(FileChangeType || (exports2.FileChangeType = FileChangeType = {}));
    var RelativePattern;
    (function(RelativePattern2) {
      function is(value) {
        const candidate = value;
        return Is2.objectLiteral(candidate) && (vscode_languageserver_types_1.URI.is(candidate.baseUri) || vscode_languageserver_types_1.WorkspaceFolder.is(candidate.baseUri)) && Is2.string(candidate.pattern);
      }
      RelativePattern2.is = is;
    })(RelativePattern || (exports2.RelativePattern = RelativePattern = {}));
    var WatchKind;
    (function(WatchKind2) {
      WatchKind2.Create = 1;
      WatchKind2.Change = 2;
      WatchKind2.Delete = 4;
    })(WatchKind || (exports2.WatchKind = WatchKind = {}));
    var PublishDiagnosticsNotification;
    (function(PublishDiagnosticsNotification2) {
      PublishDiagnosticsNotification2.method = "textDocument/publishDiagnostics";
      PublishDiagnosticsNotification2.messageDirection = messages_1.MessageDirection.serverToClient;
      PublishDiagnosticsNotification2.type = new messages_1.ProtocolNotificationType(PublishDiagnosticsNotification2.method);
    })(PublishDiagnosticsNotification || (exports2.PublishDiagnosticsNotification = PublishDiagnosticsNotification = {}));
    var CompletionTriggerKind;
    (function(CompletionTriggerKind2) {
      CompletionTriggerKind2.Invoked = 1;
      CompletionTriggerKind2.TriggerCharacter = 2;
      CompletionTriggerKind2.TriggerForIncompleteCompletions = 3;
    })(CompletionTriggerKind || (exports2.CompletionTriggerKind = CompletionTriggerKind = {}));
    var CompletionRequest;
    (function(CompletionRequest2) {
      CompletionRequest2.method = "textDocument/completion";
      CompletionRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CompletionRequest2.type = new messages_1.ProtocolRequestType(CompletionRequest2.method);
    })(CompletionRequest || (exports2.CompletionRequest = CompletionRequest = {}));
    var CompletionResolveRequest;
    (function(CompletionResolveRequest2) {
      CompletionResolveRequest2.method = "completionItem/resolve";
      CompletionResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CompletionResolveRequest2.type = new messages_1.ProtocolRequestType(CompletionResolveRequest2.method);
    })(CompletionResolveRequest || (exports2.CompletionResolveRequest = CompletionResolveRequest = {}));
    var HoverRequest;
    (function(HoverRequest2) {
      HoverRequest2.method = "textDocument/hover";
      HoverRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      HoverRequest2.type = new messages_1.ProtocolRequestType(HoverRequest2.method);
    })(HoverRequest || (exports2.HoverRequest = HoverRequest = {}));
    var SignatureHelpTriggerKind;
    (function(SignatureHelpTriggerKind2) {
      SignatureHelpTriggerKind2.Invoked = 1;
      SignatureHelpTriggerKind2.TriggerCharacter = 2;
      SignatureHelpTriggerKind2.ContentChange = 3;
    })(SignatureHelpTriggerKind || (exports2.SignatureHelpTriggerKind = SignatureHelpTriggerKind = {}));
    var SignatureHelpRequest;
    (function(SignatureHelpRequest2) {
      SignatureHelpRequest2.method = "textDocument/signatureHelp";
      SignatureHelpRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      SignatureHelpRequest2.type = new messages_1.ProtocolRequestType(SignatureHelpRequest2.method);
    })(SignatureHelpRequest || (exports2.SignatureHelpRequest = SignatureHelpRequest = {}));
    var DefinitionRequest;
    (function(DefinitionRequest2) {
      DefinitionRequest2.method = "textDocument/definition";
      DefinitionRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DefinitionRequest2.type = new messages_1.ProtocolRequestType(DefinitionRequest2.method);
    })(DefinitionRequest || (exports2.DefinitionRequest = DefinitionRequest = {}));
    var ReferencesRequest;
    (function(ReferencesRequest2) {
      ReferencesRequest2.method = "textDocument/references";
      ReferencesRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      ReferencesRequest2.type = new messages_1.ProtocolRequestType(ReferencesRequest2.method);
    })(ReferencesRequest || (exports2.ReferencesRequest = ReferencesRequest = {}));
    var DocumentHighlightRequest;
    (function(DocumentHighlightRequest2) {
      DocumentHighlightRequest2.method = "textDocument/documentHighlight";
      DocumentHighlightRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentHighlightRequest2.type = new messages_1.ProtocolRequestType(DocumentHighlightRequest2.method);
    })(DocumentHighlightRequest || (exports2.DocumentHighlightRequest = DocumentHighlightRequest = {}));
    var DocumentSymbolRequest;
    (function(DocumentSymbolRequest2) {
      DocumentSymbolRequest2.method = "textDocument/documentSymbol";
      DocumentSymbolRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentSymbolRequest2.type = new messages_1.ProtocolRequestType(DocumentSymbolRequest2.method);
    })(DocumentSymbolRequest || (exports2.DocumentSymbolRequest = DocumentSymbolRequest = {}));
    var CodeActionRequest;
    (function(CodeActionRequest2) {
      CodeActionRequest2.method = "textDocument/codeAction";
      CodeActionRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CodeActionRequest2.type = new messages_1.ProtocolRequestType(CodeActionRequest2.method);
    })(CodeActionRequest || (exports2.CodeActionRequest = CodeActionRequest = {}));
    var CodeActionResolveRequest;
    (function(CodeActionResolveRequest2) {
      CodeActionResolveRequest2.method = "codeAction/resolve";
      CodeActionResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CodeActionResolveRequest2.type = new messages_1.ProtocolRequestType(CodeActionResolveRequest2.method);
    })(CodeActionResolveRequest || (exports2.CodeActionResolveRequest = CodeActionResolveRequest = {}));
    var WorkspaceSymbolRequest;
    (function(WorkspaceSymbolRequest2) {
      WorkspaceSymbolRequest2.method = "workspace/symbol";
      WorkspaceSymbolRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WorkspaceSymbolRequest2.type = new messages_1.ProtocolRequestType(WorkspaceSymbolRequest2.method);
    })(WorkspaceSymbolRequest || (exports2.WorkspaceSymbolRequest = WorkspaceSymbolRequest = {}));
    var WorkspaceSymbolResolveRequest;
    (function(WorkspaceSymbolResolveRequest2) {
      WorkspaceSymbolResolveRequest2.method = "workspaceSymbol/resolve";
      WorkspaceSymbolResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      WorkspaceSymbolResolveRequest2.type = new messages_1.ProtocolRequestType(WorkspaceSymbolResolveRequest2.method);
    })(WorkspaceSymbolResolveRequest || (exports2.WorkspaceSymbolResolveRequest = WorkspaceSymbolResolveRequest = {}));
    var CodeLensRequest;
    (function(CodeLensRequest2) {
      CodeLensRequest2.method = "textDocument/codeLens";
      CodeLensRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CodeLensRequest2.type = new messages_1.ProtocolRequestType(CodeLensRequest2.method);
    })(CodeLensRequest || (exports2.CodeLensRequest = CodeLensRequest = {}));
    var CodeLensResolveRequest;
    (function(CodeLensResolveRequest2) {
      CodeLensResolveRequest2.method = "codeLens/resolve";
      CodeLensResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      CodeLensResolveRequest2.type = new messages_1.ProtocolRequestType(CodeLensResolveRequest2.method);
    })(CodeLensResolveRequest || (exports2.CodeLensResolveRequest = CodeLensResolveRequest = {}));
    var CodeLensRefreshRequest;
    (function(CodeLensRefreshRequest2) {
      CodeLensRefreshRequest2.method = `workspace/codeLens/refresh`;
      CodeLensRefreshRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      CodeLensRefreshRequest2.type = new messages_1.ProtocolRequestType0(CodeLensRefreshRequest2.method);
    })(CodeLensRefreshRequest || (exports2.CodeLensRefreshRequest = CodeLensRefreshRequest = {}));
    var DocumentLinkRequest;
    (function(DocumentLinkRequest2) {
      DocumentLinkRequest2.method = "textDocument/documentLink";
      DocumentLinkRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentLinkRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkRequest2.method);
    })(DocumentLinkRequest || (exports2.DocumentLinkRequest = DocumentLinkRequest = {}));
    var DocumentLinkResolveRequest;
    (function(DocumentLinkResolveRequest2) {
      DocumentLinkResolveRequest2.method = "documentLink/resolve";
      DocumentLinkResolveRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentLinkResolveRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkResolveRequest2.method);
    })(DocumentLinkResolveRequest || (exports2.DocumentLinkResolveRequest = DocumentLinkResolveRequest = {}));
    var DocumentFormattingRequest;
    (function(DocumentFormattingRequest2) {
      DocumentFormattingRequest2.method = "textDocument/formatting";
      DocumentFormattingRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentFormattingRequest2.method);
    })(DocumentFormattingRequest || (exports2.DocumentFormattingRequest = DocumentFormattingRequest = {}));
    var DocumentRangeFormattingRequest;
    (function(DocumentRangeFormattingRequest2) {
      DocumentRangeFormattingRequest2.method = "textDocument/rangeFormatting";
      DocumentRangeFormattingRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentRangeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentRangeFormattingRequest2.method);
    })(DocumentRangeFormattingRequest || (exports2.DocumentRangeFormattingRequest = DocumentRangeFormattingRequest = {}));
    var DocumentRangesFormattingRequest;
    (function(DocumentRangesFormattingRequest2) {
      DocumentRangesFormattingRequest2.method = "textDocument/rangesFormatting";
      DocumentRangesFormattingRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentRangesFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentRangesFormattingRequest2.method);
    })(DocumentRangesFormattingRequest || (exports2.DocumentRangesFormattingRequest = DocumentRangesFormattingRequest = {}));
    var DocumentOnTypeFormattingRequest;
    (function(DocumentOnTypeFormattingRequest2) {
      DocumentOnTypeFormattingRequest2.method = "textDocument/onTypeFormatting";
      DocumentOnTypeFormattingRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      DocumentOnTypeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentOnTypeFormattingRequest2.method);
    })(DocumentOnTypeFormattingRequest || (exports2.DocumentOnTypeFormattingRequest = DocumentOnTypeFormattingRequest = {}));
    var PrepareSupportDefaultBehavior;
    (function(PrepareSupportDefaultBehavior2) {
      PrepareSupportDefaultBehavior2.Identifier = 1;
    })(PrepareSupportDefaultBehavior || (exports2.PrepareSupportDefaultBehavior = PrepareSupportDefaultBehavior = {}));
    var RenameRequest;
    (function(RenameRequest2) {
      RenameRequest2.method = "textDocument/rename";
      RenameRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      RenameRequest2.type = new messages_1.ProtocolRequestType(RenameRequest2.method);
    })(RenameRequest || (exports2.RenameRequest = RenameRequest = {}));
    var PrepareRenameRequest;
    (function(PrepareRenameRequest2) {
      PrepareRenameRequest2.method = "textDocument/prepareRename";
      PrepareRenameRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      PrepareRenameRequest2.type = new messages_1.ProtocolRequestType(PrepareRenameRequest2.method);
    })(PrepareRenameRequest || (exports2.PrepareRenameRequest = PrepareRenameRequest = {}));
    var ExecuteCommandRequest;
    (function(ExecuteCommandRequest2) {
      ExecuteCommandRequest2.method = "workspace/executeCommand";
      ExecuteCommandRequest2.messageDirection = messages_1.MessageDirection.clientToServer;
      ExecuteCommandRequest2.type = new messages_1.ProtocolRequestType(ExecuteCommandRequest2.method);
    })(ExecuteCommandRequest || (exports2.ExecuteCommandRequest = ExecuteCommandRequest = {}));
    var ApplyWorkspaceEditRequest;
    (function(ApplyWorkspaceEditRequest2) {
      ApplyWorkspaceEditRequest2.method = "workspace/applyEdit";
      ApplyWorkspaceEditRequest2.messageDirection = messages_1.MessageDirection.serverToClient;
      ApplyWorkspaceEditRequest2.type = new messages_1.ProtocolRequestType("workspace/applyEdit");
    })(ApplyWorkspaceEditRequest || (exports2.ApplyWorkspaceEditRequest = ApplyWorkspaceEditRequest = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/connection.js
var require_connection2 = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/connection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var vscode_jsonrpc_1 = require_main();
    function createProtocolConnection(input, output, logger, options) {
      if (vscode_jsonrpc_1.ConnectionStrategy.is(options)) {
        options = { connectionStrategy: options };
      }
      return (0, vscode_jsonrpc_1.createMessageConnection)(input, output, logger, options);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// node_modules/vscode-languageserver-protocol/lib/common/api.js
var require_api2 = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/common/api.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LSPErrorCodes = exports2.createProtocolConnection = void 0;
    __exportStar(require_main(), exports2);
    __exportStar(require_main2(), exports2);
    __exportStar(require_messages2(), exports2);
    __exportStar(require_protocol(), exports2);
    var connection_1 = require_connection2();
    Object.defineProperty(exports2, "createProtocolConnection", { enumerable: true, get: function() {
      return connection_1.createProtocolConnection;
    } });
    var LSPErrorCodes;
    (function(LSPErrorCodes2) {
      LSPErrorCodes2.lspReservedErrorRangeStart = -32899;
      LSPErrorCodes2.RequestFailed = -32803;
      LSPErrorCodes2.ServerCancelled = -32802;
      LSPErrorCodes2.ContentModified = -32801;
      LSPErrorCodes2.RequestCancelled = -32800;
      LSPErrorCodes2.lspReservedErrorRangeEnd = -32800;
    })(LSPErrorCodes || (exports2.LSPErrorCodes = LSPErrorCodes = {}));
  }
});

// node_modules/vscode-languageserver-protocol/lib/node/main.js
var require_main3 = __commonJS({
  "node_modules/vscode-languageserver-protocol/lib/node/main.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var node_1 = require_node();
    __exportStar(require_node(), exports2);
    __exportStar(require_api2(), exports2);
    function createProtocolConnection(input, output, logger, options) {
      return (0, node_1.createMessageConnection)(input, output, logger, options);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// node_modules/vscode-languageserver/lib/common/utils/uuid.js
var require_uuid = __commonJS({
  "node_modules/vscode-languageserver/lib/common/utils/uuid.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.generateUuid = exports2.parse = exports2.isUUID = exports2.v4 = exports2.empty = void 0;
    var ValueUUID = class {
      constructor(_value) {
        this._value = _value;
      }
      asHex() {
        return this._value;
      }
      equals(other) {
        return this.asHex() === other.asHex();
      }
    };
    var V4UUID = class _V4UUID extends ValueUUID {
      static _oneOf(array) {
        return array[Math.floor(array.length * Math.random())];
      }
      static _randomHex() {
        return _V4UUID._oneOf(_V4UUID._chars);
      }
      constructor() {
        super([
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          "-",
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          "-",
          "4",
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          "-",
          _V4UUID._oneOf(_V4UUID._timeHighBits),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          "-",
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex(),
          _V4UUID._randomHex()
        ].join(""));
      }
    };
    V4UUID._chars = ["0", "1", "2", "3", "4", "5", "6", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"];
    V4UUID._timeHighBits = ["8", "9", "a", "b"];
    exports2.empty = new ValueUUID("00000000-0000-0000-0000-000000000000");
    function v4() {
      return new V4UUID();
    }
    exports2.v4 = v4;
    var _UUIDPattern = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
    function isUUID(value) {
      return _UUIDPattern.test(value);
    }
    exports2.isUUID = isUUID;
    function parse6(value) {
      if (!isUUID(value)) {
        throw new Error("invalid uuid");
      }
      return new ValueUUID(value);
    }
    exports2.parse = parse6;
    function generateUuid() {
      return v4().asHex();
    }
    exports2.generateUuid = generateUuid;
  }
});

// node_modules/vscode-languageserver/lib/common/progress.js
var require_progress = __commonJS({
  "node_modules/vscode-languageserver/lib/common/progress.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.attachPartialResult = exports2.ProgressFeature = exports2.attachWorkDone = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var uuid_1 = require_uuid();
    var WorkDoneProgressReporterImpl = class _WorkDoneProgressReporterImpl {
      constructor(_connection, _token) {
        this._connection = _connection;
        this._token = _token;
        _WorkDoneProgressReporterImpl.Instances.set(this._token, this);
      }
      begin(title, percentage, message, cancellable) {
        let param = {
          kind: "begin",
          title,
          percentage,
          message,
          cancellable
        };
        this._connection.sendProgress(vscode_languageserver_protocol_1.WorkDoneProgress.type, this._token, param);
      }
      report(arg0, arg1) {
        let param = {
          kind: "report"
        };
        if (typeof arg0 === "number") {
          param.percentage = arg0;
          if (arg1 !== void 0) {
            param.message = arg1;
          }
        } else {
          param.message = arg0;
        }
        this._connection.sendProgress(vscode_languageserver_protocol_1.WorkDoneProgress.type, this._token, param);
      }
      done() {
        _WorkDoneProgressReporterImpl.Instances.delete(this._token);
        this._connection.sendProgress(vscode_languageserver_protocol_1.WorkDoneProgress.type, this._token, { kind: "end" });
      }
    };
    WorkDoneProgressReporterImpl.Instances = /* @__PURE__ */ new Map();
    var WorkDoneProgressServerReporterImpl = class extends WorkDoneProgressReporterImpl {
      constructor(connection2, token) {
        super(connection2, token);
        this._source = new vscode_languageserver_protocol_1.CancellationTokenSource();
      }
      get token() {
        return this._source.token;
      }
      done() {
        this._source.dispose();
        super.done();
      }
      cancel() {
        this._source.cancel();
      }
    };
    var NullProgressReporter = class {
      constructor() {
      }
      begin() {
      }
      report() {
      }
      done() {
      }
    };
    var NullProgressServerReporter = class extends NullProgressReporter {
      constructor() {
        super();
        this._source = new vscode_languageserver_protocol_1.CancellationTokenSource();
      }
      get token() {
        return this._source.token;
      }
      done() {
        this._source.dispose();
      }
      cancel() {
        this._source.cancel();
      }
    };
    function attachWorkDone(connection2, params) {
      if (params === void 0 || params.workDoneToken === void 0) {
        return new NullProgressReporter();
      }
      const token = params.workDoneToken;
      delete params.workDoneToken;
      return new WorkDoneProgressReporterImpl(connection2, token);
    }
    exports2.attachWorkDone = attachWorkDone;
    var ProgressFeature = (Base) => {
      return class extends Base {
        constructor() {
          super();
          this._progressSupported = false;
        }
        initialize(capabilities) {
          var _a3;
          super.initialize(capabilities);
          if (((_a3 = capabilities == null ? void 0 : capabilities.window) == null ? void 0 : _a3.workDoneProgress) === true) {
            this._progressSupported = true;
            this.connection.onNotification(vscode_languageserver_protocol_1.WorkDoneProgressCancelNotification.type, (params) => {
              let progress = WorkDoneProgressReporterImpl.Instances.get(params.token);
              if (progress instanceof WorkDoneProgressServerReporterImpl || progress instanceof NullProgressServerReporter) {
                progress.cancel();
              }
            });
          }
        }
        attachWorkDoneProgress(token) {
          if (token === void 0) {
            return new NullProgressReporter();
          } else {
            return new WorkDoneProgressReporterImpl(this.connection, token);
          }
        }
        createWorkDoneProgress() {
          if (this._progressSupported) {
            const token = (0, uuid_1.generateUuid)();
            return this.connection.sendRequest(vscode_languageserver_protocol_1.WorkDoneProgressCreateRequest.type, { token }).then(() => {
              const result = new WorkDoneProgressServerReporterImpl(this.connection, token);
              return result;
            });
          } else {
            return Promise.resolve(new NullProgressServerReporter());
          }
        }
      };
    };
    exports2.ProgressFeature = ProgressFeature;
    var ResultProgress;
    (function(ResultProgress2) {
      ResultProgress2.type = new vscode_languageserver_protocol_1.ProgressType();
    })(ResultProgress || (ResultProgress = {}));
    var ResultProgressReporterImpl = class {
      constructor(_connection, _token) {
        this._connection = _connection;
        this._token = _token;
      }
      report(data) {
        this._connection.sendProgress(ResultProgress.type, this._token, data);
      }
    };
    function attachPartialResult(connection2, params) {
      if (params === void 0 || params.partialResultToken === void 0) {
        return void 0;
      }
      const token = params.partialResultToken;
      delete params.partialResultToken;
      return new ResultProgressReporterImpl(connection2, token);
    }
    exports2.attachPartialResult = attachPartialResult;
  }
});

// node_modules/vscode-languageserver/lib/common/configuration.js
var require_configuration = __commonJS({
  "node_modules/vscode-languageserver/lib/common/configuration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ConfigurationFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var Is2 = require_is();
    var ConfigurationFeature = (Base) => {
      return class extends Base {
        getConfiguration(arg) {
          if (!arg) {
            return this._getConfiguration({});
          } else if (Is2.string(arg)) {
            return this._getConfiguration({ section: arg });
          } else {
            return this._getConfiguration(arg);
          }
        }
        _getConfiguration(arg) {
          let params = {
            items: Array.isArray(arg) ? arg : [arg]
          };
          return this.connection.sendRequest(vscode_languageserver_protocol_1.ConfigurationRequest.type, params).then((result) => {
            if (Array.isArray(result)) {
              return Array.isArray(arg) ? result : result[0];
            } else {
              return Array.isArray(arg) ? [] : null;
            }
          });
        }
      };
    };
    exports2.ConfigurationFeature = ConfigurationFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/workspaceFolder.js
var require_workspaceFolder = __commonJS({
  "node_modules/vscode-languageserver/lib/common/workspaceFolder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WorkspaceFoldersFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var WorkspaceFoldersFeature = (Base) => {
      return class extends Base {
        constructor() {
          super();
          this._notificationIsAutoRegistered = false;
        }
        initialize(capabilities) {
          super.initialize(capabilities);
          let workspaceCapabilities = capabilities.workspace;
          if (workspaceCapabilities && workspaceCapabilities.workspaceFolders) {
            this._onDidChangeWorkspaceFolders = new vscode_languageserver_protocol_1.Emitter();
            this.connection.onNotification(vscode_languageserver_protocol_1.DidChangeWorkspaceFoldersNotification.type, (params) => {
              this._onDidChangeWorkspaceFolders.fire(params.event);
            });
          }
        }
        fillServerCapabilities(capabilities) {
          var _a3, _b;
          super.fillServerCapabilities(capabilities);
          const changeNotifications = (_b = (_a3 = capabilities.workspace) == null ? void 0 : _a3.workspaceFolders) == null ? void 0 : _b.changeNotifications;
          this._notificationIsAutoRegistered = changeNotifications === true || typeof changeNotifications === "string";
        }
        getWorkspaceFolders() {
          return this.connection.sendRequest(vscode_languageserver_protocol_1.WorkspaceFoldersRequest.type);
        }
        get onDidChangeWorkspaceFolders() {
          if (!this._onDidChangeWorkspaceFolders) {
            throw new Error("Client doesn't support sending workspace folder change events.");
          }
          if (!this._notificationIsAutoRegistered && !this._unregistration) {
            this._unregistration = this.connection.client.register(vscode_languageserver_protocol_1.DidChangeWorkspaceFoldersNotification.type);
          }
          return this._onDidChangeWorkspaceFolders.event;
        }
      };
    };
    exports2.WorkspaceFoldersFeature = WorkspaceFoldersFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/callHierarchy.js
var require_callHierarchy = __commonJS({
  "node_modules/vscode-languageserver/lib/common/callHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CallHierarchyFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var CallHierarchyFeature = (Base) => {
      return class extends Base {
        get callHierarchy() {
          return {
            onPrepare: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.CallHierarchyPrepareRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), void 0);
              });
            },
            onIncomingCalls: (handler) => {
              const type = vscode_languageserver_protocol_1.CallHierarchyIncomingCallsRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            },
            onOutgoingCalls: (handler) => {
              const type = vscode_languageserver_protocol_1.CallHierarchyOutgoingCallsRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            }
          };
        }
      };
    };
    exports2.CallHierarchyFeature = CallHierarchyFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/semanticTokens.js
var require_semanticTokens = __commonJS({
  "node_modules/vscode-languageserver/lib/common/semanticTokens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemanticTokensBuilder = exports2.SemanticTokensDiff = exports2.SemanticTokensFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var SemanticTokensFeature = (Base) => {
      return class extends Base {
        get semanticTokens() {
          return {
            refresh: () => {
              return this.connection.sendRequest(vscode_languageserver_protocol_1.SemanticTokensRefreshRequest.type);
            },
            on: (handler) => {
              const type = vscode_languageserver_protocol_1.SemanticTokensRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            },
            onDelta: (handler) => {
              const type = vscode_languageserver_protocol_1.SemanticTokensDeltaRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            },
            onRange: (handler) => {
              const type = vscode_languageserver_protocol_1.SemanticTokensRangeRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            }
          };
        }
      };
    };
    exports2.SemanticTokensFeature = SemanticTokensFeature;
    var SemanticTokensDiff = class {
      constructor(originalSequence, modifiedSequence) {
        this.originalSequence = originalSequence;
        this.modifiedSequence = modifiedSequence;
      }
      computeDiff() {
        const originalLength = this.originalSequence.length;
        const modifiedLength = this.modifiedSequence.length;
        let startIndex = 0;
        while (startIndex < modifiedLength && startIndex < originalLength && this.originalSequence[startIndex] === this.modifiedSequence[startIndex]) {
          startIndex++;
        }
        if (startIndex < modifiedLength && startIndex < originalLength) {
          let originalEndIndex = originalLength - 1;
          let modifiedEndIndex = modifiedLength - 1;
          while (originalEndIndex >= startIndex && modifiedEndIndex >= startIndex && this.originalSequence[originalEndIndex] === this.modifiedSequence[modifiedEndIndex]) {
            originalEndIndex--;
            modifiedEndIndex--;
          }
          if (originalEndIndex < startIndex || modifiedEndIndex < startIndex) {
            originalEndIndex++;
            modifiedEndIndex++;
          }
          const deleteCount = originalEndIndex - startIndex + 1;
          const newData = this.modifiedSequence.slice(startIndex, modifiedEndIndex + 1);
          if (newData.length === 1 && newData[0] === this.originalSequence[originalEndIndex]) {
            return [
              { start: startIndex, deleteCount: deleteCount - 1 }
            ];
          } else {
            return [
              { start: startIndex, deleteCount, data: newData }
            ];
          }
        } else if (startIndex < modifiedLength) {
          return [
            { start: startIndex, deleteCount: 0, data: this.modifiedSequence.slice(startIndex) }
          ];
        } else if (startIndex < originalLength) {
          return [
            { start: startIndex, deleteCount: originalLength - startIndex }
          ];
        } else {
          return [];
        }
      }
    };
    exports2.SemanticTokensDiff = SemanticTokensDiff;
    var SemanticTokensBuilder = class {
      constructor() {
        this._prevData = void 0;
        this.initialize();
      }
      initialize() {
        this._id = Date.now();
        this._prevLine = 0;
        this._prevChar = 0;
        this._data = [];
        this._dataLen = 0;
      }
      push(line, char, length, tokenType, tokenModifiers) {
        let pushLine = line;
        let pushChar = char;
        if (this._dataLen > 0) {
          pushLine -= this._prevLine;
          if (pushLine === 0) {
            pushChar -= this._prevChar;
          }
        }
        this._data[this._dataLen++] = pushLine;
        this._data[this._dataLen++] = pushChar;
        this._data[this._dataLen++] = length;
        this._data[this._dataLen++] = tokenType;
        this._data[this._dataLen++] = tokenModifiers;
        this._prevLine = line;
        this._prevChar = char;
      }
      get id() {
        return this._id.toString();
      }
      previousResult(id) {
        if (this.id === id) {
          this._prevData = this._data;
        }
        this.initialize();
      }
      build() {
        this._prevData = void 0;
        return {
          resultId: this.id,
          data: this._data
        };
      }
      canBuildEdits() {
        return this._prevData !== void 0;
      }
      buildEdits() {
        if (this._prevData !== void 0) {
          return {
            resultId: this.id,
            edits: new SemanticTokensDiff(this._prevData, this._data).computeDiff()
          };
        } else {
          return this.build();
        }
      }
    };
    exports2.SemanticTokensBuilder = SemanticTokensBuilder;
  }
});

// node_modules/vscode-languageserver/lib/common/showDocument.js
var require_showDocument = __commonJS({
  "node_modules/vscode-languageserver/lib/common/showDocument.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ShowDocumentFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var ShowDocumentFeature = (Base) => {
      return class extends Base {
        showDocument(params) {
          return this.connection.sendRequest(vscode_languageserver_protocol_1.ShowDocumentRequest.type, params);
        }
      };
    };
    exports2.ShowDocumentFeature = ShowDocumentFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/fileOperations.js
var require_fileOperations = __commonJS({
  "node_modules/vscode-languageserver/lib/common/fileOperations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileOperationsFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var FileOperationsFeature = (Base) => {
      return class extends Base {
        onDidCreateFiles(handler) {
          return this.connection.onNotification(vscode_languageserver_protocol_1.DidCreateFilesNotification.type, (params) => {
            handler(params);
          });
        }
        onDidRenameFiles(handler) {
          return this.connection.onNotification(vscode_languageserver_protocol_1.DidRenameFilesNotification.type, (params) => {
            handler(params);
          });
        }
        onDidDeleteFiles(handler) {
          return this.connection.onNotification(vscode_languageserver_protocol_1.DidDeleteFilesNotification.type, (params) => {
            handler(params);
          });
        }
        onWillCreateFiles(handler) {
          return this.connection.onRequest(vscode_languageserver_protocol_1.WillCreateFilesRequest.type, (params, cancel) => {
            return handler(params, cancel);
          });
        }
        onWillRenameFiles(handler) {
          return this.connection.onRequest(vscode_languageserver_protocol_1.WillRenameFilesRequest.type, (params, cancel) => {
            return handler(params, cancel);
          });
        }
        onWillDeleteFiles(handler) {
          return this.connection.onRequest(vscode_languageserver_protocol_1.WillDeleteFilesRequest.type, (params, cancel) => {
            return handler(params, cancel);
          });
        }
      };
    };
    exports2.FileOperationsFeature = FileOperationsFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/linkedEditingRange.js
var require_linkedEditingRange = __commonJS({
  "node_modules/vscode-languageserver/lib/common/linkedEditingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LinkedEditingRangeFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var LinkedEditingRangeFeature = (Base) => {
      return class extends Base {
        onLinkedEditingRange(handler) {
          return this.connection.onRequest(vscode_languageserver_protocol_1.LinkedEditingRangeRequest.type, (params, cancel) => {
            return handler(params, cancel, this.attachWorkDoneProgress(params), void 0);
          });
        }
      };
    };
    exports2.LinkedEditingRangeFeature = LinkedEditingRangeFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/typeHierarchy.js
var require_typeHierarchy = __commonJS({
  "node_modules/vscode-languageserver/lib/common/typeHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypeHierarchyFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var TypeHierarchyFeature = (Base) => {
      return class extends Base {
        get typeHierarchy() {
          return {
            onPrepare: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.TypeHierarchyPrepareRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), void 0);
              });
            },
            onSupertypes: (handler) => {
              const type = vscode_languageserver_protocol_1.TypeHierarchySupertypesRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            },
            onSubtypes: (handler) => {
              const type = vscode_languageserver_protocol_1.TypeHierarchySubtypesRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            }
          };
        }
      };
    };
    exports2.TypeHierarchyFeature = TypeHierarchyFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/inlineValue.js
var require_inlineValue = __commonJS({
  "node_modules/vscode-languageserver/lib/common/inlineValue.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlineValueFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var InlineValueFeature = (Base) => {
      return class extends Base {
        get inlineValue() {
          return {
            refresh: () => {
              return this.connection.sendRequest(vscode_languageserver_protocol_1.InlineValueRefreshRequest.type);
            },
            on: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.InlineValueRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params));
              });
            }
          };
        }
      };
    };
    exports2.InlineValueFeature = InlineValueFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/foldingRange.js
var require_foldingRange = __commonJS({
  "node_modules/vscode-languageserver/lib/common/foldingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FoldingRangeFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var FoldingRangeFeature = (Base) => {
      return class extends Base {
        get foldingRange() {
          return {
            refresh: () => {
              return this.connection.sendRequest(vscode_languageserver_protocol_1.FoldingRangeRefreshRequest.type);
            },
            on: (handler) => {
              const type = vscode_languageserver_protocol_1.FoldingRangeRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            }
          };
        }
      };
    };
    exports2.FoldingRangeFeature = FoldingRangeFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/inlayHint.js
var require_inlayHint = __commonJS({
  "node_modules/vscode-languageserver/lib/common/inlayHint.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlayHintFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var InlayHintFeature = (Base) => {
      return class extends Base {
        get inlayHint() {
          return {
            refresh: () => {
              return this.connection.sendRequest(vscode_languageserver_protocol_1.InlayHintRefreshRequest.type);
            },
            on: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.InlayHintRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params));
              });
            },
            resolve: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.InlayHintResolveRequest.type, (params, cancel) => {
                return handler(params, cancel);
              });
            }
          };
        }
      };
    };
    exports2.InlayHintFeature = InlayHintFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/diagnostic.js
var require_diagnostic = __commonJS({
  "node_modules/vscode-languageserver/lib/common/diagnostic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DiagnosticFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var DiagnosticFeature = (Base) => {
      return class extends Base {
        get diagnostics() {
          return {
            refresh: () => {
              return this.connection.sendRequest(vscode_languageserver_protocol_1.DiagnosticRefreshRequest.type);
            },
            on: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.DocumentDiagnosticRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(vscode_languageserver_protocol_1.DocumentDiagnosticRequest.partialResult, params));
              });
            },
            onWorkspace: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.WorkspaceDiagnosticRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(vscode_languageserver_protocol_1.WorkspaceDiagnosticRequest.partialResult, params));
              });
            }
          };
        }
      };
    };
    exports2.DiagnosticFeature = DiagnosticFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/textDocuments.js
var require_textDocuments = __commonJS({
  "node_modules/vscode-languageserver/lib/common/textDocuments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TextDocuments = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var TextDocuments = class {
      /**
       * Create a new text document manager.
       */
      constructor(configuration) {
        this._configuration = configuration;
        this._syncedDocuments = /* @__PURE__ */ new Map();
        this._onDidChangeContent = new vscode_languageserver_protocol_1.Emitter();
        this._onDidOpen = new vscode_languageserver_protocol_1.Emitter();
        this._onDidClose = new vscode_languageserver_protocol_1.Emitter();
        this._onDidSave = new vscode_languageserver_protocol_1.Emitter();
        this._onWillSave = new vscode_languageserver_protocol_1.Emitter();
      }
      /**
       * An event that fires when a text document managed by this manager
       * has been opened.
       */
      get onDidOpen() {
        return this._onDidOpen.event;
      }
      /**
       * An event that fires when a text document managed by this manager
       * has been opened or the content changes.
       */
      get onDidChangeContent() {
        return this._onDidChangeContent.event;
      }
      /**
       * An event that fires when a text document managed by this manager
       * will be saved.
       */
      get onWillSave() {
        return this._onWillSave.event;
      }
      /**
       * Sets a handler that will be called if a participant wants to provide
       * edits during a text document save.
       */
      onWillSaveWaitUntil(handler) {
        this._willSaveWaitUntil = handler;
      }
      /**
       * An event that fires when a text document managed by this manager
       * has been saved.
       */
      get onDidSave() {
        return this._onDidSave.event;
      }
      /**
       * An event that fires when a text document managed by this manager
       * has been closed.
       */
      get onDidClose() {
        return this._onDidClose.event;
      }
      /**
       * Returns the document for the given URI. Returns undefined if
       * the document is not managed by this instance.
       *
       * @param uri The text document's URI to retrieve.
       * @return the text document or `undefined`.
       */
      get(uri) {
        return this._syncedDocuments.get(uri);
      }
      /**
       * Returns all text documents managed by this instance.
       *
       * @return all text documents.
       */
      all() {
        return Array.from(this._syncedDocuments.values());
      }
      /**
       * Returns the URIs of all text documents managed by this instance.
       *
       * @return the URI's of all text documents.
       */
      keys() {
        return Array.from(this._syncedDocuments.keys());
      }
      /**
       * Listens for `low level` notification on the given connection to
       * update the text documents managed by this instance.
       *
       * Please note that the connection only provides handlers not an event model. Therefore
       * listening on a connection will overwrite the following handlers on a connection:
       * `onDidOpenTextDocument`, `onDidChangeTextDocument`, `onDidCloseTextDocument`,
       * `onWillSaveTextDocument`, `onWillSaveTextDocumentWaitUntil` and `onDidSaveTextDocument`.
       *
       * Use the corresponding events on the TextDocuments instance instead.
       *
       * @param connection The connection to listen on.
       */
      listen(connection2) {
        connection2.__textDocumentSync = vscode_languageserver_protocol_1.TextDocumentSyncKind.Incremental;
        const disposables = [];
        disposables.push(connection2.onDidOpenTextDocument((event) => {
          const td = event.textDocument;
          const document2 = this._configuration.create(td.uri, td.languageId, td.version, td.text);
          this._syncedDocuments.set(td.uri, document2);
          const toFire = Object.freeze({ document: document2 });
          this._onDidOpen.fire(toFire);
          this._onDidChangeContent.fire(toFire);
        }));
        disposables.push(connection2.onDidChangeTextDocument((event) => {
          const td = event.textDocument;
          const changes = event.contentChanges;
          if (changes.length === 0) {
            return;
          }
          const { version } = td;
          if (version === null || version === void 0) {
            throw new Error(`Received document change event for ${td.uri} without valid version identifier`);
          }
          let syncedDocument = this._syncedDocuments.get(td.uri);
          if (syncedDocument !== void 0) {
            syncedDocument = this._configuration.update(syncedDocument, changes, version);
            this._syncedDocuments.set(td.uri, syncedDocument);
            this._onDidChangeContent.fire(Object.freeze({ document: syncedDocument }));
          }
        }));
        disposables.push(connection2.onDidCloseTextDocument((event) => {
          let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
          if (syncedDocument !== void 0) {
            this._syncedDocuments.delete(event.textDocument.uri);
            this._onDidClose.fire(Object.freeze({ document: syncedDocument }));
          }
        }));
        disposables.push(connection2.onWillSaveTextDocument((event) => {
          let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
          if (syncedDocument !== void 0) {
            this._onWillSave.fire(Object.freeze({ document: syncedDocument, reason: event.reason }));
          }
        }));
        disposables.push(connection2.onWillSaveTextDocumentWaitUntil((event, token) => {
          let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
          if (syncedDocument !== void 0 && this._willSaveWaitUntil) {
            return this._willSaveWaitUntil(Object.freeze({ document: syncedDocument, reason: event.reason }), token);
          } else {
            return [];
          }
        }));
        disposables.push(connection2.onDidSaveTextDocument((event) => {
          let syncedDocument = this._syncedDocuments.get(event.textDocument.uri);
          if (syncedDocument !== void 0) {
            this._onDidSave.fire(Object.freeze({ document: syncedDocument }));
          }
        }));
        return vscode_languageserver_protocol_1.Disposable.create(() => {
          disposables.forEach((disposable) => disposable.dispose());
        });
      }
    };
    exports2.TextDocuments = TextDocuments;
  }
});

// node_modules/vscode-languageserver/lib/common/notebook.js
var require_notebook = __commonJS({
  "node_modules/vscode-languageserver/lib/common/notebook.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NotebookDocuments = exports2.NotebookSyncFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var textDocuments_1 = require_textDocuments();
    var NotebookSyncFeature = (Base) => {
      return class extends Base {
        get synchronization() {
          return {
            onDidOpenNotebookDocument: (handler) => {
              return this.connection.onNotification(vscode_languageserver_protocol_1.DidOpenNotebookDocumentNotification.type, (params) => {
                handler(params);
              });
            },
            onDidChangeNotebookDocument: (handler) => {
              return this.connection.onNotification(vscode_languageserver_protocol_1.DidChangeNotebookDocumentNotification.type, (params) => {
                handler(params);
              });
            },
            onDidSaveNotebookDocument: (handler) => {
              return this.connection.onNotification(vscode_languageserver_protocol_1.DidSaveNotebookDocumentNotification.type, (params) => {
                handler(params);
              });
            },
            onDidCloseNotebookDocument: (handler) => {
              return this.connection.onNotification(vscode_languageserver_protocol_1.DidCloseNotebookDocumentNotification.type, (params) => {
                handler(params);
              });
            }
          };
        }
      };
    };
    exports2.NotebookSyncFeature = NotebookSyncFeature;
    var CellTextDocumentConnection = class _CellTextDocumentConnection {
      onDidOpenTextDocument(handler) {
        this.openHandler = handler;
        return vscode_languageserver_protocol_1.Disposable.create(() => {
          this.openHandler = void 0;
        });
      }
      openTextDocument(params) {
        this.openHandler && this.openHandler(params);
      }
      onDidChangeTextDocument(handler) {
        this.changeHandler = handler;
        return vscode_languageserver_protocol_1.Disposable.create(() => {
          this.changeHandler = handler;
        });
      }
      changeTextDocument(params) {
        this.changeHandler && this.changeHandler(params);
      }
      onDidCloseTextDocument(handler) {
        this.closeHandler = handler;
        return vscode_languageserver_protocol_1.Disposable.create(() => {
          this.closeHandler = void 0;
        });
      }
      closeTextDocument(params) {
        this.closeHandler && this.closeHandler(params);
      }
      onWillSaveTextDocument() {
        return _CellTextDocumentConnection.NULL_DISPOSE;
      }
      onWillSaveTextDocumentWaitUntil() {
        return _CellTextDocumentConnection.NULL_DISPOSE;
      }
      onDidSaveTextDocument() {
        return _CellTextDocumentConnection.NULL_DISPOSE;
      }
    };
    CellTextDocumentConnection.NULL_DISPOSE = Object.freeze({ dispose: () => {
    } });
    var NotebookDocuments = class {
      constructor(configurationOrTextDocuments) {
        if (configurationOrTextDocuments instanceof textDocuments_1.TextDocuments) {
          this._cellTextDocuments = configurationOrTextDocuments;
        } else {
          this._cellTextDocuments = new textDocuments_1.TextDocuments(configurationOrTextDocuments);
        }
        this.notebookDocuments = /* @__PURE__ */ new Map();
        this.notebookCellMap = /* @__PURE__ */ new Map();
        this._onDidOpen = new vscode_languageserver_protocol_1.Emitter();
        this._onDidChange = new vscode_languageserver_protocol_1.Emitter();
        this._onDidSave = new vscode_languageserver_protocol_1.Emitter();
        this._onDidClose = new vscode_languageserver_protocol_1.Emitter();
      }
      get cellTextDocuments() {
        return this._cellTextDocuments;
      }
      getCellTextDocument(cell) {
        return this._cellTextDocuments.get(cell.document);
      }
      getNotebookDocument(uri) {
        return this.notebookDocuments.get(uri);
      }
      getNotebookCell(uri) {
        const value = this.notebookCellMap.get(uri);
        return value && value[0];
      }
      findNotebookDocumentForCell(cell) {
        const key = typeof cell === "string" ? cell : cell.document;
        const value = this.notebookCellMap.get(key);
        return value && value[1];
      }
      get onDidOpen() {
        return this._onDidOpen.event;
      }
      get onDidSave() {
        return this._onDidSave.event;
      }
      get onDidChange() {
        return this._onDidChange.event;
      }
      get onDidClose() {
        return this._onDidClose.event;
      }
      /**
       * Listens for `low level` notification on the given connection to
       * update the notebook documents managed by this instance.
       *
       * Please note that the connection only provides handlers not an event model. Therefore
       * listening on a connection will overwrite the following handlers on a connection:
       * `onDidOpenNotebookDocument`, `onDidChangeNotebookDocument`, `onDidSaveNotebookDocument`,
       *  and `onDidCloseNotebookDocument`.
       *
       * @param connection The connection to listen on.
       */
      listen(connection2) {
        const cellTextDocumentConnection = new CellTextDocumentConnection();
        const disposables = [];
        disposables.push(this.cellTextDocuments.listen(cellTextDocumentConnection));
        disposables.push(connection2.notebooks.synchronization.onDidOpenNotebookDocument((params) => {
          this.notebookDocuments.set(params.notebookDocument.uri, params.notebookDocument);
          for (const cellTextDocument of params.cellTextDocuments) {
            cellTextDocumentConnection.openTextDocument({ textDocument: cellTextDocument });
          }
          this.updateCellMap(params.notebookDocument);
          this._onDidOpen.fire(params.notebookDocument);
        }));
        disposables.push(connection2.notebooks.synchronization.onDidChangeNotebookDocument((params) => {
          const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
          if (notebookDocument === void 0) {
            return;
          }
          notebookDocument.version = params.notebookDocument.version;
          const oldMetadata = notebookDocument.metadata;
          let metadataChanged = false;
          const change = params.change;
          if (change.metadata !== void 0) {
            metadataChanged = true;
            notebookDocument.metadata = change.metadata;
          }
          const opened = [];
          const closed = [];
          const data = [];
          const text = [];
          if (change.cells !== void 0) {
            const changedCells = change.cells;
            if (changedCells.structure !== void 0) {
              const array = changedCells.structure.array;
              notebookDocument.cells.splice(array.start, array.deleteCount, ...array.cells !== void 0 ? array.cells : []);
              if (changedCells.structure.didOpen !== void 0) {
                for (const open of changedCells.structure.didOpen) {
                  cellTextDocumentConnection.openTextDocument({ textDocument: open });
                  opened.push(open.uri);
                }
              }
              if (changedCells.structure.didClose) {
                for (const close of changedCells.structure.didClose) {
                  cellTextDocumentConnection.closeTextDocument({ textDocument: close });
                  closed.push(close.uri);
                }
              }
            }
            if (changedCells.data !== void 0) {
              const cellUpdates = new Map(changedCells.data.map((cell) => [cell.document, cell]));
              for (let i = 0; i <= notebookDocument.cells.length; i++) {
                const change2 = cellUpdates.get(notebookDocument.cells[i].document);
                if (change2 !== void 0) {
                  const old = notebookDocument.cells.splice(i, 1, change2);
                  data.push({ old: old[0], new: change2 });
                  cellUpdates.delete(change2.document);
                  if (cellUpdates.size === 0) {
                    break;
                  }
                }
              }
            }
            if (changedCells.textContent !== void 0) {
              for (const cellTextDocument of changedCells.textContent) {
                cellTextDocumentConnection.changeTextDocument({ textDocument: cellTextDocument.document, contentChanges: cellTextDocument.changes });
                text.push(cellTextDocument.document.uri);
              }
            }
          }
          this.updateCellMap(notebookDocument);
          const changeEvent = { notebookDocument };
          if (metadataChanged) {
            changeEvent.metadata = { old: oldMetadata, new: notebookDocument.metadata };
          }
          const added = [];
          for (const open of opened) {
            added.push(this.getNotebookCell(open));
          }
          const removed = [];
          for (const close of closed) {
            removed.push(this.getNotebookCell(close));
          }
          const textContent = [];
          for (const change2 of text) {
            textContent.push(this.getNotebookCell(change2));
          }
          if (added.length > 0 || removed.length > 0 || data.length > 0 || textContent.length > 0) {
            changeEvent.cells = { added, removed, changed: { data, textContent } };
          }
          if (changeEvent.metadata !== void 0 || changeEvent.cells !== void 0) {
            this._onDidChange.fire(changeEvent);
          }
        }));
        disposables.push(connection2.notebooks.synchronization.onDidSaveNotebookDocument((params) => {
          const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
          if (notebookDocument === void 0) {
            return;
          }
          this._onDidSave.fire(notebookDocument);
        }));
        disposables.push(connection2.notebooks.synchronization.onDidCloseNotebookDocument((params) => {
          const notebookDocument = this.notebookDocuments.get(params.notebookDocument.uri);
          if (notebookDocument === void 0) {
            return;
          }
          this._onDidClose.fire(notebookDocument);
          for (const cellTextDocument of params.cellTextDocuments) {
            cellTextDocumentConnection.closeTextDocument({ textDocument: cellTextDocument });
          }
          this.notebookDocuments.delete(params.notebookDocument.uri);
          for (const cell of notebookDocument.cells) {
            this.notebookCellMap.delete(cell.document);
          }
        }));
        return vscode_languageserver_protocol_1.Disposable.create(() => {
          disposables.forEach((disposable) => disposable.dispose());
        });
      }
      updateCellMap(notebookDocument) {
        for (const cell of notebookDocument.cells) {
          this.notebookCellMap.set(cell.document, [cell, notebookDocument]);
        }
      }
    };
    exports2.NotebookDocuments = NotebookDocuments;
  }
});

// node_modules/vscode-languageserver/lib/common/moniker.js
var require_moniker = __commonJS({
  "node_modules/vscode-languageserver/lib/common/moniker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MonikerFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var MonikerFeature = (Base) => {
      return class extends Base {
        get moniker() {
          return {
            on: (handler) => {
              const type = vscode_languageserver_protocol_1.MonikerRequest.type;
              return this.connection.onRequest(type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params), this.attachPartialResultProgress(type, params));
              });
            }
          };
        }
      };
    };
    exports2.MonikerFeature = MonikerFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/server.js
var require_server = __commonJS({
  "node_modules/vscode-languageserver/lib/common/server.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createConnection = exports2.combineFeatures = exports2.combineNotebooksFeatures = exports2.combineLanguagesFeatures = exports2.combineWorkspaceFeatures = exports2.combineWindowFeatures = exports2.combineClientFeatures = exports2.combineTracerFeatures = exports2.combineTelemetryFeatures = exports2.combineConsoleFeatures = exports2._NotebooksImpl = exports2._LanguagesImpl = exports2.BulkUnregistration = exports2.BulkRegistration = exports2.ErrorMessageTracker = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var Is2 = require_is();
    var UUID = require_uuid();
    var progress_1 = require_progress();
    var configuration_1 = require_configuration();
    var workspaceFolder_1 = require_workspaceFolder();
    var callHierarchy_1 = require_callHierarchy();
    var semanticTokens_1 = require_semanticTokens();
    var showDocument_1 = require_showDocument();
    var fileOperations_1 = require_fileOperations();
    var linkedEditingRange_1 = require_linkedEditingRange();
    var typeHierarchy_1 = require_typeHierarchy();
    var inlineValue_1 = require_inlineValue();
    var foldingRange_1 = require_foldingRange();
    var inlayHint_1 = require_inlayHint();
    var diagnostic_1 = require_diagnostic();
    var notebook_1 = require_notebook();
    var moniker_1 = require_moniker();
    function null2Undefined(value) {
      if (value === null) {
        return void 0;
      }
      return value;
    }
    var ErrorMessageTracker = class {
      constructor() {
        this._messages = /* @__PURE__ */ Object.create(null);
      }
      /**
       * Add a message to the tracker.
       *
       * @param message The message to add.
       */
      add(message) {
        let count = this._messages[message];
        if (!count) {
          count = 0;
        }
        count++;
        this._messages[message] = count;
      }
      /**
       * Send all tracked messages to the connection's window.
       *
       * @param connection The connection established between client and server.
       */
      sendErrors(connection2) {
        Object.keys(this._messages).forEach((message) => {
          connection2.window.showErrorMessage(message);
        });
      }
    };
    exports2.ErrorMessageTracker = ErrorMessageTracker;
    var RemoteConsoleImpl = class {
      constructor() {
      }
      rawAttach(connection2) {
        this._rawConnection = connection2;
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      fillServerCapabilities(_capabilities) {
      }
      initialize(_capabilities) {
      }
      error(message) {
        this.send(vscode_languageserver_protocol_1.MessageType.Error, message);
      }
      warn(message) {
        this.send(vscode_languageserver_protocol_1.MessageType.Warning, message);
      }
      info(message) {
        this.send(vscode_languageserver_protocol_1.MessageType.Info, message);
      }
      log(message) {
        this.send(vscode_languageserver_protocol_1.MessageType.Log, message);
      }
      debug(message) {
        this.send(vscode_languageserver_protocol_1.MessageType.Debug, message);
      }
      send(type, message) {
        if (this._rawConnection) {
          this._rawConnection.sendNotification(vscode_languageserver_protocol_1.LogMessageNotification.type, { type, message }).catch(() => {
            (0, vscode_languageserver_protocol_1.RAL)().console.error(`Sending log message failed`);
          });
        }
      }
    };
    var _RemoteWindowImpl = class {
      constructor() {
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      showErrorMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1.MessageType.Error, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.ShowMessageRequest.type, params).then(null2Undefined);
      }
      showWarningMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1.MessageType.Warning, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.ShowMessageRequest.type, params).then(null2Undefined);
      }
      showInformationMessage(message, ...actions) {
        let params = { type: vscode_languageserver_protocol_1.MessageType.Info, message, actions };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.ShowMessageRequest.type, params).then(null2Undefined);
      }
    };
    var RemoteWindowImpl = (0, showDocument_1.ShowDocumentFeature)((0, progress_1.ProgressFeature)(_RemoteWindowImpl));
    var BulkRegistration;
    (function(BulkRegistration2) {
      function create() {
        return new BulkRegistrationImpl();
      }
      BulkRegistration2.create = create;
    })(BulkRegistration || (exports2.BulkRegistration = BulkRegistration = {}));
    var BulkRegistrationImpl = class {
      constructor() {
        this._registrations = [];
        this._registered = /* @__PURE__ */ new Set();
      }
      add(type, registerOptions) {
        const method = Is2.string(type) ? type : type.method;
        if (this._registered.has(method)) {
          throw new Error(`${method} is already added to this registration`);
        }
        const id = UUID.generateUuid();
        this._registrations.push({
          id,
          method,
          registerOptions: registerOptions || {}
        });
        this._registered.add(method);
      }
      asRegistrationParams() {
        return {
          registrations: this._registrations
        };
      }
    };
    var BulkUnregistration;
    (function(BulkUnregistration2) {
      function create() {
        return new BulkUnregistrationImpl(void 0, []);
      }
      BulkUnregistration2.create = create;
    })(BulkUnregistration || (exports2.BulkUnregistration = BulkUnregistration = {}));
    var BulkUnregistrationImpl = class {
      constructor(_connection, unregistrations) {
        this._connection = _connection;
        this._unregistrations = /* @__PURE__ */ new Map();
        unregistrations.forEach((unregistration) => {
          this._unregistrations.set(unregistration.method, unregistration);
        });
      }
      get isAttached() {
        return !!this._connection;
      }
      attach(connection2) {
        this._connection = connection2;
      }
      add(unregistration) {
        this._unregistrations.set(unregistration.method, unregistration);
      }
      dispose() {
        let unregistrations = [];
        for (let unregistration of this._unregistrations.values()) {
          unregistrations.push(unregistration);
        }
        let params = {
          unregisterations: unregistrations
        };
        this._connection.sendRequest(vscode_languageserver_protocol_1.UnregistrationRequest.type, params).catch(() => {
          this._connection.console.info(`Bulk unregistration failed.`);
        });
      }
      disposeSingle(arg) {
        const method = Is2.string(arg) ? arg : arg.method;
        const unregistration = this._unregistrations.get(method);
        if (!unregistration) {
          return false;
        }
        let params = {
          unregisterations: [unregistration]
        };
        this._connection.sendRequest(vscode_languageserver_protocol_1.UnregistrationRequest.type, params).then(() => {
          this._unregistrations.delete(method);
        }, (_error) => {
          this._connection.console.info(`Un-registering request handler for ${unregistration.id} failed.`);
        });
        return true;
      }
    };
    var RemoteClientImpl = class {
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      register(typeOrRegistrations, registerOptionsOrType, registerOptions) {
        if (typeOrRegistrations instanceof BulkRegistrationImpl) {
          return this.registerMany(typeOrRegistrations);
        } else if (typeOrRegistrations instanceof BulkUnregistrationImpl) {
          return this.registerSingle1(typeOrRegistrations, registerOptionsOrType, registerOptions);
        } else {
          return this.registerSingle2(typeOrRegistrations, registerOptionsOrType);
        }
      }
      registerSingle1(unregistration, type, registerOptions) {
        const method = Is2.string(type) ? type : type.method;
        const id = UUID.generateUuid();
        let params = {
          registrations: [{ id, method, registerOptions: registerOptions || {} }]
        };
        if (!unregistration.isAttached) {
          unregistration.attach(this.connection);
        }
        return this.connection.sendRequest(vscode_languageserver_protocol_1.RegistrationRequest.type, params).then((_result) => {
          unregistration.add({ id, method });
          return unregistration;
        }, (_error) => {
          this.connection.console.info(`Registering request handler for ${method} failed.`);
          return Promise.reject(_error);
        });
      }
      registerSingle2(type, registerOptions) {
        const method = Is2.string(type) ? type : type.method;
        const id = UUID.generateUuid();
        let params = {
          registrations: [{ id, method, registerOptions: registerOptions || {} }]
        };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.RegistrationRequest.type, params).then((_result) => {
          return vscode_languageserver_protocol_1.Disposable.create(() => {
            this.unregisterSingle(id, method).catch(() => {
              this.connection.console.info(`Un-registering capability with id ${id} failed.`);
            });
          });
        }, (_error) => {
          this.connection.console.info(`Registering request handler for ${method} failed.`);
          return Promise.reject(_error);
        });
      }
      unregisterSingle(id, method) {
        let params = {
          unregisterations: [{ id, method }]
        };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.UnregistrationRequest.type, params).catch(() => {
          this.connection.console.info(`Un-registering request handler for ${id} failed.`);
        });
      }
      registerMany(registrations) {
        let params = registrations.asRegistrationParams();
        return this.connection.sendRequest(vscode_languageserver_protocol_1.RegistrationRequest.type, params).then(() => {
          return new BulkUnregistrationImpl(this._connection, params.registrations.map((registration) => {
            return { id: registration.id, method: registration.method };
          }));
        }, (_error) => {
          this.connection.console.info(`Bulk registration failed.`);
          return Promise.reject(_error);
        });
      }
    };
    var _RemoteWorkspaceImpl = class {
      constructor() {
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      applyEdit(paramOrEdit) {
        function isApplyWorkspaceEditParams(value) {
          return value && !!value.edit;
        }
        let params = isApplyWorkspaceEditParams(paramOrEdit) ? paramOrEdit : { edit: paramOrEdit };
        return this.connection.sendRequest(vscode_languageserver_protocol_1.ApplyWorkspaceEditRequest.type, params);
      }
    };
    var RemoteWorkspaceImpl = (0, fileOperations_1.FileOperationsFeature)((0, workspaceFolder_1.WorkspaceFoldersFeature)((0, configuration_1.ConfigurationFeature)(_RemoteWorkspaceImpl)));
    var TracerImpl = class {
      constructor() {
        this._trace = vscode_languageserver_protocol_1.Trace.Off;
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      set trace(value) {
        this._trace = value;
      }
      log(message, verbose) {
        if (this._trace === vscode_languageserver_protocol_1.Trace.Off) {
          return;
        }
        this.connection.sendNotification(vscode_languageserver_protocol_1.LogTraceNotification.type, {
          message,
          verbose: this._trace === vscode_languageserver_protocol_1.Trace.Verbose ? verbose : void 0
        }).catch(() => {
        });
      }
    };
    var TelemetryImpl = class {
      constructor() {
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      logEvent(data) {
        this.connection.sendNotification(vscode_languageserver_protocol_1.TelemetryEventNotification.type, data).catch(() => {
          this.connection.console.log(`Sending TelemetryEventNotification failed`);
        });
      }
    };
    var _LanguagesImpl = class {
      constructor() {
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      attachWorkDoneProgress(params) {
        return (0, progress_1.attachWorkDone)(this.connection, params);
      }
      attachPartialResultProgress(_type, params) {
        return (0, progress_1.attachPartialResult)(this.connection, params);
      }
    };
    exports2._LanguagesImpl = _LanguagesImpl;
    var LanguagesImpl = (0, foldingRange_1.FoldingRangeFeature)((0, moniker_1.MonikerFeature)((0, diagnostic_1.DiagnosticFeature)((0, inlayHint_1.InlayHintFeature)((0, inlineValue_1.InlineValueFeature)((0, typeHierarchy_1.TypeHierarchyFeature)((0, linkedEditingRange_1.LinkedEditingRangeFeature)((0, semanticTokens_1.SemanticTokensFeature)((0, callHierarchy_1.CallHierarchyFeature)(_LanguagesImpl)))))))));
    var _NotebooksImpl = class {
      constructor() {
      }
      attach(connection2) {
        this._connection = connection2;
      }
      get connection() {
        if (!this._connection) {
          throw new Error("Remote is not attached to a connection yet.");
        }
        return this._connection;
      }
      initialize(_capabilities) {
      }
      fillServerCapabilities(_capabilities) {
      }
      attachWorkDoneProgress(params) {
        return (0, progress_1.attachWorkDone)(this.connection, params);
      }
      attachPartialResultProgress(_type, params) {
        return (0, progress_1.attachPartialResult)(this.connection, params);
      }
    };
    exports2._NotebooksImpl = _NotebooksImpl;
    var NotebooksImpl = (0, notebook_1.NotebookSyncFeature)(_NotebooksImpl);
    function combineConsoleFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineConsoleFeatures = combineConsoleFeatures;
    function combineTelemetryFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineTelemetryFeatures = combineTelemetryFeatures;
    function combineTracerFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineTracerFeatures = combineTracerFeatures;
    function combineClientFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineClientFeatures = combineClientFeatures;
    function combineWindowFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineWindowFeatures = combineWindowFeatures;
    function combineWorkspaceFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineWorkspaceFeatures = combineWorkspaceFeatures;
    function combineLanguagesFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineLanguagesFeatures = combineLanguagesFeatures;
    function combineNotebooksFeatures(one, two) {
      return function(Base) {
        return two(one(Base));
      };
    }
    exports2.combineNotebooksFeatures = combineNotebooksFeatures;
    function combineFeatures(one, two) {
      function combine(one2, two2, func) {
        if (one2 && two2) {
          return func(one2, two2);
        } else if (one2) {
          return one2;
        } else {
          return two2;
        }
      }
      let result = {
        __brand: "features",
        console: combine(one.console, two.console, combineConsoleFeatures),
        tracer: combine(one.tracer, two.tracer, combineTracerFeatures),
        telemetry: combine(one.telemetry, two.telemetry, combineTelemetryFeatures),
        client: combine(one.client, two.client, combineClientFeatures),
        window: combine(one.window, two.window, combineWindowFeatures),
        workspace: combine(one.workspace, two.workspace, combineWorkspaceFeatures),
        languages: combine(one.languages, two.languages, combineLanguagesFeatures),
        notebooks: combine(one.notebooks, two.notebooks, combineNotebooksFeatures)
      };
      return result;
    }
    exports2.combineFeatures = combineFeatures;
    function createConnection2(connectionFactory, watchDog, factories) {
      const logger = factories && factories.console ? new (factories.console(RemoteConsoleImpl))() : new RemoteConsoleImpl();
      const connection2 = connectionFactory(logger);
      logger.rawAttach(connection2);
      const tracer = factories && factories.tracer ? new (factories.tracer(TracerImpl))() : new TracerImpl();
      const telemetry = factories && factories.telemetry ? new (factories.telemetry(TelemetryImpl))() : new TelemetryImpl();
      const client = factories && factories.client ? new (factories.client(RemoteClientImpl))() : new RemoteClientImpl();
      const remoteWindow = factories && factories.window ? new (factories.window(RemoteWindowImpl))() : new RemoteWindowImpl();
      const workspace = factories && factories.workspace ? new (factories.workspace(RemoteWorkspaceImpl))() : new RemoteWorkspaceImpl();
      const languages = factories && factories.languages ? new (factories.languages(LanguagesImpl))() : new LanguagesImpl();
      const notebooks = factories && factories.notebooks ? new (factories.notebooks(NotebooksImpl))() : new NotebooksImpl();
      const allRemotes = [logger, tracer, telemetry, client, remoteWindow, workspace, languages, notebooks];
      function asPromise(value) {
        if (value instanceof Promise) {
          return value;
        } else if (Is2.thenable(value)) {
          return new Promise((resolve, reject) => {
            value.then((resolved) => resolve(resolved), (error) => reject(error));
          });
        } else {
          return Promise.resolve(value);
        }
      }
      let shutdownHandler = void 0;
      let initializeHandler = void 0;
      let exitHandler = void 0;
      let protocolConnection = {
        listen: () => connection2.listen(),
        sendRequest: (type, ...params) => connection2.sendRequest(Is2.string(type) ? type : type.method, ...params),
        onRequest: (type, handler) => connection2.onRequest(type, handler),
        sendNotification: (type, param) => {
          const method = Is2.string(type) ? type : type.method;
          return connection2.sendNotification(method, param);
        },
        onNotification: (type, handler) => connection2.onNotification(type, handler),
        onProgress: connection2.onProgress,
        sendProgress: connection2.sendProgress,
        onInitialize: (handler) => {
          initializeHandler = handler;
          return {
            dispose: () => {
              initializeHandler = void 0;
            }
          };
        },
        onInitialized: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.InitializedNotification.type, handler),
        onShutdown: (handler) => {
          shutdownHandler = handler;
          return {
            dispose: () => {
              shutdownHandler = void 0;
            }
          };
        },
        onExit: (handler) => {
          exitHandler = handler;
          return {
            dispose: () => {
              exitHandler = void 0;
            }
          };
        },
        get console() {
          return logger;
        },
        get telemetry() {
          return telemetry;
        },
        get tracer() {
          return tracer;
        },
        get client() {
          return client;
        },
        get window() {
          return remoteWindow;
        },
        get workspace() {
          return workspace;
        },
        get languages() {
          return languages;
        },
        get notebooks() {
          return notebooks;
        },
        onDidChangeConfiguration: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidChangeConfigurationNotification.type, handler),
        onDidChangeWatchedFiles: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidChangeWatchedFilesNotification.type, handler),
        __textDocumentSync: void 0,
        onDidOpenTextDocument: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidOpenTextDocumentNotification.type, handler),
        onDidChangeTextDocument: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidChangeTextDocumentNotification.type, handler),
        onDidCloseTextDocument: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidCloseTextDocumentNotification.type, handler),
        onWillSaveTextDocument: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.WillSaveTextDocumentNotification.type, handler),
        onWillSaveTextDocumentWaitUntil: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.WillSaveTextDocumentWaitUntilRequest.type, handler),
        onDidSaveTextDocument: (handler) => connection2.onNotification(vscode_languageserver_protocol_1.DidSaveTextDocumentNotification.type, handler),
        sendDiagnostics: (params) => connection2.sendNotification(vscode_languageserver_protocol_1.PublishDiagnosticsNotification.type, params),
        onHover: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.HoverRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        onCompletion: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CompletionRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onCompletionResolve: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CompletionResolveRequest.type, handler),
        onSignatureHelp: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.SignatureHelpRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        onDeclaration: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DeclarationRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onDefinition: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DefinitionRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onTypeDefinition: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.TypeDefinitionRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onImplementation: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.ImplementationRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onReferences: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.ReferencesRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onDocumentHighlight: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentHighlightRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onDocumentSymbol: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentSymbolRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onWorkspaceSymbol: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.WorkspaceSymbolRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onWorkspaceSymbolResolve: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.WorkspaceSymbolResolveRequest.type, handler),
        onCodeAction: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CodeActionRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onCodeActionResolve: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CodeActionResolveRequest.type, (params, cancel) => {
          return handler(params, cancel);
        }),
        onCodeLens: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CodeLensRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onCodeLensResolve: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.CodeLensResolveRequest.type, (params, cancel) => {
          return handler(params, cancel);
        }),
        onDocumentFormatting: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentFormattingRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        onDocumentRangeFormatting: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentRangeFormattingRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        onDocumentOnTypeFormatting: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentOnTypeFormattingRequest.type, (params, cancel) => {
          return handler(params, cancel);
        }),
        onRenameRequest: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.RenameRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        onPrepareRename: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.PrepareRenameRequest.type, (params, cancel) => {
          return handler(params, cancel);
        }),
        onDocumentLinks: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentLinkRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onDocumentLinkResolve: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentLinkResolveRequest.type, (params, cancel) => {
          return handler(params, cancel);
        }),
        onDocumentColor: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.DocumentColorRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onColorPresentation: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.ColorPresentationRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onFoldingRanges: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.FoldingRangeRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onSelectionRanges: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.SelectionRangeRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), (0, progress_1.attachPartialResult)(connection2, params));
        }),
        onExecuteCommand: (handler) => connection2.onRequest(vscode_languageserver_protocol_1.ExecuteCommandRequest.type, (params, cancel) => {
          return handler(params, cancel, (0, progress_1.attachWorkDone)(connection2, params), void 0);
        }),
        dispose: () => connection2.dispose()
      };
      for (let remote of allRemotes) {
        remote.attach(protocolConnection);
      }
      connection2.onRequest(vscode_languageserver_protocol_1.InitializeRequest.type, (params) => {
        watchDog.initialize(params);
        if (Is2.string(params.trace)) {
          tracer.trace = vscode_languageserver_protocol_1.Trace.fromString(params.trace);
        }
        for (let remote of allRemotes) {
          remote.initialize(params.capabilities);
        }
        if (initializeHandler) {
          let result = initializeHandler(params, new vscode_languageserver_protocol_1.CancellationTokenSource().token, (0, progress_1.attachWorkDone)(connection2, params), void 0);
          return asPromise(result).then((value) => {
            if (value instanceof vscode_languageserver_protocol_1.ResponseError) {
              return value;
            }
            let result2 = value;
            if (!result2) {
              result2 = { capabilities: {} };
            }
            let capabilities = result2.capabilities;
            if (!capabilities) {
              capabilities = {};
              result2.capabilities = capabilities;
            }
            if (capabilities.textDocumentSync === void 0 || capabilities.textDocumentSync === null) {
              capabilities.textDocumentSync = Is2.number(protocolConnection.__textDocumentSync) ? protocolConnection.__textDocumentSync : vscode_languageserver_protocol_1.TextDocumentSyncKind.None;
            } else if (!Is2.number(capabilities.textDocumentSync) && !Is2.number(capabilities.textDocumentSync.change)) {
              capabilities.textDocumentSync.change = Is2.number(protocolConnection.__textDocumentSync) ? protocolConnection.__textDocumentSync : vscode_languageserver_protocol_1.TextDocumentSyncKind.None;
            }
            for (let remote of allRemotes) {
              remote.fillServerCapabilities(capabilities);
            }
            return result2;
          });
        } else {
          let result = { capabilities: { textDocumentSync: vscode_languageserver_protocol_1.TextDocumentSyncKind.None } };
          for (let remote of allRemotes) {
            remote.fillServerCapabilities(result.capabilities);
          }
          return result;
        }
      });
      connection2.onRequest(vscode_languageserver_protocol_1.ShutdownRequest.type, () => {
        watchDog.shutdownReceived = true;
        if (shutdownHandler) {
          return shutdownHandler(new vscode_languageserver_protocol_1.CancellationTokenSource().token);
        } else {
          return void 0;
        }
      });
      connection2.onNotification(vscode_languageserver_protocol_1.ExitNotification.type, () => {
        try {
          if (exitHandler) {
            exitHandler();
          }
        } finally {
          if (watchDog.shutdownReceived) {
            watchDog.exit(0);
          } else {
            watchDog.exit(1);
          }
        }
      });
      connection2.onNotification(vscode_languageserver_protocol_1.SetTraceNotification.type, (params) => {
        tracer.trace = vscode_languageserver_protocol_1.Trace.fromString(params.value);
      });
      return protocolConnection;
    }
    exports2.createConnection = createConnection2;
  }
});

// node_modules/vscode-languageserver/lib/node/files.js
var require_files = __commonJS({
  "node_modules/vscode-languageserver/lib/node/files.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveModulePath = exports2.FileSystem = exports2.resolveGlobalYarnPath = exports2.resolveGlobalNodePath = exports2.resolve = exports2.uriToFilePath = void 0;
    var url = require("url");
    var path = require("path");
    var fs = require("fs");
    var child_process_1 = require("child_process");
    function uriToFilePath(uri) {
      let parsed = url.parse(uri);
      if (parsed.protocol !== "file:" || !parsed.path) {
        return void 0;
      }
      let segments = parsed.path.split("/");
      for (var i = 0, len = segments.length; i < len; i++) {
        segments[i] = decodeURIComponent(segments[i]);
      }
      if (process.platform === "win32" && segments.length > 1) {
        let first = segments[0];
        let second = segments[1];
        if (first.length === 0 && second.length > 1 && second[1] === ":") {
          segments.shift();
        }
      }
      return path.normalize(segments.join("/"));
    }
    exports2.uriToFilePath = uriToFilePath;
    function isWindows() {
      return process.platform === "win32";
    }
    function resolve(moduleName, nodePath, cwd, tracer) {
      const nodePathKey = "NODE_PATH";
      const app = [
        "var p = process;",
        "p.on('message',function(m){",
        "if(m.c==='e'){",
        "p.exit(0);",
        "}",
        "else if(m.c==='rs'){",
        "try{",
        "var r=require.resolve(m.a);",
        "p.send({c:'r',s:true,r:r});",
        "}",
        "catch(err){",
        "p.send({c:'r',s:false});",
        "}",
        "}",
        "});"
      ].join("");
      return new Promise((resolve2, reject) => {
        let env = process.env;
        let newEnv = /* @__PURE__ */ Object.create(null);
        Object.keys(env).forEach((key) => newEnv[key] = env[key]);
        if (nodePath && fs.existsSync(nodePath)) {
          if (newEnv[nodePathKey]) {
            newEnv[nodePathKey] = nodePath + path.delimiter + newEnv[nodePathKey];
          } else {
            newEnv[nodePathKey] = nodePath;
          }
          if (tracer) {
            tracer(`NODE_PATH value is: ${newEnv[nodePathKey]}`);
          }
        }
        newEnv["ELECTRON_RUN_AS_NODE"] = "1";
        try {
          let cp = (0, child_process_1.fork)("", [], {
            cwd,
            env: newEnv,
            execArgv: ["-e", app]
          });
          if (cp.pid === void 0) {
            reject(new Error(`Starting process to resolve node module  ${moduleName} failed`));
            return;
          }
          cp.on("error", (error) => {
            reject(error);
          });
          cp.on("message", (message2) => {
            if (message2.c === "r") {
              cp.send({ c: "e" });
              if (message2.s) {
                resolve2(message2.r);
              } else {
                reject(new Error(`Failed to resolve module: ${moduleName}`));
              }
            }
          });
          let message = {
            c: "rs",
            a: moduleName
          };
          cp.send(message);
        } catch (error) {
          reject(error);
        }
      });
    }
    exports2.resolve = resolve;
    function resolveGlobalNodePath(tracer) {
      let npmCommand = "npm";
      const env = /* @__PURE__ */ Object.create(null);
      Object.keys(process.env).forEach((key) => env[key] = process.env[key]);
      env["NO_UPDATE_NOTIFIER"] = "true";
      const options = {
        encoding: "utf8",
        env
      };
      if (isWindows()) {
        npmCommand = "npm.cmd";
        options.shell = true;
      }
      let handler = () => {
      };
      try {
        process.on("SIGPIPE", handler);
        let stdout = (0, child_process_1.spawnSync)(npmCommand, ["config", "get", "prefix"], options).stdout;
        if (!stdout) {
          if (tracer) {
            tracer(`'npm config get prefix' didn't return a value.`);
          }
          return void 0;
        }
        let prefix = stdout.trim();
        if (tracer) {
          tracer(`'npm config get prefix' value is: ${prefix}`);
        }
        if (prefix.length > 0) {
          if (isWindows()) {
            return path.join(prefix, "node_modules");
          } else {
            return path.join(prefix, "lib", "node_modules");
          }
        }
        return void 0;
      } catch (err) {
        return void 0;
      } finally {
        process.removeListener("SIGPIPE", handler);
      }
    }
    exports2.resolveGlobalNodePath = resolveGlobalNodePath;
    function resolveGlobalYarnPath(tracer) {
      let yarnCommand = "yarn";
      let options = {
        encoding: "utf8"
      };
      if (isWindows()) {
        yarnCommand = "yarn.cmd";
        options.shell = true;
      }
      let handler = () => {
      };
      try {
        process.on("SIGPIPE", handler);
        let results = (0, child_process_1.spawnSync)(yarnCommand, ["global", "dir", "--json"], options);
        let stdout = results.stdout;
        if (!stdout) {
          if (tracer) {
            tracer(`'yarn global dir' didn't return a value.`);
            if (results.stderr) {
              tracer(results.stderr);
            }
          }
          return void 0;
        }
        let lines = stdout.trim().split(/\r?\n/);
        for (let line of lines) {
          try {
            let yarn = JSON.parse(line);
            if (yarn.type === "log") {
              return path.join(yarn.data, "node_modules");
            }
          } catch (e) {
          }
        }
        return void 0;
      } catch (err) {
        return void 0;
      } finally {
        process.removeListener("SIGPIPE", handler);
      }
    }
    exports2.resolveGlobalYarnPath = resolveGlobalYarnPath;
    var FileSystem;
    (function(FileSystem2) {
      let _isCaseSensitive = void 0;
      function isCaseSensitive() {
        if (_isCaseSensitive !== void 0) {
          return _isCaseSensitive;
        }
        if (process.platform === "win32") {
          _isCaseSensitive = false;
        } else {
          _isCaseSensitive = !fs.existsSync(__filename.toUpperCase()) || !fs.existsSync(__filename.toLowerCase());
        }
        return _isCaseSensitive;
      }
      FileSystem2.isCaseSensitive = isCaseSensitive;
      function isParent(parent, child) {
        if (isCaseSensitive()) {
          return path.normalize(child).indexOf(path.normalize(parent)) === 0;
        } else {
          return path.normalize(child).toLowerCase().indexOf(path.normalize(parent).toLowerCase()) === 0;
        }
      }
      FileSystem2.isParent = isParent;
    })(FileSystem || (exports2.FileSystem = FileSystem = {}));
    function resolveModulePath(workspaceRoot, moduleName, nodePath, tracer) {
      if (nodePath) {
        if (!path.isAbsolute(nodePath)) {
          nodePath = path.join(workspaceRoot, nodePath);
        }
        return resolve(moduleName, nodePath, nodePath, tracer).then((value) => {
          if (FileSystem.isParent(nodePath, value)) {
            return value;
          } else {
            return Promise.reject(new Error(`Failed to load ${moduleName} from node path location.`));
          }
        }).then(void 0, (_error) => {
          return resolve(moduleName, resolveGlobalNodePath(tracer), workspaceRoot, tracer);
        });
      } else {
        return resolve(moduleName, resolveGlobalNodePath(tracer), workspaceRoot, tracer);
      }
    }
    exports2.resolveModulePath = resolveModulePath;
  }
});

// node_modules/vscode-languageserver-protocol/node.js
var require_node2 = __commonJS({
  "node_modules/vscode-languageserver-protocol/node.js"(exports2, module2) {
    "use strict";
    module2.exports = require_main3();
  }
});

// node_modules/vscode-languageserver/lib/common/inlineCompletion.proposed.js
var require_inlineCompletion_proposed = __commonJS({
  "node_modules/vscode-languageserver/lib/common/inlineCompletion.proposed.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.InlineCompletionFeature = void 0;
    var vscode_languageserver_protocol_1 = require_main3();
    var InlineCompletionFeature = (Base) => {
      return class extends Base {
        get inlineCompletion() {
          return {
            on: (handler) => {
              return this.connection.onRequest(vscode_languageserver_protocol_1.InlineCompletionRequest.type, (params, cancel) => {
                return handler(params, cancel, this.attachWorkDoneProgress(params));
              });
            }
          };
        }
      };
    };
    exports2.InlineCompletionFeature = InlineCompletionFeature;
  }
});

// node_modules/vscode-languageserver/lib/common/api.js
var require_api3 = __commonJS({
  "node_modules/vscode-languageserver/lib/common/api.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ProposedFeatures = exports2.NotebookDocuments = exports2.TextDocuments = exports2.SemanticTokensBuilder = void 0;
    var semanticTokens_1 = require_semanticTokens();
    Object.defineProperty(exports2, "SemanticTokensBuilder", { enumerable: true, get: function() {
      return semanticTokens_1.SemanticTokensBuilder;
    } });
    var ic = require_inlineCompletion_proposed();
    __exportStar(require_main3(), exports2);
    var textDocuments_1 = require_textDocuments();
    Object.defineProperty(exports2, "TextDocuments", { enumerable: true, get: function() {
      return textDocuments_1.TextDocuments;
    } });
    var notebook_1 = require_notebook();
    Object.defineProperty(exports2, "NotebookDocuments", { enumerable: true, get: function() {
      return notebook_1.NotebookDocuments;
    } });
    __exportStar(require_server(), exports2);
    var ProposedFeatures;
    (function(ProposedFeatures2) {
      ProposedFeatures2.all = {
        __brand: "features",
        languages: ic.InlineCompletionFeature
      };
    })(ProposedFeatures || (exports2.ProposedFeatures = ProposedFeatures = {}));
  }
});

// node_modules/vscode-languageserver/lib/node/main.js
var require_main4 = __commonJS({
  "node_modules/vscode-languageserver/lib/node/main.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createConnection = exports2.Files = void 0;
    var node_util_1 = require("util");
    var Is2 = require_is();
    var server_1 = require_server();
    var fm = require_files();
    var node_1 = require_node2();
    __exportStar(require_node2(), exports2);
    __exportStar(require_api3(), exports2);
    var Files;
    (function(Files2) {
      Files2.uriToFilePath = fm.uriToFilePath;
      Files2.resolveGlobalNodePath = fm.resolveGlobalNodePath;
      Files2.resolveGlobalYarnPath = fm.resolveGlobalYarnPath;
      Files2.resolve = fm.resolve;
      Files2.resolveModulePath = fm.resolveModulePath;
    })(Files || (exports2.Files = Files = {}));
    var _protocolConnection;
    function endProtocolConnection() {
      if (_protocolConnection === void 0) {
        return;
      }
      try {
        _protocolConnection.end();
      } catch (_err) {
      }
    }
    var _shutdownReceived = false;
    var exitTimer = void 0;
    function setupExitTimer() {
      const argName = "--clientProcessId";
      function runTimer(value) {
        try {
          let processId = parseInt(value);
          if (!isNaN(processId)) {
            exitTimer = setInterval(() => {
              try {
                process.kill(processId, 0);
              } catch (ex) {
                endProtocolConnection();
                process.exit(_shutdownReceived ? 0 : 1);
              }
            }, 3e3);
          }
        } catch (e) {
        }
      }
      for (let i = 2; i < process.argv.length; i++) {
        let arg = process.argv[i];
        if (arg === argName && i + 1 < process.argv.length) {
          runTimer(process.argv[i + 1]);
          return;
        } else {
          let args = arg.split("=");
          if (args[0] === argName) {
            runTimer(args[1]);
          }
        }
      }
    }
    setupExitTimer();
    var watchDog = {
      initialize: (params) => {
        const processId = params.processId;
        if (Is2.number(processId) && exitTimer === void 0) {
          setInterval(() => {
            try {
              process.kill(processId, 0);
            } catch (ex) {
              process.exit(_shutdownReceived ? 0 : 1);
            }
          }, 3e3);
        }
      },
      get shutdownReceived() {
        return _shutdownReceived;
      },
      set shutdownReceived(value) {
        _shutdownReceived = value;
      },
      exit: (code) => {
        endProtocolConnection();
        process.exit(code);
      }
    };
    function createConnection2(arg1, arg2, arg3, arg4) {
      let factories;
      let input;
      let output;
      let options;
      if (arg1 !== void 0 && arg1.__brand === "features") {
        factories = arg1;
        arg1 = arg2;
        arg2 = arg3;
        arg3 = arg4;
      }
      if (node_1.ConnectionStrategy.is(arg1) || node_1.ConnectionOptions.is(arg1)) {
        options = arg1;
      } else {
        input = arg1;
        output = arg2;
        options = arg3;
      }
      return _createConnection(input, output, options, factories);
    }
    exports2.createConnection = createConnection2;
    function _createConnection(input, output, options, factories) {
      let stdio = false;
      if (!input && !output && process.argv.length > 2) {
        let port = void 0;
        let pipeName = void 0;
        let argv = process.argv.slice(2);
        for (let i = 0; i < argv.length; i++) {
          let arg = argv[i];
          if (arg === "--node-ipc") {
            input = new node_1.IPCMessageReader(process);
            output = new node_1.IPCMessageWriter(process);
            break;
          } else if (arg === "--stdio") {
            stdio = true;
            input = process.stdin;
            output = process.stdout;
            break;
          } else if (arg === "--socket") {
            port = parseInt(argv[i + 1]);
            break;
          } else if (arg === "--pipe") {
            pipeName = argv[i + 1];
            break;
          } else {
            var args = arg.split("=");
            if (args[0] === "--socket") {
              port = parseInt(args[1]);
              break;
            } else if (args[0] === "--pipe") {
              pipeName = args[1];
              break;
            }
          }
        }
        if (port) {
          let transport = (0, node_1.createServerSocketTransport)(port);
          input = transport[0];
          output = transport[1];
        } else if (pipeName) {
          let transport = (0, node_1.createServerPipeTransport)(pipeName);
          input = transport[0];
          output = transport[1];
        }
      }
      var commandLineMessage = "Use arguments of createConnection or set command line parameters: '--node-ipc', '--stdio' or '--socket={number}'";
      if (!input) {
        throw new Error("Connection input stream is not set. " + commandLineMessage);
      }
      if (!output) {
        throw new Error("Connection output stream is not set. " + commandLineMessage);
      }
      if (Is2.func(input.read) && Is2.func(input.on)) {
        let inputStream = input;
        inputStream.on("end", () => {
          endProtocolConnection();
          process.exit(_shutdownReceived ? 0 : 1);
        });
        inputStream.on("close", () => {
          endProtocolConnection();
          process.exit(_shutdownReceived ? 0 : 1);
        });
      }
      const connectionFactory = (logger) => {
        const result = (0, node_1.createProtocolConnection)(input, output, logger, options);
        if (stdio) {
          patchConsole(logger);
        }
        return result;
      };
      return (0, server_1.createConnection)(connectionFactory, watchDog, factories);
    }
    function patchConsole(logger) {
      function serialize(args) {
        return args.map((arg) => typeof arg === "string" ? arg : (0, node_util_1.inspect)(arg)).join(" ");
      }
      const counters = /* @__PURE__ */ new Map();
      console.assert = function assert(assertion, ...args) {
        if (assertion) {
          return;
        }
        if (args.length === 0) {
          logger.error("Assertion failed");
        } else {
          const [message, ...rest] = args;
          logger.error(`Assertion failed: ${message} ${serialize(rest)}`);
        }
      };
      console.count = function count(label = "default") {
        var _a3;
        const message = String(label);
        let counter = (_a3 = counters.get(message)) != null ? _a3 : 0;
        counter += 1;
        counters.set(message, counter);
        logger.log(`${message}: ${message}`);
      };
      console.countReset = function countReset(label) {
        if (label === void 0) {
          counters.clear();
        } else {
          counters.delete(String(label));
        }
      };
      console.debug = function debug(...args) {
        logger.log(serialize(args));
      };
      console.dir = function dir(arg, options) {
        logger.log((0, node_util_1.inspect)(arg, options));
      };
      console.log = function log(...args) {
        logger.log(serialize(args));
      };
      console.error = function error(...args) {
        logger.error(serialize(args));
      };
      console.trace = function trace(...args) {
        const stack = new Error().stack.replace(/(.+\n){2}/, "");
        let message = "Trace";
        if (args.length !== 0) {
          message += `: ${serialize(args)}`;
        }
        logger.log(`${message}
${stack}`);
      };
      console.warn = function warn(...args) {
        logger.warn(serialize(args));
      };
    }
  }
});

// node_modules/vscode-languageserver/node.js
var require_node3 = __commonJS({
  "node_modules/vscode-languageserver/node.js"(exports2, module2) {
    "use strict";
    module2.exports = require_main4();
  }
});

// node_modules/vscode-uri/lib/umd/index.js
var require_umd = __commonJS({
  "node_modules/vscode-uri/lib/umd/index.js"(exports2, module2) {
    "use strict";
    !function(t21, e) {
      if ("object" == typeof exports2 && "object" == typeof module2)
        module2.exports = e();
      else if ("function" == typeof define && define.amd)
        define([], e);
      else {
        var r = e();
        for (var n in r)
          ("object" == typeof exports2 ? exports2 : t21)[n] = r[n];
      }
    }(exports2, () => (() => {
      "use strict";
      var t21 = { 470: (t22) => {
        function e2(t23) {
          if ("string" != typeof t23)
            throw new TypeError("Path must be a string. Received " + JSON.stringify(t23));
        }
        function r2(t23, e3) {
          for (var r3, n3 = "", i = 0, o = -1, s = 0, a3 = 0; a3 <= t23.length; ++a3) {
            if (a3 < t23.length)
              r3 = t23.charCodeAt(a3);
            else {
              if (47 === r3)
                break;
              r3 = 47;
            }
            if (47 === r3) {
              if (o === a3 - 1 || 1 === s)
                ;
              else if (o !== a3 - 1 && 2 === s) {
                if (n3.length < 2 || 2 !== i || 46 !== n3.charCodeAt(n3.length - 1) || 46 !== n3.charCodeAt(n3.length - 2)) {
                  if (n3.length > 2) {
                    var h = n3.lastIndexOf("/");
                    if (h !== n3.length - 1) {
                      -1 === h ? (n3 = "", i = 0) : i = (n3 = n3.slice(0, h)).length - 1 - n3.lastIndexOf("/"), o = a3, s = 0;
                      continue;
                    }
                  } else if (2 === n3.length || 1 === n3.length) {
                    n3 = "", i = 0, o = a3, s = 0;
                    continue;
                  }
                }
                e3 && (n3.length > 0 ? n3 += "/.." : n3 = "..", i = 2);
              } else
                n3.length > 0 ? n3 += "/" + t23.slice(o + 1, a3) : n3 = t23.slice(o + 1, a3), i = a3 - o - 1;
              o = a3, s = 0;
            } else
              46 === r3 && -1 !== s ? ++s : s = -1;
          }
          return n3;
        }
        var n2 = { resolve: function() {
          for (var t23, n3 = "", i = false, o = arguments.length - 1; o >= -1 && !i; o--) {
            var s;
            o >= 0 ? s = arguments[o] : (void 0 === t23 && (t23 = process.cwd()), s = t23), e2(s), 0 !== s.length && (n3 = s + "/" + n3, i = 47 === s.charCodeAt(0));
          }
          return n3 = r2(n3, !i), i ? n3.length > 0 ? "/" + n3 : "/" : n3.length > 0 ? n3 : ".";
        }, normalize: function(t23) {
          if (e2(t23), 0 === t23.length)
            return ".";
          var n3 = 47 === t23.charCodeAt(0), i = 47 === t23.charCodeAt(t23.length - 1);
          return 0 !== (t23 = r2(t23, !n3)).length || n3 || (t23 = "."), t23.length > 0 && i && (t23 += "/"), n3 ? "/" + t23 : t23;
        }, isAbsolute: function(t23) {
          return e2(t23), t23.length > 0 && 47 === t23.charCodeAt(0);
        }, join: function() {
          if (0 === arguments.length)
            return ".";
          for (var t23, r3 = 0; r3 < arguments.length; ++r3) {
            var i = arguments[r3];
            e2(i), i.length > 0 && (void 0 === t23 ? t23 = i : t23 += "/" + i);
          }
          return void 0 === t23 ? "." : n2.normalize(t23);
        }, relative: function(t23, r3) {
          if (e2(t23), e2(r3), t23 === r3)
            return "";
          if ((t23 = n2.resolve(t23)) === (r3 = n2.resolve(r3)))
            return "";
          for (var i = 1; i < t23.length && 47 === t23.charCodeAt(i); ++i)
            ;
          for (var o = t23.length, s = o - i, a3 = 1; a3 < r3.length && 47 === r3.charCodeAt(a3); ++a3)
            ;
          for (var h = r3.length - a3, c = s < h ? s : h, f3 = -1, u = 0; u <= c; ++u) {
            if (u === c) {
              if (h > c) {
                if (47 === r3.charCodeAt(a3 + u))
                  return r3.slice(a3 + u + 1);
                if (0 === u)
                  return r3.slice(a3 + u);
              } else
                s > c && (47 === t23.charCodeAt(i + u) ? f3 = u : 0 === u && (f3 = 0));
              break;
            }
            var l = t23.charCodeAt(i + u);
            if (l !== r3.charCodeAt(a3 + u))
              break;
            47 === l && (f3 = u);
          }
          var d = "";
          for (u = i + f3 + 1; u <= o; ++u)
            u !== o && 47 !== t23.charCodeAt(u) || (0 === d.length ? d += ".." : d += "/..");
          return d.length > 0 ? d + r3.slice(a3 + f3) : (a3 += f3, 47 === r3.charCodeAt(a3) && ++a3, r3.slice(a3));
        }, _makeLong: function(t23) {
          return t23;
        }, dirname: function(t23) {
          if (e2(t23), 0 === t23.length)
            return ".";
          for (var r3 = t23.charCodeAt(0), n3 = 47 === r3, i = -1, o = true, s = t23.length - 1; s >= 1; --s)
            if (47 === (r3 = t23.charCodeAt(s))) {
              if (!o) {
                i = s;
                break;
              }
            } else
              o = false;
          return -1 === i ? n3 ? "/" : "." : n3 && 1 === i ? "//" : t23.slice(0, i);
        }, basename: function(t23, r3) {
          if (void 0 !== r3 && "string" != typeof r3)
            throw new TypeError('"ext" argument must be a string');
          e2(t23);
          var n3, i = 0, o = -1, s = true;
          if (void 0 !== r3 && r3.length > 0 && r3.length <= t23.length) {
            if (r3.length === t23.length && r3 === t23)
              return "";
            var a3 = r3.length - 1, h = -1;
            for (n3 = t23.length - 1; n3 >= 0; --n3) {
              var c = t23.charCodeAt(n3);
              if (47 === c) {
                if (!s) {
                  i = n3 + 1;
                  break;
                }
              } else
                -1 === h && (s = false, h = n3 + 1), a3 >= 0 && (c === r3.charCodeAt(a3) ? -1 == --a3 && (o = n3) : (a3 = -1, o = h));
            }
            return i === o ? o = h : -1 === o && (o = t23.length), t23.slice(i, o);
          }
          for (n3 = t23.length - 1; n3 >= 0; --n3)
            if (47 === t23.charCodeAt(n3)) {
              if (!s) {
                i = n3 + 1;
                break;
              }
            } else
              -1 === o && (s = false, o = n3 + 1);
          return -1 === o ? "" : t23.slice(i, o);
        }, extname: function(t23) {
          e2(t23);
          for (var r3 = -1, n3 = 0, i = -1, o = true, s = 0, a3 = t23.length - 1; a3 >= 0; --a3) {
            var h = t23.charCodeAt(a3);
            if (47 !== h)
              -1 === i && (o = false, i = a3 + 1), 46 === h ? -1 === r3 ? r3 = a3 : 1 !== s && (s = 1) : -1 !== r3 && (s = -1);
            else if (!o) {
              n3 = a3 + 1;
              break;
            }
          }
          return -1 === r3 || -1 === i || 0 === s || 1 === s && r3 === i - 1 && r3 === n3 + 1 ? "" : t23.slice(r3, i);
        }, format: function(t23) {
          if (null === t23 || "object" != typeof t23)
            throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof t23);
          return function(t24, e3) {
            var r3 = e3.dir || e3.root, n3 = e3.base || (e3.name || "") + (e3.ext || "");
            return r3 ? r3 === e3.root ? r3 + n3 : r3 + "/" + n3 : n3;
          }(0, t23);
        }, parse: function(t23) {
          e2(t23);
          var r3 = { root: "", dir: "", base: "", ext: "", name: "" };
          if (0 === t23.length)
            return r3;
          var n3, i = t23.charCodeAt(0), o = 47 === i;
          o ? (r3.root = "/", n3 = 1) : n3 = 0;
          for (var s = -1, a3 = 0, h = -1, c = true, f3 = t23.length - 1, u = 0; f3 >= n3; --f3)
            if (47 !== (i = t23.charCodeAt(f3)))
              -1 === h && (c = false, h = f3 + 1), 46 === i ? -1 === s ? s = f3 : 1 !== u && (u = 1) : -1 !== s && (u = -1);
            else if (!c) {
              a3 = f3 + 1;
              break;
            }
          return -1 === s || -1 === h || 0 === u || 1 === u && s === h - 1 && s === a3 + 1 ? -1 !== h && (r3.base = r3.name = 0 === a3 && o ? t23.slice(1, h) : t23.slice(a3, h)) : (0 === a3 && o ? (r3.name = t23.slice(1, s), r3.base = t23.slice(1, h)) : (r3.name = t23.slice(a3, s), r3.base = t23.slice(a3, h)), r3.ext = t23.slice(s, h)), a3 > 0 ? r3.dir = t23.slice(0, a3 - 1) : o && (r3.dir = "/"), r3;
        }, sep: "/", delimiter: ":", win32: null, posix: null };
        n2.posix = n2, t22.exports = n2;
      }, 674: (t22, e2) => {
        if (Object.defineProperty(e2, "__esModule", { value: true }), e2.isWindows = void 0, "object" == typeof process)
          e2.isWindows = "win32" === process.platform;
        else if ("object" == typeof navigator) {
          let t23 = navigator.userAgent;
          e2.isWindows = t23.indexOf("Windows") >= 0;
        }
      }, 796: (t22, e2, r2) => {
        Object.defineProperty(e2, "__esModule", { value: true }), e2.uriToFsPath = e2.URI = void 0;
        const n2 = r2(674), i = /^\w[\w\d+.-]*$/, o = /^\//, s = /^\/\//;
        function a3(t23, e3) {
          if (!t23.scheme && e3)
            throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t23.authority}", path: "${t23.path}", query: "${t23.query}", fragment: "${t23.fragment}"}`);
          if (t23.scheme && !i.test(t23.scheme))
            throw new Error("[UriError]: Scheme contains illegal characters.");
          if (t23.path) {
            if (t23.authority) {
              if (!o.test(t23.path))
                throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
            } else if (s.test(t23.path))
              throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
          }
        }
        const h = "", c = "/", f3 = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
        class u {
          constructor(t23, e3, r3, n3, i2, o2 = false) {
            __publicField(this, "scheme");
            __publicField(this, "authority");
            __publicField(this, "path");
            __publicField(this, "query");
            __publicField(this, "fragment");
            "object" == typeof t23 ? (this.scheme = t23.scheme || h, this.authority = t23.authority || h, this.path = t23.path || h, this.query = t23.query || h, this.fragment = t23.fragment || h) : (this.scheme = /* @__PURE__ */ function(t24, e4) {
              return t24 || e4 ? t24 : "file";
            }(t23, o2), this.authority = e3 || h, this.path = function(t24, e4) {
              switch (t24) {
                case "https":
                case "http":
                case "file":
                  e4 ? e4[0] !== c && (e4 = c + e4) : e4 = c;
              }
              return e4;
            }(this.scheme, r3 || h), this.query = n3 || h, this.fragment = i2 || h, a3(this, o2));
          }
          static isUri(t23) {
            return t23 instanceof u || !!t23 && "string" == typeof t23.authority && "string" == typeof t23.fragment && "string" == typeof t23.path && "string" == typeof t23.query && "string" == typeof t23.scheme && "string" == typeof t23.fsPath && "function" == typeof t23.with && "function" == typeof t23.toString;
          }
          get fsPath() {
            return v(this, false);
          }
          with(t23) {
            if (!t23)
              return this;
            let { scheme: e3, authority: r3, path: n3, query: i2, fragment: o2 } = t23;
            return void 0 === e3 ? e3 = this.scheme : null === e3 && (e3 = h), void 0 === r3 ? r3 = this.authority : null === r3 && (r3 = h), void 0 === n3 ? n3 = this.path : null === n3 && (n3 = h), void 0 === i2 ? i2 = this.query : null === i2 && (i2 = h), void 0 === o2 ? o2 = this.fragment : null === o2 && (o2 = h), e3 === this.scheme && r3 === this.authority && n3 === this.path && i2 === this.query && o2 === this.fragment ? this : new d(e3, r3, n3, i2, o2);
          }
          static parse(t23, e3 = false) {
            const r3 = f3.exec(t23);
            return r3 ? new d(r3[2] || h, w(r3[4] || h), w(r3[5] || h), w(r3[7] || h), w(r3[9] || h), e3) : new d(h, h, h, h, h);
          }
          static file(t23) {
            let e3 = h;
            if (n2.isWindows && (t23 = t23.replace(/\\/g, c)), t23[0] === c && t23[1] === c) {
              const r3 = t23.indexOf(c, 2);
              -1 === r3 ? (e3 = t23.substring(2), t23 = c) : (e3 = t23.substring(2, r3), t23 = t23.substring(r3) || c);
            }
            return new d("file", e3, t23, h, h);
          }
          static from(t23) {
            const e3 = new d(t23.scheme, t23.authority, t23.path, t23.query, t23.fragment);
            return a3(e3, true), e3;
          }
          toString(t23 = false) {
            return y(this, t23);
          }
          toJSON() {
            return this;
          }
          static revive(t23) {
            if (t23) {
              if (t23 instanceof u)
                return t23;
              {
                const e3 = new d(t23);
                return e3._formatted = t23.external, e3._fsPath = t23._sep === l ? t23.fsPath : null, e3;
              }
            }
            return t23;
          }
        }
        e2.URI = u;
        const l = n2.isWindows ? 1 : void 0;
        class d extends u {
          constructor() {
            super(...arguments);
            __publicField(this, "_formatted", null);
            __publicField(this, "_fsPath", null);
          }
          get fsPath() {
            return this._fsPath || (this._fsPath = v(this, false)), this._fsPath;
          }
          toString(t23 = false) {
            return t23 ? y(this, true) : (this._formatted || (this._formatted = y(this, false)), this._formatted);
          }
          toJSON() {
            const t23 = { $mid: 1 };
            return this._fsPath && (t23.fsPath = this._fsPath, t23._sep = l), this._formatted && (t23.external = this._formatted), this.path && (t23.path = this.path), this.scheme && (t23.scheme = this.scheme), this.authority && (t23.authority = this.authority), this.query && (t23.query = this.query), this.fragment && (t23.fragment = this.fragment), t23;
          }
        }
        const p = { 58: "%3A", 47: "%2F", 63: "%3F", 35: "%23", 91: "%5B", 93: "%5D", 64: "%40", 33: "%21", 36: "%24", 38: "%26", 39: "%27", 40: "%28", 41: "%29", 42: "%2A", 43: "%2B", 44: "%2C", 59: "%3B", 61: "%3D", 32: "%20" };
        function g(t23, e3, r3) {
          let n3, i2 = -1;
          for (let o2 = 0; o2 < t23.length; o2++) {
            const s2 = t23.charCodeAt(o2);
            if (s2 >= 97 && s2 <= 122 || s2 >= 65 && s2 <= 90 || s2 >= 48 && s2 <= 57 || 45 === s2 || 46 === s2 || 95 === s2 || 126 === s2 || e3 && 47 === s2 || r3 && 91 === s2 || r3 && 93 === s2 || r3 && 58 === s2)
              -1 !== i2 && (n3 += encodeURIComponent(t23.substring(i2, o2)), i2 = -1), void 0 !== n3 && (n3 += t23.charAt(o2));
            else {
              void 0 === n3 && (n3 = t23.substr(0, o2));
              const e4 = p[s2];
              void 0 !== e4 ? (-1 !== i2 && (n3 += encodeURIComponent(t23.substring(i2, o2)), i2 = -1), n3 += e4) : -1 === i2 && (i2 = o2);
            }
          }
          return -1 !== i2 && (n3 += encodeURIComponent(t23.substring(i2))), void 0 !== n3 ? n3 : t23;
        }
        function m(t23) {
          let e3;
          for (let r3 = 0; r3 < t23.length; r3++) {
            const n3 = t23.charCodeAt(r3);
            35 === n3 || 63 === n3 ? (void 0 === e3 && (e3 = t23.substr(0, r3)), e3 += p[n3]) : void 0 !== e3 && (e3 += t23[r3]);
          }
          return void 0 !== e3 ? e3 : t23;
        }
        function v(t23, e3) {
          let r3;
          return r3 = t23.authority && t23.path.length > 1 && "file" === t23.scheme ? `//${t23.authority}${t23.path}` : 47 === t23.path.charCodeAt(0) && (t23.path.charCodeAt(1) >= 65 && t23.path.charCodeAt(1) <= 90 || t23.path.charCodeAt(1) >= 97 && t23.path.charCodeAt(1) <= 122) && 58 === t23.path.charCodeAt(2) ? e3 ? t23.path.substr(1) : t23.path[1].toLowerCase() + t23.path.substr(2) : t23.path, n2.isWindows && (r3 = r3.replace(/\//g, "\\")), r3;
        }
        function y(t23, e3) {
          const r3 = e3 ? m : g;
          let n3 = "", { scheme: i2, authority: o2, path: s2, query: a4, fragment: h2 } = t23;
          if (i2 && (n3 += i2, n3 += ":"), (o2 || "file" === i2) && (n3 += c, n3 += c), o2) {
            let t24 = o2.indexOf("@");
            if (-1 !== t24) {
              const e4 = o2.substr(0, t24);
              o2 = o2.substr(t24 + 1), t24 = e4.lastIndexOf(":"), -1 === t24 ? n3 += r3(e4, false, false) : (n3 += r3(e4.substr(0, t24), false, false), n3 += ":", n3 += r3(e4.substr(t24 + 1), false, true)), n3 += "@";
            }
            o2 = o2.toLowerCase(), t24 = o2.lastIndexOf(":"), -1 === t24 ? n3 += r3(o2, false, true) : (n3 += r3(o2.substr(0, t24), false, true), n3 += o2.substr(t24));
          }
          if (s2) {
            if (s2.length >= 3 && 47 === s2.charCodeAt(0) && 58 === s2.charCodeAt(2)) {
              const t24 = s2.charCodeAt(1);
              t24 >= 65 && t24 <= 90 && (s2 = `/${String.fromCharCode(t24 + 32)}:${s2.substr(3)}`);
            } else if (s2.length >= 2 && 58 === s2.charCodeAt(1)) {
              const t24 = s2.charCodeAt(0);
              t24 >= 65 && t24 <= 90 && (s2 = `${String.fromCharCode(t24 + 32)}:${s2.substr(2)}`);
            }
            n3 += r3(s2, true, false);
          }
          return a4 && (n3 += "?", n3 += r3(a4, false, false)), h2 && (n3 += "#", n3 += e3 ? h2 : g(h2, false, false)), n3;
        }
        function b(t23) {
          try {
            return decodeURIComponent(t23);
          } catch (e3) {
            return t23.length > 3 ? t23.substr(0, 3) + b(t23.substr(3)) : t23;
          }
        }
        e2.uriToFsPath = v;
        const C = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
        function w(t23) {
          return t23.match(C) ? t23.replace(C, (t24) => b(t24)) : t23;
        }
      }, 679: function(t22, e2, r2) {
        var n2 = this && this.__createBinding || (Object.create ? function(t23, e3, r3, n3) {
          void 0 === n3 && (n3 = r3);
          var i2 = Object.getOwnPropertyDescriptor(e3, r3);
          i2 && !("get" in i2 ? !e3.__esModule : i2.writable || i2.configurable) || (i2 = { enumerable: true, get: function() {
            return e3[r3];
          } }), Object.defineProperty(t23, n3, i2);
        } : function(t23, e3, r3, n3) {
          void 0 === n3 && (n3 = r3), t23[n3] = e3[r3];
        }), i = this && this.__setModuleDefault || (Object.create ? function(t23, e3) {
          Object.defineProperty(t23, "default", { enumerable: true, value: e3 });
        } : function(t23, e3) {
          t23.default = e3;
        }), o = this && this.__importStar || function(t23) {
          if (t23 && t23.__esModule)
            return t23;
          var e3 = {};
          if (null != t23)
            for (var r3 in t23)
              "default" !== r3 && Object.prototype.hasOwnProperty.call(t23, r3) && n2(e3, t23, r3);
          return i(e3, t23), e3;
        };
        Object.defineProperty(e2, "__esModule", { value: true }), e2.Utils = void 0;
        const s = o(r2(470)), a3 = s.posix || s, h = "/";
        var c;
        !function(t23) {
          t23.joinPath = function(t24, ...e3) {
            return t24.with({ path: a3.join(t24.path, ...e3) });
          }, t23.resolvePath = function(t24, ...e3) {
            let r3 = t24.path, n3 = false;
            r3[0] !== h && (r3 = h + r3, n3 = true);
            let i2 = a3.resolve(r3, ...e3);
            return n3 && i2[0] === h && !t24.authority && (i2 = i2.substring(1)), t24.with({ path: i2 });
          }, t23.dirname = function(t24) {
            if (0 === t24.path.length || t24.path === h)
              return t24;
            let e3 = a3.dirname(t24.path);
            return 1 === e3.length && 46 === e3.charCodeAt(0) && (e3 = ""), t24.with({ path: e3 });
          }, t23.basename = function(t24) {
            return a3.basename(t24.path);
          }, t23.extname = function(t24) {
            return a3.extname(t24.path);
          };
        }(c || (e2.Utils = c = {}));
      } }, e = {};
      function r(n2) {
        var i = e[n2];
        if (void 0 !== i)
          return i.exports;
        var o = e[n2] = { exports: {} };
        return t21[n2].call(o.exports, o, o.exports, r), o.exports;
      }
      var n = {};
      return (() => {
        var t22 = n;
        Object.defineProperty(t22, "__esModule", { value: true }), t22.Utils = t22.URI = void 0;
        const e2 = r(796);
        Object.defineProperty(t22, "URI", { enumerable: true, get: function() {
          return e2.URI;
        } });
        const i = r(679);
        Object.defineProperty(t22, "Utils", { enumerable: true, get: function() {
          return i.Utils;
        } });
      })(), n;
    })());
  }
});

// node_modules/request-light/lib/node/main.js
var require_main5 = __commonJS({
  "node_modules/request-light/lib/node/main.js"(exports2) {
    "use strict";
    (() => {
      var e = { 46: (e2, t22) => {
        "use strict";
        Object.defineProperty(t22, "__esModule", { value: true }), t22.default = function(e3, t23, { signal: r2 } = {}) {
          return new Promise((o2, n2) => {
            function s() {
              null == r2 || r2.removeEventListener("abort", s), e3.removeListener(t23, a3), e3.removeListener("error", u);
            }
            function a3(...e4) {
              s(), o2(e4);
            }
            function u(e4) {
              s(), n2(e4);
            }
            null == r2 || r2.addEventListener("abort", s), e3.on(t23, a3), e3.on("error", u);
          });
        };
      }, 54: function(e2, t22, r2) {
        "use strict";
        var o2 = this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        };
        const n2 = r2(361), s = o2(r2(374)), a3 = o2(r2(304)), u = s.default("agent-base");
        function i() {
          const { stack: e3 } = new Error();
          return "string" == typeof e3 && e3.split("\n").some((e4) => -1 !== e4.indexOf("(https.js:") || -1 !== e4.indexOf("node:https:"));
        }
        function c(e3, t23) {
          return new c.Agent(e3, t23);
        }
        !function(e3) {
          class t23 extends n2.EventEmitter {
            constructor(e4, t24) {
              super();
              let r3 = t24;
              "function" == typeof e4 ? this.callback = e4 : e4 && (r3 = e4), this.timeout = null, r3 && "number" == typeof r3.timeout && (this.timeout = r3.timeout), this.maxFreeSockets = 1, this.maxSockets = 1, this.maxTotalSockets = 1 / 0, this.sockets = {}, this.freeSockets = {}, this.requests = {}, this.options = {};
            }
            get defaultPort() {
              return "number" == typeof this.explicitDefaultPort ? this.explicitDefaultPort : i() ? 443 : 80;
            }
            set defaultPort(e4) {
              this.explicitDefaultPort = e4;
            }
            get protocol() {
              return "string" == typeof this.explicitProtocol ? this.explicitProtocol : i() ? "https:" : "http:";
            }
            set protocol(e4) {
              this.explicitProtocol = e4;
            }
            callback(e4, t24, r3) {
              throw new Error('"agent-base" has no default implementation, you must subclass and override `callback()`');
            }
            addRequest(e4, t24) {
              const r3 = Object.assign({}, t24);
              "boolean" != typeof r3.secureEndpoint && (r3.secureEndpoint = i()), null == r3.host && (r3.host = "localhost"), null == r3.port && (r3.port = r3.secureEndpoint ? 443 : 80), null == r3.protocol && (r3.protocol = r3.secureEndpoint ? "https:" : "http:"), r3.host && r3.path && delete r3.path, delete r3.agent, delete r3.hostname, delete r3._defaultAgent, delete r3.defaultPort, delete r3.createConnection, e4._last = true, e4.shouldKeepAlive = false;
              let o3 = false, n3 = null;
              const s2 = r3.timeout || this.timeout, c2 = (t25) => {
                e4._hadError || (e4.emit("error", t25), e4._hadError = true);
              }, l = () => {
                n3 = null, o3 = true;
                const e5 = new Error(`A "socket" was not created for HTTP request before ${s2}ms`);
                e5.code = "ETIMEOUT", c2(e5);
              }, d = (e5) => {
                o3 || (null !== n3 && (clearTimeout(n3), n3 = null), c2(e5));
              }, f3 = (t25) => {
                if (o3)
                  return;
                if (null != n3 && (clearTimeout(n3), n3 = null), s3 = t25, Boolean(s3) && "function" == typeof s3.addRequest)
                  return u("Callback returned another Agent instance %o", t25.constructor.name), void t25.addRequest(e4, r3);
                var s3;
                if (t25)
                  return t25.once("free", () => {
                    this.freeSocket(t25, r3);
                  }), void e4.onSocket(t25);
                const a4 = new Error(`no Duplex stream was returned to agent-base for \`${e4.method} ${e4.path}\``);
                c2(a4);
              };
              if ("function" == typeof this.callback) {
                this.promisifiedCallback || (this.callback.length >= 3 ? (u("Converting legacy callback function to promise"), this.promisifiedCallback = a3.default(this.callback)) : this.promisifiedCallback = this.callback), "number" == typeof s2 && s2 > 0 && (n3 = setTimeout(l, s2)), "port" in r3 && "number" != typeof r3.port && (r3.port = Number(r3.port));
                try {
                  u("Resolving socket for %o request: %o", r3.protocol, `${e4.method} ${e4.path}`), Promise.resolve(this.promisifiedCallback(e4, r3)).then(f3, d);
                } catch (e5) {
                  Promise.reject(e5).catch(d);
                }
              } else
                c2(new Error("`callback` is not defined"));
            }
            freeSocket(e4, t24) {
              u("Freeing socket %o %o", e4.constructor.name, t24), e4.destroy();
            }
            destroy() {
              u("Destroying agent %o", this.constructor.name);
            }
          }
          e3.Agent = t23, e3.prototype = e3.Agent.prototype;
        }(c || (c = {})), e2.exports = c;
      }, 304: (e2, t22) => {
        "use strict";
        Object.defineProperty(t22, "__esModule", { value: true }), t22.default = function(e3) {
          return function(t23, r2) {
            return new Promise((o2, n2) => {
              e3.call(this, t23, r2, (e4, t24) => {
                e4 ? n2(e4) : o2(t24);
              });
            });
          };
        };
      }, 370: function(e2, t22, r2) {
        "use strict";
        var o2 = this && this.__awaiter || function(e3, t23, r3, o3) {
          return new (r3 || (r3 = Promise))(function(n3, s2) {
            function a4(e4) {
              try {
                i2(o3.next(e4));
              } catch (e5) {
                s2(e5);
              }
            }
            function u2(e4) {
              try {
                i2(o3.throw(e4));
              } catch (e5) {
                s2(e5);
              }
            }
            function i2(e4) {
              var t24;
              e4.done ? n3(e4.value) : (t24 = e4.value, t24 instanceof r3 ? t24 : new r3(function(e5) {
                e5(t24);
              })).then(a4, u2);
            }
            i2((o3 = o3.apply(e3, t23 || [])).next());
          });
        }, n2 = this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        };
        Object.defineProperty(t22, "__esModule", { value: true });
        const s = n2(r2(808)), a3 = n2(r2(404)), u = n2(r2(310)), i = n2(r2(374)), c = n2(r2(46)), l = r2(54), d = (0, i.default)("http-proxy-agent");
        class f3 extends l.Agent {
          constructor(e3) {
            let t23;
            if (t23 = "string" == typeof e3 ? u.default.parse(e3) : e3, !t23)
              throw new Error("an HTTP(S) proxy server `host` and `port` must be specified!");
            d("Creating new HttpProxyAgent instance: %o", t23), super(t23);
            const r3 = Object.assign({}, t23);
            var o3;
            this.secureProxy = t23.secureProxy || "string" == typeof (o3 = r3.protocol) && /^https:?$/i.test(o3), r3.host = r3.hostname || r3.host, "string" == typeof r3.port && (r3.port = parseInt(r3.port, 10)), !r3.port && r3.host && (r3.port = this.secureProxy ? 443 : 80), r3.host && r3.path && (delete r3.path, delete r3.pathname), this.proxy = r3;
          }
          callback(e3, t23) {
            return o2(this, void 0, void 0, function* () {
              const { proxy: r3, secureProxy: o3 } = this, n3 = u.default.parse(e3.path);
              let i2;
              if (n3.protocol || (n3.protocol = "http:"), n3.hostname || (n3.hostname = t23.hostname || t23.host || null), null == n3.port && (t23.port, 1) && (n3.port = String(t23.port)), "80" === n3.port && (n3.port = ""), e3.path = u.default.format(n3), r3.auth && e3.setHeader("Proxy-Authorization", `Basic ${Buffer.from(r3.auth).toString("base64")}`), o3 ? (d("Creating `tls.Socket`: %o", r3), i2 = a3.default.connect(r3)) : (d("Creating `net.Socket`: %o", r3), i2 = s.default.connect(r3)), e3._header) {
                let t24, r4;
                d("Regenerating stored HTTP header string for request"), e3._header = null, e3._implicitHeader(), e3.output && e3.output.length > 0 ? (d("Patching connection write() output buffer with updated header"), t24 = e3.output[0], r4 = t24.indexOf("\r\n\r\n") + 4, e3.output[0] = e3._header + t24.substring(r4), d("Output buffer: %o", e3.output)) : e3.outputData && e3.outputData.length > 0 && (d("Patching connection write() output buffer with updated header"), t24 = e3.outputData[0].data, r4 = t24.indexOf("\r\n\r\n") + 4, e3.outputData[0].data = e3._header + t24.substring(r4), d("Output buffer: %o", e3.outputData[0].data));
              }
              return yield (0, c.default)(i2, "connect"), i2;
            });
          }
        }
        t22.default = f3;
      }, 201: function(e2, t22, r2) {
        "use strict";
        const o2 = (this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        })(r2(370));
        function n2(e3) {
          return new o2.default(e3);
        }
        !function(e3) {
          e3.HttpProxyAgent = o2.default, e3.prototype = o2.default.prototype;
        }(n2 || (n2 = {})), e2.exports = n2;
      }, 146: function(e2, t22, r2) {
        "use strict";
        var o2 = this && this.__awaiter || function(e3, t23, r3, o3) {
          return new (r3 || (r3 = Promise))(function(n3, s2) {
            function a4(e4) {
              try {
                i2(o3.next(e4));
              } catch (e5) {
                s2(e5);
              }
            }
            function u2(e4) {
              try {
                i2(o3.throw(e4));
              } catch (e5) {
                s2(e5);
              }
            }
            function i2(e4) {
              var t24;
              e4.done ? n3(e4.value) : (t24 = e4.value, t24 instanceof r3 ? t24 : new r3(function(e5) {
                e5(t24);
              })).then(a4, u2);
            }
            i2((o3 = o3.apply(e3, t23 || [])).next());
          });
        }, n2 = this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        };
        Object.defineProperty(t22, "__esModule", { value: true });
        const s = n2(r2(808)), a3 = n2(r2(404)), u = n2(r2(310)), i = n2(r2(491)), c = n2(r2(374)), l = r2(54), d = n2(r2(829)), f3 = c.default("https-proxy-agent:agent");
        class p extends l.Agent {
          constructor(e3) {
            let t23;
            if (t23 = "string" == typeof e3 ? u.default.parse(e3) : e3, !t23)
              throw new Error("an HTTP(S) proxy server `host` and `port` must be specified!");
            f3("creating new HttpsProxyAgent instance: %o", t23), super(t23);
            const r3 = Object.assign({}, t23);
            var o3;
            this.secureProxy = t23.secureProxy || "string" == typeof (o3 = r3.protocol) && /^https:?$/i.test(o3), r3.host = r3.hostname || r3.host, "string" == typeof r3.port && (r3.port = parseInt(r3.port, 10)), !r3.port && r3.host && (r3.port = this.secureProxy ? 443 : 80), this.secureProxy && !("ALPNProtocols" in r3) && (r3.ALPNProtocols = ["http 1.1"]), r3.host && r3.path && (delete r3.path, delete r3.pathname), this.proxy = r3;
          }
          callback(e3, t23) {
            return o2(this, void 0, void 0, function* () {
              const { proxy: r3, secureProxy: o3 } = this;
              let n3;
              o3 ? (f3("Creating `tls.Socket`: %o", r3), n3 = a3.default.connect(r3)) : (f3("Creating `net.Socket`: %o", r3), n3 = s.default.connect(r3));
              const u2 = Object.assign({}, r3.headers);
              let c2 = `CONNECT ${t23.host}:${t23.port} HTTP/1.1\r
`;
              r3.auth && (u2["Proxy-Authorization"] = `Basic ${Buffer.from(r3.auth).toString("base64")}`);
              let { host: l2, port: p2, secureEndpoint: g } = t23;
              (function(e4, t24) {
                return Boolean(!t24 && 80 === e4 || t24 && 443 === e4);
              })(p2, g) || (l2 += `:${p2}`), u2.Host = l2, u2.Connection = "close";
              for (const e4 of Object.keys(u2))
                c2 += `${e4}: ${u2[e4]}\r
`;
              const v = d.default(n3);
              n3.write(`${c2}\r
`);
              const { statusCode: m, buffered: y } = yield v;
              if (200 === m) {
                if (e3.once("socket", h), t23.secureEndpoint) {
                  f3("Upgrading socket connection to TLS");
                  const e4 = t23.servername || t23.host;
                  return a3.default.connect(Object.assign(Object.assign({}, function(e5, ...t24) {
                    const r4 = {};
                    let o4;
                    for (o4 in e5)
                      t24.includes(o4) || (r4[o4] = e5[o4]);
                    return r4;
                  }(t23, "host", "hostname", "path", "port")), { socket: n3, servername: e4 }));
                }
                return n3;
              }
              n3.destroy();
              const b = new s.default.Socket({ writable: false });
              return b.readable = true, e3.once("socket", (e4) => {
                f3("replaying proxy buffer for failed request"), i.default(e4.listenerCount("data") > 0), e4.push(y), e4.push(null);
              }), b;
            });
          }
        }
        function h(e3) {
          e3.resume();
        }
        t22.default = p;
      }, 18: function(e2, t22, r2) {
        "use strict";
        const o2 = (this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        })(r2(146));
        function n2(e3) {
          return new o2.default(e3);
        }
        !function(e3) {
          e3.HttpsProxyAgent = o2.default, e3.prototype = o2.default.prototype;
        }(n2 || (n2 = {})), e2.exports = n2;
      }, 829: function(e2, t22, r2) {
        "use strict";
        var o2 = this && this.__importDefault || function(e3) {
          return e3 && e3.__esModule ? e3 : { default: e3 };
        };
        Object.defineProperty(t22, "__esModule", { value: true });
        const n2 = o2(r2(374)).default("https-proxy-agent:parse-proxy-response");
        t22.default = function(e3) {
          return new Promise((t23, r3) => {
            let o3 = 0;
            const s = [];
            function a3() {
              const r4 = e3.read();
              r4 ? function(e4) {
                s.push(e4), o3 += e4.length;
                const r5 = Buffer.concat(s, o3);
                if (-1 === r5.indexOf("\r\n\r\n"))
                  return n2("have not received end of HTTP headers yet..."), void a3();
                const u2 = r5.toString("ascii", 0, r5.indexOf("\r\n")), i2 = +u2.split(" ")[1];
                n2("got proxy server response: %o", u2), t23({ statusCode: i2, buffered: r5 });
              }(r4) : e3.once("readable", a3);
            }
            function u(e4) {
              n2("onclose had error %o", e4);
            }
            function i() {
              n2("onend");
            }
            e3.on("error", function t24(o4) {
              e3.removeListener("end", i), e3.removeListener("error", t24), e3.removeListener("close", u), e3.removeListener("readable", a3), n2("onerror %o", o4), r3(o4);
            }), e3.on("close", u), e3.on("end", i), a3();
          });
        };
      }, 539: function(e2, t22, r2) {
        "use strict";
        var o2, n2 = this && this.__extends || (o2 = function(e3, t23) {
          return o2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(e4, t24) {
            e4.__proto__ = t24;
          } || function(e4, t24) {
            for (var r3 in t24)
              Object.prototype.hasOwnProperty.call(t24, r3) && (e4[r3] = t24[r3]);
          }, o2(e3, t23);
        }, function(e3, t23) {
          if ("function" != typeof t23 && null !== t23)
            throw new TypeError("Class extends value " + String(t23) + " is not a constructor or null");
          function r3() {
            this.constructor = e3;
          }
          o2(e3, t23), e3.prototype = null === t23 ? Object.create(t23) : (r3.prototype = t23.prototype, new r3());
        }), s = this && this.__assign || function() {
          return s = Object.assign || function(e3) {
            for (var t23, r3 = 1, o3 = arguments.length; r3 < o3; r3++)
              for (var n3 in t23 = arguments[r3])
                Object.prototype.hasOwnProperty.call(t23, n3) && (e3[n3] = t23[n3]);
            return e3;
          }, s.apply(this, arguments);
        };
        Object.defineProperty(t22, "__esModule", { value: true }), t22.getErrorStatusDescription = t22.xhr = t22.configure = void 0;
        var a3 = r2(685), u = r2(687), i = r2(310), c = r2(472), l = r2(796), d = r2(201), f3 = r2(18);
        if (process.env.VSCODE_NLS_CONFIG) {
          var p = process.env.VSCODE_NLS_CONFIG;
          c.config(JSON.parse(p));
        }
        var h = c.loadMessageBundle(), g = void 0, v = true;
        function m(e3) {
          var t23;
          return new Promise(function(r3, o3) {
            var n3 = (0, i.parse)(e3.url), s2 = { hostname: n3.hostname, agent: !!e3.agent && e3.agent, port: n3.port ? parseInt(n3.port) : "https:" === n3.protocol ? 443 : 80, path: n3.path, method: e3.type || "GET", headers: e3.headers, rejectUnauthorized: "boolean" != typeof e3.strictSSL || e3.strictSSL };
            e3.user && e3.password && (s2.auth = e3.user + ":" + e3.password);
            var c2 = function(o4) {
              if (o4.statusCode >= 300 && o4.statusCode < 400 && e3.followRedirects && e3.followRedirects > 0 && o4.headers.location) {
                var s3 = o4.headers.location;
                s3.startsWith("/") && (s3 = (0, i.format)({ protocol: n3.protocol, hostname: n3.hostname, port: n3.port, pathname: s3 })), r3(m(function(e4) {
                  for (var t24 = [], r4 = 1; r4 < arguments.length; r4++)
                    t24[r4 - 1] = arguments[r4];
                  return t24.forEach(function(t25) {
                    return Object.keys(t25).forEach(function(r5) {
                      return e4[r5] = t25[r5];
                    });
                  }), e4;
                }({}, e3, { url: s3, followRedirects: e3.followRedirects - 1 })));
              } else
                r3({ req: t23, res: o4 });
            };
            (t23 = "https:" === n3.protocol ? u.request(s2, c2) : a3.request(s2, c2)).on("error", o3), e3.timeout && t23.setTimeout(e3.timeout), e3.data && t23.write(e3.data), t23.end(), e3.token && (e3.token.isCancellationRequested && t23.destroy(new y()), e3.token.onCancellationRequested(function() {
              t23.destroy(new y());
            }));
          });
        }
        t22.configure = function(e3, t23) {
          g = e3, v = t23;
        }, t22.xhr = function(e3) {
          return "boolean" != typeof (e3 = s({}, e3)).strictSSL && (e3.strictSSL = v), e3.agent || (e3.agent = function(e4, t23) {
            void 0 === t23 && (t23 = {});
            var r3 = (0, i.parse)(e4), o3 = t23.proxyUrl || function(e5) {
              return "http:" === e5.protocol ? process.env.HTTP_PROXY || process.env.http_proxy || null : "https:" === e5.protocol && (process.env.HTTPS_PROXY || process.env.https_proxy || process.env.HTTP_PROXY || process.env.http_proxy) || null;
            }(r3);
            if (!o3)
              return null;
            var n3 = (0, i.parse)(o3);
            if (!/^https?:$/.test(n3.protocol))
              return null;
            var s2 = { host: n3.hostname, port: Number(n3.port), auth: n3.auth, rejectUnauthorized: "boolean" != typeof t23.strictSSL || t23.strictSSL, protocol: n3.protocol };
            return "http:" === r3.protocol ? d(s2) : f3(s2);
          }(e3.url, { proxyUrl: g, strictSSL: v })), "number" != typeof e3.followRedirects && (e3.followRedirects = 5), m(e3).then(function(r3) {
            return new Promise(function(o3, n3) {
              var s2, a4, u2 = r3.res, c2 = u2, d2 = false, f4 = u2.headers && u2.headers["content-encoding"];
              if (f4 && (s2 = e3.type, a4 = r3.res.statusCode, !("HEAD" === s2 || a4 >= 100 && a4 < 200 || 204 === a4 || 304 === a4))) {
                var p2 = { flush: l.constants.Z_SYNC_FLUSH, finishFlush: l.constants.Z_SYNC_FLUSH };
                if ("gzip" === f4) {
                  var g2 = l.createGunzip(p2);
                  u2.pipe(g2), c2 = g2;
                } else if ("deflate" === f4) {
                  var v2 = l.createInflate(p2);
                  u2.pipe(v2), c2 = v2;
                }
              }
              var m2 = [];
              c2.on("data", function(e4) {
                return m2.push(e4);
              }), c2.on("end", function() {
                if (!d2) {
                  if (d2 = true, e3.followRedirects > 0 && (u2.statusCode >= 300 && u2.statusCode <= 303 || 307 === u2.statusCode)) {
                    var r4 = u2.headers.location;
                    if (r4.startsWith("/")) {
                      var s3 = (0, i.parse)(e3.url);
                      r4 = (0, i.format)({ protocol: s3.protocol, hostname: s3.hostname, port: s3.port, pathname: r4 });
                    }
                    if (r4) {
                      var a5 = { type: e3.type, url: r4, user: e3.user, password: e3.password, headers: e3.headers, timeout: e3.timeout, followRedirects: e3.followRedirects - 1, data: e3.data, token: e3.token };
                      return void (0, t22.xhr)(a5).then(o3, n3);
                    }
                  }
                  var c3 = Buffer.concat(m2), l2 = { responseText: c3.toString(), body: c3, status: u2.statusCode, headers: u2.headers || {} };
                  u2.statusCode >= 200 && u2.statusCode < 300 || 1223 === u2.statusCode ? o3(l2) : n3(l2);
                }
              }), c2.on("error", function(t23) {
                var r4;
                r4 = y.is(t23) ? t23 : { responseText: h("error", "Unable to access {0}. Error: {1}", e3.url, t23.message), body: Buffer.concat(m2), status: 500, headers: {} }, d2 = true, n3(r4);
              }), e3.token && (e3.token.isCancellationRequested && c2.destroy(new y()), e3.token.onCancellationRequested(function() {
                c2.destroy(new y());
              }));
            });
          }, function(t23) {
            var r3;
            return r3 = y.is(t23) ? t23 : { responseText: e3.agent ? h("error.cannot.connect.proxy", "Unable to connect to {0} through a proxy. Error: {1}", e3.url, t23.message) : h("error.cannot.connect", "Unable to connect to {0}. Error: {1}", e3.url, t23.message), body: Buffer.concat([]), status: 404, headers: {} }, Promise.reject(r3);
          });
        }, t22.getErrorStatusDescription = function(e3) {
          if (!(e3 < 400))
            switch (e3) {
              case 400:
                return h("status.400", "Bad request. The request cannot be fulfilled due to bad syntax.");
              case 401:
                return h("status.401", "Unauthorized. The server is refusing to respond.");
              case 403:
                return h("status.403", "Forbidden. The server is refusing to respond.");
              case 404:
                return h("status.404", "Not Found. The requested location could not be found.");
              case 405:
                return h("status.405", "Method not allowed. A request was made using a request method not supported by that location.");
              case 406:
                return h("status.406", "Not Acceptable. The server can only generate a response that is not accepted by the client.");
              case 407:
                return h("status.407", "Proxy Authentication Required. The client must first authenticate itself with the proxy.");
              case 408:
                return h("status.408", "Request Timeout. The server timed out waiting for the request.");
              case 409:
                return h("status.409", "Conflict. The request could not be completed because of a conflict in the request.");
              case 410:
                return h("status.410", "Gone. The requested page is no longer available.");
              case 411:
                return h("status.411", 'Length Required. The "Content-Length" is not defined.');
              case 412:
                return h("status.412", "Precondition Failed. The precondition given in the request evaluated to false by the server.");
              case 413:
                return h("status.413", "Request Entity Too Large. The server will not accept the request, because the request entity is too large.");
              case 414:
                return h("status.414", "Request-URI Too Long. The server will not accept the request, because the URL is too long.");
              case 415:
                return h("status.415", "Unsupported Media Type. The server will not accept the request, because the media type is not supported.");
              case 500:
                return h("status.500", "Internal Server Error.");
              case 501:
                return h("status.501", "Not Implemented. The server either does not recognize the request method, or it lacks the ability to fulfill the request.");
              case 502:
                return h("status.502", "Bad Gateway. The upstream server did not respond.");
              case 503:
                return h("status.503", "Service Unavailable. The server is currently unavailable (overloaded or down).");
              default:
                return h("status.416", "HTTP status code {0}", e3);
            }
        };
        var y = function(e3) {
          function t23() {
            var r3 = e3.call(this, "The user aborted a request") || this;
            return r3.name = "AbortError", Object.setPrototypeOf(r3, t23.prototype), r3;
          }
          return n2(t23, e3), t23.is = function(e4) {
            return e4 instanceof t23;
          }, t23;
        }(Error);
      }, 800: (e2, t22, r2) => {
        "use strict";
        Object.defineProperty(t22, "__esModule", { value: true }), t22.config = t22.loadMessageBundle = t22.localize = t22.format = t22.setPseudo = t22.isPseudo = t22.isDefined = t22.BundleFormat = t22.MessageFormat = void 0;
        var o2, n2, s, a3 = r2(926);
        function u(e3) {
          return void 0 !== e3;
        }
        function i(e3, r3) {
          return t22.isPseudo && (e3 = "\uFF3B" + e3.replace(/[aouei]/g, "$&$&") + "\uFF3D"), 0 === r3.length ? e3 : e3.replace(/\{(\d+)\}/g, function(e4, t23) {
            var o3 = t23[0], n3 = r3[o3], s2 = e4;
            return "string" == typeof n3 ? s2 = n3 : "number" != typeof n3 && "boolean" != typeof n3 && null != n3 || (s2 = String(n3)), s2;
          });
        }
        (s = t22.MessageFormat || (t22.MessageFormat = {})).file = "file", s.bundle = "bundle", s.both = "both", (n2 = t22.BundleFormat || (t22.BundleFormat = {})).standalone = "standalone", n2.languagePack = "languagePack", function(e3) {
          e3.is = function(e4) {
            var t23 = e4;
            return t23 && u(t23.key) && u(t23.comment);
          };
        }(o2 || (o2 = {})), t22.isDefined = u, t22.isPseudo = false, t22.setPseudo = function(e3) {
          t22.isPseudo = e3;
        }, t22.format = i, t22.localize = function(e3, t23) {
          for (var r3 = [], o3 = 2; o3 < arguments.length; o3++)
            r3[o3 - 2] = arguments[o3];
          return i(t23, r3);
        }, t22.loadMessageBundle = function(e3) {
          return (0, a3.default)().loadMessageBundle(e3);
        }, t22.config = function(e3) {
          return (0, a3.default)().config(e3);
        };
      }, 926: (e2, t22) => {
        "use strict";
        var r2;
        function o2() {
          if (void 0 === r2)
            throw new Error("No runtime abstraction layer installed");
          return r2;
        }
        Object.defineProperty(t22, "__esModule", { value: true }), function(e3) {
          e3.install = function(e4) {
            if (void 0 === e4)
              throw new Error("No runtime abstraction layer provided");
            r2 = e4;
          };
        }(o2 || (o2 = {})), t22.default = o2;
      }, 472: (e2, t22, r2) => {
        "use strict";
        Object.defineProperty(t22, "__esModule", { value: true }), t22.config = t22.loadMessageBundle = t22.BundleFormat = t22.MessageFormat = void 0;
        var o2 = r2(17), n2 = r2(147), s = r2(926), a3 = r2(800), u = r2(800);
        Object.defineProperty(t22, "MessageFormat", { enumerable: true, get: function() {
          return u.MessageFormat;
        } }), Object.defineProperty(t22, "BundleFormat", { enumerable: true, get: function() {
          return u.BundleFormat;
        } });
        var i, c, l = Object.prototype.toString;
        function d(e3) {
          return "[object Number]" === l.call(e3);
        }
        function f3(e3) {
          return "[object String]" === l.call(e3);
        }
        function p(e3) {
          return JSON.parse(n2.readFileSync(e3, "utf8"));
        }
        function h(e3) {
          return function(t23, r3) {
            for (var o3 = [], n3 = 2; n3 < arguments.length; n3++)
              o3[n3 - 2] = arguments[n3];
            return d(t23) ? t23 >= e3.length ? void console.error("Broken localize call found. Index out of bounds. Stacktrace is\n: ".concat(new Error("").stack)) : (0, a3.format)(e3[t23], o3) : f3(r3) ? (console.warn("Message ".concat(r3, " didn't get externalized correctly.")), (0, a3.format)(r3, o3)) : void console.error("Broken localize call found. Stacktrace is\n: ".concat(new Error("").stack));
          };
        }
        function g(e3, t23) {
          return i[e3] = t23, t23;
        }
        function v(e3) {
          try {
            return function(e4) {
              var t23 = p(o2.join(e4, "nls.metadata.json")), r3 = /* @__PURE__ */ Object.create(null);
              for (var n3 in t23) {
                var s2 = t23[n3];
                r3[n3] = s2.messages;
              }
              return r3;
            }(e3);
          } catch (e4) {
            return void console.log("Generating default bundle from meta data failed.", e4);
          }
        }
        function m(e3, t23) {
          var r3;
          if (true === c.languagePackSupport && void 0 !== c.cacheRoot && void 0 !== c.languagePackId && void 0 !== c.translationsConfigFile && void 0 !== c.translationsConfig)
            try {
              r3 = function(e4, t24) {
                var r4, s3, a4, u2 = o2.join(c.cacheRoot, "".concat(e4.id, "-").concat(e4.hash, ".json")), i2 = false, l2 = false;
                try {
                  return r4 = JSON.parse(n2.readFileSync(u2, { encoding: "utf8", flag: "r" })), s3 = u2, a4 = /* @__PURE__ */ new Date(), n2.utimes(s3, a4, a4, function() {
                  }), r4;
                } catch (e5) {
                  if ("ENOENT" === e5.code)
                    l2 = true;
                  else {
                    if (!(e5 instanceof SyntaxError))
                      throw e5;
                    console.log("Syntax error parsing message bundle: ".concat(e5.message, ".")), n2.unlink(u2, function(e6) {
                      e6 && console.error("Deleting corrupted bundle ".concat(u2, " failed."));
                    }), i2 = true;
                  }
                }
                if (r4 = function(e5, t25) {
                  var r5 = c.translationsConfig[e5.id];
                  if (r5) {
                    var n3 = p(r5).contents, s4 = p(o2.join(t25, "nls.metadata.json")), a5 = /* @__PURE__ */ Object.create(null);
                    for (var u3 in s4) {
                      var i3 = s4[u3], l3 = n3["".concat(e5.outDir, "/").concat(u3)];
                      if (l3) {
                        for (var d2 = [], h2 = 0; h2 < i3.keys.length; h2++) {
                          var g2 = i3.keys[h2], v2 = l3[f3(g2) ? g2 : g2.key];
                          void 0 === v2 && (v2 = i3.messages[h2]), d2.push(v2);
                        }
                        a5[u3] = d2;
                      } else
                        a5[u3] = i3.messages;
                    }
                    return a5;
                  }
                }(e4, t24), !r4 || i2)
                  return r4;
                if (l2)
                  try {
                    n2.writeFileSync(u2, JSON.stringify(r4), { encoding: "utf8", flag: "wx" });
                  } catch (e5) {
                    if ("EEXIST" === e5.code)
                      return r4;
                    throw e5;
                  }
                return r4;
              }(e3, t23);
            } catch (e4) {
              console.log("Load or create bundle failed ", e4);
            }
          if (!r3) {
            if (c.languagePackSupport)
              return v(t23);
            var s2 = function(e4) {
              for (var t24 = c.language; t24; ) {
                var r4 = o2.join(e4, "nls.bundle.".concat(t24, ".json"));
                if (n2.existsSync(r4))
                  return r4;
                var s3 = t24.lastIndexOf("-");
                t24 = s3 > 0 ? t24.substring(0, s3) : void 0;
              }
              if (void 0 === t24 && (r4 = o2.join(e4, "nls.bundle.json"), n2.existsSync(r4)))
                return r4;
            }(t23);
            if (s2)
              try {
                return p(s2);
              } catch (e4) {
                console.log("Loading in the box message bundle failed.", e4);
              }
            r3 = v(t23);
          }
          return r3;
        }
        function y(e3) {
          if (!e3)
            return a3.localize;
          var t23 = o2.extname(e3);
          if (t23 && (e3 = e3.substr(0, e3.length - t23.length)), c.messageFormat === a3.MessageFormat.both || c.messageFormat === a3.MessageFormat.bundle) {
            var r3 = function(e4) {
              for (var t24, r4 = o2.dirname(e4); t24 = o2.join(r4, "nls.metadata.header.json"), !n2.existsSync(t24); ) {
                var s3 = o2.dirname(r4);
                if (s3 === r4) {
                  t24 = void 0;
                  break;
                }
                r4 = s3;
              }
              return t24;
            }(e3);
            if (r3) {
              var s2 = o2.dirname(r3), u2 = i[s2];
              if (void 0 === u2)
                try {
                  var l2 = JSON.parse(n2.readFileSync(r3, "utf8"));
                  try {
                    var d2 = m(l2, s2);
                    u2 = g(s2, d2 ? { header: l2, nlsBundle: d2 } : null);
                  } catch (e4) {
                    console.error("Failed to load nls bundle", e4), u2 = g(s2, null);
                  }
                } catch (e4) {
                  console.error("Failed to read header file", e4), u2 = g(s2, null);
                }
              if (u2) {
                var f4 = e3.substr(s2.length + 1).replace(/\\/g, "/"), v2 = u2.nlsBundle[f4];
                return void 0 === v2 ? (console.error("Messages for file ".concat(e3, " not found. See console for details.")), function() {
                  return "Messages not found.";
                }) : h(v2);
              }
            }
          }
          if (c.messageFormat === a3.MessageFormat.both || c.messageFormat === a3.MessageFormat.file)
            try {
              var y2 = p(function(e4) {
                var t24;
                if (c.cacheLanguageResolution && t24)
                  ;
                else {
                  if (a3.isPseudo || !c.language)
                    t24 = ".nls.json";
                  else
                    for (var r4 = c.language; r4; ) {
                      var o3 = ".nls." + r4 + ".json";
                      if (n2.existsSync(e4 + o3)) {
                        t24 = o3;
                        break;
                      }
                      var s3 = r4.lastIndexOf("-");
                      s3 > 0 ? r4 = r4.substring(0, s3) : (t24 = ".nls.json", r4 = null);
                    }
                  c.cacheLanguageResolution;
                }
                return e4 + t24;
              }(e3));
              return Array.isArray(y2) ? h(y2) : (0, a3.isDefined)(y2.messages) && (0, a3.isDefined)(y2.keys) ? h(y2.messages) : (console.error("String bundle '".concat(e3, "' uses an unsupported format.")), function() {
                return "File bundle has unsupported format. See console for details";
              });
            } catch (e4) {
              "ENOENT" !== e4.code && console.error("Failed to load single file bundle", e4);
            }
          return console.error("Failed to load message bundle for file ".concat(e3)), function() {
            return "Failed to load message bundle. See console for details.";
          };
        }
        function b(e3) {
          return e3 && (f3(e3.locale) && (c.locale = e3.locale.toLowerCase(), c.language = c.locale, i = /* @__PURE__ */ Object.create(null)), void 0 !== e3.messageFormat && (c.messageFormat = e3.messageFormat), e3.bundleFormat === a3.BundleFormat.standalone && true === c.languagePackSupport && (c.languagePackSupport = false)), (0, a3.setPseudo)("pseudo" === c.locale), y;
        }
        !function() {
          if (c = { locale: void 0, language: void 0, languagePackSupport: false, cacheLanguageResolution: true, messageFormat: a3.MessageFormat.bundle }, f3(process.env.VSCODE_NLS_CONFIG))
            try {
              var e3 = JSON.parse(process.env.VSCODE_NLS_CONFIG), t23 = void 0;
              if (e3.availableLanguages) {
                var r3 = e3.availableLanguages["*"];
                f3(r3) && (t23 = r3);
              }
              if (f3(e3.locale) && (c.locale = e3.locale.toLowerCase()), void 0 === t23 ? c.language = c.locale : "en" !== t23 && (c.language = t23), /* @__PURE__ */ function(e4) {
                return true === e4 || false === e4;
              }(e3._languagePackSupport) && (c.languagePackSupport = e3._languagePackSupport), f3(e3._cacheRoot) && (c.cacheRoot = e3._cacheRoot), f3(e3._languagePackId) && (c.languagePackId = e3._languagePackId), f3(e3._translationsConfigFile)) {
                c.translationsConfigFile = e3._translationsConfigFile;
                try {
                  c.translationsConfig = p(c.translationsConfigFile);
                } catch (t24) {
                  if (e3._corruptedFile) {
                    var s2 = o2.dirname(e3._corruptedFile);
                    n2.exists(s2, function(t25) {
                      t25 && n2.writeFile(e3._corruptedFile, "corrupted", "utf8", function(e4) {
                        console.error(e4);
                      });
                    });
                  }
                }
              }
            } catch (e4) {
            }
          (0, a3.setPseudo)("pseudo" === c.locale), i = /* @__PURE__ */ Object.create(null);
        }(), t22.loadMessageBundle = y, t22.config = b, s.default.install(Object.freeze({ loadMessageBundle: y, config: b }));
      }, 374: (e2, t22) => {
        function r2() {
        }
        Object.defineProperty(t22, "__esModule", { value: true }), t22.default = function(e3) {
          return r2;
        };
      }, 491: (e2) => {
        "use strict";
        e2.exports = require("assert");
      }, 361: (e2) => {
        "use strict";
        e2.exports = require("events");
      }, 147: (e2) => {
        "use strict";
        e2.exports = require("fs");
      }, 685: (e2) => {
        "use strict";
        e2.exports = require("http");
      }, 687: (e2) => {
        "use strict";
        e2.exports = require("https");
      }, 808: (e2) => {
        "use strict";
        e2.exports = require("net");
      }, 17: (e2) => {
        "use strict";
        e2.exports = require("path");
      }, 404: (e2) => {
        "use strict";
        e2.exports = require("tls");
      }, 310: (e2) => {
        "use strict";
        e2.exports = require("url");
      }, 796: (e2) => {
        "use strict";
        e2.exports = require("zlib");
      } }, t21 = {}, r = function r2(o2) {
        var n2 = t21[o2];
        if (void 0 !== n2)
          return n2.exports;
        var s = t21[o2] = { exports: {} };
        return e[o2].call(s.exports, s, s.exports, r2), s.exports;
      }(539), o = exports2;
      for (var n in r)
        o[n] = r[n];
      r.__esModule && Object.defineProperty(o, "__esModule", { value: true });
    })();
  }
});

// node_modules/@volar/language-server/lib/common/schemaRequestHandlers/http.js
var require_http = __commonJS({
  "node_modules/@volar/language-server/lib/common/schemaRequestHandlers/http.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var request_light_1 = require_main5();
    function handler(uri) {
      const headers = { "Accept-Encoding": "gzip, deflate" };
      return (0, request_light_1.xhr)({ url: uri, followRedirects: 5, headers }).then((response) => {
        if (response.status !== 200) {
          return;
        }
        return response.responseText;
      }, (error) => {
        return Promise.reject(error.responseText || (0, request_light_1.getErrorStatusDescription)(error.status) || error.toString());
      });
    }
    exports2.default = handler;
  }
});

// node_modules/muggle-string/out/binarySearch.js
var require_binarySearch = __commonJS({
  "node_modules/muggle-string/out/binarySearch.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.binarySearch = void 0;
    function binarySearch2(offsets, start) {
      let low = 0;
      let high = offsets.length - 1;
      while (low <= high) {
        const mid = Math.floor((low + high) / 2);
        const midValue = offsets[mid];
        if (midValue < start) {
          low = mid + 1;
        } else if (midValue > start) {
          high = mid - 1;
        } else {
          low = mid;
          high = mid;
          break;
        }
      }
      return Math.max(Math.min(low, high, offsets.length - 1), 0);
    }
    exports2.binarySearch = binarySearch2;
  }
});

// node_modules/muggle-string/out/track.js
var require_track = __commonJS({
  "node_modules/muggle-string/out/track.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.track = exports2.resetOffsetStack = exports2.offsetStack = exports2.setTracking = void 0;
    var tracking = true;
    var stackOffset = 0;
    function setTracking(value) {
      tracking = value;
    }
    exports2.setTracking = setTracking;
    function offsetStack() {
      stackOffset++;
    }
    exports2.offsetStack = offsetStack;
    function resetOffsetStack() {
      stackOffset--;
    }
    exports2.resetOffsetStack = resetOffsetStack;
    function track(segments, stacks = []) {
      return [
        new Proxy(segments, {
          get(target, prop, receiver) {
            if (tracking) {
              if (prop === "push")
                return push;
              if (prop === "pop")
                return pop;
              if (prop === "shift")
                return shift;
              if (prop === "unshift")
                return unshift;
              if (prop === "splice")
                return splice;
              if (prop === "sort")
                return sort2;
              if (prop === "reverse")
                return reverse;
            }
            return Reflect.get(target, prop, receiver);
          }
        }),
        stacks
      ];
      function push(...items) {
        stacks.push({ stack: getStack(), length: items.length });
        return segments.push(...items);
      }
      function pop() {
        if (stacks.length) {
          const last = stacks[stacks.length - 1];
          if (last.length > 1) {
            last.length--;
          } else {
            stacks.pop();
          }
        }
        return segments.pop();
      }
      function shift() {
        if (stacks.length) {
          const first = stacks[0];
          if (first.length > 1) {
            first.length--;
          } else {
            stacks.shift();
          }
        }
        return segments.shift();
      }
      function unshift(...items) {
        stacks.unshift({ stack: getStack(), length: items.length });
        return segments.unshift(...items);
      }
      function splice(start, deleteCount, ...items) {
        if (deleteCount === void 0) {
          deleteCount = segments.length - start;
        }
        let _stackStart = 0;
        let operateIndex;
        for (let i = 0; i < stacks.length; i++) {
          const stack = stacks[i];
          const stackStart = _stackStart;
          const stackEnd = stackStart + stack.length;
          _stackStart = stackEnd;
          if (start >= stackStart) {
            operateIndex = i + 1;
            const originalLength = stack.length;
            stack.length = start - stackStart;
            stacks.splice(operateIndex, 0, { stack: stack.stack, length: originalLength - stack.length });
            break;
          }
        }
        if (operateIndex === void 0) {
          throw new Error("Invalid splice operation");
        }
        let _deleteCount = deleteCount;
        for (let i = operateIndex; i < stacks.length; i++) {
          const stack = stacks[i];
          while (_deleteCount > 0 && stack.length > 0) {
            stack.length--;
            _deleteCount--;
          }
          if (_deleteCount === 0) {
            break;
          }
        }
        stacks.splice(operateIndex, 0, { stack: getStack(), length: items.length });
        return segments.splice(start, deleteCount, ...items);
      }
      function sort2(compareFn) {
        stacks.splice(0, stacks.length, { stack: getStack(), length: segments.length });
        return segments.sort(compareFn);
      }
      function reverse() {
        stacks.splice(0, stacks.length, { stack: getStack(), length: segments.length });
        return segments.reverse();
      }
      function getStack() {
        const stack = new Error().stack;
        let source = stack.split("\n")[3 + stackOffset].trim();
        if (source.endsWith(")")) {
          source = source.slice(source.lastIndexOf("(") + 1, -1);
        } else {
          source = source.slice(source.lastIndexOf(" ") + 1);
        }
        return source;
      }
    }
    exports2.track = track;
  }
});

// node_modules/muggle-string/out/types.js
var require_types = __commonJS({
  "node_modules/muggle-string/out/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
  }
});

// node_modules/muggle-string/out/index.js
var require_out = __commonJS({
  "node_modules/muggle-string/out/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.replaceRange = exports2.replaceSourceRange = exports2.replaceAll = exports2.replace = exports2.create = exports2.toString = exports2.getLength = void 0;
    var binarySearch_1 = require_binarySearch();
    var track_1 = require_track();
    __exportStar(require_types(), exports2);
    __exportStar(require_track(), exports2);
    function getLength(segments) {
      let length = 0;
      for (const segment of segments) {
        length += typeof segment == "string" ? segment.length : segment[0].length;
      }
      return length;
    }
    exports2.getLength = getLength;
    function toString(segments) {
      return segments.map((s) => typeof s === "string" ? s : s[0]).join("");
    }
    exports2.toString = toString;
    function create(source) {
      return [[source, void 0, 0]];
    }
    exports2.create = create;
    function replace(segments, pattern, ...replacers) {
      const str = toString(segments);
      const match = str.match(pattern);
      if (match && match.index !== void 0) {
        const startOffset = match.index;
        const endOffset = startOffset + match[0].length;
        (0, track_1.offsetStack)();
        replaceRange(segments, startOffset, endOffset, ...replacers.map((replacer) => typeof replacer === "function" ? replacer(match[0]) : replacer));
        (0, track_1.resetOffsetStack)();
      }
    }
    exports2.replace = replace;
    function replaceAll(segments, pattern, ...replacers) {
      const str = toString(segments);
      const allMatch = str.matchAll(pattern);
      let length = str.length;
      let lengthDiff = 0;
      for (const match of allMatch) {
        if (match.index !== void 0) {
          const startOffset = match.index + lengthDiff;
          const endOffset = startOffset + match[0].length;
          (0, track_1.offsetStack)();
          replaceRange(segments, startOffset, endOffset, ...replacers.map((replacer) => typeof replacer === "function" ? replacer(match[0]) : replacer));
          (0, track_1.resetOffsetStack)();
          const newLength = getLength(segments);
          lengthDiff += newLength - length;
          length = newLength;
        }
      }
    }
    exports2.replaceAll = replaceAll;
    function replaceSourceRange(segments, source, startOffset, endOffset, ...newSegments) {
      for (const segment of segments) {
        if (typeof segment === "string") {
          continue;
        }
        if (segment[1] === source) {
          const segmentStart = typeof segment[2] === "number" ? segment[2] : segment[2][0];
          const segmentEnd = typeof segment[2] === "number" ? segment[2] + segment[0].length : segment[2][1];
          if (segmentStart <= startOffset && segmentEnd >= endOffset) {
            const inserts = [];
            if (startOffset > segmentStart) {
              inserts.push(trimSegmentEnd(segment, startOffset - segmentStart));
            }
            for (const newSegment of newSegments) {
              inserts.push(newSegment);
            }
            if (endOffset < segmentEnd) {
              inserts.push(trimSegmentStart(segment, endOffset - segmentEnd));
            }
            combineStrings(inserts);
            (0, track_1.offsetStack)();
            segments.splice(segments.indexOf(segment), 1, ...inserts);
            (0, track_1.resetOffsetStack)();
            return true;
          }
        }
      }
      return false;
    }
    exports2.replaceSourceRange = replaceSourceRange;
    function replaceRange(segments, startOffset, endOffset, ...newSegments) {
      const offsets = toOffsets(segments);
      const startIndex = (0, binarySearch_1.binarySearch)(offsets, startOffset);
      const endIndex = (0, binarySearch_1.binarySearch)(offsets, endOffset);
      const startSegment = segments[startIndex];
      const endSegment = segments[endIndex];
      const startSegmentStart = offsets[startIndex];
      const endSegmentStart = offsets[endIndex];
      const endSegmentEnd = offsets[endIndex] + (typeof endSegment === "string" ? endSegment.length : endSegment[0].length);
      const inserts = [];
      if (startOffset > startSegmentStart) {
        inserts.push(trimSegmentEnd(startSegment, startOffset - startSegmentStart));
      }
      for (const newSegment of newSegments) {
        inserts.push(newSegment);
      }
      if (endOffset < endSegmentEnd) {
        inserts.push(trimSegmentStart(endSegment, endOffset - endSegmentStart));
      }
      combineStrings(inserts);
      (0, track_1.offsetStack)();
      segments.splice(startIndex, endIndex - startIndex + 1, ...inserts);
      (0, track_1.resetOffsetStack)();
    }
    exports2.replaceRange = replaceRange;
    function combineStrings(segments) {
      for (let i = segments.length - 1; i >= 1; i--) {
        if (typeof segments[i] === "string" && typeof segments[i - 1] === "string") {
          segments[i - 1] = segments[i - 1] + segments[i];
          (0, track_1.offsetStack)();
          segments.splice(i, 1);
          (0, track_1.resetOffsetStack)();
        }
      }
    }
    function trimSegmentEnd(segment, trimEnd) {
      if (typeof segment === "string") {
        return segment.slice(0, trimEnd);
      }
      const originalString = segment[0];
      const originalRange = segment[2];
      const newString = originalString.slice(0, trimEnd);
      const newRange = typeof originalRange === "number" ? originalRange : [originalRange[0], originalRange[1] - (originalString.length - newString.length)];
      return [
        newString,
        segment[1],
        newRange,
        ...segment.slice(3)
      ];
    }
    function trimSegmentStart(segment, trimStart) {
      if (typeof segment === "string") {
        return segment.slice(trimStart);
      }
      const originalString = segment[0];
      const originalRange = segment[2];
      const newString = originalString.slice(trimStart);
      if (trimStart < 0) {
        trimStart += originalString.length;
      }
      const newRange = typeof originalRange === "number" ? originalRange + trimStart : [originalRange[0] + trimStart, originalRange[1]];
      return [
        newString,
        segment[1],
        newRange,
        ...segment.slice(3)
      ];
    }
    function toOffsets(segments) {
      const offsets = [];
      let offset = 0;
      for (const segment of segments) {
        offsets.push(offset);
        offset += typeof segment == "string" ? segment.length : segment[0].length;
      }
      return offsets;
    }
  }
});

// node_modules/@volar/source-map/index.js
var require_source_map = __commonJS({
  "node_modules/@volar/source-map/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.buildStacks = exports2.buildMappings = exports2.SourceMap = void 0;
    __exportStar(require_out(), exports2);
    var SourceMap = class {
      get memo() {
        if (!this._memo) {
          let createMemo = function(key) {
            const offsets = /* @__PURE__ */ new Set();
            for (const mapping of self2.mappings) {
              offsets.add(mapping[key][0]);
              offsets.add(mapping[key][1]);
            }
            const arr = [...offsets].sort((a3, b) => a3 - b).map((offset) => ({ offset, mappings: /* @__PURE__ */ new Set() }));
            for (const mapping of self2.mappings) {
              const startIndex = binarySearch2(mapping[key][0]);
              const endIndex = binarySearch2(mapping[key][1]);
              for (let i = startIndex; i <= endIndex; i++) {
                arr[i].mappings.add(mapping);
              }
            }
            return arr;
            function binarySearch2(start) {
              let low = 0;
              let high = arr.length - 1;
              while (low <= high) {
                const mid = Math.floor((low + high) / 2);
                const midValue = arr[mid];
                if (midValue.offset < start) {
                  low = mid + 1;
                } else if (midValue.offset > start) {
                  high = mid - 1;
                } else {
                  return mid;
                }
              }
            }
          };
          const self2 = this;
          this._memo = {
            sourceRange: createMemo("sourceRange"),
            generatedRange: createMemo("generatedRange")
          };
        }
        return this._memo;
      }
      constructor(mappings) {
        this.mappings = mappings;
      }
      toSourceOffset(start, baseOnRight = false) {
        for (const mapped of this.matching(start, "generatedRange", "sourceRange", baseOnRight)) {
          return mapped;
        }
      }
      toGeneratedOffset(start, baseOnRight = false) {
        for (const mapped of this.matching(start, "sourceRange", "generatedRange", baseOnRight)) {
          return mapped;
        }
      }
      toSourceOffsets(start, baseOnRight = false) {
        return this.matching(start, "generatedRange", "sourceRange", baseOnRight);
      }
      toGeneratedOffsets(start, baseOnRight = false) {
        return this.matching(start, "sourceRange", "generatedRange", baseOnRight);
      }
      *matching(startOffset, from, to, baseOnRight) {
        const memo = this.memo[from];
        if (memo.length === 0)
          return;
        const { low: start, high: end } = this.binarySearchMemo(memo, startOffset);
        const skip = /* @__PURE__ */ new Set();
        for (let i = start; i <= end; i++) {
          for (const mapping of memo[i].mappings) {
            if (skip.has(mapping)) {
              continue;
            }
            skip.add(mapping);
            const mapped = this.matchOffset(startOffset, mapping[from], mapping[to], baseOnRight);
            if (mapped !== void 0) {
              yield [mapped, mapping];
            }
          }
        }
      }
      matchOffset(start, mappedFromRange, mappedToRange, baseOnRight) {
        if (start >= mappedFromRange[0] && start <= mappedFromRange[1]) {
          let offset = mappedToRange[0] + start - mappedFromRange[0];
          if (baseOnRight) {
            offset += mappedToRange[1] - mappedToRange[0] - (mappedFromRange[1] - mappedFromRange[0]);
          }
          if (offset >= mappedToRange[0] && offset <= mappedToRange[1]) {
            return offset;
          }
        }
      }
      binarySearchMemo(array, start) {
        let low = 0;
        let high = array.length - 1;
        while (low <= high) {
          const mid = Math.floor((low + high) / 2);
          const midValue = array[mid];
          if (midValue.offset < start) {
            low = mid + 1;
          } else if (midValue.offset > start) {
            high = mid - 1;
          } else {
            low = mid;
            high = mid;
            break;
          }
        }
        return {
          low: Math.max(Math.min(low, high, array.length - 1), 0),
          high: Math.min(Math.max(low, high, 0), array.length - 1)
        };
      }
    };
    exports2.SourceMap = SourceMap;
    function buildMappings(chunks) {
      let length = 0;
      const mappings = [];
      for (const segment of chunks) {
        if (typeof segment === "string") {
          length += segment.length;
        } else {
          mappings.push({
            generatedRange: [length, length + segment[0].length],
            source: segment[1],
            sourceRange: typeof segment[2] === "number" ? [segment[2], segment[2] + segment[0].length] : segment[2],
            // @ts-ignore
            data: segment[3]
          });
          length += segment[0].length;
        }
      }
      return mappings;
    }
    exports2.buildMappings = buildMappings;
    function buildStacks(chunks, stacks) {
      let offset = 0;
      let index = 0;
      const result = [];
      for (const stack of stacks) {
        const start = offset;
        for (let i = 0; i < stack.length; i++) {
          const segment = chunks[index + i];
          if (typeof segment === "string") {
            offset += segment.length;
          } else {
            offset += segment[0].length;
          }
        }
        index += stack.length;
        result.push({
          range: [start, offset],
          source: stack.stack
        });
      }
      return result;
    }
    exports2.buildStacks = buildStacks;
  }
});

// node_modules/@volar/language-core/lib/sourceMaps.js
var require_sourceMaps = __commonJS({
  "node_modules/@volar/language-core/lib/sourceMaps.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MirrorMap = void 0;
    var SourceMaps = require_source_map();
    var MirrorMap = class extends SourceMaps.SourceMap {
      *findMirrorOffsets(start) {
        for (const mapped of this.toGeneratedOffsets(start)) {
          yield [mapped[0], mapped[1].data[1]];
        }
        for (const mapped of this.toSourceOffsets(start)) {
          yield [mapped[0], mapped[1].data[0]];
        }
      }
    };
    exports2.MirrorMap = MirrorMap;
  }
});

// node_modules/@volar/language-core/lib/virtualFiles.js
var require_virtualFiles = __commonJS({
  "node_modules/@volar/language-core/lib/virtualFiles.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.forEachEmbeddedFile = exports2.updateVirtualFileMaps = exports2.createVirtualFiles = void 0;
    var source_map_1 = require_source_map();
    var sourceMaps_1 = require_sourceMaps();
    function createVirtualFiles(languages) {
      const sourceFiles = /* @__PURE__ */ new Map();
      const virtualFiles = /* @__PURE__ */ new Map();
      const virtualFileMaps = /* @__PURE__ */ new WeakMap();
      const virtualFileToMirrorMap = /* @__PURE__ */ new WeakMap();
      return {
        allSources() {
          return Array.from(sourceFiles.values());
        },
        updateSource(fileName, snapshot, languageId) {
          const key = normalizePath(fileName);
          const value = sourceFiles.get(key);
          if (value) {
            if (value.languageId !== languageId) {
              this.deleteSource(fileName);
              return this.updateSource(fileName, snapshot, languageId);
            } else {
              value.snapshot = snapshot;
              deleteVirtualFiles(value);
              value.language.updateVirtualFile(value.root, snapshot);
              updateVirtualFiles(value);
              return value.root;
            }
          }
          for (const language of languages) {
            const virtualFile = language.createVirtualFile(fileName, snapshot, languageId);
            if (virtualFile) {
              const source = { fileName, languageId, snapshot, root: virtualFile, language };
              sourceFiles.set(key, source);
              updateVirtualFiles(source);
              return virtualFile;
            }
          }
        },
        deleteSource(fileName) {
          var _a3, _b;
          const key = normalizePath(fileName);
          const value = sourceFiles.get(key);
          if (value) {
            (_b = (_a3 = value.language).deleteVirtualFile) == null ? void 0 : _b.call(_a3, value.root);
            sourceFiles.delete(key);
            deleteVirtualFiles(value);
          }
        },
        getSource(fileName) {
          const key = normalizePath(fileName);
          return sourceFiles.get(key);
        },
        hasSource: (fileName) => sourceFiles.has(normalizePath(fileName)),
        getMirrorMap,
        getMaps: getMapsByVirtualFile,
        hasVirtualFile(fileName) {
          return !!virtualFiles.get(normalizePath(fileName));
        },
        getVirtualFile(fileName) {
          const sourceAndVirtual = virtualFiles.get(normalizePath(fileName));
          if (sourceAndVirtual) {
            return [sourceAndVirtual.virtualFile, sourceAndVirtual.source];
          }
          return [void 0, void 0];
        }
      };
      function deleteVirtualFiles(source) {
        forEachEmbeddedFile(source.root, (file) => {
          virtualFiles.delete(normalizePath(file.fileName));
        });
      }
      function updateVirtualFiles(source) {
        forEachEmbeddedFile(source.root, (file) => {
          virtualFiles.set(normalizePath(file.fileName), { virtualFile: file, source });
        });
      }
      function getMapsByVirtualFile(virtualFile) {
        if (!virtualFileMaps.has(virtualFile.snapshot)) {
          virtualFileMaps.set(virtualFile.snapshot, /* @__PURE__ */ new Map());
        }
        updateVirtualFileMaps(virtualFile, (sourceFileName) => {
          if (sourceFileName) {
            const source = sourceFiles.get(normalizePath(sourceFileName));
            return [sourceFileName, source.snapshot];
          } else {
            const source = virtualFiles.get(normalizePath(virtualFile.fileName)).source;
            return [source.fileName, source.snapshot];
          }
        }, virtualFileMaps.get(virtualFile.snapshot));
        return virtualFileMaps.get(virtualFile.snapshot);
      }
      function getMirrorMap(file) {
        if (!virtualFileToMirrorMap.has(file.snapshot)) {
          virtualFileToMirrorMap.set(file.snapshot, file.mirrorBehaviorMappings ? new sourceMaps_1.MirrorMap(file.mirrorBehaviorMappings) : void 0);
        }
        return virtualFileToMirrorMap.get(file.snapshot);
      }
    }
    exports2.createVirtualFiles = createVirtualFiles;
    function updateVirtualFileMaps(virtualFile, getSourceSnapshot, map = /* @__PURE__ */ new Map()) {
      const sources = /* @__PURE__ */ new Set();
      for (const mapping of virtualFile.mappings) {
        if (sources.has(mapping.source))
          continue;
        sources.add(mapping.source);
        const source = getSourceSnapshot(mapping.source);
        if (!source)
          continue;
        if (!map.has(source[0]) || map.get(source[0])[0] !== source[1]) {
          map.set(source[0], [source[1], new source_map_1.SourceMap(virtualFile.mappings.filter((mapping2) => mapping2.source === mapping.source))]);
        }
      }
      return map;
    }
    exports2.updateVirtualFileMaps = updateVirtualFileMaps;
    function forEachEmbeddedFile(file, cb) {
      cb(file);
      for (const embeddedFile of file.embeddedFiles) {
        forEachEmbeddedFile(embeddedFile, cb);
      }
    }
    exports2.forEachEmbeddedFile = forEachEmbeddedFile;
    function normalizePath(fileName) {
      return fileName.replace(/\\/g, "/").toLowerCase();
    }
  }
});

// node_modules/@volar/language-core/lib/languageContext.js
var require_languageContext = __commonJS({
  "node_modules/@volar/language-core/lib/languageContext.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createLanguageContext = void 0;
    var virtualFiles_1 = require_virtualFiles();
    function createLanguageContext(rawHost, languages) {
      let host = rawHost;
      let lastRootFiles = /* @__PURE__ */ new Map();
      let lastProjectVersion;
      const virtualFiles = (0, virtualFiles_1.createVirtualFiles)(languages);
      for (const language of languages.reverse()) {
        if (language.resolveHost) {
          const pastHost = host;
          let proxyHost = language.resolveHost(host);
          if (proxyHost === pastHost) {
            console.warn(`[volar] language.resolveHost() should not return the same host instance.`);
            proxyHost = __spreadValues({}, proxyHost);
          }
          host = new Proxy(proxyHost, {
            get(target, p) {
              if (p in target) {
                return target[p];
              }
              return pastHost[p];
            }
          });
        }
      }
      return {
        rawHost,
        host,
        virtualFiles: new Proxy(virtualFiles, {
          get: (target, property) => {
            syncVirtualFiles();
            return target[property];
          }
        })
      };
      function syncVirtualFiles() {
        var _a3;
        const newProjectVersion = host.getProjectVersion();
        const shouldUpdate = newProjectVersion !== lastProjectVersion;
        if (!shouldUpdate)
          return;
        const nowRootFiles = /* @__PURE__ */ new Map();
        const remainRootFiles = new Set(lastRootFiles.keys());
        for (const rootFileName of host.getScriptFileNames()) {
          nowRootFiles.set(rootFileName, host.getScriptSnapshot(rootFileName));
        }
        for (const [fileName, snapshot] of nowRootFiles) {
          remainRootFiles.delete(fileName);
          if (lastRootFiles.get(fileName) !== nowRootFiles.get(fileName)) {
            if (snapshot) {
              virtualFiles.updateSource(fileName, snapshot, (_a3 = host.getLanguageId) == null ? void 0 : _a3.call(host, fileName));
            } else {
              virtualFiles.deleteSource(fileName);
            }
          }
        }
        for (const fileName of remainRootFiles) {
          virtualFiles.deleteSource(fileName);
        }
        lastRootFiles = nowRootFiles;
        lastProjectVersion = newProjectVersion;
      }
    }
    exports2.createLanguageContext = createLanguageContext;
  }
});

// node_modules/@volar/language-core/lib/types.js
var require_types2 = __commonJS({
  "node_modules/@volar/language-core/lib/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FileKind = exports2.MirrorBehaviorCapabilities = exports2.FileRangeCapabilities = exports2.FileCapabilities = void 0;
    var FileCapabilities;
    (function(FileCapabilities2) {
      FileCapabilities2.full = {
        diagnostic: true,
        foldingRange: true,
        documentFormatting: true,
        documentSymbol: true,
        codeAction: true,
        inlayHint: true
      };
    })(FileCapabilities || (exports2.FileCapabilities = FileCapabilities = {}));
    var FileRangeCapabilities;
    (function(FileRangeCapabilities2) {
      FileRangeCapabilities2.full = {
        hover: true,
        references: true,
        definition: true,
        rename: true,
        completion: true,
        diagnostic: true,
        semanticTokens: true
      };
    })(FileRangeCapabilities || (exports2.FileRangeCapabilities = FileRangeCapabilities = {}));
    var MirrorBehaviorCapabilities;
    (function(MirrorBehaviorCapabilities2) {
      MirrorBehaviorCapabilities2.full = {
        references: true,
        definition: true,
        rename: true
      };
    })(MirrorBehaviorCapabilities || (exports2.MirrorBehaviorCapabilities = MirrorBehaviorCapabilities = {}));
    var FileKind;
    (function(FileKind2) {
      FileKind2[FileKind2["TextFile"] = 0] = "TextFile";
      FileKind2[FileKind2["TypeScriptHostFile"] = 1] = "TypeScriptHostFile";
    })(FileKind || (exports2.FileKind = FileKind = {}));
  }
});

// node_modules/@volar/language-core/index.js
var require_language_core = __commonJS({
  "node_modules/@volar/language-core/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar(require_virtualFiles(), exports2);
    __exportStar(require_languageContext(), exports2);
    __exportStar(require_sourceMaps(), exports2);
    __exportStar(require_types2(), exports2);
  }
});

// node_modules/vscode-languageserver-textdocument/lib/umd/main.js
var require_main6 = __commonJS({
  "node_modules/vscode-languageserver-textdocument/lib/umd/main.js"(exports2, module2) {
    "use strict";
    var __spreadArray = exports2 && exports2.__spreadArray || function(to, from, pack) {
      if (pack || arguments.length === 2)
        for (var i = 0, l = from.length, ar; i < l; i++) {
          if (ar || !(i in from)) {
            if (!ar)
              ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
          }
        }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    (function(factory) {
      if (typeof module2 === "object" && typeof module2.exports === "object") {
        var v = factory(require, exports2);
        if (v !== void 0)
          module2.exports = v;
      } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
      }
    })(function(require2, exports3) {
      "use strict";
      Object.defineProperty(exports3, "__esModule", { value: true });
      exports3.TextDocument = void 0;
      var FullTextDocument3 = (
        /** @class */
        function() {
          function FullTextDocument4(uri, languageId, version, content) {
            this._uri = uri;
            this._languageId = languageId;
            this._version = version;
            this._content = content;
            this._lineOffsets = void 0;
          }
          Object.defineProperty(FullTextDocument4.prototype, "uri", {
            get: function() {
              return this._uri;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument4.prototype, "languageId", {
            get: function() {
              return this._languageId;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument4.prototype, "version", {
            get: function() {
              return this._version;
            },
            enumerable: false,
            configurable: true
          });
          FullTextDocument4.prototype.getText = function(range) {
            if (range) {
              var start = this.offsetAt(range.start);
              var end = this.offsetAt(range.end);
              return this._content.substring(start, end);
            }
            return this._content;
          };
          FullTextDocument4.prototype.update = function(changes, version) {
            for (var _i = 0, changes_1 = changes; _i < changes_1.length; _i++) {
              var change = changes_1[_i];
              if (FullTextDocument4.isIncremental(change)) {
                var range = getWellformedRange2(change.range);
                var startOffset = this.offsetAt(range.start);
                var endOffset = this.offsetAt(range.end);
                this._content = this._content.substring(0, startOffset) + change.text + this._content.substring(endOffset, this._content.length);
                var startLine = Math.max(range.start.line, 0);
                var endLine = Math.max(range.end.line, 0);
                var lineOffsets = this._lineOffsets;
                var addedLineOffsets = computeLineOffsets2(change.text, false, startOffset);
                if (endLine - startLine === addedLineOffsets.length) {
                  for (var i = 0, len = addedLineOffsets.length; i < len; i++) {
                    lineOffsets[i + startLine + 1] = addedLineOffsets[i];
                  }
                } else {
                  if (addedLineOffsets.length < 1e4) {
                    lineOffsets.splice.apply(lineOffsets, __spreadArray([startLine + 1, endLine - startLine], addedLineOffsets, false));
                  } else {
                    this._lineOffsets = lineOffsets = lineOffsets.slice(0, startLine + 1).concat(addedLineOffsets, lineOffsets.slice(endLine + 1));
                  }
                }
                var diff = change.text.length - (endOffset - startOffset);
                if (diff !== 0) {
                  for (var i = startLine + 1 + addedLineOffsets.length, len = lineOffsets.length; i < len; i++) {
                    lineOffsets[i] = lineOffsets[i] + diff;
                  }
                }
              } else if (FullTextDocument4.isFull(change)) {
                this._content = change.text;
                this._lineOffsets = void 0;
              } else {
                throw new Error("Unknown change event received");
              }
            }
            this._version = version;
          };
          FullTextDocument4.prototype.getLineOffsets = function() {
            if (this._lineOffsets === void 0) {
              this._lineOffsets = computeLineOffsets2(this._content, true);
            }
            return this._lineOffsets;
          };
          FullTextDocument4.prototype.positionAt = function(offset) {
            offset = Math.max(Math.min(offset, this._content.length), 0);
            var lineOffsets = this.getLineOffsets();
            var low = 0, high = lineOffsets.length;
            if (high === 0) {
              return { line: 0, character: offset };
            }
            while (low < high) {
              var mid = Math.floor((low + high) / 2);
              if (lineOffsets[mid] > offset) {
                high = mid;
              } else {
                low = mid + 1;
              }
            }
            var line = low - 1;
            return { line, character: offset - lineOffsets[line] };
          };
          FullTextDocument4.prototype.offsetAt = function(position) {
            var lineOffsets = this.getLineOffsets();
            if (position.line >= lineOffsets.length) {
              return this._content.length;
            } else if (position.line < 0) {
              return 0;
            }
            var lineOffset = lineOffsets[position.line];
            var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
            return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
          };
          Object.defineProperty(FullTextDocument4.prototype, "lineCount", {
            get: function() {
              return this.getLineOffsets().length;
            },
            enumerable: false,
            configurable: true
          });
          FullTextDocument4.isIncremental = function(event) {
            var candidate = event;
            return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
          };
          FullTextDocument4.isFull = function(event) {
            var candidate = event;
            return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
          };
          return FullTextDocument4;
        }()
      );
      var TextDocument3;
      (function(TextDocument4) {
        function create(uri, languageId, version, content) {
          return new FullTextDocument3(uri, languageId, version, content);
        }
        TextDocument4.create = create;
        function update(document2, changes, version) {
          if (document2 instanceof FullTextDocument3) {
            document2.update(changes, version);
            return document2;
          } else {
            throw new Error("TextDocument.update: document must be created by TextDocument.create");
          }
        }
        TextDocument4.update = update;
        function applyEdits2(document2, edits) {
          var text = document2.getText();
          var sortedEdits = mergeSort2(edits.map(getWellformedEdit2), function(a3, b) {
            var diff = a3.range.start.line - b.range.start.line;
            if (diff === 0) {
              return a3.range.start.character - b.range.start.character;
            }
            return diff;
          });
          var lastModifiedOffset = 0;
          var spans = [];
          for (var _i = 0, sortedEdits_1 = sortedEdits; _i < sortedEdits_1.length; _i++) {
            var e = sortedEdits_1[_i];
            var startOffset = document2.offsetAt(e.range.start);
            if (startOffset < lastModifiedOffset) {
              throw new Error("Overlapping edit");
            } else if (startOffset > lastModifiedOffset) {
              spans.push(text.substring(lastModifiedOffset, startOffset));
            }
            if (e.newText.length) {
              spans.push(e.newText);
            }
            lastModifiedOffset = document2.offsetAt(e.range.end);
          }
          spans.push(text.substr(lastModifiedOffset));
          return spans.join("");
        }
        TextDocument4.applyEdits = applyEdits2;
      })(TextDocument3 || (exports3.TextDocument = TextDocument3 = {}));
      function mergeSort2(data, compare) {
        if (data.length <= 1) {
          return data;
        }
        var p = data.length / 2 | 0;
        var left = data.slice(0, p);
        var right = data.slice(p);
        mergeSort2(left, compare);
        mergeSort2(right, compare);
        var leftIdx = 0;
        var rightIdx = 0;
        var i = 0;
        while (leftIdx < left.length && rightIdx < right.length) {
          var ret = compare(left[leftIdx], right[rightIdx]);
          if (ret <= 0) {
            data[i++] = left[leftIdx++];
          } else {
            data[i++] = right[rightIdx++];
          }
        }
        while (leftIdx < left.length) {
          data[i++] = left[leftIdx++];
        }
        while (rightIdx < right.length) {
          data[i++] = right[rightIdx++];
        }
        return data;
      }
      function computeLineOffsets2(text, isAtLineStart, textOffset) {
        if (textOffset === void 0) {
          textOffset = 0;
        }
        var result = isAtLineStart ? [textOffset] : [];
        for (var i = 0; i < text.length; i++) {
          var ch = text.charCodeAt(i);
          if (ch === 13 || ch === 10) {
            if (ch === 13 && i + 1 < text.length && text.charCodeAt(i + 1) === 10) {
              i++;
            }
            result.push(textOffset + i + 1);
          }
        }
        return result;
      }
      function getWellformedRange2(range) {
        var start = range.start;
        var end = range.end;
        if (start.line > end.line || start.line === end.line && start.character > end.character) {
          return { start: end, end: start };
        }
        return range;
      }
      function getWellformedEdit2(textEdit) {
        var range = getWellformedRange2(textEdit.range);
        if (range !== textEdit.range) {
          return { newText: textEdit.newText, range };
        }
        return textEdit;
      }
    });
  }
});

// node_modules/@volar/language-service/lib/utils/common.js
var require_common = __commonJS({
  "node_modules/@volar/language-service/lib/utils/common.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.notEmpty = exports2.sleep = exports2.resolveCommonLanguageId = exports2.stringToSnapshot = exports2.isInsideRange = exports2.getOverlapRange = void 0;
    function getOverlapRange(range1Start, range1End, range2Start, range2End) {
      const start = Math.max(range1Start, range2Start);
      const end = Math.min(range1End, range2End);
      if (start > end)
        return void 0;
      return {
        start,
        end
      };
    }
    exports2.getOverlapRange = getOverlapRange;
    function isInsideRange(parent, child) {
      if (child.start.line < parent.start.line)
        return false;
      if (child.end.line > parent.end.line)
        return false;
      if (child.start.line === parent.start.line && child.start.character < parent.start.character)
        return false;
      if (child.end.line === parent.end.line && child.end.character > parent.end.character)
        return false;
      return true;
    }
    exports2.isInsideRange = isInsideRange;
    function stringToSnapshot(str) {
      return {
        getText: (start, end) => str.substring(start, end),
        getLength: () => str.length,
        getChangeRange: () => void 0
      };
    }
    exports2.stringToSnapshot = stringToSnapshot;
    function resolveCommonLanguageId(uri) {
      const ext = uri.split(".").pop();
      switch (ext) {
        case "js":
          return "javascript";
        case "cjs":
          return "javascript";
        case "mjs":
          return "javascript";
        case "ts":
          return "typescript";
        case "cts":
          return "typescript";
        case "mts":
          return "typescript";
        case "jsx":
          return "javascriptreact";
        case "tsx":
          return "typescriptreact";
        case "pug":
          return "jade";
        case "md":
          return "markdown";
      }
      return ext;
    }
    exports2.resolveCommonLanguageId = resolveCommonLanguageId;
    function sleep(ms) {
      return new Promise((resolve) => setTimeout(resolve, ms));
    }
    exports2.sleep = sleep;
    function notEmpty(value) {
      return value !== null && value !== void 0;
    }
    exports2.notEmpty = notEmpty;
  }
});

// node_modules/@volar/language-service/lib/documents.js
var require_documents = __commonJS({
  "node_modules/@volar/language-service/lib/documents.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createDocumentsAndSourceMaps = exports2.MirrorMapWithDocument = exports2.SourceMapWithDocuments = void 0;
    var language_core_1 = require_language_core();
    var vscode_languageserver_textdocument_1 = require_main6();
    var common_1 = require_common();
    var SourceMapWithDocuments = class {
      constructor(sourceFileDocument, virtualFileDocument, map) {
        this.sourceFileDocument = sourceFileDocument;
        this.virtualFileDocument = virtualFileDocument;
        this.map = map;
      }
      // Range APIs
      toSourceRange(range, filter = () => true) {
        for (const result of this.toSourceRanges(range, filter)) {
          return result;
        }
      }
      toGeneratedRange(range, filter = () => true) {
        for (const result of this.toGeneratedRanges(range, filter)) {
          return result;
        }
      }
      *toSourceRanges(range, filter = () => true) {
        for (const result of this.toRanges(range, filter, "toSourcePositionsBase", "matchSourcePosition")) {
          yield result;
        }
      }
      *toGeneratedRanges(range, filter = () => true) {
        for (const result of this.toRanges(range, filter, "toGeneratedPositionsBase", "matchGeneratedPosition")) {
          yield result;
        }
      }
      *toRanges(range, filter, api, api2) {
        const failedLookUps = [];
        for (const mapped of this[api](range.start, filter, "left")) {
          const end = this[api2](range.end, mapped[1], "right");
          if (end) {
            yield { start: mapped[0], end };
          } else {
            failedLookUps.push(mapped);
          }
        }
        for (const failedLookUp of failedLookUps) {
          for (const mapped of this[api](range.end, filter, "right")) {
            yield { start: failedLookUp[0], end: mapped[0] };
          }
        }
      }
      // Position APIs
      toSourcePosition(position, filter = () => true, baseOffset) {
        for (const mapped of this.toSourcePositions(position, filter, baseOffset)) {
          return mapped;
        }
      }
      toGeneratedPosition(position, filter = () => true, baseOffset) {
        for (const mapped of this.toGeneratedPositions(position, filter, baseOffset)) {
          return mapped;
        }
      }
      *toSourcePositions(position, filter = () => true, baseOffset) {
        for (const mapped of this.toSourcePositionsBase(position, filter, baseOffset)) {
          yield mapped[0];
        }
      }
      *toGeneratedPositions(position, filter = () => true, baseOffset) {
        for (const mapped of this.toGeneratedPositionsBase(position, filter, baseOffset)) {
          yield mapped[0];
        }
      }
      *toSourcePositionsBase(position, filter = () => true, baseOffset) {
        let hasResult = false;
        for (const mapped of this.toPositions(position, filter, this.virtualFileDocument, this.sourceFileDocument, "generatedRange", "sourceRange", baseOffset != null ? baseOffset : "left")) {
          hasResult = true;
          yield mapped;
        }
        if (!hasResult && baseOffset === void 0) {
          for (const mapped of this.toPositions(position, filter, this.virtualFileDocument, this.sourceFileDocument, "generatedRange", "sourceRange", "right")) {
            yield mapped;
          }
        }
      }
      *toGeneratedPositionsBase(position, filter = () => true, baseOffset) {
        let hasResult = false;
        for (const mapped of this.toPositions(position, filter, this.sourceFileDocument, this.virtualFileDocument, "sourceRange", "generatedRange", baseOffset != null ? baseOffset : "left")) {
          hasResult = true;
          yield mapped;
        }
        if (!hasResult && baseOffset === void 0) {
          for (const mapped of this.toPositions(position, filter, this.sourceFileDocument, this.virtualFileDocument, "sourceRange", "generatedRange", "right")) {
            yield mapped;
          }
        }
      }
      *toPositions(position, filter, fromDoc, toDoc, from, to, baseOffset) {
        for (const mapped of this.map.matching(fromDoc.offsetAt(position), from, to, baseOffset === "right")) {
          if (!filter(mapped[1].data)) {
            continue;
          }
          yield [toDoc.positionAt(mapped[0]), mapped[1]];
        }
      }
      matchSourcePosition(position, mapping, baseOffset) {
        let offset = this.map.matchOffset(this.virtualFileDocument.offsetAt(position), mapping["generatedRange"], mapping["sourceRange"], baseOffset === "right");
        if (offset !== void 0) {
          return this.sourceFileDocument.positionAt(offset);
        }
      }
      matchGeneratedPosition(position, mapping, baseOffset) {
        let offset = this.map.matchOffset(this.sourceFileDocument.offsetAt(position), mapping["sourceRange"], mapping["generatedRange"], baseOffset === "right");
        if (offset !== void 0) {
          return this.virtualFileDocument.positionAt(offset);
        }
      }
    };
    exports2.SourceMapWithDocuments = SourceMapWithDocuments;
    var MirrorMapWithDocument = class extends SourceMapWithDocuments {
      constructor(document2, map) {
        super(document2, document2, map);
        this.document = document2;
      }
      *findMirrorPositions(start) {
        for (const mapped of this.toGeneratedPositionsBase(start)) {
          yield [mapped[0], mapped[1].data[1]];
        }
        for (const mapped of this.toSourcePositionsBase(start)) {
          yield [mapped[0], mapped[1].data[0]];
        }
      }
    };
    exports2.MirrorMapWithDocument = MirrorMapWithDocument;
    function createDocumentsAndSourceMaps(env, host, mapper) {
      let version = 0;
      const map2DocMap = /* @__PURE__ */ new WeakMap();
      const mirrorMap2DocMirrorMap = /* @__PURE__ */ new WeakMap();
      const snapshot2Doc = /* @__PURE__ */ new WeakMap();
      return {
        getSourceByUri(sourceFileUri) {
          return mapper.getSource(env.uriToFileName(sourceFileUri));
        },
        isVirtualFileUri(virtualFileUri) {
          return mapper.hasVirtualFile(env.uriToFileName(virtualFileUri));
        },
        getVirtualFileByUri(virtualFileUri) {
          return mapper.getVirtualFile(env.uriToFileName(virtualFileUri));
        },
        getMirrorMapByUri(virtualFileUri) {
          const fileName = env.uriToFileName(virtualFileUri);
          const [virtualFile] = mapper.getVirtualFile(fileName);
          if (virtualFile) {
            const map = mapper.getMirrorMap(virtualFile);
            if (map) {
              if (!mirrorMap2DocMirrorMap.has(map)) {
                mirrorMap2DocMirrorMap.set(map, new MirrorMapWithDocument(getDocumentByFileName(virtualFile.snapshot, fileName), map));
              }
              return [virtualFile, mirrorMap2DocMirrorMap.get(map)];
            }
          }
        },
        getMapsBySourceFileUri(uri) {
          return this.getMapsBySourceFileName(env.uriToFileName(uri));
        },
        getMapsBySourceFileName(fileName) {
          const source = mapper.getSource(fileName);
          if (source) {
            const result = [];
            (0, language_core_1.forEachEmbeddedFile)(source.root, (virtualFile) => {
              for (const [sourceFileName, [sourceSnapshot, map]] of mapper.getMaps(virtualFile)) {
                if (sourceSnapshot === source.snapshot) {
                  if (!map2DocMap.has(map)) {
                    map2DocMap.set(map, new SourceMapWithDocuments(getDocumentByFileName(sourceSnapshot, sourceFileName), getDocumentByFileName(virtualFile.snapshot, fileName), map));
                  }
                  result.push([virtualFile, map2DocMap.get(map)]);
                }
              }
            });
            return {
              snapshot: source.snapshot,
              maps: result
            };
          }
        },
        getMapsByVirtualFileUri(virtualFileUri) {
          return this.getMapsByVirtualFileName(env.uriToFileName(virtualFileUri));
        },
        *getMapsByVirtualFileName(virtualFileName) {
          const [virtualFile] = mapper.getVirtualFile(virtualFileName);
          if (virtualFile) {
            for (const [sourceFileName, [sourceSnapshot, map]] of mapper.getMaps(virtualFile)) {
              if (!map2DocMap.has(map)) {
                map2DocMap.set(map, new SourceMapWithDocuments(getDocumentByFileName(sourceSnapshot, sourceFileName), getDocumentByFileName(virtualFile.snapshot, virtualFileName), map));
              }
              yield [virtualFile, map2DocMap.get(map)];
            }
          }
        },
        getDocumentByUri(snapshot, uri) {
          return this.getDocumentByFileName(snapshot, env.uriToFileName(uri));
        },
        getDocumentByFileName
      };
      function getDocumentByFileName(snapshot, fileName) {
        var _a3, _b;
        if (!snapshot2Doc.has(snapshot)) {
          snapshot2Doc.set(snapshot, /* @__PURE__ */ new Map());
        }
        const map = snapshot2Doc.get(snapshot);
        if (!map.has(fileName)) {
          const uri = env.fileNameToUri(fileName);
          map.set(fileName, vscode_languageserver_textdocument_1.TextDocument.create(uri, (_b = (_a3 = host.getLanguageId) == null ? void 0 : _a3.call(host, fileName)) != null ? _b : (0, common_1.resolveCommonLanguageId)(uri), version++, snapshot.getText(0, snapshot.getLength())));
        }
        return map.get(fileName);
      }
    }
    exports2.createDocumentsAndSourceMaps = createDocumentsAndSourceMaps;
  }
});

// node_modules/@volar/language-service/lib/utils/definePlugin.js
var require_definePlugin = __commonJS({
  "node_modules/@volar/language-service/lib/utils/definePlugin.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.visitEmbedded = void 0;
    function visitEmbedded(_04, _1, _2) {
      return __async(this, arguments, function* (documents, current, cb, rootFile = current) {
        var _a3;
        for (const embedded of current.embeddedFiles) {
          if (!(yield visitEmbedded(documents, embedded, cb, rootFile))) {
            return false;
          }
        }
        for (const [_, map] of documents.getMapsByVirtualFileName(current.fileName)) {
          if (((_a3 = documents.getSourceByUri(map.sourceFileDocument.uri)) == null ? void 0 : _a3.root) === rootFile) {
            if (!(yield cb(current, map))) {
              return false;
            }
          }
        }
        return true;
      });
    }
    exports2.visitEmbedded = visitEmbedded;
  }
});

// node_modules/@volar/language-service/lib/types.js
var require_types3 = __commonJS({
  "node_modules/@volar/language-service/lib/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.RuleType = exports2.FileType = void 0;
    var FileType3;
    (function(FileType4) {
      FileType4[FileType4["Unknown"] = 0] = "Unknown";
      FileType4[FileType4["File"] = 1] = "File";
      FileType4[FileType4["Directory"] = 2] = "Directory";
      FileType4[FileType4["SymbolicLink"] = 64] = "SymbolicLink";
    })(FileType3 || (exports2.FileType = FileType3 = {}));
    var RuleType;
    (function(RuleType2) {
      RuleType2[RuleType2["Format"] = 0] = "Format";
      RuleType2[RuleType2["Syntax"] = 1] = "Syntax";
      RuleType2[RuleType2["Semantic"] = 2] = "Semantic";
    })(RuleType || (exports2.RuleType = RuleType = {}));
  }
});

// node_modules/@volar/language-service/lib/utils/featureWorkers.js
var require_featureWorkers = __commonJS({
  "node_modules/@volar/language-service/lib/utils/featureWorkers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.safeCall = exports2.ruleWorker = exports2.languageFeatureWorker = exports2.documentFeatureWorker = void 0;
    var definePlugin_1 = require_definePlugin();
    var types_1 = require_types3();
    function documentFeatureWorker(context, uri, isValidSourceMap, worker, transform, combineResult) {
      return __async(this, null, function* () {
        return languageFeatureWorker2(context, uri, void 0, (_, map, file) => {
          if (isValidSourceMap(file, map)) {
            return [void 0];
          }
          return [];
        }, worker, transform, combineResult);
      });
    }
    exports2.documentFeatureWorker = documentFeatureWorker;
    function languageFeatureWorker2(context, uri, arg, transformArg, worker, transform, combineResult, reportProgress) {
      return __async(this, null, function* () {
        var _a3;
        const document2 = context.getTextDocument(uri);
        const virtualFile = (_a3 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a3.root;
        let results = [];
        if (virtualFile) {
          yield (0, definePlugin_1.visitEmbedded)(context.documents, virtualFile, (file, map) => __async(this, null, function* () {
            for (const mappedArg of transformArg(arg, map, file)) {
              for (const [serviceId, service] of Object.entries(context.services)) {
                const embeddedResult = yield safeCall(() => worker(service, map.virtualFileDocument, mappedArg, map, file), "service " + serviceId + " crashed on " + map.virtualFileDocument.uri);
                if (!embeddedResult)
                  continue;
                const result = transform(embeddedResult, map);
                if (!result)
                  continue;
                results.push(result);
                if (!combineResult)
                  return false;
                const isEmptyArray = Array.isArray(result) && result.length === 0;
                if (reportProgress && !isEmptyArray) {
                  reportProgress(combineResult(results));
                }
              }
            }
            return true;
          }));
        } else if (document2) {
          for (const [serviceId, service] of Object.entries(context.services)) {
            const embeddedResult = yield safeCall(() => worker(service, document2, arg, void 0, void 0), "service " + serviceId + " crashed on " + uri);
            if (!embeddedResult)
              continue;
            const result = transform(embeddedResult, void 0);
            if (!result)
              continue;
            results.push(result);
            if (!combineResult)
              break;
            const isEmptyArray = Array.isArray(result) && result.length === 0;
            if (reportProgress && !isEmptyArray) {
              reportProgress(combineResult(results));
            }
          }
        }
        if (combineResult && results.length > 0) {
          return combineResult(results);
        } else if (results.length > 0) {
          return results[0];
        }
      });
    }
    exports2.languageFeatureWorker = languageFeatureWorker2;
    function ruleWorker(context, ruleType, uri, isValidSourceMap, worker, transform, combineResult, reportProgress) {
      return __async(this, null, function* () {
        var _a3, _b;
        const document2 = context.getTextDocument(uri);
        const virtualFile = (_a3 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a3.root;
        const ruleCtx = {
          env: context.env,
          inject: context.inject,
          report: () => {
          }
        };
        let results = [];
        if (virtualFile) {
          yield (0, definePlugin_1.visitEmbedded)(context.documents, virtualFile, (file, map) => __async(this, null, function* () {
            var _a4;
            if (!isValidSourceMap(file)) {
              return true;
            }
            for (const ruleId in context.rules) {
              const rule = context.rules[ruleId];
              if (((_a4 = rule.type) != null ? _a4 : types_1.RuleType.Syntax) !== ruleType) {
                continue;
              }
              const embeddedResult = yield safeCall(() => worker(ruleId, rule, map.virtualFileDocument, ruleCtx), "rule " + ruleId + " crashed on " + map.virtualFileDocument.uri);
              if (!embeddedResult)
                continue;
              const result = transform(embeddedResult, map);
              if (!result)
                continue;
              results.push(result);
              if (!combineResult)
                return false;
              const isEmptyArray = Array.isArray(result) && result.length === 0;
              if (reportProgress && !isEmptyArray) {
                reportProgress(combineResult(results));
              }
            }
            return true;
          }));
        } else if (document2) {
          for (const ruleId in context.rules) {
            const rule = context.rules[ruleId];
            if (((_b = rule.type) != null ? _b : types_1.RuleType.Syntax) !== ruleType) {
              continue;
            }
            const embeddedResult = yield safeCall(() => worker(ruleId, rule, document2, ruleCtx), "rule " + ruleId + " crashed on " + document2.uri);
            if (!embeddedResult)
              continue;
            const result = transform(embeddedResult, void 0);
            if (!result)
              continue;
            results.push(result);
            if (!combineResult)
              break;
            const isEmptyArray = Array.isArray(result) && result.length === 0;
            if (reportProgress && !isEmptyArray) {
              reportProgress(combineResult(results));
            }
          }
        }
        if (combineResult && results.length > 0) {
          return combineResult(results);
        } else if (results.length > 0) {
          return results[0];
        }
      });
    }
    exports2.ruleWorker = ruleWorker;
    function safeCall(cb, errorMsg) {
      return __async(this, null, function* () {
        try {
          return yield cb();
        } catch (err) {
          console.warn(errorMsg, err);
        }
      });
    }
    exports2.safeCall = safeCall;
  }
});

// node_modules/@volar/language-service/lib/utils/cancellation.js
var require_cancellation2 = __commonJS({
  "node_modules/@volar/language-service/lib/utils/cancellation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.NoneCancellationToken = void 0;
    exports2.NoneCancellationToken = {
      isCancellationRequested: false,
      onCancellationRequested: () => ({ dispose: () => {
      } })
    };
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/autoInsert.js
var require_autoInsert = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/autoInsert.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, autoInsertContext, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, { position, autoInsertContext }, function* (arg, map) {
          var _a3;
          for (const position2 of map.toGeneratedPositions(arg.position, (data) => !!data.completion)) {
            const rangeOffset = (_a3 = map.map.toGeneratedOffset(arg.autoInsertContext.lastChange.rangeOffset)) == null ? void 0 : _a3[0];
            const range = map.toGeneratedRange(arg.autoInsertContext.lastChange.range);
            if (rangeOffset !== void 0 && range) {
              yield {
                position: position2,
                autoInsertContext: {
                  lastChange: __spreadProps(__spreadValues({}, arg.autoInsertContext.lastChange), {
                    rangeOffset,
                    range
                  })
                }
              };
              break;
            }
          }
        }, (service, document2, arg) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideAutoInsertionEdit) == null ? void 0 : _a3.call(service, document2, arg.position, arg.autoInsertContext, token);
        }, (item, map) => {
          if (!map || typeof item === "string")
            return item;
          const range = map.toSourceRange(item.range);
          if (range) {
            item.range = range;
            return item;
          }
        });
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/utils/dedupe.js
var require_dedupe = __commonJS({
  "node_modules/@volar/language-service/lib/utils/dedupe.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.withRanges = exports2.withCallHierarchyOutgoingCalls = exports2.withCallHierarchyIncomingCalls = exports2.withLocationLinks = exports2.withLocations = exports2.withDiagnostics = exports2.withDocumentChanges = exports2.withTextEdits = exports2.withCodeAction = exports2.createLocationSet = void 0;
    function createLocationSet() {
      const set = /* @__PURE__ */ new Set();
      return {
        add,
        has
      };
      function add(item) {
        if (has(item)) {
          return false;
        }
        set.add(getKey(item));
        return true;
      }
      function has(item) {
        return set.has(getKey(item));
      }
      function getKey(item) {
        return [
          item.uri,
          item.range.start.line,
          item.range.start.character,
          item.range.end.line,
          item.range.end.character
        ].join(":");
      }
    }
    exports2.createLocationSet = createLocationSet;
    function withCodeAction(items) {
      return dedupe(items, (item) => [
        item.title
      ].join(":"));
    }
    exports2.withCodeAction = withCodeAction;
    function withTextEdits(items) {
      return dedupe(items, (item) => [
        item.range.start.line,
        item.range.start.character,
        item.range.end.line,
        item.range.end.character,
        item.newText
      ].join(":"));
    }
    exports2.withTextEdits = withTextEdits;
    function withDocumentChanges(items) {
      return dedupe(items, (item) => JSON.stringify(item));
    }
    exports2.withDocumentChanges = withDocumentChanges;
    function withDiagnostics(items) {
      return dedupe(items, (item) => [
        item.range.start.line,
        item.range.start.character,
        item.range.end.line,
        item.range.end.character,
        item.source,
        item.code,
        item.severity,
        item.message
      ].join(":"));
    }
    exports2.withDiagnostics = withDiagnostics;
    function withLocations(items) {
      return dedupe(items, (item) => [
        item.uri,
        item.range.start.line,
        item.range.start.character,
        item.range.end.line,
        item.range.end.character
      ].join(":"));
    }
    exports2.withLocations = withLocations;
    function withLocationLinks(items) {
      return dedupe(items, (item) => [
        item.targetUri,
        item.targetSelectionRange.start.line,
        item.targetSelectionRange.start.character,
        item.targetSelectionRange.end.line,
        item.targetSelectionRange.end.character
        // ignore difference targetRange
      ].join(":"));
    }
    exports2.withLocationLinks = withLocationLinks;
    function withCallHierarchyIncomingCalls(items) {
      return dedupe(items, (item) => [
        item.from.uri,
        item.from.range.start.line,
        item.from.range.start.character,
        item.from.range.end.line,
        item.from.range.end.character
      ].join(":"));
    }
    exports2.withCallHierarchyIncomingCalls = withCallHierarchyIncomingCalls;
    function withCallHierarchyOutgoingCalls(items) {
      return dedupe(items, (item) => [
        item.to.uri,
        item.to.range.start.line,
        item.to.range.start.character,
        item.to.range.end.line,
        item.to.range.end.character
      ].join(":"));
    }
    exports2.withCallHierarchyOutgoingCalls = withCallHierarchyOutgoingCalls;
    function withRanges(items) {
      return dedupe(items, (item) => [
        item.start.line,
        item.start.character,
        item.end.line,
        item.end.character
      ].join(":"));
    }
    exports2.withRanges = withRanges;
    function dedupe(items, getKey) {
      const map = /* @__PURE__ */ new Map();
      for (const item of items.reverse()) {
        map.set(getKey(item), item);
      }
      return [...map.values()];
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/callHierarchy.js
var require_callHierarchy2 = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/callHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var common_1 = require_common();
    var dedupe = require_dedupe();
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return {
        doPrepare(uri, position, token = cancellation_1.NoneCancellationToken) {
          return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => !!data.references), (service, document2, position2, map) => __async(this, null, function* () {
            var _a4;
            if (token.isCancellationRequested)
              return;
            const items = yield (_a4 = service.provideCallHierarchyItems) == null ? void 0 : _a4.call(service, document2, position2, token);
            items == null ? void 0 : items.forEach((item) => {
              item.data = {
                uri,
                original: {
                  data: item.data
                },
                serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
                virtualDocumentUri: map == null ? void 0 : map.virtualFileDocument.uri
              };
            });
            return items;
          }), (data, sourceMap) => !sourceMap ? data : data.map((item) => {
            var _a4;
            return (_a4 = transformCallHierarchyItem(item, [])) == null ? void 0 : _a4[0];
          }).filter(common_1.notEmpty), (arr) => dedupe.withLocations(arr.flat()));
        },
        getIncomingCalls(item, token) {
          return __async(this, null, function* () {
            const data = item.data;
            let incomingItems = [];
            if (data) {
              const service = context.services[data.serviceId];
              if (!service.provideCallHierarchyIncomingCalls)
                return incomingItems;
              Object.assign(item, data.original);
              if (data.virtualDocumentUri) {
                if (context.documents.isVirtualFileUri(data.virtualDocumentUri)) {
                  const _calls = yield service.provideCallHierarchyIncomingCalls(item, token);
                  for (const _call of _calls) {
                    const calls = transformCallHierarchyItem(_call.from, _call.fromRanges);
                    if (!calls)
                      continue;
                    incomingItems.push({
                      from: calls[0],
                      fromRanges: calls[1]
                    });
                  }
                }
              } else {
                const _calls = yield service.provideCallHierarchyIncomingCalls(item, token);
                for (const _call of _calls) {
                  const calls = transformCallHierarchyItem(_call.from, _call.fromRanges);
                  if (!calls)
                    continue;
                  incomingItems.push({
                    from: calls[0],
                    fromRanges: calls[1]
                  });
                }
              }
            }
            return dedupe.withCallHierarchyIncomingCalls(incomingItems);
          });
        },
        getOutgoingCalls(item, token) {
          return __async(this, null, function* () {
            const data = item.data;
            let items = [];
            if (data) {
              const service = context.services[data.serviceId];
              if (!service.provideCallHierarchyOutgoingCalls)
                return items;
              Object.assign(item, data.original);
              if (data.virtualDocumentUri) {
                if (context.documents.isVirtualFileUri(data.virtualDocumentUri)) {
                  const _calls = yield service.provideCallHierarchyOutgoingCalls(item, token);
                  for (const call of _calls) {
                    const calls = transformCallHierarchyItem(call.to, call.fromRanges);
                    if (!calls)
                      continue;
                    items.push({
                      to: calls[0],
                      fromRanges: calls[1]
                    });
                  }
                }
              } else {
                const _calls = yield service.provideCallHierarchyOutgoingCalls(item, token);
                for (const call of _calls) {
                  const calls = transformCallHierarchyItem(call.to, call.fromRanges);
                  if (!calls)
                    continue;
                  items.push({
                    to: calls[0],
                    fromRanges: calls[1]
                  });
                }
              }
            }
            return dedupe.withCallHierarchyOutgoingCalls(items);
          });
        }
      };
      function transformCallHierarchyItem(tsItem, tsRanges) {
        if (!context.documents.isVirtualFileUri(tsItem.uri))
          return [tsItem, tsRanges];
        for (const [_, map] of context.documents.getMapsByVirtualFileUri(tsItem.uri)) {
          let range = map.toSourceRange(tsItem.range);
          if (!range) {
            range = {
              start: map.sourceFileDocument.positionAt(0),
              end: map.sourceFileDocument.positionAt(map.sourceFileDocument.getText().length)
            };
          }
          const selectionRange = map.toSourceRange(tsItem.selectionRange);
          if (!selectionRange)
            continue;
          const vueRanges = tsRanges.map((tsRange) => map.toSourceRange(tsRange)).filter(common_1.notEmpty);
          const vueItem = __spreadProps(__spreadValues({}, tsItem), {
            name: tsItem.name === map.virtualFileDocument.uri.substring(map.virtualFileDocument.uri.lastIndexOf("/") + 1) ? map.sourceFileDocument.uri.substring(map.sourceFileDocument.uri.lastIndexOf("/") + 1) : tsItem.name,
            uri: map.sourceFileDocument.uri,
            // TS Bug: `range: range` not works
            range: {
              start: range.start,
              end: range.end
            },
            selectionRange: {
              start: selectionRange.start,
              end: selectionRange.end
            }
          });
          selectionRange.end;
          return [vueItem, vueRanges];
        }
      }
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/rename.js
var require_rename = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/rename.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.embeddedEditToSourceEdit = exports2.mergeWorkspaceEdits = exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var dedupe = require_dedupe();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, newName, token = cancellation_1.NoneCancellationToken) => {
        let _data;
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, { position, newName }, function* (arg, map) {
          for (const mapped of map.toGeneratedPositions(arg.position, (data) => {
            _data = data;
            return typeof data.rename === "object" ? !!data.rename.normalize : !!data.rename;
          })) {
            let newName2 = arg.newName;
            if (_data && typeof _data.rename === "object" && _data.rename.normalize) {
              newName2 = _data.rename.normalize(arg.newName);
            }
            yield { position: mapped, newName: newName2 };
          }
          ;
        }, (service, document2, arg) => __async(this, null, function* () {
          if (token.isCancellationRequested)
            return;
          const recursiveChecker = dedupe.createLocationSet();
          let result;
          yield withMirrors(document2, arg.position, arg.newName);
          return result;
          function withMirrors(document3, position2, newName2) {
            return __async(this, null, function* () {
              var _a3;
              if (!service.provideRenameEdits)
                return;
              if (recursiveChecker.has({ uri: document3.uri, range: { start: position2, end: position2 } }))
                return;
              recursiveChecker.add({ uri: document3.uri, range: { start: position2, end: position2 } });
              const workspaceEdit = yield service.provideRenameEdits(document3, position2, newName2, token);
              if (!workspaceEdit)
                return;
              if (!result)
                result = {};
              if (workspaceEdit.changes) {
                for (const editUri in workspaceEdit.changes) {
                  const textEdits = workspaceEdit.changes[editUri];
                  for (const textEdit of textEdits) {
                    let foundMirrorPosition = false;
                    recursiveChecker.add({ uri: editUri, range: { start: textEdit.range.start, end: textEdit.range.start } });
                    const mirrorMap = (_a3 = context.documents.getMirrorMapByUri(editUri)) == null ? void 0 : _a3[1];
                    if (mirrorMap) {
                      for (const mapped of mirrorMap.findMirrorPositions(textEdit.range.start)) {
                        if (!mapped[1].rename)
                          continue;
                        if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                          continue;
                        foundMirrorPosition = true;
                        yield withMirrors(mirrorMap.document, mapped[0], newName2);
                      }
                    }
                    if (!foundMirrorPosition) {
                      if (!result.changes)
                        result.changes = {};
                      if (!result.changes[editUri])
                        result.changes[editUri] = [];
                      result.changes[editUri].push(textEdit);
                    }
                  }
                }
              }
              if (workspaceEdit.changeAnnotations) {
                for (const uri2 in workspaceEdit.changeAnnotations) {
                  if (!result.changeAnnotations)
                    result.changeAnnotations = {};
                  result.changeAnnotations[uri2] = workspaceEdit.changeAnnotations[uri2];
                }
              }
              if (workspaceEdit.documentChanges) {
                if (!result.documentChanges)
                  result.documentChanges = [];
                result.documentChanges = result.documentChanges.concat(workspaceEdit.documentChanges);
              }
            });
          }
        }), (data) => {
          return embeddedEditToSourceEdit(data, context.documents, "rename");
        }, (workspaceEdits) => {
          const mainEdit = workspaceEdits[0];
          const otherEdits = workspaceEdits.slice(1);
          mergeWorkspaceEdits(mainEdit, ...otherEdits);
          if (mainEdit.changes) {
            for (const uri2 in mainEdit.changes) {
              mainEdit.changes[uri2] = dedupe.withTextEdits(mainEdit.changes[uri2]);
            }
          }
          return workspaceEdits[0];
        });
      };
    }
    exports2.register = register;
    function mergeWorkspaceEdits(original, ...others) {
      for (const other of others) {
        for (const uri in other.changeAnnotations) {
          if (!original.changeAnnotations) {
            original.changeAnnotations = {};
          }
          original.changeAnnotations[uri] = other.changeAnnotations[uri];
        }
        for (const uri in other.changes) {
          if (!original.changes) {
            original.changes = {};
          }
          if (!original.changes[uri]) {
            original.changes[uri] = [];
          }
          const edits = other.changes[uri];
          original.changes[uri] = original.changes[uri].concat(edits);
        }
        if (other.documentChanges) {
          if (!original.documentChanges) {
            original.documentChanges = [];
          }
          for (const docChange of other.documentChanges) {
            pushEditToDocumentChanges(original.documentChanges, docChange);
          }
        }
      }
    }
    exports2.mergeWorkspaceEdits = mergeWorkspaceEdits;
    function embeddedEditToSourceEdit(tsResult, documents, mode, versions = {}) {
      var _a3, _b, _c, _d, _e, _f2, _g, _h, _i, _j;
      const sourceResult = {};
      let hasResult = false;
      for (const tsUri in tsResult.changeAnnotations) {
        (_a3 = sourceResult.changeAnnotations) != null ? _a3 : sourceResult.changeAnnotations = {};
        const tsAnno = tsResult.changeAnnotations[tsUri];
        if (!documents.isVirtualFileUri(tsUri)) {
          sourceResult.changeAnnotations[tsUri] = tsAnno;
        } else {
          for (const [_, map] of documents.getMapsByVirtualFileUri(tsUri)) {
            const uri = map.sourceFileDocument.uri;
            sourceResult.changeAnnotations[uri] = tsAnno;
          }
        }
      }
      for (const tsUri in tsResult.changes) {
        (_b = sourceResult.changes) != null ? _b : sourceResult.changes = {};
        if (!documents.isVirtualFileUri(tsUri)) {
          sourceResult.changes[tsUri] = tsResult.changes[tsUri];
          hasResult = true;
          continue;
        }
        for (const [_, map] of documents.getMapsByVirtualFileUri(tsUri)) {
          const tsEdits = tsResult.changes[tsUri];
          for (const tsEdit of tsEdits) {
            if (mode === "rename" || mode === "fileName" || mode === "codeAction") {
              let _data;
              const range = map.toSourceRange(tsEdit.range, (data) => {
                _data = data;
                return typeof data.rename === "object" ? !!data.rename.apply : !!data.rename;
              });
              if (range) {
                let newText = tsEdit.newText;
                if (_data && typeof _data.rename === "object" && _data.rename.apply) {
                  newText = _data.rename.apply(tsEdit.newText);
                }
                (_e = (_c = sourceResult.changes)[_d = map.sourceFileDocument.uri]) != null ? _e : _c[_d] = [];
                sourceResult.changes[map.sourceFileDocument.uri].push({ newText, range });
                hasResult = true;
              }
            } else {
              const range = map.toSourceRange(tsEdit.range);
              if (range) {
                (_h = (_f2 = sourceResult.changes)[_g = map.sourceFileDocument.uri]) != null ? _h : _f2[_g] = [];
                sourceResult.changes[map.sourceFileDocument.uri].push({ newText: tsEdit.newText, range });
                hasResult = true;
              }
            }
          }
        }
      }
      if (tsResult.documentChanges) {
        for (const tsDocEdit of tsResult.documentChanges) {
          (_i = sourceResult.documentChanges) != null ? _i : sourceResult.documentChanges = [];
          let sourceEdit;
          if ("textDocument" in tsDocEdit) {
            if (documents.isVirtualFileUri(tsDocEdit.textDocument.uri)) {
              for (const [_, map] of documents.getMapsByVirtualFileUri(tsDocEdit.textDocument.uri)) {
                sourceEdit = {
                  textDocument: {
                    uri: map.sourceFileDocument.uri,
                    version: (_j = versions[map.sourceFileDocument.uri]) != null ? _j : null
                  },
                  edits: []
                };
                for (const tsEdit of tsDocEdit.edits) {
                  if (mode === "rename" || mode === "fileName" || mode === "codeAction") {
                    let _data;
                    const range = map.toSourceRange(tsEdit.range, (data) => {
                      _data = data;
                      return typeof data.rename === "object" ? !!data.rename.apply : !!data.rename;
                    });
                    if (range) {
                      let newText = tsEdit.newText;
                      if (_data && typeof _data.rename === "object" && _data.rename.apply) {
                        newText = _data.rename.apply(tsEdit.newText);
                      }
                      sourceEdit.edits.push({
                        annotationId: "annotationId" in tsEdit ? tsEdit.annotationId : void 0,
                        newText,
                        range
                      });
                    }
                  } else {
                    const range = map.toSourceRange(tsEdit.range);
                    if (range) {
                      sourceEdit.edits.push({
                        annotationId: "annotationId" in tsEdit ? tsEdit.annotationId : void 0,
                        newText: tsEdit.newText,
                        range
                      });
                    }
                  }
                }
                if (!sourceEdit.edits.length) {
                  sourceEdit = void 0;
                }
              }
            } else {
              sourceEdit = tsDocEdit;
            }
          } else if (tsDocEdit.kind === "create") {
            sourceEdit = tsDocEdit;
          } else if (tsDocEdit.kind === "rename") {
            if (!documents.isVirtualFileUri(tsDocEdit.oldUri)) {
              sourceEdit = tsDocEdit;
            } else {
              for (const [_, map] of documents.getMapsByVirtualFileUri(tsDocEdit.oldUri)) {
                sourceEdit = {
                  kind: "rename",
                  oldUri: map.sourceFileDocument.uri,
                  newUri: tsDocEdit.newUri,
                  options: tsDocEdit.options,
                  annotationId: tsDocEdit.annotationId
                };
              }
            }
          } else if (tsDocEdit.kind === "delete") {
            if (!documents.isVirtualFileUri(tsDocEdit.uri)) {
              sourceEdit = tsDocEdit;
            } else {
              for (const [_, map] of documents.getMapsByVirtualFileUri(tsDocEdit.uri)) {
                sourceEdit = {
                  kind: "delete",
                  uri: map.sourceFileDocument.uri,
                  options: tsDocEdit.options,
                  annotationId: tsDocEdit.annotationId
                };
              }
            }
          }
          if (sourceEdit) {
            pushEditToDocumentChanges(sourceResult.documentChanges, sourceEdit);
            hasResult = true;
          }
        }
      }
      if (hasResult) {
        return sourceResult;
      }
    }
    exports2.embeddedEditToSourceEdit = embeddedEditToSourceEdit;
    function pushEditToDocumentChanges(arr, item) {
      const current = arr.find((edit) => "textDocument" in edit && "textDocument" in item && edit.textDocument.uri === item.textDocument.uri);
      if (current) {
        current.edits.push(...item.edits);
      } else {
        arr.push(item);
      }
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/codeActionResolve.js
var require_codeActionResolve = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/codeActionResolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var rename_1 = require_rename();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (item, token = cancellation_1.NoneCancellationToken) {
        var _a3, _b, _c, _d, _e, _f2, _g, _h;
        const data = item.data;
        if ((data == null ? void 0 : data.type) === "service") {
          const service = context.services[data.serviceId];
          if (!service.resolveCodeAction)
            return item;
          Object.assign(item, data.original);
          item = yield service.resolveCodeAction(item, token);
          item = (_b = (_a3 = service.transformCodeAction) == null ? void 0 : _a3.call(service, item)) != null ? _b : item.edit ? __spreadProps(__spreadValues({}, item), {
            edit: (0, rename_1.embeddedEditToSourceEdit)(item.edit, context.documents, "codeAction", { [data.uri]: data.version })
          }) : item;
        }
        if ((data == null ? void 0 : data.type) === "rule") {
          const fixes = (_e = (_d = (_c = context.ruleFixes) == null ? void 0 : _c[data.documentUri]) == null ? void 0 : _d[data.ruleId]) == null ? void 0 : _e[data.ruleFixIndex];
          const fix = fixes == null ? void 0 : fixes[1][data.index];
          if (fix) {
            let edit = (_g = yield (_f2 = fix.getWorkspaceEdit) == null ? void 0 : _f2.call(fix, fixes[0])) != null ? _g : void 0;
            if (!edit) {
              const edits = yield (_h = fix.getEdits) == null ? void 0 : _h.call(fix, fixes[0]);
              if (edits) {
                edit = {
                  documentChanges: [{
                    textDocument: {
                      uri: data.documentUri,
                      version: null
                    },
                    edits
                  }]
                };
              }
            }
            if (edit) {
              item.edit = (0, rename_1.embeddedEditToSourceEdit)(edit, context.documents, data.isFormat ? "format" : "codeAction", { [data.uri]: data.version });
            }
          }
        }
        return item;
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/transformer/textEdit.js
var require_textEdit = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/textEdit.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(textEdit, getOtherRange, document2) {
      if ("range" in textEdit) {
        let range = getOtherRange(textEdit.range);
        if (range) {
          return __spreadProps(__spreadValues({}, textEdit), {
            range
          });
        }
        ;
        const cover = tryRecover(getOtherRange, textEdit.range, textEdit.newText, document2);
        if (cover) {
          return __spreadProps(__spreadValues({}, textEdit), {
            range: cover.range,
            newText: cover.newText
          });
        }
      } else if ("replace" in textEdit && "insert" in textEdit) {
        const insert = getOtherRange(textEdit.insert);
        const replace = insert ? getOtherRange(textEdit.replace) : void 0;
        if (insert && replace) {
          return __spreadProps(__spreadValues({}, textEdit), {
            insert,
            replace
          });
        }
        const recoverInsert = tryRecover(getOtherRange, textEdit.insert, textEdit.newText, document2);
        const recoverReplace = recoverInsert ? tryRecover(getOtherRange, textEdit.replace, textEdit.newText, document2) : void 0;
        if (recoverInsert && recoverReplace && recoverInsert.newText === recoverReplace.newText) {
          return __spreadProps(__spreadValues({}, textEdit), {
            insert: recoverInsert.range,
            replace: recoverReplace.range,
            newText: recoverInsert.newText
          });
        }
      }
    }
    exports2.transform = transform;
    function tryRecover(getOtherRange, replaceRange, newText, document2) {
      if (replaceRange.start.line === replaceRange.end.line && replaceRange.end.character > replaceRange.start.character) {
        let character = replaceRange.start.character;
        while (newText.length && replaceRange.end.character > character) {
          const newStart = { line: replaceRange.start.line, character: replaceRange.start.character + 1 };
          if (document2.getText({ start: replaceRange.start, end: newStart }) === newText[0]) {
            newText = newText.slice(1);
            character++;
            const otherRange = getOtherRange({ start: newStart, end: replaceRange.end });
            if (otherRange) {
              return {
                newText,
                range: otherRange
              };
            }
          } else {
            break;
          }
        }
      }
    }
  }
});

// node_modules/@volar/language-service/lib/transformer/completionItem.js
var require_completionItem = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/completionItem.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    var common_1 = require_common();
    var textEdit_1 = require_textEdit();
    function transform(item, getOtherRange, document2) {
      var _a3;
      return __spreadProps(__spreadValues({}, item), {
        additionalTextEdits: (_a3 = item.additionalTextEdits) == null ? void 0 : _a3.map((edit) => (0, textEdit_1.transform)(edit, getOtherRange, document2)).filter(common_1.notEmpty),
        textEdit: item.textEdit ? (0, textEdit_1.transform)(item.textEdit, getOtherRange, document2) : void 0
      });
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/completionList.js
var require_completionList = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/completionList.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    var completionItem_1 = require_completionItem();
    function transform(completionList, getOtherRange, document2, onItem) {
      return {
        isIncomplete: completionList.isIncomplete,
        itemDefaults: completionList.itemDefaults ? __spreadProps(__spreadValues({}, completionList.itemDefaults), {
          editRange: completionList.itemDefaults.editRange ? "replace" in completionList.itemDefaults.editRange ? {
            insert: getOtherRange(completionList.itemDefaults.editRange.insert),
            replace: getOtherRange(completionList.itemDefaults.editRange.replace)
          } : getOtherRange(completionList.itemDefaults.editRange) : void 0
        }) : void 0,
        items: completionList.items.map((item) => {
          const newItem = (0, completionItem_1.transform)(item, getOtherRange, document2);
          onItem == null ? void 0 : onItem(newItem, item);
          return newItem;
        })
      };
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/foldingRanges.js
var require_foldingRanges = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/foldingRanges.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(ranges, getOtherRange) {
      var _a3, _b;
      const result = [];
      for (const range of ranges) {
        const otherRange = getOtherRange({
          start: { line: range.startLine, character: (_a3 = range.startCharacter) != null ? _a3 : 0 },
          end: { line: range.endLine, character: (_b = range.endCharacter) != null ? _b : 0 }
        });
        if (otherRange) {
          range.startLine = otherRange.start.line;
          range.endLine = otherRange.end.line;
          if (range.startCharacter !== void 0)
            range.startCharacter = otherRange.start.character;
          if (range.endCharacter !== void 0)
            range.endCharacter = otherRange.end.character;
          result.push(range);
        }
      }
      return result;
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/hover.js
var require_hover = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/hover.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(hover, getOtherRange) {
      if (!(hover == null ? void 0 : hover.range)) {
        return hover;
      }
      const range = getOtherRange(hover.range);
      if (!range)
        return;
      return __spreadProps(__spreadValues({}, hover), {
        range
      });
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/locationLike.js
var require_locationLike = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/locationLike.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(location, getOtherRange) {
      const range = getOtherRange(location.range);
      if (!range)
        return;
      return __spreadProps(__spreadValues({}, location), {
        range
      });
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/locationsLike.js
var require_locationsLike = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/locationsLike.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    var common_1 = require_common();
    var locationLike_1 = require_locationLike();
    function transform(locations, getOtherRange) {
      return locations.map((location) => (0, locationLike_1.transform)(location, getOtherRange)).filter(common_1.notEmpty);
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/selectionRange.js
var require_selectionRange = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/selectionRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(location, getOtherRange) {
      const range = getOtherRange(location.range);
      if (!range)
        return;
      const parent = location.parent ? transform(location.parent, getOtherRange) : void 0;
      return {
        range,
        parent
      };
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/selectionRanges.js
var require_selectionRanges = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/selectionRanges.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    var common_1 = require_common();
    var selectionRange_1 = require_selectionRange();
    function transform(locations, getOtherRange) {
      return locations.map((location) => (0, selectionRange_1.transform)(location, getOtherRange)).filter(common_1.notEmpty);
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/documentSymbol.js
var require_documentSymbol = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/documentSymbol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    var common_1 = require_common();
    function transform(symbol, getOtherRange) {
      var _a3;
      const range = getOtherRange(symbol.range);
      if (!range) {
        return;
      }
      const selectionRange = getOtherRange(symbol.selectionRange);
      if (!selectionRange) {
        return;
      }
      return __spreadProps(__spreadValues({}, symbol), {
        range,
        selectionRange,
        children: (_a3 = symbol.children) == null ? void 0 : _a3.map((child) => transform(child, getOtherRange)).filter(common_1.notEmpty)
      });
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/workspaceSymbol.js
var require_workspaceSymbol = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/workspaceSymbol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transform = void 0;
    function transform(symbol, getOtherLocation) {
      if (!("range" in symbol.location)) {
        return symbol;
      }
      const loc = getOtherLocation(symbol.location);
      if (!loc) {
        return;
      }
      return __spreadProps(__spreadValues({}, symbol), {
        location: loc
      });
    }
    exports2.transform = transform;
  }
});

// node_modules/@volar/language-service/lib/transformer/index.js
var require_transformer = __commonJS({
  "node_modules/@volar/language-service/lib/transformer/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.asWorkspaceSymbol = exports2.asDocumentSymbol = exports2.asTextEdit = exports2.asSelectionRanges = exports2.asSelectionRange = exports2.asLocations = exports2.asLocation = exports2.asHover = exports2.asFoldingRanges = exports2.asCompletionList = exports2.asCompletionItem = void 0;
    var completionItem_1 = require_completionItem();
    Object.defineProperty(exports2, "asCompletionItem", { enumerable: true, get: function() {
      return completionItem_1.transform;
    } });
    var completionList_1 = require_completionList();
    Object.defineProperty(exports2, "asCompletionList", { enumerable: true, get: function() {
      return completionList_1.transform;
    } });
    var foldingRanges_1 = require_foldingRanges();
    Object.defineProperty(exports2, "asFoldingRanges", { enumerable: true, get: function() {
      return foldingRanges_1.transform;
    } });
    var hover_1 = require_hover();
    Object.defineProperty(exports2, "asHover", { enumerable: true, get: function() {
      return hover_1.transform;
    } });
    var locationLike_1 = require_locationLike();
    Object.defineProperty(exports2, "asLocation", { enumerable: true, get: function() {
      return locationLike_1.transform;
    } });
    var locationsLike_1 = require_locationsLike();
    Object.defineProperty(exports2, "asLocations", { enumerable: true, get: function() {
      return locationsLike_1.transform;
    } });
    var selectionRange_1 = require_selectionRange();
    Object.defineProperty(exports2, "asSelectionRange", { enumerable: true, get: function() {
      return selectionRange_1.transform;
    } });
    var selectionRanges_1 = require_selectionRanges();
    Object.defineProperty(exports2, "asSelectionRanges", { enumerable: true, get: function() {
      return selectionRanges_1.transform;
    } });
    var textEdit_1 = require_textEdit();
    Object.defineProperty(exports2, "asTextEdit", { enumerable: true, get: function() {
      return textEdit_1.transform;
    } });
    var documentSymbol_1 = require_documentSymbol();
    Object.defineProperty(exports2, "asDocumentSymbol", { enumerable: true, get: function() {
      return documentSymbol_1.transform;
    } });
    var workspaceSymbol_1 = require_workspaceSymbol();
    Object.defineProperty(exports2, "asWorkspaceSymbol", { enumerable: true, get: function() {
      return workspaceSymbol_1.transform;
    } });
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/codeActions.js
var require_codeActions = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/codeActions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var transformer = require_transformer();
    var common_1 = require_common();
    var dedupe = require_dedupe();
    var featureWorkers_1 = require_featureWorkers();
    var rename_1 = require_rename();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, _1, _2, ..._3) => __async(this, [_04, _1, _2, ..._3], function* (uri, range, codeActionContext, token = cancellation_1.NoneCancellationToken) {
        var _a3, _b, _c, _d, _e;
        const sourceDocument = context.getTextDocument(uri);
        if (!sourceDocument)
          return;
        const offsetRange = {
          start: sourceDocument.offsetAt(range.start),
          end: sourceDocument.offsetAt(range.end)
        };
        const transformedCodeActions = /* @__PURE__ */ new WeakSet();
        const pluginActions = yield (0, featureWorkers_1.languageFeatureWorker)(context, uri, { range, codeActionContext }, (_arg, map, file) => {
          var _a4, _b2;
          if (!file.capabilities.codeAction)
            return [];
          const _codeActionContext = {
            diagnostics: transformer.asLocations(codeActionContext.diagnostics, (range2) => map.toGeneratedRange(range2)),
            only: codeActionContext.only
          };
          let minStart;
          let maxEnd;
          for (const mapping of map.map.mappings) {
            const overlapRange = (0, common_1.getOverlapRange)(offsetRange.start, offsetRange.end, mapping.sourceRange[0], mapping.sourceRange[1]);
            if (overlapRange) {
              const start = (_a4 = map.map.toGeneratedOffset(overlapRange.start)) == null ? void 0 : _a4[0];
              const end = (_b2 = map.map.toGeneratedOffset(overlapRange.end)) == null ? void 0 : _b2[0];
              if (start !== void 0 && end !== void 0) {
                minStart = minStart === void 0 ? start : Math.min(start, minStart);
                maxEnd = maxEnd === void 0 ? end : Math.max(end, maxEnd);
              }
            }
          }
          if (minStart !== void 0 && maxEnd !== void 0) {
            return [{
              range: {
                start: map.virtualFileDocument.positionAt(minStart),
                end: map.virtualFileDocument.positionAt(maxEnd)
              },
              codeActionContext: _codeActionContext
            }];
          }
          return [];
        }, (_05, _12, _22, _32) => __async(this, [_05, _12, _22, _32], function* (service, document2, { range: range2, codeActionContext: codeActionContext2 }, map) {
          var _a4;
          if (token.isCancellationRequested)
            return;
          const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
          const diagnostics = codeActionContext2.diagnostics.filter((diagnostic) => {
            const data = diagnostic.data;
            if (data && data.version !== sourceDocument.version) {
              return false;
            }
            return (data == null ? void 0 : data.type) === "service" && (data == null ? void 0 : data.serviceOrRuleId) === serviceId;
          }).map((diagnostic) => {
            const data = diagnostic.data;
            return __spreadValues(__spreadValues({}, diagnostic), data.original);
          });
          const codeActions = yield (_a4 = service.provideCodeActions) == null ? void 0 : _a4.call(service, document2, range2, __spreadProps(__spreadValues({}, codeActionContext2), {
            diagnostics
          }), token);
          codeActions == null ? void 0 : codeActions.forEach((codeAction) => {
            codeAction.data = {
              uri,
              version: sourceDocument.version,
              type: "service",
              original: {
                data: codeAction.data,
                edit: codeAction.edit
              },
              serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
            };
          });
          if (codeActions && map && service.transformCodeAction) {
            for (let i = 0; i < codeActions.length; i++) {
              const transformed = service.transformCodeAction(codeActions[i]);
              if (transformed) {
                codeActions[i] = transformed;
                transformedCodeActions.add(transformed);
              }
            }
          }
          return codeActions;
        }), (actions, map) => actions.map((action) => {
          if (transformedCodeActions.has(action))
            return action;
          if (!map)
            return action;
          if (action.edit) {
            const edit = (0, rename_1.embeddedEditToSourceEdit)(action.edit, context.documents, "codeAction");
            if (!edit) {
              return;
            }
            action.edit = edit;
          }
          return action;
        }).filter(common_1.notEmpty), (arr) => dedupe.withCodeAction(arr.flat()));
        const ruleActions = [];
        for (const diagnostic of codeActionContext.diagnostics) {
          const data = diagnostic.data;
          if (data && data.version !== sourceDocument.version) {
            continue;
          }
          if ((data == null ? void 0 : data.type) === "rule") {
            const fixes = (_c = (_b = (_a3 = context.ruleFixes) == null ? void 0 : _a3[data.documentUri]) == null ? void 0 : _b[data.serviceOrRuleId]) == null ? void 0 : _c[data.ruleFixIndex];
            if (fixes) {
              for (let i = 0; i < fixes[1].length; i++) {
                const fix = fixes[1][i];
                const matchKinds = [];
                if (!codeActionContext.only) {
                  matchKinds.push(void 0);
                } else {
                  for (const kind of (_d = fix.kinds) != null ? _d : ["quickfix"]) {
                    const matchOnly = matchOnlyKind(codeActionContext.only, kind);
                    if (matchOnly) {
                      matchKinds.push(matchOnly);
                    }
                  }
                }
                for (const matchKind of matchKinds) {
                  const action = {
                    title: (_e = fix.title) != null ? _e : `Fix: ${diagnostic.message}`,
                    kind: matchKind,
                    diagnostics: [diagnostic],
                    data: {
                      uri,
                      type: "rule",
                      version: data.version,
                      isFormat: data.isFormat,
                      ruleId: data.serviceOrRuleId,
                      documentUri: data.documentUri,
                      ruleFixIndex: data.ruleFixIndex,
                      index: i
                    }
                  };
                  ruleActions.push(action);
                }
              }
            }
          }
        }
        return [
          ...pluginActions != null ? pluginActions : [],
          ...ruleActions
        ];
      });
    }
    exports2.register = register;
    function matchOnlyKind(only, kind) {
      const b = kind.split(".");
      for (const onlyKind of only) {
        const a3 = onlyKind.split(".");
        if (a3.length <= b.length) {
          let matchNum = 0;
          for (let i = 0; i < a3.length; i++) {
            if (a3[i] == b[i]) {
              matchNum++;
            }
          }
          if (matchNum === a3.length) {
            return onlyKind;
          }
        }
      }
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/codeLens.js
var require_codeLens = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/codeLens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (uri, token = cancellation_1.NoneCancellationToken) {
        var _a3;
        return (_a3 = yield (0, featureWorkers_1.languageFeatureWorker)(context, uri, void 0, (arg) => [arg], (service, document2) => __async(this, null, function* () {
          var _a4, _b;
          if (token.isCancellationRequested)
            return;
          let codeLens = yield (_a4 = service.provideCodeLenses) == null ? void 0 : _a4.call(service, document2, token);
          const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
          codeLens == null ? void 0 : codeLens.forEach((codeLens2) => {
            codeLens2.data = {
              kind: "normal",
              uri,
              original: {
                data: codeLens2.data
              },
              serviceId
            };
          });
          const ranges = yield (_b = service.provideReferencesCodeLensRanges) == null ? void 0 : _b.call(service, document2, token);
          const referencesCodeLens = ranges == null ? void 0 : ranges.map((range) => ({
            range,
            data: {
              kind: "references",
              uri,
              range,
              serviceId
            }
          }));
          codeLens = [
            ...codeLens != null ? codeLens : [],
            ...referencesCodeLens != null ? referencesCodeLens : []
          ];
          return codeLens;
        }), (data, map) => data.map((codeLens) => {
          if (!map)
            return codeLens;
          const range = map.toSourceRange(codeLens.range);
          if (range) {
            return __spreadProps(__spreadValues({}, codeLens), {
              range
            });
          }
        }).filter(common_1.notEmpty), (arr) => arr.flat())) != null ? _a3 : [];
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/references.js
var require_references = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/references.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var dedupe = require_dedupe();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => !!data.references), (service, document2, position2) => __async(this, null, function* () {
          if (token.isCancellationRequested)
            return;
          const recursiveChecker = dedupe.createLocationSet();
          const result = [];
          yield withMirrors(document2, position2);
          return result;
          function withMirrors(document3, position3) {
            return __async(this, null, function* () {
              var _a3, _b;
              if (!service.provideReferences)
                return;
              if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
                return;
              recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
              const references = (_a3 = yield service.provideReferences(document3, position3, token)) != null ? _a3 : [];
              for (const reference of references) {
                let foundMirrorPosition = false;
                recursiveChecker.add({ uri: reference.uri, range: { start: reference.range.start, end: reference.range.start } });
                const mirrorMap = (_b = context.documents.getMirrorMapByUri(reference.uri)) == null ? void 0 : _b[1];
                if (mirrorMap) {
                  for (const mapped of mirrorMap.findMirrorPositions(reference.range.start)) {
                    if (!mapped[1].references)
                      continue;
                    if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                      continue;
                    foundMirrorPosition = true;
                    yield withMirrors(mirrorMap.document, mapped[0]);
                  }
                }
                if (!foundMirrorPosition) {
                  result.push(reference);
                }
              }
            });
          }
        }), (data) => {
          const results = [];
          for (const reference of data) {
            if (context.documents.isVirtualFileUri(reference.uri)) {
              for (const [_, map] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
                const range = map.toSourceRange(reference.range, (data2) => !!data2.references);
                if (range) {
                  results.push({
                    uri: map.sourceFileDocument.uri,
                    range
                  });
                }
              }
            } else {
              results.push(reference);
            }
          }
          return results;
        }, (arr) => dedupe.withLocations(arr.flat()));
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/codeLensResolve.js
var require_codeLensResolve = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/codeLensResolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var references = require_references();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      const findReferences = references.register(context);
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (item, token = cancellation_1.NoneCancellationToken) {
        var _a3;
        const data = item.data;
        if ((data == null ? void 0 : data.kind) === "normal") {
          const service = context.services[data.serviceId];
          if (!service.resolveCodeLens)
            return item;
          Object.assign(item, data.original);
          item = yield service.resolveCodeLens(item, token);
        }
        if ((data == null ? void 0 : data.kind) === "references") {
          let references2 = (_a3 = yield findReferences(data.uri, item.range.start, token)) != null ? _a3 : [];
          const service = context.services[data.serviceId];
          const document2 = context.getTextDocument(data.uri);
          if (document2 && service.resolveReferencesCodeLensLocations) {
            references2 = yield service.resolveReferencesCodeLensLocations(document2, data.range, references2, token);
          }
          item.command = context.commands.showReferences.create(data.uri, data.range.start, references2);
        }
        return item;
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/complete.js
var require_complete = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/complete.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var transformer = require_transformer();
    var definePlugin_1 = require_definePlugin();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      let cache;
      return (_04, _1, ..._2) => __async(this, [_04, _1, ..._2], function* (uri, position, completionContext = { triggerKind: 1 }, token = cancellation_1.NoneCancellationToken) {
        var _a3, _b;
        let document2;
        if ((completionContext == null ? void 0 : completionContext.triggerKind) === 3 && (cache == null ? void 0 : cache.uri) === uri) {
          for (const cacheData of cache.data) {
            if (!cacheData.list.isIncomplete)
              continue;
            if (cacheData.virtualDocumentUri) {
              for (const [_, map] of context.documents.getMapsByVirtualFileUri(cacheData.virtualDocumentUri)) {
                for (const mapped of map.toGeneratedPositions(position, (data) => !!data.completion)) {
                  if (!cacheData.service.provideCompletionItems)
                    continue;
                  const embeddedCompletionList = yield cacheData.service.provideCompletionItems(map.virtualFileDocument, mapped, completionContext, token);
                  if (!embeddedCompletionList) {
                    cacheData.list.isIncomplete = false;
                    continue;
                  }
                  cacheData.list = transformer.asCompletionList(embeddedCompletionList, (range) => map.toSourceRange(range), map.virtualFileDocument, (newItem, oldItem) => newItem.data = {
                    uri,
                    original: {
                      additionalTextEdits: oldItem.additionalTextEdits,
                      textEdit: oldItem.textEdit,
                      data: oldItem.data
                    },
                    serviceId: Object.keys(context.services).find((key) => context.services[key] === cacheData.service),
                    virtualDocumentUri: map.virtualFileDocument.uri
                  });
                }
              }
            } else if (document2 = context.getTextDocument(uri)) {
              if (!cacheData.service.provideCompletionItems)
                continue;
              const completionList = yield cacheData.service.provideCompletionItems(document2, position, completionContext, token);
              if (!completionList) {
                cacheData.list.isIncomplete = false;
                continue;
              }
              completionList.items.forEach((item) => {
                item.data = {
                  uri,
                  original: {
                    additionalTextEdits: item.additionalTextEdits,
                    textEdit: item.textEdit,
                    data: item.data
                  },
                  serviceId: Object.keys(context.services).find((key) => context.services[key] === cacheData.service),
                  virtualDocumentUri: void 0
                };
              });
            }
          }
        } else {
          const rootFile = (_a3 = context.documents.getSourceByUri(uri)) == null ? void 0 : _a3.root;
          cache = {
            uri,
            data: [],
            mainCompletion: void 0
          };
          let isFirstMapping = true;
          if (rootFile) {
            yield (0, definePlugin_1.visitEmbedded)(context.documents, rootFile, (_, map) => __async(this, null, function* () {
              var _a4;
              const services = Object.values(context.services).sort(sortServices);
              let _data;
              for (const mapped of map.toGeneratedPositions(position, (data) => {
                _data = data;
                return !!data.completion;
              })) {
                for (const service of services) {
                  if (token.isCancellationRequested)
                    break;
                  if (!service.provideCompletionItems)
                    continue;
                  if (service.isAdditionalCompletion && !isFirstMapping)
                    continue;
                  if ((completionContext == null ? void 0 : completionContext.triggerCharacter) && !((_a4 = service.triggerCharacters) == null ? void 0 : _a4.includes(completionContext.triggerCharacter)))
                    continue;
                  const isAdditional = _data && typeof _data.completion === "object" && _data.completion.additional || service.isAdditionalCompletion;
                  if (cache.mainCompletion && (!isAdditional || (cache == null ? void 0 : cache.mainCompletion.documentUri) !== map.virtualFileDocument.uri))
                    continue;
                  if (service.isAdditionalCompletion && (cache == null ? void 0 : cache.data.some((data) => data.service === service)))
                    continue;
                  const embeddedCompletionList = yield service.provideCompletionItems(map.virtualFileDocument, mapped, completionContext, token);
                  if (!embeddedCompletionList || !embeddedCompletionList.items.length)
                    continue;
                  if (typeof (_data == null ? void 0 : _data.completion) === "object" && _data.completion.autoImportOnly) {
                    embeddedCompletionList.items = embeddedCompletionList.items.filter((item) => !!item.labelDetails);
                  }
                  if (!isAdditional) {
                    cache.mainCompletion = { documentUri: map.virtualFileDocument.uri };
                  }
                  const completionList = transformer.asCompletionList(embeddedCompletionList, (range) => map.toSourceRange(range), map.virtualFileDocument, (newItem, oldItem) => newItem.data = {
                    uri,
                    original: {
                      additionalTextEdits: oldItem.additionalTextEdits,
                      textEdit: oldItem.textEdit,
                      data: oldItem.data
                    },
                    serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
                    virtualDocumentUri: map.virtualFileDocument.uri
                  });
                  cache.data.push({
                    virtualDocumentUri: map.virtualFileDocument.uri,
                    service,
                    list: completionList
                  });
                }
                isFirstMapping = false;
              }
              return true;
            }));
          }
          if (document2 = context.getTextDocument(uri)) {
            const services = Object.values(context.services).sort(sortServices);
            for (const service of services) {
              if (token.isCancellationRequested)
                break;
              if (!service.provideCompletionItems)
                continue;
              if (service.isAdditionalCompletion && !isFirstMapping)
                continue;
              if ((completionContext == null ? void 0 : completionContext.triggerCharacter) && !((_b = service.triggerCharacters) == null ? void 0 : _b.includes(completionContext.triggerCharacter)))
                continue;
              if (cache.mainCompletion && (!service.isAdditionalCompletion || cache.mainCompletion.documentUri !== document2.uri))
                continue;
              if (service.isAdditionalCompletion && (cache == null ? void 0 : cache.data.some((data) => data.service === service)))
                continue;
              const completionList = yield service.provideCompletionItems(document2, position, completionContext, token);
              if (!completionList || !completionList.items.length)
                continue;
              if (!service.isAdditionalCompletion) {
                cache.mainCompletion = { documentUri: document2.uri };
              }
              completionList.items.forEach((item) => {
                item.data = {
                  uri,
                  original: {
                    additionalTextEdits: item.additionalTextEdits,
                    textEdit: item.textEdit,
                    data: item.data
                  },
                  serviceId: Object.keys(context.services).find((key) => context.services[key] === service),
                  virtualDocumentUri: void 0
                };
              });
              cache.data.push({
                virtualDocumentUri: void 0,
                service,
                list: completionList
              });
            }
          }
        }
        return combineCompletionList(cache.data.map((cacheData) => cacheData.list));
        function sortServices(a3, b) {
          return (b.isAdditionalCompletion ? -1 : 1) - (a3.isAdditionalCompletion ? -1 : 1);
        }
        function combineCompletionList(lists) {
          var _a4;
          return {
            isIncomplete: lists.some((list) => list.isIncomplete),
            itemDefaults: (_a4 = lists.find((list) => list.itemDefaults)) == null ? void 0 : _a4.itemDefaults,
            items: lists.map((list) => list.items).flat()
          };
        }
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/completeResolve.js
var require_completeResolve = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/completeResolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var transformer = require_transformer();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (item, token = cancellation_1.NoneCancellationToken) {
        var _a3, _b;
        const data = item.data;
        if (data) {
          const service = context.services[data.serviceId];
          if (!service.resolveCompletionItem)
            return item;
          item = Object.assign(item, data.original);
          if (data.virtualDocumentUri) {
            for (const [_, map] of context.documents.getMapsByVirtualFileUri(data.virtualDocumentUri)) {
              item = yield service.resolveCompletionItem(item, token);
              item = (_b = (_a3 = service.transformCompletionItem) == null ? void 0 : _a3.call(service, item)) != null ? _b : transformer.asCompletionItem(item, (embeddedRange) => map.toSourceRange(embeddedRange), map.virtualFileDocument);
            }
          } else {
            item = yield service.resolveCompletionItem(item, token);
          }
        }
        if (item.detail !== item.detail + ".ts") {
          item.detail = item.detail;
        }
        return item;
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/definition.js
var require_definition = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/definition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var dedupe = require_dedupe();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context, apiName, isValidMapping, isValidMirrorPosition) {
      return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, isValidMapping), (service, document2, position2) => __async(this, null, function* () {
          if (token.isCancellationRequested)
            return;
          const recursiveChecker = dedupe.createLocationSet();
          const result = [];
          yield withMirrors(document2, position2, void 0);
          return result;
          function withMirrors(document3, position3, originDefinition) {
            return __async(this, null, function* () {
              var _a3, _b;
              const api = service[apiName];
              if (!api)
                return;
              if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
                return;
              recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
              const definitions = (_a3 = yield api == null ? void 0 : api(document3, position3, token)) != null ? _a3 : [];
              for (const definition of definitions) {
                let foundMirrorPosition = false;
                recursiveChecker.add({ uri: definition.targetUri, range: { start: definition.targetRange.start, end: definition.targetRange.start } });
                const mirrorMap = (_b = context.documents.getMirrorMapByUri(definition.targetUri)) == null ? void 0 : _b[1];
                if (mirrorMap) {
                  for (const mapped of mirrorMap.findMirrorPositions(definition.targetSelectionRange.start)) {
                    if (!isValidMirrorPosition(mapped[1]))
                      continue;
                    if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                      continue;
                    foundMirrorPosition = true;
                    yield withMirrors(mirrorMap.document, mapped[0], originDefinition != null ? originDefinition : definition);
                  }
                }
                if (!foundMirrorPosition) {
                  if (originDefinition) {
                    result.push(__spreadProps(__spreadValues({}, definition), {
                      originSelectionRange: originDefinition.originSelectionRange
                    }));
                  } else {
                    result.push(definition);
                  }
                }
              }
            });
          }
        }), (data, sourceMap) => data.map((link) => {
          if (link.originSelectionRange && sourceMap) {
            const originSelectionRange = toSourcePositionPreferSurroundedPosition(sourceMap, link.originSelectionRange, position);
            if (!originSelectionRange)
              return;
            link.originSelectionRange = originSelectionRange;
          }
          let foundTargetSelectionRange = false;
          for (const [_, targetSourceMap] of context.documents.getMapsByVirtualFileUri(link.targetUri)) {
            const targetSelectionRange = targetSourceMap.toSourceRange(link.targetSelectionRange);
            if (!targetSelectionRange)
              continue;
            foundTargetSelectionRange = true;
            let targetRange = targetSourceMap.toSourceRange(link.targetRange);
            link.targetUri = targetSourceMap.sourceFileDocument.uri;
            link.targetRange = targetRange != null ? targetRange : targetSelectionRange;
            link.targetSelectionRange = targetSelectionRange;
          }
          if (apiName === "provideDefinition" && context.documents.isVirtualFileUri(link.targetUri) && !foundTargetSelectionRange) {
            for (const [_, targetMap] of context.documents.getMapsByVirtualFileUri(link.targetUri)) {
              if (targetMap && targetMap.sourceFileDocument.uri !== uri) {
                return __spreadProps(__spreadValues({}, link), {
                  targetUri: targetMap.sourceFileDocument.uri,
                  targetRange: {
                    start: { line: 0, character: 0 },
                    end: { line: 0, character: 0 }
                  },
                  targetSelectionRange: {
                    start: { line: 0, character: 0 },
                    end: { line: 0, character: 0 }
                  }
                });
              }
            }
            return;
          }
          return link;
        }).filter(common_1.notEmpty), (arr) => dedupe.withLocationLinks(arr.flat()));
      };
    }
    exports2.register = register;
    function toSourcePositionPreferSurroundedPosition(map, mappedRange, position) {
      let result;
      for (const range of map.toSourceRanges(mappedRange)) {
        if (!result) {
          result = range;
        }
        if ((range.start.line < position.line || range.start.line === position.line && range.start.character <= position.character) && (range.end.line > position.line || range.end.line === position.line && range.end.character >= position.character)) {
          return range;
        }
      }
      return result;
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/documentHighlights.js
var require_documentHighlights = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/documentHighlights.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var dedupe = require_dedupe();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(
          position2,
          // note https://github.com/johnsoncodehk/volar/issues/2009
          (data) => typeof data.rename === "object" ? !!data.rename.normalize : !!data.rename
        ), (service, document2, position2) => __async(this, null, function* () {
          if (token.isCancellationRequested)
            return;
          const recursiveChecker = dedupe.createLocationSet();
          const result = [];
          yield withMirrors(document2, position2);
          return result;
          function withMirrors(document3, position3) {
            return __async(this, null, function* () {
              var _a3, _b;
              if (!service.provideDocumentHighlights)
                return;
              if (recursiveChecker.has({ uri: document3.uri, range: { start: position3, end: position3 } }))
                return;
              recursiveChecker.add({ uri: document3.uri, range: { start: position3, end: position3 } });
              const references = (_a3 = yield service.provideDocumentHighlights(document3, position3, token)) != null ? _a3 : [];
              for (const reference of references) {
                let foundMirrorPosition = false;
                recursiveChecker.add({ uri: document3.uri, range: { start: reference.range.start, end: reference.range.start } });
                const mirrorMap = (_b = context.documents.getMirrorMapByUri(document3.uri)) == null ? void 0 : _b[1];
                if (mirrorMap) {
                  for (const mapped of mirrorMap.findMirrorPositions(reference.range.start)) {
                    if (!mapped[1].references)
                      continue;
                    if (recursiveChecker.has({ uri: mirrorMap.document.uri, range: { start: mapped[0], end: mapped[0] } }))
                      continue;
                    foundMirrorPosition = true;
                    yield withMirrors(mirrorMap.document, mapped[0]);
                  }
                }
                if (!foundMirrorPosition) {
                  result.push(reference);
                }
              }
            });
          }
        }), (data, map) => data.map((highlight) => {
          if (!map)
            return highlight;
          const range = map.toSourceRange(highlight.range);
          if (range) {
            return __spreadProps(__spreadValues({}, highlight), {
              range
            });
          }
        }).filter(common_1.notEmpty), (arr) => arr.flat());
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/documentLinkResolve.js
var require_documentLinkResolve = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/documentLinkResolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.transformDocumentLinkTarget = exports2.register = void 0;
    var cancellation_1 = require_cancellation2();
    var vscode_uri_1 = require_umd();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (item, token = cancellation_1.NoneCancellationToken) {
        const data = item.data;
        if (data) {
          const service = context.services[data.serviceId];
          if (!service.resolveDocumentLink)
            return item;
          Object.assign(item, data.original);
          item = yield service.resolveDocumentLink(item, token);
          if (item.target) {
            item.target = transformDocumentLinkTarget(item.target, context);
          }
        }
        return item;
      });
    }
    exports2.register = register;
    function transformDocumentLinkTarget(target, context) {
      var _a3, _b;
      const targetUri = vscode_uri_1.URI.parse(target);
      const clearUri = targetUri.with({ fragment: "" }).toString();
      if (context.documents.isVirtualFileUri(clearUri)) {
        for (const [virtualFile, map] of context.documents.getMapsByVirtualFileUri(clearUri)) {
          if (!virtualFile.capabilities.documentSymbol) {
            continue;
          }
          target = map.sourceFileDocument.uri;
          const hash = targetUri.fragment;
          const range = hash.match(/^L(\d+)(,(\d+))?(-L(\d+)(,(\d+))?)?$/);
          if (range) {
            const startLine = Number(range[1]) - 1;
            const startCharacter = Number((_a3 = range[3]) != null ? _a3 : 1) - 1;
            if (range[5] !== void 0) {
              const endLine = Number(range[5]) - 1;
              const endCharacter = Number((_b = range[7]) != null ? _b : 1) - 1;
              const sourceRange = map.toSourceRange({
                start: { line: startLine, character: startCharacter },
                end: { line: endLine, character: endCharacter }
              });
              if (sourceRange) {
                target += "#L" + (sourceRange.start.line + 1) + "," + (sourceRange.start.character + 1);
                target += "-L" + (sourceRange.end.line + 1) + "," + (sourceRange.end.character + 1);
                break;
              }
            } else {
              const sourcePos = map.toSourcePosition({ line: startLine, character: startCharacter });
              if (sourcePos) {
                target += "#L" + (sourcePos.line + 1) + "," + (sourcePos.character + 1);
                break;
              }
            }
          }
        }
      }
      return target;
    }
    exports2.transformDocumentLinkTarget = transformDocumentLinkTarget;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/documentLinks.js
var require_documentLinks = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/documentLinks.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    var documentLinkResolve_1 = require_documentLinkResolve();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (uri, token = cancellation_1.NoneCancellationToken) {
        var _a3;
        const pluginLinks = (_a3 = yield (0, featureWorkers_1.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.documentSymbol, (service, document2) => __async(this, null, function* () {
          var _a4;
          if (token.isCancellationRequested)
            return;
          const links = yield (_a4 = service.provideDocumentLinks) == null ? void 0 : _a4.call(service, document2, token);
          for (const link of links != null ? links : []) {
            link.data = {
              uri,
              original: {
                data: link.data
              },
              serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
            };
          }
          return links;
        }), (links, map) => links.map((link) => {
          if (!map)
            return link;
          const range = map.toSourceRange(link.range);
          if (!range)
            return;
          link = __spreadProps(__spreadValues({}, link), {
            range
          });
          if (link.target)
            link.target = (0, documentLinkResolve_1.transformDocumentLinkTarget)(link.target, context);
          return link;
        }).filter(common_1.notEmpty), (arr) => arr.flat())) != null ? _a3 : [];
        const maps = context.documents.getMapsBySourceFileUri(uri);
        const fictitiousLinks = maps ? getFictitiousLinks(context.documents.getDocumentByUri(maps.snapshot, uri), maps.maps) : [];
        return [
          ...pluginLinks,
          ...fictitiousLinks
        ];
        function getFictitiousLinks(document2, maps2) {
          const result = [];
          for (const [_, map] of maps2) {
            for (const mapped of map.map.mappings) {
              if (!mapped.data.displayWithLink)
                continue;
              if (mapped.sourceRange[0] === mapped.sourceRange[1])
                continue;
              result.push({
                range: {
                  start: document2.positionAt(mapped.sourceRange[0]),
                  end: document2.positionAt(mapped.sourceRange[1])
                },
                target: uri
                // TODO
              });
            }
          }
          return result;
        }
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/utils/SemanticTokensBuilder.js
var require_SemanticTokensBuilder = __commonJS({
  "node_modules/@volar/language-service/lib/utils/SemanticTokensBuilder.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemanticTokensBuilder = void 0;
    var SemanticTokensBuilder = class {
      constructor() {
        this.initialize();
      }
      initialize() {
        this._id = Date.now();
        this._prevLine = 0;
        this._prevChar = 0;
        this._data = [];
        this._dataLen = 0;
      }
      push(line, char, length, tokenType, tokenModifiers) {
        let pushLine = line;
        let pushChar = char;
        if (this._dataLen > 0) {
          pushLine -= this._prevLine;
          if (pushLine === 0) {
            pushChar -= this._prevChar;
          }
        }
        this._data[this._dataLen++] = pushLine;
        this._data[this._dataLen++] = pushChar;
        this._data[this._dataLen++] = length;
        this._data[this._dataLen++] = tokenType;
        this._data[this._dataLen++] = tokenModifiers;
        this._prevLine = line;
        this._prevChar = char;
      }
      get id() {
        return this._id.toString();
      }
      build() {
        return {
          resultId: this.id,
          data: this._data
        };
      }
    };
    exports2.SemanticTokensBuilder = SemanticTokensBuilder;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/documentSemanticTokens.js
var require_documentSemanticTokens = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/documentSemanticTokens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var SemanticTokensBuilder_1 = require_SemanticTokensBuilder();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, _1, _2, ..._3) => __async(this, [_04, _1, _2, ..._3], function* (uri, range, legend, token = cancellation_1.NoneCancellationToken, reportProgress) {
        const document2 = context.getTextDocument(uri);
        if (!document2)
          return;
        const offsetRange = range ? [
          document2.offsetAt(range.start),
          document2.offsetAt(range.end)
        ] : [
          0,
          document2.getText().length
        ];
        const tokens = yield (0, featureWorkers_1.languageFeatureWorker)(context, uri, offsetRange, function* (offsetRange2, map) {
          let range2;
          for (const mapping of map.map.mappings) {
            if (mapping.data.semanticTokens && mapping.sourceRange[1] > offsetRange2[0] && mapping.sourceRange[0] < offsetRange2[1]) {
              if (!range2) {
                range2 = [...mapping.generatedRange];
              } else {
                range2[0] = Math.min(range2[0], mapping.generatedRange[0]);
                range2[1] = Math.max(range2[1], mapping.generatedRange[1]);
              }
            }
          }
          if (range2) {
            yield range2;
          }
        }, (service, document3, offsetRange2) => {
          var _a3;
          if (token == null ? void 0 : token.isCancellationRequested)
            return;
          return (_a3 = service.provideDocumentSemanticTokens) == null ? void 0 : _a3.call(service, document3, {
            start: document3.positionAt(offsetRange2[0]),
            end: document3.positionAt(offsetRange2[1])
          }, legend, token);
        }, (tokens2, map) => tokens2.map((_token) => {
          if (!map)
            return _token;
          const range2 = map.toSourceRange({
            start: { line: _token[0], character: _token[1] },
            end: { line: _token[0], character: _token[1] + _token[2] }
          }, (data) => !!data.semanticTokens);
          if (range2) {
            return [range2.start.line, range2.start.character, range2.end.character - range2.start.character, _token[3], _token[4]];
          }
        }).filter(common_1.notEmpty), (tokens2) => tokens2.flat(), (tokens2) => reportProgress == null ? void 0 : reportProgress(buildTokens(tokens2)));
        if (tokens) {
          return buildTokens(tokens);
        }
      });
    }
    exports2.register = register;
    function buildTokens(tokens) {
      const builder = new SemanticTokensBuilder_1.SemanticTokensBuilder();
      const sortedTokens = tokens.sort((a3, b) => a3[0] - b[0] === 0 ? a3[1] - b[1] : a3[0] - b[0]);
      for (const token of sortedTokens) {
        builder.push(...token);
      }
      return builder.build();
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/fileReferences.js
var require_fileReferences = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/fileReferences.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var dedupe = require_dedupe();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, void 0, function* (_) {
          yield _;
        }, (service, document2) => __async(this, null, function* () {
          var _a3, _b;
          if (token.isCancellationRequested)
            return;
          return (_b = yield (_a3 = service.provideFileReferences) == null ? void 0 : _a3.call(service, document2, token)) != null ? _b : [];
        }), (data) => data.map((reference) => {
          if (!context.documents.isVirtualFileUri(reference.uri)) {
            return reference;
          }
          for (const [_, map] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
            const range = map.toSourceRange(reference.range);
            if (range) {
              reference.uri = map.sourceFileDocument.uri;
              reference.range = range;
              return reference;
            }
          }
        }).filter(common_1.notEmpty), (arr) => dedupe.withLocations(arr.flat()));
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/fileRename.js
var require_fileRename = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/fileRename.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var rename_1 = require_rename();
    var dedupe = require_dedupe();
    var language_core_1 = require_language_core();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, _1, ..._2) => __async(this, [_04, _1, ..._2], function* (oldUri, newUri, token = cancellation_1.NoneCancellationToken) {
        var _a3;
        const rootFile = (_a3 = context.documents.getSourceByUri(oldUri)) == null ? void 0 : _a3.root;
        if (rootFile) {
          let tsExt;
          (0, language_core_1.forEachEmbeddedFile)(rootFile, (embedded) => {
            if (embedded.kind === language_core_1.FileKind.TypeScriptHostFile && embedded.fileName.replace(rootFile.fileName, "").match(/^\.(js|ts)x?$/)) {
              tsExt = embedded.fileName.substring(embedded.fileName.lastIndexOf("."));
            }
          });
          if (!tsExt) {
            return;
          }
          oldUri += tsExt;
          newUri += tsExt;
        }
        for (const service of Object.values(context.services)) {
          if (token.isCancellationRequested)
            break;
          if (!service.provideFileRenameEdits)
            continue;
          const workspaceEdit = yield service.provideFileRenameEdits(oldUri, newUri, token);
          if (workspaceEdit) {
            const result = (0, rename_1.embeddedEditToSourceEdit)(workspaceEdit, context.documents, "fileName");
            if (result == null ? void 0 : result.documentChanges) {
              result.documentChanges = dedupe.withDocumentChanges(result.documentChanges);
            }
            return result;
          }
        }
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/validation.js
var require_validation = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/validation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = exports2.errorMarkups = exports2.updateRange = void 0;
    var types_1 = require_types3();
    var common_1 = require_common();
    var dedupe = require_dedupe();
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function updateRange(range, change) {
      if (!updatePosition(range.start, change, false)) {
        return;
      }
      if (!updatePosition(range.end, change, true)) {
        return;
      }
      if (range.end.line === range.start.line && range.end.character <= range.start.character) {
        range.end.character++;
      }
      return range;
    }
    exports2.updateRange = updateRange;
    function updatePosition(position, change, isEnd) {
      if (change.range.end.line > position.line) {
        if (change.newEnd.line > position.line) {
          return true;
        } else if (change.newEnd.line === position.line) {
          position.character = Math.min(position.character, change.newEnd.character);
          return true;
        } else if (change.newEnd.line < position.line) {
          position.line = change.newEnd.line;
          position.character = change.newEnd.character;
          return true;
        }
      } else if (change.range.end.line === position.line) {
        const characterDiff = change.newEnd.character - change.range.end.character;
        if (position.character >= change.range.end.character) {
          if (change.newEnd.line !== change.range.end.line) {
            position.line = change.newEnd.line;
            position.character = change.newEnd.character + position.character - change.range.end.character;
          } else {
            if (isEnd ? change.range.end.character < position.character : change.range.end.character <= position.character) {
              position.character += characterDiff;
            } else {
              const offset = change.range.end.character - position.character;
              if (-characterDiff > offset) {
                position.character += characterDiff + offset;
              }
            }
          }
          return true;
        } else {
          if (change.newEnd.line === change.range.end.line) {
            const offset = change.range.end.character - position.character;
            if (-characterDiff > offset) {
              position.character += characterDiff + offset;
            }
          } else if (change.newEnd.line < change.range.end.line) {
            position.line = change.newEnd.line;
            position.character = change.newEnd.character;
          } else {
          }
          return true;
        }
      } else if (change.range.end.line < position.line) {
        position.line += change.newEnd.line - change.range.end.line;
        return true;
      }
      return false;
    }
    exports2.errorMarkups = {};
    function register(context) {
      const lastResponses = /* @__PURE__ */ new Map();
      const cacheMaps = {
        semantic: /* @__PURE__ */ new Map(),
        syntactic: /* @__PURE__ */ new Map(),
        semantic_rules: /* @__PURE__ */ new Map(),
        syntax_rules: /* @__PURE__ */ new Map(),
        format_rules: /* @__PURE__ */ new Map()
      };
      return (_04, _1, ..._2) => __async(this, [_04, _1, ..._2], function* (uri, mode, token = cancellation_1.NoneCancellationToken, response) {
        var _a3;
        const newDocument = context.getTextDocument(uri);
        if (!newDocument) {
          return [];
        }
        const lastResponse = (_a3 = lastResponses.get(uri)) != null ? _a3 : lastResponses.set(uri, {
          semantic: { errors: [] },
          syntactic: { errors: [] },
          semantic_rules: { errors: [] },
          syntax_rules: { errors: [] },
          format_rules: { errors: [] }
        }).get(uri);
        const newSnapshot = context.host.getScriptSnapshot(context.env.uriToFileName(uri));
        let updateCacheRangeFailed = false;
        let errorsUpdated = false;
        let lastCheckCancelAt = 0;
        for (const cache of Object.values(lastResponse)) {
          const oldSnapshot = cache.snapshot;
          const oldDocument = cache.document;
          const change = oldSnapshot ? newSnapshot == null ? void 0 : newSnapshot.getChangeRange(oldSnapshot) : void 0;
          cache.snapshot = newSnapshot;
          cache.document = newDocument;
          if (!updateCacheRangeFailed && newDocument && oldSnapshot && oldDocument && newSnapshot && change) {
            const changeRange = {
              range: {
                start: oldDocument.positionAt(change.span.start),
                end: oldDocument.positionAt(change.span.start + change.span.length)
              },
              newEnd: newDocument.positionAt(change.span.start + change.newLength)
            };
            for (const error of cache.errors) {
              if (!updateRange(error.range, changeRange)) {
                updateCacheRangeFailed = true;
                break;
              }
            }
          }
        }
        if (mode === "all" || mode === "syntactic") {
          yield lintWorker(types_1.RuleType.Format, cacheMaps.format_rules, lastResponse.format_rules);
          yield doResponse();
          yield lintWorker(types_1.RuleType.Syntax, cacheMaps.syntax_rules, lastResponse.syntax_rules);
          yield doResponse();
          yield worker("provideDiagnostics", cacheMaps.syntactic, lastResponse.syntactic);
          yield doResponse();
        }
        if (mode === "all" || mode === "semantic") {
          yield lintWorker(types_1.RuleType.Semantic, cacheMaps.semantic_rules, lastResponse.semantic_rules);
          yield doResponse();
          yield worker("provideSemanticDiagnostics", cacheMaps.semantic, lastResponse.semantic);
        }
        return yield collectErrors();
        function doResponse() {
          return __async(this, null, function* () {
            if (errorsUpdated && !updateCacheRangeFailed) {
              response == null ? void 0 : response(yield collectErrors());
              errorsUpdated = false;
            }
          });
        }
        function collectErrors() {
          return __async(this, null, function* () {
            var _a4;
            const errors = Object.values(lastResponse).flatMap(({ errors: errors2 }) => errors2);
            exports2.errorMarkups[uri] = [];
            for (const error of errors) {
              for (const service of Object.values(context.services)) {
                const markup = yield (_a4 = service.provideDiagnosticMarkupContent) == null ? void 0 : _a4.call(service, error, token);
                if (markup) {
                  exports2.errorMarkups[uri].push({ error, markup });
                }
              }
            }
            return errors;
          });
        }
        function lintWorker(ruleType, cacheMap, cache) {
          return __async(this, null, function* () {
            const result = yield (0, featureWorkers_1.ruleWorker)(context, ruleType, uri, (file) => ruleType === types_1.RuleType.Format ? !!file.capabilities.documentFormatting : !!file.capabilities.diagnostic, (ruleId, rule, lintDocument, ruleCtx) => __async(this, null, function* () {
              var _a4, _b, _c, _d, _e, _f2, _g, _h, _i;
              if (token) {
                if (Date.now() - lastCheckCancelAt >= 5) {
                  yield (0, common_1.sleep)(5);
                  lastCheckCancelAt = Date.now();
                }
                if (token.isCancellationRequested) {
                  return;
                }
              }
              const pluginCache = (_a4 = cacheMap.get(ruleId)) != null ? _a4 : cacheMap.set(ruleId, /* @__PURE__ */ new Map()).get(ruleId);
              const cache2 = pluginCache.get(lintDocument.uri);
              const projectVersion = ruleType === types_1.RuleType.Semantic ? (_c = (_b = context.host).getProjectVersion) == null ? void 0 : _c.call(_b) : void 0;
              if (ruleType === types_1.RuleType.Semantic) {
                if (cache2 && cache2.documentVersion === lintDocument.version && cache2.projectVersion === projectVersion) {
                  return cache2.errors;
                }
              } else {
                if (cache2 && cache2.documentVersion === lintDocument.version) {
                  return cache2.errors;
                }
              }
              const reportResults = [];
              ruleCtx.report = (error, ...fixes) => {
                error.message || (error.message = "No message.");
                error.source || (error.source = "rule");
                error.code || (error.code = ruleId);
                reportResults.push([error, ...fixes]);
              };
              try {
                yield rule.run(lintDocument, ruleCtx);
              } catch (err) {
                console.warn(`[volar/rules-api] ${ruleId} ${ruleType} error.`);
                console.warn(err);
              }
              (_d = context.ruleFixes) != null ? _d : context.ruleFixes = {};
              (_g = (_e = context.ruleFixes)[_f2 = lintDocument.uri]) != null ? _g : _e[_f2] = {};
              (_i = (_h = context.ruleFixes[lintDocument.uri])[ruleId]) != null ? _i : _h[ruleId] = {};
              reportResults == null ? void 0 : reportResults.forEach(([error, ...fixes], index) => {
                context.ruleFixes[lintDocument.uri][ruleId][index] = [error, fixes];
                error.data = {
                  uri,
                  version: newDocument.version,
                  type: "rule",
                  isFormat: ruleType === types_1.RuleType.Format,
                  serviceOrRuleId: ruleId,
                  original: {
                    data: error.data
                  },
                  ruleFixIndex: index,
                  documentUri: lintDocument.uri
                };
              });
              errorsUpdated = true;
              const errors = reportResults.map((reportResult) => reportResult[0]);
              pluginCache.set(lintDocument.uri, {
                documentVersion: lintDocument.version,
                errors,
                projectVersion
              });
              return errors;
            }), ruleType === types_1.RuleType.Format ? transformFormatErrorRange : transformErrorRange, (arr) => arr.flat());
            if (result) {
              cache.errors = result;
              cache.snapshot = newSnapshot;
            }
          });
        }
        function worker(api, cacheMap, cache) {
          return __async(this, null, function* () {
            const result = yield (0, featureWorkers_1.languageFeatureWorker)(context, uri, true, function* (arg, _, file) {
              if (file.capabilities.diagnostic) {
                yield arg;
              }
            }, (service, document2) => __async(this, null, function* () {
              var _a4, _b, _c, _d;
              if (token) {
                if (Date.now() - lastCheckCancelAt >= 5) {
                  yield (0, common_1.sleep)(5);
                  lastCheckCancelAt = Date.now();
                }
                if (token.isCancellationRequested) {
                  return;
                }
              }
              const serviceId = Object.keys(context.services).find((key) => context.services[key] === service);
              const serviceCache = (_a4 = cacheMap.get(serviceId)) != null ? _a4 : cacheMap.set(serviceId, /* @__PURE__ */ new Map()).get(serviceId);
              const cache2 = serviceCache.get(document2.uri);
              const projectVersion = api === "provideSemanticDiagnostics" ? (_c = (_b = context.host).getProjectVersion) == null ? void 0 : _c.call(_b) : void 0;
              if (api === "provideSemanticDiagnostics") {
                if (cache2 && cache2.documentVersion === document2.version && cache2.projectVersion === projectVersion) {
                  return cache2.errors;
                }
              } else {
                if (cache2 && cache2.documentVersion === document2.version) {
                  return cache2.errors;
                }
              }
              const errors = yield (_d = service[api]) == null ? void 0 : _d.call(service, document2, token);
              errors == null ? void 0 : errors.forEach((error) => {
                error.data = {
                  uri,
                  version: newDocument.version,
                  type: "service",
                  serviceOrRuleId: serviceId,
                  isFormat: false,
                  original: {
                    data: error.data
                  },
                  ruleFixIndex: 0,
                  documentUri: document2.uri
                };
              });
              errorsUpdated = true;
              serviceCache.set(document2.uri, {
                documentVersion: document2.version,
                errors,
                projectVersion
              });
              return errors;
            }), transformErrorRange, (arr) => dedupe.withDiagnostics(arr.flat()));
            if (result) {
              cache.errors = result;
              cache.snapshot = newSnapshot;
            }
          });
        }
      });
      function transformFormatErrorRange(errors, map) {
        return transformErrorRangeBase(errors, map, () => true);
      }
      function transformErrorRange(errors, map) {
        return transformErrorRangeBase(errors, map, (data) => typeof data.diagnostic === "object" ? data.diagnostic.shouldReport() : !!data.diagnostic);
      }
      function transformErrorRangeBase(errors, map, filter) {
        const result = [];
        for (const error of errors) {
          let _error = __spreadValues({}, error);
          if (map) {
            const range = map.toSourceRange(error.range, filter);
            if (!range) {
              continue;
            }
            _error.range = range;
          }
          if (_error.relatedInformation) {
            const relatedInfos = [];
            for (const info of _error.relatedInformation) {
              if (context.documents.isVirtualFileUri(info.location.uri)) {
                for (const [_, map2] of context.documents.getMapsByVirtualFileUri(info.location.uri)) {
                  const range = map2.toSourceRange(info.location.range, filter);
                  if (range) {
                    relatedInfos.push({
                      location: {
                        uri: map2.sourceFileDocument.uri,
                        range
                      },
                      message: info.message
                    });
                  }
                }
              } else {
                relatedInfos.push(info);
              }
            }
            _error.relatedInformation = relatedInfos;
          }
          result.push(_error);
        }
        return result;
      }
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/hover.js
var require_hover2 = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/hover.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var validation_1 = require_validation();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, _1, ..._2) => __async(this, [_04, _1, ..._2], function* (uri, position, token = cancellation_1.NoneCancellationToken) {
        let hover = yield (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => !!data.hover), (service, document2, position2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideHover) == null ? void 0 : _a3.call(service, document2, position2, token);
        }, (item, map) => {
          if (!map || !item.range)
            return item;
          const range = map.toSourceRange(item.range);
          if (range) {
            item.range = range;
            return item;
          }
        }, (hovers) => {
          var _a3, _b;
          return {
            contents: {
              kind: "markdown",
              value: hovers.map(getHoverTexts).flat().join("\n\n---\n\n")
            },
            range: (_b = (_a3 = hovers.find((hover2) => hover2.range && (0, common_1.isInsideRange)(hover2.range, { start: position, end: position }))) == null ? void 0 : _a3.range) != null ? _b : hovers[0].range
          };
        });
        const markups = validation_1.errorMarkups[uri];
        if (markups) {
          for (const errorAndMarkup of markups) {
            if ((0, common_1.isInsideRange)(errorAndMarkup.error.range, { start: position, end: position })) {
              hover != null ? hover : hover = {
                contents: {
                  kind: "markdown",
                  value: ""
                }
              };
              hover.range = errorAndMarkup.error.range;
              if (typeof hover.contents !== "object" || typeof hover.contents !== "string") {
                hover.contents = {
                  kind: "markdown",
                  value: hover.contents
                };
              }
              if (hover.contents.value) {
                hover.contents.value += "\n\n---\n\n";
              }
              hover.contents.value += errorAndMarkup.markup.value;
            }
          }
        }
        return hover;
      });
    }
    exports2.register = register;
    function getHoverTexts(hover) {
      if (typeof hover.contents === "string") {
        return [hover.contents];
      }
      if (Array.isArray(hover.contents)) {
        return hover.contents.map((content) => {
          if (typeof content === "string") {
            return content;
          }
          return `\`\`\`${content.language}
${content.value}
\`\`\``;
        });
      }
      if ("kind" in hover.contents) {
        return [hover.contents.value];
      }
      return [`\`\`\`${hover.contents.language}
${hover.contents.value}
\`\`\``];
    }
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/inlayHints.js
var require_inlayHints = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/inlayHints.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var transformer = require_transformer();
    var common_1 = require_common();
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, _1, ..._2) => __async(this, [_04, _1, ..._2], function* (uri, range, token = cancellation_1.NoneCancellationToken) {
        const document2 = context.getTextDocument(uri);
        if (!document2)
          return;
        const offsetRange = {
          start: document2.offsetAt(range.start),
          end: document2.offsetAt(range.end)
        };
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, range, (_arg, map, file) => {
          var _a3, _b;
          if (!file.capabilities.inlayHint)
            return [];
          let minStart;
          let maxEnd;
          for (const mapping of map.map.mappings) {
            const overlapRange = (0, common_1.getOverlapRange)(offsetRange.start, offsetRange.end, mapping.sourceRange[0], mapping.sourceRange[1]);
            if (overlapRange) {
              const start = (_a3 = map.map.toGeneratedOffset(overlapRange.start)) == null ? void 0 : _a3[0];
              const end = (_b = map.map.toGeneratedOffset(overlapRange.end)) == null ? void 0 : _b[0];
              if (start !== void 0 && end !== void 0) {
                minStart = minStart === void 0 ? start : Math.min(start, minStart);
                maxEnd = maxEnd === void 0 ? end : Math.max(end, maxEnd);
              }
            }
          }
          if (minStart !== void 0 && maxEnd !== void 0) {
            return [{
              start: map.virtualFileDocument.positionAt(minStart),
              end: map.virtualFileDocument.positionAt(maxEnd)
            }];
          }
          return [];
        }, (service, document3, arg) => __async(this, null, function* () {
          var _a3;
          if (token.isCancellationRequested)
            return;
          const hints = yield (_a3 = service.provideInlayHints) == null ? void 0 : _a3.call(service, document3, arg, token);
          hints == null ? void 0 : hints.forEach((link) => {
            link.data = {
              uri,
              original: {
                data: link.data
              },
              serviceId: Object.keys(context.services).find((key) => context.services[key] === service)
            };
          });
          return hints;
        }), (inlayHints, map) => inlayHints.map((_inlayHint) => {
          var _a3;
          if (!map)
            return _inlayHint;
          const position = map.toSourcePosition(
            _inlayHint.position,
            (data) => !!data.semanticTokens
            /* todo */
          );
          const edits = (_a3 = _inlayHint.textEdits) == null ? void 0 : _a3.map((textEdit) => transformer.asTextEdit(textEdit, (range2) => map.toSourceRange(range2), map.virtualFileDocument)).filter(common_1.notEmpty);
          if (position) {
            return __spreadProps(__spreadValues({}, _inlayHint), {
              position,
              textEdits: edits
            });
          }
        }).filter(common_1.notEmpty), (arr) => arr.flat());
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/inlayHintResolve.js
var require_inlayHintResolve = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/inlayHintResolve.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (item, token = cancellation_1.NoneCancellationToken) {
        const data = item.data;
        if (data) {
          const service = context.services[data.serviceId];
          if (!service.resolveInlayHint)
            return item;
          Object.assign(item, data.original);
          item = yield service.resolveInlayHint(item, token);
        }
        return item;
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/renamePrepare.js
var require_renamePrepare = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/renamePrepare.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => typeof data.rename === "object" ? !!data.rename.normalize : !!data.rename), (service, document2, position2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideRenameRange) == null ? void 0 : _a3.call(service, document2, position2, token);
        }, (item, map) => {
          if (!map) {
            return item;
          }
          if ("start" in item && "end" in item) {
            return map.toSourceRange(item);
          }
          return item;
        }, (prepares) => {
          for (const prepare of prepares) {
            if ("start" in prepare && "end" in prepare) {
              return prepare;
            }
          }
          return prepares[0];
        });
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/signatureHelp.js
var require_signatureHelp = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/signatureHelp.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, signatureHelpContext = {
        triggerKind: 1,
        isRetrigger: false
      }, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => !!data.completion), (service, document2, position2) => {
          var _a3, _b;
          if (token.isCancellationRequested)
            return;
          if ((signatureHelpContext == null ? void 0 : signatureHelpContext.triggerKind) === 2 && signatureHelpContext.triggerCharacter && !((_a3 = signatureHelpContext.isRetrigger ? service.signatureHelpRetriggerCharacters : service.signatureHelpTriggerCharacters) == null ? void 0 : _a3.includes(signatureHelpContext.triggerCharacter))) {
            return;
          }
          return (_b = service.provideSignatureHelp) == null ? void 0 : _b.call(service, document2, position2, signatureHelpContext, token);
        }, (data) => data);
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/languageFeatures/workspaceSymbols.js
var require_workspaceSymbols = __commonJS({
  "node_modules/@volar/language-service/lib/languageFeatures/workspaceSymbols.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var transformer = require_transformer();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (_04, ..._1) => __async(this, [_04, ..._1], function* (query, token = cancellation_1.NoneCancellationToken) {
        const symbolsList = [];
        for (const service of Object.values(context.services)) {
          if (token.isCancellationRequested)
            break;
          if (!service.provideWorkspaceSymbols)
            continue;
          const embeddedSymbols = yield service.provideWorkspaceSymbols(query, token);
          if (!embeddedSymbols)
            continue;
          const symbols = embeddedSymbols.map((symbol) => transformer.asWorkspaceSymbol(symbol, (loc) => {
            if (context.documents.isVirtualFileUri(loc.uri)) {
              for (const [_, map] of context.documents.getMapsByVirtualFileUri(loc.uri)) {
                const range = map.toSourceRange(loc.range);
                if (range) {
                  return { uri: map.sourceFileDocument.uri, range };
                }
              }
            } else {
              return loc;
            }
          })).filter(common_1.notEmpty);
          symbolsList.push(symbols);
        }
        return symbolsList.flat();
      });
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/colorPresentations.js
var require_colorPresentations = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/colorPresentations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, color, range, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, range, (range2, map, file) => {
          if (file.capabilities.documentSymbol)
            return map.toGeneratedRanges(range2);
          return [];
        }, (service, document2, range2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideColorPresentations) == null ? void 0 : _a3.call(service, document2, color, range2, token);
        }, (data, map) => map ? data.map((cp) => {
          if (cp.textEdit) {
            const range2 = map.toSourceRange(cp.textEdit.range);
            if (!range2)
              return void 0;
            cp.textEdit.range = range2;
          }
          if (cp.additionalTextEdits) {
            for (const textEdit of cp.additionalTextEdits) {
              const range2 = map.toSourceRange(textEdit.range);
              if (!range2)
                return void 0;
              textEdit.range = range2;
            }
          }
          return cp;
        }).filter(common_1.notEmpty) : data);
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/documentColors.js
var require_documentColors = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/documentColors.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.documentFeatureWorker)(
          context,
          uri,
          (file) => !!file.capabilities.documentSymbol,
          // TODO: add color capability setting
          (service, document2) => {
            var _a3;
            if (token.isCancellationRequested)
              return;
            return (_a3 = service.provideDocumentColors) == null ? void 0 : _a3.call(service, document2, token);
          },
          (data, map) => map ? data.map((color) => {
            const range = map.toSourceRange(color.range);
            if (range) {
              return {
                range,
                color: color.color
              };
            }
          }).filter(common_1.notEmpty) : data,
          (arr) => arr.flat()
        );
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/documentSymbols.js
var require_documentSymbols = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/documentSymbols.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var transformer = require_transformer();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.documentSymbol, (service, document2) => __async(this, null, function* () {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideDocumentSymbols) == null ? void 0 : _a3.call(service, document2, token);
        }), (data, map) => map ? data.map((symbol) => transformer.asDocumentSymbol(symbol, (range) => map.toSourceRange(range))).filter(common_1.notEmpty) : data, (results) => {
          for (let i = 0; i < results.length; i++) {
            for (let j = 0; j < results.length; j++) {
              if (i === j)
                continue;
              results[i] = results[i].filter((child) => {
                var _a3;
                for (const parent of results[j]) {
                  if ((0, common_1.isInsideRange)(parent.range, child.range)) {
                    (_a3 = parent.children) != null ? _a3 : parent.children = [];
                    parent.children.push(child);
                    return false;
                  }
                }
                return true;
              });
            }
          }
          return results.flat();
        });
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/foldingRanges.js
var require_foldingRanges2 = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/foldingRanges.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var transformer = require_transformer();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.documentFeatureWorker)(context, uri, (file) => !!file.capabilities.foldingRange, (service, document2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideFoldingRanges) == null ? void 0 : _a3.call(service, document2, token);
        }, (data, map) => map ? transformer.asFoldingRanges(data, (range) => map.toSourceRange(range)) : data, (arr) => arr.flat());
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/format.js
var require_format = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/format.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var language_core_1 = require_language_core();
    var vscode_languageserver_textdocument_1 = require_main6();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    var documents_1 = require_documents();
    function register(context) {
      let fakeVersion = 0;
      return (_04, _1, _2, _3, ..._4) => __async(this, [_04, _1, _2, _3, ..._4], function* (uri, options, range, onTypeParams, token = cancellation_1.NoneCancellationToken) {
        var _a3, _b, _c, _d, _e, _f2;
        let document2 = context.getTextDocument(uri);
        if (!document2)
          return;
        range != null ? range : range = {
          start: document2.positionAt(0),
          end: document2.positionAt(document2.getText().length)
        };
        const source = context.documents.getSourceByUri(document2.uri);
        if (!source) {
          return onTypeParams ? (_a3 = yield tryFormat(document2, onTypeParams.position, onTypeParams.ch)) == null ? void 0 : _a3.edits : (_b = yield tryFormat(document2, range, void 0)) == null ? void 0 : _b.edits;
        }
        const initialIndentLanguageId = (_e = yield (_d = (_c = context.env).getConfiguration) == null ? void 0 : _d.call(_c, "volar.format.initialIndent")) != null ? _e : { html: true };
        let tempSourceSnapshot = source.snapshot;
        const tempVirtualFile = source.language.createVirtualFile(source.fileName, source.snapshot, source.languageId);
        const originalDocument = document2;
        let level = 0;
        while (true) {
          const embeddedFiles = getEmbeddedFilesByLevel(tempVirtualFile, level++);
          if (embeddedFiles.length === 0)
            break;
          let edits = [];
          const toPatchIndent = [];
          for (const file of embeddedFiles) {
            if (!file.capabilities.documentFormatting)
              continue;
            const isCodeBlock = file.mappings.length === 1 && file.mappings[0].generatedRange[0] === 0 && file.mappings[0].generatedRange[1] === file.snapshot.getLength();
            if (onTypeParams && !isCodeBlock)
              continue;
            const docMap = createDocMap(file, source.fileName, tempSourceSnapshot);
            if (!docMap)
              continue;
            let embeddedCodeResult;
            if (onTypeParams) {
              const embeddedPosition = docMap.toGeneratedPosition(onTypeParams.position);
              if (embeddedPosition) {
                embeddedCodeResult = yield tryFormat(docMap.virtualFileDocument, embeddedPosition, onTypeParams.ch);
              }
            } else {
              embeddedCodeResult = yield tryFormat(docMap.virtualFileDocument, {
                start: docMap.virtualFileDocument.positionAt(0),
                end: docMap.virtualFileDocument.positionAt(docMap.virtualFileDocument.getText().length)
              });
            }
            if (!embeddedCodeResult)
              continue;
            toPatchIndent.push({
              virtualFileName: file.fileName,
              isCodeBlock,
              service: embeddedCodeResult.service
            });
            for (const textEdit2 of embeddedCodeResult.edits) {
              const range2 = docMap.toSourceRange(textEdit2.range);
              if (range2) {
                edits.push({
                  newText: textEdit2.newText,
                  range: range2
                });
              }
            }
          }
          edits = edits.filter((edit) => (0, common_1.isInsideRange)(range, edit.range));
          if (edits.length > 0) {
            const newText = vscode_languageserver_textdocument_1.TextDocument.applyEdits(document2, edits);
            document2 = vscode_languageserver_textdocument_1.TextDocument.create(document2.uri, document2.languageId, document2.version + 1, newText);
            tempSourceSnapshot = (0, common_1.stringToSnapshot)(newText);
            source.language.updateVirtualFile(tempVirtualFile, tempSourceSnapshot);
          }
          if (level > 1) {
            const baseIndent = options.insertSpaces ? " ".repeat(options.tabSize) : "	";
            const editLines = /* @__PURE__ */ new Set();
            if (onTypeParams) {
              for (const edit of edits) {
                for (let line = edit.range.start.line; line <= edit.range.end.line; line++) {
                  editLines.add(line);
                }
              }
            }
            for (const item of toPatchIndent) {
              let virtualFile;
              (0, language_core_1.forEachEmbeddedFile)(tempVirtualFile, (file) => {
                if (file.fileName === item.virtualFileName) {
                  virtualFile = file;
                }
              });
              const docMap = createDocMap(virtualFile, source.fileName, tempSourceSnapshot);
              if (!docMap)
                continue;
              const indentSensitiveLines = /* @__PURE__ */ new Set();
              for (const service of item.service.provideFormattingIndentSensitiveLines ? [item.service] : Object.values(context.services)) {
                if (token.isCancellationRequested)
                  break;
                if (service.provideFormattingIndentSensitiveLines) {
                  const lines = yield service.provideFormattingIndentSensitiveLines(docMap.virtualFileDocument, token);
                  if (lines) {
                    for (const line of lines) {
                      const sourceLine = (_f2 = docMap.toSourcePosition({ line, character: 0 })) == null ? void 0 : _f2.line;
                      if (sourceLine !== void 0) {
                        indentSensitiveLines.add(sourceLine);
                      }
                    }
                  }
                }
              }
              let indentEdits = patchIndents(document2, item.isCodeBlock, docMap.map, initialIndentLanguageId[docMap.virtualFileDocument.languageId] ? baseIndent : "");
              indentEdits = indentEdits.filter((edit) => {
                for (let line = edit.range.start.line; line <= edit.range.end.line; line++) {
                  if (indentSensitiveLines.has(line) && !edit.newText.includes("\n")) {
                    return false;
                  }
                  if (onTypeParams && !editLines.has(line)) {
                    return false;
                  }
                  if (!(0, common_1.isInsideRange)(range, edit.range)) {
                    return false;
                  }
                }
                return true;
              });
              if (indentEdits.length > 0) {
                const newText = vscode_languageserver_textdocument_1.TextDocument.applyEdits(document2, indentEdits);
                document2 = vscode_languageserver_textdocument_1.TextDocument.create(document2.uri, document2.languageId, document2.version + 1, newText);
                tempSourceSnapshot = (0, common_1.stringToSnapshot)(newText);
                source.language.updateVirtualFile(tempVirtualFile, tempSourceSnapshot);
              }
            }
          }
        }
        if (document2.getText() === originalDocument.getText())
          return;
        const editRange = {
          start: originalDocument.positionAt(0),
          end: originalDocument.positionAt(originalDocument.getText().length)
        };
        const textEdit = {
          range: editRange,
          newText: document2.getText()
        };
        return [textEdit];
        function getEmbeddedFilesByLevel(rootFile, level2) {
          const embeddedFilesByLevel = [[rootFile]];
          while (true) {
            if (embeddedFilesByLevel.length > level2)
              return embeddedFilesByLevel[level2];
            let nextLevel = [];
            for (const file of embeddedFilesByLevel[embeddedFilesByLevel.length - 1]) {
              nextLevel = nextLevel.concat(file.embeddedFiles);
            }
            embeddedFilesByLevel.push(nextLevel);
          }
        }
        function tryFormat(document3, range2, ch) {
          return __async(this, null, function* () {
            var _a4, _b2, _c2;
            let formatRange = range2;
            for (const service of Object.values(context.services)) {
              if (token.isCancellationRequested)
                break;
              let edits;
              try {
                if (ch !== void 0 && "line" in formatRange && "character" in formatRange) {
                  if ((_a4 = service.autoFormatTriggerCharacters) == null ? void 0 : _a4.includes(ch)) {
                    edits = yield (_b2 = service.provideOnTypeFormattingEdits) == null ? void 0 : _b2.call(service, document3, formatRange, ch, options, token);
                  }
                } else if (ch === void 0 && "start" in formatRange && "end" in formatRange) {
                  edits = yield (_c2 = service.provideDocumentFormattingEdits) == null ? void 0 : _c2.call(service, document3, formatRange, options, token);
                }
              } catch (err) {
                console.warn(err);
              }
              if (!edits)
                continue;
              return {
                service,
                edits
              };
            }
          });
        }
      });
      function createDocMap(file, _sourceFileName, _sourceSnapshot) {
        var _a3, _b, _c, _d, _e, _f2;
        const maps = (0, language_core_1.updateVirtualFileMaps)(file, (sourceFileName) => {
          if (!sourceFileName) {
            return [_sourceFileName, _sourceSnapshot];
          }
        });
        if (maps.has(_sourceFileName) && maps.get(_sourceFileName)[0] === _sourceSnapshot) {
          const [_, map] = maps.get(_sourceFileName);
          const version = fakeVersion++;
          return new documents_1.SourceMapWithDocuments(vscode_languageserver_textdocument_1.TextDocument.create(context.env.fileNameToUri(_sourceFileName), (_c = (_b = (_a3 = context.host).getLanguageId) == null ? void 0 : _b.call(_a3, _sourceFileName)) != null ? _c : (0, common_1.resolveCommonLanguageId)(context.env.fileNameToUri(_sourceFileName)), version, _sourceSnapshot.getText(0, _sourceSnapshot.getLength())), vscode_languageserver_textdocument_1.TextDocument.create(context.env.fileNameToUri(file.fileName), (_f2 = (_e = (_d = context.host).getLanguageId) == null ? void 0 : _e.call(_d, file.fileName)) != null ? _f2 : (0, common_1.resolveCommonLanguageId)(context.env.fileNameToUri(file.fileName)), version, file.snapshot.getText(0, file.snapshot.getLength())), map);
        }
      }
    }
    exports2.register = register;
    function patchIndents(document2, isCodeBlock, map, initialIndent) {
      const indentTextEdits = [];
      if (!isCodeBlock) {
        initialIndent = "";
      }
      for (let i = 0; i < map.mappings.length; i++) {
        const mapping = map.mappings[i];
        const firstLineIndent = getBaseIndent(mapping.sourceRange[0]);
        const text = document2.getText().substring(mapping.sourceRange[0], mapping.sourceRange[1]);
        const lines = text.split("\n");
        const baseIndent = firstLineIndent + initialIndent;
        let lineOffset = lines[0].length + 1;
        let insertedFinalNewLine = false;
        if (!text.trim())
          continue;
        if (isCodeBlock && text.trimStart().length === text.length) {
          indentTextEdits.push({
            newText: "\n" + baseIndent,
            range: {
              start: document2.positionAt(mapping.sourceRange[0]),
              end: document2.positionAt(mapping.sourceRange[0])
            }
          });
        }
        if (isCodeBlock && text.trimEnd().length === text.length) {
          indentTextEdits.push({
            newText: "\n",
            range: {
              start: document2.positionAt(mapping.sourceRange[1]),
              end: document2.positionAt(mapping.sourceRange[1])
            }
          });
          insertedFinalNewLine = true;
        }
        if (baseIndent && lines.length > 1) {
          for (let i2 = 1; i2 < lines.length; i2++) {
            if (lines[i2].trim() || i2 === lines.length - 1) {
              const isLastLine = i2 === lines.length - 1 && !insertedFinalNewLine;
              indentTextEdits.push({
                newText: isLastLine ? firstLineIndent : baseIndent,
                range: {
                  start: document2.positionAt(mapping.sourceRange[0] + lineOffset),
                  end: document2.positionAt(mapping.sourceRange[0] + lineOffset)
                }
              });
            }
            lineOffset += lines[i2].length + 1;
          }
        }
      }
      return indentTextEdits;
      function getBaseIndent(pos) {
        const startPos = document2.positionAt(pos);
        const startLineText = document2.getText({ start: { line: startPos.line, character: 0 }, end: startPos });
        return startLineText.substring(0, startLineText.length - startLineText.trimStart().length);
      }
    }
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/linkedEditingRanges.js
var require_linkedEditingRanges = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/linkedEditingRanges.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, position, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, position, (position2, map) => map.toGeneratedPositions(position2, (data) => !!data.completion), (service, document2, position2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideLinkedEditingRanges) == null ? void 0 : _a3.call(service, document2, position2, token);
        }, (data, map) => map ? {
          wordPattern: data.wordPattern,
          ranges: data.ranges.map((range) => map.toSourceRange(range)).filter(common_1.notEmpty)
        } : data);
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/documentFeatures/selectionRanges.js
var require_selectionRanges2 = __commonJS({
  "node_modules/@volar/language-service/lib/documentFeatures/selectionRanges.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var featureWorkers_1 = require_featureWorkers();
    var transformer = require_transformer();
    var common_1 = require_common();
    var cancellation_1 = require_cancellation2();
    function register(context) {
      return (uri, positions, token = cancellation_1.NoneCancellationToken) => {
        return (0, featureWorkers_1.languageFeatureWorker)(context, uri, positions, (positions2, map, file) => {
          if (file.capabilities.documentFormatting) {
            const result = positions2.map((position) => map.toGeneratedPosition(position)).filter(common_1.notEmpty);
            if (result.length) {
              return [result];
            }
          }
          return [];
        }, (service, document2, positions2) => {
          var _a3;
          if (token.isCancellationRequested)
            return;
          return (_a3 = service.provideSelectionRanges) == null ? void 0 : _a3.call(service, document2, positions2, token);
        }, (item, map) => map ? transformer.asSelectionRanges(item, (range) => map.toSourceRange(range)) : item, (results) => {
          const result = [];
          for (let i = 0; i < positions.length; i++) {
            let pluginResults = [];
            for (const ranges of results) {
              pluginResults.push(ranges[i]);
            }
            pluginResults = pluginResults.sort((a3, b) => {
              if ((0, common_1.isInsideRange)(a3.range, b.range)) {
                return 1;
              }
              if ((0, common_1.isInsideRange)(b.range, a3.range)) {
                return -1;
              }
              return 0;
            });
            for (let i2 = 1; i2 < pluginResults.length; i2++) {
              let root = pluginResults[i2 - 1];
              while (root.parent) {
                root = root.parent;
              }
              let parent = pluginResults[i2];
              while (parent && !(0, common_1.isInsideRange)(parent.range, root.range)) {
                parent = parent.parent;
              }
              if (parent) {
                root.parent = parent;
              }
            }
            result.push(pluginResults[0]);
          }
          return result;
        });
      };
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-service/lib/baseLanguageService.js
var require_baseLanguageService = __commonJS({
  "node_modules/@volar/language-service/lib/baseLanguageService.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createLanguageService = void 0;
    var language_core_1 = require_language_core();
    var vscode_languageserver_textdocument_1 = require_main6();
    var documents_1 = require_documents();
    var autoInsert = require_autoInsert();
    var callHierarchy = require_callHierarchy2();
    var codeActionResolve = require_codeActionResolve();
    var codeActions = require_codeActions();
    var codeLens = require_codeLens();
    var codeLensResolve = require_codeLensResolve();
    var completions = require_complete();
    var completionResolve = require_completeResolve();
    var definition = require_definition();
    var documentHighlight = require_documentHighlights();
    var documentLink = require_documentLinks();
    var documentLinkResolve = require_documentLinkResolve();
    var semanticTokens = require_documentSemanticTokens();
    var fileReferences = require_fileReferences();
    var fileRename = require_fileRename();
    var hover = require_hover2();
    var inlayHints = require_inlayHints();
    var inlayHintResolve = require_inlayHintResolve();
    var references = require_references();
    var rename = require_rename();
    var renamePrepare = require_renamePrepare();
    var signatureHelp = require_signatureHelp();
    var diagnostics = require_validation();
    var workspaceSymbol = require_workspaceSymbols();
    var colorPresentations = require_colorPresentations();
    var documentColors = require_documentColors();
    var documentSymbols = require_documentSymbols();
    var foldingRanges = require_foldingRanges2();
    var format8 = require_format();
    var linkedEditingRanges = require_linkedEditingRanges();
    var selectionRanges = require_selectionRanges2();
    var common_1 = require_common();
    function createLanguageService(modules, env, config, languageHost) {
      var _a3;
      if (languageHost.workspacePath.indexOf("\\") >= 0 || languageHost.rootPath.indexOf("\\") >= 0) {
        throw new Error("Volar: Current directory must be posix style.");
      }
      if (languageHost.getScriptFileNames().some((fileName) => fileName.indexOf("\\") >= 0)) {
        throw new Error("Volar: Script file names must be posix style.");
      }
      const languageContext = (0, language_core_1.createLanguageContext)(languageHost, Object.values((_a3 = config.languages) != null ? _a3 : {}).filter(common_1.notEmpty));
      const context = createLanguageServicePluginContext(modules, env, config, languageHost, languageContext);
      return createLanguageServiceBase(context);
    }
    exports2.createLanguageService = createLanguageService;
    function createLanguageServicePluginContext(modules, env, config, host, languageContext) {
      var _a3, _b, _c;
      const textDocumentMapper = (0, documents_1.createDocumentsAndSourceMaps)(env, host, languageContext.virtualFiles);
      const documents = /* @__PURE__ */ new WeakMap();
      const documentVersions = /* @__PURE__ */ new Map();
      const context = __spreadProps(__spreadValues({}, languageContext), {
        env,
        inject: (key, ...args) => {
          var _a4;
          for (const service of Object.values(context.services)) {
            const provide = (_a4 = service.provide) == null ? void 0 : _a4[key];
            if (provide) {
              return provide(...args);
            }
          }
          throw `No service provide ${key}`;
        },
        rules: (_a3 = config.rules) != null ? _a3 : {},
        services: {},
        documents: textDocumentMapper,
        commands: {
          rename: {
            create(uri, position) {
              const source = toSourceLocation(uri, position, (data) => typeof data.rename === "object" ? !!data.rename.normalize : !!data.rename);
              if (!source) {
                return;
              }
              return {
                title: "",
                command: "editor.action.rename",
                arguments: [
                  source.uri,
                  source.position
                ]
              };
            },
            is(command) {
              return command.command === "editor.action.rename";
            }
          },
          showReferences: {
            create(uri, position, locations) {
              const source = toSourceLocation(uri, position);
              if (!source) {
                return;
              }
              const sourceReferences = [];
              for (const reference of locations) {
                if (context.documents.isVirtualFileUri(reference.uri)) {
                  for (const [_, map] of context.documents.getMapsByVirtualFileUri(reference.uri)) {
                    const range = map.toSourceRange(reference.range);
                    if (range) {
                      sourceReferences.push({ uri: map.sourceFileDocument.uri, range });
                    }
                  }
                } else {
                  sourceReferences.push(reference);
                }
              }
              return {
                title: locations.length === 1 ? "1 reference" : `${locations.length} references`,
                command: "editor.action.showReferences",
                arguments: [
                  source.uri,
                  source.position,
                  sourceReferences
                ]
              };
            },
            is(command) {
              return command.command === "editor.action.showReferences";
            }
          },
          setSelection: {
            create(position) {
              return {
                title: "",
                command: "setSelection",
                arguments: [{
                  selection: {
                    selectionStartLineNumber: position.line + 1,
                    positionLineNumber: position.line + 1,
                    selectionStartColumn: position.character + 1,
                    positionColumn: position.character + 1
                  }
                }]
              };
            },
            is(command) {
              return command.command === "setSelection";
            }
          }
        },
        getTextDocument
      });
      for (const serviceId in (_b = config.services) != null ? _b : {}) {
        const service = (_c = config.services) == null ? void 0 : _c[serviceId];
        if (service) {
          context.services[serviceId] = service(context, modules);
        }
      }
      return context;
      function toSourceLocation(uri, position, filter) {
        if (!textDocumentMapper.isVirtualFileUri(uri)) {
          return { uri, position };
        }
        const map = textDocumentMapper.getVirtualFileByUri(uri);
        if (map) {
          for (const [_, map2] of context.documents.getMapsByVirtualFileUri(uri)) {
            const sourcePosition = map2.toSourcePosition(position, filter);
            if (sourcePosition) {
              return {
                uri: map2.sourceFileDocument.uri,
                position: sourcePosition
              };
            }
          }
        }
      }
      function getTextDocument(uri) {
        var _a4, _b2, _c2;
        for (const [_, map] of context.documents.getMapsByVirtualFileUri(uri)) {
          return map.virtualFileDocument;
        }
        const fileName = env.uriToFileName(uri);
        const scriptSnapshot = host.getScriptSnapshot(fileName);
        if (scriptSnapshot) {
          let document2 = documents.get(scriptSnapshot);
          if (!document2) {
            const newVersion = ((_a4 = documentVersions.get(uri.toLowerCase())) != null ? _a4 : 0) + 1;
            documentVersions.set(uri.toLowerCase(), newVersion);
            document2 = vscode_languageserver_textdocument_1.TextDocument.create(uri, (_c2 = (_b2 = host.getLanguageId) == null ? void 0 : _b2.call(host, fileName)) != null ? _c2 : (0, common_1.resolveCommonLanguageId)(uri), newVersion, scriptSnapshot.getText(0, scriptSnapshot.getLength()));
            documents.set(scriptSnapshot, document2);
          }
          return document2;
        }
      }
    }
    function createLanguageServiceBase(context) {
      return {
        getTriggerCharacters: () => Object.values(context.services).map((service) => {
          var _a3;
          return (_a3 = service == null ? void 0 : service.triggerCharacters) != null ? _a3 : [];
        }).flat(),
        getAutoFormatTriggerCharacters: () => Object.values(context.services).map((service) => {
          var _a3;
          return (_a3 = service == null ? void 0 : service.autoFormatTriggerCharacters) != null ? _a3 : [];
        }).flat(),
        getSignatureHelpTriggerCharacters: () => Object.values(context.services).map((service) => {
          var _a3;
          return (_a3 = service == null ? void 0 : service.signatureHelpTriggerCharacters) != null ? _a3 : [];
        }).flat(),
        getSignatureHelpRetriggerCharacters: () => Object.values(context.services).map((service) => {
          var _a3;
          return (_a3 = service == null ? void 0 : service.signatureHelpRetriggerCharacters) != null ? _a3 : [];
        }).flat(),
        format: format8.register(context),
        getFoldingRanges: foldingRanges.register(context),
        getSelectionRanges: selectionRanges.register(context),
        findLinkedEditingRanges: linkedEditingRanges.register(context),
        findDocumentSymbols: documentSymbols.register(context),
        findDocumentColors: documentColors.register(context),
        getColorPresentations: colorPresentations.register(context),
        doValidation: diagnostics.register(context),
        findReferences: references.register(context),
        findFileReferences: fileReferences.register(context),
        findDefinition: definition.register(context, "provideDefinition", (data) => !!data.definition, (data) => !!data.definition),
        findTypeDefinition: definition.register(context, "provideTypeDefinition", (data) => !!data.definition, (data) => !!data.definition),
        findImplementations: definition.register(context, "provideImplementation", (data) => !!data.references, () => false),
        prepareRename: renamePrepare.register(context),
        doRename: rename.register(context),
        getEditsForFileRename: fileRename.register(context),
        getSemanticTokens: semanticTokens.register(context),
        doHover: hover.register(context),
        doComplete: completions.register(context),
        doCodeActions: codeActions.register(context),
        doCodeActionResolve: codeActionResolve.register(context),
        doCompletionResolve: completionResolve.register(context),
        getSignatureHelp: signatureHelp.register(context),
        doCodeLens: codeLens.register(context),
        doCodeLensResolve: codeLensResolve.register(context),
        findDocumentHighlights: documentHighlight.register(context),
        findDocumentLinks: documentLink.register(context),
        doDocumentLinkResolve: documentLinkResolve.register(context),
        findWorkspaceSymbols: workspaceSymbol.register(context),
        doAutoInsert: autoInsert.register(context),
        getInlayHints: inlayHints.register(context),
        doInlayHintResolve: inlayHintResolve.register(context),
        callHierarchy: callHierarchy.register(context),
        dispose: () => Object.values(context.services).forEach((service) => {
          var _a3;
          return (_a3 = service.dispose) == null ? void 0 : _a3.call(service);
        }),
        context
      };
    }
  }
});

// node_modules/@volar/language-service/index.js
var require_language_service = __commonJS({
  "node_modules/@volar/language-service/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.standardSemanticTokensLegend = exports2.transformer = exports2.mergeWorkspaceEdits = void 0;
    __exportStar(require_language_core(), exports2);
    __exportStar(require_baseLanguageService(), exports2);
    __exportStar(require_documents(), exports2);
    var rename_1 = require_rename();
    Object.defineProperty(exports2, "mergeWorkspaceEdits", { enumerable: true, get: function() {
      return rename_1.mergeWorkspaceEdits;
    } });
    __exportStar(require_types3(), exports2);
    exports2.transformer = require_transformer();
    exports2.standardSemanticTokensLegend = {
      tokenTypes: [
        "namespace",
        "class",
        "enum",
        "interface",
        "struct",
        "typeParameter",
        "type",
        "parameter",
        "variable",
        "property",
        "enumMember",
        "decorator",
        "event",
        "function",
        "method",
        "macro",
        "label",
        "comment",
        "string",
        "keyword",
        "number",
        "regexp",
        "operator"
      ],
      tokenModifiers: [
        "declaration",
        "definition",
        "readonly",
        "static",
        "deprecated",
        "abstract",
        "async",
        "modification",
        "documentation",
        "defaultLibrary"
      ]
    };
  }
});

// node_modules/@vscode/l10n/dist/main.js
var require_main7 = __commonJS({
  "node_modules/@vscode/l10n/dist/main.js"(exports2, module2) {
    "use strict";
    var __create2 = Object.create;
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc2 = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __getProtoOf2 = Object.getPrototypeOf;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __commonJS2 = (cb, mod) => function __require() {
      return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
    };
    var __export2 = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps2 = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc2(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toESM2 = (mod, isNodeMode, target) => (target = mod != null ? __create2(__getProtoOf2(mod)) : {}, __copyProps2(
      isNodeMode || !mod || !mod.__esModule ? __defProp2(target, "default", { value: mod, enumerable: true }) : target,
      mod
    ));
    var __toCommonJS2 = (mod) => __copyProps2(__defProp2({}, "__esModule", { value: true }), mod);
    var require_main12 = __commonJS2({
      "node_modules/request-light/lib/node/main.js"(exports3) {
        (() => {
          var e = { 46: (e2, t32) => {
            "use strict";
            Object.defineProperty(t32, "__esModule", { value: true }), t32.default = function(e3, t42, { signal: o2 } = {}) {
              return new Promise((r2, n2) => {
                function s() {
                  null == o2 || o2.removeEventListener("abort", s), e3.removeListener(t42, a3), e3.removeListener("error", u);
                }
                function a3(...e4) {
                  s(), r2(e4);
                }
                function u(e4) {
                  s(), n2(e4);
                }
                null == o2 || o2.addEventListener("abort", s), e3.on(t42, a3), e3.on("error", u);
              });
            };
          }, 54: function(e2, t32, o2) {
            "use strict";
            var r2 = this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            };
            const n2 = o2(361), s = r2(o2(374)), a3 = r2(o2(304)), u = s.default("agent-base");
            function i() {
              const { stack: e3 } = new Error();
              return "string" == typeof e3 && e3.split("\n").some((e4) => -1 !== e4.indexOf("(https.js:") || -1 !== e4.indexOf("node:https:"));
            }
            function c(e3, t42) {
              return new c.Agent(e3, t42);
            }
            !function(e3) {
              class t42 extends n2.EventEmitter {
                constructor(e4, t52) {
                  super();
                  let o3 = t52;
                  "function" == typeof e4 ? this.callback = e4 : e4 && (o3 = e4), this.timeout = null, o3 && "number" == typeof o3.timeout && (this.timeout = o3.timeout), this.maxFreeSockets = 1, this.maxSockets = 1, this.maxTotalSockets = 1 / 0, this.sockets = {}, this.freeSockets = {}, this.requests = {}, this.options = {};
                }
                get defaultPort() {
                  return "number" == typeof this.explicitDefaultPort ? this.explicitDefaultPort : i() ? 443 : 80;
                }
                set defaultPort(e4) {
                  this.explicitDefaultPort = e4;
                }
                get protocol() {
                  return "string" == typeof this.explicitProtocol ? this.explicitProtocol : i() ? "https:" : "http:";
                }
                set protocol(e4) {
                  this.explicitProtocol = e4;
                }
                callback(e4, t52, o3) {
                  throw new Error('"agent-base" has no default implementation, you must subclass and override `callback()`');
                }
                addRequest(e4, t52) {
                  const o3 = Object.assign({}, t52);
                  "boolean" != typeof o3.secureEndpoint && (o3.secureEndpoint = i()), null == o3.host && (o3.host = "localhost"), null == o3.port && (o3.port = o3.secureEndpoint ? 443 : 80), null == o3.protocol && (o3.protocol = o3.secureEndpoint ? "https:" : "http:"), o3.host && o3.path && delete o3.path, delete o3.agent, delete o3.hostname, delete o3._defaultAgent, delete o3.defaultPort, delete o3.createConnection, e4._last = true, e4.shouldKeepAlive = false;
                  let r3 = false, n3 = null;
                  const s2 = o3.timeout || this.timeout, c2 = (t62) => {
                    e4._hadError || (e4.emit("error", t62), e4._hadError = true);
                  }, l = () => {
                    n3 = null, r3 = true;
                    const e5 = new Error(`A "socket" was not created for HTTP request before ${s2}ms`);
                    e5.code = "ETIMEOUT", c2(e5);
                  }, d = (e5) => {
                    r3 || (null !== n3 && (clearTimeout(n3), n3 = null), c2(e5));
                  }, f3 = (t62) => {
                    if (r3)
                      return;
                    if (null != n3 && (clearTimeout(n3), n3 = null), s3 = t62, Boolean(s3) && "function" == typeof s3.addRequest)
                      return u("Callback returned another Agent instance %o", t62.constructor.name), void t62.addRequest(e4, o3);
                    var s3;
                    if (t62)
                      return t62.once("free", () => {
                        this.freeSocket(t62, o3);
                      }), void e4.onSocket(t62);
                    const a22 = new Error(`no Duplex stream was returned to agent-base for \`${e4.method} ${e4.path}\``);
                    c2(a22);
                  };
                  if ("function" == typeof this.callback) {
                    this.promisifiedCallback || (this.callback.length >= 3 ? (u("Converting legacy callback function to promise"), this.promisifiedCallback = a3.default(this.callback)) : this.promisifiedCallback = this.callback), "number" == typeof s2 && s2 > 0 && (n3 = setTimeout(l, s2)), "port" in o3 && "number" != typeof o3.port && (o3.port = Number(o3.port));
                    try {
                      u("Resolving socket for %o request: %o", o3.protocol, `${e4.method} ${e4.path}`), Promise.resolve(this.promisifiedCallback(e4, o3)).then(f3, d);
                    } catch (e5) {
                      Promise.reject(e5).catch(d);
                    }
                  } else
                    c2(new Error("`callback` is not defined"));
                }
                freeSocket(e4, t52) {
                  u("Freeing socket %o %o", e4.constructor.name, t52), e4.destroy();
                }
                destroy() {
                  u("Destroying agent %o", this.constructor.name);
                }
              }
              e3.Agent = t42, e3.prototype = e3.Agent.prototype;
            }(c || (c = {})), e2.exports = c;
          }, 304: (e2, t32) => {
            "use strict";
            Object.defineProperty(t32, "__esModule", { value: true }), t32.default = function(e3) {
              return function(t42, o2) {
                return new Promise((r2, n2) => {
                  e3.call(this, t42, o2, (e4, t52) => {
                    e4 ? n2(e4) : r2(t52);
                  });
                });
              };
            };
          }, 370: function(e2, t32, o2) {
            "use strict";
            var r2 = this && this.__awaiter || function(e3, t42, o3, r3) {
              return new (o3 || (o3 = Promise))(function(n3, s2) {
                function a22(e4) {
                  try {
                    i2(r3.next(e4));
                  } catch (e5) {
                    s2(e5);
                  }
                }
                function u2(e4) {
                  try {
                    i2(r3.throw(e4));
                  } catch (e5) {
                    s2(e5);
                  }
                }
                function i2(e4) {
                  var t52;
                  e4.done ? n3(e4.value) : (t52 = e4.value, t52 instanceof o3 ? t52 : new o3(function(e5) {
                    e5(t52);
                  })).then(a22, u2);
                }
                i2((r3 = r3.apply(e3, t42 || [])).next());
              });
            }, n2 = this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            };
            Object.defineProperty(t32, "__esModule", { value: true });
            const s = n2(o2(808)), a3 = n2(o2(404)), u = n2(o2(310)), i = n2(o2(374)), c = n2(o2(46)), l = o2(54), d = (0, i.default)("http-proxy-agent");
            class f3 extends l.Agent {
              constructor(e3) {
                let t42;
                if (t42 = "string" == typeof e3 ? u.default.parse(e3) : e3, !t42)
                  throw new Error("an HTTP(S) proxy server `host` and `port` must be specified!");
                d("Creating new HttpProxyAgent instance: %o", t42), super(t42);
                const o3 = Object.assign({}, t42);
                var r3;
                this.secureProxy = t42.secureProxy || "string" == typeof (r3 = o3.protocol) && /^https:?$/i.test(r3), o3.host = o3.hostname || o3.host, "string" == typeof o3.port && (o3.port = parseInt(o3.port, 10)), !o3.port && o3.host && (o3.port = this.secureProxy ? 443 : 80), o3.host && o3.path && (delete o3.path, delete o3.pathname), this.proxy = o3;
              }
              callback(e3, t42) {
                return r2(this, void 0, void 0, function* () {
                  const { proxy: o3, secureProxy: r3 } = this, n3 = u.default.parse(e3.path);
                  let i2;
                  if (n3.protocol || (n3.protocol = "http:"), n3.hostname || (n3.hostname = t42.hostname || t42.host || null), null == n3.port && (t42.port, 1) && (n3.port = String(t42.port)), "80" === n3.port && (n3.port = ""), e3.path = u.default.format(n3), o3.auth && e3.setHeader("Proxy-Authorization", `Basic ${Buffer.from(o3.auth).toString("base64")}`), r3 ? (d("Creating `tls.Socket`: %o", o3), i2 = a3.default.connect(o3)) : (d("Creating `net.Socket`: %o", o3), i2 = s.default.connect(o3)), e3._header) {
                    let t52, o4;
                    d("Regenerating stored HTTP header string for request"), e3._header = null, e3._implicitHeader(), e3.output && e3.output.length > 0 ? (d("Patching connection write() output buffer with updated header"), t52 = e3.output[0], o4 = t52.indexOf("\r\n\r\n") + 4, e3.output[0] = e3._header + t52.substring(o4), d("Output buffer: %o", e3.output)) : e3.outputData && e3.outputData.length > 0 && (d("Patching connection write() output buffer with updated header"), t52 = e3.outputData[0].data, o4 = t52.indexOf("\r\n\r\n") + 4, e3.outputData[0].data = e3._header + t52.substring(o4), d("Output buffer: %o", e3.outputData[0].data));
                  }
                  return yield (0, c.default)(i2, "connect"), i2;
                });
              }
            }
            t32.default = f3;
          }, 201: function(e2, t32, o2) {
            "use strict";
            const r2 = (this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            })(o2(370));
            function n2(e3) {
              return new r2.default(e3);
            }
            !function(e3) {
              e3.HttpProxyAgent = r2.default, e3.prototype = r2.default.prototype;
            }(n2 || (n2 = {})), e2.exports = n2;
          }, 146: function(e2, t32, o2) {
            "use strict";
            var r2 = this && this.__awaiter || function(e3, t42, o3, r3) {
              return new (o3 || (o3 = Promise))(function(n3, s2) {
                function a22(e4) {
                  try {
                    i2(r3.next(e4));
                  } catch (e5) {
                    s2(e5);
                  }
                }
                function u2(e4) {
                  try {
                    i2(r3.throw(e4));
                  } catch (e5) {
                    s2(e5);
                  }
                }
                function i2(e4) {
                  var t52;
                  e4.done ? n3(e4.value) : (t52 = e4.value, t52 instanceof o3 ? t52 : new o3(function(e5) {
                    e5(t52);
                  })).then(a22, u2);
                }
                i2((r3 = r3.apply(e3, t42 || [])).next());
              });
            }, n2 = this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            };
            Object.defineProperty(t32, "__esModule", { value: true });
            const s = n2(o2(808)), a3 = n2(o2(404)), u = n2(o2(310)), i = n2(o2(491)), c = n2(o2(374)), l = o2(54), d = n2(o2(829)), f3 = c.default("https-proxy-agent:agent");
            class p extends l.Agent {
              constructor(e3) {
                let t42;
                if (t42 = "string" == typeof e3 ? u.default.parse(e3) : e3, !t42)
                  throw new Error("an HTTP(S) proxy server `host` and `port` must be specified!");
                f3("creating new HttpsProxyAgent instance: %o", t42), super(t42);
                const o3 = Object.assign({}, t42);
                var r3;
                this.secureProxy = t42.secureProxy || "string" == typeof (r3 = o3.protocol) && /^https:?$/i.test(r3), o3.host = o3.hostname || o3.host, "string" == typeof o3.port && (o3.port = parseInt(o3.port, 10)), !o3.port && o3.host && (o3.port = this.secureProxy ? 443 : 80), this.secureProxy && !("ALPNProtocols" in o3) && (o3.ALPNProtocols = ["http 1.1"]), o3.host && o3.path && (delete o3.path, delete o3.pathname), this.proxy = o3;
              }
              callback(e3, t42) {
                return r2(this, void 0, void 0, function* () {
                  const { proxy: o3, secureProxy: r3 } = this;
                  let n3;
                  r3 ? (f3("Creating `tls.Socket`: %o", o3), n3 = a3.default.connect(o3)) : (f3("Creating `net.Socket`: %o", o3), n3 = s.default.connect(o3));
                  const u2 = Object.assign({}, o3.headers);
                  let c2 = `CONNECT ${t42.host}:${t42.port} HTTP/1.1\r
`;
                  o3.auth && (u2["Proxy-Authorization"] = `Basic ${Buffer.from(o3.auth).toString("base64")}`);
                  let { host: l2, port: p2, secureEndpoint: g } = t42;
                  (function(e4, t52) {
                    return Boolean(!t52 && 80 === e4 || t52 && 443 === e4);
                  })(p2, g) || (l2 += `:${p2}`), u2.Host = l2, u2.Connection = "close";
                  for (const e4 of Object.keys(u2))
                    c2 += `${e4}: ${u2[e4]}\r
`;
                  const v = d.default(n3);
                  n3.write(`${c2}\r
`);
                  const { statusCode: m, buffered: y } = yield v;
                  if (200 === m) {
                    if (e3.once("socket", h), t42.secureEndpoint) {
                      f3("Upgrading socket connection to TLS");
                      const e4 = t42.servername || t42.host;
                      return a3.default.connect(Object.assign(Object.assign({}, function(e5, ...t52) {
                        const o4 = {};
                        let r4;
                        for (r4 in e5)
                          t52.includes(r4) || (o4[r4] = e5[r4]);
                        return o4;
                      }(t42, "host", "hostname", "path", "port")), { socket: n3, servername: e4 }));
                    }
                    return n3;
                  }
                  n3.destroy();
                  const b = new s.default.Socket({ writable: false });
                  return b.readable = true, e3.once("socket", (e4) => {
                    f3("replaying proxy buffer for failed request"), i.default(e4.listenerCount("data") > 0), e4.push(y), e4.push(null);
                  }), b;
                });
              }
            }
            function h(e3) {
              e3.resume();
            }
            t32.default = p;
          }, 18: function(e2, t32, o2) {
            "use strict";
            const r2 = (this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            })(o2(146));
            function n2(e3) {
              return new r2.default(e3);
            }
            !function(e3) {
              e3.HttpsProxyAgent = r2.default, e3.prototype = r2.default.prototype;
            }(n2 || (n2 = {})), e2.exports = n2;
          }, 829: function(e2, t32, o2) {
            "use strict";
            var r2 = this && this.__importDefault || function(e3) {
              return e3 && e3.__esModule ? e3 : { default: e3 };
            };
            Object.defineProperty(t32, "__esModule", { value: true });
            const n2 = r2(o2(374)).default("https-proxy-agent:parse-proxy-response");
            t32.default = function(e3) {
              return new Promise((t42, o3) => {
                let r3 = 0;
                const s = [];
                function a3() {
                  const o4 = e3.read();
                  o4 ? function(e4) {
                    s.push(e4), r3 += e4.length;
                    const o5 = Buffer.concat(s, r3);
                    if (-1 === o5.indexOf("\r\n\r\n"))
                      return n2("have not received end of HTTP headers yet..."), void a3();
                    const u2 = o5.toString("ascii", 0, o5.indexOf("\r\n")), i2 = +u2.split(" ")[1];
                    n2("got proxy server response: %o", u2), t42({ statusCode: i2, buffered: o5 });
                  }(o4) : e3.once("readable", a3);
                }
                function u(e4) {
                  n2("onclose had error %o", e4);
                }
                function i() {
                  n2("onend");
                }
                e3.on("error", function t52(r4) {
                  e3.removeListener("end", i), e3.removeListener("error", t52), e3.removeListener("close", u), e3.removeListener("readable", a3), n2("onerror %o", r4), o3(r4);
                }), e3.on("close", u), e3.on("end", i), a3();
              });
            };
          }, 539: function(e2, t32, o2) {
            "use strict";
            var r2, n2 = this && this.__extends || (r2 = function(e3, t42) {
              return r2 = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(e4, t52) {
                e4.__proto__ = t52;
              } || function(e4, t52) {
                for (var o3 in t52)
                  Object.prototype.hasOwnProperty.call(t52, o3) && (e4[o3] = t52[o3]);
              }, r2(e3, t42);
            }, function(e3, t42) {
              if ("function" != typeof t42 && null !== t42)
                throw new TypeError("Class extends value " + String(t42) + " is not a constructor or null");
              function o3() {
                this.constructor = e3;
              }
              r2(e3, t42), e3.prototype = null === t42 ? Object.create(t42) : (o3.prototype = t42.prototype, new o3());
            }), s = this && this.__assign || function() {
              return s = Object.assign || function(e3) {
                for (var t42, o3 = 1, r3 = arguments.length; o3 < r3; o3++)
                  for (var n3 in t42 = arguments[o3])
                    Object.prototype.hasOwnProperty.call(t42, n3) && (e3[n3] = t42[n3]);
                return e3;
              }, s.apply(this, arguments);
            };
            Object.defineProperty(t32, "__esModule", { value: true }), t32.getErrorStatusDescription = t32.xhr = t32.configure = void 0;
            var a3 = o2(685), u = o2(687), i = o2(310), c = o2(472), l = o2(796), d = o2(201), f3 = o2(18);
            if (process.env.VSCODE_NLS_CONFIG) {
              var p = process.env.VSCODE_NLS_CONFIG;
              c.config(JSON.parse(p));
            }
            var h = c.loadMessageBundle(), g = void 0, v = true;
            function m(e3) {
              var t42;
              return new Promise(function(o3, r3) {
                var n3 = (0, i.parse)(e3.url), s2 = { hostname: n3.hostname, agent: !!e3.agent && e3.agent, port: n3.port ? parseInt(n3.port) : "https:" === n3.protocol ? 443 : 80, path: n3.path, method: e3.type || "GET", headers: e3.headers, rejectUnauthorized: "boolean" != typeof e3.strictSSL || e3.strictSSL };
                e3.user && e3.password && (s2.auth = e3.user + ":" + e3.password);
                var c2 = function(r4) {
                  if (r4.statusCode >= 300 && r4.statusCode < 400 && e3.followRedirects && e3.followRedirects > 0 && r4.headers.location) {
                    var s3 = r4.headers.location;
                    s3.startsWith("/") && (s3 = (0, i.format)({ protocol: n3.protocol, hostname: n3.hostname, port: n3.port, pathname: s3 })), o3(m(function(e4) {
                      for (var t52 = [], o4 = 1; o4 < arguments.length; o4++)
                        t52[o4 - 1] = arguments[o4];
                      return t52.forEach(function(t62) {
                        return Object.keys(t62).forEach(function(o5) {
                          return e4[o5] = t62[o5];
                        });
                      }), e4;
                    }({}, e3, { url: s3, followRedirects: e3.followRedirects - 1 })));
                  } else
                    o3({ req: t42, res: r4 });
                };
                (t42 = "https:" === n3.protocol ? u.request(s2, c2) : a3.request(s2, c2)).on("error", r3), e3.timeout && t42.setTimeout(e3.timeout), e3.data && t42.write(e3.data), t42.end(), e3.token && (e3.token.isCancellationRequested && t42.destroy(new y()), e3.token.onCancellationRequested(function() {
                  t42.destroy(new y());
                }));
              });
            }
            t32.configure = function(e3, t42) {
              g = e3, v = t42;
            }, t32.xhr = function(e3) {
              return "boolean" != typeof (e3 = s({}, e3)).strictSSL && (e3.strictSSL = v), e3.agent || (e3.agent = function(e4, t42) {
                void 0 === t42 && (t42 = {});
                var o3 = (0, i.parse)(e4), r3 = t42.proxyUrl || function(e5) {
                  return "http:" === e5.protocol ? process.env.HTTP_PROXY || process.env.http_proxy || null : "https:" === e5.protocol && (process.env.HTTPS_PROXY || process.env.https_proxy || process.env.HTTP_PROXY || process.env.http_proxy) || null;
                }(o3);
                if (!r3)
                  return null;
                var n3 = (0, i.parse)(r3);
                if (!/^https?:$/.test(n3.protocol))
                  return null;
                var s2 = { host: n3.hostname, port: Number(n3.port), auth: n3.auth, rejectUnauthorized: "boolean" != typeof t42.strictSSL || t42.strictSSL, protocol: n3.protocol };
                return "http:" === o3.protocol ? d(s2) : f3(s2);
              }(e3.url, { proxyUrl: g, strictSSL: v })), "number" != typeof e3.followRedirects && (e3.followRedirects = 5), m(e3).then(function(o3) {
                return new Promise(function(r3, n3) {
                  var s2, a22, u2 = o3.res, c2 = u2, d2 = false, f22 = u2.headers && u2.headers["content-encoding"];
                  if (f22 && (s2 = e3.type, a22 = o3.res.statusCode, !("HEAD" === s2 || a22 >= 100 && a22 < 200 || 204 === a22 || 304 === a22))) {
                    var p2 = { flush: l.constants.Z_SYNC_FLUSH, finishFlush: l.constants.Z_SYNC_FLUSH };
                    if ("gzip" === f22) {
                      var g2 = l.createGunzip(p2);
                      u2.pipe(g2), c2 = g2;
                    } else if ("deflate" === f22) {
                      var v2 = l.createInflate(p2);
                      u2.pipe(v2), c2 = v2;
                    }
                  }
                  var m2 = [];
                  c2.on("data", function(e4) {
                    return m2.push(e4);
                  }), c2.on("end", function() {
                    if (!d2) {
                      if (d2 = true, e3.followRedirects > 0 && (u2.statusCode >= 300 && u2.statusCode <= 303 || 307 === u2.statusCode)) {
                        var o4 = u2.headers.location;
                        if (o4.startsWith("/")) {
                          var s3 = (0, i.parse)(e3.url);
                          o4 = (0, i.format)({ protocol: s3.protocol, hostname: s3.hostname, port: s3.port, pathname: o4 });
                        }
                        if (o4) {
                          var a32 = { type: e3.type, url: o4, user: e3.user, password: e3.password, headers: e3.headers, timeout: e3.timeout, followRedirects: e3.followRedirects - 1, data: e3.data, token: e3.token };
                          return void (0, t32.xhr)(a32).then(r3, n3);
                        }
                      }
                      var c3 = Buffer.concat(m2), l2 = { responseText: c3.toString(), body: c3, status: u2.statusCode, headers: u2.headers || {} };
                      u2.statusCode >= 200 && u2.statusCode < 300 || 1223 === u2.statusCode ? r3(l2) : n3(l2);
                    }
                  }), c2.on("error", function(t42) {
                    var o4;
                    o4 = y.is(t42) ? t42 : { responseText: h("error", "Unable to access {0}. Error: {1}", e3.url, t42.message), body: Buffer.concat(m2), status: 500, headers: {} }, d2 = true, n3(o4);
                  }), e3.token && (e3.token.isCancellationRequested && c2.destroy(new y()), e3.token.onCancellationRequested(function() {
                    c2.destroy(new y());
                  }));
                });
              }, function(t42) {
                var o3;
                return o3 = y.is(t42) ? t42 : { responseText: e3.agent ? h("error.cannot.connect.proxy", "Unable to connect to {0} through a proxy. Error: {1}", e3.url, t42.message) : h("error.cannot.connect", "Unable to connect to {0}. Error: {1}", e3.url, t42.message), body: Buffer.concat([]), status: 404, headers: {} }, Promise.reject(o3);
              });
            }, t32.getErrorStatusDescription = function(e3) {
              if (!(e3 < 400))
                switch (e3) {
                  case 400:
                    return h("status.400", "Bad request. The request cannot be fulfilled due to bad syntax.");
                  case 401:
                    return h("status.401", "Unauthorized. The server is refusing to respond.");
                  case 403:
                    return h("status.403", "Forbidden. The server is refusing to respond.");
                  case 404:
                    return h("status.404", "Not Found. The requested location could not be found.");
                  case 405:
                    return h("status.405", "Method not allowed. A request was made using a request method not supported by that location.");
                  case 406:
                    return h("status.406", "Not Acceptable. The server can only generate a response that is not accepted by the client.");
                  case 407:
                    return h("status.407", "Proxy Authentication Required. The client must first authenticate itself with the proxy.");
                  case 408:
                    return h("status.408", "Request Timeout. The server timed out waiting for the request.");
                  case 409:
                    return h("status.409", "Conflict. The request could not be completed because of a conflict in the request.");
                  case 410:
                    return h("status.410", "Gone. The requested page is no longer available.");
                  case 411:
                    return h("status.411", 'Length Required. The "Content-Length" is not defined.');
                  case 412:
                    return h("status.412", "Precondition Failed. The precondition given in the request evaluated to false by the server.");
                  case 413:
                    return h("status.413", "Request Entity Too Large. The server will not accept the request, because the request entity is too large.");
                  case 414:
                    return h("status.414", "Request-URI Too Long. The server will not accept the request, because the URL is too long.");
                  case 415:
                    return h("status.415", "Unsupported Media Type. The server will not accept the request, because the media type is not supported.");
                  case 500:
                    return h("status.500", "Internal Server Error.");
                  case 501:
                    return h("status.501", "Not Implemented. The server either does not recognize the request method, or it lacks the ability to fulfill the request.");
                  case 503:
                    return h("status.503", "Service Unavailable. The server is currently unavailable (overloaded or down).");
                  default:
                    return h("status.416", "HTTP status code {0}", e3);
                }
            };
            var y = function(e3) {
              function t42() {
                var o3 = e3.call(this, "The user aborted a request") || this;
                return o3.name = "AbortError", Object.setPrototypeOf(o3, t42.prototype), o3;
              }
              return n2(t42, e3), t42.is = function(e4) {
                return e4 instanceof t42;
              }, t42;
            }(Error);
          }, 800: (e2, t32, o2) => {
            "use strict";
            Object.defineProperty(t32, "__esModule", { value: true }), t32.config = t32.loadMessageBundle = t32.localize = t32.format = t32.setPseudo = t32.isPseudo = t32.isDefined = t32.BundleFormat = t32.MessageFormat = void 0;
            var r2, n2, s, a3 = o2(926);
            function u(e3) {
              return void 0 !== e3;
            }
            function i(e3, o3) {
              return t32.isPseudo && (e3 = "\uFF3B" + e3.replace(/[aouei]/g, "$&$&") + "\uFF3D"), 0 === o3.length ? e3 : e3.replace(/\{(\d+)\}/g, function(e4, t42) {
                var r3 = t42[0], n3 = o3[r3], s2 = e4;
                return "string" == typeof n3 ? s2 = n3 : "number" != typeof n3 && "boolean" != typeof n3 && null != n3 || (s2 = String(n3)), s2;
              });
            }
            (s = t32.MessageFormat || (t32.MessageFormat = {})).file = "file", s.bundle = "bundle", s.both = "both", (n2 = t32.BundleFormat || (t32.BundleFormat = {})).standalone = "standalone", n2.languagePack = "languagePack", function(e3) {
              e3.is = function(e4) {
                var t42 = e4;
                return t42 && u(t42.key) && u(t42.comment);
              };
            }(r2 || (r2 = {})), t32.isDefined = u, t32.isPseudo = false, t32.setPseudo = function(e3) {
              t32.isPseudo = e3;
            }, t32.format = i, t32.localize = function(e3, t42) {
              for (var o3 = [], r3 = 2; r3 < arguments.length; r3++)
                o3[r3 - 2] = arguments[r3];
              return i(t42, o3);
            }, t32.loadMessageBundle = function(e3) {
              return (0, a3.default)().loadMessageBundle(e3);
            }, t32.config = function(e3) {
              return (0, a3.default)().config(e3);
            };
          }, 926: (e2, t32) => {
            "use strict";
            var o2;
            function r2() {
              if (void 0 === o2)
                throw new Error("No runtime abstraction layer installed");
              return o2;
            }
            Object.defineProperty(t32, "__esModule", { value: true }), function(e3) {
              e3.install = function(e4) {
                if (void 0 === e4)
                  throw new Error("No runtime abstraction layer provided");
                o2 = e4;
              };
            }(r2 || (r2 = {})), t32.default = r2;
          }, 472: (e2, t32, o2) => {
            "use strict";
            Object.defineProperty(t32, "__esModule", { value: true }), t32.config = t32.loadMessageBundle = t32.BundleFormat = t32.MessageFormat = void 0;
            var r2 = o2(17), n2 = o2(147), s = o2(926), a3 = o2(800), u = o2(800);
            Object.defineProperty(t32, "MessageFormat", { enumerable: true, get: function() {
              return u.MessageFormat;
            } }), Object.defineProperty(t32, "BundleFormat", { enumerable: true, get: function() {
              return u.BundleFormat;
            } });
            var i, c, l = Object.prototype.toString;
            function d(e3) {
              return "[object Number]" === l.call(e3);
            }
            function f3(e3) {
              return "[object String]" === l.call(e3);
            }
            function p(e3) {
              return JSON.parse(n2.readFileSync(e3, "utf8"));
            }
            function h(e3) {
              return function(t42, o3) {
                for (var r3 = [], n3 = 2; n3 < arguments.length; n3++)
                  r3[n3 - 2] = arguments[n3];
                return d(t42) ? t42 >= e3.length ? void console.error("Broken localize call found. Index out of bounds. Stacktrace is\n: ".concat(new Error("").stack)) : (0, a3.format)(e3[t42], r3) : f3(o3) ? (console.warn("Message ".concat(o3, " didn't get externalized correctly.")), (0, a3.format)(o3, r3)) : void console.error("Broken localize call found. Stacktrace is\n: ".concat(new Error("").stack));
              };
            }
            function g(e3, t42) {
              return i[e3] = t42, t42;
            }
            function v(e3) {
              try {
                return function(e4) {
                  var t42 = p(r2.join(e4, "nls.metadata.json")), o3 = /* @__PURE__ */ Object.create(null);
                  for (var n3 in t42) {
                    var s2 = t42[n3];
                    o3[n3] = s2.messages;
                  }
                  return o3;
                }(e3);
              } catch (e4) {
                return void console.log("Generating default bundle from meta data failed.", e4);
              }
            }
            function m(e3, t42) {
              var o3;
              if (true === c.languagePackSupport && void 0 !== c.cacheRoot && void 0 !== c.languagePackId && void 0 !== c.translationsConfigFile && void 0 !== c.translationsConfig)
                try {
                  o3 = function(e4, t52) {
                    var o4, s3, a22, u2 = r2.join(c.cacheRoot, "".concat(e4.id, "-").concat(e4.hash, ".json")), i2 = false, l2 = false;
                    try {
                      return o4 = JSON.parse(n2.readFileSync(u2, { encoding: "utf8", flag: "r" })), s3 = u2, a22 = /* @__PURE__ */ new Date(), n2.utimes(s3, a22, a22, function() {
                      }), o4;
                    } catch (e5) {
                      if ("ENOENT" === e5.code)
                        l2 = true;
                      else {
                        if (!(e5 instanceof SyntaxError))
                          throw e5;
                        console.log("Syntax error parsing message bundle: ".concat(e5.message, ".")), n2.unlink(u2, function(e6) {
                          e6 && console.error("Deleting corrupted bundle ".concat(u2, " failed."));
                        }), i2 = true;
                      }
                    }
                    if (o4 = function(e5, t62) {
                      var o5 = c.translationsConfig[e5.id];
                      if (o5) {
                        var n3 = p(o5).contents, s4 = p(r2.join(t62, "nls.metadata.json")), a32 = /* @__PURE__ */ Object.create(null);
                        for (var u3 in s4) {
                          var i3 = s4[u3], l3 = n3["".concat(e5.outDir, "/").concat(u3)];
                          if (l3) {
                            for (var d2 = [], h2 = 0; h2 < i3.keys.length; h2++) {
                              var g2 = i3.keys[h2], v2 = l3[f3(g2) ? g2 : g2.key];
                              void 0 === v2 && (v2 = i3.messages[h2]), d2.push(v2);
                            }
                            a32[u3] = d2;
                          } else
                            a32[u3] = i3.messages;
                        }
                        return a32;
                      }
                    }(e4, t52), !o4 || i2)
                      return o4;
                    if (l2)
                      try {
                        n2.writeFileSync(u2, JSON.stringify(o4), { encoding: "utf8", flag: "wx" });
                      } catch (e5) {
                        if ("EEXIST" === e5.code)
                          return o4;
                        throw e5;
                      }
                    return o4;
                  }(e3, t42);
                } catch (e4) {
                  console.log("Load or create bundle failed ", e4);
                }
              if (!o3) {
                if (c.languagePackSupport)
                  return v(t42);
                var s2 = function(e4) {
                  for (var t52 = c.language; t52; ) {
                    var o4 = r2.join(e4, "nls.bundle.".concat(t52, ".json"));
                    if (n2.existsSync(o4))
                      return o4;
                    var s3 = t52.lastIndexOf("-");
                    t52 = s3 > 0 ? t52.substring(0, s3) : void 0;
                  }
                  if (void 0 === t52 && (o4 = r2.join(e4, "nls.bundle.json"), n2.existsSync(o4)))
                    return o4;
                }(t42);
                if (s2)
                  try {
                    return p(s2);
                  } catch (e4) {
                    console.log("Loading in the box message bundle failed.", e4);
                  }
                o3 = v(t42);
              }
              return o3;
            }
            function y(e3) {
              if (!e3)
                return a3.localize;
              var t42 = r2.extname(e3);
              if (t42 && (e3 = e3.substr(0, e3.length - t42.length)), c.messageFormat === a3.MessageFormat.both || c.messageFormat === a3.MessageFormat.bundle) {
                var o3 = function(e4) {
                  for (var t52, o4 = r2.dirname(e4); t52 = r2.join(o4, "nls.metadata.header.json"), !n2.existsSync(t52); ) {
                    var s3 = r2.dirname(o4);
                    if (s3 === o4) {
                      t52 = void 0;
                      break;
                    }
                    o4 = s3;
                  }
                  return t52;
                }(e3);
                if (o3) {
                  var s2 = r2.dirname(o3), u2 = i[s2];
                  if (void 0 === u2)
                    try {
                      var l2 = JSON.parse(n2.readFileSync(o3, "utf8"));
                      try {
                        var d2 = m(l2, s2);
                        u2 = g(s2, d2 ? { header: l2, nlsBundle: d2 } : null);
                      } catch (e4) {
                        console.error("Failed to load nls bundle", e4), u2 = g(s2, null);
                      }
                    } catch (e4) {
                      console.error("Failed to read header file", e4), u2 = g(s2, null);
                    }
                  if (u2) {
                    var f22 = e3.substr(s2.length + 1).replace(/\\/g, "/"), v2 = u2.nlsBundle[f22];
                    return void 0 === v2 ? (console.error("Messages for file ".concat(e3, " not found. See console for details.")), function() {
                      return "Messages not found.";
                    }) : h(v2);
                  }
                }
              }
              if (c.messageFormat === a3.MessageFormat.both || c.messageFormat === a3.MessageFormat.file)
                try {
                  var y2 = p(function(e4) {
                    var t52;
                    if (c.cacheLanguageResolution && t52)
                      ;
                    else {
                      if (a3.isPseudo || !c.language)
                        t52 = ".nls.json";
                      else
                        for (var o4 = c.language; o4; ) {
                          var r3 = ".nls." + o4 + ".json";
                          if (n2.existsSync(e4 + r3)) {
                            t52 = r3;
                            break;
                          }
                          var s3 = o4.lastIndexOf("-");
                          s3 > 0 ? o4 = o4.substring(0, s3) : (t52 = ".nls.json", o4 = null);
                        }
                      c.cacheLanguageResolution;
                    }
                    return e4 + t52;
                  }(e3));
                  return Array.isArray(y2) ? h(y2) : (0, a3.isDefined)(y2.messages) && (0, a3.isDefined)(y2.keys) ? h(y2.messages) : (console.error("String bundle '".concat(e3, "' uses an unsupported format.")), function() {
                    return "File bundle has unsupported format. See console for details";
                  });
                } catch (e4) {
                  "ENOENT" !== e4.code && console.error("Failed to load single file bundle", e4);
                }
              return console.error("Failed to load message bundle for file ".concat(e3)), function() {
                return "Failed to load message bundle. See console for details.";
              };
            }
            function b(e3) {
              return e3 && (f3(e3.locale) && (c.locale = e3.locale.toLowerCase(), c.language = c.locale, i = /* @__PURE__ */ Object.create(null)), void 0 !== e3.messageFormat && (c.messageFormat = e3.messageFormat), e3.bundleFormat === a3.BundleFormat.standalone && true === c.languagePackSupport && (c.languagePackSupport = false)), (0, a3.setPseudo)("pseudo" === c.locale), y;
            }
            !function() {
              if (c = { locale: void 0, language: void 0, languagePackSupport: false, cacheLanguageResolution: true, messageFormat: a3.MessageFormat.bundle }, f3(process.env.VSCODE_NLS_CONFIG))
                try {
                  var e3 = JSON.parse(process.env.VSCODE_NLS_CONFIG), t42 = void 0;
                  if (e3.availableLanguages) {
                    var o3 = e3.availableLanguages["*"];
                    f3(o3) && (t42 = o3);
                  }
                  if (f3(e3.locale) && (c.locale = e3.locale.toLowerCase()), void 0 === t42 ? c.language = c.locale : "en" !== t42 && (c.language = t42), /* @__PURE__ */ function(e4) {
                    return true === e4 || false === e4;
                  }(e3._languagePackSupport) && (c.languagePackSupport = e3._languagePackSupport), f3(e3._cacheRoot) && (c.cacheRoot = e3._cacheRoot), f3(e3._languagePackId) && (c.languagePackId = e3._languagePackId), f3(e3._translationsConfigFile)) {
                    c.translationsConfigFile = e3._translationsConfigFile;
                    try {
                      c.translationsConfig = p(c.translationsConfigFile);
                    } catch (t52) {
                      if (e3._corruptedFile) {
                        var s2 = r2.dirname(e3._corruptedFile);
                        n2.exists(s2, function(t62) {
                          t62 && n2.writeFile(e3._corruptedFile, "corrupted", "utf8", function(e4) {
                            console.error(e4);
                          });
                        });
                      }
                    }
                  }
                } catch (e4) {
                }
              (0, a3.setPseudo)("pseudo" === c.locale), i = /* @__PURE__ */ Object.create(null);
            }(), t32.loadMessageBundle = y, t32.config = b, s.default.install(Object.freeze({ loadMessageBundle: y, config: b }));
          }, 374: (e2, t32) => {
            function o2() {
            }
            Object.defineProperty(t32, "__esModule", { value: true }), t32.default = function(e3) {
              return o2;
            };
          }, 491: (e2) => {
            "use strict";
            e2.exports = require("assert");
          }, 361: (e2) => {
            "use strict";
            e2.exports = require("events");
          }, 147: (e2) => {
            "use strict";
            e2.exports = require("fs");
          }, 685: (e2) => {
            "use strict";
            e2.exports = require("http");
          }, 687: (e2) => {
            "use strict";
            e2.exports = require("https");
          }, 808: (e2) => {
            "use strict";
            e2.exports = require("net");
          }, 17: (e2) => {
            "use strict";
            e2.exports = require("path");
          }, 404: (e2) => {
            "use strict";
            e2.exports = require("tls");
          }, 310: (e2) => {
            "use strict";
            e2.exports = require("url");
          }, 796: (e2) => {
            "use strict";
            e2.exports = require("zlib");
          } }, t22 = {}, o = function o2(r2) {
            var n2 = t22[r2];
            if (void 0 !== n2)
              return n2.exports;
            var s = t22[r2] = { exports: {} };
            return e[r2].call(s.exports, s, s.exports, o2), s.exports;
          }(539), r = exports3;
          for (var n in o)
            r[n] = o[n];
          o.__esModule && Object.defineProperty(r, "__esModule", { value: true });
        })();
      }
    });
    var main_exports3 = {};
    __export2(main_exports3, {
      config: () => config,
      t: () => t21
    });
    module2.exports = __toCommonJS2(main_exports3);
    var import_fs = require("fs");
    var import_promises = require("fs/promises");
    var import_request_light = __toESM2(require_main12());
    function readFileFromUri(uri) {
      return __async(this, null, function* () {
        var _a3, _b;
        if (uri.protocol === "file:") {
          return yield (0, import_promises.readFile)(uri, "utf8");
        }
        if (uri.protocol === "http:" || uri.protocol === "https:") {
          try {
            const res = yield (0, import_request_light.xhr)({
              url: uri.toString(),
              followRedirects: 5,
              headers: {
                "Accept-Encoding": "gzip, deflate",
                "Accept": "application/json"
              }
            });
            const decoded = new TextDecoder().decode(res.body);
            return decoded;
          } catch (e) {
            throw new Error((_b = (_a3 = e.responseText) != null ? _a3 : (0, import_request_light.getErrorStatusDescription)(e.status)) != null ? _b : e.toString());
          }
        }
        throw new Error("Unsupported protocol");
      });
    }
    function readFileFromFsPath(fsPath) {
      return (0, import_fs.readFileSync)(fsPath, "utf8");
    }
    var bundle;
    function config(config2) {
      if ("contents" in config2) {
        if (typeof config2.contents === "string") {
          bundle = JSON.parse(config2.contents);
        } else {
          bundle = config2.contents;
        }
        return;
      }
      if ("fsPath" in config2) {
        const fileContent = readFileFromFsPath(config2.fsPath);
        const content = JSON.parse(fileContent);
        bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
        return;
      }
      if (config2.uri) {
        let uri = config2.uri;
        if (typeof config2.uri === "string") {
          uri = new URL(config2.uri);
        }
        return new Promise((resolve, reject) => {
          const p = readFileFromUri(uri).then((uriContent) => {
            try {
              const content = JSON.parse(uriContent);
              bundle = isBuiltinExtension(content) ? content.contents.bundle : content;
            } catch (err) {
              reject(err);
            }
          }).catch((err) => {
            reject(err);
          });
          resolve(p);
        });
      }
    }
    function t21(...args) {
      var _a3;
      const firstArg = args[0];
      let key;
      let message;
      let formatArgs;
      if (typeof firstArg === "string") {
        key = firstArg;
        message = firstArg;
        args.splice(0, 1);
        formatArgs = !args || typeof args[0] !== "object" ? args : args[0];
      } else if (firstArg instanceof Array) {
        const replacements = args.slice(1);
        if (firstArg.length !== replacements.length + 1) {
          throw new Error("expected a string as the first argument to l10n.t");
        }
        let str = firstArg[0];
        for (let i = 1; i < firstArg.length; i++) {
          str += `{${i - 1}}` + firstArg[i];
        }
        return t21(str, ...replacements);
      } else {
        message = firstArg.message;
        key = message;
        if (firstArg.comment && firstArg.comment.length > 0) {
          key += `/${Array.isArray(firstArg.comment) ? firstArg.comment.join("") : firstArg.comment}`;
        }
        formatArgs = (_a3 = firstArg.args) != null ? _a3 : {};
      }
      const messageFromBundle = bundle == null ? void 0 : bundle[key];
      if (!messageFromBundle) {
        return format8(message, formatArgs);
      }
      if (typeof messageFromBundle === "string") {
        return format8(messageFromBundle, formatArgs);
      }
      if (messageFromBundle.comment) {
        return format8(messageFromBundle.message, formatArgs);
      }
      return format8(message, formatArgs);
    }
    var _format2Regexp = /{([^}]+)}/g;
    function format8(template, values2) {
      return template.replace(_format2Regexp, (match, group) => {
        var _a3;
        return (_a3 = values2[group]) != null ? _a3 : match;
      });
    }
    function isBuiltinExtension(json) {
      var _a3;
      return !!(typeof ((_a3 = json == null ? void 0 : json.contents) == null ? void 0 : _a3.bundle) === "object" && typeof (json == null ? void 0 : json.version) === "string");
    }
  }
});

// node_modules/@volar/language-server/lib/types.js
var require_types4 = __commonJS({
  "node_modules/@volar/language-server/lib/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DiagnosticModel = exports2.ServerMode = void 0;
    var ServerMode;
    (function(ServerMode2) {
      ServerMode2[ServerMode2["Semantic"] = 0] = "Semantic";
      ServerMode2[ServerMode2["PartialSemantic"] = 1] = "PartialSemantic";
      ServerMode2[ServerMode2["Syntactic"] = 2] = "Syntactic";
    })(ServerMode || (exports2.ServerMode = ServerMode = {}));
    var DiagnosticModel;
    (function(DiagnosticModel2) {
      DiagnosticModel2[DiagnosticModel2["None"] = 0] = "None";
      DiagnosticModel2[DiagnosticModel2["Push"] = 1] = "Push";
      DiagnosticModel2[DiagnosticModel2["Pull"] = 2] = "Pull";
    })(DiagnosticModel || (exports2.DiagnosticModel = DiagnosticModel = {}));
  }
});

// node_modules/@volar/language-server/lib/common/configurationHost.js
var require_configurationHost = __commonJS({
  "node_modules/@volar/language-server/lib/common/configurationHost.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createConfigurationHost = void 0;
    var vscode = require_main4();
    function createConfigurationHost(params, connection2) {
      const callbacks = /* @__PURE__ */ new Set();
      const cache = /* @__PURE__ */ new Map();
      connection2.onDidChangeConfiguration(() => __async(this, null, function* () {
        cache.clear();
        for (const cb of callbacks) {
          cb();
        }
      }));
      return {
        ready() {
          var _a4, _b;
          if ((_b = (_a4 = params.capabilities.workspace) == null ? void 0 : _a4.didChangeConfiguration) == null ? void 0 : _b.dynamicRegistration) {
            connection2.client.register(vscode.DidChangeConfigurationNotification.type);
          }
        },
        getConfiguration(section, scopeUri) {
          return __async(this, null, function* () {
            var _a4;
            if (!scopeUri && ((_a4 = params.capabilities.workspace) == null ? void 0 : _a4.didChangeConfiguration)) {
              if (!cache.has(section)) {
                cache.set(section, yield getConfigurationWorker(section, scopeUri));
              }
              return cache.get(section);
            }
            return yield getConfigurationWorker(section, scopeUri);
          });
        },
        onDidChangeConfiguration(cb) {
          callbacks.add(cb);
          return {
            dispose() {
              callbacks.delete(cb);
            }
          };
        }
      };
      function getConfigurationWorker(section, scopeUri) {
        return __async(this, null, function* () {
          var _a4;
          return (_a4 = yield connection2.workspace.getConfiguration({ scopeUri, section })) != null ? _a4 : void 0;
        });
      }
    }
    exports2.createConfigurationHost = createConfigurationHost;
  }
});

// node_modules/@volar/language-server/lib/common/utils/uriMap.js
var require_uriMap = __commonJS({
  "node_modules/@volar/language-server/lib/common/utils/uriMap.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createUriMap = exports2._ = void 0;
    var vscode_uri_1 = require_umd();
    exports2._ = require_umd();
    function createUriMap(fileNameToUri, map = /* @__PURE__ */ new Map()) {
      const uriToUri = /* @__PURE__ */ new Map();
      const pathToUri = /* @__PURE__ */ new Map();
      return {
        clear,
        values: values2,
        uriKeys: keys,
        uriDelete,
        uriGet,
        uriHas,
        uriSet,
        pathDelete,
        pathGet,
        pathHas,
        pathSet
      };
      function getUriByUri(uri) {
        if (!uriToUri.has(uri))
          uriToUri.set(uri, normalizeUri(uri).toLowerCase());
        return uriToUri.get(uri);
      }
      function getUriByPath(path) {
        if (!pathToUri.has(path)) {
          pathToUri.set(path, fileNameToUri(path).toLowerCase());
        }
        return pathToUri.get(path);
      }
      function clear() {
        return map.clear();
      }
      function values2() {
        return map.values();
      }
      function keys() {
        return map.keys();
      }
      function uriDelete(_uri) {
        return map.delete(getUriByUri(_uri));
      }
      function uriGet(_uri) {
        return map.get(getUriByUri(_uri));
      }
      function uriHas(_uri) {
        return map.has(getUriByUri(_uri));
      }
      function uriSet(_uri, item) {
        return map.set(getUriByUri(_uri), item);
      }
      function pathDelete(path) {
        return uriDelete(getUriByPath(path));
      }
      function pathGet(path) {
        return uriGet(getUriByPath(path));
      }
      function pathHas(path) {
        return uriGet(getUriByPath(path));
      }
      function pathSet(path, item) {
        return uriSet(getUriByPath(path), item);
      }
    }
    exports2.createUriMap = createUriMap;
    function normalizeUri(uri) {
      try {
        return vscode_uri_1.URI.parse(uri).toString();
      } catch (e) {
        return "";
      }
    }
  }
});

// node_modules/@volar/language-server/lib/common/documents.js
var require_documents2 = __commonJS({
  "node_modules/@volar/language-server/lib/common/documents.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createDocuments = exports2.combineContinuousChangeRanges = void 0;
    var vscode_languageserver_textdocument_1 = require_main6();
    var vscode = require_main4();
    var uriMap_1 = require_uriMap();
    var IncrementalScriptSnapshot = class {
      constructor(uri, languageId, version, text) {
        this.uri = uri;
        this.document = vscode_languageserver_textdocument_1.TextDocument.create(uri, languageId, version, text);
        this.changes = [
          {
            applied: true,
            changeRange: void 0,
            version,
            contentChange: void 0,
            snapshot: void 0
          }
        ];
      }
      get version() {
        return this.changes[this.changes.length - 1].version;
      }
      get languageId() {
        return this.document.languageId;
      }
      update(params) {
        vscode_languageserver_textdocument_1.TextDocument.update(this.document, params.contentChanges, params.textDocument.version);
        this.changes = [
          {
            applied: true,
            changeRange: void 0,
            version: params.textDocument.version,
            contentChange: void 0,
            snapshot: void 0
          }
        ];
      }
      getSnapshot() {
        this.clearUnReferenceVersions();
        const lastChange = this.changes[this.changes.length - 1];
        if (!lastChange.snapshot) {
          this.applyVersionChanges(lastChange.version, false);
          const text = this.document.getText();
          const cache = /* @__PURE__ */ new WeakMap();
          const snapshot = {
            getText: (start, end) => text.substring(start, end),
            getLength: () => text.length,
            getChangeRange: (oldSnapshot) => {
              if (!cache.has(oldSnapshot)) {
                const oldIndex = this.changes.findIndex((change) => {
                  var _a3;
                  return ((_a3 = change.snapshot) == null ? void 0 : _a3.deref()) === oldSnapshot;
                });
                if (oldIndex >= 0) {
                  const start = oldIndex + 1;
                  const end = this.changes.indexOf(lastChange) + 1;
                  const changeRanges = this.changes.slice(start, end).map((change) => change.changeRange);
                  const result = combineContinuousChangeRanges.apply(null, changeRanges);
                  cache.set(oldSnapshot, result);
                } else {
                  cache.set(oldSnapshot, void 0);
                }
              }
              return cache.get(oldSnapshot);
            }
          };
          lastChange.snapshot = new WeakRef(snapshot);
        }
        return lastChange.snapshot.deref();
      }
      getDocument() {
        this.clearUnReferenceVersions();
        const lastChange = this.changes[this.changes.length - 1];
        if (!lastChange.applied) {
          this.applyVersionChanges(lastChange.version, false);
        }
        return this.document;
      }
      clearUnReferenceVersions() {
        var _a3;
        let versionToApply;
        for (let i = 0; i <= this.changes.length - 2; i++) {
          const change = this.changes[i];
          const nextChange = this.changes[i + 1];
          if (!((_a3 = change.snapshot) == null ? void 0 : _a3.deref())) {
            if (change.version !== nextChange.version) {
              versionToApply = change.version;
            }
          } else {
            break;
          }
        }
        if (versionToApply !== void 0) {
          this.applyVersionChanges(versionToApply, true);
        }
      }
      applyVersionChanges(version, removeBeforeVersions) {
        let removeEnd = -1;
        for (let i = 0; i < this.changes.length; i++) {
          const change = this.changes[i];
          if (change.version > version) {
            break;
          }
          if (!change.applied) {
            if (change.contentChange) {
              change.changeRange = {
                span: {
                  start: this.document.offsetAt(change.contentChange.range.start),
                  length: this.document.offsetAt(change.contentChange.range.end) - this.document.offsetAt(change.contentChange.range.start)
                },
                newLength: change.contentChange.text.length
              };
              vscode_languageserver_textdocument_1.TextDocument.update(this.document, [change.contentChange], change.version);
            }
            change.applied = true;
          }
          removeEnd = i + 1;
        }
        if (removeBeforeVersions && removeEnd >= 1) {
          this.changes.splice(0, removeEnd);
        }
      }
    };
    function combineContinuousChangeRanges(...changeRanges) {
      if (changeRanges.length === 1) {
        return changeRanges[0];
      }
      let changeRange = changeRanges[0];
      for (let i = 1; i < changeRanges.length; i++) {
        const nextChangeRange = changeRanges[i];
        changeRange = _combineContinuousChangeRanges(changeRange, nextChangeRange);
      }
      return changeRange;
    }
    exports2.combineContinuousChangeRanges = combineContinuousChangeRanges;
    function _combineContinuousChangeRanges(a3, b) {
      const aStart = a3.span.start;
      const aEnd = a3.span.start + a3.span.length;
      const aDiff = a3.newLength - a3.span.length;
      const changeBegin = aStart + Math.min(a3.span.length, a3.newLength);
      const rollback = (start2) => start2 > changeBegin ? Math.max(aStart, start2 - aDiff) : start2;
      const bStart = rollback(b.span.start);
      const bEnd = rollback(b.span.start + b.span.length);
      const bDiff = b.newLength - b.span.length;
      const start = Math.min(aStart, bStart);
      const end = Math.max(aEnd, bEnd);
      const length = end - start;
      const newLength = aDiff + bDiff + length;
      return { span: { start, length }, newLength };
    }
    function createDocuments(env, connection2) {
      const snapshots = (0, uriMap_1.createUriMap)(env.fileNameToUri);
      const onDidChangeContents = /* @__PURE__ */ new Set();
      const onDidCloses = /* @__PURE__ */ new Set();
      connection2.onDidOpenTextDocument((params) => {
        if (params.textDocument.uri.startsWith("git:/"))
          return;
        snapshots.uriSet(params.textDocument.uri, new IncrementalScriptSnapshot(params.textDocument.uri, params.textDocument.languageId, params.textDocument.version, params.textDocument.text));
        for (const cb of onDidChangeContents) {
          cb({ textDocument: params.textDocument, contentChanges: [{ text: params.textDocument.text }] });
        }
      });
      connection2.onDidChangeTextDocument((params) => {
        if (params.textDocument.uri.startsWith("git:/"))
          return;
        const incrementalSnapshot = snapshots.uriGet(params.textDocument.uri);
        if (incrementalSnapshot) {
          if (params.contentChanges.every(vscode.TextDocumentContentChangeEvent.isIncremental)) {
            for (const contentChange of params.contentChanges) {
              incrementalSnapshot.changes.push({
                applied: false,
                changeRange: void 0,
                contentChange,
                version: params.textDocument.version,
                snapshot: void 0
              });
            }
          } else {
            incrementalSnapshot.update(params);
          }
        }
        for (const cb of onDidChangeContents) {
          cb(params);
        }
      });
      connection2.onDidCloseTextDocument((params) => {
        if (params.textDocument.uri.startsWith("git:/"))
          return;
        snapshots.uriDelete(params.textDocument.uri);
        for (const cb of onDidCloses) {
          cb(params);
        }
      });
      return {
        data: snapshots,
        onDidChangeContent: (cb) => {
          onDidChangeContents.add(cb);
          return {
            dispose() {
              onDidChangeContents.delete(cb);
            }
          };
        },
        onDidClose: (cb) => {
          onDidCloses.add(cb);
          return {
            dispose() {
              onDidCloses.delete(cb);
            }
          };
        }
      };
    }
    exports2.createDocuments = createDocuments;
  }
});

// node_modules/@volar/language-server/lib/common/utils/registerFeatures.js
var require_registerFeatures = __commonJS({
  "node_modules/@volar/language-server/lib/common/utils/registerFeatures.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.setupCapabilities = void 0;
    var types_1 = require_types4();
    var vscode = require_main4();
    function setupCapabilities(server, initOptions, plugins, semanticTokensLegend, services) {
      var _a3, _b, _c;
      const serviceInstances = Object.values(services).map((service) => typeof service === "function" ? service(void 0, void 0) : service).filter((service) => !!service);
      const serverMode = (_a3 = initOptions.serverMode) != null ? _a3 : types_1.ServerMode.Semantic;
      if (serverMode === types_1.ServerMode.Semantic || serverMode === types_1.ServerMode.Syntactic) {
        server.selectionRangeProvider = true;
        server.foldingRangeProvider = true;
        server.linkedEditingRangeProvider = true;
        server.colorProvider = true;
        server.documentSymbolProvider = true;
        server.documentFormattingProvider = true;
        server.documentRangeFormattingProvider = true;
        const characters = [...new Set(serviceInstances.map((service) => {
          var _a4;
          return (_a4 = service.autoFormatTriggerCharacters) != null ? _a4 : [];
        }).flat())];
        if (characters.length) {
          server.documentOnTypeFormattingProvider = {
            firstTriggerCharacter: characters[0],
            moreTriggerCharacter: characters.slice(1)
          };
        }
      }
      if (serverMode === types_1.ServerMode.Semantic || serverMode === types_1.ServerMode.PartialSemantic) {
        server.referencesProvider = true;
        server.implementationProvider = true;
        server.definitionProvider = true;
        server.typeDefinitionProvider = true;
        server.callHierarchyProvider = true;
        server.hoverProvider = true;
        server.renameProvider = {
          prepareProvider: true
        };
        server.signatureHelpProvider = {
          triggerCharacters: [...new Set(serviceInstances.map((service) => {
            var _a4;
            return (_a4 = service.signatureHelpTriggerCharacters) != null ? _a4 : [];
          }).flat())],
          retriggerCharacters: [...new Set(serviceInstances.map((service) => {
            var _a4;
            return (_a4 = service.signatureHelpRetriggerCharacters) != null ? _a4 : [];
          }).flat())]
        };
        server.completionProvider = {
          triggerCharacters: [...new Set(serviceInstances.map((service) => {
            var _a4;
            return (_a4 = service.triggerCharacters) != null ? _a4 : [];
          }).flat())],
          resolveProvider: true
        };
        if (initOptions.ignoreTriggerCharacters) {
          server.completionProvider.triggerCharacters = (_b = server.completionProvider.triggerCharacters) == null ? void 0 : _b.filter((c) => !initOptions.ignoreTriggerCharacters.includes(c));
        }
        server.documentHighlightProvider = true;
        server.documentLinkProvider = {
          resolveProvider: true
        };
        server.codeLensProvider = {
          resolveProvider: true
        };
        server.semanticTokensProvider = {
          range: true,
          full: false,
          legend: semanticTokensLegend
        };
        server.codeActionProvider = {
          codeActionKinds: [
            vscode.CodeActionKind.Empty,
            vscode.CodeActionKind.QuickFix,
            vscode.CodeActionKind.Refactor,
            vscode.CodeActionKind.RefactorExtract,
            vscode.CodeActionKind.RefactorInline,
            vscode.CodeActionKind.RefactorRewrite,
            vscode.CodeActionKind.Source,
            vscode.CodeActionKind.SourceFixAll,
            vscode.CodeActionKind.SourceOrganizeImports
          ],
          resolveProvider: true
        };
        server.inlayHintProvider = {
          resolveProvider: true
        };
        const exts = plugins.map((plugin) => plugin.watchFileExtensions).flat();
        if (exts.length) {
          server.workspace = {
            fileOperations: {
              willRename: {
                filters: [
                  {
                    pattern: {
                      glob: `**/*.{${exts.join(",")}}`
                    }
                  }
                ]
              }
            }
          };
        }
        server.workspaceSymbolProvider = true;
      }
      if (((_c = initOptions.diagnosticModel) != null ? _c : types_1.DiagnosticModel.Push) === types_1.DiagnosticModel.Pull) {
        server.diagnosticProvider = {
          interFileDependencies: true,
          workspaceDiagnostics: false
        };
      }
    }
    exports2.setupCapabilities = setupCapabilities;
  }
});

// node_modules/@volar/language-server/lib/common/utils/serverConfig.js
var require_serverConfig = __commonJS({
  "node_modules/@volar/language-server/lib/common/utils/serverConfig.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.loadConfig = void 0;
    function loadConfig(console2, dir, configFile) {
      let configPath;
      try {
        configPath = require.resolve(configFile != null ? configFile : "./volar.config.js", { paths: [dir] });
      } catch (e) {
      }
      try {
        if (configPath) {
          const config = require(configPath);
          delete require.cache[configPath];
          return config;
        }
      } catch (err) {
        console2.warn(String(err));
      }
    }
    exports2.loadConfig = loadConfig;
  }
});

// node_modules/path-browserify/index.js
var require_path_browserify = __commonJS({
  "node_modules/path-browserify/index.js"(exports2, module2) {
    "use strict";
    function assertPath(path) {
      if (typeof path !== "string") {
        throw new TypeError("Path must be a string. Received " + JSON.stringify(path));
      }
    }
    function normalizeStringPosix(path, allowAboveRoot) {
      var res = "";
      var lastSegmentLength = 0;
      var lastSlash = -1;
      var dots = 0;
      var code;
      for (var i = 0; i <= path.length; ++i) {
        if (i < path.length)
          code = path.charCodeAt(i);
        else if (code === 47)
          break;
        else
          code = 47;
        if (code === 47) {
          if (lastSlash === i - 1 || dots === 1) {
          } else if (lastSlash !== i - 1 && dots === 2) {
            if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
              if (res.length > 2) {
                var lastSlashIndex = res.lastIndexOf("/");
                if (lastSlashIndex !== res.length - 1) {
                  if (lastSlashIndex === -1) {
                    res = "";
                    lastSegmentLength = 0;
                  } else {
                    res = res.slice(0, lastSlashIndex);
                    lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
                  }
                  lastSlash = i;
                  dots = 0;
                  continue;
                }
              } else if (res.length === 2 || res.length === 1) {
                res = "";
                lastSegmentLength = 0;
                lastSlash = i;
                dots = 0;
                continue;
              }
            }
            if (allowAboveRoot) {
              if (res.length > 0)
                res += "/..";
              else
                res = "..";
              lastSegmentLength = 2;
            }
          } else {
            if (res.length > 0)
              res += "/" + path.slice(lastSlash + 1, i);
            else
              res = path.slice(lastSlash + 1, i);
            lastSegmentLength = i - lastSlash - 1;
          }
          lastSlash = i;
          dots = 0;
        } else if (code === 46 && dots !== -1) {
          ++dots;
        } else {
          dots = -1;
        }
      }
      return res;
    }
    function _format(sep, pathObject) {
      var dir = pathObject.dir || pathObject.root;
      var base = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
      if (!dir) {
        return base;
      }
      if (dir === pathObject.root) {
        return dir + base;
      }
      return dir + sep + base;
    }
    var posix = {
      // path.resolve([from ...], to)
      resolve: function resolve() {
        var resolvedPath = "";
        var resolvedAbsolute = false;
        var cwd;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path;
          if (i >= 0)
            path = arguments[i];
          else {
            if (cwd === void 0)
              cwd = process.cwd();
            path = cwd;
          }
          assertPath(path);
          if (path.length === 0) {
            continue;
          }
          resolvedPath = path + "/" + resolvedPath;
          resolvedAbsolute = path.charCodeAt(0) === 47;
        }
        resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
        if (resolvedAbsolute) {
          if (resolvedPath.length > 0)
            return "/" + resolvedPath;
          else
            return "/";
        } else if (resolvedPath.length > 0) {
          return resolvedPath;
        } else {
          return ".";
        }
      },
      normalize: function normalize(path) {
        assertPath(path);
        if (path.length === 0)
          return ".";
        var isAbsolute = path.charCodeAt(0) === 47;
        var trailingSeparator = path.charCodeAt(path.length - 1) === 47;
        path = normalizeStringPosix(path, !isAbsolute);
        if (path.length === 0 && !isAbsolute)
          path = ".";
        if (path.length > 0 && trailingSeparator)
          path += "/";
        if (isAbsolute)
          return "/" + path;
        return path;
      },
      isAbsolute: function isAbsolute(path) {
        assertPath(path);
        return path.length > 0 && path.charCodeAt(0) === 47;
      },
      join: function join() {
        if (arguments.length === 0)
          return ".";
        var joined;
        for (var i = 0; i < arguments.length; ++i) {
          var arg = arguments[i];
          assertPath(arg);
          if (arg.length > 0) {
            if (joined === void 0)
              joined = arg;
            else
              joined += "/" + arg;
          }
        }
        if (joined === void 0)
          return ".";
        return posix.normalize(joined);
      },
      relative: function relative(from, to) {
        assertPath(from);
        assertPath(to);
        if (from === to)
          return "";
        from = posix.resolve(from);
        to = posix.resolve(to);
        if (from === to)
          return "";
        var fromStart = 1;
        for (; fromStart < from.length; ++fromStart) {
          if (from.charCodeAt(fromStart) !== 47)
            break;
        }
        var fromEnd = from.length;
        var fromLen = fromEnd - fromStart;
        var toStart = 1;
        for (; toStart < to.length; ++toStart) {
          if (to.charCodeAt(toStart) !== 47)
            break;
        }
        var toEnd = to.length;
        var toLen = toEnd - toStart;
        var length = fromLen < toLen ? fromLen : toLen;
        var lastCommonSep = -1;
        var i = 0;
        for (; i <= length; ++i) {
          if (i === length) {
            if (toLen > length) {
              if (to.charCodeAt(toStart + i) === 47) {
                return to.slice(toStart + i + 1);
              } else if (i === 0) {
                return to.slice(toStart + i);
              }
            } else if (fromLen > length) {
              if (from.charCodeAt(fromStart + i) === 47) {
                lastCommonSep = i;
              } else if (i === 0) {
                lastCommonSep = 0;
              }
            }
            break;
          }
          var fromCode = from.charCodeAt(fromStart + i);
          var toCode = to.charCodeAt(toStart + i);
          if (fromCode !== toCode)
            break;
          else if (fromCode === 47)
            lastCommonSep = i;
        }
        var out = "";
        for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
          if (i === fromEnd || from.charCodeAt(i) === 47) {
            if (out.length === 0)
              out += "..";
            else
              out += "/..";
          }
        }
        if (out.length > 0)
          return out + to.slice(toStart + lastCommonSep);
        else {
          toStart += lastCommonSep;
          if (to.charCodeAt(toStart) === 47)
            ++toStart;
          return to.slice(toStart);
        }
      },
      _makeLong: function _makeLong(path) {
        return path;
      },
      dirname: function dirname2(path) {
        assertPath(path);
        if (path.length === 0)
          return ".";
        var code = path.charCodeAt(0);
        var hasRoot = code === 47;
        var end = -1;
        var matchedSlash = true;
        for (var i = path.length - 1; i >= 1; --i) {
          code = path.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1)
          return hasRoot ? "/" : ".";
        if (hasRoot && end === 1)
          return "//";
        return path.slice(0, end);
      },
      basename: function basename(path, ext) {
        if (ext !== void 0 && typeof ext !== "string")
          throw new TypeError('"ext" argument must be a string');
        assertPath(path);
        var start = 0;
        var end = -1;
        var matchedSlash = true;
        var i;
        if (ext !== void 0 && ext.length > 0 && ext.length <= path.length) {
          if (ext.length === path.length && ext === path)
            return "";
          var extIdx = ext.length - 1;
          var firstNonSlashEnd = -1;
          for (i = path.length - 1; i >= 0; --i) {
            var code = path.charCodeAt(i);
            if (code === 47) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code === ext.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end)
            end = firstNonSlashEnd;
          else if (end === -1)
            end = path.length;
          return path.slice(start, end);
        } else {
          for (i = path.length - 1; i >= 0; --i) {
            if (path.charCodeAt(i) === 47) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else if (end === -1) {
              matchedSlash = false;
              end = i + 1;
            }
          }
          if (end === -1)
            return "";
          return path.slice(start, end);
        }
      },
      extname: function extname(path) {
        assertPath(path);
        var startDot = -1;
        var startPart = 0;
        var end = -1;
        var matchedSlash = true;
        var preDotState = 0;
        for (var i = path.length - 1; i >= 0; --i) {
          var code = path.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === 46) {
            if (startDot === -1)
              startDot = i;
            else if (preDotState !== 1)
              preDotState = 1;
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path.slice(startDot, end);
      },
      format: function format8(pathObject) {
        if (pathObject === null || typeof pathObject !== "object") {
          throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
        }
        return _format("/", pathObject);
      },
      parse: function parse6(path) {
        assertPath(path);
        var ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path.length === 0)
          return ret;
        var code = path.charCodeAt(0);
        var isAbsolute = code === 47;
        var start;
        if (isAbsolute) {
          ret.root = "/";
          start = 1;
        } else {
          start = 0;
        }
        var startDot = -1;
        var startPart = 0;
        var end = -1;
        var matchedSlash = true;
        var i = path.length - 1;
        var preDotState = 0;
        for (; i >= start; --i) {
          code = path.charCodeAt(i);
          if (code === 47) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === 46) {
            if (startDot === -1)
              startDot = i;
            else if (preDotState !== 1)
              preDotState = 1;
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          if (end !== -1) {
            if (startPart === 0 && isAbsolute)
              ret.base = ret.name = path.slice(1, end);
            else
              ret.base = ret.name = path.slice(startPart, end);
          }
        } else {
          if (startPart === 0 && isAbsolute) {
            ret.name = path.slice(1, startDot);
            ret.base = path.slice(1, end);
          } else {
            ret.name = path.slice(startPart, startDot);
            ret.base = path.slice(startPart, end);
          }
          ret.ext = path.slice(startDot, end);
        }
        if (startPart > 0)
          ret.dir = path.slice(0, startPart - 1);
        else if (isAbsolute)
          ret.dir = "/";
        return ret;
      },
      sep: "/",
      delimiter: ":",
      win32: null,
      posix: null
    };
    posix.posix = posix;
    module2.exports = posix;
  }
});

// node_modules/@volar/language-server/lib/common/utils/isFileInDir.js
var require_isFileInDir = __commonJS({
  "node_modules/@volar/language-server/lib/common/utils/isFileInDir.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.isFileInDir = void 0;
    var path = require_path_browserify();
    function isFileInDir(fileName, dir) {
      const relative = path.relative(dir, fileName);
      return !!relative && !relative.startsWith("..") && !path.isAbsolute(relative);
    }
    exports2.isFileInDir = isFileInDir;
  }
});

// node_modules/@volar/typescript/lib/documentRegistry.js
var require_documentRegistry = __commonJS({
  "node_modules/@volar/typescript/lib/documentRegistry.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getDocumentRegistry = void 0;
    var documentRegistries = [];
    function getDocumentRegistry(ts, useCaseSensitiveFileNames, currentDirectory) {
      var _a3;
      let documentRegistry = (_a3 = documentRegistries.find((item) => item[0] === useCaseSensitiveFileNames && item[1] === currentDirectory)) == null ? void 0 : _a3[2];
      if (!documentRegistry) {
        documentRegistry = ts.createDocumentRegistry(useCaseSensitiveFileNames, currentDirectory);
        documentRegistries.push([useCaseSensitiveFileNames, currentDirectory, documentRegistry]);
      }
      return documentRegistry;
    }
    exports2.getDocumentRegistry = getDocumentRegistry;
  }
});

// node_modules/@volar/typescript/lib/languageService.js
var require_languageService = __commonJS({
  "node_modules/@volar/typescript/lib/languageService.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decorateLanguageService = void 0;
    var language_core_1 = require_language_core();
    function decorateLanguageService(virtualFiles, languageService, isTsPlugin) {
      const _organizeImports = languageService.organizeImports.bind(languageService);
      const _getDefinitionAtPosition = languageService.getDefinitionAtPosition.bind(languageService);
      const _getDefinitionAndBoundSpan = languageService.getDefinitionAndBoundSpan.bind(languageService);
      const _getTypeDefinitionAtPosition = languageService.getTypeDefinitionAtPosition.bind(languageService);
      const _getImplementationAtPosition = languageService.getImplementationAtPosition.bind(languageService);
      const _getFileReferences = languageService.getFileReferences.bind(languageService);
      const _findRenameLocations = languageService.findRenameLocations.bind(languageService);
      const _getReferencesAtPosition = languageService.getReferencesAtPosition.bind(languageService);
      const _findReferences = languageService.findReferences.bind(languageService);
      languageService.organizeImports = organizeImports;
      languageService.getDefinitionAtPosition = getDefinitionAtPosition;
      languageService.getDefinitionAndBoundSpan = getDefinitionAndBoundSpan;
      languageService.getTypeDefinitionAtPosition = getTypeDefinitionAtPosition;
      languageService.getImplementationAtPosition = getImplementationAtPosition;
      languageService.findRenameLocations = findRenameLocations;
      languageService.getReferencesAtPosition = getReferencesAtPosition;
      languageService.getFileReferences = getFileReferences;
      languageService.findReferences = findReferences;
      function organizeImports(args, formatOptions, preferences) {
        var _a3;
        let edits = [];
        const file = (_a3 = virtualFiles.getSource(args.fileName)) == null ? void 0 : _a3.root;
        if (file) {
          (0, language_core_1.forEachEmbeddedFile)(file, (embeddedFile) => {
            if (embeddedFile.kind === language_core_1.FileKind.TypeScriptHostFile && embeddedFile.capabilities.codeAction) {
              edits = edits.concat(_organizeImports(__spreadProps(__spreadValues({}, args), {
                fileName: embeddedFile.fileName
              }), formatOptions, preferences));
            }
          });
        } else {
          return _organizeImports(args, formatOptions, preferences);
        }
        return edits.map(transformFileTextChanges).filter(notEmpty);
      }
      function getReferencesAtPosition(fileName, position) {
        return findLocations(fileName, position, "references");
      }
      function getFileReferences(fileName) {
        return findLocations(fileName, -1, "fileReferences");
      }
      function getDefinitionAtPosition(fileName, position) {
        return findLocations(fileName, position, "definition");
      }
      function getTypeDefinitionAtPosition(fileName, position) {
        return findLocations(fileName, position, "typeDefinition");
      }
      function getImplementationAtPosition(fileName, position) {
        return findLocations(fileName, position, "implementation");
      }
      function findRenameLocations(fileName, position, findInStrings, findInComments, preferences) {
        return findLocations(fileName, position, "rename", findInStrings, findInComments, preferences);
      }
      function findLocations(fileName, position, mode, findInStrings = false, findInComments = false, preferences) {
        const loopChecker = /* @__PURE__ */ new Set();
        let symbols = [];
        withMirrors(fileName, position);
        return symbols.map((s) => transformDocumentSpanLike(s, mode === "definition")).filter(notEmpty);
        function withMirrors(fileName2, position2) {
          if (loopChecker.has(fileName2 + ":" + position2))
            return;
          loopChecker.add(fileName2 + ":" + position2);
          const _symbols = mode === "definition" ? _getDefinitionAtPosition(fileName2, position2) : mode === "typeDefinition" ? _getTypeDefinitionAtPosition(fileName2, position2) : mode === "references" ? _getReferencesAtPosition(fileName2, position2) : mode === "fileReferences" ? _getFileReferences(fileName2) : mode === "implementation" ? _getImplementationAtPosition(fileName2, position2) : mode === "rename" && preferences ? _findRenameLocations(fileName2, position2, findInStrings, findInComments, preferences) : void 0;
          if (!_symbols)
            return;
          symbols = symbols.concat(_symbols);
          for (const ref of _symbols) {
            loopChecker.add(ref.fileName + ":" + ref.textSpan.start);
            const [virtualFile] = getVirtualFile(ref.fileName);
            if (!virtualFile)
              continue;
            const mirrorMap = virtualFiles.getMirrorMap(virtualFile);
            if (!mirrorMap)
              continue;
            for (const [mirrorOffset, data] of mirrorMap.findMirrorOffsets(ref.textSpan.start)) {
              if ((mode === "definition" || mode === "typeDefinition" || mode === "implementation") && !data.definition)
                continue;
              if (mode === "references" && !data.references)
                continue;
              if (mode === "rename" && !data.rename)
                continue;
              if (loopChecker.has(ref.fileName + ":" + mirrorOffset))
                continue;
              withMirrors(ref.fileName, mirrorOffset);
            }
          }
        }
      }
      function getDefinitionAndBoundSpan(fileName, position) {
        const loopChecker = /* @__PURE__ */ new Set();
        let textSpan;
        let symbols = [];
        withMirrors(fileName, position);
        if (!textSpan)
          return;
        return {
          textSpan,
          definitions: symbols == null ? void 0 : symbols.map((s) => transformDocumentSpanLike(s, true)).filter(notEmpty)
        };
        function withMirrors(fileName2, position2) {
          if (loopChecker.has(fileName2 + ":" + position2))
            return;
          loopChecker.add(fileName2 + ":" + position2);
          const _symbols = _getDefinitionAndBoundSpan(fileName2, position2);
          if (!_symbols)
            return;
          if (!textSpan) {
            textSpan = _symbols.textSpan;
          }
          if (!_symbols.definitions)
            return;
          symbols = symbols.concat(_symbols.definitions);
          for (const ref of _symbols.definitions) {
            loopChecker.add(ref.fileName + ":" + ref.textSpan.start);
            const [virtualFile] = getVirtualFile(ref.fileName);
            if (!virtualFile)
              continue;
            const mirrorMap = virtualFiles.getMirrorMap(virtualFile);
            if (!mirrorMap)
              continue;
            for (const [mirrorOffset, data] of mirrorMap.findMirrorOffsets(ref.textSpan.start)) {
              if (!data.definition)
                continue;
              if (loopChecker.has(ref.fileName + ":" + mirrorOffset))
                continue;
              withMirrors(ref.fileName, mirrorOffset);
            }
          }
        }
      }
      function findReferences(fileName, position) {
        const loopChecker = /* @__PURE__ */ new Set();
        let symbols = [];
        withMirrors(fileName, position);
        return symbols.map((s) => transformReferencedSymbol(s)).filter(notEmpty);
        function withMirrors(fileName2, position2) {
          if (loopChecker.has(fileName2 + ":" + position2))
            return;
          loopChecker.add(fileName2 + ":" + position2);
          const _symbols = _findReferences(fileName2, position2);
          if (!_symbols)
            return;
          symbols = symbols.concat(_symbols);
          for (const symbol of _symbols) {
            for (const ref of symbol.references) {
              loopChecker.add(ref.fileName + ":" + ref.textSpan.start);
              const [virtualFile] = getVirtualFile(ref.fileName);
              if (!virtualFile)
                continue;
              const mirrorMap = virtualFiles.getMirrorMap(virtualFile);
              if (!mirrorMap)
                continue;
              for (const [mirrorOffset, data] of mirrorMap.findMirrorOffsets(ref.textSpan.start)) {
                if (!data.references)
                  continue;
                if (loopChecker.has(ref.fileName + ":" + mirrorOffset))
                  continue;
                withMirrors(ref.fileName, mirrorOffset);
              }
            }
          }
        }
      }
      function transformFileTextChanges(changes) {
        const [_, source] = getVirtualFile(changes.fileName);
        if (source) {
          return __spreadProps(__spreadValues({}, changes), {
            fileName: source.fileName,
            textChanges: changes.textChanges.map((c) => {
              const span = transformSpan(changes.fileName, c.span);
              if (span) {
                return __spreadProps(__spreadValues({}, c), {
                  span: span.textSpan
                });
              }
            }).filter(notEmpty)
          });
        } else {
          return changes;
        }
      }
      function transformReferencedSymbol(symbol) {
        const definition = transformDocumentSpanLike(symbol.definition, false);
        const references = symbol.references.map((r) => transformDocumentSpanLike(r, false)).filter(notEmpty);
        if (definition) {
          return {
            definition,
            references
          };
        } else if (references.length) {
          return {
            definition: __spreadProps(__spreadValues({}, symbol.definition), {
              fileName: references[0].fileName,
              textSpan: references[0].textSpan
            }),
            references
          };
        }
      }
      function transformDocumentSpanLike(documentSpan, isDefinition) {
        let textSpan = transformSpan(documentSpan.fileName, documentSpan.textSpan);
        if (isDefinition && !textSpan) {
          const [virtualFile, source] = getVirtualFile(documentSpan.fileName);
          if (virtualFile && source) {
            textSpan = {
              fileName: source.fileName,
              textSpan: { start: 0, length: 0 }
            };
          }
        }
        if (!textSpan)
          return;
        const contextSpan = transformSpan(documentSpan.fileName, documentSpan.contextSpan);
        const originalTextSpan = transformSpan(documentSpan.originalFileName, documentSpan.originalTextSpan);
        const originalContextSpan = transformSpan(documentSpan.originalFileName, documentSpan.originalContextSpan);
        return __spreadProps(__spreadValues({}, documentSpan), {
          fileName: textSpan.fileName,
          textSpan: textSpan.textSpan,
          contextSpan: contextSpan == null ? void 0 : contextSpan.textSpan,
          originalFileName: originalTextSpan == null ? void 0 : originalTextSpan.fileName,
          originalTextSpan: originalTextSpan == null ? void 0 : originalTextSpan.textSpan,
          originalContextSpan: originalContextSpan == null ? void 0 : originalContextSpan.textSpan
        });
      }
      function transformSpan(fileName, textSpan) {
        if (!fileName)
          return;
        if (!textSpan)
          return;
        const [virtualFile, source] = getVirtualFile(fileName);
        if (virtualFile && source) {
          if (isTsPlugin) {
            textSpan = {
              start: textSpan.start - source.snapshot.getLength(),
              length: textSpan.length
            };
          }
          for (const [_, [sourceSnapshot, map]] of virtualFiles.getMaps(virtualFile)) {
            if (source.snapshot !== sourceSnapshot)
              continue;
            const sourceLoc = map.toSourceOffset(textSpan.start);
            if (sourceLoc) {
              return {
                fileName: source.fileName,
                textSpan: {
                  start: sourceLoc[0],
                  length: textSpan.length
                }
              };
            }
          }
        } else {
          return {
            fileName,
            textSpan
          };
        }
      }
      function getVirtualFile(fileName) {
        if (isTsPlugin) {
          let result;
          const source = virtualFiles.getSource(fileName);
          if (source) {
            (0, language_core_1.forEachEmbeddedFile)(source.root, (file) => {
              const ext = file.fileName.replace(fileName, "");
              if (file.kind === language_core_1.FileKind.TypeScriptHostFile && (ext === ".d.ts" || ext.match(/^\.(js|ts)x?$/))) {
                result = file;
              }
            });
          }
          return [result, source];
        } else {
          return virtualFiles.getVirtualFile(fileName);
        }
      }
    }
    exports2.decorateLanguageService = decorateLanguageService;
    function notEmpty(value) {
      return value !== null && value !== void 0;
    }
  }
});

// node_modules/@volar/typescript/lib/typescript/core.js
var require_core = __commonJS({
  "node_modules/@volar/typescript/lib/typescript/core.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.startsWith = exports2.createGetCanonicalFileName = exports2.stringContains = exports2.endsWith = exports2.getStringComparer = exports2.compareStringsCaseSensitive = exports2.equateStringsCaseSensitive = exports2.equateStringsCaseInsensitive = exports2.last = exports2.lastOrUndefined = exports2.sort = exports2.some = exports2.flatMap = exports2.flatten = exports2.map = exports2.indexOfAnyCharCode = exports2.findIndex = exports2.every = void 0;
    var emptyArray = [];
    function every(array, callback) {
      if (array) {
        for (let i = 0; i < array.length; i++) {
          if (!callback(array[i], i)) {
            return false;
          }
        }
      }
      return true;
    }
    exports2.every = every;
    function findIndex(array, predicate, startIndex) {
      if (array === void 0)
        return -1;
      for (let i = startIndex != null ? startIndex : 0; i < array.length; i++) {
        if (predicate(array[i], i)) {
          return i;
        }
      }
      return -1;
    }
    exports2.findIndex = findIndex;
    function contains4(array, value, equalityComparer = equateValues) {
      if (array) {
        for (const v of array) {
          if (equalityComparer(v, value)) {
            return true;
          }
        }
      }
      return false;
    }
    function indexOfAnyCharCode(text, charCodes, start) {
      for (let i = start || 0; i < text.length; i++) {
        if (contains4(charCodes, text.charCodeAt(i))) {
          return i;
        }
      }
      return -1;
    }
    exports2.indexOfAnyCharCode = indexOfAnyCharCode;
    function map(array, f3) {
      let result;
      if (array) {
        result = [];
        for (let i = 0; i < array.length; i++) {
          result.push(f3(array[i], i));
        }
      }
      return result;
    }
    exports2.map = map;
    function flatten(array) {
      const result = [];
      for (const v of array) {
        if (v) {
          if (isArray(v)) {
            addRange(result, v);
          } else {
            result.push(v);
          }
        }
      }
      return result;
    }
    exports2.flatten = flatten;
    function flatMap(array, mapfn) {
      let result;
      if (array) {
        for (let i = 0; i < array.length; i++) {
          const v = mapfn(array[i], i);
          if (v) {
            if (isArray(v)) {
              result = addRange(result, v);
            } else {
              result = append(result, v);
            }
          }
        }
      }
      return result || emptyArray;
    }
    exports2.flatMap = flatMap;
    function some(array, predicate) {
      if (array) {
        if (predicate) {
          for (const v of array) {
            if (predicate(v)) {
              return true;
            }
          }
        } else {
          return array.length > 0;
        }
      }
      return false;
    }
    exports2.some = some;
    function append(to, value) {
      if (value === void 0)
        return to;
      if (to === void 0)
        return [value];
      to.push(value);
      return to;
    }
    function toOffset(array, offset) {
      return offset < 0 ? array.length + offset : offset;
    }
    function addRange(to, from, start, end) {
      if (from === void 0 || from.length === 0)
        return to;
      if (to === void 0)
        return from.slice(start, end);
      start = start === void 0 ? 0 : toOffset(from, start);
      end = end === void 0 ? from.length : toOffset(from, end);
      for (let i = start; i < end && i < from.length; i++) {
        if (from[i] !== void 0) {
          to.push(from[i]);
        }
      }
      return to;
    }
    function sort2(array, comparer) {
      return array.length === 0 ? array : array.slice().sort(comparer);
    }
    exports2.sort = sort2;
    function lastOrUndefined(array) {
      return array === void 0 || array.length === 0 ? void 0 : array[array.length - 1];
    }
    exports2.lastOrUndefined = lastOrUndefined;
    function last(array) {
      return array[array.length - 1];
    }
    exports2.last = last;
    function isArray(value) {
      return Array.isArray ? Array.isArray(value) : value instanceof Array;
    }
    function identity(x) {
      return x;
    }
    function toLowerCase(x) {
      return x.toLowerCase();
    }
    var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
    function toFileNameLowerCase(x) {
      return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
    }
    function equateValues(a3, b) {
      return a3 === b;
    }
    function equateStringsCaseInsensitive(a3, b) {
      return a3 === b || a3 !== void 0 && b !== void 0 && a3.toUpperCase() === b.toUpperCase();
    }
    exports2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
    function equateStringsCaseSensitive(a3, b) {
      return equateValues(a3, b);
    }
    exports2.equateStringsCaseSensitive = equateStringsCaseSensitive;
    function compareComparableValues(a3, b) {
      return a3 === b ? 0 : a3 === void 0 ? -1 : b === void 0 ? 1 : a3 < b ? -1 : 1;
    }
    function compareStringsCaseInsensitive(a3, b) {
      if (a3 === b)
        return 0;
      if (a3 === void 0)
        return -1;
      if (b === void 0)
        return 1;
      a3 = a3.toUpperCase();
      b = b.toUpperCase();
      return a3 < b ? -1 : a3 > b ? 1 : 0;
    }
    function compareStringsCaseSensitive(a3, b) {
      return compareComparableValues(a3, b);
    }
    exports2.compareStringsCaseSensitive = compareStringsCaseSensitive;
    function getStringComparer(ignoreCase) {
      return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
    }
    exports2.getStringComparer = getStringComparer;
    function endsWith4(str, suffix) {
      const expectedPos = str.length - suffix.length;
      return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
    }
    exports2.endsWith = endsWith4;
    function stringContains(str, substring) {
      return str.indexOf(substring) !== -1;
    }
    exports2.stringContains = stringContains;
    function createGetCanonicalFileName(useCaseSensitiveFileNames) {
      return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
    }
    exports2.createGetCanonicalFileName = createGetCanonicalFileName;
    function startsWith4(str, prefix) {
      return str.lastIndexOf(prefix, 0) === 0;
    }
    exports2.startsWith = startsWith4;
  }
});

// node_modules/@volar/typescript/lib/typescript/path.js
var require_path = __commonJS({
  "node_modules/@volar/typescript/lib/typescript/path.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.containsPath = exports2.removeTrailingDirectorySeparator = exports2.normalizePath = exports2.getNormalizedPathComponents = exports2.combinePaths = exports2.getDirectoryPath = exports2.fileExtensionIsOneOf = exports2.hasExtension = exports2.isRootedDiskPath = exports2.directorySeparator = void 0;
    var core_1 = require_core();
    exports2.directorySeparator = "/";
    var altDirectorySeparator = "\\";
    var urlSchemeSeparator = "://";
    var backslashRegExp = /\\/g;
    function isAnyDirectorySeparator(charCode) {
      return charCode === 47 || charCode === 92;
    }
    function isRootedDiskPath(path) {
      return getEncodedRootLength(path) > 0;
    }
    exports2.isRootedDiskPath = isRootedDiskPath;
    function hasExtension(fileName) {
      return (0, core_1.stringContains)(getBaseFileName(fileName), ".");
    }
    exports2.hasExtension = hasExtension;
    function fileExtensionIs(path, extension) {
      return path.length > extension.length && (0, core_1.endsWith)(path, extension);
    }
    function fileExtensionIsOneOf(path, extensions) {
      for (const extension of extensions) {
        if (fileExtensionIs(path, extension)) {
          return true;
        }
      }
      return false;
    }
    exports2.fileExtensionIsOneOf = fileExtensionIsOneOf;
    function hasTrailingDirectorySeparator(path) {
      return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
    }
    function isVolumeCharacter(charCode) {
      return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
    }
    function getFileUrlVolumeSeparatorEnd(url, start) {
      const ch0 = url.charCodeAt(start);
      if (ch0 === 58)
        return start + 1;
      if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
        const ch2 = url.charCodeAt(start + 2);
        if (ch2 === 97 || ch2 === 65)
          return start + 3;
      }
      return -1;
    }
    function getEncodedRootLength(path) {
      if (!path)
        return 0;
      const ch0 = path.charCodeAt(0);
      if (ch0 === 47 || ch0 === 92) {
        if (path.charCodeAt(1) !== ch0)
          return 1;
        const p1 = path.indexOf(ch0 === 47 ? exports2.directorySeparator : altDirectorySeparator, 2);
        if (p1 < 0)
          return path.length;
        return p1 + 1;
      }
      if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58) {
        const ch2 = path.charCodeAt(2);
        if (ch2 === 47 || ch2 === 92)
          return 3;
        if (path.length === 2)
          return 2;
      }
      const schemeEnd = path.indexOf(urlSchemeSeparator);
      if (schemeEnd !== -1) {
        const authorityStart = schemeEnd + urlSchemeSeparator.length;
        const authorityEnd = path.indexOf(exports2.directorySeparator, authorityStart);
        if (authorityEnd !== -1) {
          const scheme = path.slice(0, schemeEnd);
          const authority = path.slice(authorityStart, authorityEnd);
          if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
            const volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
            if (volumeSeparatorEnd !== -1) {
              if (path.charCodeAt(volumeSeparatorEnd) === 47) {
                return ~(volumeSeparatorEnd + 1);
              }
              if (volumeSeparatorEnd === path.length) {
                return ~volumeSeparatorEnd;
              }
            }
          }
          return ~(authorityEnd + 1);
        }
        return ~path.length;
      }
      return 0;
    }
    function getRootLength(path) {
      const rootLength = getEncodedRootLength(path);
      return rootLength < 0 ? ~rootLength : rootLength;
    }
    function getDirectoryPath(path) {
      path = normalizeSlashes(path);
      const rootLength = getRootLength(path);
      if (rootLength === path.length)
        return path;
      path = removeTrailingDirectorySeparator(path);
      return path.slice(0, Math.max(rootLength, path.lastIndexOf(exports2.directorySeparator)));
    }
    exports2.getDirectoryPath = getDirectoryPath;
    function getBaseFileName(path, extensions, ignoreCase) {
      path = normalizeSlashes(path);
      const rootLength = getRootLength(path);
      if (rootLength === path.length)
        return "";
      path = removeTrailingDirectorySeparator(path);
      const name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(exports2.directorySeparator) + 1));
      const extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
      return extension ? name.slice(0, name.length - extension.length) : name;
    }
    function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
      if (!(0, core_1.startsWith)(extension, "."))
        extension = "." + extension;
      if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46) {
        const pathExtension = path.slice(path.length - extension.length);
        if (stringEqualityComparer(pathExtension, extension)) {
          return pathExtension;
        }
      }
    }
    function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
      if (typeof extensions === "string") {
        return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
      }
      for (const extension of extensions) {
        const result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
        if (result)
          return result;
      }
      return "";
    }
    function getAnyExtensionFromPath(path, extensions, ignoreCase) {
      if (extensions) {
        return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? core_1.equateStringsCaseInsensitive : core_1.equateStringsCaseSensitive);
      }
      const baseFileName = getBaseFileName(path);
      const extensionIndex = baseFileName.lastIndexOf(".");
      if (extensionIndex >= 0) {
        return baseFileName.substring(extensionIndex);
      }
      return "";
    }
    function pathComponents(path, rootLength) {
      const root = path.substring(0, rootLength);
      const rest = path.substring(rootLength).split(exports2.directorySeparator);
      if (rest.length && !(0, core_1.lastOrUndefined)(rest))
        rest.pop();
      return [root, ...rest];
    }
    function getPathComponents(path, currentDirectory = "") {
      path = combinePaths(currentDirectory, path);
      return pathComponents(path, getRootLength(path));
    }
    function getPathFromPathComponents(pathComponents2) {
      if (pathComponents2.length === 0)
        return "";
      const root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
      return root + pathComponents2.slice(1).join(exports2.directorySeparator);
    }
    function normalizeSlashes(path) {
      return path.indexOf("\\") !== -1 ? path.replace(backslashRegExp, exports2.directorySeparator) : path;
    }
    function reducePathComponents(components) {
      if (!(0, core_1.some)(components))
        return [];
      const reduced = [components[0]];
      for (let i = 1; i < components.length; i++) {
        const component = components[i];
        if (!component)
          continue;
        if (component === ".")
          continue;
        if (component === "..") {
          if (reduced.length > 1) {
            if (reduced[reduced.length - 1] !== "..") {
              reduced.pop();
              continue;
            }
          } else if (reduced[0])
            continue;
        }
        reduced.push(component);
      }
      return reduced;
    }
    function combinePaths(path, ...paths) {
      if (path)
        path = normalizeSlashes(path);
      for (let relativePath of paths) {
        if (!relativePath)
          continue;
        relativePath = normalizeSlashes(relativePath);
        if (!path || getRootLength(relativePath) !== 0) {
          path = relativePath;
        } else {
          path = ensureTrailingDirectorySeparator(path) + relativePath;
        }
      }
      return path;
    }
    exports2.combinePaths = combinePaths;
    function getNormalizedPathComponents(path, currentDirectory) {
      return reducePathComponents(getPathComponents(path, currentDirectory));
    }
    exports2.getNormalizedPathComponents = getNormalizedPathComponents;
    function normalizePath(path) {
      path = normalizeSlashes(path);
      if (!relativePathSegmentRegExp.test(path)) {
        return path;
      }
      const simplified = path.replace(/\/\.\//g, "/").replace(/^\.\//, "");
      if (simplified !== path) {
        path = simplified;
        if (!relativePathSegmentRegExp.test(path)) {
          return path;
        }
      }
      const normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
      return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
    }
    exports2.normalizePath = normalizePath;
    function removeTrailingDirectorySeparator(path) {
      if (hasTrailingDirectorySeparator(path)) {
        return path.substr(0, path.length - 1);
      }
      return path;
    }
    exports2.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
    function ensureTrailingDirectorySeparator(path) {
      if (!hasTrailingDirectorySeparator(path)) {
        return path + exports2.directorySeparator;
      }
      return path;
    }
    var relativePathSegmentRegExp = /(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;
    function containsPath(parent, child, currentDirectory, ignoreCase) {
      if (typeof currentDirectory === "string") {
        parent = combinePaths(currentDirectory, parent);
        child = combinePaths(currentDirectory, child);
      } else if (typeof currentDirectory === "boolean") {
        ignoreCase = currentDirectory;
      }
      if (parent === void 0 || child === void 0)
        return false;
      if (parent === child)
        return true;
      const parentComponents = reducePathComponents(getPathComponents(parent));
      const childComponents = reducePathComponents(getPathComponents(child));
      if (childComponents.length < parentComponents.length) {
        return false;
      }
      const componentEqualityComparer = ignoreCase ? core_1.equateStringsCaseInsensitive : core_1.equateStringsCaseSensitive;
      for (let i = 0; i < parentComponents.length; i++) {
        const equalityComparer = i === 0 ? core_1.equateStringsCaseInsensitive : componentEqualityComparer;
        if (!equalityComparer(parentComponents[i], childComponents[i])) {
          return false;
        }
      }
      return true;
    }
    exports2.containsPath = containsPath;
  }
});

// node_modules/@volar/typescript/lib/typescript/utilities.js
var require_utilities = __commonJS({
  "node_modules/@volar/typescript/lib/typescript/utilities.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.matchFiles = void 0;
    var core_1 = require_core();
    var path_1 = require_path();
    var reservedCharacterPattern = /[^\w\s\/]/g;
    var wildcardCharCodes = [
      42,
      63
      /* CharacterCodes.question */
    ];
    var commonPackageFolders = ["node_modules", "bower_components", "jspm_packages"];
    var implicitExcludePathRegexPattern = `(?!(${commonPackageFolders.join("|")})(/|$))`;
    var filesMatcher = {
      /**
       * Matches any single directory segment unless it is the last segment and a .min.js file
       * Breakdown:
       *  [^./]                   # matches everything up to the first . character (excluding directory separators)
       *  (\\.(?!min\\.js$))?     # matches . characters but not if they are part of the .min.js file extension
       */
      singleAsteriskRegexFragment: "([^./]|(\\.(?!min\\.js$))?)*",
      /**
       * Regex for the ** wildcard. Matches any number of subdirectories. When used for including
       * files or directories, does not match subdirectories that start with a . character
       */
      doubleAsteriskRegexFragment: `(/${implicitExcludePathRegexPattern}[^/.][^/]*)*?`,
      replaceWildcardCharacter: (match) => replaceWildcardCharacter(match, filesMatcher.singleAsteriskRegexFragment)
    };
    var directoriesMatcher = {
      singleAsteriskRegexFragment: "[^/]*",
      /**
       * Regex for the ** wildcard. Matches any number of subdirectories. When used for including
       * files or directories, does not match subdirectories that start with a . character
       */
      doubleAsteriskRegexFragment: `(/${implicitExcludePathRegexPattern}[^/.][^/]*)*?`,
      replaceWildcardCharacter: (match) => replaceWildcardCharacter(match, directoriesMatcher.singleAsteriskRegexFragment)
    };
    var excludeMatcher = {
      singleAsteriskRegexFragment: "[^/]*",
      doubleAsteriskRegexFragment: "(/.+?)?",
      replaceWildcardCharacter: (match) => replaceWildcardCharacter(match, excludeMatcher.singleAsteriskRegexFragment)
    };
    var wildcardMatchers = {
      files: filesMatcher,
      directories: directoriesMatcher,
      exclude: excludeMatcher
    };
    function getRegularExpressionForWildcard(specs, basePath, usage) {
      const patterns = getRegularExpressionsForWildcards(specs, basePath, usage);
      if (!patterns || !patterns.length) {
        return void 0;
      }
      const pattern = patterns.map((pattern2) => `(${pattern2})`).join("|");
      const terminator = usage === "exclude" ? "($|/)" : "$";
      return `^(${pattern})${terminator}`;
    }
    function getRegularExpressionsForWildcards(specs, basePath, usage) {
      if (specs === void 0 || specs.length === 0) {
        return void 0;
      }
      return (0, core_1.flatMap)(specs, (spec) => spec && getSubPatternFromSpec(spec, basePath, usage, wildcardMatchers[usage]));
    }
    function isImplicitGlob(lastPathComponent) {
      return !/[.*?]/.test(lastPathComponent);
    }
    function getSubPatternFromSpec(spec, basePath, usage, { singleAsteriskRegexFragment, doubleAsteriskRegexFragment, replaceWildcardCharacter: replaceWildcardCharacter2 }) {
      let subpattern = "";
      let hasWrittenComponent = false;
      const components = (0, path_1.getNormalizedPathComponents)(spec, basePath);
      const lastComponent = (0, core_1.last)(components);
      if (usage !== "exclude" && lastComponent === "**") {
        return void 0;
      }
      components[0] = (0, path_1.removeTrailingDirectorySeparator)(components[0]);
      if (isImplicitGlob(lastComponent)) {
        components.push("**", "*");
      }
      let optionalCount = 0;
      for (let component of components) {
        if (component === "**") {
          subpattern += doubleAsteriskRegexFragment;
        } else {
          if (usage === "directories") {
            subpattern += "(";
            optionalCount++;
          }
          if (hasWrittenComponent) {
            subpattern += path_1.directorySeparator;
          }
          if (usage !== "exclude") {
            let componentPattern = "";
            if (component.charCodeAt(0) === 42) {
              componentPattern += "([^./]" + singleAsteriskRegexFragment + ")?";
              component = component.substr(1);
            } else if (component.charCodeAt(0) === 63) {
              componentPattern += "[^./]";
              component = component.substr(1);
            }
            componentPattern += component.replace(reservedCharacterPattern, replaceWildcardCharacter2);
            if (componentPattern !== component) {
              subpattern += implicitExcludePathRegexPattern;
            }
            subpattern += componentPattern;
          } else {
            subpattern += component.replace(reservedCharacterPattern, replaceWildcardCharacter2);
          }
        }
        hasWrittenComponent = true;
      }
      while (optionalCount > 0) {
        subpattern += ")?";
        optionalCount--;
      }
      return subpattern;
    }
    function replaceWildcardCharacter(match, singleAsteriskRegexFragment) {
      return match === "*" ? singleAsteriskRegexFragment : match === "?" ? "[^/]" : "\\" + match;
    }
    function getFileMatcherPatterns(path, excludes, includes2, useCaseSensitiveFileNames, currentDirectory) {
      path = (0, path_1.normalizePath)(path);
      currentDirectory = (0, path_1.normalizePath)(currentDirectory);
      const absolutePath = (0, path_1.combinePaths)(currentDirectory, path);
      return {
        includeFilePatterns: (0, core_1.map)(getRegularExpressionsForWildcards(includes2, absolutePath, "files"), (pattern) => `^${pattern}$`),
        includeFilePattern: getRegularExpressionForWildcard(includes2, absolutePath, "files"),
        includeDirectoryPattern: getRegularExpressionForWildcard(includes2, absolutePath, "directories"),
        excludePattern: getRegularExpressionForWildcard(excludes, absolutePath, "exclude"),
        basePaths: getBasePaths(path, includes2, useCaseSensitiveFileNames)
      };
    }
    function getRegexFromPattern(pattern, useCaseSensitiveFileNames) {
      return new RegExp(pattern, useCaseSensitiveFileNames ? "" : "i");
    }
    function matchFiles(path, extensions, excludes, includes2, useCaseSensitiveFileNames, currentDirectory, depth, getFileSystemEntries, realpath) {
      path = (0, path_1.normalizePath)(path);
      currentDirectory = (0, path_1.normalizePath)(currentDirectory);
      const patterns = getFileMatcherPatterns(path, excludes, includes2, useCaseSensitiveFileNames, currentDirectory);
      const includeFileRegexes = patterns.includeFilePatterns && patterns.includeFilePatterns.map((pattern) => getRegexFromPattern(pattern, useCaseSensitiveFileNames));
      const includeDirectoryRegex = patterns.includeDirectoryPattern && getRegexFromPattern(patterns.includeDirectoryPattern, useCaseSensitiveFileNames);
      const excludeRegex = patterns.excludePattern && getRegexFromPattern(patterns.excludePattern, useCaseSensitiveFileNames);
      const results = includeFileRegexes ? includeFileRegexes.map(() => []) : [[]];
      const visited = /* @__PURE__ */ new Map();
      const toCanonical = (0, core_1.createGetCanonicalFileName)(useCaseSensitiveFileNames);
      for (const basePath of patterns.basePaths) {
        visitDirectory(basePath, (0, path_1.combinePaths)(currentDirectory, basePath), depth);
      }
      return (0, core_1.flatten)(results);
      function visitDirectory(path2, absolutePath, depth2) {
        const canonicalPath = toCanonical(realpath(absolutePath));
        if (visited.has(canonicalPath))
          return;
        visited.set(canonicalPath, true);
        const { files, directories } = getFileSystemEntries(path2);
        for (const current of (0, core_1.sort)(files, core_1.compareStringsCaseSensitive)) {
          const name = (0, path_1.combinePaths)(path2, current);
          const absoluteName = (0, path_1.combinePaths)(absolutePath, current);
          if (extensions && !(0, path_1.fileExtensionIsOneOf)(name, extensions))
            continue;
          if (excludeRegex && excludeRegex.test(absoluteName))
            continue;
          if (!includeFileRegexes) {
            results[0].push(name);
          } else {
            const includeIndex = (0, core_1.findIndex)(includeFileRegexes, (re) => re.test(absoluteName));
            if (includeIndex !== -1) {
              results[includeIndex].push(name);
            }
          }
        }
        if (depth2 !== void 0) {
          depth2--;
          if (depth2 === 0) {
            return;
          }
        }
        for (const current of (0, core_1.sort)(directories, core_1.compareStringsCaseSensitive)) {
          const name = (0, path_1.combinePaths)(path2, current);
          const absoluteName = (0, path_1.combinePaths)(absolutePath, current);
          if ((!includeDirectoryRegex || includeDirectoryRegex.test(absoluteName)) && (!excludeRegex || !excludeRegex.test(absoluteName))) {
            visitDirectory(name, absoluteName, depth2);
          }
        }
      }
    }
    exports2.matchFiles = matchFiles;
    function getBasePaths(path, includes2, useCaseSensitiveFileNames) {
      const basePaths = [path];
      if (includes2) {
        const includeBasePaths = [];
        for (const include of includes2) {
          const absolute = (0, path_1.isRootedDiskPath)(include) ? include : (0, path_1.normalizePath)((0, path_1.combinePaths)(path, include));
          includeBasePaths.push(getIncludeBasePath(absolute));
        }
        includeBasePaths.sort((0, core_1.getStringComparer)(!useCaseSensitiveFileNames));
        for (const includeBasePath of includeBasePaths) {
          if ((0, core_1.every)(basePaths, (basePath) => !(0, path_1.containsPath)(basePath, includeBasePath, path, !useCaseSensitiveFileNames))) {
            basePaths.push(includeBasePath);
          }
        }
      }
      return basePaths;
    }
    function getIncludeBasePath(absolute) {
      const wildcardOffset = (0, core_1.indexOfAnyCharCode)(absolute, wildcardCharCodes);
      if (wildcardOffset < 0) {
        return !(0, path_1.hasExtension)(absolute) ? absolute : (0, path_1.removeTrailingDirectorySeparator)((0, path_1.getDirectoryPath)(absolute));
      }
      return absolute.substring(0, absolute.lastIndexOf(path_1.directorySeparator, wildcardOffset));
    }
  }
});

// node_modules/@volar/typescript/lib/languageServiceHost.js
var require_languageServiceHost = __commonJS({
  "node_modules/@volar/typescript/lib/languageServiceHost.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createLanguageServiceHost = void 0;
    var path = require_path_browserify();
    var utilities_1 = require_utilities();
    var fileVersions = /* @__PURE__ */ new Map();
    function createLanguageServiceHost(ctx, ts, sys) {
      let lastProjectVersion;
      let tsProjectVersion = 0;
      let tsFileNames = [];
      let tsDirectories = /* @__PURE__ */ new Set();
      const _tsHost = __spreadProps(__spreadValues({}, sys), {
        getCurrentDirectory: () => ctx.host.workspacePath,
        getCompilationSettings: () => ctx.host.getCompilationSettings(),
        getCancellationToken: ctx.host.getCancellationToken ? () => ctx.host.getCancellationToken() : void 0,
        getLocalizedDiagnosticMessages: ctx.host.getLocalizedDiagnosticMessages ? () => ctx.host.getLocalizedDiagnosticMessages() : void 0,
        getProjectReferences: ctx.host.getProjectReferences ? () => ctx.host.getProjectReferences() : void 0,
        getDefaultLibFileName: (options) => {
          try {
            return ts.getDefaultLibFilePath(options);
          } catch (e) {
            return `/node_modules/typescript/lib/${ts.getDefaultLibFileName(options)}`;
          }
        },
        useCaseSensitiveFileNames: () => sys.useCaseSensitiveFileNames,
        getNewLine: () => sys.newLine,
        readFile: (fileName) => {
          const snapshot = getScriptSnapshot(fileName);
          if (snapshot) {
            return snapshot.getText(0, snapshot.getLength());
          }
        },
        readDirectory,
        getDirectories,
        directoryExists,
        fileExists,
        getProjectVersion: () => {
          return tsProjectVersion + ":" + sys.version;
        },
        getTypeRootsVersion: () => {
          var _a3;
          return (_a3 = sys.version) != null ? _a3 : -1;
        },
        getScriptFileNames: () => tsFileNames,
        getScriptVersion,
        getScriptSnapshot,
        getScriptKind(fileName) {
          if (ts) {
            if (ctx.virtualFiles.hasSource(fileName))
              return ts.ScriptKind.Deferred;
            switch (path.extname(fileName)) {
              case ".js":
                return ts.ScriptKind.JS;
              case ".cjs":
                return ts.ScriptKind.JS;
              case ".mjs":
                return ts.ScriptKind.JS;
              case ".jsx":
                return ts.ScriptKind.JSX;
              case ".ts":
                return ts.ScriptKind.TS;
              case ".cts":
                return ts.ScriptKind.TS;
              case ".mts":
                return ts.ScriptKind.TS;
              case ".tsx":
                return ts.ScriptKind.TSX;
              case ".json":
                return ts.ScriptKind.JSON;
              default:
                return ts.ScriptKind.Unknown;
            }
          }
          return 0;
        }
      });
      const fsFileSnapshots = /* @__PURE__ */ new Map();
      if (ctx.host.resolveModuleName) {
        const moduleCache = ts.createModuleResolutionCache(_tsHost.getCurrentDirectory(), _tsHost.useCaseSensitiveFileNames ? (s) => s : (s) => s.toLowerCase(), _tsHost.getCompilationSettings());
        let lastSysVersion = sys.version;
        _tsHost.resolveModuleNameLiterals = (moduleLiterals, containingFile, redirectedReference, options, sourceFile) => {
          if (lastSysVersion !== sys.version) {
            lastSysVersion = sys.version;
            moduleCache.clear();
          }
          return moduleLiterals.map((moduleLiteral) => {
            let moduleName = moduleLiteral.text;
            moduleName = ctx.host.resolveModuleName(moduleName, sourceFile.impliedNodeFormat);
            return ts.resolveModuleName(moduleName, containingFile, options, _tsHost, moduleCache, redirectedReference, sourceFile.impliedNodeFormat);
          });
        };
        _tsHost.resolveModuleNames = (moduleNames, containingFile, _reusedNames, redirectedReference, options, sourceFile) => {
          if (lastSysVersion !== sys.version) {
            lastSysVersion = sys.version;
            moduleCache.clear();
          }
          return moduleNames.map((moduleName) => {
            moduleName = ctx.host.resolveModuleName(moduleName, sourceFile == null ? void 0 : sourceFile.impliedNodeFormat);
            return ts.resolveModuleName(moduleName, containingFile, options, _tsHost, moduleCache, redirectedReference, sourceFile == null ? void 0 : sourceFile.impliedNodeFormat).resolvedModule;
          });
        };
      }
      let oldTsVirtualFileSnapshots = /* @__PURE__ */ new Set();
      let oldOtherVirtualFileSnapshots = /* @__PURE__ */ new Set();
      return new Proxy(_tsHost, {
        get: (target, property) => {
          sync();
          return target[property];
        }
      });
      function sync() {
        const newProjectVersion = ctx.host.getProjectVersion();
        const shouldUpdate = newProjectVersion !== lastProjectVersion;
        if (!shouldUpdate)
          return;
        lastProjectVersion = newProjectVersion;
        const newTsVirtualFileSnapshots = /* @__PURE__ */ new Set();
        const newOtherVirtualFileSnapshots = /* @__PURE__ */ new Set();
        for (const { root } of ctx.virtualFiles.allSources()) {
          forEachEmbeddedFile(root, (embedded) => {
            if (embedded.kind === 1) {
              newTsVirtualFileSnapshots.add(embedded.snapshot);
            } else {
              newOtherVirtualFileSnapshots.add(embedded.snapshot);
            }
          });
        }
        if (!setEquals(oldTsVirtualFileSnapshots, newTsVirtualFileSnapshots)) {
          tsProjectVersion++;
        } else if (setEquals(oldOtherVirtualFileSnapshots, newOtherVirtualFileSnapshots)) {
          tsProjectVersion++;
        }
        oldTsVirtualFileSnapshots = newTsVirtualFileSnapshots;
        oldOtherVirtualFileSnapshots = newOtherVirtualFileSnapshots;
        const tsFileNamesSet = /* @__PURE__ */ new Set();
        for (const { root } of ctx.virtualFiles.allSources()) {
          forEachEmbeddedFile(root, (embedded) => {
            if (embedded.kind === 1) {
              tsFileNamesSet.add(embedded.fileName);
            }
          });
        }
        for (const fileName of ctx.host.getScriptFileNames()) {
          if (!ctx.virtualFiles.hasSource(fileName)) {
            tsFileNamesSet.add(fileName);
          }
        }
        tsFileNames = [...tsFileNamesSet];
        tsDirectories.clear();
        for (const fileName of tsFileNames) {
          tsDirectories.add(path.dirname(normalizePath(fileName)));
        }
      }
      function readDirectory(dirName, extensions, excludes, includes2, depth) {
        var _a3;
        let matches2 = (0, utilities_1.matchFiles)(dirName, extensions, excludes, includes2, (_a3 = sys == null ? void 0 : sys.useCaseSensitiveFileNames) != null ? _a3 : false, ctx.host.workspacePath, depth, (dirPath) => {
          const files = [];
          for (const fileName of tsFileNames) {
            if (fileName.toLowerCase().startsWith(dirPath.toLowerCase())) {
              const baseName = fileName.substring(dirPath.length);
              if (baseName.indexOf("/") === -1) {
                files.push(baseName);
              }
            }
          }
          return {
            files,
            directories: getVirtualFileDirectories(dirPath)
          };
        }, (sys == null ? void 0 : sys.realpath) ? (path2) => sys.realpath(path2) : (path2) => path2);
        matches2 = matches2.map((match) => {
          const [_, source] = ctx.virtualFiles.getVirtualFile(match);
          if (source) {
            return source.fileName;
          }
          return match;
        });
        return [.../* @__PURE__ */ new Set([
          ...matches2,
          ...sys.readDirectory(dirName, extensions, excludes, includes2, depth)
        ])];
      }
      function getDirectories(dirName) {
        return [.../* @__PURE__ */ new Set([
          ...getVirtualFileDirectories(dirName),
          ...sys.getDirectories(dirName)
        ])];
      }
      function getVirtualFileDirectories(dirName) {
        const names = /* @__PURE__ */ new Set();
        for (const fileName of tsFileNames) {
          if (fileName.toLowerCase().startsWith(dirName.toLowerCase())) {
            const path2 = fileName.substring(dirName.length);
            if (path2.indexOf("/") >= 0) {
              names.add(path2.split("/")[0]);
            }
          }
        }
        return [...names];
      }
      function getScriptSnapshot(fileName) {
        var _a3, _b, _c;
        const [virtualFile] = ctx.virtualFiles.getVirtualFile(fileName);
        if (virtualFile) {
          return virtualFile.snapshot;
        }
        const tsScript = ctx.host.getScriptSnapshot(fileName);
        if (tsScript) {
          return tsScript;
        }
        const cache = fsFileSnapshots.get(fileName);
        const modifiedTime = (_b = (_a3 = sys.getModifiedTime) == null ? void 0 : _a3.call(sys, fileName)) == null ? void 0 : _b.valueOf();
        if (!cache || cache[0] !== modifiedTime) {
          if (sys.fileExists(fileName)) {
            const text = sys.readFile(fileName);
            const snapshot = text !== void 0 ? ts.ScriptSnapshot.fromString(text) : void 0;
            fsFileSnapshots.set(fileName, [modifiedTime, snapshot]);
          } else {
            fsFileSnapshots.set(fileName, [modifiedTime, void 0]);
          }
        }
        return (_c = fsFileSnapshots.get(fileName)) == null ? void 0 : _c[1];
      }
      function getScriptVersion(fileName) {
        var _a3, _b, _c, _d;
        const [virtualFile] = ctx.virtualFiles.getVirtualFile(fileName);
        const snapshot = (_a3 = virtualFile == null ? void 0 : virtualFile.snapshot) != null ? _a3 : ctx.host.getScriptSnapshot(fileName);
        if (snapshot) {
          if (!fileVersions.has(fileName)) {
            fileVersions.set(fileName, { lastVersion: 0, snapshotVersions: /* @__PURE__ */ new WeakMap() });
          }
          const version = fileVersions.get(fileName);
          if (!version.snapshotVersions.has(snapshot)) {
            version.snapshotVersions.set(snapshot, version.lastVersion++);
          }
          return version.snapshotVersions.get(snapshot).toString();
        }
        return (_d = (_c = (_b = sys.getModifiedTime) == null ? void 0 : _b.call(sys, fileName)) == null ? void 0 : _c.valueOf().toString()) != null ? _d : "";
      }
      function directoryExists(dirName) {
        return tsDirectories.has(normalizePath(dirName)) || sys.directoryExists(dirName);
      }
      function fileExists(fileName) {
        var _a3, _b;
        const ext = fileName.substring(fileName.lastIndexOf("."));
        if (ext === ".js" || ext === ".ts" || ext === ".jsx" || ext === ".tsx") {
          const sourceFileName = fileName.substring(0, fileName.lastIndexOf("."));
          if (!ctx.virtualFiles.hasSource(sourceFileName)) {
            const scriptSnapshot = getScriptSnapshot(sourceFileName);
            if (scriptSnapshot) {
              ctx.virtualFiles.updateSource(sourceFileName, scriptSnapshot, (_b = (_a3 = ctx.host).getLanguageId) == null ? void 0 : _b.call(_a3, sourceFileName));
            }
          }
        }
        if (ctx.virtualFiles.hasVirtualFile(fileName)) {
          return true;
        }
        if (ctx.host.getScriptSnapshot(fileName)) {
          return true;
        }
        return !!sys.fileExists(fileName);
      }
    }
    exports2.createLanguageServiceHost = createLanguageServiceHost;
    function setEquals(a3, b) {
      if (a3.size !== b.size)
        return false;
      for (const item of a3) {
        if (!b.has(item))
          return false;
      }
      return true;
    }
    function forEachEmbeddedFile(file, cb) {
      cb(file);
      for (const embeddedFile of file.embeddedFiles) {
        forEachEmbeddedFile(embeddedFile, cb);
      }
    }
    function normalizePath(fileName) {
      return fileName.replace(/\\/g, "/").toLowerCase();
    }
  }
});

// node_modules/@volar/typescript/lib/sys.js
var require_sys = __commonJS({
  "node_modules/@volar/typescript/lib/sys.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createSys = void 0;
    var path = require_path_browserify();
    var utilities_1 = require_utilities();
    var currentCwd = "";
    function createSys(ts, env) {
      var _a3, _b, _c, _d, _e, _f2, _g, _h, _i;
      let version = 0;
      const rootPath = env.uriToFileName(env.workspaceUri.toString());
      const sys = ts.sys;
      const root = {
        dirs: /* @__PURE__ */ new Map(),
        files: /* @__PURE__ */ new Map(),
        requestedRead: false
      };
      const promises = /* @__PURE__ */ new Set();
      const fileWatcher = (_a3 = env.onDidChangeWatchedFiles) == null ? void 0 : _a3.call(env, ({ changes }) => {
        for (const change of changes) {
          const fileName = env.uriToFileName(change.uri);
          const dirName = path.dirname(fileName);
          const baseName = path.basename(fileName);
          const dir = getDir(dirName);
          if (dir.files.has(baseName)) {
            version++;
            if (change.type === 1 || change.type === 2) {
              dir.files.set(baseName, {
                stat: {
                  type: 1,
                  ctime: Date.now(),
                  mtime: Date.now(),
                  size: -1
                },
                requestedStat: false
              });
            } else if (change.type === 3) {
              dir.files.set(baseName, {
                stat: void 0,
                text: void 0,
                requestedStat: true,
                requestedText: true
              });
            }
          }
        }
      });
      return {
        get version() {
          return version;
        },
        dispose() {
          fileWatcher == null ? void 0 : fileWatcher.dispose();
        },
        args: (_b = sys == null ? void 0 : sys.args) != null ? _b : [],
        newLine: (_c = sys == null ? void 0 : sys.newLine) != null ? _c : "\n",
        useCaseSensitiveFileNames: (_d = sys == null ? void 0 : sys.useCaseSensitiveFileNames) != null ? _d : false,
        realpath: sys == null ? void 0 : sys.realpath,
        write: (_e = sys == null ? void 0 : sys.write) != null ? _e : () => {
        },
        writeFile: (_f2 = sys == null ? void 0 : sys.writeFile) != null ? _f2 : () => {
        },
        createDirectory: (_g = sys == null ? void 0 : sys.createDirectory) != null ? _g : () => {
        },
        exit: (_h = sys == null ? void 0 : sys.exit) != null ? _h : () => {
        },
        getExecutingFilePath: (_i = sys == null ? void 0 : sys.getExecutingFilePath) != null ? _i : () => rootPath + "/__fake__.js",
        getCurrentDirectory: () => rootPath,
        getModifiedTime,
        readFile,
        readDirectory,
        getDirectories,
        resolvePath,
        fileExists,
        directoryExists,
        sync() {
          return __async(this, null, function* () {
            while (promises.size) {
              yield Promise.all(promises);
            }
            return version;
          });
        }
      };
      function resolvePath(fsPath) {
        if (sys) {
          if (currentCwd !== rootPath) {
            currentCwd = rootPath;
            if (sys.directoryExists(rootPath)) {
              try {
                process.chdir(rootPath);
              } catch (e) {
              }
            }
          }
          return sys.resolvePath(fsPath).replace(/\\/g, "/");
        }
        return path.resolve(fsPath).replace(/\\/g, "/");
      }
      function readFile(fileName, encoding) {
        var _a4;
        fileName = resolvePath(fileName);
        const dirPath = path.dirname(fileName);
        const dir = getDir(dirPath);
        const name = path.basename(fileName);
        readFileWorker(fileName, encoding, dir);
        return (_a4 = dir.files.get(name)) == null ? void 0 : _a4.text;
      }
      function directoryExists(dirName) {
        var _a4;
        dirName = resolvePath(dirName);
        const dir = getDir(dirName);
        if (dir.exists === void 0) {
          dir.exists = false;
          const result = (_a4 = env.fs) == null ? void 0 : _a4.stat(env.fileNameToUri(dirName));
          if (typeof result === "object" && "then" in result) {
            const promise = result;
            promises.add(promise);
            result.then((result2) => {
              promises.delete(promise);
              dir.exists = (result2 == null ? void 0 : result2.type) === 2;
              if (dir.exists) {
                version++;
              }
            });
          } else {
            dir.exists = (result == null ? void 0 : result.type) === 2;
          }
        }
        return dir.exists;
      }
      function getModifiedTime(fileName) {
        fileName = resolvePath(fileName);
        const file = getFile(fileName);
        if (!file.requestedStat) {
          file.requestedStat = true;
          handleStat(fileName, file);
        }
        return file.stat ? new Date(file.stat.mtime) : /* @__PURE__ */ new Date(0);
      }
      function fileExists(fileName) {
        fileName = resolvePath(fileName);
        const file = getFile(fileName);
        const exists = () => {
          var _a4;
          return file.text !== void 0 || ((_a4 = file.stat) == null ? void 0 : _a4.type) === 1;
        };
        if (exists()) {
          return true;
        }
        if (!file.requestedStat) {
          file.requestedStat = true;
          handleStat(fileName, file);
        }
        return exists();
      }
      function handleStat(fileName, file) {
        var _a4;
        const result = (_a4 = env.fs) == null ? void 0 : _a4.stat(env.fileNameToUri(fileName));
        if (typeof result === "object" && "then" in result) {
          const promise = result;
          promises.add(promise);
          result.then((result2) => {
            var _a5, _b2;
            promises.delete(promise);
            if (((_a5 = file.stat) == null ? void 0 : _a5.type) !== (result2 == null ? void 0 : result2.type) || ((_b2 = file.stat) == null ? void 0 : _b2.mtime) !== (result2 == null ? void 0 : result2.mtime)) {
              version++;
            }
            file.stat = result2;
          });
        } else {
          file.stat = result;
        }
      }
      function getFile(fileName) {
        fileName = resolvePath(fileName);
        const dirPath = path.dirname(fileName);
        const baseName = path.basename(fileName);
        const dir = getDir(dirPath);
        let file = dir.files.get(baseName);
        if (!file) {
          dir.files.set(baseName, file = {});
        }
        return file;
      }
      function getDirectories(dirName) {
        dirName = resolvePath(dirName);
        readDirectoryWorker(dirName);
        const dir = getDir(dirName);
        return [...dir.dirs.entries()].filter(([_, dir2]) => dir2.exists).map(([name]) => name);
      }
      function readDirectory(dirName, extensions, excludes, includes2, depth) {
        var _a4;
        dirName = resolvePath(dirName);
        const matches2 = (0, utilities_1.matchFiles)(dirName, extensions, excludes, includes2, (_a4 = sys == null ? void 0 : sys.useCaseSensitiveFileNames) != null ? _a4 : false, rootPath, depth, (dirPath) => {
          dirPath = resolvePath(dirPath);
          readDirectoryWorker(dirPath);
          const dir = getDir(dirPath);
          return {
            files: [...dir.files.entries()].filter(([_, file]) => {
              var _a5;
              return ((_a5 = file.stat) == null ? void 0 : _a5.type) === 1;
            }).map(([name]) => name),
            directories: [...dir.dirs.entries()].filter(([_, dir2]) => dir2.exists).map(([name]) => name)
          };
        }, (sys == null ? void 0 : sys.realpath) ? (path2) => sys.realpath(path2) : (path2) => path2);
        return [...new Set(matches2)];
      }
      function readFileWorker(fileName, encoding, dir) {
        var _a4;
        const name = path.basename(fileName);
        let file = dir.files.get(name);
        if (!file) {
          dir.files.set(name, file = {});
        }
        if (file.requestedText) {
          return;
        }
        file.requestedText = true;
        const uri = env.fileNameToUri(fileName);
        const result = (_a4 = env.fs) == null ? void 0 : _a4.readFile(uri, encoding);
        if (typeof result === "object" && "then" in result) {
          const promise = result;
          promises.add(promise);
          result.then((result2) => {
            promises.delete(promise);
            if (result2 !== void 0) {
              file.text = result2;
              if (file.stat) {
                file.stat.mtime++;
              }
              version++;
            }
          });
        } else if (result !== void 0) {
          file.text = result;
        }
      }
      function readDirectoryWorker(dirName) {
        var _a4;
        const dir = getDir(dirName);
        if (dir.requestedRead) {
          return;
        }
        dir.requestedRead = true;
        const result = (_a4 = env.fs) == null ? void 0 : _a4.readDirectory(env.fileNameToUri(dirName || "."));
        if (typeof result === "object" && "then" in result) {
          const promise = result;
          promises.add(promise);
          result.then((result2) => {
            promises.delete(promise);
            if (onReadDirectoryResult(dirName, dir, result2)) {
              version++;
            }
          });
        } else {
          onReadDirectoryResult(dirName, dir, result != null ? result : []);
        }
      }
      function onReadDirectoryResult(dirName, dir, result) {
        var _a4;
        result = result.filter(([name]) => name !== "." && name !== "..");
        let updated = false;
        for (const [name, _fileType] of result) {
          let fileType = _fileType;
          if (fileType === 64) {
            const stat = (_a4 = env.fs) == null ? void 0 : _a4.stat(env.fileNameToUri(dirName + "/" + name));
            if (typeof stat === "object" && "then" in stat) {
              const promise = stat;
              promises.add(promise);
              stat.then((stat2) => {
                var _a5, _b2;
                promises.delete(promise);
                if ((stat2 == null ? void 0 : stat2.type) === 1) {
                  let file = dir.files.get(name);
                  if (!file) {
                    dir.files.set(name, file = {});
                  }
                  if (stat2.type !== ((_a5 = file.stat) == null ? void 0 : _a5.type) || stat2.mtime !== ((_b2 = file.stat) == null ? void 0 : _b2.mtime)) {
                    version++;
                  }
                  file.stat = stat2;
                  file.requestedStat = true;
                } else if ((stat2 == null ? void 0 : stat2.type) === 2) {
                  const childDir = getDirFromDir(dir, name);
                  if (!childDir.exists) {
                    childDir.exists = true;
                    version++;
                  }
                }
              });
            } else if (stat) {
              fileType = stat.type;
            }
          }
          if (fileType === 1) {
            let file = dir.files.get(name);
            if (!file) {
              dir.files.set(name, file = {});
            }
            if (!file.stat) {
              file.stat = {
                type: 1,
                mtime: 0,
                ctime: 0,
                size: 0
              };
              updated = true;
            }
          } else if (fileType === 2) {
            const childDir = getDirFromDir(dir, name);
            if (!childDir.exists) {
              childDir.exists = true;
              updated = true;
            }
          }
        }
        return updated;
      }
      function getDir(dirName) {
        const dirNames = [];
        let currentDirPath = dirName;
        let currentDirName = path.basename(currentDirPath);
        let lastDirPath;
        while (lastDirPath !== currentDirPath) {
          lastDirPath = currentDirPath;
          dirNames.push(currentDirName);
          currentDirPath = path.dirname(currentDirPath);
          currentDirName = path.basename(currentDirPath);
        }
        let currentDir = root;
        for (let i = dirNames.length - 1; i >= 0; i--) {
          const nextDirName = dirNames[i];
          currentDir = getDirFromDir(currentDir, nextDirName);
        }
        return currentDir;
      }
      function getDirFromDir(dir, name) {
        let target = dir.dirs.get(name);
        if (!target) {
          dir.dirs.set(name, target = {
            dirs: /* @__PURE__ */ new Map(),
            files: /* @__PURE__ */ new Map()
          });
        }
        return target;
      }
    }
    exports2.createSys = createSys;
  }
});

// node_modules/@volar/typescript/lib/getProgram.js
var require_getProgram = __commonJS({
  "node_modules/@volar/typescript/lib/getProgram.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getProgram = void 0;
    function getProgram(ts, core, ls, sys) {
      const proxy = {
        getRootFileNames,
        emit,
        getSyntacticDiagnostics,
        getSemanticDiagnostics,
        getGlobalDiagnostics,
        // @ts-expect-error
        getBindAndCheckDiagnostics
      };
      return new Proxy({}, {
        get: (target, property) => {
          if (property in proxy) {
            return proxy[property];
          }
          const program = getProgram2();
          if (property in program) {
            return program[property];
          }
          return target[property];
        },
        // #17
        // notice: https://github.com/vuejs/language-tools/issues/2403
        set: (target, property, newValue) => {
          const program = getProgram2();
          target[property] = program[property] = newValue;
          return true;
        }
      });
      function getProgram2() {
        return ls.getProgram();
      }
      function getRootFileNames() {
        return getProgram2().getRootFileNames().filter((fileName) => {
          var _a3;
          return (_a3 = sys.fileExists) == null ? void 0 : _a3.call(sys, fileName);
        });
      }
      function getBindAndCheckDiagnostics(sourceFile, cancellationToken) {
        return getSourceFileDiagnosticsWorker(sourceFile, cancellationToken, "getBindAndCheckDiagnostics");
      }
      function getSyntacticDiagnostics(sourceFile, cancellationToken) {
        return getSourceFileDiagnosticsWorker(sourceFile, cancellationToken, "getSyntacticDiagnostics");
      }
      function getSemanticDiagnostics(sourceFile, cancellationToken) {
        return getSourceFileDiagnosticsWorker(sourceFile, cancellationToken, "getSemanticDiagnostics");
      }
      function getSourceFileDiagnosticsWorker(sourceFile, cancellationToken, api) {
        var _a3, _b, _c;
        if (sourceFile) {
          const [virtualFile, source] = core.virtualFiles.getVirtualFile(sourceFile.fileName);
          if (virtualFile && source) {
            if (!virtualFile.capabilities.diagnostic)
              return [];
            const errors = transformDiagnostics((_b = (_a3 = ls.getProgram()) == null ? void 0 : _a3[api](sourceFile, cancellationToken)) != null ? _b : []);
            return errors;
          }
        }
        return transformDiagnostics((_c = getProgram2()[api](sourceFile, cancellationToken)) != null ? _c : []);
      }
      function getGlobalDiagnostics(cancellationToken) {
        var _a3;
        return transformDiagnostics((_a3 = getProgram2().getGlobalDiagnostics(cancellationToken)) != null ? _a3 : []);
      }
      function emit(targetSourceFile, _writeFile, cancellationToken, emitOnlyDtsFiles, customTransformers) {
        var _a3;
        const scriptResult = getProgram2().emit(targetSourceFile, (_a3 = sys.writeFile) != null ? _a3 : ts.sys.writeFile, cancellationToken, emitOnlyDtsFiles, customTransformers);
        return {
          emitSkipped: scriptResult.emitSkipped,
          emittedFiles: scriptResult.emittedFiles,
          diagnostics: transformDiagnostics(scriptResult.diagnostics)
        };
      }
      function transformDiagnostics(diagnostics) {
        var _a3, _b;
        const result = [];
        for (const diagnostic of diagnostics) {
          if (diagnostic.file !== void 0 && diagnostic.start !== void 0 && diagnostic.length !== void 0) {
            const [virtualFile, source] = core.virtualFiles.getVirtualFile(diagnostic.file.fileName);
            if (virtualFile && source) {
              if (((_a3 = sys.fileExists) == null ? void 0 : _a3.call(sys, source.fileName)) === false)
                continue;
              for (const [_, [sourceSnapshot, map]] of core.virtualFiles.getMaps(virtualFile)) {
                if (sourceSnapshot !== source.snapshot)
                  continue;
                for (const start of map.toSourceOffsets(diagnostic.start)) {
                  const reportStart = typeof start[1].data.diagnostic === "object" ? start[1].data.diagnostic.shouldReport() : !!start[1].data.diagnostic;
                  if (!reportStart)
                    continue;
                  for (const end of map.toSourceOffsets(diagnostic.start + diagnostic.length, true)) {
                    const reportEnd = typeof end[1].data.diagnostic === "object" ? end[1].data.diagnostic.shouldReport() : !!end[1].data.diagnostic;
                    if (!reportEnd)
                      continue;
                    onMapping(diagnostic, source.fileName, start[0], end[0], source.snapshot.getText(0, source.snapshot.getLength()));
                    break;
                  }
                  break;
                }
              }
            } else {
              if (((_b = sys.fileExists) == null ? void 0 : _b.call(sys, diagnostic.file.fileName)) === false)
                continue;
              onMapping(diagnostic, diagnostic.file.fileName, diagnostic.start, diagnostic.start + diagnostic.length, diagnostic.file.text);
            }
          } else if (diagnostic.file === void 0) {
            result.push(diagnostic);
          }
        }
        return result;
        function onMapping(diagnostic, fileName, start, end, docText) {
          var _a4;
          let file = fileName === ((_a4 = diagnostic.file) == null ? void 0 : _a4.fileName) ? diagnostic.file : void 0;
          if (!file) {
            if (docText === void 0) {
              const snapshot = core.host.getScriptSnapshot(fileName);
              if (snapshot) {
                docText = snapshot.getText(0, snapshot.getLength());
              }
            } else {
              file = ts.createSourceFile(fileName, docText, ts.ScriptTarget.Latest, void 0, ts.ScriptKind.Deferred);
              file.originalFileName = fileName;
              file.path = fileName.toLowerCase();
              file.resolvedPath = fileName.toLowerCase();
            }
          }
          const newDiagnostic = __spreadProps(__spreadValues({}, diagnostic), {
            file,
            start,
            length: end - start
          });
          const relatedInformation = diagnostic.relatedInformation;
          if (relatedInformation) {
            newDiagnostic.relatedInformation = transformDiagnostics(relatedInformation);
          }
          result.push(newDiagnostic);
        }
      }
    }
    exports2.getProgram = getProgram;
  }
});

// node_modules/@volar/typescript/lib/serverPlugin.js
var require_serverPlugin = __commonJS({
  "node_modules/@volar/typescript/lib/serverPlugin.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getExternalFiles = exports2.searchExternalFiles = exports2.decorateLanguageServiceHost = void 0;
    var language_core_1 = require_language_core();
    function decorateLanguageServiceHost(virtualFiles, languageServiceHost, ts, exts) {
      var _a3, _b, _c, _d, _e;
      let extraProjectVersion = 0;
      const scripts = /* @__PURE__ */ new Map();
      const readDirectory = (_a3 = languageServiceHost.readDirectory) == null ? void 0 : _a3.bind(languageServiceHost);
      const resolveModuleNameLiterals = (_b = languageServiceHost.resolveModuleNameLiterals) == null ? void 0 : _b.bind(languageServiceHost);
      const resolveModuleNames = (_c = languageServiceHost.resolveModuleNames) == null ? void 0 : _c.bind(languageServiceHost);
      const getProjectVersion = (_d = languageServiceHost.getProjectVersion) == null ? void 0 : _d.bind(languageServiceHost);
      const getScriptSnapshot = languageServiceHost.getScriptSnapshot.bind(languageServiceHost);
      const getScriptKind = (_e = languageServiceHost.getScriptKind) == null ? void 0 : _e.bind(languageServiceHost);
      if (readDirectory) {
        languageServiceHost.readDirectory = (path, extensions, exclude, include, depth) => {
          if (extensions) {
            for (const ext of exts) {
              if (!extensions.includes(ext)) {
                extensions = [...extensions, ...ext];
              }
            }
          }
          return readDirectory(path, extensions, exclude, include, depth);
        };
      }
      if (resolveModuleNameLiterals) {
        languageServiceHost.resolveModuleNameLiterals = (moduleNames, containingFile, redirectedReference, options, ...rest) => {
          const resolvedModules = resolveModuleNameLiterals(moduleNames, containingFile, redirectedReference, options, ...rest);
          return moduleNames.map((name, i) => {
            if (exts.some((ext) => name.text.endsWith(ext))) {
              const resolved = resolveModuleName(name.text, containingFile, options, redirectedReference);
              if (resolved.resolvedModule) {
                return resolved;
              }
            }
            return resolvedModules[i];
          });
        };
      } else if (resolveModuleNames) {
        languageServiceHost.resolveModuleNames = (moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile) => {
          const resolvedModules = resolveModuleNames(moduleNames, containingFile, reusedNames, redirectedReference, options, containingSourceFile);
          return moduleNames.map((name, i) => {
            if (exts.some((ext) => name.endsWith(ext))) {
              const resolved = resolveModuleName(name, containingFile, options, redirectedReference);
              if (resolved.resolvedModule) {
                return resolved.resolvedModule;
              }
            }
            return resolvedModules[i];
          });
        };
      }
      if (getProjectVersion) {
        languageServiceHost.getProjectVersion = () => {
          return getProjectVersion() + ":" + extraProjectVersion;
        };
      }
      languageServiceHost.getScriptSnapshot = (fileName) => {
        var _a4;
        if (exts.some((ext) => fileName.endsWith(ext))) {
          updateScript(fileName);
          return (_a4 = scripts.get(fileName)) == null ? void 0 : _a4.snapshot;
        }
        return getScriptSnapshot(fileName);
      };
      if (getScriptKind) {
        languageServiceHost.getScriptKind = (fileName) => {
          if (exts.some((ext) => fileName.endsWith(ext))) {
            updateScript(fileName);
            const script = scripts.get(fileName);
            if (script) {
              if (script.extension.endsWith(".js")) {
                return ts.ScriptKind.JS;
              }
              if (script.extension.endsWith(".jsx")) {
                return ts.ScriptKind.JSX;
              }
              if (script.extension.endsWith(".ts")) {
                return ts.ScriptKind.TS;
              }
              if (script.extension.endsWith(".tsx")) {
                return ts.ScriptKind.TSX;
              }
            }
            return ts.ScriptKind.Deferred;
          }
          return getScriptKind(fileName);
        };
      }
      function resolveModuleName(name, containingFile, options, redirectedReference) {
        const resolved = ts.resolveModuleName(name, containingFile, options, {
          readFile(fileName) {
            return languageServiceHost.readFile(fileName);
          },
          fileExists(fileName) {
            if (exts.some((ext) => fileName.endsWith(ext + ".d.ts"))) {
              return fileExists(fileName.slice(0, -".d.ts".length));
            }
            return languageServiceHost.fileExists(fileName);
          }
        }, void 0, redirectedReference);
        if (resolved.resolvedModule) {
          resolved.resolvedModule.resolvedFileName = resolved.resolvedModule.resolvedFileName.slice(0, -".d.ts".length);
          const script = updateScript(resolved.resolvedModule.resolvedFileName);
          if (script) {
            resolved.resolvedModule.extension = script.extension;
          }
        }
        return resolved;
      }
      function fileExists(fileName) {
        var _a4, _b2, _c2, _d2, _e2;
        if (languageServiceHost.fileExists(fileName)) {
          const fileSize = (_e2 = (_d2 = (_b2 = (_a4 = ts.sys).getFileSize) == null ? void 0 : _b2.call(_a4, fileName)) != null ? _d2 : (_c2 = languageServiceHost.readFile(fileName)) == null ? void 0 : _c2.length) != null ? _e2 : 0;
          return fileSize < 4 * 1024 * 1024;
        }
        return false;
      }
      function updateScript(fileName) {
        var _a4;
        const version = languageServiceHost.getScriptVersion(fileName);
        if (version !== ((_a4 = scripts.get(fileName)) == null ? void 0 : _a4.version)) {
          const text = languageServiceHost.readFile(fileName);
          let snapshot;
          let extension = ".ts";
          if (text !== void 0) {
            extraProjectVersion++;
            const virtualFile = virtualFiles.updateSource(fileName, ts.ScriptSnapshot.fromString(text), void 0);
            if (virtualFile) {
              let patchedText = text.split("\n").map((line) => " ".repeat(line.length)).join("\n");
              (0, language_core_1.forEachEmbeddedFile)(virtualFile, (file) => {
                const ext = file.fileName.substring(fileName.length);
                if (file.kind === language_core_1.FileKind.TypeScriptHostFile && (ext === ".d.ts" || ext.match(/^\.(js|ts)x?$/))) {
                  extension = ext;
                  patchedText += file.snapshot.getText(0, file.snapshot.getLength());
                }
              });
              snapshot = ts.ScriptSnapshot.fromString(patchedText);
            }
          } else if (virtualFiles.hasSource(fileName)) {
            extraProjectVersion++;
            virtualFiles.deleteSource(fileName);
          }
          scripts.set(fileName, {
            version,
            snapshot,
            extension
          });
        }
        return scripts.get(fileName);
      }
    }
    exports2.decorateLanguageServiceHost = decorateLanguageServiceHost;
    function searchExternalFiles(ts, project, exts) {
      if (project.projectKind !== ts.server.ProjectKind.Configured) {
        return [];
      }
      const configFile = project.getProjectName();
      const config = ts.readJsonConfigFile(configFile, project.readFile.bind(project));
      const parseHost = {
        useCaseSensitiveFileNames: project.useCaseSensitiveFileNames(),
        fileExists: project.fileExists.bind(project),
        readFile: project.readFile.bind(project),
        readDirectory: (...args) => {
          args[1] = exts;
          return project.readDirectory(...args);
        }
      };
      const parsed = ts.parseJsonSourceFileConfigFileContent(config, parseHost, project.getCurrentDirectory());
      return parsed.fileNames;
    }
    exports2.searchExternalFiles = searchExternalFiles;
    exports2.getExternalFiles = searchExternalFiles;
  }
});

// node_modules/@volar/typescript/index.js
var require_typescript = __commonJS({
  "node_modules/@volar/typescript/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar(require_documentRegistry(), exports2);
    __exportStar(require_languageService(), exports2);
    __exportStar(require_languageServiceHost(), exports2);
    __exportStar(require_sys(), exports2);
    __exportStar(require_getProgram(), exports2);
    __exportStar(require_serverPlugin(), exports2);
  }
});

// node_modules/@volar/language-server/lib/common/project.js
var require_project = __commonJS({
  "node_modules/@volar/language-server/lib/common/project.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProject = void 0;
    var language_service_1 = require_language_service();
    var path = require_path_browserify();
    var vscode = require_main4();
    var serverConfig_1 = require_serverConfig();
    var uriMap_1 = require_uriMap();
    var typescript_1 = require_typescript();
    var globalSnapshots = /* @__PURE__ */ new WeakMap();
    function createProject(context) {
      return __async(this, null, function* () {
        var _a3, _b, _c, _d;
        let projectVersion = 0;
        let token = context.server.runtimeEnv.getCancellationToken();
        let languageService;
        const tsToken = {
          isCancellationRequested() {
            return token.isCancellationRequested;
          },
          throwIfCancellationRequested() {
          }
        };
        const { uriToFileName, fileNameToUri, fs } = context.server.runtimeEnv;
        const env = {
          uriToFileName,
          fileNameToUri,
          fs,
          console: context.server.runtimeEnv.console,
          locale: context.workspaces.initParams.locale,
          workspaceUri: context.project.workspaceUri,
          rootUri: context.project.rootUri,
          clientCapabilities: context.workspaces.initParams.capabilities,
          getConfiguration: (_a3 = context.server.configurationHost) == null ? void 0 : _a3.getConfiguration,
          onDidChangeConfiguration: (_b = context.server.configurationHost) == null ? void 0 : _b.onDidChangeConfiguration,
          onDidChangeWatchedFiles: context.server.onDidChangeWatchedFiles
        };
        if (!globalSnapshots.has(fs)) {
          globalSnapshots.set(fs, (0, uriMap_1.createUriMap)(fileNameToUri));
        }
        const askedFiles = (0, uriMap_1.createUriMap)(fileNameToUri);
        const languageHost = {
          workspacePath: uriToFileName(context.project.workspaceUri.toString()),
          rootPath: uriToFileName(context.project.rootUri.toString()),
          getProjectVersion: () => projectVersion.toString(),
          getScriptFileNames: () => parsedCommandLine.fileNames,
          getScriptSnapshot: (fileName) => {
            askedFiles.pathSet(fileName, true);
            const doc = context.workspaces.documents.data.pathGet(fileName);
            if (doc) {
              return doc.getSnapshot();
            }
            const fsSnapshot = globalSnapshots.get(fs).pathGet(fileName);
            if (fsSnapshot) {
              return fsSnapshot;
            }
          },
          getLanguageId: (fileName) => {
            var _a4;
            return (_a4 = context.workspaces.documents.data.pathGet(fileName)) == null ? void 0 : _a4.languageId;
          },
          getCancellationToken: () => tsToken,
          getCompilationSettings: () => parsedCommandLine.options,
          getLocalizedDiagnosticMessages: context.workspaces.tsLocalized ? () => context.workspaces.tsLocalized : void 0,
          getProjectReferences: () => parsedCommandLine.projectReferences
        };
        const docChangeWatcher = context.workspaces.documents.onDidChangeContent(() => {
          projectVersion++;
          token = context.server.runtimeEnv.getCancellationToken();
        });
        const fileWatch = (_c = env.onDidChangeWatchedFiles) == null ? void 0 : _c.call(env, (params) => {
          onWorkspaceFilesChanged(params.changes);
        });
        let existingOptions;
        for (const plugin of context.workspaces.plugins) {
          if (plugin.resolveExistingOptions) {
            existingOptions = plugin.resolveExistingOptions(existingOptions);
          }
        }
        let parsedCommandLine = yield createParsedCommandLine(context.workspaces.ts, env, uriToFileName(context.project.rootUri.toString()), context.project.tsConfig, context.workspaces.plugins, existingOptions);
        let config = (_d = context.project.workspaceUri.scheme === "file" ? (0, serverConfig_1.loadConfig)(context.server.runtimeEnv.console, context.server.runtimeEnv.uriToFileName(context.project.workspaceUri.toString()), context.workspaces.initOptions.configFilePath) : {}) != null ? _d : {};
        for (const plugin of context.workspaces.plugins) {
          if (plugin.resolveConfig) {
            config = yield plugin.resolveConfig(config, __spreadProps(__spreadValues({}, context), {
              env,
              host: languageHost
            }));
          }
        }
        yield syncRootScriptSnapshots();
        return {
          context,
          tsConfig: context.project.tsConfig,
          languageHost,
          getLanguageService: getLanguageService3,
          getLanguageServiceDontCreate: () => languageService,
          getParsedCommandLine: () => parsedCommandLine,
          tryAddFile: (fileName) => {
            if (!parsedCommandLine.fileNames.includes(fileName)) {
              parsedCommandLine.fileNames.push(fileName);
              projectVersion++;
              token = context.server.runtimeEnv.getCancellationToken();
            }
          },
          askedFiles,
          dispose
        };
        function getLanguageService3() {
          if (!languageService) {
            languageService = (0, language_service_1.createLanguageService)({ typescript: context.workspaces.ts }, env, config, languageHost);
          }
          return languageService;
        }
        function syncRootScriptSnapshots() {
          return __async(this, null, function* () {
            const promises = [];
            let dirty = false;
            for (const fileName of parsedCommandLine.fileNames) {
              const uri = fileNameToUri(fileName);
              if (!globalSnapshots.get(fs).uriGet(uri)) {
                dirty = true;
                promises.push(updateRootScriptSnapshot(uri));
              }
            }
            yield Promise.all(promises);
            return dirty;
          });
        }
        function updateRootScriptSnapshot(uri) {
          return __async(this, null, function* () {
            const text = yield context.server.runtimeEnv.fs.readFile(uri);
            globalSnapshots.get(fs).uriSet(uri, text !== void 0 ? {
              getText: (start, end) => text.substring(start, end),
              getLength: () => text.length,
              getChangeRange: () => void 0
            } : void 0);
          });
        }
        function onWorkspaceFilesChanged(changes) {
          return __async(this, null, function* () {
            const oldProjectVersion = projectVersion;
            const creates = changes.filter((change) => change.type === vscode.FileChangeType.Created);
            if (creates.length) {
              parsedCommandLine = yield createParsedCommandLine(context.workspaces.ts, env, uriToFileName(context.project.rootUri.toString()), context.project.tsConfig, context.workspaces.plugins, existingOptions);
              if (yield syncRootScriptSnapshots()) {
                projectVersion++;
              }
            }
            yield Promise.all(changes.map((change) => __async(this, null, function* () {
              if (askedFiles.uriGet(change.uri) && globalSnapshots.get(fs).uriGet(change.uri)) {
                if (change.type === vscode.FileChangeType.Changed) {
                  yield updateRootScriptSnapshot(change.uri);
                } else if (change.type === vscode.FileChangeType.Deleted) {
                  globalSnapshots.get(fs).uriSet(change.uri, void 0);
                }
                projectVersion++;
              }
            })));
            if (oldProjectVersion !== projectVersion) {
              token = context.server.runtimeEnv.getCancellationToken();
            }
          });
        }
        function dispose() {
          languageService == null ? void 0 : languageService.dispose();
          fileWatch == null ? void 0 : fileWatch.dispose();
          docChangeWatcher.dispose();
        }
      });
    }
    exports2.createProject = createProject;
    function createParsedCommandLine(ts, env, rootPath, tsConfig, plugins, existingOptions) {
      return __async(this, null, function* () {
        const extraFileExtensions = plugins.map((plugin) => {
          var _a3;
          return (_a3 = plugin.extraFileExtensions) != null ? _a3 : [];
        }).flat();
        if (ts) {
          const sys = (0, typescript_1.createSys)(ts, __spreadProps(__spreadValues({}, env), {
            onDidChangeWatchedFiles: void 0
          }));
          let content;
          let sysVersion;
          let newSysVersion = yield sys.sync();
          while (sysVersion !== newSysVersion) {
            sysVersion = newSysVersion;
            try {
              if (typeof tsConfig === "string") {
                const config = ts.readJsonConfigFile(tsConfig, sys.readFile);
                content = ts.parseJsonSourceFileConfigFileContent(config, sys, path.dirname(tsConfig), existingOptions, tsConfig, void 0, extraFileExtensions);
              } else {
                content = ts.parseJsonConfigFileContent({ files: [] }, sys, rootPath, __spreadValues(__spreadValues({}, tsConfig), existingOptions), rootPath + "/jsconfig.json", void 0, extraFileExtensions);
              }
              content.options.outDir = void 0;
              content.fileNames = content.fileNames.map((fileName) => fileName.replace(/\\/g, "/"));
            } catch (e) {
            }
            newSysVersion = yield sys.sync();
          }
          if (content) {
            return content;
          }
        }
        return {
          errors: [],
          fileNames: [],
          options: {}
        };
      });
    }
  }
});

// node_modules/@volar/language-server/lib/common/utils/inferredCompilerOptions.js
var require_inferredCompilerOptions = __commonJS({
  "node_modules/@volar/language-server/lib/common/utils/inferredCompilerOptions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getInferredCompilerOptions = void 0;
    function getInferredCompilerOptions(ctx) {
      return __async(this, null, function* () {
        var _a3, _b;
        let [implicitProjectConfig_1, implicitProjectConfig_2] = yield Promise.all([
          (_a3 = ctx == null ? void 0 : ctx.getConfiguration) == null ? void 0 : _a3.call(ctx, "js/ts.implicitProjectConfig"),
          (_b = ctx == null ? void 0 : ctx.getConfiguration) == null ? void 0 : _b.call(ctx, "javascript.implicitProjectConfig")
        ]);
        implicitProjectConfig_1 = implicitProjectConfig_1 != null ? implicitProjectConfig_1 : {};
        implicitProjectConfig_2 = implicitProjectConfig_2 != null ? implicitProjectConfig_2 : {};
        const checkJs = readCheckJs();
        const experimentalDecorators = readExperimentalDecorators();
        const strictNullChecks = readImplicitStrictNullChecks();
        const strictFunctionTypes = readImplicitStrictFunctionTypes();
        const options = __spreadProps(__spreadValues({}, inferredProjectCompilerOptions("typescript")), {
          allowJs: true,
          allowSyntheticDefaultImports: true,
          allowNonTsExtensions: true,
          resolveJsonModule: true,
          jsx: 1
        });
        return options;
        function readCheckJs() {
          var _a4, _b2;
          return (_b2 = (_a4 = implicitProjectConfig_1["checkJs"]) != null ? _a4 : implicitProjectConfig_2["checkJs"]) != null ? _b2 : false;
        }
        function readExperimentalDecorators() {
          var _a4, _b2;
          return (_b2 = (_a4 = implicitProjectConfig_1["experimentalDecorators"]) != null ? _a4 : implicitProjectConfig_2["experimentalDecorators"]) != null ? _b2 : false;
        }
        function readImplicitStrictNullChecks() {
          var _a4;
          return (_a4 = implicitProjectConfig_1["strictNullChecks"]) != null ? _a4 : false;
        }
        function readImplicitStrictFunctionTypes() {
          var _a4;
          return (_a4 = implicitProjectConfig_1["strictFunctionTypes"]) != null ? _a4 : true;
        }
        function inferredProjectCompilerOptions(projectType) {
          const projectConfig = {
            module: 1,
            target: 7,
            jsx: 1
          };
          if (checkJs) {
            projectConfig.checkJs = true;
            if (projectType === "typescript") {
              projectConfig.allowJs = true;
            }
          }
          if (experimentalDecorators) {
            projectConfig.experimentalDecorators = true;
          }
          if (strictNullChecks) {
            projectConfig.strictNullChecks = true;
          }
          if (strictFunctionTypes) {
            projectConfig.strictFunctionTypes = true;
          }
          if (projectType === "typescript") {
            projectConfig.sourceMap = true;
          }
          return projectConfig;
        }
      });
    }
    exports2.getInferredCompilerOptions = getInferredCompilerOptions;
  }
});

// node_modules/@volar/language-server/lib/common/workspaces.js
var require_workspaces = __commonJS({
  "node_modules/@volar/language-server/lib/common/workspaces.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sortTsConfigs = exports2.sleep = exports2.createWorkspaces = exports2.rootTsConfigNames = void 0;
    var vscode = require_main4();
    var vscode_uri_1 = require_umd();
    var types_1 = require_types4();
    var isFileInDir_1 = require_isFileInDir();
    var path = require_path_browserify();
    var project_1 = require_project();
    var inferredCompilerOptions_1 = require_inferredCompilerOptions();
    var uriMap_1 = require_uriMap();
    var language_service_1 = require_language_service();
    exports2.rootTsConfigNames = ["tsconfig.json", "jsconfig.json"];
    function createWorkspaces(context, rootUris) {
      var _a3, _b;
      const { fileNameToUri, uriToFileName, fs } = context.server.runtimeEnv;
      const configProjects = (0, uriMap_1.createUriMap)(fileNameToUri);
      const inferredProjects = (0, uriMap_1.createUriMap)(fileNameToUri);
      const rootTsConfigs = /* @__PURE__ */ new Set();
      const searchedDirs = /* @__PURE__ */ new Set();
      let semanticTokensReq = 0;
      let documentUpdatedReq = 0;
      context.workspaces.documents.onDidChangeContent(({ textDocument }) => {
        updateDiagnostics(textDocument.uri);
      });
      context.workspaces.documents.onDidClose(({ textDocument }) => {
        context.server.connection.sendDiagnostics({ uri: textDocument.uri, diagnostics: [] });
      });
      context.server.onDidChangeWatchedFiles(({ changes }) => {
        const tsConfigChanges = changes.filter((change) => exports2.rootTsConfigNames.includes(change.uri.substring(change.uri.lastIndexOf("/") + 1)));
        for (const change of tsConfigChanges) {
          if (change.type === vscode.FileChangeType.Created) {
            rootTsConfigs.add(uriToFileName(change.uri));
          } else if ((change.type === vscode.FileChangeType.Changed || change.type === vscode.FileChangeType.Deleted) && configProjects.uriHas(change.uri)) {
            if (change.type === vscode.FileChangeType.Deleted) {
              rootTsConfigs.delete(uriToFileName(change.uri));
            }
            const project = configProjects.uriGet(change.uri);
            configProjects.uriDelete(change.uri);
            project == null ? void 0 : project.then((project2) => project2.dispose());
          }
        }
        if (tsConfigChanges.length) {
          reloadDiagnostics();
        } else {
          updateDiagnosticsAndSemanticTokens();
        }
      });
      (_b = (_a3 = context.server.configurationHost) == null ? void 0 : _a3.onDidChangeConfiguration) == null ? void 0 : _b.call(_a3, updateDiagnosticsAndSemanticTokens);
      return {
        configProjects,
        inferredProjects,
        getProject: getProjectAndTsConfig,
        reloadProjects: reloadProject,
        add: (rootUri) => {
          if (!rootUris.some((uri) => uri.toString() === rootUri.toString())) {
            rootUris.push(rootUri);
          }
        },
        remove: (rootUri) => {
          rootUris = rootUris.filter((uri) => uri.toString() !== rootUri.toString());
          for (const uri of configProjects.uriKeys()) {
            const project = configProjects.uriGet(uri);
            project.then((project2) => {
              if (project2.context.project.workspaceUri.toString() === rootUri.toString()) {
                configProjects.uriDelete(uri);
                project2.dispose();
              }
            });
          }
        }
      };
      function reloadProject() {
        return __async(this, null, function* () {
          for (const project of [...configProjects.values(), ...inferredProjects.values()]) {
            project.then((project2) => project2.dispose());
          }
          configProjects.clear();
          inferredProjects.clear();
          reloadDiagnostics();
        });
      }
      function reloadDiagnostics() {
        for (const doc of context.workspaces.documents.data.values()) {
          context.server.connection.sendDiagnostics({ uri: doc.uri, diagnostics: [] });
        }
        updateDiagnosticsAndSemanticTokens();
      }
      function updateDiagnosticsAndSemanticTokens() {
        return __async(this, null, function* () {
          var _a4, _b2, _c, _d, _e, _f2, _g;
          const req = ++semanticTokensReq;
          yield updateDiagnostics();
          const delay = 250;
          yield sleep(delay);
          if (req === semanticTokensReq) {
            if ((_b2 = (_a4 = context.workspaces.initParams.capabilities.workspace) == null ? void 0 : _a4.semanticTokens) == null ? void 0 : _b2.refreshSupport) {
              context.server.connection.languages.semanticTokens.refresh();
            }
            if ((_d = (_c = context.workspaces.initParams.capabilities.workspace) == null ? void 0 : _c.inlayHint) == null ? void 0 : _d.refreshSupport) {
              context.server.connection.languages.inlayHint.refresh();
            }
            if (((_e = context.workspaces.initOptions.diagnosticModel) != null ? _e : types_1.DiagnosticModel.Push) === types_1.DiagnosticModel.Pull) {
              if ((_g = (_f2 = context.workspaces.initParams.capabilities.workspace) == null ? void 0 : _f2.diagnostics) == null ? void 0 : _g.refreshSupport) {
                context.server.connection.languages.diagnostics.refresh();
              }
            }
          }
        });
      }
      function updateDiagnostics(docUri) {
        return __async(this, null, function* () {
          var _a4;
          if (((_a4 = context.workspaces.initOptions.diagnosticModel) != null ? _a4 : types_1.DiagnosticModel.Push) !== types_1.DiagnosticModel.Push)
            return;
          const req = ++documentUpdatedReq;
          const delay = 250;
          const cancel = context.server.runtimeEnv.getCancellationToken({
            get isCancellationRequested() {
              return req !== documentUpdatedReq;
            },
            onCancellationRequested: vscode.Event.None
          });
          const changeDoc = docUri ? context.workspaces.documents.data.uriGet(docUri) : void 0;
          const otherDocs = [...context.workspaces.documents.data.values()].filter((doc) => doc !== changeDoc);
          if (changeDoc) {
            yield sleep(delay);
            if (cancel.isCancellationRequested) {
              return;
            }
            yield sendDocumentDiagnostics(changeDoc.uri, changeDoc.version, cancel);
          }
          for (const doc of otherDocs) {
            yield sleep(delay);
            if (cancel.isCancellationRequested) {
              break;
            }
            yield sendDocumentDiagnostics(doc.uri, doc.version, cancel);
          }
        });
      }
      function sendDocumentDiagnostics(uri, version, cancel) {
        return __async(this, null, function* () {
          var _a4;
          const project = (_a4 = yield getProjectAndTsConfig(uri)) == null ? void 0 : _a4.project;
          if (!project)
            return;
          if (context.workspaces.initOptions.serverMode === types_1.ServerMode.Syntactic) {
            return;
          }
          const languageService = project.getLanguageService();
          const errors = yield languageService.doValidation(uri, "all", cancel, (result) => {
            context.server.connection.sendDiagnostics({ uri, diagnostics: result, version });
          });
          context.server.connection.sendDiagnostics({ uri, diagnostics: errors, version });
        });
      }
      function getProjectAndTsConfig(uri) {
        return __async(this, null, function* () {
          if (context.workspaces.initOptions.serverMode !== types_1.ServerMode.Syntactic) {
            const tsconfig = yield findMatchConfigs(vscode_uri_1.URI.parse(uri));
            if (tsconfig) {
              const project2 = yield getProjectByCreate(tsconfig);
              return {
                tsconfig,
                project: project2
              };
            }
          }
          const workspaceUri = getWorkspaceUri(vscode_uri_1.URI.parse(uri));
          if (!inferredProjects.uriHas(workspaceUri.toString())) {
            inferredProjects.uriSet(workspaceUri.toString(), (() => __async(this, null, function* () {
              const inferOptions = yield (0, inferredCompilerOptions_1.getInferredCompilerOptions)(context.server.configurationHost);
              return (0, project_1.createProject)(__spreadProps(__spreadValues({}, context), {
                project: {
                  workspaceUri,
                  rootUri: workspaceUri,
                  tsConfig: inferOptions
                }
              }));
            }))());
          }
          const project = yield inferredProjects.uriGet(workspaceUri.toString());
          project.tryAddFile(uriToFileName(uri));
          return {
            tsconfig: void 0,
            project
          };
        });
      }
      function getWorkspaceUri(uri) {
        const fileName = uriToFileName(uri.toString());
        let _rootUris = [...rootUris].filter((rootUri) => (0, isFileInDir_1.isFileInDir)(fileName, uriToFileName(rootUri.toString()))).sort((a3, b) => sortTsConfigs(fileName, uriToFileName(a3.toString()), uriToFileName(b.toString())));
        if (!_rootUris.length) {
          _rootUris = [...rootUris];
        }
        if (!_rootUris.length) {
          _rootUris = [uri.with({ path: "/" })];
        }
        return _rootUris[0];
      }
      function findMatchConfigs(uri) {
        return __async(this, null, function* () {
          var _a4, _b2, _c;
          const filePath = uriToFileName(uri.toString());
          let dir = path.dirname(filePath);
          while (true) {
            if (searchedDirs.has(dir)) {
              break;
            }
            searchedDirs.add(dir);
            for (const tsConfigName of exports2.rootTsConfigNames) {
              const tsconfigPath = path.join(dir, tsConfigName);
              if (((_b2 = yield (_a4 = fs.stat) == null ? void 0 : _a4.call(fs, fileNameToUri(tsconfigPath))) == null ? void 0 : _b2.type) === language_service_1.FileType.File) {
                rootTsConfigs.add(tsconfigPath);
              }
            }
            dir = path.dirname(dir);
          }
          yield prepareClosestootParsedCommandLine();
          return (_c = yield findDirectIncludeTsconfig()) != null ? _c : yield findIndirectReferenceTsconfig();
          function prepareClosestootParsedCommandLine() {
            return __async(this, null, function* () {
              let matches2 = [];
              for (const rootTsConfig of rootTsConfigs) {
                if ((0, isFileInDir_1.isFileInDir)(uriToFileName(uri.toString()), path.dirname(rootTsConfig))) {
                  matches2.push(rootTsConfig);
                }
              }
              matches2 = matches2.sort((a3, b) => sortTsConfigs(uriToFileName(uri.toString()), a3, b));
              if (matches2.length) {
                yield getParsedCommandLine(matches2[0]);
              }
            });
          }
          function findIndirectReferenceTsconfig() {
            return findTsconfig((tsconfig) => __async(this, null, function* () {
              var _a5;
              const project = yield configProjects.pathGet(tsconfig);
              return (_a5 = project == null ? void 0 : project.askedFiles.uriHas(uri.toString())) != null ? _a5 : false;
            }));
          }
          function findDirectIncludeTsconfig() {
            return findTsconfig((tsconfig) => __async(this, null, function* () {
              var _a5;
              const map = (0, uriMap_1.createUriMap)(fileNameToUri);
              const parsedCommandLine = yield getParsedCommandLine(tsconfig);
              for (const fileName of (_a5 = parsedCommandLine == null ? void 0 : parsedCommandLine.fileNames) != null ? _a5 : []) {
                map.pathSet(fileName, true);
              }
              return map.uriHas(uri.toString());
            }));
          }
          function findTsconfig(match) {
            return __async(this, null, function* () {
              const checked = /* @__PURE__ */ new Set();
              for (const rootTsConfig of [...rootTsConfigs].sort((a3, b) => sortTsConfigs(uriToFileName(uri.toString()), a3, b))) {
                const project = yield configProjects.pathGet(rootTsConfig);
                if (project) {
                  let chains = yield getReferencesChains(project.getParsedCommandLine(), rootTsConfig, []);
                  if (context.workspaces.initOptions.reverseConfigFilePriority) {
                    chains = chains.reverse();
                  }
                  for (const chain of chains) {
                    for (let i = chain.length - 1; i >= 0; i--) {
                      const tsconfig = chain[i];
                      if (checked.has(tsconfig))
                        continue;
                      checked.add(tsconfig);
                      if (yield match(tsconfig)) {
                        return tsconfig;
                      }
                    }
                  }
                }
              }
            });
          }
          function getReferencesChains(parsedCommandLine, tsConfig, before) {
            return __async(this, null, function* () {
              var _a5, _b3, _c2, _d, _e, _f2, _g;
              if ((_a5 = parsedCommandLine.projectReferences) == null ? void 0 : _a5.length) {
                const newChains = [];
                for (const projectReference of parsedCommandLine.projectReferences) {
                  let tsConfigPath = projectReference.path.replace(/\\/g, "/");
                  if (((_c2 = yield (_b3 = fs.stat) == null ? void 0 : _b3.call(fs, fileNameToUri(tsConfigPath))) == null ? void 0 : _c2.type) === language_service_1.FileType.File) {
                    const newTsConfigPath = path.join(tsConfigPath, "tsconfig.json");
                    const newJsConfigPath = path.join(tsConfigPath, "jsconfig.json");
                    if (((_e = yield (_d = fs.stat) == null ? void 0 : _d.call(fs, fileNameToUri(newTsConfigPath))) == null ? void 0 : _e.type) === language_service_1.FileType.File) {
                      tsConfigPath = newTsConfigPath;
                    } else if (((_g = yield (_f2 = fs.stat) == null ? void 0 : _f2.call(fs, fileNameToUri(newJsConfigPath))) == null ? void 0 : _g.type) === language_service_1.FileType.File) {
                      tsConfigPath = newJsConfigPath;
                    }
                  }
                  const beforeIndex = before.indexOf(tsConfigPath);
                  if (beforeIndex >= 0) {
                    newChains.push(before.slice(0, Math.max(beforeIndex, 1)));
                  } else {
                    const referenceParsedCommandLine = yield getParsedCommandLine(tsConfigPath);
                    if (referenceParsedCommandLine) {
                      for (const chain of yield getReferencesChains(referenceParsedCommandLine, tsConfigPath, [...before, tsConfig])) {
                        newChains.push(chain);
                      }
                    }
                  }
                }
                return newChains;
              } else {
                return [[...before, tsConfig]];
              }
            });
          }
          function getParsedCommandLine(tsConfig) {
            return __async(this, null, function* () {
              const project = yield getProjectByCreate(tsConfig);
              return project == null ? void 0 : project.getParsedCommandLine();
            });
          }
        });
      }
      function getProjectByCreate(_tsConfig) {
        const tsConfig = _tsConfig.replace(/\\/g, "/");
        let project = configProjects.pathGet(tsConfig);
        if (!project) {
          const rootUri = vscode_uri_1.URI.parse(fileNameToUri(path.dirname(tsConfig)));
          project = (0, project_1.createProject)(__spreadProps(__spreadValues({}, context), {
            project: {
              workspaceUri: getWorkspaceUri(rootUri),
              rootUri,
              tsConfig
            }
          }));
          configProjects.pathSet(tsConfig, project);
        }
        return project;
      }
    }
    exports2.createWorkspaces = createWorkspaces;
    function sleep(ms) {
      return new Promise((resolve) => setTimeout(resolve, ms));
    }
    exports2.sleep = sleep;
    function sortTsConfigs(file, a3, b) {
      const inA = (0, isFileInDir_1.isFileInDir)(file, path.dirname(a3));
      const inB = (0, isFileInDir_1.isFileInDir)(file, path.dirname(b));
      if (inA !== inB) {
        const aWeight = inA ? 1 : 0;
        const bWeight = inB ? 1 : 0;
        return bWeight - aWeight;
      }
      const aLength = a3.split("/").length;
      const bLength = b.split("/").length;
      if (aLength === bLength) {
        const aWeight = path.basename(a3) === "tsconfig.json" ? 1 : 0;
        const bWeight = path.basename(b) === "tsconfig.json" ? 1 : 0;
        return bWeight - aWeight;
      }
      return bLength - aLength;
    }
    exports2.sortTsConfigs = sortTsConfigs;
  }
});

// node_modules/@volar/language-server/protocol.js
var require_protocol2 = __commonJS({
  "node_modules/@volar/language-server/protocol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GetVirtualFileRequest = exports2.GetVirtualFilesRequest = exports2.ReloadProjectNotification = exports2.WriteVirtualFilesNotification = exports2.LoadedTSFilesMetaRequest = exports2.AutoInsertRequest = exports2.GetMatchTsConfigRequest = exports2.FindFileReferenceRequest = exports2.FsStatRequest = exports2.FsReadDirectoryRequest = exports2.FsReadFileRequest = void 0;
    var vscode = require_main3();
    var FsReadFileRequest;
    (function(FsReadFileRequest2) {
      FsReadFileRequest2.type = new vscode.RequestType("volar/server/fs/readFile");
    })(FsReadFileRequest || (exports2.FsReadFileRequest = FsReadFileRequest = {}));
    var FsReadDirectoryRequest;
    (function(FsReadDirectoryRequest2) {
      FsReadDirectoryRequest2.type = new vscode.RequestType("volar/server/fs/readDirectory");
    })(FsReadDirectoryRequest || (exports2.FsReadDirectoryRequest = FsReadDirectoryRequest = {}));
    var FsStatRequest;
    (function(FsStatRequest2) {
      FsStatRequest2.type = new vscode.RequestType("volar/server/fs/stat");
    })(FsStatRequest || (exports2.FsStatRequest = FsStatRequest = {}));
    var FindFileReferenceRequest;
    (function(FindFileReferenceRequest2) {
      FindFileReferenceRequest2.type = new vscode.RequestType("volar/client/findFileReference");
    })(FindFileReferenceRequest || (exports2.FindFileReferenceRequest = FindFileReferenceRequest = {}));
    var GetMatchTsConfigRequest;
    (function(GetMatchTsConfigRequest2) {
      GetMatchTsConfigRequest2.type = new vscode.RequestType("volar/client/tsconfig");
    })(GetMatchTsConfigRequest || (exports2.GetMatchTsConfigRequest = GetMatchTsConfigRequest = {}));
    var AutoInsertRequest;
    (function(AutoInsertRequest2) {
      AutoInsertRequest2.type = new vscode.RequestType("volar/client/autoInsert");
    })(AutoInsertRequest || (exports2.AutoInsertRequest = AutoInsertRequest = {}));
    var LoadedTSFilesMetaRequest;
    (function(LoadedTSFilesMetaRequest2) {
      LoadedTSFilesMetaRequest2.type = new vscode.RequestType0("volar/client/loadedTsFiles");
    })(LoadedTSFilesMetaRequest || (exports2.LoadedTSFilesMetaRequest = LoadedTSFilesMetaRequest = {}));
    var WriteVirtualFilesNotification;
    (function(WriteVirtualFilesNotification2) {
      WriteVirtualFilesNotification2.type = new vscode.NotificationType("volar/client/writeVirtualFiles");
    })(WriteVirtualFilesNotification || (exports2.WriteVirtualFilesNotification = WriteVirtualFilesNotification = {}));
    var ReloadProjectNotification;
    (function(ReloadProjectNotification2) {
      ReloadProjectNotification2.type = new vscode.NotificationType("volar/client/reloadProject");
    })(ReloadProjectNotification || (exports2.ReloadProjectNotification = ReloadProjectNotification = {}));
    var GetVirtualFilesRequest;
    (function(GetVirtualFilesRequest2) {
      GetVirtualFilesRequest2.type = new vscode.RequestType("volar/client/virtualFiles");
    })(GetVirtualFilesRequest || (exports2.GetVirtualFilesRequest = GetVirtualFilesRequest = {}));
    var GetVirtualFileRequest;
    (function(GetVirtualFileRequest2) {
      GetVirtualFileRequest2.type = new vscode.RequestType("volar/client/virtualFile");
    })(GetVirtualFileRequest || (exports2.GetVirtualFileRequest = GetVirtualFileRequest = {}));
  }
});

// node_modules/@volar/language-server/lib/common/features/customFeatures.js
var require_customFeatures = __commonJS({
  "node_modules/@volar/language-server/lib/common/features/customFeatures.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.register = void 0;
    var language_core_1 = require_language_core();
    var protocol_1 = require_protocol2();
    function register(connection2, workspaces, env) {
      const scriptVersions = /* @__PURE__ */ new Map();
      const scriptVersionSnapshots = /* @__PURE__ */ new WeakSet();
      connection2.onRequest(protocol_1.GetMatchTsConfigRequest.type, (params) => __async(this, null, function* () {
        const project = yield workspaces.getProject(params.uri);
        if (project == null ? void 0 : project.tsconfig) {
          return { uri: env.fileNameToUri(project.tsconfig) };
        }
      }));
      connection2.onRequest(protocol_1.GetVirtualFilesRequest.type, (document2) => __async(this, null, function* () {
        var _a3, _b, _c;
        const project = yield workspaces.getProject(document2.uri);
        if (project) {
          let prune = function(file2) {
            var _a4;
            let version = (_a4 = scriptVersions.get(file2.fileName)) != null ? _a4 : 0;
            if (!scriptVersionSnapshots.has(file2.snapshot)) {
              version++;
              scriptVersions.set(file2.fileName, version);
              scriptVersionSnapshots.add(file2.snapshot);
            }
            return {
              fileName: file2.fileName,
              kind: file2.kind,
              capabilities: file2.capabilities,
              embeddedFiles: file2.embeddedFiles.map(prune),
              version
            };
          };
          const file = (_c = (_b = (_a3 = project.project) == null ? void 0 : _a3.getLanguageService()) == null ? void 0 : _b.context.virtualFiles.getSource(env.uriToFileName(document2.uri))) == null ? void 0 : _c.root;
          return file ? prune(file) : void 0;
        }
      }));
      connection2.onRequest(protocol_1.GetVirtualFileRequest.type, (params) => __async(this, null, function* () {
        var _a3;
        const project = yield workspaces.getProject(params.sourceFileUri);
        const service = (_a3 = project == null ? void 0 : project.project) == null ? void 0 : _a3.getLanguageService();
        if (service) {
          let content = "";
          let codegenStacks = [];
          const mappings = {};
          for (const [file, map] of service.context.documents.getMapsByVirtualFileName(params.virtualFileName)) {
            content = map.virtualFileDocument.getText();
            codegenStacks = file.codegenStacks;
            mappings[map.sourceFileDocument.uri] = map.map.mappings;
          }
          return {
            content,
            mappings,
            codegenStacks
          };
        }
      }));
      connection2.onNotification(protocol_1.ReloadProjectNotification.type, () => {
        workspaces.reloadProjects();
      });
      connection2.onNotification(protocol_1.WriteVirtualFilesNotification.type, (params) => __async(this, null, function* () {
        var _a3;
        const fsModeName = "fs";
        const fs = yield import(fsModeName);
        const project = yield workspaces.getProject(params.uri);
        if (project) {
          const ls = (_a3 = yield project.project) == null ? void 0 : _a3.getLanguageServiceDontCreate();
          if (ls) {
            const rootPath = ls.context.env.uriToFileName(ls.context.env.rootUri.toString());
            for (const { root } of ls.context.virtualFiles.allSources()) {
              (0, language_core_1.forEachEmbeddedFile)(root, (virtualFile) => {
                if (virtualFile.kind === language_core_1.FileKind.TypeScriptHostFile) {
                  if (virtualFile.fileName.startsWith(rootPath)) {
                    const snapshot = virtualFile.snapshot;
                    fs.writeFile(virtualFile.fileName, snapshot.getText(0, snapshot.getLength()), () => {
                    });
                  }
                }
              });
            }
            for (const fileName of ls.context.host.getScriptFileNames()) {
              if (!fs.existsSync(fileName)) {
                const snapshot = ls.context.host.getScriptSnapshot(fileName);
                if (snapshot) {
                  fs.writeFile(fileName, snapshot.getText(0, snapshot.getLength()), () => {
                  });
                }
              }
            }
          }
        }
      }));
      connection2.onRequest(protocol_1.LoadedTSFilesMetaRequest.type, () => __async(this, null, function* () {
        var _a3, _b, _c;
        const sourceFilesData = /* @__PURE__ */ new Map();
        for (const _project of [...workspaces.configProjects.values(), ...workspaces.inferredProjects.values()]) {
          const project = yield _project;
          const service = project.getLanguageServiceDontCreate();
          const languageService = service == null ? void 0 : service.context.inject("typescript/languageService");
          const program = languageService == null ? void 0 : languageService.getProgram();
          if (program) {
            const projectName = typeof project.tsConfig === "string" ? project.tsConfig : project.languageHost.workspacePath + "(inferred)";
            const sourceFiles = (_a3 = program == null ? void 0 : program.getSourceFiles()) != null ? _a3 : [];
            for (const sourceFile of sourceFiles) {
              if (!sourceFilesData.has(sourceFile)) {
                let nodes = 0;
                sourceFile.forEachChild(function walk(node) {
                  nodes++;
                  node.forEachChild(walk);
                });
                sourceFilesData.set(sourceFile, {
                  projectNames: [],
                  size: nodes * 128
                });
              }
              sourceFilesData.get(sourceFile).projectNames.push(projectName);
            }
            ;
          }
        }
        const result = {
          inputs: {},
          outputs: {}
        };
        for (const [sourceFile, fileData] of sourceFilesData) {
          let key = fileData.projectNames.sort().join(", ");
          if (fileData.projectNames.length >= 2) {
            key = `Shared in ${fileData.projectNames.length} projects (${key})`;
          }
          (_c = (_b = result.outputs)[key]) != null ? _c : _b[key] = {
            imports: [],
            exports: [],
            entryPoint: "",
            inputs: {},
            bytes: 0
          };
          result.outputs[key].inputs[sourceFile.fileName] = { bytesInOutput: fileData.size };
        }
        return result;
      }));
    }
    exports2.register = register;
  }
});

// node_modules/@volar/language-server/lib/common/features/languageFeatures.js
var require_languageFeatures = __commonJS({
  "node_modules/@volar/language-server/lib/common/features/languageFeatures.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.sleep = exports2.register = void 0;
    var embedded = require_language_service();
    var vscode = require_main4();
    var protocol_1 = require_protocol2();
    var types_1 = require_types4();
    function register(connection2, workspaces, initParams, initOptions, semanticTokensLegend, runtime, documents) {
      let lastCompleteUri;
      let lastCompleteLs;
      let lastCodeLensLs;
      let lastCodeActionLs;
      let lastCallHierarchyLs;
      let lastDocumentLinkLs;
      let lastInlayHintLs;
      connection2.onDocumentFormatting((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.format(params.textDocument.uri, params.options, void 0, void 0, token);
        });
      }));
      connection2.onDocumentRangeFormatting((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.format(params.textDocument.uri, params.options, params.range, void 0, token);
        });
      }));
      connection2.onDocumentOnTypeFormatting((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.format(params.textDocument.uri, params.options, void 0, params, token);
        });
      }));
      connection2.onSelectionRanges((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.getSelectionRanges(params.textDocument.uri, params.positions, token);
        });
      }));
      connection2.onFoldingRanges((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.getFoldingRanges(params.textDocument.uri, token);
        });
      }));
      connection2.languages.onLinkedEditingRange((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findLinkedEditingRanges(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onDocumentSymbol((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findDocumentSymbols(params.textDocument.uri, token);
        });
      }));
      connection2.onDocumentColor((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findDocumentColors(params.textDocument.uri, token);
        });
      }));
      connection2.onColorPresentation((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.getColorPresentations(params.textDocument.uri, params.color, params.range, token);
        });
      }));
      connection2.onCompletion((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          var _a3;
          lastCompleteUri = params.textDocument.uri;
          lastCompleteLs = service;
          const document2 = (_a3 = documents.data.uriGet(params.textDocument.uri)) == null ? void 0 : _a3.getDocument();
          const list = yield service.doComplete(params.textDocument.uri, params.position, params.context, token);
          for (const item of list.items) {
            fixTextEdit(item);
          }
          if (!initOptions.fullCompletionList && document2) {
            list.items = list.items.filter((item) => {
              var _a4, _b;
              const range = item.textEdit ? vscode.InsertReplaceEdit.is(item.textEdit) ? item.textEdit.replace : item.textEdit.range : ((_a4 = list.itemDefaults) == null ? void 0 : _a4.editRange) ? vscode.Range.is(list.itemDefaults.editRange) ? list.itemDefaults.editRange : list.itemDefaults.editRange.replace : void 0;
              if (range) {
                const sourceText = document2.getText(range).toLowerCase();
                if (sourceText.trim()) {
                  let filterText = ((_b = item.filterText) != null ? _b : item.label).toLowerCase();
                  for (const char of sourceText) {
                    const index = filterText.indexOf(char);
                    if (index === -1) {
                      return false;
                    }
                    filterText = filterText.slice(index + 1);
                  }
                }
              }
              return true;
            });
          }
          return list;
        }));
      }));
      connection2.onCompletionResolve((item, token) => __async(this, null, function* () {
        if (lastCompleteUri && lastCompleteLs) {
          item = yield lastCompleteLs.doCompletionResolve(item, token);
          fixTextEdit(item);
        }
        return item;
      }));
      connection2.onHover((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.doHover(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onSignatureHelp((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.getSignatureHelp(params.textDocument.uri, params.position, params.context, token);
        });
      }));
      connection2.onPrepareRename((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          const result = yield service.prepareRename(params.textDocument.uri, params.position, token);
          if (result && "message" in result) {
            return new vscode.ResponseError(0, result.message);
          }
          return result;
        }));
      }));
      connection2.onRenameRequest((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.doRename(params.textDocument.uri, params.position, params.newName, token);
        });
      }));
      connection2.onCodeLens((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          lastCodeLensLs = service;
          return service.doCodeLens(params.textDocument.uri, token);
        }));
      }));
      connection2.onCodeLensResolve((codeLens, token) => __async(this, null, function* () {
        var _a3;
        return (_a3 = yield lastCodeLensLs == null ? void 0 : lastCodeLensLs.doCodeLensResolve(codeLens, token)) != null ? _a3 : codeLens;
      }));
      connection2.onCodeAction((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          var _a3, _b, _c;
          lastCodeActionLs = service;
          let codeActions = (_a3 = yield service.doCodeActions(params.textDocument.uri, params.range, params.context, token)) != null ? _a3 : [];
          for (const codeAction of codeActions) {
            if (codeAction.data && typeof codeAction.data === "object") {
              codeAction.data.uri = params.textDocument.uri;
            } else {
              codeAction.data = { uri: params.textDocument.uri };
            }
          }
          if (!((_c = (_b = initParams.capabilities.textDocument) == null ? void 0 : _b.codeAction) == null ? void 0 : _c.disabledSupport)) {
            codeActions = codeActions.filter((codeAction) => !codeAction.disabled);
          }
          return codeActions;
        }));
      }));
      connection2.onCodeActionResolve((codeAction, token) => __async(this, null, function* () {
        var _a3;
        return (_a3 = yield lastCodeActionLs.doCodeActionResolve(codeAction, token)) != null ? _a3 : codeAction;
      }));
      connection2.onReferences((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findReferences(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onRequest(protocol_1.FindFileReferenceRequest.type, (params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findFileReferences(params.textDocument.uri, token);
        });
      }));
      connection2.onImplementation((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findImplementations(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onDefinition((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findDefinition(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onTypeDefinition((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findTypeDefinition(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onDocumentHighlight((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.findDocumentHighlights(params.textDocument.uri, params.position, token);
        });
      }));
      connection2.onDocumentLinks((params, token) => __async(this, null, function* () {
        return yield worker(params.textDocument.uri, token, (service) => {
          lastDocumentLinkLs = service;
          return service.findDocumentLinks(params.textDocument.uri, token);
        });
      }));
      connection2.onDocumentLinkResolve((link, token) => __async(this, null, function* () {
        return yield lastDocumentLinkLs.doDocumentLinkResolve(link, token);
      }));
      connection2.onWorkspaceSymbol((params, token) => __async(this, null, function* () {
        let results = [];
        let projects = [...workspaces.configProjects.values()];
        if (!projects.length) {
          projects = [...workspaces.inferredProjects.values()];
        }
        for (const project of projects) {
          if (token.isCancellationRequested)
            return;
          const service = (yield project).getLanguageService();
          results = results.concat(yield service.findWorkspaceSymbols(params.query, token));
        }
        return results;
      }));
      connection2.languages.callHierarchy.onPrepare((params, token) => __async(this, null, function* () {
        var _a3;
        return (_a3 = yield worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          lastCallHierarchyLs = service;
          return service.callHierarchy.doPrepare(params.textDocument.uri, params.position, token);
        }))) != null ? _a3 : [];
      }));
      connection2.languages.callHierarchy.onIncomingCalls((params, token) => __async(this, null, function* () {
        var _a3;
        return (_a3 = yield lastCallHierarchyLs == null ? void 0 : lastCallHierarchyLs.callHierarchy.getIncomingCalls(params.item, token)) != null ? _a3 : [];
      }));
      connection2.languages.callHierarchy.onOutgoingCalls((params, token) => __async(this, null, function* () {
        var _a3;
        return (_a3 = yield lastCallHierarchyLs == null ? void 0 : lastCallHierarchyLs.callHierarchy.getOutgoingCalls(params.item, token)) != null ? _a3 : [];
      }));
      connection2.languages.semanticTokens.on((params, token, _, resultProgress) => __async(this, null, function* () {
        var _a3;
        yield sleep(200);
        return (_a3 = yield worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          return yield service == null ? void 0 : service.getSemanticTokens(params.textDocument.uri, void 0, semanticTokensLegend, token, (tokens) => resultProgress == null ? void 0 : resultProgress.report(tokens));
        }))) != null ? _a3 : { data: [] };
      }));
      connection2.languages.semanticTokens.onRange((params, token, _, resultProgress) => __async(this, null, function* () {
        var _a3;
        yield sleep(200);
        return (_a3 = yield worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          return yield service == null ? void 0 : service.getSemanticTokens(params.textDocument.uri, params.range, semanticTokensLegend, token, (tokens) => resultProgress == null ? void 0 : resultProgress.report(tokens));
        }))) != null ? _a3 : { data: [] };
      }));
      connection2.languages.diagnostics.on((params, token, _workDoneProgressReporter, resultProgressReporter) => __async(this, null, function* () {
        const result = yield worker(params.textDocument.uri, token, (service) => {
          const tsToken = runtime.getCancellationToken(token);
          const mode = initOptions.serverMode === types_1.ServerMode.PartialSemantic ? "semantic" : initOptions.serverMode === types_1.ServerMode.Syntactic ? "syntactic" : "all";
          return service.doValidation(params.textDocument.uri, mode, tsToken, (errors) => {
            resultProgressReporter == null ? void 0 : resultProgressReporter.report({
              relatedDocuments: {
                [params.textDocument.uri]: {
                  kind: vscode.DocumentDiagnosticReportKind.Full,
                  items: errors
                }
              }
            });
          });
        });
        return {
          kind: vscode.DocumentDiagnosticReportKind.Full,
          items: result != null ? result : []
        };
      }));
      connection2.languages.inlayHint.on((params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => __async(this, null, function* () {
          lastInlayHintLs = service;
          return service.getInlayHints(params.textDocument.uri, params.range, token);
        }));
      }));
      connection2.languages.inlayHint.resolve((hint, token) => __async(this, null, function* () {
        return yield lastInlayHintLs.doInlayHintResolve(hint, token);
      }));
      connection2.workspace.onWillRenameFiles((params, token) => __async(this, null, function* () {
        const _edits = yield Promise.all(params.files.map((file) => __async(this, null, function* () {
          var _a3;
          return (_a3 = yield worker(file.oldUri, token, (service) => {
            var _a4;
            return (_a4 = service.getEditsForFileRename(file.oldUri, file.newUri, token)) != null ? _a4 : null;
          })) != null ? _a3 : null;
        })));
        const edits = _edits.filter((edit) => !!edit);
        if (edits.length) {
          embedded.mergeWorkspaceEdits(edits[0], ...edits.slice(1));
          return edits[0];
        }
        return null;
      }));
      connection2.onRequest(protocol_1.AutoInsertRequest.type, (params, token) => __async(this, null, function* () {
        return worker(params.textDocument.uri, token, (service) => {
          return service.doAutoInsert(params.textDocument.uri, params.position, params.options, token);
        });
      }));
      function worker(uri, token, cb) {
        return new Promise((resolve) => {
          runtime.timer.setImmediate(() => __async(this, null, function* () {
            if (token.isCancellationRequested) {
              resolve(void 0);
              return;
            }
            const project = yield getProject(uri);
            if (project) {
              const service = project.getLanguageService();
              try {
                const result = yield cb(service);
                if (token.isCancellationRequested) {
                  resolve(void 0);
                  return;
                }
                resolve(result);
              } catch (e) {
                resolve(void 0);
                return;
              }
            } else {
              resolve(void 0);
            }
          }));
        });
      }
      function getProject(uri) {
        return __async(this, null, function* () {
          var _a3;
          return (_a3 = yield workspaces.getProject(uri)) == null ? void 0 : _a3.project;
        });
      }
      function fixTextEdit(item) {
        var _a3, _b, _c, _d;
        const insertReplaceSupport = (_d = (_c = (_b = (_a3 = initParams.capabilities.textDocument) == null ? void 0 : _a3.completion) == null ? void 0 : _b.completionItem) == null ? void 0 : _c.insertReplaceSupport) != null ? _d : false;
        if (!insertReplaceSupport) {
          if (item.textEdit && vscode.InsertReplaceEdit.is(item.textEdit)) {
            item.textEdit = vscode.TextEdit.replace(item.textEdit.insert, item.textEdit.newText);
          }
        }
      }
    }
    exports2.register = register;
    function sleep(ms) {
      return new Promise((resolve) => setTimeout(resolve, ms));
    }
    exports2.sleep = sleep;
  }
});

// node_modules/@volar/language-server/lib/common/server.js
var require_server2 = __commonJS({
  "node_modules/@volar/language-server/lib/common/server.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.startCommonLanguageServer = void 0;
    var index_js_1 = require_language_service();
    var l10n21 = require_main7();
    var vscode = require_main4();
    var vscode_uri_1 = require_umd();
    var types_js_1 = require_types4();
    var configurationHost_js_1 = require_configurationHost();
    var documents_js_1 = require_documents2();
    var registerFeatures_js_1 = require_registerFeatures();
    var serverConfig_js_1 = require_serverConfig();
    var workspaces_js_1 = require_workspaces();
    var request_light_1 = require_main5();
    function startCommonLanguageServer(connection2, _plugins, getRuntimeEnv) {
      let initParams;
      let options;
      let roots = [];
      let workspaces;
      let plugins;
      let documents;
      let context;
      let ts;
      let tsLocalized;
      const didChangeWatchedFilesCallbacks = /* @__PURE__ */ new Set();
      connection2.onInitialize((_params) => __async(this, null, function* () {
        var _a3, _b, _c;
        initParams = _params;
        options = initParams.initializationOptions;
        const env = getRuntimeEnv(initParams, options);
        context = {
          server: {
            initializeParams: initParams,
            connection: connection2,
            runtimeEnv: __spreadProps(__spreadValues({}, env), {
              fs: createFsWithCache(env.fs)
            }),
            plugins: _plugins,
            configurationHost: ((_a3 = initParams.capabilities.workspace) == null ? void 0 : _a3.configuration) ? (0, configurationHost_js_1.createConfigurationHost)(initParams, connection2) : void 0,
            onDidChangeWatchedFiles: (cb) => {
              didChangeWatchedFilesCallbacks.add(cb);
              return {
                dispose: () => {
                  didChangeWatchedFilesCallbacks.delete(cb);
                }
              };
            }
          }
        };
        ts = yield context.server.runtimeEnv.loadTypeScript(options);
        tsLocalized = initParams.locale ? yield context.server.runtimeEnv.loadTypeScriptLocalized(options, initParams.locale) : void 0;
        plugins = context.server.plugins.map((plugin) => plugin(options, { typescript: ts }));
        documents = (0, documents_js_1.createDocuments)(context.server.runtimeEnv, connection2);
        if (options.l10n) {
          yield l10n21.config({ uri: options.l10n.location });
        }
        if (((_b = initParams.capabilities.workspace) == null ? void 0 : _b.workspaceFolders) && initParams.workspaceFolders) {
          roots = initParams.workspaceFolders.map((folder) => vscode_uri_1.URI.parse(folder.uri));
        } else if (initParams.rootUri) {
          roots = [vscode_uri_1.URI.parse(initParams.rootUri)];
        } else if (initParams.rootPath) {
          roots = [vscode_uri_1.URI.file(initParams.rootPath)];
        }
        const result = {
          capabilities: {
            textDocumentSync: vscode.TextDocumentSyncKind.Incremental,
            workspace: {
              // #18
              workspaceFolders: {
                supported: true,
                changeNotifications: true
              }
            }
          }
        };
        let config = {};
        for (const root of roots) {
          if (root.scheme === "file") {
            const workspaceConfig = (0, serverConfig_js_1.loadConfig)(env.console, root.path, options.configFilePath);
            if (workspaceConfig) {
              config = workspaceConfig;
              break;
            }
          }
        }
        for (const plugin of plugins) {
          if (plugin.resolveConfig) {
            config = yield plugin.resolveConfig(config, void 0);
          }
        }
        (0, registerFeatures_js_1.setupCapabilities)(result.capabilities, options, plugins, getSemanticTokensLegend(), (_c = config.services) != null ? _c : {});
        yield createLanguageServiceHost();
        try {
          const packageJson = require("../package.json");
          result.serverInfo = {
            name: packageJson.name,
            version: packageJson.version
          };
        } catch (e) {
        }
        return result;
      }));
      connection2.onInitialized(() => __async(this, null, function* () {
        var _a3, _b, _c, _d, _e, _f2;
        (_a3 = context.server.configurationHost) == null ? void 0 : _a3.ready();
        (_c = (_b = context.server.configurationHost) == null ? void 0 : _b.onDidChangeConfiguration) == null ? void 0 : _c.call(_b, updateHttpSettings);
        updateHttpSettings();
        if ((_d = initParams.capabilities.workspace) == null ? void 0 : _d.workspaceFolders) {
          connection2.workspace.onDidChangeWorkspaceFolders((e) => {
            for (const folder of e.added) {
              workspaces == null ? void 0 : workspaces.add(vscode_uri_1.URI.parse(folder.uri));
            }
            for (const folder of e.removed) {
              workspaces == null ? void 0 : workspaces.remove(vscode_uri_1.URI.parse(folder.uri));
            }
          });
        }
        if (options.serverMode !== types_js_1.ServerMode.Syntactic && ((_f2 = (_e = initParams.capabilities.workspace) == null ? void 0 : _e.didChangeWatchedFiles) == null ? void 0 : _f2.dynamicRegistration)) {
          const exts = plugins.map((plugin) => plugin.watchFileExtensions).flat();
          if (exts.length) {
            connection2.client.register(vscode.DidChangeWatchedFilesNotification.type, {
              watchers: [
                {
                  globPattern: `**/*.{${exts.join(",")}}`
                }
              ]
            });
            connection2.onDidChangeWatchedFiles((e) => {
              for (const cb of didChangeWatchedFilesCallbacks) {
                cb(e);
              }
            });
          }
        }
        function updateHttpSettings() {
          return __async(this, null, function* () {
            var _a4, _b2, _c2;
            const httpSettings = yield (_b2 = (_a4 = context.server.configurationHost) == null ? void 0 : _a4.getConfiguration) == null ? void 0 : _b2.call(_a4, "http");
            (0, request_light_1.configure)(httpSettings == null ? void 0 : httpSettings.proxy, (_c2 = httpSettings == null ? void 0 : httpSettings.proxyStrictSSL) != null ? _c2 : false);
          });
        }
      }));
      connection2.onShutdown(() => __async(this, null, function* () {
        workspaces == null ? void 0 : workspaces.reloadProjects();
      }));
      connection2.listen();
      function createFsWithCache(fs) {
        const readFileCache = /* @__PURE__ */ new Map();
        const statCache = /* @__PURE__ */ new Map();
        const readDirectoryCache = /* @__PURE__ */ new Map();
        didChangeWatchedFilesCallbacks.add(({ changes }) => {
          for (const change of changes) {
            if (change.type === vscode.FileChangeType.Deleted) {
              readFileCache.set(change.uri, void 0);
              statCache.set(change.uri, void 0);
              const dir = change.uri.substring(0, change.uri.lastIndexOf("/"));
              readDirectoryCache.delete(dir);
            } else if (change.type === vscode.FileChangeType.Changed) {
              readFileCache.delete(change.uri);
              statCache.delete(change.uri);
            } else if (change.type === vscode.FileChangeType.Created) {
              readFileCache.delete(change.uri);
              statCache.delete(change.uri);
              const dir = change.uri.substring(0, change.uri.lastIndexOf("/"));
              readDirectoryCache.delete(dir);
            }
          }
        });
        return {
          readFile: (uri) => {
            if (!readFileCache.has(uri)) {
              readFileCache.set(uri, fs.readFile(uri));
            }
            return readFileCache.get(uri);
          },
          stat: (uri) => {
            if (!statCache.has(uri)) {
              statCache.set(uri, fs.stat(uri));
            }
            return statCache.get(uri);
          },
          readDirectory: (uri) => {
            if (!readDirectoryCache.has(uri)) {
              readDirectoryCache.set(uri, fs.readDirectory(uri));
            }
            return readDirectoryCache.get(uri);
          }
        };
      }
      function createLanguageServiceHost() {
        return __async(this, null, function* () {
          var _a3;
          workspaces = (0, workspaces_js_1.createWorkspaces)(__spreadProps(__spreadValues({}, context), {
            workspaces: {
              ts,
              tsLocalized,
              initParams,
              initOptions: options,
              documents,
              plugins
            }
          }), roots);
          (yield Promise.resolve().then(() => __toESM(require_customFeatures()))).register(connection2, workspaces, context.server.runtimeEnv);
          (yield Promise.resolve().then(() => __toESM(require_languageFeatures()))).register(connection2, workspaces, initParams, options, getSemanticTokensLegend(), context.server.runtimeEnv, documents);
          for (const plugin of plugins) {
            (_a3 = plugin.onInitialized) == null ? void 0 : _a3.call(plugin, getLanguageService3, context.server.runtimeEnv);
          }
          function getLanguageService3(uri) {
            return __async(this, null, function* () {
              var _a4;
              const project = (_a4 = yield workspaces.getProject(uri)) == null ? void 0 : _a4.project;
              return project == null ? void 0 : project.getLanguageService();
            });
          }
        });
      }
      function getSemanticTokensLegend() {
        if (!options.semanticTokensLegend) {
          return index_js_1.standardSemanticTokensLegend;
        }
        return {
          tokenTypes: [...index_js_1.standardSemanticTokensLegend.tokenTypes, ...options.semanticTokensLegend.tokenTypes],
          tokenModifiers: [...index_js_1.standardSemanticTokensLegend.tokenModifiers, ...options.semanticTokensLegend.tokenModifiers]
        };
      }
    }
    exports2.startCommonLanguageServer = startCommonLanguageServer;
  }
});

// node_modules/@volar/language-server/lib/node/cancellationPipe.js
var require_cancellationPipe = __commonJS({
  "node_modules/@volar/language-server/lib/node/cancellationPipe.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createGetCancellationToken = void 0;
    var vscode = require_main4();
    function createGetCancellationToken(_cancellationPipeName) {
      if (_cancellationPipeName === void 0) {
        return (original) => {
          return original != null ? original : vscode.CancellationToken.None;
        };
      }
      const cancellationPipeName = _cancellationPipeName;
      const fs = require("fs");
      return getCancellationToken;
      function getCancellationToken(original) {
        const mtime = getMtime();
        let currentMtime = mtime;
        let updateAt = Date.now();
        const token = {
          get isCancellationRequested() {
            if (original == null ? void 0 : original.isCancellationRequested) {
              return true;
            }
            if (currentMtime === mtime && Date.now() - updateAt >= 20) {
              currentMtime = getMtime();
              updateAt = Date.now();
            }
            return currentMtime !== mtime;
          },
          onCancellationRequested: vscode.Event.None
        };
        return token;
      }
      function getMtime() {
        var _a3;
        try {
          const stat = fs.statSync(cancellationPipeName, { throwIfNoEntry: false });
          return (_a3 = stat == null ? void 0 : stat.mtime.valueOf()) != null ? _a3 : -1;
        } catch (e) {
          return -1;
        }
      }
    }
    exports2.createGetCancellationToken = createGetCancellationToken;
  }
});

// node_modules/@volar/language-server/index.js
var require_language_server = __commonJS({
  "node_modules/@volar/language-server/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    __exportStar(require_protocol2(), exports2);
    __exportStar(require_types4(), exports2);
    __exportStar(require_main4(), exports2);
    __exportStar(require_types2(), exports2);
    __exportStar(require_types3(), exports2);
  }
});

// node_modules/@volar/language-server/node.js
var require_node4 = __commonJS({
  "node_modules/@volar/language-server/node.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.startLanguageServer = exports2.createConnection = exports2.createFs = exports2.fileNameToUri = exports2.uriToFileName = void 0;
    var fs = require("fs");
    var vscode = require_node3();
    var vscode_uri_1 = require_umd();
    var http_1 = require_http();
    var server_1 = require_server2();
    var language_service_1 = require_language_service();
    var cancellationPipe_1 = require_cancellationPipe();
    __exportStar(require_language_server(), exports2);
    var uriToFileName = (uri) => vscode_uri_1.URI.parse(uri).fsPath.replace(/\\/g, "/");
    exports2.uriToFileName = uriToFileName;
    var fileNameToUri = (fileName) => vscode_uri_1.URI.file(fileName).toString();
    exports2.fileNameToUri = fileNameToUri;
    function createFs(options) {
      return {
        stat(uri) {
          if (uri.startsWith("file://")) {
            try {
              const stats = fs.statSync((0, exports2.uriToFileName)(uri), { throwIfNoEntry: false });
              if (stats) {
                return {
                  type: stats.isFile() ? language_service_1.FileType.File : stats.isDirectory() ? language_service_1.FileType.Directory : stats.isSymbolicLink() ? language_service_1.FileType.SymbolicLink : language_service_1.FileType.Unknown,
                  ctime: stats.ctimeMs,
                  mtime: stats.mtimeMs,
                  size: stats.size
                };
              }
            } catch (e) {
              return void 0;
            }
          }
        },
        readFile(uri, encoding) {
          if (uri.startsWith("file://")) {
            try {
              if (options.maxFileSize) {
                const stats = fs.statSync((0, exports2.uriToFileName)(uri), { throwIfNoEntry: false });
                if (stats && stats.size > options.maxFileSize) {
                  console.warn(`[volar] file size exceeded limit: ${uri} (${stats.size} > ${options.maxFileSize})`);
                  return void 0;
                }
              }
              return fs.readFileSync((0, exports2.uriToFileName)(uri), { encoding: encoding != null ? encoding : "utf-8" });
            } catch (e) {
              return void 0;
            }
          }
          if (uri.startsWith("http://") || uri.startsWith("https://")) {
            return (0, http_1.default)(uri);
          }
        },
        readDirectory(uri) {
          if (uri.startsWith("file://")) {
            try {
              const dirName = (0, exports2.uriToFileName)(uri);
              const files = fs.readdirSync(dirName, { withFileTypes: true });
              return files.map((file) => {
                return [file.name, file.isFile() ? language_service_1.FileType.File : file.isDirectory() ? language_service_1.FileType.Directory : file.isSymbolicLink() ? language_service_1.FileType.SymbolicLink : language_service_1.FileType.Unknown];
              });
            } catch (e) {
              return [];
            }
          }
          return [];
        }
      };
    }
    exports2.createFs = createFs;
    function createConnection2() {
      return vscode.createConnection(vscode.ProposedFeatures.all);
    }
    exports2.createConnection = createConnection2;
    function startLanguageServer2(connection2, ...plugins) {
      (0, server_1.startCommonLanguageServer)(connection2, plugins, (_, options) => ({
        uriToFileName: exports2.uriToFileName,
        fileNameToUri: exports2.fileNameToUri,
        console: connection2.console,
        timer: {
          setImmediate(callback, ...args) {
            const handle = setImmediate(callback, ...args);
            return { dispose: () => clearImmediate(handle) };
          }
        },
        loadTypeScript(options2) {
          const tsdk = options2.typescript && "tsdk" in options2.typescript ? options2.typescript.tsdk : void 0;
          if (!tsdk) {
            return;
          }
          for (const name of ["./typescript.js", "./tsserverlibrary.js"]) {
            try {
              return require(require.resolve(name, { paths: [tsdk] }));
            } catch (e) {
            }
          }
          for (const name of ["typescript.js", "tsserverlibrary.js"]) {
            try {
              return require(tsdk + "/" + name);
            } catch (e) {
            }
          }
          throw new Error(`Can't find typescript.js or tsserverlibrary.js in ${tsdk}`);
        },
        loadTypeScriptLocalized(options2, locale) {
          return __async(this, null, function* () {
            const tsdk = options2.typescript && "tsdk" in options2.typescript ? options2.typescript.tsdk : void 0;
            if (!tsdk) {
              return;
            }
            try {
              const path = require.resolve(`./${locale}/diagnosticMessages.generated.json`, { paths: [tsdk] });
              return require(path);
            } catch (e) {
            }
          });
        },
        fs: createFs(options),
        getCancellationToken: (0, cancellationPipe_1.createGetCancellationToken)(options.cancellationPipeName)
      }));
    }
    exports2.startLanguageServer = startLanguageServer2;
  }
});

// node_modules/@vue/shared/dist/shared.cjs.prod.js
var require_shared_cjs_prod = __commonJS({
  "node_modules/@vue/shared/dist/shared.cjs.prod.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    function makeMap(str, expectsLowerCase) {
      const set = new Set(str.split(","));
      return expectsLowerCase ? (val) => set.has(val.toLowerCase()) : (val) => set.has(val);
    }
    var EMPTY_OBJ = {};
    var EMPTY_ARR = [];
    var NOOP = () => {
    };
    var NO = () => false;
    var isOn = (key) => key.charCodeAt(0) === 111 && key.charCodeAt(1) === 110 && // uppercase letter
    (key.charCodeAt(2) > 122 || key.charCodeAt(2) < 97);
    var isModelListener = (key) => key.startsWith("onUpdate:");
    var extend = Object.assign;
    var remove = (arr, el) => {
      const i = arr.indexOf(el);
      if (i > -1) {
        arr.splice(i, 1);
      }
    };
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var hasOwn = (val, key) => hasOwnProperty.call(val, key);
    var isArray = Array.isArray;
    var isMap = (val) => toTypeString(val) === "[object Map]";
    var isSet = (val) => toTypeString(val) === "[object Set]";
    var isDate = (val) => toTypeString(val) === "[object Date]";
    var isRegExp = (val) => toTypeString(val) === "[object RegExp]";
    var isFunction = (val) => typeof val === "function";
    var isString2 = (val) => typeof val === "string";
    var isSymbol = (val) => typeof val === "symbol";
    var isObject2 = (val) => val !== null && typeof val === "object";
    var isPromise = (val) => {
      return (isObject2(val) || isFunction(val)) && isFunction(val.then) && isFunction(val.catch);
    };
    var objectToString = Object.prototype.toString;
    var toTypeString = (value) => objectToString.call(value);
    var toRawType = (value) => {
      return toTypeString(value).slice(8, -1);
    };
    var isPlainObject = (val) => toTypeString(val) === "[object Object]";
    var isIntegerKey = (key) => isString2(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
    var isReservedProp = /* @__PURE__ */ makeMap(
      // the leading comma is intentional so empty string "" is also included
      ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
    );
    var isBuiltInDirective = /* @__PURE__ */ makeMap(
      "bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"
    );
    var cacheStringFunction = (fn) => {
      const cache = /* @__PURE__ */ Object.create(null);
      return (str) => {
        const hit = cache[str];
        return hit || (cache[str] = fn(str));
      };
    };
    var camelizeRE = /-(\w)/g;
    var camelize = cacheStringFunction((str) => {
      return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : "");
    });
    var hyphenateRE = /\B([A-Z])/g;
    var hyphenate = cacheStringFunction(
      (str) => str.replace(hyphenateRE, "-$1").toLowerCase()
    );
    var capitalize = cacheStringFunction((str) => {
      return str.charAt(0).toUpperCase() + str.slice(1);
    });
    var toHandlerKey = cacheStringFunction((str) => {
      const s = str ? `on${capitalize(str)}` : ``;
      return s;
    });
    var hasChanged = (value, oldValue) => !Object.is(value, oldValue);
    var invokeArrayFns = (fns, arg) => {
      for (let i = 0; i < fns.length; i++) {
        fns[i](arg);
      }
    };
    var def = (obj, key, value) => {
      Object.defineProperty(obj, key, {
        configurable: true,
        enumerable: false,
        value
      });
    };
    var looseToNumber = (val) => {
      const n = parseFloat(val);
      return isNaN(n) ? val : n;
    };
    var toNumber = (val) => {
      const n = isString2(val) ? Number(val) : NaN;
      return isNaN(n) ? val : n;
    };
    var _globalThis;
    var getGlobalThis = () => {
      return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
    };
    var identRE = /^[_$a-zA-Z\xA0-\uFFFF][_$a-zA-Z0-9\xA0-\uFFFF]*$/;
    function genPropsAccessExp(name) {
      return identRE.test(name) ? `__props.${name}` : `__props[${JSON.stringify(name)}]`;
    }
    var PatchFlags = {
      "TEXT": 1,
      "1": "TEXT",
      "CLASS": 2,
      "2": "CLASS",
      "STYLE": 4,
      "4": "STYLE",
      "PROPS": 8,
      "8": "PROPS",
      "FULL_PROPS": 16,
      "16": "FULL_PROPS",
      "NEED_HYDRATION": 32,
      "32": "NEED_HYDRATION",
      "STABLE_FRAGMENT": 64,
      "64": "STABLE_FRAGMENT",
      "KEYED_FRAGMENT": 128,
      "128": "KEYED_FRAGMENT",
      "UNKEYED_FRAGMENT": 256,
      "256": "UNKEYED_FRAGMENT",
      "NEED_PATCH": 512,
      "512": "NEED_PATCH",
      "DYNAMIC_SLOTS": 1024,
      "1024": "DYNAMIC_SLOTS",
      "DEV_ROOT_FRAGMENT": 2048,
      "2048": "DEV_ROOT_FRAGMENT",
      "HOISTED": -1,
      "-1": "HOISTED",
      "BAIL": -2,
      "-2": "BAIL"
    };
    var PatchFlagNames = {
      [1]: `TEXT`,
      [2]: `CLASS`,
      [4]: `STYLE`,
      [8]: `PROPS`,
      [16]: `FULL_PROPS`,
      [32]: `NEED_HYDRATION`,
      [64]: `STABLE_FRAGMENT`,
      [128]: `KEYED_FRAGMENT`,
      [256]: `UNKEYED_FRAGMENT`,
      [512]: `NEED_PATCH`,
      [1024]: `DYNAMIC_SLOTS`,
      [2048]: `DEV_ROOT_FRAGMENT`,
      [-1]: `HOISTED`,
      [-2]: `BAIL`
    };
    var ShapeFlags = {
      "ELEMENT": 1,
      "1": "ELEMENT",
      "FUNCTIONAL_COMPONENT": 2,
      "2": "FUNCTIONAL_COMPONENT",
      "STATEFUL_COMPONENT": 4,
      "4": "STATEFUL_COMPONENT",
      "TEXT_CHILDREN": 8,
      "8": "TEXT_CHILDREN",
      "ARRAY_CHILDREN": 16,
      "16": "ARRAY_CHILDREN",
      "SLOTS_CHILDREN": 32,
      "32": "SLOTS_CHILDREN",
      "TELEPORT": 64,
      "64": "TELEPORT",
      "SUSPENSE": 128,
      "128": "SUSPENSE",
      "COMPONENT_SHOULD_KEEP_ALIVE": 256,
      "256": "COMPONENT_SHOULD_KEEP_ALIVE",
      "COMPONENT_KEPT_ALIVE": 512,
      "512": "COMPONENT_KEPT_ALIVE",
      "COMPONENT": 6,
      "6": "COMPONENT"
    };
    var SlotFlags = {
      "STABLE": 1,
      "1": "STABLE",
      "DYNAMIC": 2,
      "2": "DYNAMIC",
      "FORWARDED": 3,
      "3": "FORWARDED"
    };
    var slotFlagsText = {
      [1]: "STABLE",
      [2]: "DYNAMIC",
      [3]: "FORWARDED"
    };
    var GLOBALS_ALLOWED = "Infinity,undefined,NaN,isFinite,isNaN,parseFloat,parseInt,decodeURI,decodeURIComponent,encodeURI,encodeURIComponent,Math,Number,Date,Array,Object,Boolean,String,RegExp,Map,Set,JSON,Intl,BigInt,console,Error";
    var isGloballyAllowed = /* @__PURE__ */ makeMap(GLOBALS_ALLOWED);
    var isGloballyWhitelisted = isGloballyAllowed;
    var range = 2;
    function generateCodeFrame(source, start = 0, end = source.length) {
      let lines = source.split(/(\r?\n)/);
      const newlineSequences = lines.filter((_, idx) => idx % 2 === 1);
      lines = lines.filter((_, idx) => idx % 2 === 0);
      let count = 0;
      const res = [];
      for (let i = 0; i < lines.length; i++) {
        count += lines[i].length + (newlineSequences[i] && newlineSequences[i].length || 0);
        if (count >= start) {
          for (let j = i - range; j <= i + range || end > count; j++) {
            if (j < 0 || j >= lines.length)
              continue;
            const line = j + 1;
            res.push(
              `${line}${" ".repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`
            );
            const lineLength = lines[j].length;
            const newLineSeqLength = newlineSequences[j] && newlineSequences[j].length || 0;
            if (j === i) {
              const pad = start - (count - (lineLength + newLineSeqLength));
              const length = Math.max(
                1,
                end > count ? lineLength - pad : end - start
              );
              res.push(`   |  ` + " ".repeat(pad) + "^".repeat(length));
            } else if (j > i) {
              if (end > count) {
                const length = Math.max(Math.min(end - count, lineLength), 1);
                res.push(`   |  ` + "^".repeat(length));
              }
              count += lineLength + newLineSeqLength;
            }
          }
          break;
        }
      }
      return res.join("\n");
    }
    function normalizeStyle(value) {
      if (isArray(value)) {
        const res = {};
        for (let i = 0; i < value.length; i++) {
          const item = value[i];
          const normalized = isString2(item) ? parseStringStyle(item) : normalizeStyle(item);
          if (normalized) {
            for (const key in normalized) {
              res[key] = normalized[key];
            }
          }
        }
        return res;
      } else if (isString2(value) || isObject2(value)) {
        return value;
      }
    }
    var listDelimiterRE = /;(?![^(]*\))/g;
    var propertyDelimiterRE = /:([^]+)/;
    var styleCommentRE = /\/\*[^]*?\*\//g;
    function parseStringStyle(cssText) {
      const ret = {};
      cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
        if (item) {
          const tmp = item.split(propertyDelimiterRE);
          tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
        }
      });
      return ret;
    }
    function stringifyStyle(styles) {
      let ret = "";
      if (!styles || isString2(styles)) {
        return ret;
      }
      for (const key in styles) {
        const value = styles[key];
        const normalizedKey = key.startsWith(`--`) ? key : hyphenate(key);
        if (isString2(value) || typeof value === "number") {
          ret += `${normalizedKey}:${value};`;
        }
      }
      return ret;
    }
    function normalizeClass(value) {
      let res = "";
      if (isString2(value)) {
        res = value;
      } else if (isArray(value)) {
        for (let i = 0; i < value.length; i++) {
          const normalized = normalizeClass(value[i]);
          if (normalized) {
            res += normalized + " ";
          }
        }
      } else if (isObject2(value)) {
        for (const name in value) {
          if (value[name]) {
            res += name + " ";
          }
        }
      }
      return res.trim();
    }
    function normalizeProps(props) {
      if (!props)
        return null;
      let { class: klass, style } = props;
      if (klass && !isString2(klass)) {
        props.class = normalizeClass(klass);
      }
      if (style) {
        props.style = normalizeStyle(style);
      }
      return props;
    }
    var HTML_TAGS = "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,hgroup,h1,h2,h3,h4,h5,h6,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,summary,template,blockquote,iframe,tfoot";
    var SVG_TAGS = "svg,animate,animateMotion,animateTransform,circle,clipPath,color-profile,defs,desc,discard,ellipse,feBlend,feColorMatrix,feComponentTransfer,feComposite,feConvolveMatrix,feDiffuseLighting,feDisplacementMap,feDistantLight,feDropShadow,feFlood,feFuncA,feFuncB,feFuncG,feFuncR,feGaussianBlur,feImage,feMerge,feMergeNode,feMorphology,feOffset,fePointLight,feSpecularLighting,feSpotLight,feTile,feTurbulence,filter,foreignObject,g,hatch,hatchpath,image,line,linearGradient,marker,mask,mesh,meshgradient,meshpatch,meshrow,metadata,mpath,path,pattern,polygon,polyline,radialGradient,rect,set,solidcolor,stop,switch,symbol,text,textPath,title,tspan,unknown,use,view";
    var MATH_TAGS = "annotation,annotation-xml,maction,maligngroup,malignmark,math,menclose,merror,mfenced,mfrac,mfraction,mglyph,mi,mlabeledtr,mlongdiv,mmultiscripts,mn,mo,mover,mpadded,mphantom,mprescripts,mroot,mrow,ms,mscarries,mscarry,msgroup,msline,mspace,msqrt,msrow,mstack,mstyle,msub,msubsup,msup,mtable,mtd,mtext,mtr,munder,munderover,none,semantics";
    var VOID_TAGS = "area,base,br,col,embed,hr,img,input,link,meta,param,source,track,wbr";
    var isHTMLTag = /* @__PURE__ */ makeMap(HTML_TAGS);
    var isSVGTag = /* @__PURE__ */ makeMap(SVG_TAGS);
    var isMathMLTag = /* @__PURE__ */ makeMap(MATH_TAGS);
    var isVoidTag = /* @__PURE__ */ makeMap(VOID_TAGS);
    var specialBooleanAttrs = `itemscope,allowfullscreen,formnovalidate,ismap,nomodule,novalidate,readonly`;
    var isSpecialBooleanAttr = /* @__PURE__ */ makeMap(specialBooleanAttrs);
    var isBooleanAttr = /* @__PURE__ */ makeMap(
      specialBooleanAttrs + `,async,autofocus,autoplay,controls,default,defer,disabled,hidden,inert,loop,open,required,reversed,scoped,seamless,checked,muted,multiple,selected`
    );
    function includeBooleanAttr(value) {
      return !!value || value === "";
    }
    var unsafeAttrCharRE = /[>/="'\u0009\u000a\u000c\u0020]/;
    var attrValidationCache = {};
    function isSSRSafeAttrName(name) {
      if (attrValidationCache.hasOwnProperty(name)) {
        return attrValidationCache[name];
      }
      const isUnsafe = unsafeAttrCharRE.test(name);
      if (isUnsafe) {
        console.error(`unsafe attribute name: ${name}`);
      }
      return attrValidationCache[name] = !isUnsafe;
    }
    var propsToAttrMap = {
      acceptCharset: "accept-charset",
      className: "class",
      htmlFor: "for",
      httpEquiv: "http-equiv"
    };
    var isKnownHtmlAttr = /* @__PURE__ */ makeMap(
      `accept,accept-charset,accesskey,action,align,allow,alt,async,autocapitalize,autocomplete,autofocus,autoplay,background,bgcolor,border,buffered,capture,challenge,charset,checked,cite,class,code,codebase,color,cols,colspan,content,contenteditable,contextmenu,controls,coords,crossorigin,csp,data,datetime,decoding,default,defer,dir,dirname,disabled,download,draggable,dropzone,enctype,enterkeyhint,for,form,formaction,formenctype,formmethod,formnovalidate,formtarget,headers,height,hidden,high,href,hreflang,http-equiv,icon,id,importance,inert,integrity,ismap,itemprop,keytype,kind,label,lang,language,loading,list,loop,low,manifest,max,maxlength,minlength,media,min,multiple,muted,name,novalidate,open,optimum,pattern,ping,placeholder,poster,preload,radiogroup,readonly,referrerpolicy,rel,required,reversed,rows,rowspan,sandbox,scope,scoped,selected,shape,size,sizes,slot,span,spellcheck,src,srcdoc,srclang,srcset,start,step,style,summary,tabindex,target,title,translate,type,usemap,value,width,wrap`
    );
    var isKnownSvgAttr = /* @__PURE__ */ makeMap(
      `xmlns,accent-height,accumulate,additive,alignment-baseline,alphabetic,amplitude,arabic-form,ascent,attributeName,attributeType,azimuth,baseFrequency,baseline-shift,baseProfile,bbox,begin,bias,by,calcMode,cap-height,class,clip,clipPathUnits,clip-path,clip-rule,color,color-interpolation,color-interpolation-filters,color-profile,color-rendering,contentScriptType,contentStyleType,crossorigin,cursor,cx,cy,d,decelerate,descent,diffuseConstant,direction,display,divisor,dominant-baseline,dur,dx,dy,edgeMode,elevation,enable-background,end,exponent,fill,fill-opacity,fill-rule,filter,filterRes,filterUnits,flood-color,flood-opacity,font-family,font-size,font-size-adjust,font-stretch,font-style,font-variant,font-weight,format,from,fr,fx,fy,g1,g2,glyph-name,glyph-orientation-horizontal,glyph-orientation-vertical,glyphRef,gradientTransform,gradientUnits,hanging,height,href,hreflang,horiz-adv-x,horiz-origin-x,id,ideographic,image-rendering,in,in2,intercept,k,k1,k2,k3,k4,kernelMatrix,kernelUnitLength,kerning,keyPoints,keySplines,keyTimes,lang,lengthAdjust,letter-spacing,lighting-color,limitingConeAngle,local,marker-end,marker-mid,marker-start,markerHeight,markerUnits,markerWidth,mask,maskContentUnits,maskUnits,mathematical,max,media,method,min,mode,name,numOctaves,offset,opacity,operator,order,orient,orientation,origin,overflow,overline-position,overline-thickness,panose-1,paint-order,path,pathLength,patternContentUnits,patternTransform,patternUnits,ping,pointer-events,points,pointsAtX,pointsAtY,pointsAtZ,preserveAlpha,preserveAspectRatio,primitiveUnits,r,radius,referrerPolicy,refX,refY,rel,rendering-intent,repeatCount,repeatDur,requiredExtensions,requiredFeatures,restart,result,rotate,rx,ry,scale,seed,shape-rendering,slope,spacing,specularConstant,specularExponent,speed,spreadMethod,startOffset,stdDeviation,stemh,stemv,stitchTiles,stop-color,stop-opacity,strikethrough-position,strikethrough-thickness,string,stroke,stroke-dasharray,stroke-dashoffset,stroke-linecap,stroke-linejoin,stroke-miterlimit,stroke-opacity,stroke-width,style,surfaceScale,systemLanguage,tabindex,tableValues,target,targetX,targetY,text-anchor,text-decoration,text-rendering,textLength,to,transform,transform-origin,type,u1,u2,underline-position,underline-thickness,unicode,unicode-bidi,unicode-range,units-per-em,v-alphabetic,v-hanging,v-ideographic,v-mathematical,values,vector-effect,version,vert-adv-y,vert-origin-x,vert-origin-y,viewBox,viewTarget,visibility,width,widths,word-spacing,writing-mode,x,x-height,x1,x2,xChannelSelector,xlink:actuate,xlink:arcrole,xlink:href,xlink:role,xlink:show,xlink:title,xlink:type,xmlns:xlink,xml:base,xml:lang,xml:space,y,y1,y2,yChannelSelector,z,zoomAndPan`
    );
    function isRenderableAttrValue(value) {
      if (value == null) {
        return false;
      }
      const type = typeof value;
      return type === "string" || type === "number" || type === "boolean";
    }
    var escapeRE = /["'&<>]/;
    function escapeHtml(string) {
      const str = "" + string;
      const match = escapeRE.exec(str);
      if (!match) {
        return str;
      }
      let html = "";
      let escaped;
      let index;
      let lastIndex = 0;
      for (index = match.index; index < str.length; index++) {
        switch (str.charCodeAt(index)) {
          case 34:
            escaped = "&quot;";
            break;
          case 38:
            escaped = "&amp;";
            break;
          case 39:
            escaped = "&#39;";
            break;
          case 60:
            escaped = "&lt;";
            break;
          case 62:
            escaped = "&gt;";
            break;
          default:
            continue;
        }
        if (lastIndex !== index) {
          html += str.slice(lastIndex, index);
        }
        lastIndex = index + 1;
        html += escaped;
      }
      return lastIndex !== index ? html + str.slice(lastIndex, index) : html;
    }
    var commentStripRE = /^-?>|<!--|-->|--!>|<!-$/g;
    function escapeHtmlComment(src) {
      return src.replace(commentStripRE, "");
    }
    function looseCompareArrays(a3, b) {
      if (a3.length !== b.length)
        return false;
      let equal = true;
      for (let i = 0; equal && i < a3.length; i++) {
        equal = looseEqual(a3[i], b[i]);
      }
      return equal;
    }
    function looseEqual(a3, b) {
      if (a3 === b)
        return true;
      let aValidType = isDate(a3);
      let bValidType = isDate(b);
      if (aValidType || bValidType) {
        return aValidType && bValidType ? a3.getTime() === b.getTime() : false;
      }
      aValidType = isSymbol(a3);
      bValidType = isSymbol(b);
      if (aValidType || bValidType) {
        return a3 === b;
      }
      aValidType = isArray(a3);
      bValidType = isArray(b);
      if (aValidType || bValidType) {
        return aValidType && bValidType ? looseCompareArrays(a3, b) : false;
      }
      aValidType = isObject2(a3);
      bValidType = isObject2(b);
      if (aValidType || bValidType) {
        if (!aValidType || !bValidType) {
          return false;
        }
        const aKeysCount = Object.keys(a3).length;
        const bKeysCount = Object.keys(b).length;
        if (aKeysCount !== bKeysCount) {
          return false;
        }
        for (const key in a3) {
          const aHasKey = a3.hasOwnProperty(key);
          const bHasKey = b.hasOwnProperty(key);
          if (aHasKey && !bHasKey || !aHasKey && bHasKey || !looseEqual(a3[key], b[key])) {
            return false;
          }
        }
      }
      return String(a3) === String(b);
    }
    function looseIndexOf(arr, val) {
      return arr.findIndex((item) => looseEqual(item, val));
    }
    var toDisplayString2 = (val) => {
      return isString2(val) ? val : val == null ? "" : isArray(val) || isObject2(val) && (val.toString === objectToString || !isFunction(val.toString)) ? JSON.stringify(val, replacer, 2) : String(val);
    };
    var replacer = (_key, val) => {
      if (val && val.__v_isRef) {
        return replacer(_key, val.value);
      } else if (isMap(val)) {
        return {
          [`Map(${val.size})`]: [...val.entries()].reduce(
            (entries, [key, val2], i) => {
              entries[stringifySymbol(key, i) + " =>"] = val2;
              return entries;
            },
            {}
          )
        };
      } else if (isSet(val)) {
        return {
          [`Set(${val.size})`]: [...val.values()].map((v) => stringifySymbol(v))
        };
      } else if (isSymbol(val)) {
        return stringifySymbol(val);
      } else if (isObject2(val) && !isArray(val) && !isPlainObject(val)) {
        return String(val);
      }
      return val;
    };
    var stringifySymbol = (v, i = "") => {
      var _a3;
      return isSymbol(v) ? `Symbol(${(_a3 = v.description) != null ? _a3 : i})` : v;
    };
    exports2.EMPTY_ARR = EMPTY_ARR;
    exports2.EMPTY_OBJ = EMPTY_OBJ;
    exports2.NO = NO;
    exports2.NOOP = NOOP;
    exports2.PatchFlagNames = PatchFlagNames;
    exports2.PatchFlags = PatchFlags;
    exports2.ShapeFlags = ShapeFlags;
    exports2.SlotFlags = SlotFlags;
    exports2.camelize = camelize;
    exports2.capitalize = capitalize;
    exports2.def = def;
    exports2.escapeHtml = escapeHtml;
    exports2.escapeHtmlComment = escapeHtmlComment;
    exports2.extend = extend;
    exports2.genPropsAccessExp = genPropsAccessExp;
    exports2.generateCodeFrame = generateCodeFrame;
    exports2.getGlobalThis = getGlobalThis;
    exports2.hasChanged = hasChanged;
    exports2.hasOwn = hasOwn;
    exports2.hyphenate = hyphenate;
    exports2.includeBooleanAttr = includeBooleanAttr;
    exports2.invokeArrayFns = invokeArrayFns;
    exports2.isArray = isArray;
    exports2.isBooleanAttr = isBooleanAttr;
    exports2.isBuiltInDirective = isBuiltInDirective;
    exports2.isDate = isDate;
    exports2.isFunction = isFunction;
    exports2.isGloballyAllowed = isGloballyAllowed;
    exports2.isGloballyWhitelisted = isGloballyWhitelisted;
    exports2.isHTMLTag = isHTMLTag;
    exports2.isIntegerKey = isIntegerKey;
    exports2.isKnownHtmlAttr = isKnownHtmlAttr;
    exports2.isKnownSvgAttr = isKnownSvgAttr;
    exports2.isMap = isMap;
    exports2.isMathMLTag = isMathMLTag;
    exports2.isModelListener = isModelListener;
    exports2.isObject = isObject2;
    exports2.isOn = isOn;
    exports2.isPlainObject = isPlainObject;
    exports2.isPromise = isPromise;
    exports2.isRegExp = isRegExp;
    exports2.isRenderableAttrValue = isRenderableAttrValue;
    exports2.isReservedProp = isReservedProp;
    exports2.isSSRSafeAttrName = isSSRSafeAttrName;
    exports2.isSVGTag = isSVGTag;
    exports2.isSet = isSet;
    exports2.isSpecialBooleanAttr = isSpecialBooleanAttr;
    exports2.isString = isString2;
    exports2.isSymbol = isSymbol;
    exports2.isVoidTag = isVoidTag;
    exports2.looseEqual = looseEqual;
    exports2.looseIndexOf = looseIndexOf;
    exports2.looseToNumber = looseToNumber;
    exports2.makeMap = makeMap;
    exports2.normalizeClass = normalizeClass;
    exports2.normalizeProps = normalizeProps;
    exports2.normalizeStyle = normalizeStyle;
    exports2.objectToString = objectToString;
    exports2.parseStringStyle = parseStringStyle;
    exports2.propsToAttrMap = propsToAttrMap;
    exports2.remove = remove;
    exports2.slotFlagsText = slotFlagsText;
    exports2.stringifyStyle = stringifyStyle;
    exports2.toDisplayString = toDisplayString2;
    exports2.toHandlerKey = toHandlerKey;
    exports2.toNumber = toNumber;
    exports2.toRawType = toRawType;
    exports2.toTypeString = toTypeString;
  }
});

// node_modules/@vue/shared/index.js
var require_shared = __commonJS({
  "node_modules/@vue/shared/index.js"(exports2, module2) {
    "use strict";
    if (true) {
      module2.exports = require_shared_cjs_prod();
    } else {
      module2.exports = null;
    }
  }
});

// node_modules/entities/lib/generated/decode-data-html.js
var require_decode_data_html = __commonJS({
  "node_modules/entities/lib/generated/decode-data-html.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = new Uint16Array(
      // prettier-ignore
      '\u1D41<\xD5\u0131\u028A\u049D\u057B\u05D0\u0675\u06DE\u07A2\u07D6\u080F\u0A4A\u0A91\u0DA1\u0E6D\u0F09\u0F26\u10CA\u1228\u12E1\u1415\u149D\u14C3\u14DF\u1525\0\0\0\0\0\0\u156B\u16CD\u198D\u1C12\u1DDD\u1F7E\u2060\u21B0\u228D\u23C0\u23FB\u2442\u2824\u2912\u2D08\u2E48\u2FCE\u3016\u32BA\u3639\u37AC\u38FE\u3A28\u3A71\u3AE0\u3B2E\u0800EMabcfglmnoprstu\\bfms\x7F\x84\x8B\x90\x95\x98\xA6\xB3\xB9\xC8\xCFlig\u803B\xC6\u40C6P\u803B&\u4026cute\u803B\xC1\u40C1reve;\u4102\u0100iyx}rc\u803B\xC2\u40C2;\u4410r;\uC000\u{1D504}rave\u803B\xC0\u40C0pha;\u4391acr;\u4100d;\u6A53\u0100gp\x9D\xA1on;\u4104f;\uC000\u{1D538}plyFunction;\u6061ing\u803B\xC5\u40C5\u0100cs\xBE\xC3r;\uC000\u{1D49C}ign;\u6254ilde\u803B\xC3\u40C3ml\u803B\xC4\u40C4\u0400aceforsu\xE5\xFB\xFE\u0117\u011C\u0122\u0127\u012A\u0100cr\xEA\xF2kslash;\u6216\u0176\xF6\xF8;\u6AE7ed;\u6306y;\u4411\u0180crt\u0105\u010B\u0114ause;\u6235noullis;\u612Ca;\u4392r;\uC000\u{1D505}pf;\uC000\u{1D539}eve;\u42D8c\xF2\u0113mpeq;\u624E\u0700HOacdefhilorsu\u014D\u0151\u0156\u0180\u019E\u01A2\u01B5\u01B7\u01BA\u01DC\u0215\u0273\u0278\u027Ecy;\u4427PY\u803B\xA9\u40A9\u0180cpy\u015D\u0162\u017Aute;\u4106\u0100;i\u0167\u0168\u62D2talDifferentialD;\u6145leys;\u612D\u0200aeio\u0189\u018E\u0194\u0198ron;\u410Cdil\u803B\xC7\u40C7rc;\u4108nint;\u6230ot;\u410A\u0100dn\u01A7\u01ADilla;\u40B8terDot;\u40B7\xF2\u017Fi;\u43A7rcle\u0200DMPT\u01C7\u01CB\u01D1\u01D6ot;\u6299inus;\u6296lus;\u6295imes;\u6297o\u0100cs\u01E2\u01F8kwiseContourIntegral;\u6232eCurly\u0100DQ\u0203\u020FoubleQuote;\u601Duote;\u6019\u0200lnpu\u021E\u0228\u0247\u0255on\u0100;e\u0225\u0226\u6237;\u6A74\u0180git\u022F\u0236\u023Aruent;\u6261nt;\u622FourIntegral;\u622E\u0100fr\u024C\u024E;\u6102oduct;\u6210nterClockwiseContourIntegral;\u6233oss;\u6A2Fcr;\uC000\u{1D49E}p\u0100;C\u0284\u0285\u62D3ap;\u624D\u0580DJSZacefios\u02A0\u02AC\u02B0\u02B4\u02B8\u02CB\u02D7\u02E1\u02E6\u0333\u048D\u0100;o\u0179\u02A5trahd;\u6911cy;\u4402cy;\u4405cy;\u440F\u0180grs\u02BF\u02C4\u02C7ger;\u6021r;\u61A1hv;\u6AE4\u0100ay\u02D0\u02D5ron;\u410E;\u4414l\u0100;t\u02DD\u02DE\u6207a;\u4394r;\uC000\u{1D507}\u0100af\u02EB\u0327\u0100cm\u02F0\u0322ritical\u0200ADGT\u0300\u0306\u0316\u031Ccute;\u40B4o\u0174\u030B\u030D;\u42D9bleAcute;\u42DDrave;\u4060ilde;\u42DCond;\u62C4ferentialD;\u6146\u0470\u033D\0\0\0\u0342\u0354\0\u0405f;\uC000\u{1D53B}\u0180;DE\u0348\u0349\u034D\u40A8ot;\u60DCqual;\u6250ble\u0300CDLRUV\u0363\u0372\u0382\u03CF\u03E2\u03F8ontourIntegra\xEC\u0239o\u0274\u0379\0\0\u037B\xBB\u0349nArrow;\u61D3\u0100eo\u0387\u03A4ft\u0180ART\u0390\u0396\u03A1rrow;\u61D0ightArrow;\u61D4e\xE5\u02CAng\u0100LR\u03AB\u03C4eft\u0100AR\u03B3\u03B9rrow;\u67F8ightArrow;\u67FAightArrow;\u67F9ight\u0100AT\u03D8\u03DErrow;\u61D2ee;\u62A8p\u0241\u03E9\0\0\u03EFrrow;\u61D1ownArrow;\u61D5erticalBar;\u6225n\u0300ABLRTa\u0412\u042A\u0430\u045E\u047F\u037Crrow\u0180;BU\u041D\u041E\u0422\u6193ar;\u6913pArrow;\u61F5reve;\u4311eft\u02D2\u043A\0\u0446\0\u0450ightVector;\u6950eeVector;\u695Eector\u0100;B\u0459\u045A\u61BDar;\u6956ight\u01D4\u0467\0\u0471eeVector;\u695Fector\u0100;B\u047A\u047B\u61C1ar;\u6957ee\u0100;A\u0486\u0487\u62A4rrow;\u61A7\u0100ct\u0492\u0497r;\uC000\u{1D49F}rok;\u4110\u0800NTacdfglmopqstux\u04BD\u04C0\u04C4\u04CB\u04DE\u04E2\u04E7\u04EE\u04F5\u0521\u052F\u0536\u0552\u055D\u0560\u0565G;\u414AH\u803B\xD0\u40D0cute\u803B\xC9\u40C9\u0180aiy\u04D2\u04D7\u04DCron;\u411Arc\u803B\xCA\u40CA;\u442Dot;\u4116r;\uC000\u{1D508}rave\u803B\xC8\u40C8ement;\u6208\u0100ap\u04FA\u04FEcr;\u4112ty\u0253\u0506\0\0\u0512mallSquare;\u65FBerySmallSquare;\u65AB\u0100gp\u0526\u052Aon;\u4118f;\uC000\u{1D53C}silon;\u4395u\u0100ai\u053C\u0549l\u0100;T\u0542\u0543\u6A75ilde;\u6242librium;\u61CC\u0100ci\u0557\u055Ar;\u6130m;\u6A73a;\u4397ml\u803B\xCB\u40CB\u0100ip\u056A\u056Fsts;\u6203onentialE;\u6147\u0280cfios\u0585\u0588\u058D\u05B2\u05CCy;\u4424r;\uC000\u{1D509}lled\u0253\u0597\0\0\u05A3mallSquare;\u65FCerySmallSquare;\u65AA\u0370\u05BA\0\u05BF\0\0\u05C4f;\uC000\u{1D53D}All;\u6200riertrf;\u6131c\xF2\u05CB\u0600JTabcdfgorst\u05E8\u05EC\u05EF\u05FA\u0600\u0612\u0616\u061B\u061D\u0623\u066C\u0672cy;\u4403\u803B>\u403Emma\u0100;d\u05F7\u05F8\u4393;\u43DCreve;\u411E\u0180eiy\u0607\u060C\u0610dil;\u4122rc;\u411C;\u4413ot;\u4120r;\uC000\u{1D50A};\u62D9pf;\uC000\u{1D53E}eater\u0300EFGLST\u0635\u0644\u064E\u0656\u065B\u0666qual\u0100;L\u063E\u063F\u6265ess;\u62DBullEqual;\u6267reater;\u6AA2ess;\u6277lantEqual;\u6A7Eilde;\u6273cr;\uC000\u{1D4A2};\u626B\u0400Aacfiosu\u0685\u068B\u0696\u069B\u069E\u06AA\u06BE\u06CARDcy;\u442A\u0100ct\u0690\u0694ek;\u42C7;\u405Eirc;\u4124r;\u610ClbertSpace;\u610B\u01F0\u06AF\0\u06B2f;\u610DizontalLine;\u6500\u0100ct\u06C3\u06C5\xF2\u06A9rok;\u4126mp\u0144\u06D0\u06D8ownHum\xF0\u012Fqual;\u624F\u0700EJOacdfgmnostu\u06FA\u06FE\u0703\u0707\u070E\u071A\u071E\u0721\u0728\u0744\u0778\u078B\u078F\u0795cy;\u4415lig;\u4132cy;\u4401cute\u803B\xCD\u40CD\u0100iy\u0713\u0718rc\u803B\xCE\u40CE;\u4418ot;\u4130r;\u6111rave\u803B\xCC\u40CC\u0180;ap\u0720\u072F\u073F\u0100cg\u0734\u0737r;\u412AinaryI;\u6148lie\xF3\u03DD\u01F4\u0749\0\u0762\u0100;e\u074D\u074E\u622C\u0100gr\u0753\u0758ral;\u622Bsection;\u62C2isible\u0100CT\u076C\u0772omma;\u6063imes;\u6062\u0180gpt\u077F\u0783\u0788on;\u412Ef;\uC000\u{1D540}a;\u4399cr;\u6110ilde;\u4128\u01EB\u079A\0\u079Ecy;\u4406l\u803B\xCF\u40CF\u0280cfosu\u07AC\u07B7\u07BC\u07C2\u07D0\u0100iy\u07B1\u07B5rc;\u4134;\u4419r;\uC000\u{1D50D}pf;\uC000\u{1D541}\u01E3\u07C7\0\u07CCr;\uC000\u{1D4A5}rcy;\u4408kcy;\u4404\u0380HJacfos\u07E4\u07E8\u07EC\u07F1\u07FD\u0802\u0808cy;\u4425cy;\u440Cppa;\u439A\u0100ey\u07F6\u07FBdil;\u4136;\u441Ar;\uC000\u{1D50E}pf;\uC000\u{1D542}cr;\uC000\u{1D4A6}\u0580JTaceflmost\u0825\u0829\u082C\u0850\u0863\u09B3\u09B8\u09C7\u09CD\u0A37\u0A47cy;\u4409\u803B<\u403C\u0280cmnpr\u0837\u083C\u0841\u0844\u084Dute;\u4139bda;\u439Bg;\u67EAlacetrf;\u6112r;\u619E\u0180aey\u0857\u085C\u0861ron;\u413Ddil;\u413B;\u441B\u0100fs\u0868\u0970t\u0500ACDFRTUVar\u087E\u08A9\u08B1\u08E0\u08E6\u08FC\u092F\u095B\u0390\u096A\u0100nr\u0883\u088FgleBracket;\u67E8row\u0180;BR\u0899\u089A\u089E\u6190ar;\u61E4ightArrow;\u61C6eiling;\u6308o\u01F5\u08B7\0\u08C3bleBracket;\u67E6n\u01D4\u08C8\0\u08D2eeVector;\u6961ector\u0100;B\u08DB\u08DC\u61C3ar;\u6959loor;\u630Aight\u0100AV\u08EF\u08F5rrow;\u6194ector;\u694E\u0100er\u0901\u0917e\u0180;AV\u0909\u090A\u0910\u62A3rrow;\u61A4ector;\u695Aiangle\u0180;BE\u0924\u0925\u0929\u62B2ar;\u69CFqual;\u62B4p\u0180DTV\u0937\u0942\u094CownVector;\u6951eeVector;\u6960ector\u0100;B\u0956\u0957\u61BFar;\u6958ector\u0100;B\u0965\u0966\u61BCar;\u6952ight\xE1\u039Cs\u0300EFGLST\u097E\u098B\u0995\u099D\u09A2\u09ADqualGreater;\u62DAullEqual;\u6266reater;\u6276ess;\u6AA1lantEqual;\u6A7Dilde;\u6272r;\uC000\u{1D50F}\u0100;e\u09BD\u09BE\u62D8ftarrow;\u61DAidot;\u413F\u0180npw\u09D4\u0A16\u0A1Bg\u0200LRlr\u09DE\u09F7\u0A02\u0A10eft\u0100AR\u09E6\u09ECrrow;\u67F5ightArrow;\u67F7ightArrow;\u67F6eft\u0100ar\u03B3\u0A0Aight\xE1\u03BFight\xE1\u03CAf;\uC000\u{1D543}er\u0100LR\u0A22\u0A2CeftArrow;\u6199ightArrow;\u6198\u0180cht\u0A3E\u0A40\u0A42\xF2\u084C;\u61B0rok;\u4141;\u626A\u0400acefiosu\u0A5A\u0A5D\u0A60\u0A77\u0A7C\u0A85\u0A8B\u0A8Ep;\u6905y;\u441C\u0100dl\u0A65\u0A6FiumSpace;\u605Flintrf;\u6133r;\uC000\u{1D510}nusPlus;\u6213pf;\uC000\u{1D544}c\xF2\u0A76;\u439C\u0480Jacefostu\u0AA3\u0AA7\u0AAD\u0AC0\u0B14\u0B19\u0D91\u0D97\u0D9Ecy;\u440Acute;\u4143\u0180aey\u0AB4\u0AB9\u0ABEron;\u4147dil;\u4145;\u441D\u0180gsw\u0AC7\u0AF0\u0B0Eative\u0180MTV\u0AD3\u0ADF\u0AE8ediumSpace;\u600Bhi\u0100cn\u0AE6\u0AD8\xEB\u0AD9eryThi\xEE\u0AD9ted\u0100GL\u0AF8\u0B06reaterGreate\xF2\u0673essLes\xF3\u0A48Line;\u400Ar;\uC000\u{1D511}\u0200Bnpt\u0B22\u0B28\u0B37\u0B3Areak;\u6060BreakingSpace;\u40A0f;\u6115\u0680;CDEGHLNPRSTV\u0B55\u0B56\u0B6A\u0B7C\u0BA1\u0BEB\u0C04\u0C5E\u0C84\u0CA6\u0CD8\u0D61\u0D85\u6AEC\u0100ou\u0B5B\u0B64ngruent;\u6262pCap;\u626DoubleVerticalBar;\u6226\u0180lqx\u0B83\u0B8A\u0B9Bement;\u6209ual\u0100;T\u0B92\u0B93\u6260ilde;\uC000\u2242\u0338ists;\u6204reater\u0380;EFGLST\u0BB6\u0BB7\u0BBD\u0BC9\u0BD3\u0BD8\u0BE5\u626Fqual;\u6271ullEqual;\uC000\u2267\u0338reater;\uC000\u226B\u0338ess;\u6279lantEqual;\uC000\u2A7E\u0338ilde;\u6275ump\u0144\u0BF2\u0BFDownHump;\uC000\u224E\u0338qual;\uC000\u224F\u0338e\u0100fs\u0C0A\u0C27tTriangle\u0180;BE\u0C1A\u0C1B\u0C21\u62EAar;\uC000\u29CF\u0338qual;\u62ECs\u0300;EGLST\u0C35\u0C36\u0C3C\u0C44\u0C4B\u0C58\u626Equal;\u6270reater;\u6278ess;\uC000\u226A\u0338lantEqual;\uC000\u2A7D\u0338ilde;\u6274ested\u0100GL\u0C68\u0C79reaterGreater;\uC000\u2AA2\u0338essLess;\uC000\u2AA1\u0338recedes\u0180;ES\u0C92\u0C93\u0C9B\u6280qual;\uC000\u2AAF\u0338lantEqual;\u62E0\u0100ei\u0CAB\u0CB9verseElement;\u620CghtTriangle\u0180;BE\u0CCB\u0CCC\u0CD2\u62EBar;\uC000\u29D0\u0338qual;\u62ED\u0100qu\u0CDD\u0D0CuareSu\u0100bp\u0CE8\u0CF9set\u0100;E\u0CF0\u0CF3\uC000\u228F\u0338qual;\u62E2erset\u0100;E\u0D03\u0D06\uC000\u2290\u0338qual;\u62E3\u0180bcp\u0D13\u0D24\u0D4Eset\u0100;E\u0D1B\u0D1E\uC000\u2282\u20D2qual;\u6288ceeds\u0200;EST\u0D32\u0D33\u0D3B\u0D46\u6281qual;\uC000\u2AB0\u0338lantEqual;\u62E1ilde;\uC000\u227F\u0338erset\u0100;E\u0D58\u0D5B\uC000\u2283\u20D2qual;\u6289ilde\u0200;EFT\u0D6E\u0D6F\u0D75\u0D7F\u6241qual;\u6244ullEqual;\u6247ilde;\u6249erticalBar;\u6224cr;\uC000\u{1D4A9}ilde\u803B\xD1\u40D1;\u439D\u0700Eacdfgmoprstuv\u0DBD\u0DC2\u0DC9\u0DD5\u0DDB\u0DE0\u0DE7\u0DFC\u0E02\u0E20\u0E22\u0E32\u0E3F\u0E44lig;\u4152cute\u803B\xD3\u40D3\u0100iy\u0DCE\u0DD3rc\u803B\xD4\u40D4;\u441Eblac;\u4150r;\uC000\u{1D512}rave\u803B\xD2\u40D2\u0180aei\u0DEE\u0DF2\u0DF6cr;\u414Cga;\u43A9cron;\u439Fpf;\uC000\u{1D546}enCurly\u0100DQ\u0E0E\u0E1AoubleQuote;\u601Cuote;\u6018;\u6A54\u0100cl\u0E27\u0E2Cr;\uC000\u{1D4AA}ash\u803B\xD8\u40D8i\u016C\u0E37\u0E3Cde\u803B\xD5\u40D5es;\u6A37ml\u803B\xD6\u40D6er\u0100BP\u0E4B\u0E60\u0100ar\u0E50\u0E53r;\u603Eac\u0100ek\u0E5A\u0E5C;\u63DEet;\u63B4arenthesis;\u63DC\u0480acfhilors\u0E7F\u0E87\u0E8A\u0E8F\u0E92\u0E94\u0E9D\u0EB0\u0EFCrtialD;\u6202y;\u441Fr;\uC000\u{1D513}i;\u43A6;\u43A0usMinus;\u40B1\u0100ip\u0EA2\u0EADncareplan\xE5\u069Df;\u6119\u0200;eio\u0EB9\u0EBA\u0EE0\u0EE4\u6ABBcedes\u0200;EST\u0EC8\u0EC9\u0ECF\u0EDA\u627Aqual;\u6AAFlantEqual;\u627Cilde;\u627Eme;\u6033\u0100dp\u0EE9\u0EEEuct;\u620Fortion\u0100;a\u0225\u0EF9l;\u621D\u0100ci\u0F01\u0F06r;\uC000\u{1D4AB};\u43A8\u0200Ufos\u0F11\u0F16\u0F1B\u0F1FOT\u803B"\u4022r;\uC000\u{1D514}pf;\u611Acr;\uC000\u{1D4AC}\u0600BEacefhiorsu\u0F3E\u0F43\u0F47\u0F60\u0F73\u0FA7\u0FAA\u0FAD\u1096\u10A9\u10B4\u10BEarr;\u6910G\u803B\xAE\u40AE\u0180cnr\u0F4E\u0F53\u0F56ute;\u4154g;\u67EBr\u0100;t\u0F5C\u0F5D\u61A0l;\u6916\u0180aey\u0F67\u0F6C\u0F71ron;\u4158dil;\u4156;\u4420\u0100;v\u0F78\u0F79\u611Cerse\u0100EU\u0F82\u0F99\u0100lq\u0F87\u0F8Eement;\u620Builibrium;\u61CBpEquilibrium;\u696Fr\xBB\u0F79o;\u43A1ght\u0400ACDFTUVa\u0FC1\u0FEB\u0FF3\u1022\u1028\u105B\u1087\u03D8\u0100nr\u0FC6\u0FD2gleBracket;\u67E9row\u0180;BL\u0FDC\u0FDD\u0FE1\u6192ar;\u61E5eftArrow;\u61C4eiling;\u6309o\u01F5\u0FF9\0\u1005bleBracket;\u67E7n\u01D4\u100A\0\u1014eeVector;\u695Dector\u0100;B\u101D\u101E\u61C2ar;\u6955loor;\u630B\u0100er\u102D\u1043e\u0180;AV\u1035\u1036\u103C\u62A2rrow;\u61A6ector;\u695Biangle\u0180;BE\u1050\u1051\u1055\u62B3ar;\u69D0qual;\u62B5p\u0180DTV\u1063\u106E\u1078ownVector;\u694FeeVector;\u695Cector\u0100;B\u1082\u1083\u61BEar;\u6954ector\u0100;B\u1091\u1092\u61C0ar;\u6953\u0100pu\u109B\u109Ef;\u611DndImplies;\u6970ightarrow;\u61DB\u0100ch\u10B9\u10BCr;\u611B;\u61B1leDelayed;\u69F4\u0680HOacfhimoqstu\u10E4\u10F1\u10F7\u10FD\u1119\u111E\u1151\u1156\u1161\u1167\u11B5\u11BB\u11BF\u0100Cc\u10E9\u10EEHcy;\u4429y;\u4428FTcy;\u442Ccute;\u415A\u0280;aeiy\u1108\u1109\u110E\u1113\u1117\u6ABCron;\u4160dil;\u415Erc;\u415C;\u4421r;\uC000\u{1D516}ort\u0200DLRU\u112A\u1134\u113E\u1149ownArrow\xBB\u041EeftArrow\xBB\u089AightArrow\xBB\u0FDDpArrow;\u6191gma;\u43A3allCircle;\u6218pf;\uC000\u{1D54A}\u0272\u116D\0\0\u1170t;\u621Aare\u0200;ISU\u117B\u117C\u1189\u11AF\u65A1ntersection;\u6293u\u0100bp\u118F\u119Eset\u0100;E\u1197\u1198\u628Fqual;\u6291erset\u0100;E\u11A8\u11A9\u6290qual;\u6292nion;\u6294cr;\uC000\u{1D4AE}ar;\u62C6\u0200bcmp\u11C8\u11DB\u1209\u120B\u0100;s\u11CD\u11CE\u62D0et\u0100;E\u11CD\u11D5qual;\u6286\u0100ch\u11E0\u1205eeds\u0200;EST\u11ED\u11EE\u11F4\u11FF\u627Bqual;\u6AB0lantEqual;\u627Dilde;\u627FTh\xE1\u0F8C;\u6211\u0180;es\u1212\u1213\u1223\u62D1rset\u0100;E\u121C\u121D\u6283qual;\u6287et\xBB\u1213\u0580HRSacfhiors\u123E\u1244\u1249\u1255\u125E\u1271\u1276\u129F\u12C2\u12C8\u12D1ORN\u803B\xDE\u40DEADE;\u6122\u0100Hc\u124E\u1252cy;\u440By;\u4426\u0100bu\u125A\u125C;\u4009;\u43A4\u0180aey\u1265\u126A\u126Fron;\u4164dil;\u4162;\u4422r;\uC000\u{1D517}\u0100ei\u127B\u1289\u01F2\u1280\0\u1287efore;\u6234a;\u4398\u0100cn\u128E\u1298kSpace;\uC000\u205F\u200ASpace;\u6009lde\u0200;EFT\u12AB\u12AC\u12B2\u12BC\u623Cqual;\u6243ullEqual;\u6245ilde;\u6248pf;\uC000\u{1D54B}ipleDot;\u60DB\u0100ct\u12D6\u12DBr;\uC000\u{1D4AF}rok;\u4166\u0AE1\u12F7\u130E\u131A\u1326\0\u132C\u1331\0\0\0\0\0\u1338\u133D\u1377\u1385\0\u13FF\u1404\u140A\u1410\u0100cr\u12FB\u1301ute\u803B\xDA\u40DAr\u0100;o\u1307\u1308\u619Fcir;\u6949r\u01E3\u1313\0\u1316y;\u440Eve;\u416C\u0100iy\u131E\u1323rc\u803B\xDB\u40DB;\u4423blac;\u4170r;\uC000\u{1D518}rave\u803B\xD9\u40D9acr;\u416A\u0100di\u1341\u1369er\u0100BP\u1348\u135D\u0100ar\u134D\u1350r;\u405Fac\u0100ek\u1357\u1359;\u63DFet;\u63B5arenthesis;\u63DDon\u0100;P\u1370\u1371\u62C3lus;\u628E\u0100gp\u137B\u137Fon;\u4172f;\uC000\u{1D54C}\u0400ADETadps\u1395\u13AE\u13B8\u13C4\u03E8\u13D2\u13D7\u13F3rrow\u0180;BD\u1150\u13A0\u13A4ar;\u6912ownArrow;\u61C5ownArrow;\u6195quilibrium;\u696Eee\u0100;A\u13CB\u13CC\u62A5rrow;\u61A5own\xE1\u03F3er\u0100LR\u13DE\u13E8eftArrow;\u6196ightArrow;\u6197i\u0100;l\u13F9\u13FA\u43D2on;\u43A5ing;\u416Ecr;\uC000\u{1D4B0}ilde;\u4168ml\u803B\xDC\u40DC\u0480Dbcdefosv\u1427\u142C\u1430\u1433\u143E\u1485\u148A\u1490\u1496ash;\u62ABar;\u6AEBy;\u4412ash\u0100;l\u143B\u143C\u62A9;\u6AE6\u0100er\u1443\u1445;\u62C1\u0180bty\u144C\u1450\u147Aar;\u6016\u0100;i\u144F\u1455cal\u0200BLST\u1461\u1465\u146A\u1474ar;\u6223ine;\u407Ceparator;\u6758ilde;\u6240ThinSpace;\u600Ar;\uC000\u{1D519}pf;\uC000\u{1D54D}cr;\uC000\u{1D4B1}dash;\u62AA\u0280cefos\u14A7\u14AC\u14B1\u14B6\u14BCirc;\u4174dge;\u62C0r;\uC000\u{1D51A}pf;\uC000\u{1D54E}cr;\uC000\u{1D4B2}\u0200fios\u14CB\u14D0\u14D2\u14D8r;\uC000\u{1D51B};\u439Epf;\uC000\u{1D54F}cr;\uC000\u{1D4B3}\u0480AIUacfosu\u14F1\u14F5\u14F9\u14FD\u1504\u150F\u1514\u151A\u1520cy;\u442Fcy;\u4407cy;\u442Ecute\u803B\xDD\u40DD\u0100iy\u1509\u150Drc;\u4176;\u442Br;\uC000\u{1D51C}pf;\uC000\u{1D550}cr;\uC000\u{1D4B4}ml;\u4178\u0400Hacdefos\u1535\u1539\u153F\u154B\u154F\u155D\u1560\u1564cy;\u4416cute;\u4179\u0100ay\u1544\u1549ron;\u417D;\u4417ot;\u417B\u01F2\u1554\0\u155BoWidt\xE8\u0AD9a;\u4396r;\u6128pf;\u6124cr;\uC000\u{1D4B5}\u0BE1\u1583\u158A\u1590\0\u15B0\u15B6\u15BF\0\0\0\0\u15C6\u15DB\u15EB\u165F\u166D\0\u1695\u169B\u16B2\u16B9\0\u16BEcute\u803B\xE1\u40E1reve;\u4103\u0300;Ediuy\u159C\u159D\u15A1\u15A3\u15A8\u15AD\u623E;\uC000\u223E\u0333;\u623Frc\u803B\xE2\u40E2te\u80BB\xB4\u0306;\u4430lig\u803B\xE6\u40E6\u0100;r\xB2\u15BA;\uC000\u{1D51E}rave\u803B\xE0\u40E0\u0100ep\u15CA\u15D6\u0100fp\u15CF\u15D4sym;\u6135\xE8\u15D3ha;\u43B1\u0100ap\u15DFc\u0100cl\u15E4\u15E7r;\u4101g;\u6A3F\u0264\u15F0\0\0\u160A\u0280;adsv\u15FA\u15FB\u15FF\u1601\u1607\u6227nd;\u6A55;\u6A5Clope;\u6A58;\u6A5A\u0380;elmrsz\u1618\u1619\u161B\u161E\u163F\u164F\u1659\u6220;\u69A4e\xBB\u1619sd\u0100;a\u1625\u1626\u6221\u0461\u1630\u1632\u1634\u1636\u1638\u163A\u163C\u163E;\u69A8;\u69A9;\u69AA;\u69AB;\u69AC;\u69AD;\u69AE;\u69AFt\u0100;v\u1645\u1646\u621Fb\u0100;d\u164C\u164D\u62BE;\u699D\u0100pt\u1654\u1657h;\u6222\xBB\xB9arr;\u637C\u0100gp\u1663\u1667on;\u4105f;\uC000\u{1D552}\u0380;Eaeiop\u12C1\u167B\u167D\u1682\u1684\u1687\u168A;\u6A70cir;\u6A6F;\u624Ad;\u624Bs;\u4027rox\u0100;e\u12C1\u1692\xF1\u1683ing\u803B\xE5\u40E5\u0180cty\u16A1\u16A6\u16A8r;\uC000\u{1D4B6};\u402Amp\u0100;e\u12C1\u16AF\xF1\u0288ilde\u803B\xE3\u40E3ml\u803B\xE4\u40E4\u0100ci\u16C2\u16C8onin\xF4\u0272nt;\u6A11\u0800Nabcdefiklnoprsu\u16ED\u16F1\u1730\u173C\u1743\u1748\u1778\u177D\u17E0\u17E6\u1839\u1850\u170D\u193D\u1948\u1970ot;\u6AED\u0100cr\u16F6\u171Ek\u0200ceps\u1700\u1705\u170D\u1713ong;\u624Cpsilon;\u43F6rime;\u6035im\u0100;e\u171A\u171B\u623Dq;\u62CD\u0176\u1722\u1726ee;\u62BDed\u0100;g\u172C\u172D\u6305e\xBB\u172Drk\u0100;t\u135C\u1737brk;\u63B6\u0100oy\u1701\u1741;\u4431quo;\u601E\u0280cmprt\u1753\u175B\u1761\u1764\u1768aus\u0100;e\u010A\u0109ptyv;\u69B0s\xE9\u170Cno\xF5\u0113\u0180ahw\u176F\u1771\u1773;\u43B2;\u6136een;\u626Cr;\uC000\u{1D51F}g\u0380costuvw\u178D\u179D\u17B3\u17C1\u17D5\u17DB\u17DE\u0180aiu\u1794\u1796\u179A\xF0\u0760rc;\u65EFp\xBB\u1371\u0180dpt\u17A4\u17A8\u17ADot;\u6A00lus;\u6A01imes;\u6A02\u0271\u17B9\0\0\u17BEcup;\u6A06ar;\u6605riangle\u0100du\u17CD\u17D2own;\u65BDp;\u65B3plus;\u6A04e\xE5\u1444\xE5\u14ADarow;\u690D\u0180ako\u17ED\u1826\u1835\u0100cn\u17F2\u1823k\u0180lst\u17FA\u05AB\u1802ozenge;\u69EBriangle\u0200;dlr\u1812\u1813\u1818\u181D\u65B4own;\u65BEeft;\u65C2ight;\u65B8k;\u6423\u01B1\u182B\0\u1833\u01B2\u182F\0\u1831;\u6592;\u65914;\u6593ck;\u6588\u0100eo\u183E\u184D\u0100;q\u1843\u1846\uC000=\u20E5uiv;\uC000\u2261\u20E5t;\u6310\u0200ptwx\u1859\u185E\u1867\u186Cf;\uC000\u{1D553}\u0100;t\u13CB\u1863om\xBB\u13CCtie;\u62C8\u0600DHUVbdhmptuv\u1885\u1896\u18AA\u18BB\u18D7\u18DB\u18EC\u18FF\u1905\u190A\u1910\u1921\u0200LRlr\u188E\u1890\u1892\u1894;\u6557;\u6554;\u6556;\u6553\u0280;DUdu\u18A1\u18A2\u18A4\u18A6\u18A8\u6550;\u6566;\u6569;\u6564;\u6567\u0200LRlr\u18B3\u18B5\u18B7\u18B9;\u655D;\u655A;\u655C;\u6559\u0380;HLRhlr\u18CA\u18CB\u18CD\u18CF\u18D1\u18D3\u18D5\u6551;\u656C;\u6563;\u6560;\u656B;\u6562;\u655Fox;\u69C9\u0200LRlr\u18E4\u18E6\u18E8\u18EA;\u6555;\u6552;\u6510;\u650C\u0280;DUdu\u06BD\u18F7\u18F9\u18FB\u18FD;\u6565;\u6568;\u652C;\u6534inus;\u629Flus;\u629Eimes;\u62A0\u0200LRlr\u1919\u191B\u191D\u191F;\u655B;\u6558;\u6518;\u6514\u0380;HLRhlr\u1930\u1931\u1933\u1935\u1937\u1939\u193B\u6502;\u656A;\u6561;\u655E;\u653C;\u6524;\u651C\u0100ev\u0123\u1942bar\u803B\xA6\u40A6\u0200ceio\u1951\u1956\u195A\u1960r;\uC000\u{1D4B7}mi;\u604Fm\u0100;e\u171A\u171Cl\u0180;bh\u1968\u1969\u196B\u405C;\u69C5sub;\u67C8\u016C\u1974\u197El\u0100;e\u1979\u197A\u6022t\xBB\u197Ap\u0180;Ee\u012F\u1985\u1987;\u6AAE\u0100;q\u06DC\u06DB\u0CE1\u19A7\0\u19E8\u1A11\u1A15\u1A32\0\u1A37\u1A50\0\0\u1AB4\0\0\u1AC1\0\0\u1B21\u1B2E\u1B4D\u1B52\0\u1BFD\0\u1C0C\u0180cpr\u19AD\u19B2\u19DDute;\u4107\u0300;abcds\u19BF\u19C0\u19C4\u19CA\u19D5\u19D9\u6229nd;\u6A44rcup;\u6A49\u0100au\u19CF\u19D2p;\u6A4Bp;\u6A47ot;\u6A40;\uC000\u2229\uFE00\u0100eo\u19E2\u19E5t;\u6041\xEE\u0693\u0200aeiu\u19F0\u19FB\u1A01\u1A05\u01F0\u19F5\0\u19F8s;\u6A4Don;\u410Ddil\u803B\xE7\u40E7rc;\u4109ps\u0100;s\u1A0C\u1A0D\u6A4Cm;\u6A50ot;\u410B\u0180dmn\u1A1B\u1A20\u1A26il\u80BB\xB8\u01ADptyv;\u69B2t\u8100\xA2;e\u1A2D\u1A2E\u40A2r\xE4\u01B2r;\uC000\u{1D520}\u0180cei\u1A3D\u1A40\u1A4Dy;\u4447ck\u0100;m\u1A47\u1A48\u6713ark\xBB\u1A48;\u43C7r\u0380;Ecefms\u1A5F\u1A60\u1A62\u1A6B\u1AA4\u1AAA\u1AAE\u65CB;\u69C3\u0180;el\u1A69\u1A6A\u1A6D\u42C6q;\u6257e\u0261\u1A74\0\0\u1A88rrow\u0100lr\u1A7C\u1A81eft;\u61BAight;\u61BB\u0280RSacd\u1A92\u1A94\u1A96\u1A9A\u1A9F\xBB\u0F47;\u64C8st;\u629Birc;\u629Aash;\u629Dnint;\u6A10id;\u6AEFcir;\u69C2ubs\u0100;u\u1ABB\u1ABC\u6663it\xBB\u1ABC\u02EC\u1AC7\u1AD4\u1AFA\0\u1B0Aon\u0100;e\u1ACD\u1ACE\u403A\u0100;q\xC7\xC6\u026D\u1AD9\0\0\u1AE2a\u0100;t\u1ADE\u1ADF\u402C;\u4040\u0180;fl\u1AE8\u1AE9\u1AEB\u6201\xEE\u1160e\u0100mx\u1AF1\u1AF6ent\xBB\u1AE9e\xF3\u024D\u01E7\u1AFE\0\u1B07\u0100;d\u12BB\u1B02ot;\u6A6Dn\xF4\u0246\u0180fry\u1B10\u1B14\u1B17;\uC000\u{1D554}o\xE4\u0254\u8100\xA9;s\u0155\u1B1Dr;\u6117\u0100ao\u1B25\u1B29rr;\u61B5ss;\u6717\u0100cu\u1B32\u1B37r;\uC000\u{1D4B8}\u0100bp\u1B3C\u1B44\u0100;e\u1B41\u1B42\u6ACF;\u6AD1\u0100;e\u1B49\u1B4A\u6AD0;\u6AD2dot;\u62EF\u0380delprvw\u1B60\u1B6C\u1B77\u1B82\u1BAC\u1BD4\u1BF9arr\u0100lr\u1B68\u1B6A;\u6938;\u6935\u0270\u1B72\0\0\u1B75r;\u62DEc;\u62DFarr\u0100;p\u1B7F\u1B80\u61B6;\u693D\u0300;bcdos\u1B8F\u1B90\u1B96\u1BA1\u1BA5\u1BA8\u622Arcap;\u6A48\u0100au\u1B9B\u1B9Ep;\u6A46p;\u6A4Aot;\u628Dr;\u6A45;\uC000\u222A\uFE00\u0200alrv\u1BB5\u1BBF\u1BDE\u1BE3rr\u0100;m\u1BBC\u1BBD\u61B7;\u693Cy\u0180evw\u1BC7\u1BD4\u1BD8q\u0270\u1BCE\0\0\u1BD2re\xE3\u1B73u\xE3\u1B75ee;\u62CEedge;\u62CFen\u803B\xA4\u40A4earrow\u0100lr\u1BEE\u1BF3eft\xBB\u1B80ight\xBB\u1BBDe\xE4\u1BDD\u0100ci\u1C01\u1C07onin\xF4\u01F7nt;\u6231lcty;\u632D\u0980AHabcdefhijlorstuwz\u1C38\u1C3B\u1C3F\u1C5D\u1C69\u1C75\u1C8A\u1C9E\u1CAC\u1CB7\u1CFB\u1CFF\u1D0D\u1D7B\u1D91\u1DAB\u1DBB\u1DC6\u1DCDr\xF2\u0381ar;\u6965\u0200glrs\u1C48\u1C4D\u1C52\u1C54ger;\u6020eth;\u6138\xF2\u1133h\u0100;v\u1C5A\u1C5B\u6010\xBB\u090A\u016B\u1C61\u1C67arow;\u690Fa\xE3\u0315\u0100ay\u1C6E\u1C73ron;\u410F;\u4434\u0180;ao\u0332\u1C7C\u1C84\u0100gr\u02BF\u1C81r;\u61CAtseq;\u6A77\u0180glm\u1C91\u1C94\u1C98\u803B\xB0\u40B0ta;\u43B4ptyv;\u69B1\u0100ir\u1CA3\u1CA8sht;\u697F;\uC000\u{1D521}ar\u0100lr\u1CB3\u1CB5\xBB\u08DC\xBB\u101E\u0280aegsv\u1CC2\u0378\u1CD6\u1CDC\u1CE0m\u0180;os\u0326\u1CCA\u1CD4nd\u0100;s\u0326\u1CD1uit;\u6666amma;\u43DDin;\u62F2\u0180;io\u1CE7\u1CE8\u1CF8\u40F7de\u8100\xF7;o\u1CE7\u1CF0ntimes;\u62C7n\xF8\u1CF7cy;\u4452c\u026F\u1D06\0\0\u1D0Arn;\u631Eop;\u630D\u0280lptuw\u1D18\u1D1D\u1D22\u1D49\u1D55lar;\u4024f;\uC000\u{1D555}\u0280;emps\u030B\u1D2D\u1D37\u1D3D\u1D42q\u0100;d\u0352\u1D33ot;\u6251inus;\u6238lus;\u6214quare;\u62A1blebarwedg\xE5\xFAn\u0180adh\u112E\u1D5D\u1D67ownarrow\xF3\u1C83arpoon\u0100lr\u1D72\u1D76ef\xF4\u1CB4igh\xF4\u1CB6\u0162\u1D7F\u1D85karo\xF7\u0F42\u026F\u1D8A\0\0\u1D8Ern;\u631Fop;\u630C\u0180cot\u1D98\u1DA3\u1DA6\u0100ry\u1D9D\u1DA1;\uC000\u{1D4B9};\u4455l;\u69F6rok;\u4111\u0100dr\u1DB0\u1DB4ot;\u62F1i\u0100;f\u1DBA\u1816\u65BF\u0100ah\u1DC0\u1DC3r\xF2\u0429a\xF2\u0FA6angle;\u69A6\u0100ci\u1DD2\u1DD5y;\u445Fgrarr;\u67FF\u0900Dacdefglmnopqrstux\u1E01\u1E09\u1E19\u1E38\u0578\u1E3C\u1E49\u1E61\u1E7E\u1EA5\u1EAF\u1EBD\u1EE1\u1F2A\u1F37\u1F44\u1F4E\u1F5A\u0100Do\u1E06\u1D34o\xF4\u1C89\u0100cs\u1E0E\u1E14ute\u803B\xE9\u40E9ter;\u6A6E\u0200aioy\u1E22\u1E27\u1E31\u1E36ron;\u411Br\u0100;c\u1E2D\u1E2E\u6256\u803B\xEA\u40EAlon;\u6255;\u444Dot;\u4117\u0100Dr\u1E41\u1E45ot;\u6252;\uC000\u{1D522}\u0180;rs\u1E50\u1E51\u1E57\u6A9Aave\u803B\xE8\u40E8\u0100;d\u1E5C\u1E5D\u6A96ot;\u6A98\u0200;ils\u1E6A\u1E6B\u1E72\u1E74\u6A99nters;\u63E7;\u6113\u0100;d\u1E79\u1E7A\u6A95ot;\u6A97\u0180aps\u1E85\u1E89\u1E97cr;\u4113ty\u0180;sv\u1E92\u1E93\u1E95\u6205et\xBB\u1E93p\u01001;\u1E9D\u1EA4\u0133\u1EA1\u1EA3;\u6004;\u6005\u6003\u0100gs\u1EAA\u1EAC;\u414Bp;\u6002\u0100gp\u1EB4\u1EB8on;\u4119f;\uC000\u{1D556}\u0180als\u1EC4\u1ECE\u1ED2r\u0100;s\u1ECA\u1ECB\u62D5l;\u69E3us;\u6A71i\u0180;lv\u1EDA\u1EDB\u1EDF\u43B5on\xBB\u1EDB;\u43F5\u0200csuv\u1EEA\u1EF3\u1F0B\u1F23\u0100io\u1EEF\u1E31rc\xBB\u1E2E\u0269\u1EF9\0\0\u1EFB\xED\u0548ant\u0100gl\u1F02\u1F06tr\xBB\u1E5Dess\xBB\u1E7A\u0180aei\u1F12\u1F16\u1F1Als;\u403Dst;\u625Fv\u0100;D\u0235\u1F20D;\u6A78parsl;\u69E5\u0100Da\u1F2F\u1F33ot;\u6253rr;\u6971\u0180cdi\u1F3E\u1F41\u1EF8r;\u612Fo\xF4\u0352\u0100ah\u1F49\u1F4B;\u43B7\u803B\xF0\u40F0\u0100mr\u1F53\u1F57l\u803B\xEB\u40EBo;\u60AC\u0180cip\u1F61\u1F64\u1F67l;\u4021s\xF4\u056E\u0100eo\u1F6C\u1F74ctatio\xEE\u0559nential\xE5\u0579\u09E1\u1F92\0\u1F9E\0\u1FA1\u1FA7\0\0\u1FC6\u1FCC\0\u1FD3\0\u1FE6\u1FEA\u2000\0\u2008\u205Allingdotse\xF1\u1E44y;\u4444male;\u6640\u0180ilr\u1FAD\u1FB3\u1FC1lig;\u8000\uFB03\u0269\u1FB9\0\0\u1FBDg;\u8000\uFB00ig;\u8000\uFB04;\uC000\u{1D523}lig;\u8000\uFB01lig;\uC000fj\u0180alt\u1FD9\u1FDC\u1FE1t;\u666Dig;\u8000\uFB02ns;\u65B1of;\u4192\u01F0\u1FEE\0\u1FF3f;\uC000\u{1D557}\u0100ak\u05BF\u1FF7\u0100;v\u1FFC\u1FFD\u62D4;\u6AD9artint;\u6A0D\u0100ao\u200C\u2055\u0100cs\u2011\u2052\u03B1\u201A\u2030\u2038\u2045\u2048\0\u2050\u03B2\u2022\u2025\u2027\u202A\u202C\0\u202E\u803B\xBD\u40BD;\u6153\u803B\xBC\u40BC;\u6155;\u6159;\u615B\u01B3\u2034\0\u2036;\u6154;\u6156\u02B4\u203E\u2041\0\0\u2043\u803B\xBE\u40BE;\u6157;\u615C5;\u6158\u01B6\u204C\0\u204E;\u615A;\u615D8;\u615El;\u6044wn;\u6322cr;\uC000\u{1D4BB}\u0880Eabcdefgijlnorstv\u2082\u2089\u209F\u20A5\u20B0\u20B4\u20F0\u20F5\u20FA\u20FF\u2103\u2112\u2138\u0317\u213E\u2152\u219E\u0100;l\u064D\u2087;\u6A8C\u0180cmp\u2090\u2095\u209Dute;\u41F5ma\u0100;d\u209C\u1CDA\u43B3;\u6A86reve;\u411F\u0100iy\u20AA\u20AErc;\u411D;\u4433ot;\u4121\u0200;lqs\u063E\u0642\u20BD\u20C9\u0180;qs\u063E\u064C\u20C4lan\xF4\u0665\u0200;cdl\u0665\u20D2\u20D5\u20E5c;\u6AA9ot\u0100;o\u20DC\u20DD\u6A80\u0100;l\u20E2\u20E3\u6A82;\u6A84\u0100;e\u20EA\u20ED\uC000\u22DB\uFE00s;\u6A94r;\uC000\u{1D524}\u0100;g\u0673\u061Bmel;\u6137cy;\u4453\u0200;Eaj\u065A\u210C\u210E\u2110;\u6A92;\u6AA5;\u6AA4\u0200Eaes\u211B\u211D\u2129\u2134;\u6269p\u0100;p\u2123\u2124\u6A8Arox\xBB\u2124\u0100;q\u212E\u212F\u6A88\u0100;q\u212E\u211Bim;\u62E7pf;\uC000\u{1D558}\u0100ci\u2143\u2146r;\u610Am\u0180;el\u066B\u214E\u2150;\u6A8E;\u6A90\u8300>;cdlqr\u05EE\u2160\u216A\u216E\u2173\u2179\u0100ci\u2165\u2167;\u6AA7r;\u6A7Aot;\u62D7Par;\u6995uest;\u6A7C\u0280adels\u2184\u216A\u2190\u0656\u219B\u01F0\u2189\0\u218Epro\xF8\u209Er;\u6978q\u0100lq\u063F\u2196les\xF3\u2088i\xED\u066B\u0100en\u21A3\u21ADrtneqq;\uC000\u2269\uFE00\xC5\u21AA\u0500Aabcefkosy\u21C4\u21C7\u21F1\u21F5\u21FA\u2218\u221D\u222F\u2268\u227Dr\xF2\u03A0\u0200ilmr\u21D0\u21D4\u21D7\u21DBrs\xF0\u1484f\xBB\u2024il\xF4\u06A9\u0100dr\u21E0\u21E4cy;\u444A\u0180;cw\u08F4\u21EB\u21EFir;\u6948;\u61ADar;\u610Firc;\u4125\u0180alr\u2201\u220E\u2213rts\u0100;u\u2209\u220A\u6665it\xBB\u220Alip;\u6026con;\u62B9r;\uC000\u{1D525}s\u0100ew\u2223\u2229arow;\u6925arow;\u6926\u0280amopr\u223A\u223E\u2243\u225E\u2263rr;\u61FFtht;\u623Bk\u0100lr\u2249\u2253eftarrow;\u61A9ightarrow;\u61AAf;\uC000\u{1D559}bar;\u6015\u0180clt\u226F\u2274\u2278r;\uC000\u{1D4BD}as\xE8\u21F4rok;\u4127\u0100bp\u2282\u2287ull;\u6043hen\xBB\u1C5B\u0AE1\u22A3\0\u22AA\0\u22B8\u22C5\u22CE\0\u22D5\u22F3\0\0\u22F8\u2322\u2367\u2362\u237F\0\u2386\u23AA\u23B4cute\u803B\xED\u40ED\u0180;iy\u0771\u22B0\u22B5rc\u803B\xEE\u40EE;\u4438\u0100cx\u22BC\u22BFy;\u4435cl\u803B\xA1\u40A1\u0100fr\u039F\u22C9;\uC000\u{1D526}rave\u803B\xEC\u40EC\u0200;ino\u073E\u22DD\u22E9\u22EE\u0100in\u22E2\u22E6nt;\u6A0Ct;\u622Dfin;\u69DCta;\u6129lig;\u4133\u0180aop\u22FE\u231A\u231D\u0180cgt\u2305\u2308\u2317r;\u412B\u0180elp\u071F\u230F\u2313in\xE5\u078Ear\xF4\u0720h;\u4131f;\u62B7ed;\u41B5\u0280;cfot\u04F4\u232C\u2331\u233D\u2341are;\u6105in\u0100;t\u2338\u2339\u621Eie;\u69DDdo\xF4\u2319\u0280;celp\u0757\u234C\u2350\u235B\u2361al;\u62BA\u0100gr\u2355\u2359er\xF3\u1563\xE3\u234Darhk;\u6A17rod;\u6A3C\u0200cgpt\u236F\u2372\u2376\u237By;\u4451on;\u412Ff;\uC000\u{1D55A}a;\u43B9uest\u803B\xBF\u40BF\u0100ci\u238A\u238Fr;\uC000\u{1D4BE}n\u0280;Edsv\u04F4\u239B\u239D\u23A1\u04F3;\u62F9ot;\u62F5\u0100;v\u23A6\u23A7\u62F4;\u62F3\u0100;i\u0777\u23AElde;\u4129\u01EB\u23B8\0\u23BCcy;\u4456l\u803B\xEF\u40EF\u0300cfmosu\u23CC\u23D7\u23DC\u23E1\u23E7\u23F5\u0100iy\u23D1\u23D5rc;\u4135;\u4439r;\uC000\u{1D527}ath;\u4237pf;\uC000\u{1D55B}\u01E3\u23EC\0\u23F1r;\uC000\u{1D4BF}rcy;\u4458kcy;\u4454\u0400acfghjos\u240B\u2416\u2422\u2427\u242D\u2431\u2435\u243Bppa\u0100;v\u2413\u2414\u43BA;\u43F0\u0100ey\u241B\u2420dil;\u4137;\u443Ar;\uC000\u{1D528}reen;\u4138cy;\u4445cy;\u445Cpf;\uC000\u{1D55C}cr;\uC000\u{1D4C0}\u0B80ABEHabcdefghjlmnoprstuv\u2470\u2481\u2486\u248D\u2491\u250E\u253D\u255A\u2580\u264E\u265E\u2665\u2679\u267D\u269A\u26B2\u26D8\u275D\u2768\u278B\u27C0\u2801\u2812\u0180art\u2477\u247A\u247Cr\xF2\u09C6\xF2\u0395ail;\u691Barr;\u690E\u0100;g\u0994\u248B;\u6A8Bar;\u6962\u0963\u24A5\0\u24AA\0\u24B1\0\0\0\0\0\u24B5\u24BA\0\u24C6\u24C8\u24CD\0\u24F9ute;\u413Amptyv;\u69B4ra\xEE\u084Cbda;\u43BBg\u0180;dl\u088E\u24C1\u24C3;\u6991\xE5\u088E;\u6A85uo\u803B\xAB\u40ABr\u0400;bfhlpst\u0899\u24DE\u24E6\u24E9\u24EB\u24EE\u24F1\u24F5\u0100;f\u089D\u24E3s;\u691Fs;\u691D\xEB\u2252p;\u61ABl;\u6939im;\u6973l;\u61A2\u0180;ae\u24FF\u2500\u2504\u6AABil;\u6919\u0100;s\u2509\u250A\u6AAD;\uC000\u2AAD\uFE00\u0180abr\u2515\u2519\u251Drr;\u690Crk;\u6772\u0100ak\u2522\u252Cc\u0100ek\u2528\u252A;\u407B;\u405B\u0100es\u2531\u2533;\u698Bl\u0100du\u2539\u253B;\u698F;\u698D\u0200aeuy\u2546\u254B\u2556\u2558ron;\u413E\u0100di\u2550\u2554il;\u413C\xEC\u08B0\xE2\u2529;\u443B\u0200cqrs\u2563\u2566\u256D\u257Da;\u6936uo\u0100;r\u0E19\u1746\u0100du\u2572\u2577har;\u6967shar;\u694Bh;\u61B2\u0280;fgqs\u258B\u258C\u0989\u25F3\u25FF\u6264t\u0280ahlrt\u2598\u25A4\u25B7\u25C2\u25E8rrow\u0100;t\u0899\u25A1a\xE9\u24F6arpoon\u0100du\u25AF\u25B4own\xBB\u045Ap\xBB\u0966eftarrows;\u61C7ight\u0180ahs\u25CD\u25D6\u25DErrow\u0100;s\u08F4\u08A7arpoon\xF3\u0F98quigarro\xF7\u21F0hreetimes;\u62CB\u0180;qs\u258B\u0993\u25FAlan\xF4\u09AC\u0280;cdgs\u09AC\u260A\u260D\u261D\u2628c;\u6AA8ot\u0100;o\u2614\u2615\u6A7F\u0100;r\u261A\u261B\u6A81;\u6A83\u0100;e\u2622\u2625\uC000\u22DA\uFE00s;\u6A93\u0280adegs\u2633\u2639\u263D\u2649\u264Bppro\xF8\u24C6ot;\u62D6q\u0100gq\u2643\u2645\xF4\u0989gt\xF2\u248C\xF4\u099Bi\xED\u09B2\u0180ilr\u2655\u08E1\u265Asht;\u697C;\uC000\u{1D529}\u0100;E\u099C\u2663;\u6A91\u0161\u2669\u2676r\u0100du\u25B2\u266E\u0100;l\u0965\u2673;\u696Alk;\u6584cy;\u4459\u0280;acht\u0A48\u2688\u268B\u2691\u2696r\xF2\u25C1orne\xF2\u1D08ard;\u696Bri;\u65FA\u0100io\u269F\u26A4dot;\u4140ust\u0100;a\u26AC\u26AD\u63B0che\xBB\u26AD\u0200Eaes\u26BB\u26BD\u26C9\u26D4;\u6268p\u0100;p\u26C3\u26C4\u6A89rox\xBB\u26C4\u0100;q\u26CE\u26CF\u6A87\u0100;q\u26CE\u26BBim;\u62E6\u0400abnoptwz\u26E9\u26F4\u26F7\u271A\u272F\u2741\u2747\u2750\u0100nr\u26EE\u26F1g;\u67ECr;\u61FDr\xEB\u08C1g\u0180lmr\u26FF\u270D\u2714eft\u0100ar\u09E6\u2707ight\xE1\u09F2apsto;\u67FCight\xE1\u09FDparrow\u0100lr\u2725\u2729ef\xF4\u24EDight;\u61AC\u0180afl\u2736\u2739\u273Dr;\u6985;\uC000\u{1D55D}us;\u6A2Dimes;\u6A34\u0161\u274B\u274Fst;\u6217\xE1\u134E\u0180;ef\u2757\u2758\u1800\u65CAnge\xBB\u2758ar\u0100;l\u2764\u2765\u4028t;\u6993\u0280achmt\u2773\u2776\u277C\u2785\u2787r\xF2\u08A8orne\xF2\u1D8Car\u0100;d\u0F98\u2783;\u696D;\u600Eri;\u62BF\u0300achiqt\u2798\u279D\u0A40\u27A2\u27AE\u27BBquo;\u6039r;\uC000\u{1D4C1}m\u0180;eg\u09B2\u27AA\u27AC;\u6A8D;\u6A8F\u0100bu\u252A\u27B3o\u0100;r\u0E1F\u27B9;\u601Arok;\u4142\u8400<;cdhilqr\u082B\u27D2\u2639\u27DC\u27E0\u27E5\u27EA\u27F0\u0100ci\u27D7\u27D9;\u6AA6r;\u6A79re\xE5\u25F2mes;\u62C9arr;\u6976uest;\u6A7B\u0100Pi\u27F5\u27F9ar;\u6996\u0180;ef\u2800\u092D\u181B\u65C3r\u0100du\u2807\u280Dshar;\u694Ahar;\u6966\u0100en\u2817\u2821rtneqq;\uC000\u2268\uFE00\xC5\u281E\u0700Dacdefhilnopsu\u2840\u2845\u2882\u288E\u2893\u28A0\u28A5\u28A8\u28DA\u28E2\u28E4\u0A83\u28F3\u2902Dot;\u623A\u0200clpr\u284E\u2852\u2863\u287Dr\u803B\xAF\u40AF\u0100et\u2857\u2859;\u6642\u0100;e\u285E\u285F\u6720se\xBB\u285F\u0100;s\u103B\u2868to\u0200;dlu\u103B\u2873\u2877\u287Bow\xEE\u048Cef\xF4\u090F\xF0\u13D1ker;\u65AE\u0100oy\u2887\u288Cmma;\u6A29;\u443Cash;\u6014asuredangle\xBB\u1626r;\uC000\u{1D52A}o;\u6127\u0180cdn\u28AF\u28B4\u28C9ro\u803B\xB5\u40B5\u0200;acd\u1464\u28BD\u28C0\u28C4s\xF4\u16A7ir;\u6AF0ot\u80BB\xB7\u01B5us\u0180;bd\u28D2\u1903\u28D3\u6212\u0100;u\u1D3C\u28D8;\u6A2A\u0163\u28DE\u28E1p;\u6ADB\xF2\u2212\xF0\u0A81\u0100dp\u28E9\u28EEels;\u62A7f;\uC000\u{1D55E}\u0100ct\u28F8\u28FDr;\uC000\u{1D4C2}pos\xBB\u159D\u0180;lm\u2909\u290A\u290D\u43BCtimap;\u62B8\u0C00GLRVabcdefghijlmoprstuvw\u2942\u2953\u297E\u2989\u2998\u29DA\u29E9\u2A15\u2A1A\u2A58\u2A5D\u2A83\u2A95\u2AA4\u2AA8\u2B04\u2B07\u2B44\u2B7F\u2BAE\u2C34\u2C67\u2C7C\u2CE9\u0100gt\u2947\u294B;\uC000\u22D9\u0338\u0100;v\u2950\u0BCF\uC000\u226B\u20D2\u0180elt\u295A\u2972\u2976ft\u0100ar\u2961\u2967rrow;\u61CDightarrow;\u61CE;\uC000\u22D8\u0338\u0100;v\u297B\u0C47\uC000\u226A\u20D2ightarrow;\u61CF\u0100Dd\u298E\u2993ash;\u62AFash;\u62AE\u0280bcnpt\u29A3\u29A7\u29AC\u29B1\u29CCla\xBB\u02DEute;\u4144g;\uC000\u2220\u20D2\u0280;Eiop\u0D84\u29BC\u29C0\u29C5\u29C8;\uC000\u2A70\u0338d;\uC000\u224B\u0338s;\u4149ro\xF8\u0D84ur\u0100;a\u29D3\u29D4\u666El\u0100;s\u29D3\u0B38\u01F3\u29DF\0\u29E3p\u80BB\xA0\u0B37mp\u0100;e\u0BF9\u0C00\u0280aeouy\u29F4\u29FE\u2A03\u2A10\u2A13\u01F0\u29F9\0\u29FB;\u6A43on;\u4148dil;\u4146ng\u0100;d\u0D7E\u2A0Aot;\uC000\u2A6D\u0338p;\u6A42;\u443Dash;\u6013\u0380;Aadqsx\u0B92\u2A29\u2A2D\u2A3B\u2A41\u2A45\u2A50rr;\u61D7r\u0100hr\u2A33\u2A36k;\u6924\u0100;o\u13F2\u13F0ot;\uC000\u2250\u0338ui\xF6\u0B63\u0100ei\u2A4A\u2A4Ear;\u6928\xED\u0B98ist\u0100;s\u0BA0\u0B9Fr;\uC000\u{1D52B}\u0200Eest\u0BC5\u2A66\u2A79\u2A7C\u0180;qs\u0BBC\u2A6D\u0BE1\u0180;qs\u0BBC\u0BC5\u2A74lan\xF4\u0BE2i\xED\u0BEA\u0100;r\u0BB6\u2A81\xBB\u0BB7\u0180Aap\u2A8A\u2A8D\u2A91r\xF2\u2971rr;\u61AEar;\u6AF2\u0180;sv\u0F8D\u2A9C\u0F8C\u0100;d\u2AA1\u2AA2\u62FC;\u62FAcy;\u445A\u0380AEadest\u2AB7\u2ABA\u2ABE\u2AC2\u2AC5\u2AF6\u2AF9r\xF2\u2966;\uC000\u2266\u0338rr;\u619Ar;\u6025\u0200;fqs\u0C3B\u2ACE\u2AE3\u2AEFt\u0100ar\u2AD4\u2AD9rro\xF7\u2AC1ightarro\xF7\u2A90\u0180;qs\u0C3B\u2ABA\u2AEAlan\xF4\u0C55\u0100;s\u0C55\u2AF4\xBB\u0C36i\xED\u0C5D\u0100;r\u0C35\u2AFEi\u0100;e\u0C1A\u0C25i\xE4\u0D90\u0100pt\u2B0C\u2B11f;\uC000\u{1D55F}\u8180\xAC;in\u2B19\u2B1A\u2B36\u40ACn\u0200;Edv\u0B89\u2B24\u2B28\u2B2E;\uC000\u22F9\u0338ot;\uC000\u22F5\u0338\u01E1\u0B89\u2B33\u2B35;\u62F7;\u62F6i\u0100;v\u0CB8\u2B3C\u01E1\u0CB8\u2B41\u2B43;\u62FE;\u62FD\u0180aor\u2B4B\u2B63\u2B69r\u0200;ast\u0B7B\u2B55\u2B5A\u2B5Flle\xEC\u0B7Bl;\uC000\u2AFD\u20E5;\uC000\u2202\u0338lint;\u6A14\u0180;ce\u0C92\u2B70\u2B73u\xE5\u0CA5\u0100;c\u0C98\u2B78\u0100;e\u0C92\u2B7D\xF1\u0C98\u0200Aait\u2B88\u2B8B\u2B9D\u2BA7r\xF2\u2988rr\u0180;cw\u2B94\u2B95\u2B99\u619B;\uC000\u2933\u0338;\uC000\u219D\u0338ghtarrow\xBB\u2B95ri\u0100;e\u0CCB\u0CD6\u0380chimpqu\u2BBD\u2BCD\u2BD9\u2B04\u0B78\u2BE4\u2BEF\u0200;cer\u0D32\u2BC6\u0D37\u2BC9u\xE5\u0D45;\uC000\u{1D4C3}ort\u026D\u2B05\0\0\u2BD6ar\xE1\u2B56m\u0100;e\u0D6E\u2BDF\u0100;q\u0D74\u0D73su\u0100bp\u2BEB\u2BED\xE5\u0CF8\xE5\u0D0B\u0180bcp\u2BF6\u2C11\u2C19\u0200;Ees\u2BFF\u2C00\u0D22\u2C04\u6284;\uC000\u2AC5\u0338et\u0100;e\u0D1B\u2C0Bq\u0100;q\u0D23\u2C00c\u0100;e\u0D32\u2C17\xF1\u0D38\u0200;Ees\u2C22\u2C23\u0D5F\u2C27\u6285;\uC000\u2AC6\u0338et\u0100;e\u0D58\u2C2Eq\u0100;q\u0D60\u2C23\u0200gilr\u2C3D\u2C3F\u2C45\u2C47\xEC\u0BD7lde\u803B\xF1\u40F1\xE7\u0C43iangle\u0100lr\u2C52\u2C5Ceft\u0100;e\u0C1A\u2C5A\xF1\u0C26ight\u0100;e\u0CCB\u2C65\xF1\u0CD7\u0100;m\u2C6C\u2C6D\u43BD\u0180;es\u2C74\u2C75\u2C79\u4023ro;\u6116p;\u6007\u0480DHadgilrs\u2C8F\u2C94\u2C99\u2C9E\u2CA3\u2CB0\u2CB6\u2CD3\u2CE3ash;\u62ADarr;\u6904p;\uC000\u224D\u20D2ash;\u62AC\u0100et\u2CA8\u2CAC;\uC000\u2265\u20D2;\uC000>\u20D2nfin;\u69DE\u0180Aet\u2CBD\u2CC1\u2CC5rr;\u6902;\uC000\u2264\u20D2\u0100;r\u2CCA\u2CCD\uC000<\u20D2ie;\uC000\u22B4\u20D2\u0100At\u2CD8\u2CDCrr;\u6903rie;\uC000\u22B5\u20D2im;\uC000\u223C\u20D2\u0180Aan\u2CF0\u2CF4\u2D02rr;\u61D6r\u0100hr\u2CFA\u2CFDk;\u6923\u0100;o\u13E7\u13E5ear;\u6927\u1253\u1A95\0\0\0\0\0\0\0\0\0\0\0\0\0\u2D2D\0\u2D38\u2D48\u2D60\u2D65\u2D72\u2D84\u1B07\0\0\u2D8D\u2DAB\0\u2DC8\u2DCE\0\u2DDC\u2E19\u2E2B\u2E3E\u2E43\u0100cs\u2D31\u1A97ute\u803B\xF3\u40F3\u0100iy\u2D3C\u2D45r\u0100;c\u1A9E\u2D42\u803B\xF4\u40F4;\u443E\u0280abios\u1AA0\u2D52\u2D57\u01C8\u2D5Alac;\u4151v;\u6A38old;\u69BClig;\u4153\u0100cr\u2D69\u2D6Dir;\u69BF;\uC000\u{1D52C}\u036F\u2D79\0\0\u2D7C\0\u2D82n;\u42DBave\u803B\xF2\u40F2;\u69C1\u0100bm\u2D88\u0DF4ar;\u69B5\u0200acit\u2D95\u2D98\u2DA5\u2DA8r\xF2\u1A80\u0100ir\u2D9D\u2DA0r;\u69BEoss;\u69BBn\xE5\u0E52;\u69C0\u0180aei\u2DB1\u2DB5\u2DB9cr;\u414Dga;\u43C9\u0180cdn\u2DC0\u2DC5\u01CDron;\u43BF;\u69B6pf;\uC000\u{1D560}\u0180ael\u2DD4\u2DD7\u01D2r;\u69B7rp;\u69B9\u0380;adiosv\u2DEA\u2DEB\u2DEE\u2E08\u2E0D\u2E10\u2E16\u6228r\xF2\u1A86\u0200;efm\u2DF7\u2DF8\u2E02\u2E05\u6A5Dr\u0100;o\u2DFE\u2DFF\u6134f\xBB\u2DFF\u803B\xAA\u40AA\u803B\xBA\u40BAgof;\u62B6r;\u6A56lope;\u6A57;\u6A5B\u0180clo\u2E1F\u2E21\u2E27\xF2\u2E01ash\u803B\xF8\u40F8l;\u6298i\u016C\u2E2F\u2E34de\u803B\xF5\u40F5es\u0100;a\u01DB\u2E3As;\u6A36ml\u803B\xF6\u40F6bar;\u633D\u0AE1\u2E5E\0\u2E7D\0\u2E80\u2E9D\0\u2EA2\u2EB9\0\0\u2ECB\u0E9C\0\u2F13\0\0\u2F2B\u2FBC\0\u2FC8r\u0200;ast\u0403\u2E67\u2E72\u0E85\u8100\xB6;l\u2E6D\u2E6E\u40B6le\xEC\u0403\u0269\u2E78\0\0\u2E7Bm;\u6AF3;\u6AFDy;\u443Fr\u0280cimpt\u2E8B\u2E8F\u2E93\u1865\u2E97nt;\u4025od;\u402Eil;\u6030enk;\u6031r;\uC000\u{1D52D}\u0180imo\u2EA8\u2EB0\u2EB4\u0100;v\u2EAD\u2EAE\u43C6;\u43D5ma\xF4\u0A76ne;\u660E\u0180;tv\u2EBF\u2EC0\u2EC8\u43C0chfork\xBB\u1FFD;\u43D6\u0100au\u2ECF\u2EDFn\u0100ck\u2ED5\u2EDDk\u0100;h\u21F4\u2EDB;\u610E\xF6\u21F4s\u0480;abcdemst\u2EF3\u2EF4\u1908\u2EF9\u2EFD\u2F04\u2F06\u2F0A\u2F0E\u402Bcir;\u6A23ir;\u6A22\u0100ou\u1D40\u2F02;\u6A25;\u6A72n\u80BB\xB1\u0E9Dim;\u6A26wo;\u6A27\u0180ipu\u2F19\u2F20\u2F25ntint;\u6A15f;\uC000\u{1D561}nd\u803B\xA3\u40A3\u0500;Eaceinosu\u0EC8\u2F3F\u2F41\u2F44\u2F47\u2F81\u2F89\u2F92\u2F7E\u2FB6;\u6AB3p;\u6AB7u\xE5\u0ED9\u0100;c\u0ECE\u2F4C\u0300;acens\u0EC8\u2F59\u2F5F\u2F66\u2F68\u2F7Eppro\xF8\u2F43urlye\xF1\u0ED9\xF1\u0ECE\u0180aes\u2F6F\u2F76\u2F7Approx;\u6AB9qq;\u6AB5im;\u62E8i\xED\u0EDFme\u0100;s\u2F88\u0EAE\u6032\u0180Eas\u2F78\u2F90\u2F7A\xF0\u2F75\u0180dfp\u0EEC\u2F99\u2FAF\u0180als\u2FA0\u2FA5\u2FAAlar;\u632Eine;\u6312urf;\u6313\u0100;t\u0EFB\u2FB4\xEF\u0EFBrel;\u62B0\u0100ci\u2FC0\u2FC5r;\uC000\u{1D4C5};\u43C8ncsp;\u6008\u0300fiopsu\u2FDA\u22E2\u2FDF\u2FE5\u2FEB\u2FF1r;\uC000\u{1D52E}pf;\uC000\u{1D562}rime;\u6057cr;\uC000\u{1D4C6}\u0180aeo\u2FF8\u3009\u3013t\u0100ei\u2FFE\u3005rnion\xF3\u06B0nt;\u6A16st\u0100;e\u3010\u3011\u403F\xF1\u1F19\xF4\u0F14\u0A80ABHabcdefhilmnoprstux\u3040\u3051\u3055\u3059\u30E0\u310E\u312B\u3147\u3162\u3172\u318E\u3206\u3215\u3224\u3229\u3258\u326E\u3272\u3290\u32B0\u32B7\u0180art\u3047\u304A\u304Cr\xF2\u10B3\xF2\u03DDail;\u691Car\xF2\u1C65ar;\u6964\u0380cdenqrt\u3068\u3075\u3078\u307F\u308F\u3094\u30CC\u0100eu\u306D\u3071;\uC000\u223D\u0331te;\u4155i\xE3\u116Emptyv;\u69B3g\u0200;del\u0FD1\u3089\u308B\u308D;\u6992;\u69A5\xE5\u0FD1uo\u803B\xBB\u40BBr\u0580;abcfhlpstw\u0FDC\u30AC\u30AF\u30B7\u30B9\u30BC\u30BE\u30C0\u30C3\u30C7\u30CAp;\u6975\u0100;f\u0FE0\u30B4s;\u6920;\u6933s;\u691E\xEB\u225D\xF0\u272El;\u6945im;\u6974l;\u61A3;\u619D\u0100ai\u30D1\u30D5il;\u691Ao\u0100;n\u30DB\u30DC\u6236al\xF3\u0F1E\u0180abr\u30E7\u30EA\u30EEr\xF2\u17E5rk;\u6773\u0100ak\u30F3\u30FDc\u0100ek\u30F9\u30FB;\u407D;\u405D\u0100es\u3102\u3104;\u698Cl\u0100du\u310A\u310C;\u698E;\u6990\u0200aeuy\u3117\u311C\u3127\u3129ron;\u4159\u0100di\u3121\u3125il;\u4157\xEC\u0FF2\xE2\u30FA;\u4440\u0200clqs\u3134\u3137\u313D\u3144a;\u6937dhar;\u6969uo\u0100;r\u020E\u020Dh;\u61B3\u0180acg\u314E\u315F\u0F44l\u0200;ips\u0F78\u3158\u315B\u109Cn\xE5\u10BBar\xF4\u0FA9t;\u65AD\u0180ilr\u3169\u1023\u316Esht;\u697D;\uC000\u{1D52F}\u0100ao\u3177\u3186r\u0100du\u317D\u317F\xBB\u047B\u0100;l\u1091\u3184;\u696C\u0100;v\u318B\u318C\u43C1;\u43F1\u0180gns\u3195\u31F9\u31FCht\u0300ahlrst\u31A4\u31B0\u31C2\u31D8\u31E4\u31EErrow\u0100;t\u0FDC\u31ADa\xE9\u30C8arpoon\u0100du\u31BB\u31BFow\xEE\u317Ep\xBB\u1092eft\u0100ah\u31CA\u31D0rrow\xF3\u0FEAarpoon\xF3\u0551ightarrows;\u61C9quigarro\xF7\u30CBhreetimes;\u62CCg;\u42DAingdotse\xF1\u1F32\u0180ahm\u320D\u3210\u3213r\xF2\u0FEAa\xF2\u0551;\u600Foust\u0100;a\u321E\u321F\u63B1che\xBB\u321Fmid;\u6AEE\u0200abpt\u3232\u323D\u3240\u3252\u0100nr\u3237\u323Ag;\u67EDr;\u61FEr\xEB\u1003\u0180afl\u3247\u324A\u324Er;\u6986;\uC000\u{1D563}us;\u6A2Eimes;\u6A35\u0100ap\u325D\u3267r\u0100;g\u3263\u3264\u4029t;\u6994olint;\u6A12ar\xF2\u31E3\u0200achq\u327B\u3280\u10BC\u3285quo;\u603Ar;\uC000\u{1D4C7}\u0100bu\u30FB\u328Ao\u0100;r\u0214\u0213\u0180hir\u3297\u329B\u32A0re\xE5\u31F8mes;\u62CAi\u0200;efl\u32AA\u1059\u1821\u32AB\u65B9tri;\u69CEluhar;\u6968;\u611E\u0D61\u32D5\u32DB\u32DF\u332C\u3338\u3371\0\u337A\u33A4\0\0\u33EC\u33F0\0\u3428\u3448\u345A\u34AD\u34B1\u34CA\u34F1\0\u3616\0\0\u3633cute;\u415Bqu\xEF\u27BA\u0500;Eaceinpsy\u11ED\u32F3\u32F5\u32FF\u3302\u330B\u330F\u331F\u3326\u3329;\u6AB4\u01F0\u32FA\0\u32FC;\u6AB8on;\u4161u\xE5\u11FE\u0100;d\u11F3\u3307il;\u415Frc;\u415D\u0180Eas\u3316\u3318\u331B;\u6AB6p;\u6ABAim;\u62E9olint;\u6A13i\xED\u1204;\u4441ot\u0180;be\u3334\u1D47\u3335\u62C5;\u6A66\u0380Aacmstx\u3346\u334A\u3357\u335B\u335E\u3363\u336Drr;\u61D8r\u0100hr\u3350\u3352\xEB\u2228\u0100;o\u0A36\u0A34t\u803B\xA7\u40A7i;\u403Bwar;\u6929m\u0100in\u3369\xF0nu\xF3\xF1t;\u6736r\u0100;o\u3376\u2055\uC000\u{1D530}\u0200acoy\u3382\u3386\u3391\u33A0rp;\u666F\u0100hy\u338B\u338Fcy;\u4449;\u4448rt\u026D\u3399\0\0\u339Ci\xE4\u1464ara\xEC\u2E6F\u803B\xAD\u40AD\u0100gm\u33A8\u33B4ma\u0180;fv\u33B1\u33B2\u33B2\u43C3;\u43C2\u0400;deglnpr\u12AB\u33C5\u33C9\u33CE\u33D6\u33DE\u33E1\u33E6ot;\u6A6A\u0100;q\u12B1\u12B0\u0100;E\u33D3\u33D4\u6A9E;\u6AA0\u0100;E\u33DB\u33DC\u6A9D;\u6A9Fe;\u6246lus;\u6A24arr;\u6972ar\xF2\u113D\u0200aeit\u33F8\u3408\u340F\u3417\u0100ls\u33FD\u3404lsetm\xE9\u336Ahp;\u6A33parsl;\u69E4\u0100dl\u1463\u3414e;\u6323\u0100;e\u341C\u341D\u6AAA\u0100;s\u3422\u3423\u6AAC;\uC000\u2AAC\uFE00\u0180flp\u342E\u3433\u3442tcy;\u444C\u0100;b\u3438\u3439\u402F\u0100;a\u343E\u343F\u69C4r;\u633Ff;\uC000\u{1D564}a\u0100dr\u344D\u0402es\u0100;u\u3454\u3455\u6660it\xBB\u3455\u0180csu\u3460\u3479\u349F\u0100au\u3465\u346Fp\u0100;s\u1188\u346B;\uC000\u2293\uFE00p\u0100;s\u11B4\u3475;\uC000\u2294\uFE00u\u0100bp\u347F\u348F\u0180;es\u1197\u119C\u3486et\u0100;e\u1197\u348D\xF1\u119D\u0180;es\u11A8\u11AD\u3496et\u0100;e\u11A8\u349D\xF1\u11AE\u0180;af\u117B\u34A6\u05B0r\u0165\u34AB\u05B1\xBB\u117Car\xF2\u1148\u0200cemt\u34B9\u34BE\u34C2\u34C5r;\uC000\u{1D4C8}tm\xEE\xF1i\xEC\u3415ar\xE6\u11BE\u0100ar\u34CE\u34D5r\u0100;f\u34D4\u17BF\u6606\u0100an\u34DA\u34EDight\u0100ep\u34E3\u34EApsilo\xEE\u1EE0h\xE9\u2EAFs\xBB\u2852\u0280bcmnp\u34FB\u355E\u1209\u358B\u358E\u0480;Edemnprs\u350E\u350F\u3511\u3515\u351E\u3523\u352C\u3531\u3536\u6282;\u6AC5ot;\u6ABD\u0100;d\u11DA\u351Aot;\u6AC3ult;\u6AC1\u0100Ee\u3528\u352A;\u6ACB;\u628Alus;\u6ABFarr;\u6979\u0180eiu\u353D\u3552\u3555t\u0180;en\u350E\u3545\u354Bq\u0100;q\u11DA\u350Feq\u0100;q\u352B\u3528m;\u6AC7\u0100bp\u355A\u355C;\u6AD5;\u6AD3c\u0300;acens\u11ED\u356C\u3572\u3579\u357B\u3326ppro\xF8\u32FAurlye\xF1\u11FE\xF1\u11F3\u0180aes\u3582\u3588\u331Bppro\xF8\u331Aq\xF1\u3317g;\u666A\u0680123;Edehlmnps\u35A9\u35AC\u35AF\u121C\u35B2\u35B4\u35C0\u35C9\u35D5\u35DA\u35DF\u35E8\u35ED\u803B\xB9\u40B9\u803B\xB2\u40B2\u803B\xB3\u40B3;\u6AC6\u0100os\u35B9\u35BCt;\u6ABEub;\u6AD8\u0100;d\u1222\u35C5ot;\u6AC4s\u0100ou\u35CF\u35D2l;\u67C9b;\u6AD7arr;\u697Bult;\u6AC2\u0100Ee\u35E4\u35E6;\u6ACC;\u628Blus;\u6AC0\u0180eiu\u35F4\u3609\u360Ct\u0180;en\u121C\u35FC\u3602q\u0100;q\u1222\u35B2eq\u0100;q\u35E7\u35E4m;\u6AC8\u0100bp\u3611\u3613;\u6AD4;\u6AD6\u0180Aan\u361C\u3620\u362Drr;\u61D9r\u0100hr\u3626\u3628\xEB\u222E\u0100;o\u0A2B\u0A29war;\u692Alig\u803B\xDF\u40DF\u0BE1\u3651\u365D\u3660\u12CE\u3673\u3679\0\u367E\u36C2\0\0\0\0\0\u36DB\u3703\0\u3709\u376C\0\0\0\u3787\u0272\u3656\0\0\u365Bget;\u6316;\u43C4r\xEB\u0E5F\u0180aey\u3666\u366B\u3670ron;\u4165dil;\u4163;\u4442lrec;\u6315r;\uC000\u{1D531}\u0200eiko\u3686\u369D\u36B5\u36BC\u01F2\u368B\0\u3691e\u01004f\u1284\u1281a\u0180;sv\u3698\u3699\u369B\u43B8ym;\u43D1\u0100cn\u36A2\u36B2k\u0100as\u36A8\u36AEppro\xF8\u12C1im\xBB\u12ACs\xF0\u129E\u0100as\u36BA\u36AE\xF0\u12C1rn\u803B\xFE\u40FE\u01EC\u031F\u36C6\u22E7es\u8180\xD7;bd\u36CF\u36D0\u36D8\u40D7\u0100;a\u190F\u36D5r;\u6A31;\u6A30\u0180eps\u36E1\u36E3\u3700\xE1\u2A4D\u0200;bcf\u0486\u36EC\u36F0\u36F4ot;\u6336ir;\u6AF1\u0100;o\u36F9\u36FC\uC000\u{1D565}rk;\u6ADA\xE1\u3362rime;\u6034\u0180aip\u370F\u3712\u3764d\xE5\u1248\u0380adempst\u3721\u374D\u3740\u3751\u3757\u375C\u375Fngle\u0280;dlqr\u3730\u3731\u3736\u3740\u3742\u65B5own\xBB\u1DBBeft\u0100;e\u2800\u373E\xF1\u092E;\u625Cight\u0100;e\u32AA\u374B\xF1\u105Aot;\u65ECinus;\u6A3Alus;\u6A39b;\u69CDime;\u6A3Bezium;\u63E2\u0180cht\u3772\u377D\u3781\u0100ry\u3777\u377B;\uC000\u{1D4C9};\u4446cy;\u445Brok;\u4167\u0100io\u378B\u378Ex\xF4\u1777head\u0100lr\u3797\u37A0eftarro\xF7\u084Fightarrow\xBB\u0F5D\u0900AHabcdfghlmoprstuw\u37D0\u37D3\u37D7\u37E4\u37F0\u37FC\u380E\u381C\u3823\u3834\u3851\u385D\u386B\u38A9\u38CC\u38D2\u38EA\u38F6r\xF2\u03EDar;\u6963\u0100cr\u37DC\u37E2ute\u803B\xFA\u40FA\xF2\u1150r\u01E3\u37EA\0\u37EDy;\u445Eve;\u416D\u0100iy\u37F5\u37FArc\u803B\xFB\u40FB;\u4443\u0180abh\u3803\u3806\u380Br\xF2\u13ADlac;\u4171a\xF2\u13C3\u0100ir\u3813\u3818sht;\u697E;\uC000\u{1D532}rave\u803B\xF9\u40F9\u0161\u3827\u3831r\u0100lr\u382C\u382E\xBB\u0957\xBB\u1083lk;\u6580\u0100ct\u3839\u384D\u026F\u383F\0\0\u384Arn\u0100;e\u3845\u3846\u631Cr\xBB\u3846op;\u630Fri;\u65F8\u0100al\u3856\u385Acr;\u416B\u80BB\xA8\u0349\u0100gp\u3862\u3866on;\u4173f;\uC000\u{1D566}\u0300adhlsu\u114B\u3878\u387D\u1372\u3891\u38A0own\xE1\u13B3arpoon\u0100lr\u3888\u388Cef\xF4\u382Digh\xF4\u382Fi\u0180;hl\u3899\u389A\u389C\u43C5\xBB\u13FAon\xBB\u389Aparrows;\u61C8\u0180cit\u38B0\u38C4\u38C8\u026F\u38B6\0\0\u38C1rn\u0100;e\u38BC\u38BD\u631Dr\xBB\u38BDop;\u630Eng;\u416Fri;\u65F9cr;\uC000\u{1D4CA}\u0180dir\u38D9\u38DD\u38E2ot;\u62F0lde;\u4169i\u0100;f\u3730\u38E8\xBB\u1813\u0100am\u38EF\u38F2r\xF2\u38A8l\u803B\xFC\u40FCangle;\u69A7\u0780ABDacdeflnoprsz\u391C\u391F\u3929\u392D\u39B5\u39B8\u39BD\u39DF\u39E4\u39E8\u39F3\u39F9\u39FD\u3A01\u3A20r\xF2\u03F7ar\u0100;v\u3926\u3927\u6AE8;\u6AE9as\xE8\u03E1\u0100nr\u3932\u3937grt;\u699C\u0380eknprst\u34E3\u3946\u394B\u3952\u395D\u3964\u3996app\xE1\u2415othin\xE7\u1E96\u0180hir\u34EB\u2EC8\u3959op\xF4\u2FB5\u0100;h\u13B7\u3962\xEF\u318D\u0100iu\u3969\u396Dgm\xE1\u33B3\u0100bp\u3972\u3984setneq\u0100;q\u397D\u3980\uC000\u228A\uFE00;\uC000\u2ACB\uFE00setneq\u0100;q\u398F\u3992\uC000\u228B\uFE00;\uC000\u2ACC\uFE00\u0100hr\u399B\u399Fet\xE1\u369Ciangle\u0100lr\u39AA\u39AFeft\xBB\u0925ight\xBB\u1051y;\u4432ash\xBB\u1036\u0180elr\u39C4\u39D2\u39D7\u0180;be\u2DEA\u39CB\u39CFar;\u62BBq;\u625Alip;\u62EE\u0100bt\u39DC\u1468a\xF2\u1469r;\uC000\u{1D533}tr\xE9\u39AEsu\u0100bp\u39EF\u39F1\xBB\u0D1C\xBB\u0D59pf;\uC000\u{1D567}ro\xF0\u0EFBtr\xE9\u39B4\u0100cu\u3A06\u3A0Br;\uC000\u{1D4CB}\u0100bp\u3A10\u3A18n\u0100Ee\u3980\u3A16\xBB\u397En\u0100Ee\u3992\u3A1E\xBB\u3990igzag;\u699A\u0380cefoprs\u3A36\u3A3B\u3A56\u3A5B\u3A54\u3A61\u3A6Airc;\u4175\u0100di\u3A40\u3A51\u0100bg\u3A45\u3A49ar;\u6A5Fe\u0100;q\u15FA\u3A4F;\u6259erp;\u6118r;\uC000\u{1D534}pf;\uC000\u{1D568}\u0100;e\u1479\u3A66at\xE8\u1479cr;\uC000\u{1D4CC}\u0AE3\u178E\u3A87\0\u3A8B\0\u3A90\u3A9B\0\0\u3A9D\u3AA8\u3AAB\u3AAF\0\0\u3AC3\u3ACE\0\u3AD8\u17DC\u17DFtr\xE9\u17D1r;\uC000\u{1D535}\u0100Aa\u3A94\u3A97r\xF2\u03C3r\xF2\u09F6;\u43BE\u0100Aa\u3AA1\u3AA4r\xF2\u03B8r\xF2\u09EBa\xF0\u2713is;\u62FB\u0180dpt\u17A4\u3AB5\u3ABE\u0100fl\u3ABA\u17A9;\uC000\u{1D569}im\xE5\u17B2\u0100Aa\u3AC7\u3ACAr\xF2\u03CEr\xF2\u0A01\u0100cq\u3AD2\u17B8r;\uC000\u{1D4CD}\u0100pt\u17D6\u3ADCr\xE9\u17D4\u0400acefiosu\u3AF0\u3AFD\u3B08\u3B0C\u3B11\u3B15\u3B1B\u3B21c\u0100uy\u3AF6\u3AFBte\u803B\xFD\u40FD;\u444F\u0100iy\u3B02\u3B06rc;\u4177;\u444Bn\u803B\xA5\u40A5r;\uC000\u{1D536}cy;\u4457pf;\uC000\u{1D56A}cr;\uC000\u{1D4CE}\u0100cm\u3B26\u3B29y;\u444El\u803B\xFF\u40FF\u0500acdefhiosw\u3B42\u3B48\u3B54\u3B58\u3B64\u3B69\u3B6D\u3B74\u3B7A\u3B80cute;\u417A\u0100ay\u3B4D\u3B52ron;\u417E;\u4437ot;\u417C\u0100et\u3B5D\u3B61tr\xE6\u155Fa;\u43B6r;\uC000\u{1D537}cy;\u4436grarr;\u61DDpf;\uC000\u{1D56B}cr;\uC000\u{1D4CF}\u0100jn\u3B85\u3B87;\u600Dj;\u600C'.split("").map(function(c) {
        return c.charCodeAt(0);
      })
    );
  }
});

// node_modules/entities/lib/generated/decode-data-xml.js
var require_decode_data_xml = __commonJS({
  "node_modules/entities/lib/generated/decode-data-xml.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = new Uint16Array(
      // prettier-ignore
      "\u0200aglq	\x1B\u026D\0\0p;\u4026os;\u4027t;\u403Et;\u403Cuot;\u4022".split("").map(function(c) {
        return c.charCodeAt(0);
      })
    );
  }
});

// node_modules/entities/lib/decode_codepoint.js
var require_decode_codepoint = __commonJS({
  "node_modules/entities/lib/decode_codepoint.js"(exports2) {
    "use strict";
    var _a3;
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.replaceCodePoint = exports2.fromCodePoint = void 0;
    var decodeMap = /* @__PURE__ */ new Map([
      [0, 65533],
      // C1 Unicode control character reference replacements
      [128, 8364],
      [130, 8218],
      [131, 402],
      [132, 8222],
      [133, 8230],
      [134, 8224],
      [135, 8225],
      [136, 710],
      [137, 8240],
      [138, 352],
      [139, 8249],
      [140, 338],
      [142, 381],
      [145, 8216],
      [146, 8217],
      [147, 8220],
      [148, 8221],
      [149, 8226],
      [150, 8211],
      [151, 8212],
      [152, 732],
      [153, 8482],
      [154, 353],
      [155, 8250],
      [156, 339],
      [158, 382],
      [159, 376]
    ]);
    exports2.fromCodePoint = // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition, node/no-unsupported-features/es-builtins
    (_a3 = String.fromCodePoint) !== null && _a3 !== void 0 ? _a3 : function(codePoint) {
      var output = "";
      if (codePoint > 65535) {
        codePoint -= 65536;
        output += String.fromCharCode(codePoint >>> 10 & 1023 | 55296);
        codePoint = 56320 | codePoint & 1023;
      }
      output += String.fromCharCode(codePoint);
      return output;
    };
    function replaceCodePoint(codePoint) {
      var _a4;
      if (codePoint >= 55296 && codePoint <= 57343 || codePoint > 1114111) {
        return 65533;
      }
      return (_a4 = decodeMap.get(codePoint)) !== null && _a4 !== void 0 ? _a4 : codePoint;
    }
    exports2.replaceCodePoint = replaceCodePoint;
    function decodeCodePoint(codePoint) {
      return (0, exports2.fromCodePoint)(replaceCodePoint(codePoint));
    }
    exports2.default = decodeCodePoint;
  }
});

// node_modules/entities/lib/decode.js
var require_decode = __commonJS({
  "node_modules/entities/lib/decode.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.decodeXML = exports2.decodeHTMLStrict = exports2.decodeHTMLAttribute = exports2.decodeHTML = exports2.determineBranch = exports2.EntityDecoder = exports2.DecodingMode = exports2.BinTrieFlags = exports2.fromCodePoint = exports2.replaceCodePoint = exports2.decodeCodePoint = exports2.xmlDecodeTree = exports2.htmlDecodeTree = void 0;
    var decode_data_html_js_1 = __importDefault(require_decode_data_html());
    exports2.htmlDecodeTree = decode_data_html_js_1.default;
    var decode_data_xml_js_1 = __importDefault(require_decode_data_xml());
    exports2.xmlDecodeTree = decode_data_xml_js_1.default;
    var decode_codepoint_js_1 = __importStar(require_decode_codepoint());
    exports2.decodeCodePoint = decode_codepoint_js_1.default;
    var decode_codepoint_js_2 = require_decode_codepoint();
    Object.defineProperty(exports2, "replaceCodePoint", { enumerable: true, get: function() {
      return decode_codepoint_js_2.replaceCodePoint;
    } });
    Object.defineProperty(exports2, "fromCodePoint", { enumerable: true, get: function() {
      return decode_codepoint_js_2.fromCodePoint;
    } });
    var CharCodes;
    (function(CharCodes2) {
      CharCodes2[CharCodes2["NUM"] = 35] = "NUM";
      CharCodes2[CharCodes2["SEMI"] = 59] = "SEMI";
      CharCodes2[CharCodes2["EQUALS"] = 61] = "EQUALS";
      CharCodes2[CharCodes2["ZERO"] = 48] = "ZERO";
      CharCodes2[CharCodes2["NINE"] = 57] = "NINE";
      CharCodes2[CharCodes2["LOWER_A"] = 97] = "LOWER_A";
      CharCodes2[CharCodes2["LOWER_F"] = 102] = "LOWER_F";
      CharCodes2[CharCodes2["LOWER_X"] = 120] = "LOWER_X";
      CharCodes2[CharCodes2["LOWER_Z"] = 122] = "LOWER_Z";
      CharCodes2[CharCodes2["UPPER_A"] = 65] = "UPPER_A";
      CharCodes2[CharCodes2["UPPER_F"] = 70] = "UPPER_F";
      CharCodes2[CharCodes2["UPPER