"use strict";
// noinspection JSBitwiseOperatorUsage
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
exports.getTypeProperties = exports.getSymbolType = exports.getElementType = void 0;
var lastIdeTypeCheckerId = 0;
function getElementType(ts, program, sourceFile, range, forceReturnType, reverseMapper) {
    var _a, _b;
    var positionStart = ts.getPositionOfLineAndCharacter(sourceFile, range.start.line, range.start.character);
    var positionEnd = ts.getPositionOfLineAndCharacter(sourceFile, range.end.line, range.end.character);
    var node = ts.getTokenAtPosition(sourceFile, positionStart);
    while (node && node.getEnd() < positionEnd) {
        node = node.parent;
    }
    if (!node || node === sourceFile) {
        return undefined;
    }
    if ((ts.isStringLiteral(node) || ts.isNumericLiteral(node))
        && node.pos === ((_a = node.parent) === null || _a === void 0 ? void 0 : _a.pos)
        && node.end === ((_b = node.parent) === null || _b === void 0 ? void 0 : _b.end)) {
        node = node.parent;
    }
    var typeChecker = program.getTypeChecker();
    if (!typeChecker.webStormCacheInfo) {
        typeChecker.webStormCacheInfo = {
            ideTypeCheckerId: ++lastIdeTypeCheckerId,
            requestedTypeIds: new Set(),
            seenTypeIds: new Map(),
            seenSymbolIds: new Map()
        };
    }
    var cacheInfo = typeChecker.webStormCacheInfo;
    var type = typeChecker.getTypeAtLocation(node);
    var prepared;
    if (forceReturnType || type.id == null || !cacheInfo.requestedTypeIds.has(type.id)) {
        var ctx = {
            ts: ts,
            checker: typeChecker,
            createdObjectsIdeIds: new Map(),
            reverseMapper: reverseMapper,
            level: 0,
            nextId: 0
        };
        prepared = convertType(type, ctx);
        prepared.ideTypeCheckerId = cacheInfo.ideTypeCheckerId;
        if (type.id != null) {
            cacheInfo.requestedTypeIds.add(type.id);
        }
    }
    else {
        prepared = {
            id: type.id,
            ideTypeCheckerId: cacheInfo.ideTypeCheckerId
        };
    }
    return { responseRequired: true, response: prepared };
}
exports.getElementType = getElementType;
function convertType(type, ctx) {
    return findReferenceOrConvert(type, function (ideObjectId) {
        var _a, _b, _c, _d;
        var tscType = {
            ideObjectId: ideObjectId,
            ideObjectType: "TypeObject",
            flags: type.flags
        };
        // First, we map only types -- to get them on shallower levels, allowing them more room for nested items.
        // Then we map everything else -- these entries will likely get references to already mapped types.
        tscType.aliasTypeArguments = (_b = (_a = type.aliasTypeArguments) === null || _a === void 0 ? void 0 : _a.map(function (t) { return convertType(t, ctx); })) === null || _b === void 0 ? void 0 : _b.filter(isNotNull);
        if (type.flags & ctx.ts.TypeFlags.Object) {
            if (type.target)
                // FIXME internal API
                // FIXME Whole target is not needed, only target.objectFlags needed
                tscType.target = convertType(type.target, ctx);
            if (type.objectFlags & ctx.ts.ObjectFlags.Reference)
                tscType.resolvedTypeArguments = ctx.checker.getTypeArguments(type)
                    // TS 4 returns 'this'-type as one of class type arguments, which we don't need
                    // FIXME internal API
                    .filter(function (t) { return !t.isThisType; })
                    .map(function (t) { return convertType(t, ctx); })
                    .filter(isNotNull);
        }
        if (type.flags & (ctx.ts.TypeFlags.UnionOrIntersection | ctx.ts.TypeFlags.TemplateLiteral))
            tscType.types = type.types
                .map(function (t) { return convertType(t, ctx); })
                .filter(isNotNull);
        if (type.flags & ctx.ts.TypeFlags.Literal && type.freshType)
            tscType.freshType = convertType(type.freshType, ctx);
        if (type.flags & ctx.ts.TypeFlags.TypeParameter) {
            var constraint = ctx.checker.getBaseConstraintOfType(type);
            if (constraint)
                tscType.constraint = convertType(constraint, ctx);
        }
        if (type.flags & ctx.ts.TypeFlags.Index)
            tscType.type = convertType(type.type, ctx);
        if (type.flags & ctx.ts.TypeFlags.IndexedAccess) {
            tscType.objectType = convertType(type.objectType, ctx);
            tscType.indexType = convertType(type.indexType, ctx);
        }
        if (type.flags & ctx.ts.TypeFlags.Conditional) {
            tscType.checkType = convertType(type.checkType, ctx);
            tscType.extendsType = convertType(type.extendsType, ctx);
            ctx.checker.getPropertiesOfType(type); // In TS 4 this triggers calculation of true and false types
            if (type.resolvedTrueType)
                tscType.resolvedTrueType = convertType(type.resolvedTrueType, ctx);
            if (type.resolvedFalseType)
                tscType.resolvedFalseType = convertType(type.resolvedFalseType, ctx);
        }
        // Now map everything else but types
        if (type.symbol)
            tscType.symbol = convertSymbol(type.symbol, ctx);
        if (type.aliasSymbol)
            tscType.aliasSymbol = convertSymbol(type.aliasSymbol, ctx);
        if (type.flags & ctx.ts.TypeFlags.Object) {
            tscType.objectFlags = type.objectFlags;
        }
        if (type.flags & ctx.ts.TypeFlags.Literal) {
            if (type.flags & ctx.ts.TypeFlags.BigIntLiteral)
                tscType.value = convertPseudoBigInt(type.value, ctx);
            else
                tscType.value = type.value;
        }
        if (type.flags & ctx.ts.TypeFlags.EnumLiteral)
            // FIXME 'nameType' is just some random name from generated Kotlin TypeObjectProperty.
            // FIXME This field should have its own name.
            tscType.nameType = getEnumQualifiedName(type, ctx);
        if (type.flags & ctx.ts.TypeFlags.TemplateLiteral)
            tscType.texts = type.texts;
        // FIXME internal API
        if (type.flags & ctx.ts.TypeFlags.TypeParameter && type.isThisType)
            tscType.isThisType = true;
        // FIXME internal API
        if (typeof type.intrinsicName === 'string')
            tscType.intrinsicName = type.intrinsicName;
        var typeId = type.id;
        tscType.id = typeId;
        if (typeId) {
            (_d = (_c = ctx.checker.webStormCacheInfo) === null || _c === void 0 ? void 0 : _c.seenTypeIds) === null || _d === void 0 ? void 0 : _d.set(typeId, type);
        }
        return tscType;
    }, ctx);
}
function getEnumQualifiedName(type, ctx) {
    var qName = '';
    // FIXME internal API. Maybe use Node.parent instead?
    var current = type.symbol.parent;
    while (current && !(current.valueDeclaration && ctx.ts.isSourceFile(current.valueDeclaration))) {
        qName = current.escapedName + (qName ? '.' + qName : '');
        current = current.parent;
    }
    return qName || undefined;
}
function convertSymbol(symbol, ctx) {
    return findReferenceOrConvert(symbol, function (ideObjectId) {
        var _a, _b, _c, _d, _e, _f;
        var tscSymbol = {
            ideObjectId: ideObjectId,
            ideObjectType: "SymbolObject",
            flags: symbol.flags,
            escapedName: symbol.escapedName
        };
        tscSymbol.declarations = (_b = (_a = symbol.declarations) === null || _a === void 0 ? void 0 : _a.map(function (d) { return convertNode(d, ctx); })) === null || _b === void 0 ? void 0 : _b.filter(isNotNull);
        if (symbol.valueDeclaration)
            tscSymbol.valueDeclaration = convertNode(symbol.valueDeclaration, ctx);
        // FIXME internal API
        if ((_c = symbol.links) === null || _c === void 0 ? void 0 : _c.type)
            tscSymbol.type = convertType((_d = symbol.links) === null || _d === void 0 ? void 0 : _d.type, ctx); // TS 5
        else if (symbol.type)
            tscSymbol.type = convertType(symbol.type, ctx); // TS 4
        var symbolId = ctx.ts.getSymbolId(symbol);
        (_f = (_e = ctx.checker.webStormCacheInfo) === null || _e === void 0 ? void 0 : _e.seenSymbolIds) === null || _f === void 0 ? void 0 : _f.set(symbolId, symbol);
        tscSymbol.id = symbolId;
        return tscSymbol;
    }, ctx, false);
}
function convertSignature(signature, ctx) {
    return findReferenceOrConvert(signature, function (ideObjectId) { return ({
        ideObjectId: ideObjectId,
        ideObjectType: "SignatureObject",
        parameters: signature.parameters
            .map(function (s) { return convertSymbol(s, ctx); })
            .filter(isNotNull),
        resolvedReturnType: convertType(ctx.checker.getReturnTypeOfSignature(signature), ctx)
    }); }, ctx);
}
function convertNode(node, ctx, childReverseMapping) {
    if (childReverseMapping === void 0) { childReverseMapping = undefined; }
    return findReferenceOrConvert(node, function (ideObjectId) {
        var _a, _b, _c;
        if (ctx.ts.isSourceFile(node)) {
            return {
                ideObjectId: ideObjectId,
                ideObjectType: "SourceFileObject",
                fileName: (_a = childReverseMapping === null || childReverseMapping === void 0 ? void 0 : childReverseMapping.fileName) !== null && _a !== void 0 ? _a : node.fileName
            };
        }
        else {
            var sourceFileParent = getSourceFileParent(node, ctx);
            var reverseMapping = runReverseMapper(sourceFileParent, node, ctx);
            return {
                ideObjectId: ideObjectId,
                ideObjectType: "NodeObject",
                pos: (_b = reverseMapping === null || reverseMapping === void 0 ? void 0 : reverseMapping.pos) !== null && _b !== void 0 ? _b : node.pos,
                end: (_c = reverseMapping === null || reverseMapping === void 0 ? void 0 : reverseMapping.end) !== null && _c !== void 0 ? _c : node.end,
                parent: sourceFileParent
                    ? convertNode(sourceFileParent, ctx, reverseMapping)
                    : undefined
            };
        }
    }, ctx, false);
}
function getSourceFileParent(node, ctx) {
    if (ctx.ts.isSourceFile(node))
        return undefined;
    var current = node.parent;
    while (current) {
        if (ctx.ts.isSourceFile(current))
            return current;
        current = current.parent;
    }
}
function runReverseMapper(sourceFileParent, node, ctx) {
    return ctx.reverseMapper && sourceFileParent
        ? ctx.reverseMapper(sourceFileParent, {
            start: ctx.ts.getLineAndCharacterOfPosition(sourceFileParent, node.pos),
            end: ctx.ts.getLineAndCharacterOfPosition(sourceFileParent, node.end)
        })
        : undefined;
}
function convertPseudoBigInt(pseudoBigInt, ctx) {
    return findReferenceOrConvert(pseudoBigInt, function (ideObjectId) { return (__assign({ ideObjectId: ideObjectId }, pseudoBigInt)); }, ctx, false);
}
function convertIndexInfo(indexInfo, ctx) {
    return findReferenceOrConvert(indexInfo, function (ideObjectId) { return ({ ideObjectId: ideObjectId }); }, ctx, false);
}
function findReferenceOrConvert(sourceObj, convertTarget, ctx, respectLevelLimitation) {
    if (respectLevelLimitation === void 0) { respectLevelLimitation = true; }
    if (ctx.createdObjectsIdeIds.has(sourceObj)) {
        return { ideObjectIdRef: ctx.createdObjectsIdeIds.get(sourceObj) };
    }
    /*
     * Even with endless memory, level limitation needed because some generic symbols
     * always produce the new type. For example, Array.concat(): T[] will produce
     * another generic Array, not initial array. The property 'concat' of that generic Array
     * will produce yet another Array etc. Endless.
     */
    // TODO registry -- decrease for a huge project
    if (respectLevelLimitation && ctx.level >= 7)
        return undefined;
    var ideObjectId = ctx.nextId++;
    ctx.createdObjectsIdeIds.set(sourceObj, ideObjectId);
    ctx.level++;
    var newObject = convertTarget(ideObjectId);
    ctx.level--;
    return newObject;
}
function isNotNull(t) {
    return t != null;
}
function getSymbolType(ts, program, symbolId, reverseMapper) {
    var typeChecker = program.getTypeChecker();
    var cacheInfo = typeChecker.webStormCacheInfo;
    if (!cacheInfo) {
        return undefined;
    }
    var symbol = cacheInfo.seenSymbolIds.get(symbolId);
    if (!symbol) {
        return undefined;
    }
    var ctx = {
        ts: ts,
        checker: typeChecker,
        createdObjectsIdeIds: new Map(),
        reverseMapper: reverseMapper,
        level: 0,
        nextId: 0
    };
    var prepared = {};
    if (ctx.checker.getTypeOfSymbol) {
        prepared = convertType(ctx.checker.getTypeOfSymbol(symbol), ctx);
    }
    prepared.ideTypeCheckerId = cacheInfo.ideTypeCheckerId;
    return { responseRequired: true, response: prepared };
}
exports.getSymbolType = getSymbolType;
function getTypeProperties(ts, program, typeId, reverseMapper) {
    var typeChecker = program.getTypeChecker();
    var cacheInfo = typeChecker.webStormCacheInfo;
    if (!cacheInfo) {
        return undefined;
    }
    var type = cacheInfo.seenTypeIds.get(typeId);
    if (!type) {
        return undefined;
    }
    var ctx = {
        ts: ts,
        checker: typeChecker,
        createdObjectsIdeIds: new Map(),
        reverseMapper: reverseMapper,
        level: 0,
        nextId: 0
    };
    var prepared = convertTypeProperties(type, ctx);
    prepared.ideTypeCheckerId = cacheInfo.ideTypeCheckerId;
    return { responseRequired: true, response: prepared };
}
exports.getTypeProperties = getTypeProperties;
function convertTypeProperties(type, ctx) {
    return findReferenceOrConvert(type, function (ideObjectId) {
        var prepared = {
            ideObjectId: ideObjectId,
            ideObjectType: "TypeObject",
            flags: type.flags,
            objectFlags: type.objectFlags
        };
        if (type.flags & ctx.ts.TypeFlags.Object) {
            assignObjectTypeProperties(type, ctx, prepared);
        }
        if (type.flags & ctx.ts.TypeFlags.UnionOrIntersection) {
            assignUnionOrIntersectionTypeProperties(type, ctx, prepared);
        }
        return prepared;
    }, ctx, false);
}
function assignObjectTypeProperties(type, ctx, tscType) {
    tscType.constructSignatures = type.getConstructSignatures()
        .map(function (s) { return convertSignature(s, ctx); })
        .filter(isNotNull);
    tscType.callSignatures = type.getCallSignatures()
        .map(function (s) { return convertSignature(s, ctx); })
        .filter(isNotNull);
    tscType.properties = type.getProperties()
        .map(function (p) { return convertSymbol(p, ctx); })
        .filter(isNotNull);
    tscType.indexInfos = ctx.checker.getIndexInfosOfType &&
        ctx.checker.getIndexInfosOfType(type)
            .map(function (info) { return convertIndexInfo(info, ctx); })
            .filter(isNotNull);
}
function assignUnionOrIntersectionTypeProperties(type, ctx, tscType) {
    tscType.resolvedProperties = ctx.checker.getPropertiesOfType(type)
        .map(function (p) { return convertSymbol(p, ctx); })
        .filter(isNotNull);
}
//# sourceMappingURL=ide-get-element-type.js.map