"use strict";
exports.__esModule = true;
exports.getTypePropertiesTsServer = exports.getSymbolTypeTsServer = exports.getElementTypeTsServer = void 0;
var ide_get_element_type_1 = require("./ide-get-element-type");
function getElementTypeTsServer(ts, projectService, request) {
    var requestArguments = request.arguments;
    var fileName = ts.server.toNormalizedPath(requestArguments.file);
    var project = projectService.getDefaultProjectForFile(fileName, true);
    if (!project) {
        return undefined;
    }
    // see getQuickInfoAtPosition
    var program = project.getLanguageService().getProgram();
    if (!program) {
        return undefined;
    }
    var sourceFile = program.getSourceFile(fileName);
    if (!sourceFile) {
        return undefined;
    }
    return (0, ide_get_element_type_1.getElementType)(ts, program, sourceFile, requestArguments.range, requestArguments.forceReturnType);
}
exports.getElementTypeTsServer = getElementTypeTsServer;
function getSymbolTypeTsServer(ts, projectService, request) {
    var requestArguments = request.arguments;
    var program = findProgram(projectService, requestArguments.ideTypeCheckerId);
    if (!program) {
        return undefined;
    }
    return (0, ide_get_element_type_1.getSymbolType)(ts, program, requestArguments.symbolId);
}
exports.getSymbolTypeTsServer = getSymbolTypeTsServer;
function getTypePropertiesTsServer(ts, projectService, request) {
    var requestArguments = request.arguments;
    var program = findProgram(projectService, requestArguments.ideTypeCheckerId);
    if (!program) {
        return undefined;
    }
    return (0, ide_get_element_type_1.getTypeProperties)(ts, program, requestArguments.typeId);
}
exports.getTypePropertiesTsServer = getTypePropertiesTsServer;
function findProgram(projectService, ideTypeCheckerId) {
    var _a, _b, _c, _d, _e, _f;
    var configuredProjects = projectService.configuredProjects.values();
    while (true) {
        var next = configuredProjects.next();
        if (next.done) {
            break;
        }
        else {
            var program = next.value.getLanguageService().getProgram();
            if (((_b = (_a = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _a === void 0 ? void 0 : _a.webStormCacheInfo) === null || _b === void 0 ? void 0 : _b.ideTypeCheckerId) == ideTypeCheckerId) {
                return program;
            }
        }
    }
    for (var _i = 0, _g = projectService.inferredProjects; _i < _g.length; _i++) {
        var inferredProject = _g[_i];
        var program = inferredProject.getLanguageService().getProgram();
        if (((_d = (_c = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _c === void 0 ? void 0 : _c.webStormCacheInfo) === null || _d === void 0 ? void 0 : _d.ideTypeCheckerId) == ideTypeCheckerId) {
            return program;
        }
    }
    for (var _h = 0, _j = projectService.externalProjects; _h < _j.length; _h++) {
        var externalProject = _j[_h];
        var program = externalProject.getLanguageService().getProgram();
        if (((_f = (_e = program === null || program === void 0 ? void 0 : program.getTypeChecker()) === null || _e === void 0 ? void 0 : _e.webStormCacheInfo) === null || _f === void 0 ? void 0 : _f.ideTypeCheckerId) == ideTypeCheckerId) {
            return program;
        }
    }
}
//# sourceMappingURL=get-element-type-ts-server.js.map