import type * as ts from "typescript/lib/tsserverlibrary"

export type GetElementTypeArguments = {
  file: string;
  range: Range;
  forceReturnType: boolean;
}

export type GetElementTypeResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type GetSymbolTypeArguments = {
  ideTypeCheckerId: number;
  originalRequestUri: string;
  symbolId: number;
}

export type GetSymbolTypeResponse = {
  response: object;
  responseRequired: true
} | undefined;

export type GetTypePropertiesArguments = {
  ideTypeCheckerId: number;
  originalRequestUri: string;
  typeId: number;
}

/**
 * @see https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#range
 */
export interface Range {
  start: Position;
  end: Position;
}

/**
 * @see https://microsoft.github.io/language-server-protocol/specifications/lsp/3.17/specification/#position
 */
export interface Position extends ts.LineAndCharacter {
}