// @ts-ignore
import {
  GetElementTypeArguments,
  GetElementTypeResponse,
  GetSymbolTypeArguments,
  GetSymbolTypeResponse,
  GetTypePropertiesArguments,
  Range
} from "tsc-ide-plugin/protocol"
// @ts-ignore
import {getElementType, getSymbolType, getTypeProperties, ReverseMapper} from "tsc-ide-plugin/ide-get-element-type"
import {languageFeatureWorker} from '@volar/language-service/lib/utils/featureWorkers';
import {ServiceContext} from "@vue/language-server";

export async function getElementTypeVolarServer(ts: typeof import("typescript/lib/tsserverlibrary"),
                                                context: ServiceContext<import('volar-service-typescript').Provide>,
                                                uri: string,
                                                requestArguments: GetElementTypeArguments): Promise<GetElementTypeResponse> {
  const range: Range = requestArguments.range;
  return await callInLanguageFeatureWorker(context, uri, range, (program: ts.Program, sourceFile: ts.SourceFile, range: Range | undefined, reverseMapper: ReverseMapper) => {
    return getElementType(ts, program, sourceFile, range, requestArguments.forceReturnType, reverseMapper);
  })
}

export async function getSymbolTypeVolarServer(ts: typeof import("typescript/lib/tsserverlibrary"),
                                               context: ServiceContext<import('volar-service-typescript').Provide>,
                                               uri: string,
                                               requestArguments: GetSymbolTypeArguments): Promise<GetSymbolTypeResponse> {
  return await callInLanguageFeatureWorker(context, uri, undefined, (program: ts.Program, sourceFile: ts.SourceFile, range: Range | undefined, reverseMapper: ReverseMapper) => {
    return getSymbolType(ts, program, requestArguments.symbolId, reverseMapper);
  })
}

export async function getTypePropertiesVolarServer(ts: typeof import("typescript/lib/tsserverlibrary"),
                                                   context: ServiceContext<import('volar-service-typescript').Provide>,
                                                   uri: string,
                                                   requestArguments: GetTypePropertiesArguments): Promise<GetElementTypeResponse> {
  return await callInLanguageFeatureWorker(context, uri, undefined, (program: ts.Program, sourceFile: ts.SourceFile, range: Range | undefined, reverseMapper: ReverseMapper) => {
    return getTypeProperties(ts, program, requestArguments.typeId, reverseMapper);
  })
}


function callInLanguageFeatureWorker<T>(
  context: ServiceContext<import('volar-service-typescript').Provide>,
  uri: string,
  range: Range | undefined,
  callable: (program: ts.Program, sourceFile: ts.SourceFile, range: Range | undefined, reverseMapper: ReverseMapper) => T
): Promise<NonNullable<Awaited<T | undefined>> | undefined> {
  return languageFeatureWorker(
    context,
    uri,
    range,
    (range, sourceMap) => range ? sourceMap.toGeneratedRanges(range, data => true) : [range],
    (service, document, range, sourceMap) => {
      // if (token.isCancellationRequested)
      //   return;

      if (document.languageId !== 'typescript') {
        return;
      }
      if (document.uri.includes("format.ts")) {
        return;
      }
      if (context.services["typescript"] != service) {
        return; // we don't really need full iteration
      }

      let languageService = context.inject("typescript/languageService");
      let program = languageService.getProgram();
      const sourceFile = context.inject("typescript/sourceFile", document!!)

      if (!program) {
        return undefined
      }
      if (!sourceFile) {
        return undefined
      }

      const reverseMapper = (targetFile: typeof sourceFile, generatedRange: Range) => {
        // sourceMap is only available for SFC sources, i.e., not for TS, since such a map would be pointless.
        if (sourceMap != null && sourceFile == targetFile) {
          const sourceRange = sourceMap.toSourceRange(generatedRange);
          if (sourceRange != undefined) {
            const sourceDocument = sourceMap.sourceFileDocument;
            const targetName = targetFile.fileName;
            return  {
              pos: sourceDocument.offsetAt(sourceRange.start),
              end: sourceDocument.offsetAt(sourceRange.end),
              fileName: targetName.endsWith(".vue.ts") ? targetName.substring(0, targetName.length - ".ts".length) : targetName
            }
          }
        }
        return undefined;
      }

      return callable(program, sourceFile, range, reverseMapper);
    },
    item => item,
    items => items[0],
  );
}