function ContentType(mimeType, charset) {
  this.mimeType = mimeType
  this.charset = charset
}

function __null_aware_lowercase(value) {
  return value != null ? ("" + value).toLowerCase() : null
}

function HttpClient(vars, canelable) {
  this.tests = {}
  this.global = new Variables(vars)

  this.test = function (testName, func) {
    let exception
    try {
      throw new Error("error")
    }
    catch (e) {
      exception = __exception__
    }
    this.tests[testName] = {
      "func": func || null,
      "creationException": exception,
    }
  }

  this.assert = function (condition, message) {
    if (!condition) {
      const err = new Error(message || "Assert failed")
      err.name = "AssertionError"
      throw err
    }
  }

  this.log = __log

  this.exit = function () {
    canelable.accept(this)
  }
}

function ResponseHeaders(headers) {
  this.headers = headers

  this.valueOf = function (headerName) {
    const len = this.headers.length
    for (let i = 0; i < len; i++) {
      if (__null_aware_lowercase(headerName) === __null_aware_lowercase(this.headers[i].name)) {
        return __null_aware_to_string(this.headers[i].value)
      }
    }
    return null
  }

  this.valuesOf = function (headerName) {
    let values = []
    let len = this.headers.length
    for (let i = 0; i < len; i++) {
      if (__null_aware_lowercase(headerName) === __null_aware_lowercase(this.headers[i].name)) {
        values.push(__null_aware_to_string(headers[i].value))
      }
    }
    return values
  }

  this.toJSON = function () {
    const obj = {};
    const len = this.headers.length

    for (let i = 0; i < len; i++) {
      let key = "" + headers[i].name;
      let headerValue = obj[key];
      if (headerValue === undefined) {
        obj[key] = headers[i].value
      }
      else if (headerValue instanceof Array) {
        headerValue.push(headers[i].value)
      }
      else {
        obj[key] = [headerValue, headers[i].value]
      }
    }

    return obj;
  }
}

function TextStreamResponse(
  linesSubscriberConsumer,
  messagesSubscriberConsumer,
  isJson
) {
  this.onEachLine = function (subscriber, onFinish) {
    const finalSubscriber = isJson
      ? function (line, unsubscribe) {
        let newLine
        try {
          newLine = JSON.parse(line)
        }
        catch (e) {
          newLine = line
        }
        subscriber(newLine, unsubscribe)
      }
      : subscriber
    linesSubscriberConsumer.accept(finalSubscriber, onFinish)
  }

  this.onEachMessage = function (subscriber, onFinish) {
    const finalSubscriber = isJson ?
      function (message, unsubscribe, output) {
        let newMessage
        try {
          newMessage = JSON.parse(message)
        }
        catch (e) {
          newMessage = message
        }
        subscriber(newMessage, unsubscribe, output)
      }
      : subscriber
    messagesSubscriberConsumer.accept(finalSubscriber, onFinish)
  }
}

function RequestHeader(h) {
  this.__headerValue = h.getSubstitutedValue();
  this.name = __null_aware_to_string(h.name);
  this.value = function () {
    return __null_aware_to_string(this.__headerValue.getValue())
  }
}

function Request(requestElementsProvider) {
  this.__url = requestElementsProvider.getSubstitutedUrl();
  this.__body = requestElementsProvider.getSubstitutedBody();

  this.url = function() {
    return __null_aware_to_string(this.__url.getValue())
  }

  this.body = function() {
    return __null_aware_to_string(this.__body.getValue())
  }

  this.environment = {
    __env: requestElementsProvider,
    get: function (name) {
      return __null_aware_to_string(this.__env.getEnvironmentVariable(name));
    }
  }

  this.variables = {
    __provider: requestElementsProvider,
    get: function (name) {
      return __null_aware_to_string(this.__provider.getSessionVariable(name))
    }
  }

  this.headers = {
    __headers: requestElementsProvider.getHeaders(),
    all: function () {
      const iterator = this.__headers.getValue().iterator()
      const result = []
      while (iterator.hasNext()) {
        let h = iterator.next()
        result.push(new RequestHeader(h));
      }
      return result;
    },
    findByName: function(name) {
      const result = this.__headers.getValue().getHeader(name)
      return result !== null ? new RequestHeader(result) : null
    }
  }

  this.method = '' + requestElementsProvider.getMethod()
}

const client = new HttpClient(__args.global, __args.cancelable)

let userVisibleBody
try {
  if (__args.isStreaming) {
    userVisibleBody = new TextStreamResponse(__args.linesSubscriberConsumer, __args.messagesSubscriberConsumer, __args.isJson)
  }
  else {
    userVisibleBody = __args.isJson ? JSON.parse(__args.responseBody) : __args.responseBody
  }
}
catch (e) {
  userVisibleBody = __args.responseBody
}

const response = {
  body: userVisibleBody,
  status: __args.statusCode,
  headers: new ResponseHeaders(__args.headers),
  contentType: new ContentType(__args.mimeType, __args.charset)
}

const request = new Request(__args.requestElementsProvider);

function ResponseHandlerErrorWrapper(error) {
  this.__wrappedError__ = error
}

function AssertionError(message) {
  this.__assertion_message__ = message
}