export function __null_aware_to_string(value) {
  return value != null ? "" + value : value
}

const __jsonPathSupport =  __args.jsonPathSupport

export function jsonPath(obj, path) {
  const result = __jsonPathSupport.applyJsonPath(JSON.stringify(obj), "" + path)
  return result
}

const __urlSearchParamsSupport = __args.urlSearchParamsSupport

export function URLSearchParams(options) {
  this.__delegate = __urlSearchParamsSupport(options)

  Object.defineProperty(this, "size", {
    get() {
      return this.__delegate.getSize()
    }
  })

  this.append = function (name, value) {
    this.__delegate.append('' + name, '' + value)
  }

  this.delete = function (name, value) {
    if (value === undefined) {
      value = null
    }
    this.__delegate.delete('' +name, __null_aware_to_string(value))
  }

  this.get = function (name) {
    return __null_aware_to_string(this.__delegate.get('' + name))
  }

  this.getAll = function (name) {
    let result = []
    for (let el of this.__delegate.getAll('' + name)) {
      result.push('' + el)
    }
    return result
  }

  this.has = function (name, value) {
    if (value === undefined) {
      value = null
    }
    return this.__delegate.has('' + name,  __null_aware_to_string(value))
  }

  this.set = function (name, value) {
    this.__delegate.set('' + name, '' + value)
  }

  this.sort = function () {
    this.__delegate.sort()
  }

  this.toString = function () {
    return '' + this.__delegate.toString()
  }

  // iteration
  this.entries = function () {
    const result = [];
    for (let el of this.__delegate.entries()) {
      result.push(['' + el.getFirst(), '' + el.getSecond()])
    }

    return result
  }

  this.keys = function () {
    const result = [];
    for (let [key, _] of this.entries()) {
      result.push(key);
    }
    return result
  }

  this.values = function () {
    const result = [];
    for (let [_, value] of this.entries()) {
      result.push(value);
    }
    return result;
  }

  this.forEach = function (callback) {
    for (let [key, value] of this.entries()) {
      callback(key, value, this)
    }
  }

  this[Symbol.iterator] = function () {
    return this.entries()[Symbol.iterator]()
  }
}

export function Variables(global) {
  this.vars = {}

  for (var key in global) {
    console.plain(`key: ${key}`)
    this.vars[key] = __null_aware_to_string(global[key])
  }

  this.set = function (varName, varValue) {
    this.vars[varName] = varValue
  }

  this.get = function (varName) {
    return this.vars[varName]
  }

  this.isEmpty = function () {
    return Object.keys(this.vars).length === 0
  }

  this.clear = function (varName) {
    delete this.vars[varName]
  }

  this.clearAll = function () {
    this.vars = {}
  }
};

export const __logPrinter = __args.logSupport;

export function __log() {
  const result = [];

  for (let arg of arguments) {
    console.plain(`__log: ${Object.prototype.toString.call(arg)}`)
    if (
      arg instanceof Object ||
      arg instanceof Array ||
      Object.prototype.toString.call(arg) === "[object JavaMap]" ||
      Object.prototype.toString.call(arg) === "[object JavaArray]" ||
      Object.prototype.toString.call(arg) === "[object JavaList]"
    ) {
      result.push([JSON.stringify(arg, null, 2), true])
    }
    else {
      result.push(['' + arg, false])
    }
  }

  __logPrinter(result)
};

export const console = {
  log: __log,
  plain: __args.plain
};

export const ExitException = Java.type('com.intellij.httpClient.http.request.run.HttpClientCommonJsHandler.ExitScriptException')
