import React from 'react';
import { Message } from './Message';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { MESSAGES_TEXT } from '../../constants';
export var Messages = function () {
    var asyncapi = useSpec();
    var config = useConfig();
    var messages = asyncapi.hasComponents() && asyncapi.components().messages();
    if (!messages || Object.keys(messages).length === 0) {
        return null;
    }
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('messages', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, MESSAGES_TEXT),
        React.createElement("ul", null, Object.entries(messages).map(function (_a, idx) {
            var messageName = _a[0], message = _a[1];
            return (React.createElement("li", { className: "mb-4", key: messageName, id: CommonHelpers.getIdentifier("message-".concat(messageName), config) },
                React.createElement(Message, { messageName: messageName, message: message, index: idx + 1, key: messageName })));
        }))));
};
//# sourceMappingURL=Messages.js.map