/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.ConfigMigrationUtil;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="fileTransfer")
public class FileTransferConfig
implements Cloneable {
    @NonNls
    public static final String FILE_TRANSFER_TAG = "fileTransfer";
    @NonNls
    public static final String ROOT_FOLDER_ATTRIBUTE = "rootFolder";
    @NonNls
    public static final String ANONYMOUS = "anonymous";
    @NonNls
    public static final String ANONYMOUS_EMAIL = "user@example.com";
    public static final int FTPS_EXPLICIT_PORT = 21;
    public static final int FTPS_IMPLICIT_PORT = 990;
    private static final Logger LOG = Logger.getInstance(FileTransferConfig.class);
    @Nullable
    private PresentableId mySshPresentableId;
    private String myHost;
    private String myLiteralPort;
    private int myPort;
    @NotNull
    private AuthType myAuthType;
    private String myPrivateKeyFile;
    private AccessType myAccessType;
    private AdvancedOptionsConfig myAdvancedOptions;
    private String myRootFolder;
    private String myMountedFolder;
    private boolean myFtpsExplicit;
    private boolean myAnonymous;
    @Deprecated
    @Attribute(value="username")
    @Nullable
    public String _serializedUserName;
    @Deprecated
    @Attribute(value="password")
    @Nullable
    public String _serializedPassword;
    @Deprecated
    @Attribute(value="passphrase")
    @Nullable
    public String _serializedPassphrase;

    public FileTransferConfig() {
        this((MutableRemoteCredentials)new RemoteCredentialsHolder());
    }

    public FileTransferConfig(@NotNull MutableRemoteCredentials credentials) {
        if (credentials == null) {
            FileTransferConfig.$$$reportNull$$$0(0);
        }
        this.myAccessType = AccessType.FTP;
        this.myAdvancedOptions = new AdvancedOptionsConfig();
        this.myRootFolder = this.myAccessType.getDefaultRootFolder();
        this.myMountedFolder = null;
        this.myFtpsExplicit = true;
        this.myAnonymous = false;
        this.setConfig(credentials.getHost(), credentials.getPort(), credentials.getLiteralPort(), credentials.getAuthType(), credentials.getPrivateKeyFile(), credentials.getConnectionConfigPatch());
    }

    private void setConfig(String host, int port, String literalPort, AuthType authType, String privateKeyFile, @Nullable SshConnectionConfigPatch connectionConfigPatch) {
        this.myHost = host;
        this.myPort = port;
        this.myLiteralPort = literalPort;
        this.myAuthType = authType;
        this.myPrivateKeyFile = privateKeyFile;
        if (connectionConfigPatch != null) {
            ConfigMigrationUtil.transfer(connectionConfigPatch, this.getAdvancedOptions());
        }
    }

    @Transient
    public boolean isConfiguredWithSshConfig() {
        return this.getSshPresentableId() != null;
    }

    @Deprecated
    @Attribute(value="sshConfig")
    @Nullable
    public String getSerializedSshConfigName() {
        return this.myAccessType == AccessType.SFTP && this.mySshPresentableId != null ? this.mySshPresentableId.getName() : null;
    }

    @Deprecated
    public void setSerializedSshConfigName(@Nullable String sshConfigName) {
        this.mySshPresentableId = PresentableId.createMergedName((PresentableId)this.mySshPresentableId, (String)sshConfigName);
    }

    @Deprecated
    @Attribute(value="sshConfigId")
    @Nullable
    public String getSerializedSshConfigId() {
        return this.myAccessType == AccessType.SFTP && this.mySshPresentableId != null ? this.mySshPresentableId.getId() : null;
    }

    @Deprecated
    public void setSerializedSshConfigId(@Nullable String sshConfigId) {
        this.mySshPresentableId = PresentableId.createMergedId((PresentableId)this.mySshPresentableId, (String)sshConfigId);
    }

    @Transient
    @Nullable
    public PresentableId getSshPresentableId() {
        return this.mySshPresentableId;
    }

    public void setSshConfig(@Nullable SshConfig config) {
        this.myAccessType = AccessType.SFTP;
        if (config == null) {
            this.setSshConfig(null, null);
        } else {
            this.mySshPresentableId = config.createPresentableId();
            this.setConfig(config.getHost(), config.getPort(), config.getLiteralPort(), config.getAuthType(), config.getKeyPath(), config.getConnectionConfigPatch());
        }
    }

    public void setSshConfig(@Nullable PresentableId presentableId, @Nullable SshConfig config) {
        if (config == null) {
            this.mySshPresentableId = presentableId;
            this.setConfig(null, 0, null, AuthType.PASSWORD, null, null);
        } else {
            this.setSshConfig(config);
        }
    }

    @Attribute(value="protocol")
    public String getSerializedProtocol() {
        return null;
    }

    public void setSerializedProtocol(String protocol) {
        this.setSerializedAccessType(protocol);
    }

    @Attribute(value="accessType")
    public String getSerializedAccessType() {
        return this.myAccessType.name();
    }

    public void setSerializedAccessType(String accessType) {
        try {
            this.myAccessType = AccessType.valueOf(accessType);
        }
        catch (IllegalArgumentException e) {
            this.myAccessType = AccessType.FTP;
        }
    }

    @Transient
    public AccessType getAccessType() {
        return this.myAccessType;
    }

    public void setAccessType(AccessType accessType) {
        this.myAccessType = accessType;
    }

    @Transient
    public String getHost() {
        return this.myHost;
    }

    public void setHost(String host) {
        this.myHost = host;
    }

    @Deprecated
    @Attribute(value="host")
    public String getSerializedHost() {
        return this.myHost;
    }

    @Deprecated
    public void setSerializedHost(String host) {
        this.myHost = host;
    }

    @Transient
    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
        this.myLiteralPort = String.valueOf(port);
    }

    @Transient
    public String getLiteralPort() {
        return this.myLiteralPort;
    }

    public void setLiteralPort(String port) {
        this.myLiteralPort = port;
        this.myPort = StringUtil.parseInt((String)port, (int)0);
    }

    @Deprecated
    @Attribute(value="port")
    public String getSerializedLiteralPort() {
        return this.myLiteralPort;
    }

    @Deprecated
    public void setSerializedLiteralPort(String port) {
        this.myLiteralPort = port;
        this.myPort = StringUtil.parseInt((String)port, (int)0);
    }

    @Attribute(value="anonymous")
    public boolean isAnonymous() {
        return this.myAnonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.myAnonymous = anonymous;
    }

    @Transient
    public String getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFile) {
        this.myPrivateKeyFile = privateKeyFile;
    }

    @Deprecated
    @Attribute(value="privateKey")
    public String getSerializedPrivateKeyFile() {
        return null;
    }

    @Deprecated
    public void setSerializedPrivateKeyFile(String privateKeyFile) {
        this.myPrivateKeyFile = privateKeyFile;
    }

    @Transient
    @NotNull
    public AuthType getAuthType() {
        AuthType authType = this.myAuthType;
        if (authType == null) {
            FileTransferConfig.$$$reportNull$$$0(1);
        }
        return authType;
    }

    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            FileTransferConfig.$$$reportNull$$$0(2);
        }
        this.myAuthType = authType;
    }

    @Deprecated
    @Attribute(value="keyPair")
    public boolean isSerializedUseKeyPair() {
        return this.getAuthType() == AuthType.KEY_PAIR;
    }

    @Deprecated
    public void setSerializedUseKeyPair(boolean useKeyPair) {
        if (useKeyPair) {
            this.setAuthType(AuthType.KEY_PAIR);
        } else if (this.getAuthType() == AuthType.KEY_PAIR) {
            this.setAuthType(AuthType.PASSWORD);
        }
    }

    @Deprecated
    @Attribute(value="authAgent")
    public boolean isSerializedUseAuthAgent() {
        return this.getAuthType() == AuthType.OPEN_SSH;
    }

    @Deprecated
    public void setSerializedUseAuthAgent(boolean useAuthAgent) {
        if (useAuthAgent) {
            this.setAuthType(AuthType.OPEN_SSH);
        } else if (this.getAuthType() == AuthType.OPEN_SSH) {
            this.setAuthType(AuthType.PASSWORD);
        }
    }

    @Tag(value="advancedOptions")
    public AdvancedOptionsConfig getAdvancedOptions() {
        return this.myAdvancedOptions;
    }

    public void setAdvancedOptions(AdvancedOptionsConfig advancedOptions) {
        this.myAdvancedOptions = advancedOptions;
    }

    @Attribute(value="rootFolder")
    public String getRootFolder() {
        return this.myRootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.myRootFolder = rootFolder;
    }

    @Attribute(value="mountedRoot")
    public String getMountedFolder() {
        return this.myMountedFolder;
    }

    public void setMountedFolder(String mountedFolder) {
        this.myMountedFolder = mountedFolder;
    }

    @Attribute(value="explicitFtps")
    public boolean isFtpsExplicit() {
        return this.myFtpsExplicit;
    }

    public void setFtpsExplicit(boolean value) {
        this.myFtpsExplicit = value;
    }

    protected FileTransferConfig clone() {
        try {
            FileTransferConfig clone = (FileTransferConfig)super.clone();
            clone.setAdvancedOptions(this.myAdvancedOptions == null ? null : this.myAdvancedOptions.clone());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String validateSlow(long timeout, boolean checkRootFolder) throws TimeoutException {
        return this.validateSlow(checkRootFolder, timeout);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String validateFast() {
        return this.validateFast(true);
    }

    @Nullable
    public ErrorMessageAndField validateUiFast() {
        return this.validateUiFast(true);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String validateFast(boolean checkRootFolder) {
        ErrorMessageAndField error = this.validateUiFast(checkRootFolder);
        return (String)Pair.getFirst((Pair)error);
    }

    @Nullable
    private ErrorMessageAndField validateUiFast(boolean checkRootFolder) {
        try {
            return this.validateUi(checkRootFolder, -1L, true);
        }
        catch (TimeoutException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    private String validateSlow(boolean checkRootFolder, long timeout) throws TimeoutException {
        ErrorMessageAndField error = this.validateUi(checkRootFolder, timeout, false);
        return (String)Pair.getFirst((Pair)error);
    }

    @Nullable
    private ErrorMessageAndField validateUi(boolean checkRootFolder, long timeout, boolean fast) throws TimeoutException {
        if (this.myAccessType == AccessType.LOCAL) {
            return null;
        }
        if (this.myAccessType == AccessType.MOUNT) {
            String message = this.validateMountFolder(timeout, fast);
            return message == null ? null : new ErrorMessageAndField(message, null);
        }
        ErrorMessageAndField credentialsResult = RemoteCredentialsVerifiableHolder.verify(this.myAccessType == AccessType.SFTP, this.myAccessType.getTitle(), fast, timeout, this.getHost(), this.getPort(), this.getAuthType(), this.getPrivateKeyFile());
        if (credentialsResult != null) {
            return credentialsResult;
        }
        if (checkRootFolder) {
            if (StringUtil.isEmptyOrSpaces((String)this.myRootFolder)) {
                return new ErrorMessageAndField(WDBundle.message("root.path.empty", new Object[0]), null);
            }
            if (!this.myRootFolder.startsWith("/")) {
                return new ErrorMessageAndField(WDBundle.message("root.path.invalid", new Object[0]), null);
            }
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    private String validateMountFolder(long timeout, boolean fast) throws TimeoutException {
        Object path = this.myMountedFolder;
        if (StringUtil.isEmpty((String)path)) {
            return WDBundle.message("mounted.folder.is.empty", new Object[0]);
        }
        if (SystemInfo.isWindows && ((String)path).length() == 2 && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            path = (String)path + "\\";
        }
        if (SystemInfo.isWindows && ((String)path).startsWith("\\\\") && !((String)path).startsWith("\\\\wsl$")) {
            return WDBundle.message("unc.path.not.supported", path);
        }
        if (((String)path).equals("\\")) {
            return WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)path));
        }
        if (!fast) {
            return (String)SshCredentialsVerifier.runWithTimeout((long)timeout, FileTransferConfig.getValidator((String)path));
        }
        return null;
    }

    private static Computable<@Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String> getValidator(String finalPath) {
        return () -> {
            File file = new File(finalPath);
            if (!file.isAbsolute()) {
                return WDBundle.message("mounted.folder.is.not.absolute", new Object[0]);
            }
            try {
                if (!file.getCanonicalFile().isDirectory()) {
                    return WDBundle.message("mounted.folder.not.found", FileUtil.toSystemDependentName((String)finalPath));
                }
            }
            catch (IOException e) {
                return WDBundle.message("mounted.folder.invalid", FileUtil.toSystemDependentName((String)finalPath), e.getMessage());
            }
            return null;
        };
    }

    @Nullable
    public String getNonBlockingWarnings() {
        if (this.myAccessType == AccessType.FTPS && this.getPort() == (this.myFtpsExplicit ? 990 : 21)) {
            return WDBundle.message("ftps.wrong.port.warning.message", new Object[0]);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTransferConfig that = (FileTransferConfig)o;
        return this.equalsNonAuthData(that);
    }

    public boolean equalsNonAuthData(FileTransferConfig that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        if (this.isAnonymous() != that.isAnonymous()) {
            return false;
        }
        if (this.getLiteralPort() != null ? !this.getLiteralPort().equals(that.getLiteralPort()) : that.getLiteralPort() != null) {
            return false;
        }
        if (this.getAuthType() != that.getAuthType()) {
            return false;
        }
        if (this.myAdvancedOptions != null ? !this.myAdvancedOptions.equals(that.myAdvancedOptions) : that.myAdvancedOptions != null) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(that.getHost()) : that.getHost() != null) {
            return false;
        }
        if (this.getPrivateKeyFile() != null ? !this.getPrivateKeyFile().equals(that.getPrivateKeyFile()) : that.getPrivateKeyFile() != null) {
            return false;
        }
        if (this.myAccessType != that.myAccessType) {
            return false;
        }
        if (this.myRootFolder != null ? !this.myRootFolder.equals(that.myRootFolder) : that.myRootFolder != null) {
            return false;
        }
        return !(this.myMountedFolder != null ? !this.myMountedFolder.equals(that.myMountedFolder) : that.myMountedFolder != null);
    }

    public int hashCode() {
        int result = this.myAccessType != null ? this.myAccessType.hashCode() : 0;
        result = 31 * result + (this.getHost() != null ? this.getHost().hashCode() : 0);
        result = 31 * result + (this.getLiteralPort() != null ? this.getLiteralPort().hashCode() : 0);
        result = 31 * result + (this.isAnonymous() ? 1 : 0);
        result = 31 * result + (this.getPrivateKeyFile() != null ? this.getPrivateKeyFile().hashCode() : 0);
        result = 31 * result + this.getAuthType().hashCode();
        result = 31 * result + (this.myAdvancedOptions != null ? this.myAdvancedOptions.hashCode() : 0);
        result = 31 * result + (this.myRootFolder != null ? this.myRootFolder.hashCode() : 0);
        result = 31 * result + (this.myMountedFolder != null ? this.myMountedFolder.hashCode() : 0);
        return result;
    }

    public String getDisplayName() {
        if (this.myAccessType.isProtocolBased()) {
            if (StringUtil.isEmpty((String)this.getHost())) {
                return WDBundle.message("host.undefined", new Object[0]);
            }
            return MessageFormat.format("{0}://{1}:{2}", this.myAccessType.getScheme(), this.getHost(), this.getLiteralPort());
        }
        return WDBundle.message("accessType.mount.title", new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getRootUri() {
        if (this.getAccessType().isProtocolBased()) {
            return this.getAccessType().getScheme() + "://" + this.getHost() + ":" + this.getLiteralPort() + "/";
        }
        @NonNls Object scheme = "file://";
        String localPath = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)this.getMountedFolder()));
        if (SystemInfo.isWindows && OSAgnosticPathUtil.startsWithWindowsDrive((String)localPath)) {
            scheme = (String)scheme + "/" + localPath.substring(0, 2) + "/";
            localPath = localPath.substring(2);
        }
        return (String)scheme + localPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/FileTransferConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/FileTransferConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum Origin {
        Unchanged,
        ForceRoot,
        Default;

    }
}

