/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowFactory;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowPanel;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class RemoteHostSelectInTarget
implements SelectInTarget,
DumbAware {
    public boolean canSelect(SelectInContext context) {
        if (context.getVirtualFile() instanceof RemoteVirtualFile) {
            return true;
        }
        return RemoteHostSelectInTarget.findDeployPath(context) != null;
    }

    public String toString() {
        return WDBundle.message("web.server.browser", new Object[0]);
    }

    @Nullable
    private static WebServerConfig.RemotePath findDeployPath(SelectInContext context) {
        return PublishActionUtil.findDeployPathFor(context.getVirtualFile(), context.getProject(), true);
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        String serverName;
        WebServerConfig.RemotePath deployPath;
        VirtualFile file = context.getVirtualFile();
        if (file instanceof RemoteVirtualFile) {
            RemoteVirtualFile remoteVirtualFile = (RemoteVirtualFile)file;
            deployPath = remoteVirtualFile.getRemotePath();
            serverName = remoteVirtualFile.getServerConfig().getName();
        } else {
            WebServerToolWindowPanel view;
            Content content = WebServerToolWindowFactory.getWebServerToolWindow(context.getProject()).getContentManager().getContent(0);
            WebServerToolWindowPanel webServerToolWindowPanel = view = content == null ? null : (WebServerToolWindowPanel)((Object)content.getComponent());
            if (view == null) {
                return;
            }
            serverName = view.getSelectedServerName();
            Pair<WebServerConfig, DeploymentPathMapping> mapping = PublishActionUtil.findMappingFor(file, Objects.requireNonNull(view.getSelectedServer()), PublishConfig.getInstance(context.getProject()), false);
            WebServerConfig.RemotePath remotePath = deployPath = mapping != null ? ((DeploymentPathMapping)mapping.getSecond()).mapToDeployPath(file.getPath(), (Mappable)view.getSelectedServer()) : null;
            if (serverName == null || deployPath == null) {
                serverName = PublishConfig.getInstance(context.getProject()).getDefaultServerOrGroupName();
                deployPath = RemoteHostSelectInTarget.findDeployPath(context);
            }
        }
        if (serverName == null || deployPath == null) {
            return;
        }
        ToolWindow toolWindow = WebServerToolWindowFactory.getWebServerToolWindow(context.getProject());
        String finalServerName = serverName;
        WebServerConfig.RemotePath finalDeployPath = deployPath;
        Runnable runnable = () -> {
            WebServerToolWindowPanel view;
            Content content = toolWindow.getContentManager().getContent(0);
            WebServerToolWindowPanel webServerToolWindowPanel = view = content == null ? null : (WebServerToolWindowPanel)((Object)((Object)content.getComponent()));
            if (view == null) {
                return;
            }
            view.selectInServerByName(context.getProject(), finalServerName, finalDeployPath);
        };
        if (requestFocus) {
            toolWindow.activate(runnable);
        } else {
            runnable.run();
        }
    }

    public String getToolWindowId() {
        return "Remote Host";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 2.0f;
    }
}

