/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploadAsyncFileListener;
import com.jetbrains.plugins.webDeployment.autoupload.MuteFilter;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@Service(value={Service.Level.PROJECT})
public final class AutoUploadComponent
implements Disposable {
    public static final Logger LOG = Logger.getInstance(AutoUploadComponent.class);
    private AutoUploadAsyncFileListener myListener;
    private final MuteHandler myMuteHandler = new MuteHandler();

    public static AutoUploadComponent getInstance(@NotNull Project project) {
        if (project == null) {
            AutoUploadComponent.$$$reportNull$$$0(0);
        }
        return (AutoUploadComponent)project.getService(AutoUploadComponent.class);
    }

    public void addOrRemoveListener(@NotNull Project project) {
        if (project == null) {
            AutoUploadComponent.$$$reportNull$$$0(1);
        }
        Pair<Boolean, List<WebServerConfig>> shouldBeListeningAndDefaultServers = AutoUploadComponent.getShouldBeListeningAndDefaultServers(project);
        if (((Boolean)shouldBeListeningAndDefaultServers.first).booleanValue()) {
            PublishConfig publishConfig = PublishConfig.getInstance(project).clone();
            List defaultServers = (List)shouldBeListeningAndDefaultServers.second;
            if (this.myListener == null) {
                this.myListener = new AutoUploadAsyncFileListener(project, publishConfig, defaultServers, this.myMuteHandler);
                LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.myListener);
                Disposer.register((Disposable)this, (Disposable)this.myListener);
            } else {
                this.myListener.setConfigs(publishConfig, defaultServers);
            }
            if (publishConfig.getAutoUploadState() == PublishConfig.AutoUploadState.ON_EXPLICIT_SAVE) {
                this.myListener.registerActionListener();
            } else {
                this.myListener.unregisterActionListener();
            }
        } else if (this.myListener != null) {
            Disposer.dispose((Disposable)this.myListener);
            this.myListener = null;
        }
    }

    @NotNull
    private static Pair<Boolean, List<WebServerConfig>> getShouldBeListeningAndDefaultServers(@NotNull Project project) {
        boolean shouldBeListening;
        if (project == null) {
            AutoUploadComponent.$$$reportNull$$$0(2);
        }
        if (project.isDisposed()) {
            Pair pair = Pair.create((Object)false, Collections.emptyList());
            if (pair == null) {
                AutoUploadComponent.$$$reportNull$$$0(3);
            }
            return pair;
        }
        List<Object> defaultServers = Collections.emptyList();
        PublishConfig publishConfig = PublishConfig.getInstance(project).clone();
        boolean bl = shouldBeListening = project.isOpen() && publishConfig.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER;
        if (shouldBeListening) {
            defaultServers = publishConfig.findValidDefaultTransferableServers();
            shouldBeListening = !defaultServers.isEmpty();
        }
        Pair pair = Pair.create((Object)shouldBeListening, defaultServers);
        if (pair == null) {
            AutoUploadComponent.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @NotNull
    public MuteLock mutePaths(@NotNull MuteFilter filter) {
        if (filter == null) {
            AutoUploadComponent.$$$reportNull$$$0(5);
        }
        MuteLock lock = new MuteLock();
        this.myMuteHandler.mutePaths(filter, lock);
        AutoUploadAsyncFileListener listener = this.myListener;
        if (listener != null) {
            listener.mutePaths(filter, lock);
        }
        MuteLock muteLock = lock;
        if (muteLock == null) {
            AutoUploadComponent.$$$reportNull$$$0(6);
        }
        return muteLock;
    }

    public void unmutePaths(@NotNull MuteLock lock) {
        if (lock == null) {
            AutoUploadComponent.$$$reportNull$$$0(7);
        }
        this.myMuteHandler.unmutePaths(lock);
        AutoUploadAsyncFileListener listener = this.myListener;
        if (listener != null) {
            this.myListener.unmutePaths(lock);
        }
    }

    public void dispose() {
    }

    public static void executeWriteActionSilently(@Nullable Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        ApplicationManager.getApplication().runWriteAction(() -> AutoUploadComponent.executeSilently(project, muteFilter, runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSilently(Project project, @NotNull MuteFilter muteFilter, Runnable runnable) {
        if (muteFilter == null) {
            AutoUploadComponent.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MuteLock lock = null;
        if (project != null && !project.isDisposed()) {
            lock = AutoUploadComponent.getInstance(project).mutePaths(muteFilter);
        }
        try {
            runnable.run();
        }
        finally {
            if (lock != null && !project.isDisposed()) {
                AutoUploadComponent.getInstance(project).unmutePaths(lock);
            }
        }
    }

    public static void saveDocumentsSilently(Project project, Change[] changes) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(changes), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Change change : changes) {
                Document document;
                VirtualFile file;
                ContentRevision contentRevision = change.getAfterRevision();
                if (contentRevision == null || (file = contentRevision.getFile().getVirtualFile()) == null || !file.isValid() || (document = mgr.getDocument(file)) == null) continue;
                mgr.saveDocument(document);
            }
        });
    }

    public static void saveDocumentsSilently(Project project, Collection<VirtualFile> roots) {
        AutoUploadComponent.executeWriteActionSilently(project, MuteFilter.create(roots), () -> {
            FileDocumentManager mgr = FileDocumentManager.getInstance();
            for (Document document : mgr.getUnsavedDocuments()) {
                VirtualFile file = mgr.getFile(document);
                if (file == null || !file.isValid()) continue;
                boolean save = false;
                for (VirtualFile root : roots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                    save = true;
                    break;
                }
                if (!save) continue;
                mgr.saveDocument(document);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lock";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "muteFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShouldBeListeningAndDefaultServers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mutePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addOrRemoveListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getShouldBeListeningAndDefaultServers";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mutePaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unmutePaths";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteActionSilently";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeSilently";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6 -> new IllegalStateException(string);
        };
    }

    public static class MuteHandler {
        private final Map<MuteLock, MuteFilter> myMutedPaths = new ConcurrentHashMap<MuteLock, MuteFilter>();

        public boolean isMuted(@NotNull String parentPath, String fileName) {
            if (parentPath == null) {
                MuteHandler.$$$reportNull$$$0(0);
            }
            return this.isMuted(parentPath + "/" + fileName);
        }

        public boolean isMuted(@NotNull String filePath) {
            if (filePath == null) {
                MuteHandler.$$$reportNull$$$0(1);
            }
            if (this.myMutedPaths.isEmpty()) {
                return false;
            }
            @SystemIndependent String unifiedPath = MuteFilter.getUnifiedPath(filePath);
            for (MuteFilter filter : this.myMutedPaths.values()) {
                if (!filter.isMuted(unifiedPath)) continue;
                return true;
            }
            return false;
        }

        public void mutePaths(@NotNull MuteFilter filter, @NotNull MuteLock lock) {
            if (filter == null) {
                MuteHandler.$$$reportNull$$$0(2);
            }
            if (lock == null) {
                MuteHandler.$$$reportNull$$$0(3);
            }
            this.myMutedPaths.put(lock, filter);
        }

        public void unmutePaths(@NotNull MuteLock lock) {
            if (lock == null) {
                MuteHandler.$$$reportNull$$$0(4);
            }
            this.myMutedPaths.remove(lock);
        }

        public void load(@Nullable MuteHandler handler) {
            if (handler != null) {
                this.myMutedPaths.putAll(handler.myMutedPaths);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lock";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/AutoUploadComponent$MuteHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMuted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mutePaths";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unmutePaths";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MuteLock {
        @NonNls
        public String toString() {
            return "MuteLock@" + Integer.toHexString(this.hashCode());
        }
    }

    static final class AutoUploadProjectManagerListener
    implements ProjectCloseListener {
        AutoUploadProjectManagerListener() {
        }

        public void projectClosed(@NotNull Project project) {
            AutoUploadComponent autoUploadComponent;
            if (project == null) {
                AutoUploadProjectManagerListener.$$$reportNull$$$0(0);
            }
            if ((autoUploadComponent = (AutoUploadComponent)project.getServiceIfCreated(AutoUploadComponent.class)) != null) {
                autoUploadComponent.addOrRemoveListener(project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$AutoUploadProjectManagerListener", "projectClosed"));
        }
    }

    static final class AutoUploadPostStartupActivity
    implements StartupActivity,
    DumbAware {
        AutoUploadPostStartupActivity() {
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                AutoUploadPostStartupActivity.$$$reportNull$$$0(0);
            }
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

                @Override
                public void optionsChanged() {
                    AutoUploadComponent.getInstance(project).addOrRemoveListener(project);
                }

                @Override
                public void excludedPathsChanged() {
                    AutoUploadComponent.getInstance(project).addOrRemoveListener(project);
                }
            });
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)AutoUploadComponent.getInstance(project)).subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, () -> AutoUploadComponent.getInstance(project).addOrRemoveListener(project));
            Boolean shouldListen = (Boolean)ReadAction.nonBlocking(() -> (Boolean)AutoUploadComponent.getShouldBeListeningAndDefaultServers((Project)project).first).executeSynchronously();
            if (shouldListen == Boolean.TRUE) {
                ReadAction.run(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    AutoUploadComponent.getInstance(project).addOrRemoveListener(project);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/AutoUploadComponent$AutoUploadPostStartupActivity", "runActivity"));
        }
    }
}

