/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.JSCachingFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.DirectoryItem;
import com.intellij.util.io.FileItem;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.IoKt;
import com.intellij.util.io.Item;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import io.netty.util.CharsetUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0000\u001a\u001c\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0001\u001a&\u0010$\u001a\u0004\u0018\u00010\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\b\u001a\u0012\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\bH\u0002\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a$\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020-H\u0002\u001a\u0010\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u0012\u0010/\u001a\u0004\u0018\u00010 2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u001a\u00100\u001a\u0004\u0018\u00010\f*\u00020\u001e2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u001a\u0014\u00101\u001a\u0004\u0018\u00010\u0001*\u0002022\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u00103\u001a\u00020 *\u00020\u001d\u001a\n\u00104\u001a\u000205*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"ASAR", "", "REFERENCE_LINE", "REFERENCE_PATTERN_FILE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REFERENCE_PATTERN_LINE", "canonicalizeUrl", "Lcom/intellij/util/Url;", "url", "baseUrl", "decodeLocalSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "path", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "decodeString", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "charBuffer", "Ljava/nio/CharBuffer;", "findSourceMap", "parsedUrl", "findSourceMapLocally", "script", "Lorg/jetbrains/debugger/Script;", "getSourceMapUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/file/Path;", "string", "", "pattern", "getStringFromDataUri", "dataUrl", "loadFromDataUri", "sourceMapUrl", "baseFileUrl", "loadRemoteSourceMapData", "regularFile", "tail", "channel", "Ljava/nio/channels/SeekableByteChannel;", "size", "", "offset", "tryLoad", "decodeSourceMap", "getSourceMapUrlFromAsar", "Lcom/intellij/util/io/AsarFileSystem;", "loadFile", "looksLikeInternalNodeScript", "", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nSourceMapLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapLoader.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapLoaderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,396:1\n1#2:397\n46#3,5:398\n*S KotlinDebug\n*F\n+ 1 SourceMapLoader.kt\ncom/intellij/javascript/debugger/sourcemap/SourceMapLoaderKt\n*L\n220#1:398,5\n*E\n"})
public final class SourceMapLoaderKt {
    @NotNull
    public static final String ASAR = ".asar/";
    @NotNull
    private static final String REFERENCE_LINE = "//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$";
    private static final Pattern REFERENCE_PATTERN_FILE = Pattern.compile("[\\r\\n]//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$");
    private static final Pattern REFERENCE_PATTERN_LINE = Pattern.compile("//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String getSourceMapUrlFromAsar(@NotNull AsarFileSystem $this$getSourceMapUrlFromAsar, @NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getSourceMapUrlFromAsar, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileItem fileItem = $this$getSourceMapUrlFromAsar.getFile(path);
        if (fileItem != null) {
            FileItem fileItem2 = fileItem;
            boolean bl = false;
            Closeable closeable = $this$getSourceMapUrlFromAsar.openFileChannel();
            Throwable throwable = null;
            try {
                SeekableByteChannel it = (SeekableByteChannel)closeable;
                boolean bl2 = false;
                CharSequence charSequence = SourceMapLoaderKt.tail(it, fileItem2.getSize(), fileItem2.getOffset());
                Pattern pattern = REFERENCE_PATTERN_LINE;
                Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
                String string2 = SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean looksLikeInternalNodeScript(@NotNull Url $this$looksLikeInternalNodeScript) {
        Intrinsics.checkNotNullParameter((Object)$this$looksLikeInternalNodeScript, (String)"<this>");
        if ($this$looksLikeInternalNodeScript.getScheme() == null && $this$looksLikeInternalNodeScript.getAuthority() == null && $this$looksLikeInternalNodeScript.getParameters() == null && !FileUtil.isAbsolutePlatformIndependent((String)$this$looksLikeInternalNodeScript.getPath())) {
            String string = $this$looksLikeInternalNodeScript.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) {
                String string2 = $this$looksLikeInternalNodeScript.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)string2, (String)".js", (boolean)false, (int)2, null)) return true;
            }
        }
        if (!Intrinsics.areEqual((Object)$this$looksLikeInternalNodeScript.getScheme(), (Object)"node")) return false;
        return true;
    }

    @Nullable
    public static final SourceMap findSourceMapLocally(@NotNull Script script, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        Path path;
        String url;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (SourceMapLoaderKt.looksLikeInternalNodeScript(script.getUrl())) {
            return null;
        }
        String string = ScriptDebuggerUrls.INSTANCE.toFilePath(script.getUrl());
        if (string == null) {
            return null;
        }
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)ASAR, (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            JSCachingFileFinder jSCachingFileFinder = debugProcess.getFinder();
            String string2 = scriptPath.substring(0, index + 5);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            AsarFileSystem asarFileSystem = jSCachingFileFinder.getAsarFs$intellij_javascript_debugger(string2, project);
            if (asarFileSystem != null) {
                AsarFileSystem fs = asarFileSystem;
                boolean bl = false;
                String string3 = scriptPath.substring(index + 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String scriptRelativePath = string3;
                String string4 = SourceMapLoaderKt.getSourceMapUrlFromAsar(fs, scriptRelativePath);
                if (string4 != null) {
                    SourceMap sourceMap;
                    String url2 = string4;
                    boolean bl2 = false;
                    if (((CharSequence)url2).length() == 0) {
                        return null;
                    }
                    if (URLUtil.isDataUri((String)url2)) {
                        return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url2);
                    }
                    if (FileUtil.isAbsolutePlatformIndependent((String)url2)) {
                        return SourceMapLoaderKt.decodeLocalSourceMap(url2, debugProcess);
                    }
                    String string5 = PathUtilRt.getParentPath((String)scriptRelativePath);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getParentPath(...)");
                    DirectoryItem directoryItem = fs.getDir(string5);
                    Item item = directoryItem != null ? directoryItem.findChild(url2) : null;
                    FileItem fileItem = item instanceof FileItem ? (FileItem)item : null;
                    if (fileItem != null) {
                        FileItem it = fileItem;
                        boolean bl3 = false;
                        CharSequence it2 = fs.loadText(it);
                        boolean bl4 = false;
                        sourceMap = debugProcess.decodeSourceMap(it2, script.getUrl(), true);
                    } else {
                        sourceMap = null;
                    }
                    return sourceMap;
                }
            }
        }
        if ((path2 = SourceMapLoaderKt.regularFile(scriptPath)) == null) {
            Path path3;
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(scriptPath, project);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                String string6 = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                path3 = SourceMapLoaderKt.regularFile(string6);
            } else {
                path3 = path2 = null;
            }
            if (path3 == null) {
                return null;
            }
        }
        if ((url = SourceMapLoaderKt.getSourceMapUrl(path = path2)) == null) {
            Path mapPath = path.getParent().resolve(path.getFileName() + ".map");
            if (Files.isRegularFile(mapPath, new LinkOption[0]) && Files.getLastModifiedTime(mapPath, new LinkOption[0]).toMillis() + (long)100 >= Files.getLastModifiedTime(path, new LinkOption[0]).toMillis()) {
                Intrinsics.checkNotNull((Object)mapPath);
                return debugProcess.decodeSourceMap(PathKt.readChars((Path)mapPath), script.getUrl(), true);
            }
            return null;
        }
        if (((CharSequence)url).length() == 0) {
            return null;
        }
        if (URLUtil.isDataUri((String)url)) {
            return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
        }
        Path path4 = path.getParent().resolve(url);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        return SourceMapLoaderKt.decodeSourceMap(path4, debugProcess);
    }

    private static final SourceMap decodeLocalSourceMap(String path, JavaScriptDebugProcess<?> debugProcess) {
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        return SourceMapLoaderKt.decodeSourceMap(path2, debugProcess);
    }

    private static final SourceMap decodeSourceMap(Path $this$decodeSourceMap, JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        if (Files.isRegularFile($this$decodeSourceMap, new LinkOption[0])) {
            Path path = $this$decodeSourceMap.normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
            CharSequence it = PathKt.readChars((Path)path);
            boolean bl = false;
            sourceMap = debugProcess.decodeSourceMap(it, Urls.newLocalFileUrl((String)((Object)$this$decodeSourceMap).toString()), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    private static final SourceMap loadFromDataUri(JavaScriptDebugProcess<?> debugProcess, Script script, String url) {
        SourceMap sourceMap;
        CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(url, script.getUrl());
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            sourceMap = debugProcess.decodeSourceMap(it, script.getUrl(), true);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    @Nullable
    public static final Path regularFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path it = Paths.get(path, new String[0]);
        boolean bl = false;
        return Files.isRegularFile(it, new LinkOption[0]) ? it : null;
    }

    @Nullable
    public static final SourceMap findSourceMap(@NotNull Url parsedUrl, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        SourceMap sourceMapFromLocalFile;
        String path;
        Intrinsics.checkNotNullParameter((Object)parsedUrl, (String)"parsedUrl");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        if (parsedUrl.isInLocalFileSystem() && (path = ScriptDebuggerUrls.INSTANCE.toFilePath(parsedUrl)) != null && (sourceMapFromLocalFile = SourceMapLoaderKt.decodeLocalSourceMap(path, debugProcess)) != null) {
            return sourceMapFromLocalFile;
        }
        if (BuiltInServerManager.Companion.getInstance().isOnBuiltInWebServer(parsedUrl) && (path = SourceMapLoaderKt.findSourceMap$findFile(debugProcess, parsedUrl, null)) != null) {
            String it = path;
            boolean bl = false;
            return it;
        }
        boolean isSchemeAcceptable = false;
        String sourceContent = null;
        if (Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"https")) {
            isSchemeAcceptable = true;
            CharSequence charSequence = SourceMapLoaderKt.loadRemoteSourceMapData(parsedUrl);
            String string = sourceContent = charSequence != null ? ((Object)charSequence).toString() : null;
        }
        if ((sourceMap = SourceMapLoaderKt.findSourceMap$findFile(debugProcess, parsedUrl, sourceContent)) != null) {
            SourceMap it = sourceMap;
            boolean bl = false;
            return it;
        }
        if (!isSchemeAcceptable && !parsedUrl.isInLocalFileSystem()) {
            CommandProcessorKt.getLOG().warn("Cannot load source map from '" + parsedUrl + "': scheme " + parsedUrl.getScheme() + " is not supported");
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static final CharSequence loadRemoteSourceMapData(Url parsedUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final CharSequence tryLoad(Url url) {
        CharSequence charSequence;
        CharSequence result;
        CharSequence charSequence2 = HttpRequests.request((Url)url).productNameAsUserAgent().tuner(arg_0 -> SourceMapLoaderKt.tryLoad$lambda$13(url, arg_0)).readChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"readChars(...)");
        CharSequence charSequence3 = result = charSequence2;
        if (charSequence3.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence3;
        }
        return charSequence;
    }

    @Nullable
    public static final String getStringFromDataUri(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        Matcher matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String string;
                String content = matcher.group(4);
                if (StringsKt.equals((String)";base64", (String)matcher.group(3), (boolean)true)) {
                    byte[] byArray = Base64.getDecoder().decode(content);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
                    byte[] byArray2 = byArray;
                    Charset charset = Charsets.UTF_8;
                    string = new String(byArray2, charset);
                } else {
                    string = content;
                }
                return string;
            }
            catch (IllegalArgumentException e) {
                CommandProcessorKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static final CharSequence loadFromDataUri(@NotNull String sourceMapUrl, @NotNull Url baseFileUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceMapUrl, (String)"sourceMapUrl");
        Intrinsics.checkNotNullParameter((Object)baseFileUrl, (String)"baseFileUrl");
        String string = baseFileUrl.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.endsWith$default((String)string, (String)"nodent.min.js", (boolean)false, (int)2, null)) {
            return null;
        }
        String sourceMapData = SourceMapLoaderKt.getStringFromDataUri(sourceMapUrl);
        if (sourceMapData == null) {
            String message = "Cannot decode sourcemap data URI " + baseFileUrl;
            CommandProcessorKt.getLOG().error(message);
            return null;
        }
        return ((CharSequence)sourceMapData).length() == 0 ? null : (CharSequence)sourceMapData;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return Urls.newFromEncoded((String)url);
        }
        return SourceResolverKt.doCanonicalize((String)url, (Url)baseUrl, (boolean)true, (boolean)false);
    }

    @NotNull
    public static final CharSequence loadFile(@NotNull VirtualFile $this$loadFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadFile, (String)"<this>");
        return IoKt.readCharSequence((Reader)new InputStreamReader($this$loadFile.getInputStream(), $this$loadFile.getCharset()), (int)((int)$this$loadFile.getLength()));
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        try {
            if (file2.isInLocalFileSystem()) {
                Path path = Paths.get(file2.getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return SourceMapLoaderKt.getSourceMapUrl(path);
            }
            CharSequence charSequence = SourceMapLoaderKt.loadFile(file2);
            Pattern pattern = REFERENCE_PATTERN_FILE;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_FILE");
            return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
        }
        catch (IOException e) {
            CommandProcessorKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CharSequence charSequence = SourceMapLoaderKt.tail(file2);
        Pattern pattern = REFERENCE_PATTERN_LINE;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
        return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
    }

    private static final String getSourceMapUrl(CharSequence string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(1) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final CharSequence tail(@NotNull Path file2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Closeable closeable = Files.newByteChannel(file2, new OpenOption[0]);
        Throwable throwable = null;
        try {
            SeekableByteChannel it = (SeekableByteChannel)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            charSequence = SourceMapLoaderKt.tail$default(it, (int)Files.size(file2), 0, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return charSequence;
    }

    private static final CharSequence tail(SeekableByteChannel channel, int size, int offset) {
        int bufferSize = Math.min(4096, size);
        boolean trim = true;
        StringBuilder stringBuilder = null;
        CharBuffer charBuffer = null;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        int position = offset + (size - bufferSize);
        while (position >= offset) {
            int n;
            channel.position(position);
            for (int count = 0; count < bufferSize && (n = channel.read(buffer)) > 0; count += n) {
            }
            for (int p = buffer.position() - 1; -1 < p; --p) {
                char c = (char)buffer.get(p);
                if (trim) {
                    if (c == '\n' || c == '\r' || c == ';' || c == ')' || c == '}') {
                        buffer.limit(p);
                        continue;
                    }
                    trim = false;
                }
                if (c != '\n') continue;
                buffer.position(p + 1);
                if (charBuffer == null) {
                    charBuffer = CharBuffer.allocate(buffer.remaining());
                }
                Intrinsics.checkNotNull((Object)buffer);
                CharBuffer charBuffer2 = charBuffer;
                Intrinsics.checkNotNull((Object)charBuffer2);
                SourceMapLoaderKt.decodeString(buffer, charBuffer2);
                StringBuilder stringBuilder2 = stringBuilder;
                return stringBuilder2 == null ? (CharSequence)charBuffer : (CharSequence)stringBuilder2.insert(0, charBuffer);
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(bufferSize * 2);
            }
            if (charBuffer == null) {
                charBuffer = CharBuffer.allocate(bufferSize);
            }
            buffer.position(0);
            Intrinsics.checkNotNull((Object)buffer);
            CharBuffer charBuffer3 = charBuffer;
            Intrinsics.checkNotNull((Object)charBuffer3);
            SourceMapLoaderKt.decodeString(buffer, charBuffer3);
            stringBuilder.insert(0, charBuffer);
            buffer.clear();
            charBuffer.clear();
            if (position == 0) break;
            if (position < bufferSize) {
                bufferSize = position;
                buffer.limit(position);
                position = 0;
                continue;
            }
            position -= bufferSize;
        }
        return null;
    }

    static /* synthetic */ CharSequence tail$default(SeekableByteChannel seekableByteChannel, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return SourceMapLoaderKt.tail(seekableByteChannel, n, n2);
    }

    private static final void decodeString(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)Charsets.UTF_8);
        CoderResult coderResult = decoder.decode(byteBuffer, charBuffer, true);
        if (!coderResult.isUnderflow()) {
            coderResult.throwException();
        }
        if (!(coderResult = decoder.flush(charBuffer)).isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
    }

    private static final SourceMap findSourceMap$findFile(JavaScriptDebugProcess<?> $debugProcess, Url $parsedUrl, String sourceContent) {
        String content = sourceContent;
        JSCachingFileFinder jSCachingFileFinder = $debugProcess.getFinder();
        Project project = $debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile sourceMapFile = jSCachingFileFinder.findFile($parsedUrl, project, false, sourceContent, null);
        if (sourceMapFile != null || sourceContent != null) {
            if (sourceContent == null) {
                VirtualFile virtualFile = sourceMapFile;
                Intrinsics.checkNotNull((Object)virtualFile);
                virtualFile.refresh(false, false);
                content = VfsUtil.loadText((VirtualFile)sourceMapFile);
            }
            VirtualFile virtualFile = sourceMapFile;
            Url baseUrl = virtualFile != null ? Urls.newLocalFileUrl((VirtualFile)virtualFile) : $parsedUrl;
            String string = content;
            Intrinsics.checkNotNull((Object)string);
            return $debugProcess.decodeSourceMap(string, baseUrl, true);
        }
        return null;
    }

    private static final void tryLoad$lambda$13(Url $url, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (BuiltInServerManager.Companion.getInstance().isOnBuiltInWebServer($url)) {
            it.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
        }
    }
}

