/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.javascript.debugger.coverage.WipCoverageEngine;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myWorkingDirectory", "", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "dereferenceBasePath", "file", "Ljava/io/File;", "getBaseDir", "getDataFileExtension", "getId", "getPresentableName", "loadCoverageData", "Lcom/intellij/rt/coverage/data/ProjectData;", "sessionDataFile", "baseCoverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "readProjectData", "dataFile", "basePath", "setWorkingDirectory", "", "workingDirectory", "intellij.javascript.debugger"})
public final class WipCoverageRunner
extends CoverageRunner {
    @NotNull
    private final Logger LOG;
    @Nullable
    private String myWorkingDirectory;

    public WipCoverageRunner() {
        Logger logger = Logger.getInstance(WipCoverageRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    public final void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    @Nullable
    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        File basePathDir = this.getBaseDir();
        try {
            return this.readProjectData(sessionDataFile, basePathDir);
        }
        catch (Exception e) {
            this.LOG.warn("Can't read coverage data", (Throwable)e);
            return null;
        }
    }

    private final File getBaseDir() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            string = ".";
        }
        String basePath = string;
        return new File(basePath);
    }

    private final ProjectData readProjectData(File dataFile, File basePath) throws IOException {
        ProjectData projectData = new ProjectData();
        LcovCoverageReport lcovCoverageReport = CoverageSerializationUtils.readLCOV((File)basePath, (File)dataFile);
        Intrinsics.checkNotNullExpressionValue((Object)lcovCoverageReport, (String)"readLCOV(...)");
        LcovCoverageReport report = lcovCoverageReport;
        String targetBaseDir = this.dereferenceBasePath(basePath);
        for (Map.Entry entry : report.getInfo().entrySet()) {
            String filePath = (String)entry.getKey();
            ClassData classData = projectData.getOrCreateClassData(filePath);
            int max = 0;
            List lineHitsList = (List)entry.getValue();
            if (lineHitsList.size() > 0) {
                LcovCoverageReport.LineHits lastLineHits = (LcovCoverageReport.LineHits)lineHitsList.get(lineHitsList.size() - 1);
                max = lastLineHits.getLineNumber();
            }
            LineData[] lines = new LineData[max + 1];
            for (LcovCoverageReport.LineHits lineHits : lineHitsList) {
                LineData lineData = new LineData(lineHits.getLineNumber(), null);
                lineData.setHits(lineHits.getHits());
                lines[lineHits.getLineNumber()] = lineData;
            }
            classData.setLines(lines);
            if (targetBaseDir == null) continue;
            Intrinsics.checkNotNull((Object)filePath);
            if (!StringsKt.startsWith$default((String)filePath, (String)targetBaseDir, (boolean)false, (int)2, null)) continue;
            String string = filePath.substring(targetBaseDir.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            File fileInsideBasePath = new File(basePath, string);
            ClassData classData2 = projectData.getOrCreateClassData(fileInsideBasePath.getAbsolutePath());
            classData2.setLines(lines);
        }
        return projectData;
    }

    private final String dereferenceBasePath(File file2) {
        String string = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String path = string;
        try {
            File canonicalFile = file2.getCanonicalFile();
            String string2 = FileUtil.toSystemIndependentName((String)canonicalFile.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
            String canonicalPath = string2;
            if (!Intrinsics.areEqual((Object)canonicalPath, (Object)path)) {
                return StringUtil.trimEnd((String)canonicalPath, (char)'/') + "/";
            }
        }
        catch (IOException e) {
            this.LOG.warn("Failed to dereference " + path, (Throwable)e);
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        return "WipPresentableName";
    }

    @NotNull
    public String getId() {
        return "WipCoverageRunner";
    }

    @NotNull
    public String getDataFileExtension() {
        return "dat";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof WipCoverageEngine;
    }
}

