/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileOffsetsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Url;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipStyleSheet;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.org.jetbrains.wip.WipCssManager;
import org.jetbrains.wip.protocol.css.RuleUsageValue;
import org.jetbrains.wip.protocol.profiler.CoverageRangeValue;
import org.jetbrains.wip.protocol.profiler.ScriptCoverageValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001GB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\fH\u0002J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0007J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020!0\u0007J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0007H\u0002J&\u0010$\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u000fH\u0002JV\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020-\u0018\u00010,2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00102\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014012\u0006\u00102\u001a\u0002032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J5\u00104\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0010062\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u00109JL\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00070;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010=\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0012\u0010\u001b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0002J\u001e\u0010>\u001a\u00020\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0010062\u0006\u0010?\u001a\u00020\u0010H\u0002J#\u0010@\u001a\u0004\u0018\u00010\f2\b\u0010A\u001a\u0004\u0018\u00010\f2\b\u0010B\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010CJ\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020&H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "cssExtensions", "", "", "append", "", "offset", "", "count", "result", "", "Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "computeLines", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport$LineHits;", "document", "Lcom/intellij/openapi/editor/Document;", "segments", "scriptStartLine", "scriptEndLine", "convertCoverageFormat", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/javascript/testFramework/coverage/LcovCoverageReport;", "jsDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "coverageResult", "Lorg/jetbrains/wip/protocol/profiler/ScriptCoverageValue;", "convertCssCoverageFormat", "Lorg/jetbrains/wip/protocol/css/RuleUsageValue;", "convertCssDataToSegments", "rules", "convertSegmentsOffsets", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptStartOffset", "convertToDisjointSegments", "ranges", "Lorg/jetbrains/wip/protocol/profiler/CoverageRangeValue;", "findNextValidMapping", "Lkotlin/Pair;", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mapping", "segment", "nullableSourcesCache", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "insertSegment", "sourceSegments", "Ljava/util/TreeSet;", "startOffsetInclusive", "endOffsetExclusive", "(Ljava/util/TreeSet;IILjava/lang/Integer;)V", "mapCoverage", "", "generatedSegments", "generatedDocument", "merge", "endSegment", "nullableMax", "a", "b", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;", "supportedExtension", "", "file", "CoverageSegment", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nWipCoverageReportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipCoverageReportProcessor.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n1747#2,3:411\n1477#2:414\n1502#2,3:415\n1505#2,3:425\n1238#2,4:440\n372#3,7:418\n372#3,7:431\n403#3:439\n13374#4,3:428\n1#5:438\n*S KotlinDebug\n*F\n+ 1 WipCoverageReportProcessor.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor\n*L\n98#1:411,3\n108#1:414\n108#1:415,3\n108#1:425,3\n218#1:440,4\n108#1:418,7\n199#1:431,7\n218#1:439\n180#1:428,3\n*E\n"})
public final class WipCoverageReportProcessor {
    @NotNull
    public static final WipCoverageReportProcessor INSTANCE = new WipCoverageReportProcessor();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> cssExtensions;

    private WipCoverageReportProcessor() {
    }

    @NotNull
    public final Promise<LcovCoverageReport> convertCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends ScriptCoverageValue> coverageResult) {
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        Vm vm = jsDebugProcess.getVm();
        Intrinsics.checkNotNull((Object)vm, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipVm");
        WipVm vm2 = (WipVm)vm;
        LcovCoverageReport lcov = new LcovCoverageReport();
        List promises = new ArrayList();
        for (ScriptCoverageValue scriptCoverageValue : coverageResult) {
            WipScript wipScript = (WipScript)vm2.getScriptManager().findScriptById(scriptCoverageValue.scriptId());
            if (wipScript == null) continue;
            Promise<VirtualFile> promise2 = VmScriptFileSystemKt.getVmFile((Script)wipScript).ensureDownloaded();
            promise2.onSuccess(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$0((Function1)new Function1<VirtualFile, Unit>(scriptCoverageValue, wipScript, jsDebugProcess, lcov){
                final /* synthetic */ ScriptCoverageValue $script;
                final /* synthetic */ WipScript $wipScript;
                final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $jsDebugProcess;
                final /* synthetic */ LcovCoverageReport $lcov;
                {
                    this.$script = $script;
                    this.$wipScript = $wipScript;
                    this.$jsDebugProcess = $jsDebugProcess;
                    this.$lcov = $lcov;
                    super(1);
                }

                public final void invoke(VirtualFile scriptFile) {
                    ReadAction.run(() -> convertCoverageFormat.1.invoke$lambda$1(this.$script, scriptFile, this.$wipScript, this.$jsDebugProcess, this.$lcov));
                }

                private static final Stream invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Stream)$tmp0.invoke(p0);
                }

                private static final void invoke$lambda$1(ScriptCoverageValue $script, VirtualFile $scriptFile, WipScript $wipScript, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov) {
                    Intrinsics.checkNotNullParameter((Object)$script, (String)"$script");
                    Intrinsics.checkNotNullParameter((Object)((Object)$jsDebugProcess), (String)"$jsDebugProcess");
                    Intrinsics.checkNotNullParameter((Object)$lcov, (String)"$lcov");
                    try {
                        List<R> list = $script.functions().stream().flatMap(arg_0 -> convertCoverageFormat.1.invoke$lambda$1$lambda$0(convertCoverageFormat.1.ranges.1.INSTANCE, arg_0)).toList();
                        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                        List ranges2 = CollectionsKt.toMutableList((Collection)list);
                        List segments2 = WipCoverageReportProcessor.access$convertToDisjointSegments(WipCoverageReportProcessor.INSTANCE, ranges2);
                        Document document = FileDocumentManager.getInstance().getDocument($scriptFile);
                        if (document == null) {
                            return;
                        }
                        int scriptStartLine = $wipScript.getLine();
                        int scriptEndLine = $wipScript.getEndLine();
                        int scriptStartOffset = document.getLineStartOffset(scriptStartLine) + $wipScript.getColumn();
                        Intrinsics.checkNotNull((Object)$scriptFile);
                        WipCoverageReportProcessor.access$convertSegmentsOffsets(WipCoverageReportProcessor.INSTANCE, segments2, $scriptFile, scriptStartOffset);
                        if ($wipScript.getSourceMap() != null) {
                            SourceMap sourceMap = $wipScript.getSourceMap();
                            Intrinsics.checkNotNull((Object)sourceMap);
                            Map coverageMap = WipCoverageReportProcessor.access$mapCoverage(WipCoverageReportProcessor.INSTANCE, segments2, document, sourceMap, $jsDebugProcess);
                            for (Map.Entry<K, V> entry : coverageMap.entrySet()) {
                                VirtualFile sourceFile;
                                Document sourceDocument = (Document)entry.getKey();
                                List sourceSegments = (List)entry.getValue();
                                Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile(sourceDocument));
                                try {
                                    if (!WipCoverageReportProcessor.access$supportedExtension(WipCoverageReportProcessor.INSTANCE, sourceFile)) continue;
                                    List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                                    $lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                                }
                                catch (Exception e) {
                                    WipCoverageReportProcessor.access$getLOG$p().debug("Failed to process coverage for " + $wipScript.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                                }
                            }
                        }
                        if (!($scriptFile instanceof LightVirtualFile) && WipCoverageReportProcessor.access$supportedExtension(WipCoverageReportProcessor.INSTANCE, $scriptFile)) {
                            List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, document, segments2, scriptStartLine, scriptEndLine);
                            $lcov.mergeFileReport(null, $scriptFile.getPath(), lines);
                        }
                    }
                    catch (Exception e) {
                        WipCoverageReportProcessor.access$getLOG$p().debug("Failed to process coverage for " + $wipScript.getUrl() + ". Matched file: " + $scriptFile.getPath() + ".\n" + e.getMessage());
                    }
                }
            }, arg_0));
            promises.add(promise2);
        }
        Promise promise2 = Promises.all((Collection)promises, null, (boolean)true).then(arg_0 -> WipCoverageReportProcessor.convertCoverageFormat$lambda$1(new Function1(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;
            {
                this.$lcov = $lcov;
                super(1);
            }

            public final LcovCoverageReport invoke(@Nullable Void it) {
                return this.$lcov;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final boolean supportedExtension(VirtualFile file2) {
        boolean bl;
        block3: {
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path = string;
            Iterable $this$any$iv = cssExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<LcovCoverageReport> convertCssCoverageFormat(@NotNull JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, @NotNull List<? extends RuleUsageValue> coverageResult) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(jsDebugProcess, (String)"jsDebugProcess");
        Intrinsics.checkNotNullParameter(coverageResult, (String)"coverageResult");
        LcovCoverageReport lcov = new LcovCoverageReport();
        List promises = new ArrayList();
        Iterable $this$groupBy$iv = coverageResult;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            RuleUsageValue p0 = (RuleUsageValue)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = p0.styleSheetId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            VirtualFile file2;
            String styleSheetId = (String)entry.getKey();
            List rules = (List)entry.getValue();
            WipCssManager wipCssManager = jsDebugProcess.getCssManager();
            Intrinsics.checkNotNull((Object)wipCssManager);
            WipStyleSheet styleSheet = wipCssManager.getIdToStyleSheet().get(styleSheetId);
            if (styleSheet == null) continue;
            VirtualFile virtualFile = file2 = JavaScriptDebugProcess.findFile$default(jsDebugProcess, styleSheet.getUrl(), false, null, 4, null);
            Promise promise2 = virtualFile == null ? Promises.rejectedPromise() : Promises.resolvedPromise((Object)virtualFile);
            promise2.onSuccess(arg_0 -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$3((Function1)new Function1<VirtualFile, Unit>((List<? extends RuleUsageValue>)rules, styleSheet, jsDebugProcess, lcov){
                final /* synthetic */ List<RuleUsageValue> $rules;
                final /* synthetic */ WipStyleSheet $styleSheet;
                final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $jsDebugProcess;
                final /* synthetic */ LcovCoverageReport $lcov;
                {
                    this.$rules = $rules;
                    this.$styleSheet = $styleSheet;
                    this.$jsDebugProcess = $jsDebugProcess;
                    this.$lcov = $lcov;
                    super(1);
                }

                public final void invoke(VirtualFile scriptFile) {
                    ReadAction.run(() -> convertCssCoverageFormat.2.invoke$lambda$0(this.$rules, scriptFile, this.$styleSheet, this.$jsDebugProcess, this.$lcov));
                }

                private static final void invoke$lambda$0(List $rules, VirtualFile $scriptFile, WipStyleSheet $styleSheet, JavaScriptDebugProcess $jsDebugProcess, LcovCoverageReport $lcov) {
                    Intrinsics.checkNotNullParameter((Object)$rules, (String)"$rules");
                    Intrinsics.checkNotNullParameter((Object)((Object)$jsDebugProcess), (String)"$jsDebugProcess");
                    Intrinsics.checkNotNullParameter((Object)$lcov, (String)"$lcov");
                    try {
                        List segments2 = WipCoverageReportProcessor.access$convertCssDataToSegments(WipCoverageReportProcessor.INSTANCE, $rules);
                        Document document = FileDocumentManager.getInstance().getDocument($scriptFile);
                        if (document == null) {
                            return;
                        }
                        int scriptStartLine = 0;
                        int scriptEndLine = document.getLineCount();
                        Intrinsics.checkNotNull((Object)$scriptFile);
                        WipCoverageReportProcessor.access$convertSegmentsOffsets(WipCoverageReportProcessor.INSTANCE, segments2, $scriptFile, 0);
                        if ($styleSheet.getSourceMap() != null) {
                            SourceMap sourceMap = $styleSheet.getSourceMap();
                            Intrinsics.checkNotNull((Object)sourceMap);
                            Map coverageMap = WipCoverageReportProcessor.access$mapCoverage(WipCoverageReportProcessor.INSTANCE, segments2, document, sourceMap, $jsDebugProcess);
                            for (Map.Entry<K, V> entry : coverageMap.entrySet()) {
                                VirtualFile sourceFile;
                                Document sourceDocument = (Document)entry.getKey();
                                List sourceSegments = (List)entry.getValue();
                                Intrinsics.checkNotNull((Object)FileDocumentManager.getInstance().getFile(sourceDocument));
                                try {
                                    List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, sourceDocument, sourceSegments, 0, sourceDocument.getLineCount());
                                    $lcov.mergeFileReport(null, sourceFile.getPath(), lines);
                                }
                                catch (Exception e) {
                                    WipCoverageReportProcessor.access$getLOG$p().debug("Failed to process coverage for " + $styleSheet.getUrl() + ". Mapped file: " + sourceFile.getPath() + ".\n" + e.getMessage());
                                }
                            }
                        }
                        if (!($scriptFile instanceof LightVirtualFile)) {
                            List lines = WipCoverageReportProcessor.access$computeLines(WipCoverageReportProcessor.INSTANCE, document, segments2, scriptStartLine, scriptEndLine);
                            $lcov.mergeFileReport(null, $scriptFile.getPath(), lines);
                        }
                    }
                    catch (Exception e) {
                        WipCoverageReportProcessor.access$getLOG$p().debug("Failed to process coverage for " + $styleSheet + ". Matched file: " + $scriptFile.getPath() + ".\n" + e.getMessage());
                    }
                }
            }, arg_0));
            promises.add(promise2);
        }
        Promise promise3 = Promises.all((Collection)promises, null, (boolean)true).then(arg_0 -> WipCoverageReportProcessor.convertCssCoverageFormat$lambda$4(new Function1(lcov){
            final /* synthetic */ LcovCoverageReport $lcov;
            {
                this.$lcov = $lcov;
                super(1);
            }

            public final LcovCoverageReport invoke(@Nullable Void it) {
                return this.$lcov;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(...)");
        return promise3;
    }

    private final List<CoverageSegment> convertCssDataToSegments(List<? extends RuleUsageValue> rules) {
        List<Object> list = rules.stream().flatMap(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$5(convertCssDataToSegments.segments.1.INSTANCE, arg_0)).sorted(Comparator.comparing(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$6((Function1)convertCssDataToSegments.segments.2.INSTANCE, arg_0))).filter(arg_0 -> WipCoverageReportProcessor.convertCssDataToSegments$lambda$7(convertCssDataToSegments.segments.3.INSTANCE, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        List segments2 = CollectionsKt.toMutableList((Collection)list);
        return segments2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Document, List<CoverageSegment>> mapCoverage(List<CoverageSegment> generatedSegments, Document generatedDocument, SourceMap sourceMap, JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess) {
        Object object;
        Object object2;
        String string;
        int currentOffset = 0;
        Map coverageMap = new LinkedHashMap();
        Map nullableSourcesCache = new LinkedHashMap();
        Url[] $this$forEachIndexed$iv = sourceMap.getSources();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Url item$iv : $this$forEachIndexed$iv) {
            Document document;
            void url;
            int n = index$iv++;
            Url url2 = item$iv;
            int i = n;
            boolean bl = false;
            Map map = nullableSourcesCache;
            Integer n2 = i;
            if (JavaScriptDebugProcess.findFile$default(jsDebugProcess, (Url)url, false, null, 4, null) != null) {
                VirtualFile it;
                boolean bl2 = false;
                document = FileDocumentManager.getInstance().getDocument(it);
            } else {
                document = null;
            }
            Document document2 = document;
            map.put(n2, document2);
        }
        for (CoverageSegment segment : generatedSegments) {
            block15: {
                Object mapping = null;
                try {
                    Pair<Document, MappingEntry> nextMapping;
                    do {
                        if ((nextMapping = this.findNextValidMapping((MappingEntry)mapping, currentOffset, segment, nullableSourcesCache, sourceMap, generatedDocument)) != null) {
                            Object object3;
                            Pair<Document, MappingEntry> it;
                            boolean bl = false;
                            Document sourceDocument = (Document)it.getFirst();
                            Object object4 = mapping = it.getSecond();
                            Intrinsics.checkNotNull((Object)object4);
                            MappingEntry currentMapping = (MappingEntry)object4;
                            currentOffset = generatedDocument.getLineStartOffset(currentMapping.getGeneratedLine()) + currentMapping.getGeneratedColumn();
                            Mappings mappings = sourceMap.findSourceMappings(currentMapping.getSource());
                            Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                            MappingList mappings2 = (MappingList)mappings;
                            Map $this$getOrPut$iv = coverageMap;
                            boolean $i$f$getOrPut = false;
                            Object value$iv = $this$getOrPut$iv.get(sourceDocument);
                            if (value$iv == null) {
                                boolean bl3 = false;
                                TreeSet answer$iv = new TreeSet(new Comparator(){

                                    public final int compare(T a, T b) {
                                        CoverageSegment p0 = (CoverageSegment)a;
                                        boolean bl = false;
                                        Comparable comparable = Integer.valueOf(p0.getEndOffsetExclusive());
                                        p0 = (CoverageSegment)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getEndOffsetExclusive()));
                                    }
                                });
                                $this$getOrPut$iv.put(sourceDocument, answer$iv);
                                object3 = answer$iv;
                            } else {
                                object3 = value$iv;
                            }
                            TreeSet sourceSegments = (TreeSet)object3;
                            int lineStartOffset = sourceDocument.getLineStartOffset(mappings2.getLine(currentMapping));
                            int sourceEndOffset = mappings2.getEndOffset(currentMapping, lineStartOffset, sourceDocument);
                            if (sourceEndOffset == sourceDocument.getLineEndOffset(mappings2.getLine(currentMapping))) {
                                ++sourceEndOffset;
                            }
                            INSTANCE.insertSegment(sourceSegments, lineStartOffset + mappings2.getColumn(currentMapping), sourceEndOffset, segment.getCount());
                        }
                    } while (nextMapping != null && currentOffset < segment.getEndOffsetExclusive());
                }
                catch (IndexOutOfBoundsException e) {
                    MappingEntry it;
                    Url url;
                    Logger logger = LOG;
                    String string2 = e.getMessage();
                    if ((MappingEntry)mapping != null) {
                        string = string2;
                        object2 = logger;
                        boolean bl = false;
                        Url[] urlArray = sourceMap.getSources();
                        Object object5 = mapping;
                        Intrinsics.checkNotNull(object5);
                        object = urlArray[((MappingEntry)object5).getSource()];
                        logger = object2;
                        string2 = string;
                        url = object;
                    } else {
                        url = null;
                    }
                    logger.debug(string2 + "\nurl: " + url + ", segment: " + segment);
                    if ((MappingEntry)mapping == null) break block15;
                    boolean bl = false;
                    if ((Document)nullableSourcesCache.get(it.getSource()) != null) {
                        Document it2;
                        boolean bl4 = false;
                        TreeSet cfr_ignored_0 = (TreeSet)coverageMap.remove(it2);
                    }
                }
            }
            currentOffset = segment.getEndOffsetExclusive();
        }
        Map result = new LinkedHashMap();
        Map $this$mapValuesTo$iv = coverageMap;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv;
            Map map = result;
            boolean bl5 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            string = it$iv.getKey();
            object2 = map;
            boolean bl6 = false;
            TreeSet segments2 = (TreeSet)entry.getValue();
            object = new ArrayList(segments2);
            object2.put(string, object);
        }
        return result;
    }

    private final Pair<Document, MappingEntry> findNextValidMapping(MappingEntry mapping, int offset, CoverageSegment segment, Map<Integer, Document> nullableSourcesCache, SourceMap sourceMap, Document document) {
        Pair pair;
        int currentOffset = offset;
        MappingEntry nextMapping = mapping;
        Document sourceDocument = null;
        while (sourceDocument == null && currentOffset < segment.getEndOffsetExclusive()) {
            if (nextMapping == null) {
                int generatedLine = document.getLineNumber(currentOffset);
                int generatedColumn = currentOffset - document.getLineStartOffset(generatedLine);
                nextMapping = sourceMap.getGeneratedMappings().get(generatedLine, generatedColumn);
                if (nextMapping == null) {
                    if (currentOffset + 1 >= segment.getEndOffsetExclusive()) break;
                    ++currentOffset;
                }
            } else {
                if (nextMapping.getNextGenerated() == null) break;
                currentOffset = document.getLineStartOffset(nextMapping.getGeneratedLine()) + nextMapping.getGeneratedColumn();
            }
            if (nextMapping == null || nextMapping.getSourceLine() < 0 || currentOffset >= segment.getEndOffsetExclusive()) continue;
            sourceDocument = nullableSourcesCache.get(nextMapping.getSource());
        }
        if (sourceDocument == null) {
            pair = null;
        } else {
            MappingEntry mappingEntry = nextMapping;
            Intrinsics.checkNotNull((Object)mappingEntry);
            pair = new Pair(sourceDocument, (Object)mappingEntry);
        }
        return pair;
    }

    private final void convertSegmentsOffsets(List<CoverageSegment> segments2, VirtualFile scriptFile, int scriptStartOffset) {
        FileOffsetsManager fileOffsetsManager = FileOffsetsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileOffsetsManager, (String)"getInstance(...)");
        FileOffsetsManager offsetManager = fileOffsetsManager;
        for (CoverageSegment segment : segments2) {
            segment.setEndOffsetExclusive(scriptFile instanceof LightVirtualFile ? scriptStartOffset + segment.getEndOffsetExclusive() : offsetManager.getConvertedOffset(scriptFile, scriptStartOffset + segment.getEndOffsetExclusive()));
        }
    }

    private final void insertSegment(TreeSet<CoverageSegment> sourceSegments, int startOffsetInclusive, int endOffsetExclusive, Integer count) {
        CoverageSegment segment;
        CoverageSegment coverageSegment = segment = sourceSegments.higher(new CoverageSegment(startOffsetInclusive, null));
        CoverageSegment startSegment = new CoverageSegment(startOffsetInclusive, coverageSegment != null ? coverageSegment.getCount() : null);
        CoverageSegment endSegment = new CoverageSegment(endOffsetExclusive, count);
        if (segment == null) {
            if (startOffsetInclusive != 0 && !sourceSegments.contains(startSegment)) {
                sourceSegments.add(startSegment);
            }
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
            return;
        }
        if (startOffsetInclusive != 0 && Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count)) && !sourceSegments.contains(startSegment)) {
            sourceSegments.add(startSegment);
        }
        if (segment.getEndOffsetExclusive() == endOffsetExclusive) {
            segment.setCount(this.nullableMax(segment.getCount(), count));
            this.merge(sourceSegments, segment);
        } else if (Intrinsics.areEqual((Object)count, (Object)this.nullableMax(segment.getCount(), count))) {
            sourceSegments.add(endSegment);
            this.merge(sourceSegments, endSegment);
        }
    }

    private final void merge(TreeSet<CoverageSegment> sourceSegments, CoverageSegment endSegment) {
        CoverageSegment prev = sourceSegments.lower(endSegment);
        CoverageSegment current = sourceSegments.floor(endSegment);
        CoverageSegment coverageSegment = prev;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment != null ? coverageSegment.getCount() : null)) && prev != null) {
            sourceSegments.remove(prev);
        }
        CoverageSegment next = sourceSegments.higher(endSegment);
        CoverageSegment coverageSegment2 = next;
        if (Intrinsics.areEqual((Object)current.getCount(), (Object)(coverageSegment2 != null ? coverageSegment2.getCount() : null))) {
            sourceSegments.remove(current);
        }
    }

    private final List<CoverageSegment> convertToDisjointSegments(List<CoverageRangeValue> ranges2) {
        Function1[] function1Array = new Function1[]{convertToDisjointSegments.1.INSTANCE, convertToDisjointSegments.2.INSTANCE};
        CollectionsKt.sortWith(ranges2, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        List result = new ArrayList();
        LinkedList<CoverageRangeValue> stack = new LinkedList<CoverageRangeValue>();
        for (CoverageRangeValue entry : ranges2) {
            CoverageRangeValue top = (CoverageRangeValue)stack.peek();
            while (top != null && top.getEndOffset() <= entry.getStartOffset()) {
                this.append(top.getEndOffset() + 1, top.getCount(), result);
                stack.pop();
                top = (CoverageRangeValue)stack.peek();
            }
            if (top != null) {
                this.append(entry.getStartOffset(), top.getCount(), result);
            }
            stack.push(entry);
        }
        while (!stack.isEmpty()) {
            CoverageRangeValue top = (CoverageRangeValue)stack.pop();
            this.append(top.getEndOffset() + 1, top.getCount(), result);
        }
        return result;
    }

    private final void append(int offset, int count, List<CoverageSegment> result) {
        if (!((Collection)result).isEmpty()) {
            CoverageSegment last = (CoverageSegment)CollectionsKt.last(result);
            if (last.getEndOffsetExclusive() == offset) {
                return;
            }
            Integer n = last.getCount();
            int n2 = count;
            if (n != null && n == n2) {
                last.setEndOffsetExclusive(offset);
                return;
            }
        }
        result.add(new CoverageSegment(offset, count));
    }

    private final List<LcovCoverageReport.LineHits> computeLines(Document document, List<CoverageSegment> segments2, int scriptStartLine, int scriptEndLine) {
        List lines = new ArrayList(scriptEndLine - scriptStartLine);
        int currentLine = scriptStartLine;
        ListIterator<CoverageSegment> listIterator = segments2.listIterator();
        CoverageSegment segment = null;
        while (listIterator.hasNext()) {
            segment = listIterator.next();
            int inclusiveEnd = segment.getEndOffsetExclusive() - 1;
            int segmentEndLine = document.getLineNumber(inclusiveEnd);
            if (segment.getCount() != null) {
                for (int line = currentLine; line < segmentEndLine; ++line) {
                    Integer n = segment.getCount();
                    Intrinsics.checkNotNull((Object)n);
                    lines.add(new LcovCoverageReport.LineHits(line + 1, n.intValue()));
                }
            }
            Integer endLineHits = segment.getCount();
            while (inclusiveEnd < document.getLineEndOffset(segmentEndLine) && listIterator.hasNext()) {
                segment = listIterator.next();
                inclusiveEnd = segment.getEndOffsetExclusive() - 1;
                endLineHits = this.nullableMax(endLineHits, segment.getCount());
            }
            if (inclusiveEnd > document.getLineEndOffset(segmentEndLine)) {
                listIterator.previous();
            }
            if (endLineHits != null) {
                lines.add(new LcovCoverageReport.LineHits(segmentEndLine + 1, endLineHits.intValue()));
            }
            currentLine = segmentEndLine + 1;
        }
        return lines;
    }

    private final Integer nullableMax(Integer a, Integer b) {
        Integer n;
        if (a == null) {
            n = b;
        } else if (b == null) {
            n = a;
        } else {
            int n2 = a;
            int n3 = b;
            n = Math.max(n2, n3);
        }
        return n;
    }

    private static final void convertCoverageFormat$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LcovCoverageReport convertCoverageFormat$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LcovCoverageReport)$tmp0.invoke(p0);
    }

    private static final void convertCssCoverageFormat$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final LcovCoverageReport convertCssCoverageFormat$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LcovCoverageReport)$tmp0.invoke(p0);
    }

    private static final Stream convertCssDataToSegments$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    private static final Integer convertCssDataToSegments$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final boolean convertCssDataToSegments$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$convertToDisjointSegments(WipCoverageReportProcessor $this, List ranges2) {
        return $this.convertToDisjointSegments(ranges2);
    }

    public static final /* synthetic */ void access$convertSegmentsOffsets(WipCoverageReportProcessor $this, List segments2, VirtualFile scriptFile, int scriptStartOffset) {
        $this.convertSegmentsOffsets(segments2, scriptFile, scriptStartOffset);
    }

    public static final /* synthetic */ Map access$mapCoverage(WipCoverageReportProcessor $this, List generatedSegments, Document generatedDocument, SourceMap sourceMap, JavaScriptDebugProcess jsDebugProcess) {
        return $this.mapCoverage(generatedSegments, generatedDocument, sourceMap, jsDebugProcess);
    }

    public static final /* synthetic */ boolean access$supportedExtension(WipCoverageReportProcessor $this, VirtualFile file2) {
        return $this.supportedExtension(file2);
    }

    public static final /* synthetic */ List access$computeLines(WipCoverageReportProcessor $this, Document document, List segments2, int scriptStartLine, int scriptEndLine) {
        return $this.computeLines(document, segments2, scriptStartLine, scriptEndLine);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ List access$convertCssDataToSegments(WipCoverageReportProcessor $this, List rules) {
        return $this.convertCssDataToSegments(rules);
    }

    static {
        Logger logger = Logger.getInstance(WipCoverageReportProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"css", "sass", "less", "styl"};
        cssExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\n\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "", "endOffsetExclusive", "", "count", "(ILjava/lang/Integer;)V", "getCount", "()Ljava/lang/Integer;", "setCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getEndOffsetExclusive", "()I", "setEndOffsetExclusive", "(I)V", "component1", "component2", "copy", "(ILjava/lang/Integer;)Lcom/intellij/javascript/debugger/coverage/WipCoverageReportProcessor$CoverageSegment;", "equals", "", "other", "hashCode", "toString", "", "intellij.javascript.debugger"})
    public static final class CoverageSegment {
        private int endOffsetExclusive;
        @Nullable
        private Integer count;

        public CoverageSegment(int endOffsetExclusive, @Nullable Integer count) {
            this.endOffsetExclusive = endOffsetExclusive;
            this.count = count;
        }

        public final int getEndOffsetExclusive() {
            return this.endOffsetExclusive;
        }

        public final void setEndOffsetExclusive(int n) {
            this.endOffsetExclusive = n;
        }

        @Nullable
        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(@Nullable Integer n) {
            this.count = n;
        }

        public final int component1() {
            return this.endOffsetExclusive;
        }

        @Nullable
        public final Integer component2() {
            return this.count;
        }

        @NotNull
        public final CoverageSegment copy(int endOffsetExclusive, @Nullable Integer count) {
            return new CoverageSegment(endOffsetExclusive, count);
        }

        public static /* synthetic */ CoverageSegment copy$default(CoverageSegment coverageSegment, int n, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = coverageSegment.endOffsetExclusive;
            }
            if ((n3 & 2) != 0) {
                n2 = coverageSegment.count;
            }
            return coverageSegment.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "CoverageSegment(endOffsetExclusive=" + this.endOffsetExclusive + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.endOffsetExclusive);
            result = result * 31 + (this.count == null ? 0 : ((Object)this.count).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoverageSegment)) {
                return false;
            }
            CoverageSegment coverageSegment = (CoverageSegment)other;
            if (this.endOffsetExclusive != coverageSegment.endOffsetExclusive) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.count, (Object)coverageSegment.count);
        }
    }
}

