/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.coverage.WipCoverageProgramRunner;
import com.intellij.javascript.debugger.coverage.WipCoverageReportProcessor;
import com.intellij.javascript.debugger.coverage.WipCoverageRunner;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugRunner;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.javascript.testFramework.coverage.CoverageSerializationUtils;
import com.intellij.javascript.testFramework.coverage.LcovCoverageReport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.org.jetbrains.wip.WipCssManager;
import org.jetbrains.wip.protocol.css.CSSKt;
import org.jetbrains.wip.protocol.css.TakeCoverageDeltaResult;
import org.jetbrains.wip.protocol.profiler.ProfilerKt;
import org.jetbrains.wip.protocol.profiler.TakePreciseCoverageResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u001a\u001a\u00020\u00042\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00122\u0010\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&H\u0002J\u0018\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/debugger/coverage/WipCoverageProgramRunner;", "Lcom/intellij/javascript/debugger/execution/JavaScriptDebugRunner;", "()V", "addNotification", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "Lcom/intellij/execution/configurations/RunnerSettings;", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "hideDebuggerTabs", "onProtocolStart", "jsDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "vm", "Lorg/jetbrains/wip/WipVm;", "onProtocolStop", "javaScriptDebugProcess", "startSession", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "updateCoverageView", "env", "coverageReport", "Ljava/io/File;", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nWipCoverageProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipCoverageProgramRunner.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageProgramRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 DebuggableProgramRunner.kt\ncom/intellij/javascript/debugger/execution/DebuggableProgramRunnerKt\n*L\n1#1,164:1\n1#2:165\n37#3,6:166\n*S KotlinDebug\n*F\n+ 1 WipCoverageProgramRunner.kt\ncom/intellij/javascript/debugger/coverage/WipCoverageProgramRunner\n*L\n91#1:166,6\n*E\n"})
public final class WipCoverageProgramRunner
extends JavaScriptDebugRunner {
    @Override
    @NotNull
    public String getRunnerId() {
        return "WipCoverageProgramRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && Intrinsics.areEqual((Object)executorId, (Object)"Coverage");
    }

    @Override
    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = JavaScriptDebugRunner.Companion.findEngineAndBrowser(configuration.getEngineId());
        JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)engineAndBrowser.first;
        Project project = environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object object = engineAndBrowser.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        Promise promise2 = javaScriptDebugEngine.prepareDebugger(project, (WebBrowser)object).then(arg_0 -> WipCoverageProgramRunner.execute$lambda$0((Function1)new Function1<Unit, RunContentDescriptor>(this, environment, engineAndBrowser){
            final /* synthetic */ WipCoverageProgramRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ Pair<JavaScriptDebugEngine, WebBrowser> $engineAndBrowser;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
                this.$engineAndBrowser = $engineAndBrowser;
                super(1);
            }

            @Nullable
            public final RunContentDescriptor invoke(Unit it) {
                FileDocumentManager.getInstance().saveAllDocuments();
                Project project = this.$environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                XDebugSession session2 = WipCoverageProgramRunner.access$startSession(this.this$0, project, this.$environment, this.$engineAndBrowser);
                WipCoverageProgramRunner.access$hideDebuggerTabs(this.this$0, session2);
                WipCoverageProgramRunner.access$addNotification(this.this$0, session2);
                return session2.getRunContentDescriptor();
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    private final void addNotification(XDebugSession session2) {
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.JavaScriptDebugProcess<org.jetbrains.debugger.connection.VmConnection<out org.jetbrains.wip.WipVm>>");
        JavaScriptDebugProcess jsDebugProcess = (JavaScriptDebugProcess)xDebugProcess;
        jsDebugProcess.getConnection().addDebugListener(new DebugEventListener(jsDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess<VmConnection<? extends WipVm>> $jsDebugProcess;
            {
                this.$jsDebugProcess = $jsDebugProcess;
            }

            public void navigated(@Nullable String newUrl) {
                block0: {
                    ConsoleView jsConsoleView;
                    super.navigated(newUrl);
                    ConsoleView consoleView = jsConsoleView = this.$jsDebugProcess.getJSConsoleView(false);
                    if (consoleView == null) break block0;
                    consoleView.print(JSDebuggerBundle.message("js.coverage.notification", new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
            }
        });
    }

    private final void hideDebuggerTabs(XDebugSession session2) {
        block3: {
            Content it;
            ContentManager contentManager = session2.getUI().getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            ContentManager contentManager2 = contentManager;
            Content variables = contentManager2.findContent("Variables");
            Content frames = contentManager2.findContent("Frames");
            Content scripts = contentManager2.findContent("Scripts");
            Content elements = contentManager2.findContent("Elements");
            Content content = variables;
            if (content != null) {
                it = content;
                boolean bl = false;
                contentManager2.removeContent(it, true);
            }
            Content content2 = frames;
            if (content2 != null) {
                it = content2;
                boolean bl = false;
                contentManager2.removeContent(it, true);
            }
            Content content3 = scripts;
            if (content3 != null) {
                it = content3;
                boolean bl = false;
                contentManager2.removeContent(it, true);
            }
            Content content4 = elements;
            if (content4 == null) break block3;
            it = content4;
            boolean bl = false;
            contentManager2.removeContent(it, true);
        }
    }

    private final XDebugSession startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        DebuggableFileFinder debuggableFileFinder;
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        Intrinsics.checkNotNull((Object)string);
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        if (url.isInLocalFileSystem()) {
            debuggableFileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getMappings(...)");
            debuggableFileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        DebuggableFileFinder fileFinder = debuggableFileFinder;
        boolean $i$f$startSession = false;
        boolean $i$f$xDebugProcessStarter = false;
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(engineAndBrowser, fileFinder, url, this, environment){
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;
            final /* synthetic */ WipCoverageProgramRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment$inlined;
            {
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
                this.this$0 = wipCoverageProgramRunner;
                this.$environment$inlined = executionEnvironment;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                XDebugSession session3 = session2;
                boolean bl = false;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                Object object = this.$engineAndBrowser$inlined.second;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                JavaScriptDebugProcess<VmConnection<?>> debugProcess = javaScriptDebugEngine.createDebugProcess(session3, (WebBrowser)object, this.$fileFinder$inlined, this.$url$inlined, null, true);
                debugProcess.getConnection().executeOnStart((Function1)new Function1<Vm, Unit>(this.this$0, debugProcess){
                    final /* synthetic */ WipCoverageProgramRunner this$0;
                    final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $debugProcess;
                    {
                        this.this$0 = $receiver;
                        this.$debugProcess = $debugProcess;
                        super(1);
                    }

                    public final void invoke(@NotNull Vm it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        WipCoverageProgramRunner.access$onProtocolStart(this.this$0, this.$debugProcess, (WipVm)it);
                    }
                });
                debugProcess.setBeforeStopAction((Function0)new Function0<Promise<?>>(this.this$0, debugProcess, this.$environment$inlined){
                    final /* synthetic */ WipCoverageProgramRunner this$0;
                    final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $debugProcess;
                    final /* synthetic */ ExecutionEnvironment $environment;
                    {
                        this.this$0 = $receiver;
                        this.$debugProcess = $debugProcess;
                        this.$environment = $environment;
                        super(0);
                    }

                    @NotNull
                    public final Promise<?> invoke() {
                        return WipCoverageProgramRunner.access$onProtocolStop(this.this$0, this.$debugProcess, this.$environment);
                    }
                });
                return debugProcess;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
        XDebugSession session2 = xDebugSession;
        session2.setBreakpointMuted(true);
        return session2;
    }

    private final void onProtocolStart(JavaScriptDebugProcess<? extends VmConnection<?>> jsDebugProcess, WipVm vm) {
        vm.getCommandProcessor().send((Request)ProfilerKt.Enable());
        WipCssManager wipCssManager = jsDebugProcess.getCssManager();
        Intrinsics.checkNotNull((Object)wipCssManager);
        wipCssManager.enable();
        vm.getCommandProcessor().send((Request)ProfilerKt.StartPreciseCoverage$default((Boolean)true, (Boolean)true, null, (int)4, null));
        vm.getCommandProcessor().send((Request)CSSKt.StartRuleUsageTracking());
    }

    private final Promise<?> onProtocolStop(JavaScriptDebugProcess<? extends VmConnection<?>> javaScriptDebugProcess, ExecutionEnvironment environment) {
        Vm vm = javaScriptDebugProcess.getVm();
        WipVm wipVm = vm instanceof WipVm ? (WipVm)vm : null;
        if (wipVm == null) {
            return Promises.nullPromise();
        }
        WipVm vm2 = wipVm;
        Ref.ObjectRef coverageReport = new Ref.ObjectRef();
        Promise promise2 = vm2.getCommandProcessor().send((Request)ProfilerKt.TakePreciseCoverage()).thenAsync(arg_0 -> WipCoverageProgramRunner.onProtocolStop$lambda$6((Function1)new Function1<TakePreciseCoverageResult, Promise<LcovCoverageReport>>(javaScriptDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $javaScriptDebugProcess;
            {
                this.$javaScriptDebugProcess = $javaScriptDebugProcess;
                super(1);
            }

            public final Promise<LcovCoverageReport> invoke(TakePreciseCoverageResult it) {
                return WipCoverageReportProcessor.INSTANCE.convertCoverageFormat(this.$javaScriptDebugProcess, it.result());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        Promise jsPromise2 = promise2;
        Promise promise3 = vm2.getCommandProcessor().send((Request)CSSKt.TakeCoverageDelta()).thenAsync(arg_0 -> WipCoverageProgramRunner.onProtocolStop$lambda$7((Function1)new Function1<TakeCoverageDeltaResult, Promise<LcovCoverageReport>>(javaScriptDebugProcess){
            final /* synthetic */ JavaScriptDebugProcess<VmConnection<?>> $javaScriptDebugProcess;
            {
                this.$javaScriptDebugProcess = $javaScriptDebugProcess;
                super(1);
            }

            public final Promise<LcovCoverageReport> invoke(TakeCoverageDeltaResult it) {
                return WipCoverageReportProcessor.INSTANCE.convertCssCoverageFormat(this.$javaScriptDebugProcess, it.coverage());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"thenAsync(...)");
        Promise cssPromise2 = promise3;
        Object[] objectArray = new Promise[]{jsPromise2, cssPromise2};
        Promise promise4 = Promises.collectResults((Collection)CollectionsKt.listOf((Object[])objectArray), (boolean)false).thenAsync(arg_0 -> WipCoverageProgramRunner.onProtocolStop$lambda$8((Function1)new Function1<List<? extends LcovCoverageReport>, Promise<Unit>>((Ref.ObjectRef<File>)coverageReport, environment, vm2, this){
            final /* synthetic */ Ref.ObjectRef<File> $coverageReport;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ WipVm $vm;
            final /* synthetic */ WipCoverageProgramRunner this$0;
            {
                this.$coverageReport = $coverageReport;
                this.$environment = $environment;
                this.$vm = $vm;
                this.this$0 = $receiver;
                super(1);
            }

            public final Promise<Unit> invoke(List<? extends LcovCoverageReport> reports) {
                Intrinsics.checkNotNull(reports);
                LcovCoverageReport lcov = (LcovCoverageReport)CollectionsKt.first(reports);
                lcov.mergeReport((LcovCoverageReport)CollectionsKt.last(reports));
                Object object = this.$coverageReport.element = FileUtil.createTempFile((String)"covData", null);
                Intrinsics.checkNotNull((Object)object);
                CoverageSerializationUtils.writeLCOV((LcovCoverageReport)lcov, (File)((File)object));
                ApplicationManager.getApplication().invokeLater(() -> onProtocolStop.1.invoke$lambda$0(this.this$0, this.$environment, this.$coverageReport), this.$environment.getProject().getDisposed());
                return this.$vm.getCommandProcessor().send((Request)ProfilerKt.StopPreciseCoverage());
            }

            private static final void invoke$lambda$0(WipCoverageProgramRunner this$0, ExecutionEnvironment $environment, Ref.ObjectRef $coverageReport) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
                Intrinsics.checkNotNullParameter((Object)$coverageReport, (String)"$coverageReport");
                Object object = $coverageReport.element;
                Intrinsics.checkNotNull((Object)object);
                WipCoverageProgramRunner.access$updateCoverageView(this$0, $environment, (File)object);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise4, (String)"thenAsync(...)");
        return promise4;
    }

    @NotNull
    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        return (RunnerSettings)new CoverageRunnerData();
    }

    private final void updateCoverageView(ExecutionEnvironment env, File coverageReport) {
        RunProfile runProfile = env.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.RunConfigurationBase<*>");
        RunConfigurationBase runConfiguration = (RunConfigurationBase)runProfile;
        CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)coverageEnabledConfiguration, (String)"getOrCreate(...)");
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        String string = coverageEnabledConfiguration2.getCoverageFilePath();
        if (string == null) {
            return;
        }
        String coverageFilePath = string;
        try {
            FileUtil.copy((File)coverageReport, (File)new File(coverageFilePath));
        }
        catch (IOException e) {
            return;
        }
        RunnerSettings runnerSettings = env.getRunnerSettings();
        if (runnerSettings != null) {
            WipCoverageRunner coverageRunner = (WipCoverageRunner)CoverageRunner.getInstance(WipCoverageRunner.class);
            coverageRunner.setWorkingDirectory(env.getProject().getBasePath());
            CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, runnerSettings);
        }
    }

    private static final RunContentDescriptor execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    private static final Promise onProtocolStop$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise onProtocolStop$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise onProtocolStop$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ XDebugSession access$startSession(WipCoverageProgramRunner $this, Project project, ExecutionEnvironment environment, Pair engineAndBrowser) {
        return $this.startSession(project, environment, (Pair<JavaScriptDebugEngine, WebBrowser>)engineAndBrowser);
    }

    public static final /* synthetic */ void access$hideDebuggerTabs(WipCoverageProgramRunner $this, XDebugSession session2) {
        $this.hideDebuggerTabs(session2);
    }

    public static final /* synthetic */ void access$addNotification(WipCoverageProgramRunner $this, XDebugSession session2) {
        $this.addNotification(session2);
    }

    public static final /* synthetic */ void access$updateCoverageView(WipCoverageProgramRunner $this, ExecutionEnvironment env, File coverageReport) {
        $this.updateCoverageView(env, coverageReport);
    }

    public static final /* synthetic */ void access$onProtocolStart(WipCoverageProgramRunner $this, JavaScriptDebugProcess jsDebugProcess, WipVm vm) {
        $this.onProtocolStart(jsDebugProcess, vm);
    }

    public static final /* synthetic */ Promise access$onProtocolStop(WipCoverageProgramRunner $this, JavaScriptDebugProcess javaScriptDebugProcess, ExecutionEnvironment environment) {
        return $this.onProtocolStop(javaScriptDebugProcess, environment);
    }
}

