/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.idea.ActionsBundle;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.HistoryViewNavigator;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.WebConsoleFilterForm;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.javascript.debugger.console.WebConsoleSearchSession;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00fd\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b#*\u0001\u001d\u0018\u00002\u00020\u00012\u00020\u0002:\u000e\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001\u008e\u0001\u008f\u0001B;\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0016J\u0010\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u001a\u00100\u001a\u00020/2\b\b\u0001\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0001H\u0002J\u0013\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0016\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020/H\u0016J\r\u00109\u001a\u00020/H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\n =*\u0004\u0018\u00010<0<H\u0002J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020AH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020HH\u0016J\u000f\u0010I\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\bJJ\b\u0010K\u001a\u00020AH\u0016J\b\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020?H\u0016J\b\u0010O\u001a\u00020PH\u0016J\n\u0010Q\u001a\u0004\u0018\u000102H\u0016J\b\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u000202H\u0016J\b\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u00020\u0013H\u0016J\b\u0010X\u001a\u00020\u0013H\u0016J\b\u0010Y\u001a\u00020\u0013H\u0016J\b\u0010Z\u001a\u00020\u0013H\u0016J\u0010\u0010[\u001a\u00020/2\u0006\u0010\\\u001a\u00020]H\u0016J\u0018\u0010^\u001a\u00020/2\u0006\u0010_\u001a\u0002022\u0006\u0010`\u001a\u00020SH\u0016J\u001a\u0010a\u001a\u00020/2\u0006\u0010b\u001a\u0002022\b\u0010c\u001a\u0004\u0018\u00010dH\u0016J\u001a\u0010e\u001a\u0002022\b\b\u0002\u0010f\u001a\u00020\u00132\b\b\u0002\u0010g\u001a\u00020\u0013J%\u0010h\u001a\u0002022\u0006\u0010i\u001a\u00020P2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020mH\u0000\u00a2\u0006\u0002\bnJ\u0010\u0010o\u001a\u00020&2\u0006\u0010p\u001a\u00020CH\u0016J\r\u0010q\u001a\u00020/H\u0000\u00a2\u0006\u0002\brJ\u0010\u0010s\u001a\u00020/2\u0006\u0010t\u001a\u00020\u0013H\u0016J\u000e\u0010u\u001a\u00020/2\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010v\u001a\u00020/2\u0006\u0010w\u001a\u00020\u0013H\u0016J\u0017\u0010x\u001a\u00020/2\b\u0010y\u001a\u0004\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\bzJ\u0010\u0010{\u001a\u00020&2\u0006\u0010|\u001a\u000202H\u0016J\u0010\u0010}\u001a\u00020/2\u0006\u0010~\u001a\u000202H\u0016J\u0011\u0010\u007f\u001a\u00020/2\u0007\u0010\u0080\u0001\u001a\u00020MH\u0016J\u0012\u0010\u0081\u0001\u001a\u00020&2\u0007\u0010\u0082\u0001\u001a\u00020\u0013H\u0016J\u0014\u0010\u0083\u0001\u001a\u00020/2\t\u0010\u0084\u0001\u001a\u0004\u0018\u000102H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020/2\u0007\u0010\u0086\u0001\u001a\u00020SH\u0016J\u0011\u0010\u0087\u0001\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0016J\t\u0010\u0088\u0001\u001a\u00020/H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0090\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView;", "Ljavax/swing/JPanel;", "Lcom/intellij/execution/console/LanguageConsoleView;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "helper", "Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "historyView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/execution/console/LanguageConsoleImpl$Helper;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "consoleExecutionEditor", "Lcom/intellij/execution/console/ConsoleExecutionEditor;", "disposed", "", "<set-?>", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "domPresentationProvider", "getDomPresentationProvider", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "executionPanel", "headerComponent", "Ljava/awt/Component;", "keyListener", "com/intellij/javascript/debugger/console/WebConsoleView$keyListener$1", "Lcom/intellij/javascript/debugger/console/WebConsoleView$keyListener$1;", "printer", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "getPrinter$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/console/MessagePrinter;", "searchSession", "Lcom/intellij/javascript/debugger/console/WebConsoleSearchSession;", "addMessageFilter", "", "filter", "Lcom/intellij/execution/filters/Filter;", "allowHeavyFilters", "attachToProcess", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "canPause", "clear", "", "createAndShowPopup", "title", "", "jPanel", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "dispose", "doClear", "doClear$intellij_javascript_debugger", "getBorderColor", "Lcom/intellij/ui/Gray;", "kotlin.jvm.PlatformType", "getComponent", "Ljavax/swing/JComponent;", "getConsoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getContentSize", "", "getCurrentEditor", "getEditorDocument", "Lcom/intellij/openapi/editor/Document;", "getFile", "Lcom/intellij/psi/PsiFile;", "getHeaderComponent", "getHeaderComponent$intellij_javascript_debugger", "getHistoryViewer", "getLanguage", "Lcom/intellij/lang/Language;", "getPreferredFocusableComponent", "getProject", "Lcom/intellij/openapi/project/Project;", "getPrompt", "getPromptAttributes", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getTitle", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasDeferredOutput", "isConsoleEditorEnabled", "isEditable", "isOutputPaused", "performWhenNoDeferredOutput", "runnable", "Ljava/lang/Runnable;", "print", "text", "contentType", "printHyperlink", "hyperlinkText", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "printInputFromExecutionEditor", "scrollToEnd", "clearInputEditor", "printUserInputWithHighlighting", "project", "inputEditor", "Lcom/intellij/openapi/editor/Editor;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "printUserInputWithHighlighting$intellij_javascript_debugger", "scrollTo", "offset", "searchSessionStopped", "searchSessionStopped$intellij_javascript_debugger", "setConsoleEditorEnabled", "enabled", "setDOMViewHandler", "setEditable", "editable", "setHeaderComponent", "header", "setHeaderComponent$intellij_javascript_debugger", "setHelpId", "helpId", "setInputText", "inputText", "setLanguage", "language", "setOutputPaused", "value", "setPrompt", "prompt", "setPromptAttributes", "textAttributes", "setTitle", "showFiltersPopup", "ClearAllAction", "DOMPresentationProvider", "FilterAction", "IconHolder", "OpenDevToolsAction", "ScrollToTheEndToolbarAction", "SearchAction", "intellij.javascript.debugger"})
public final class WebConsoleView
extends JPanel
implements LanguageConsoleView {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final LanguageConsoleImpl.Helper helper;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final WebConsoleViewSettings settings;
    @NotNull
    private final WebConsoleHistoryView historyView;
    @NotNull
    private final ConsolePrinter consolePrinter;
    @NotNull
    private final MessagePrinter printer;
    @NotNull
    private final ConsoleExecutionEditor consoleExecutionEditor;
    @NotNull
    private final JPanel executionPanel;
    @Nullable
    private Component headerComponent;
    @Nullable
    private WebConsoleSearchSession searchSession;
    @Nullable
    private DOMPresentationProvider domPresentationProvider;
    private volatile boolean disposed;
    @NotNull
    private final keyListener.1 keyListener;

    public WebConsoleView(@NotNull CoroutineScope coroutineScope, @NotNull LanguageConsoleImpl.Helper helper2, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull WebConsoleViewSettings settings, @NotNull WebConsoleHistoryView historyView, @NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)historyView, (String)"historyView");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        super(new BorderLayout());
        this.coroutineScope = coroutineScope;
        this.helper = helper2;
        this.debugProcess = debugProcess;
        this.settings = settings;
        this.historyView = historyView;
        this.consolePrinter = consolePrinter;
        this.printer = this.historyView;
        this.consoleExecutionEditor = new ConsoleExecutionEditor(this.helper);
        this.executionPanel = new JPanel(new BorderLayout());
        this.keyListener = new KeyAdapter(this){
            final /* synthetic */ WebConsoleView this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyTyped(@Nullable KeyEvent event) {
                if (this.this$0.isConsoleEditorEnabled()) {
                    KeyEvent keyEvent = event;
                    Intrinsics.checkNotNull((Object)keyEvent);
                    if (UIUtil.isReallyTypedEvent((KeyEvent)keyEvent)) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> keyListener.1.keyTyped$lambda$0(this.this$0));
                        WebConsoleView.access$getConsoleExecutionEditor$p(this.this$0).getEditor().processKeyTyped(event);
                    }
                }
            }

            private static final void keyTyped$lambda$0(WebConsoleView this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                IdeFocusManager.getGlobalInstance().requestFocus((Component)WebConsoleView.access$getConsoleExecutionEditor$p(this$0).getEditor().getContentComponent(), true);
            }
        };
        this.helper.setupEditor(this.consoleExecutionEditor.getEditor());
        this.consoleExecutionEditor.initComponent();
        this.consoleExecutionEditor.setPrompt(null);
        this.consoleExecutionEditor.getEditor().getGutter().closeAllAnnotations();
        this.add(this.historyView.getComponent(), "Center");
        this.add((Component)this.executionPanel, "South");
        this.executionPanel.add(this.consoleExecutionEditor.getComponent());
        Icon icon = AllIcons.Debugger.PromptInput;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"PromptInput");
        EditorColorsScheme editorColorsScheme = this.consoleExecutionEditor.getCurrentEditor().getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        IconHolder iconHolder = new IconHolder(icon, editorColorsScheme);
        this.executionPanel.add((Component)iconHolder, "West");
        this.executionPanel.setBorder((Border)new CustomLineBorder((Color)this.getBorderColor(), 1, 0, 0, 0));
        this.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> WebConsoleView._init_$lambda$0(this, iconHolder, arg_0));
        this.historyView.addKeyListener(this.keyListener);
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.consoleExecutionEditor));
        Disposer.register((Disposable)((Disposable)this), (Disposable)this.historyView);
    }

    @NotNull
    public final MessagePrinter getPrinter$intellij_javascript_debugger() {
        return this.printer;
    }

    @Nullable
    public final DOMPresentationProvider getDomPresentationProvider() {
        return this.domPresentationProvider;
    }

    private final Gray getBorderColor() {
        return JBColor.isBright() ? Gray._240 : Gray._58;
    }

    public void dispose() {
        FileEditorManager editorManager;
        this.disposed = true;
        this.historyView.removeKeyListener(this.keyListener);
        this.remove(this.historyView.getComponent());
        if (this.helper.project.isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.helper.project)).isFileOpen(this.helper.virtualFile)) {
            editorManager.closeFile(this.helper.virtualFile);
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, (String)"WebConsoleView disposed", null, (int)2, null);
    }

    @NotNull
    public final String printInputFromExecutionEditor(boolean scrollToEnd2, boolean clearInputEditor) {
        EditorEx editor = this.getCurrentEditor();
        DocumentEx documentEx = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        TextRange range = new TextRange(0, document.getTextLength());
        this.printUserInputWithHighlighting$intellij_javascript_debugger(this.getProject(), (Editor)editor, range);
        if (clearInputEditor) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> WebConsoleView.printInputFromExecutionEditor$lambda$1(editor, document));
        }
        if (scrollToEnd2) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WebConsoleView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            WebConsoleView.access$getHistoryView$p(this.this$0).scrollToEnd();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return text;
    }

    public static /* synthetic */ String printInputFromExecutionEditor$default(WebConsoleView webConsoleView, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return webConsoleView.printInputFromExecutionEditor(bl, bl2);
    }

    @NotNull
    public final String printUserInputWithHighlighting$intellij_javascript_debugger(@NotNull Project project, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)inputEditor, (String)"inputEditor");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        ThreadingAssertions.assertEventDispatchThread();
        String text = null;
        EditorHighlighter highlighter = null;
        if (inputEditor instanceof EditorWindow) {
            PsiFile psiFile = ((EditorWindow)inputEditor).getInjectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getInjectedFile(...)");
            PsiFile file2 = psiFile;
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
            highlighter = editorHighlighter;
            String string = InjectedLanguageManager.getInstance((Project)project).getUnescapedText((PsiElement)file2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUnescapedText(...)");
            String fullText = string;
            highlighter.setText((CharSequence)fullText);
            String string2 = textRange.substring(fullText);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            text = string2;
        } else {
            String string = inputEditor.getDocument().getText(textRange);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            text = string;
            EditorHighlighter editorHighlighter = inputEditor.getHighlighter();
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
            highlighter = editorHighlighter;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, highlighter, text, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ EditorHighlighter $highlighter;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$highlighter = $highlighter;
                this.$text = $text;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object3 = consolePrinter.submitMessage(vm, true, (Function1<? super ConsoleMessageBuilder, Unit>)((Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$highlighter, this.$text){
                            final /* synthetic */ EditorHighlighter $highlighter;
                            final /* synthetic */ String $text;
                            {
                                this.$highlighter = $highlighter;
                                this.$text = $text;
                                super(1);
                            }

                            public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.USER_INPUT;
                                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"USER_INPUT");
                                ConsoleMessageBuilder.startMessage$default($this$submitMessage, consoleViewContentType, MessageType.EVAL_IN, null, 4, null);
                                if (this.$highlighter instanceof LexerEditorHighlighter) {
                                    ConsoleViewUtil.printWithHighlighting((arg_0, arg_1) -> printUserInputWithHighlighting.1.invoke$lambda$0((Function2)new Function2<String, ConsoleViewContentType, Unit>((Object)$this$submitMessage){

                                        public final void invoke(@NotNull String p0, @NotNull ConsoleViewContentType p1) {
                                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                            ConsoleMessageBuilder.append$default((ConsoleMessageBuilder)this.receiver, p0, p1, null, 4, null);
                                        }
                                    }, arg_0, arg_1), (String)this.$text, (SyntaxHighlighter)((LexerEditorHighlighter)this.$highlighter).getSyntaxHighlighter(), null);
                                } else {
                                    ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.USER_INPUT;
                                    Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"USER_INPUT");
                                    ConsoleMessageBuilder.append$default($this$submitMessage, this.$text, consoleViewContentType2, null, 4, null);
                                }
                            }

                            private static final void invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0, p1);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return text;
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, text, contentType, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ ConsoleViewContentType $contentType;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$contentType = $contentType;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object3 = ConsolePrinter.submitMessage$default(consolePrinter, vm, false, (Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$text, this.$contentType){
                            final /* synthetic */ String $text;
                            final /* synthetic */ ConsoleViewContentType $contentType;
                            {
                                this.$text = $text;
                                this.$contentType = $contentType;
                                super(1);
                            }

                            public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                ConsoleMessageBuilder.startMessage$default($this$submitMessage, null, null, null, 7, null);
                                ConsoleMessageBuilder.append$default($this$submitMessage, this.$text, this.$contentType, null, 4, null);
                            }
                        }, (Continuation)this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hyperlinkText, info, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ String $hyperlinkText;
            final /* synthetic */ HyperlinkInfo $info;
            {
                this.this$0 = $receiver;
                this.$hyperlinkText = $hyperlinkText;
                this.$info = $info;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ConsolePrinter consolePrinter = WebConsoleView.access$getConsolePrinter$p(this.this$0);
                        Vm vm = WebConsoleView.access$getDebugProcess$p(this.this$0).getVm();
                        Intrinsics.checkNotNull((Object)vm);
                        this.label = 1;
                        Object object3 = ConsolePrinter.submitMessage$default(consolePrinter, vm, false, (Function1)new Function1<ConsoleMessageBuilder, Unit>(this.$hyperlinkText, this.$info){
                            final /* synthetic */ String $hyperlinkText;
                            final /* synthetic */ HyperlinkInfo $info;
                            {
                                this.$hyperlinkText = $hyperlinkText;
                                this.$info = $info;
                                super(1);
                            }

                            public final void invoke(@NotNull ConsoleMessageBuilder $this$submitMessage) {
                                Intrinsics.checkNotNullParameter((Object)$this$submitMessage, (String)"$this$submitMessage");
                                ConsoleMessageBuilder.startMessage$default($this$submitMessage, null, null, null, 7, null);
                                $this$submitMessage.addHyperLink(this.$hyperlinkText, this.$info);
                            }
                        }, (Continuation)this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void clear() {
        this.doClear$intellij_javascript_debugger();
    }

    public final void doClear$intellij_javascript_debugger() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ WebConsoleView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!WebConsoleView.access$getDisposed$p(this.this$0)) {
                            WebConsoleView.access$getHistoryView$p(this.this$0).clear();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray;
        SearchAction searchAction = new SearchAction();
        searchAction.registerCustomShortcutSet(this.getComponent(), (Disposable)this);
        if (ApplicationManager.getApplication().isInternal()) {
            AnAction[] anActionArray2 = new AnAction[]{new ScrollToTheEndToolbarAction(this.historyView), new ClearAllAction(this.coroutineScope, this, this.consolePrinter), new FilterAction(), new OpenDevToolsAction()};
            anActionArray = anActionArray2;
        } else {
            AnAction[] anActionArray3 = new AnAction[]{new ScrollToTheEndToolbarAction(this.historyView), new ClearAllAction(this.coroutineScope, this, this.consolePrinter), new FilterAction()};
            anActionArray = anActionArray3;
        }
        return anActionArray;
    }

    @Nullable
    public final Component getHeaderComponent$intellij_javascript_debugger() {
        return this.headerComponent;
    }

    public final void setHeaderComponent$intellij_javascript_debugger(@Nullable Component header) {
        if (this.headerComponent != null) {
            this.remove(this.headerComponent);
        }
        if (header != null) {
            this.add(header, "North");
        }
        this.revalidate();
        this.repaint();
        this.headerComponent = header;
    }

    public final void searchSessionStopped$intellij_javascript_debugger() {
        this.searchSession = null;
    }

    private final void showFiltersPopup() {
        WebConsoleFilterForm filterForm = new WebConsoleFilterForm();
        filterForm.reset(this.settings);
        filterForm.addListener(new WebConsoleFilterForm.FilterListener(this, filterForm){
            final /* synthetic */ WebConsoleView this$0;
            final /* synthetic */ WebConsoleFilterForm $filterForm;
            {
                this.this$0 = $receiver;
                this.$filterForm = $filterForm;
            }

            public void filtersChanged() {
                WebConsoleView.access$getHistoryView$p(this.this$0).updateFromFilterSettingsUI(this.$filterForm);
            }

            public void filtersResetRequested() {
                WebConsoleView.access$getHistoryView$p(this.this$0).resetAllFilters();
                this.$filterForm.reset(WebConsoleView.access$getSettings$p(this.this$0));
            }
        });
        String string = JSDebuggerBundle.message("js.console.filter.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        JPanel jPanel = filterForm.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
        this.createAndShowPopup(string, jPanel);
    }

    private final void createAndShowPopup(@NlsContexts.PopupTitle String title, JPanel jPanel) {
        Rectangle visibleRect = this.getComponent().getVisibleRect();
        Point topLeft = new Point(this.getComponent().getLocationOnScreen().x + visibleRect.x, this.getComponent().getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)jPanel, null).setProject(this.getProject()).setTitle(title).setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)topLeft));
    }

    public final void setDOMViewHandler(@NotNull DOMPresentationProvider domPresentationProvider) {
        Intrinsics.checkNotNullParameter((Object)domPresentationProvider, (String)"domPresentationProvider");
        this.domPresentationProvider = domPresentationProvider;
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.consoleExecutionEditor.getEditor().getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    @NotNull
    public Void scrollTo(int offset) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void attachToProcess(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void setOutputPaused(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
    }

    @NotNull
    public Void setHelpId(@NotNull String helpId) {
        Intrinsics.checkNotNullParameter((Object)helpId, (String)"helpId");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void addMessageFilter(@NotNull Filter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        throw new UnsupportedOperationException();
    }

    public int getContentSize() {
        return 1;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public Void allowHeavyFilters() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Project getProject() {
        Project project = this.helper.project;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return project;
    }

    @NotNull
    public String getTitle() {
        String string = this.helper.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
        return string;
    }

    public void setTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        this.helper.setTitle(title);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.helper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return psiFile;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.consoleExecutionEditor.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return virtualFile;
    }

    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getCurrentEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getCurrentEditor(...)");
        return editorEx;
    }

    @NotNull
    public EditorEx getConsoleEditor() {
        EditorEx editorEx = this.consoleExecutionEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getEditor(...)");
        return editorEx;
    }

    @NotNull
    public Document getEditorDocument() {
        Document document = this.consoleExecutionEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return document;
    }

    @NotNull
    public EditorEx getHistoryViewer() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return language;
    }

    public void setLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.helper.setLanguage(language);
    }

    @Nullable
    public String getPrompt() {
        return this.consoleExecutionEditor.getPrompt();
    }

    public void setPrompt(@Nullable String prompt) {
        this.consoleExecutionEditor.setPrompt(prompt);
    }

    @NotNull
    public ConsoleViewContentType getPromptAttributes() {
        ConsoleViewContentType consoleViewContentType = this.consoleExecutionEditor.getPromptAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getPromptAttributes(...)");
        return consoleViewContentType;
    }

    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.consoleExecutionEditor.setPromptAttributes(textAttributes);
    }

    public void setInputText(@NotNull String inputText) {
        Intrinsics.checkNotNullParameter((Object)inputText, (String)"inputText");
        DocumentUtil.writeInRunUndoTransparentAction(() -> WebConsoleView.setInputText$lambda$2(this, inputText));
    }

    public boolean isEditable() {
        return this.consoleExecutionEditor.isEditable();
    }

    public void setEditable(boolean editable) {
        this.consoleExecutionEditor.setEditable(editable);
    }

    public boolean isConsoleEditorEnabled() {
        return this.executionPanel.isVisible();
    }

    public void setConsoleEditorEnabled(boolean enabled) {
        if (this.isConsoleEditorEnabled() == enabled) {
            return;
        }
        if (enabled) {
            FileEditorManager.getInstance((Project)this.helper.project).closeFile(this.helper.virtualFile);
        }
        this.executionPanel.setVisible(enabled);
    }

    private static final void _init_$lambda$0(WebConsoleView this$0, IconHolder $iconHolder, EditorColorsScheme newScheme) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$iconHolder, (String)"$iconHolder");
        EditorColorsScheme editorColorsScheme = newScheme;
        if (editorColorsScheme == null) {
            editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        }
        EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
        Intrinsics.checkNotNull((Object)editorColorsScheme2);
        EditorColorsScheme scheme = editorColorsScheme2;
        this$0.setBackground(scheme.getDefaultBackground());
        $iconHolder.updateScheme(scheme);
        this$0.executionPanel.setBorder((Border)new CustomLineBorder((Color)this$0.getBorderColor(), 1, 0, 0, 0));
    }

    private static final void printInputFromExecutionEditor$lambda$1(EditorEx $editor, DocumentEx $document) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        $editor.getDocument().deleteString(0, $document.getTextLength());
    }

    private static final void setInputText$lambda$2(WebConsoleView this$0, String $inputText) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inputText, (String)"$inputText");
        this$0.consoleExecutionEditor.getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)$inputText));
    }

    public static final /* synthetic */ ConsolePrinter access$getConsolePrinter$p(WebConsoleView $this) {
        return $this.consolePrinter;
    }

    public static final /* synthetic */ JavaScriptDebugProcess access$getDebugProcess$p(WebConsoleView $this) {
        return $this.debugProcess;
    }

    public static final /* synthetic */ boolean access$getDisposed$p(WebConsoleView $this) {
        return $this.disposed;
    }

    public static final /* synthetic */ ConsoleExecutionEditor access$getConsoleExecutionEditor$p(WebConsoleView $this) {
        return $this.consoleExecutionEditor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ClearAllAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "consoleView", "Lcom/intellij/execution/console/LanguageConsoleView;", "consolePrinter", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/execution/console/LanguageConsoleView;Lcom/intellij/javascript/debugger/console/ConsolePrinter;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.javascript.debugger"})
    private static final class ClearAllAction
    extends DumbAwareAction {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final LanguageConsoleView consoleView;
        @NotNull
        private final ConsolePrinter consolePrinter;

        public ClearAllAction(@NotNull CoroutineScope coroutineScope, @NotNull LanguageConsoleView consoleView, @NotNull ConsolePrinter consolePrinter) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"clear.all.from.console.action.description", (Object[])new Object[0]), AllIcons.Actions.GC);
            this.coroutineScope = coroutineScope;
            this.consoleView = consoleView;
            this.consolePrinter = consolePrinter;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(this.consoleView.getContentSize() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ClearAllAction this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ClearAllAction.access$getConsolePrinter$p(this.this$0).clear((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ ConsolePrinter access$getConsolePrinter$p(ClearAllAction $this) {
            return $this.consolePrinter;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H&J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "", "getChildren", "", "Lcom/intellij/navigation/ItemPresentation;", "node", "getNodePresentation", "Lorg/jetbrains/concurrency/Promise;", "v", "Lorg/jetbrains/debugger/values/Value;", "hasChildren", "", "hideHighlight", "", "highlight", "intellij.javascript.debugger"})
    public static interface DOMPresentationProvider {
        @NotNull
        public Promise<ItemPresentation> getNodePresentation(@NotNull Value var1);

        public boolean hasChildren(@NotNull ItemPresentation var1);

        @NotNull
        public List<ItemPresentation> getChildren(@NotNull ItemPresentation var1);

        public void highlight(@NotNull ItemPresentation var1);

        public void hideHighlight(@NotNull ItemPresentation var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$FilterAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.javascript.debugger"})
    private final class FilterAction
    extends DumbAwareAction
    implements Toggleable {
        public FilterAction() {
            super(JSDebuggerBundle.message("js.console.filter.popup", new Object[0]), null, AllIcons.General.Filter);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)WebConsoleView.this.settings.areFiltersApplied());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebConsoleView.this.showFiltersPopup();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$IconHolder;", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "(Ljavax/swing/Icon;Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getIcon", "()Ljavax/swing/Icon;", "scaledIcon", "getScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "setScheme", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "getFontMetrics", "Ljava/awt/FontMetrics;", "getLineHeight", "", "getPreferredSize", "Ljava/awt/Dimension;", "paint", "", "g", "Ljava/awt/Graphics;", "scaleIcon", "colorsScheme", "updateScheme", "intellij.javascript.debugger"})
    private static final class IconHolder
    extends JComponent {
        @NotNull
        private final Icon icon;
        @NotNull
        private EditorColorsScheme scheme;
        @NotNull
        private Icon scaledIcon;

        public IconHolder(@NotNull Icon icon, @NotNull EditorColorsScheme scheme) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            this.icon = icon;
            this.scheme = scheme;
            this.scaledIcon = this.scaleIcon(this.scheme);
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        @NotNull
        public final EditorColorsScheme getScheme() {
            return this.scheme;
        }

        public final void setScheme(@NotNull EditorColorsScheme editorColorsScheme) {
            Intrinsics.checkNotNullParameter((Object)editorColorsScheme, (String)"<set-?>");
            this.scheme = editorColorsScheme;
        }

        public final void updateScheme(@NotNull EditorColorsScheme colorsScheme) {
            Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
            this.scheme = colorsScheme;
            this.scaledIcon = this.scaleIcon(colorsScheme);
        }

        private final Icon scaleIcon(EditorColorsScheme colorsScheme) {
            return IconUtil.scaleByFont((Icon)this.icon, (Component)this, (float)colorsScheme.getConsoleFontSize());
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Rectangle clip = g.getClipBounds();
            g.setColor(this.scheme.getDefaultBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            this.scaledIcon.paintIcon(null, g, 0, this.getLineHeight() / 2 - this.scaledIcon.getIconHeight() / 2);
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(this.scaledIcon.getIconWidth(), this.getLineHeight());
        }

        private final int getLineHeight() {
            FontMetrics fontMetrics = this.getFontMetrics();
            return (int)((float)fontMetrics.getHeight() * this.scheme.getConsoleLineSpacing());
        }

        @NotNull
        public final FontMetrics getFontMetrics() {
            Font font = this.scheme.getFont(EditorFontType.CONSOLE_PLAIN);
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            Font schemeFont = font;
            FontMetrics fontMetrics = this.getFontMetrics(schemeFont);
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
            return fontMetrics;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$OpenDevToolsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javascript.debugger"})
    private final class OpenDevToolsAction
    extends AnAction {
        public OpenDevToolsAction() {
            this.getTemplatePresentation().setText(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenDevTools.text", new Object[0]));
            this.getTemplatePresentation().setDescription(JSDebuggerBundle.message("action.JavaScriptDebugger.OpenDevTools.description", new Object[0]));
            this.getTemplatePresentation().setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            WebConsoleView.this.historyView.openDevtools();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$ScrollToTheEndToolbarAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/project/DumbAware;", "historyViewNavigator", "Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;", "(Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.javascript.debugger"})
    private static final class ScrollToTheEndToolbarAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final HistoryViewNavigator historyViewNavigator;

        public ScrollToTheEndToolbarAction(@NotNull HistoryViewNavigator historyViewNavigator) {
            Intrinsics.checkNotNullParameter((Object)historyViewNavigator, (String)"historyViewNavigator");
            this.historyViewNavigator = historyViewNavigator;
            String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
            this.getTemplatePresentation().setDescription(message);
            this.getTemplatePresentation().setText(message);
            this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return this.historyViewNavigator.isStickToEnd();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.historyViewNavigator.setStickToEnd(state);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleView$SearchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/javascript/debugger/console/WebConsoleView;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javascript.debugger"})
    private final class SearchAction
    extends AnAction {
        public SearchAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Find");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (WebConsoleView.this.searchSession == null) {
                WebConsoleView.this.searchSession = new WebConsoleSearchSession(WebConsoleView.this.coroutineScope, WebConsoleView.this, WebConsoleView.this.historyView, WebConsoleView.this.getProject());
            }
        }
    }
}

