/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.LinkType;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.ui.SimpleColoredText;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/console/HyperLink;", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "hyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "linkType", "Lcom/intellij/javascript/debugger/console/LinkType;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/execution/filters/HyperlinkInfo;Lcom/intellij/javascript/debugger/console/LinkType;Lcom/intellij/ui/SimpleColoredText;)V", "getHyperlink", "()Lcom/intellij/execution/filters/HyperlinkInfo;", "getLinkType", "()Lcom/intellij/javascript/debugger/console/LinkType;", "getJSProps", "", "", "getJSStyles", "", "getJSType", "intellij.javascript.debugger"})
public final class HyperLink
extends PrintableEntity {
    @Nullable
    private final HyperlinkInfo hyperlink;
    @NotNull
    private final LinkType linkType;

    public HyperLink(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo hyperlink, @NotNull LinkType linkType, @Nullable SimpleColoredText coloredText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)linkType), (String)"linkType");
        super(text, contentType, coloredText, null, 8, null);
        this.hyperlink = hyperlink;
        this.linkType = linkType;
    }

    public /* synthetic */ HyperLink(String string, ConsoleViewContentType consoleViewContentType, HyperlinkInfo hyperlinkInfo, LinkType linkType, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            simpleColoredText = null;
        }
        this(string, consoleViewContentType, hyperlinkInfo, linkType, simpleColoredText);
    }

    @Nullable
    public final HyperlinkInfo getHyperlink() {
        return this.hyperlink;
    }

    @NotNull
    public final LinkType getLinkType() {
        return this.linkType;
    }

    @Override
    @NotNull
    public String getJSType() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.linkType.ordinal()]) {
            case 1 -> "source-link";
            case 2 -> "browser-link";
            case 3 -> "message-link";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public Map<String, Object> getJSProps() {
        Map<String, Object> jsProps = super.getJSProps();
        jsProps.put("styleClasses", this.getJSStyles());
        return jsProps;
    }

    private final List<String> getJSStyles() {
        return CollectionsKt.listOf((Object)this.getJSType());
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LinkType.values().length];
            try {
                nArray[LinkType.SOURCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkType.BROWSER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LinkType.MESSAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

