/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageCollectors;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@ApiStatus.Internal
public final class FUCounterUsageLogger {
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = StatisticsUploadAssistant.isUseTestStatisticsSendEndpoint() ? 1 : 5;
    private static final Logger LOG = Logger.getInstance(FUCounterUsageLogger.class);
    private final Map<String, EventLogGroup> myGroups = new HashMap<String, EventLogGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        FUCounterUsageLogger fUCounterUsageLogger = (FUCounterUsageLogger)ApplicationManager.getApplication().getService(FUCounterUsageLogger.class);
        if (fUCounterUsageLogger == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(0);
        }
        return fUCounterUsageLogger;
    }

    public FUCounterUsageLogger() {
        for (CounterUsageCollectorEP ep : UsageCollectors.COUNTER_EP_NAME.getExtensionList()) {
            this.registerGroupFromEP(ep);
        }
        ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(UsageCollectors.COUNTER_EP_NAME).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CounterUsageCollectorEP>(){

            public void extensionAdded(@NotNull CounterUsageCollectorEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                FUCounterUsageLogger.this.registerGroupFromEP(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger$1";
                objectArray[2] = "extensionAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, null);
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), LOG_REGISTERED_INITIAL_DELAY_MIN, 1440L, TimeUnit.MINUTES);
    }

    private void registerGroupFromEP(CounterUsageCollectorEP ep) {
        String id;
        if (ep.implementationClass == null && StringUtil.isNotEmpty((String)(id = ep.getGroupId()))) {
            this.register(new EventLogGroup(id, ep.version));
        }
    }

    @NotNull
    public static List<FeatureUsagesCollector> instantiateCounterCollectors() {
        ArrayList<FeatureUsagesCollector> result = new ArrayList<FeatureUsagesCollector>(UsageCollectors.COUNTER_EP_NAME.getPoint().size());
        UsageCollectors.COUNTER_EP_NAME.processWithPluginDescriptor((ep, pluginDescriptor) -> {
            if (ep.implementationClass != null) {
                result.add(FUCounterUsageLogger.createCounterCollector(ep, pluginDescriptor));
            }
            return Unit.INSTANCE;
        });
        ArrayList<FeatureUsagesCollector> arrayList = result;
        if (arrayList == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private static FeatureUsagesCollector createCounterCollector(@NotNull CounterUsageCollectorEP ep, @NotNull PluginDescriptor pluginDescriptor) {
        FeatureUsagesCollector featureUsagesCollector;
        Field instanceField;
        Class aClass;
        if (ep == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(3);
        }
        try {
            aClass = ApplicationManager.getApplication().loadClass(ep.implementationClass, pluginDescriptor);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException((Throwable)e, pluginDescriptor.getPluginId());
        }
        try {
            instanceField = aClass.getDeclaredField("INSTANCE");
        }
        catch (NoSuchFieldException e) {
            FeatureUsagesCollector featureUsagesCollector2 = (FeatureUsagesCollector)ApplicationManager.getApplication().instantiateClass(ep.implementationClass, pluginDescriptor);
            if (featureUsagesCollector2 == null) {
                FUCounterUsageLogger.$$$reportNull$$$0(4);
            }
            return featureUsagesCollector2;
        }
        instanceField.setAccessible(true);
        try {
            featureUsagesCollector = (FeatureUsagesCollector)instanceField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new PluginException((Throwable)e, pluginDescriptor.getPluginId());
        }
        if (featureUsagesCollector == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(5);
        }
        return featureUsagesCollector;
    }

    private void register(@NotNull EventLogGroup group) {
        if (group == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(6);
        }
        this.myGroups.put(group.getId(), group);
    }

    public CompletableFuture<Void> logRegisteredGroups() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (EventLogGroup group : this.myGroups.values()) {
            futures.add(FeatureUsageLogger.INSTANCE.log(group, "registered"));
        }
        HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
        for (FeatureUsagesCollector collector : FUCounterUsageLogger.instantiateCounterCollectors()) {
            EventLogGroup group = collector.getGroup();
            if (group != null) {
                String recorder = group.getRecorder();
                StatisticsEventLogger logger = (StatisticsEventLogger)recorderLoggers.get(recorder);
                if (logger == null) {
                    logger = StatisticsEventLogProviderUtil.getEventLogProvider(recorder).getLogger();
                    recorderLoggers.put(recorder, logger);
                }
                futures.add(logger.logAsync(group, "registered", false));
                continue;
            }
            try {
                if (!StringUtil.isEmpty((String)collector.getGroupId())) continue;
                LOG.error("Please override either getGroupId() or getGroup() with not empty string in " + collector.getClass().getName());
            }
            catch (IllegalStateException e) {
                LOG.error(e.getMessage() + " in " + collector.getClass().getName());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Deprecated(forRemoval=true)
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(7);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(8);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            Map<String, Object> data = new FeatureUsageData(group.getRecorder()).addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, eventId, data);
        }
    }

    @Deprecated
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(9);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(10);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(11);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.addProject(project).build());
        }
    }

    @Deprecated(forRemoval=true)
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(12);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(13);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId);
        }
    }

    @Deprecated
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group;
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(14);
        }
        if (eventId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(15);
        }
        if (data == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(16);
        }
        if ((group = this.findRegisteredGroupById(groupId)) != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.build());
        }
    }

    @Nullable
    private EventLogGroup findRegisteredGroupById(@NotNull String groupId) {
        if (groupId == null) {
            FUCounterUsageLogger.$$$reportNull$$$0(17);
        }
        if (!this.myGroups.containsKey(groupId)) {
            LOG.error("Cannot record event because group '" + groupId + "' is not registered. To fix it add '<statistics.counterUsagesCollector groupId=\"" + groupId + "\" version=\"1\"/>' in plugin.xml");
            return null;
        }
        return this.myGroups.get(groupId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateCounterCollectors";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUCounterUsageLogger";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCounterCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCounterCollector";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logEvent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredGroupById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

