/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details.container;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.docker.view.details.container.DockerContainerBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0002H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/view/details/container/ContainerBrowserTab;", "Lcom/intellij/docker/view/details/DockerDetailsTab;", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "runtime", "(Lcom/intellij/docker/view/details/DockerTabManager;Lcom/intellij/docker/runtimes/DockerApplicationRuntime;)V", "isClosable", "", "()Z", "myBrowser", "Lcom/intellij/docker/view/details/container/DockerContainerBrowser;", "title", "Ljava/util/function/Supplier;", "", "getTitle", "()Ljava/util/function/Supplier;", "withBorder", "getWithBorder", "createBrowser", "content", "Lcom/intellij/ui/content/Content;", "createComponent", "Ljavax/swing/JComponent;", "dispose", "", "refreshTab", "selected", "refreshTabNow", "removeBrowser", "intellij.clouds.docker"})
public final class ContainerBrowserTab
extends DockerDetailsTab<DockerApplicationRuntime> {
    @Nullable
    private DockerContainerBrowser myBrowser;
    private final boolean withBorder;
    @NotNull
    private final Supplier<String> title;
    private final boolean isClosable;

    public ContainerBrowserTab(@NotNull DockerTabManager tabManager2, @NotNull DockerApplicationRuntime runtime2) {
        Intrinsics.checkNotNullParameter((Object)tabManager2, (String)"tabManager");
        Intrinsics.checkNotNullParameter((Object)runtime2, (String)"runtime");
        super(tabManager2, runtime2, null, 4, null);
        this.withBorder = true;
        Supplier<String> supplier = DockerBundle.messagePointer("DockerContainerBrowserTab.displayName", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        this.title = supplier;
        this.isClosable = true;
    }

    @Override
    public boolean getWithBorder() {
        return this.withBorder;
    }

    @Override
    @NotNull
    public Supplier<String> getTitle() {
        return this.title;
    }

    @Override
    public boolean isClosable() {
        return this.isClosable;
    }

    @Override
    @NotNull
    protected JComponent createComponent() {
        JBPanel jBPanel = new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withEmptyText(DockerBundle.message("DockerContainerBrowserTab.emptyText", new Object[0])).withBorder((Border)JBUI.Borders.empty());
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (JComponent)jBPanel;
    }

    @Override
    public void refreshTab(boolean selected) {
        this.refreshTabNow(selected);
    }

    private final void refreshTabNow(boolean selected) {
        if (!((DockerApplicationRuntime)this.getRuntime()).isRunning()) {
            this.removeBrowser(this.getContent());
            return;
        }
        if (selected && this.myBrowser == null) {
            this.myBrowser = this.createBrowser((DockerApplicationRuntime)this.getRuntime());
        }
    }

    public void dispose() {
        this.myBrowser = null;
    }

    private final DockerContainerBrowser createBrowser(DockerApplicationRuntime runtime2) {
        return this.createBrowser(this.getContent(), runtime2);
    }

    private final DockerContainerBrowser createBrowser(Content content2, DockerApplicationRuntime runtime2) {
        DockerContainerBrowser browser = new DockerContainerBrowser(this.getProject(), runtime2);
        Disposer.register((Disposable)((Disposable)content2), (Disposable)browser);
        JComponent it = content2.getComponent();
        boolean bl = false;
        it.add((Component)browser, "Center");
        it.validate();
        it.repaint();
        return browser;
    }

    private final void removeBrowser(Content content2) {
        DockerContainerBrowser dockerContainerBrowser = this.myBrowser;
        if (dockerContainerBrowser != null) {
            DockerContainerBrowser it = dockerContainerBrowser;
            boolean bl = false;
            JComponent jComponent = content2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent component2 = jComponent;
            component2.removeAll();
            Disposer.dispose((Disposable)it);
            component2.repaint();
        }
        this.myBrowser = null;
    }
}

