/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.DockerConsoleSettings;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.view.details.DockerLogConsoleView;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0014J$\u0010\u001d\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myConsoleSettings", "Lcom/intellij/docker/settings/DockerConsoleSettings;", "mySelectedFoldingPolicy", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$FoldingPolicy;", "myShowFoldingActionGroup", "", "myShowPreviousSessions", "myShowTimestamps", "value", "Ljava/time/ZonedDateTime;", "oldSessionEndDate", "getOldSessionEndDate", "()Ljava/time/ZonedDateTime;", "setOldSessionEndDate", "(Ljava/time/ZonedDateTime;)V", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "updateFoldings", "", "startLine", "", "endLine", "hideOldSessionLines", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "document", "Lcom/intellij/openapi/editor/Document;", "hideTimestampsIfNeeded", "info", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "showOldSessionLines", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerLogConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView\n+ 2 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n*L\n1#1,305:1\n245#2:306\n245#2:307\n245#2:308\n245#2:309\n245#2:310\n*S KotlinDebug\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView\n*L\n238#1:306\n239#1:307\n240#1:308\n241#1:309\n242#1:310\n*E\n"})
public final class DockerLogConsoleView
extends ConsoleViewImpl {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerConsoleSettings myConsoleSettings;
    private volatile boolean myShowFoldingActionGroup;
    private volatile boolean myShowTimestamps;
    private volatile boolean myShowPreviousSessions;
    @NotNull
    private volatile Companion.FoldingPolicy mySelectedFoldingPolicy;
    @Nullable
    private ZonedDateTime oldSessionEndDate;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkYears = Companion.checkYears.1.INSTANCE;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkMonths;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkDays;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkHours;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkMinutes;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkSeconds;

    public DockerLogConsoleView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        this.myConsoleSettings = DockerConsoleSettings.Companion.getInstance();
        this.myShowFoldingActionGroup = this.myConsoleSettings.getEnableFoldingForLogConsole();
        this.mySelectedFoldingPolicy = Companion.FoldingPolicy.MINUTES;
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    this.getComponent();
                    Editor editor = this.getEditor();
                    Object object = editor instanceof EditorEx ? (EditorEx)editor : null;
                    if (object == null || (object = object.getScrollPane()) == null) break block0;
                    JComponent jComponent = (JComponent)object;
                    JBInsets jBInsets = JBUI.insetsRight((int)1);
                    Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsRight(...)");
                    JScrollPane cfr_ignored_0 = (JScrollPane)DockerUiUtilsKt.withBorder(jComponent, (Insets)jBInsets);
                }
            }
        }), (int)1, null);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        boolean bl = false;
        connection.subscribe(DockerConsoleSettings.SettingsChangeListener.Companion.getTOPIC(), () -> DockerLogConsoleView.lambda$1$lambda$0(this));
    }

    @Nullable
    public final ZonedDateTime getOldSessionEndDate() {
        return this.oldSessionEndDate;
    }

    public final void setOldSessionEndDate(@Nullable ZonedDateTime value) {
        ZonedDateTime zonedDateTime = value;
        this.oldSessionEndDate = zonedDateTime != null ? zonedDateTime.plus(1L, ChronoUnit.NANOS) : null;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        Object[] objectArray = DockerBundle.message("DockerLogConsoleView.folding.action.title", new Object[0]);
        ActionGroup group2 = new ActionGroup(this, (String)objectArray){
            final /* synthetic */ DockerLogConsoleView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, true);
                this.getTemplatePresentation().setIcon(AllIcons.General.InspectionsEye);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(DockerLogConsoleView.access$getMyShowFoldingActionGroup$p(this.this$0));
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[3];
                String string = DockerBundle.message("DockerLogConsoleView.checkbox.show.previous.sessions.lines", new Object[0]);
                anActionArray[0] = new ToggleAction(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        DockerLogConsoleView.access$setMyShowPreviousSessions$p(this.this$0, state);
                        this.this$0.foldImmediately();
                    }

                    public void update(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.getPresentation().setEnabledAndVisible(this.this$0.getOldSessionEndDate() != null);
                        super.update(e);
                    }

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        return DockerLogConsoleView.access$getMyShowPreviousSessions$p(this.this$0);
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }
                };
                string = DockerBundle.message("DockerLogConsoleView.checkbox.show.timestamps", new Object[0]);
                anActionArray[1] = new ToggleAction(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        return DockerLogConsoleView.access$getMyShowTimestamps$p(this.this$0);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        DockerLogConsoleView.access$setMyShowTimestamps$p(this.this$0, state);
                        this.this$0.foldImmediately();
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }
                };
                string = DockerBundle.message("DockerLogConsoleView.label.folding.for.previous.sessions.lines.by", new Object[0]);
                anActionArray[2] = new DefaultActionGroup(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, true);
                    }

                    public void update(@NotNull AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.getPresentation().setEnabledAndVisible(DockerLogConsoleView.access$getMyShowPreviousSessions$p(this.this$0));
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Companion.FoldingPolicy[] foldingPolicyArray = Companion.FoldingPolicy.values();
                        DockerLogConsoleView dockerLogConsoleView = this.this$0;
                        boolean $i$f$map = false;
                        void var5_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        int n = ((void)$this$mapTo$iv$iv).length;
                        for (int i = 0; i < n; ++i) {
                            void it;
                            void item$iv$iv;
                            void var11_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getLabel();
                            collection.add(new ToggleAction(dockerLogConsoleView, (Companion.FoldingPolicy)it, string){
                                final /* synthetic */ DockerLogConsoleView this$0;
                                final /* synthetic */ Companion.FoldingPolicy $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super($super_call_param$1);
                                }

                                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    DockerLogConsoleView.access$setMySelectedFoldingPolicy$p(this.this$0, this.$it);
                                    this.this$0.foldImmediately();
                                }

                                public boolean isSelected(@NotNull AnActionEvent e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    return DockerLogConsoleView.access$getMySelectedFoldingPolicy$p(this.this$0) == this.$it;
                                }

                                @NotNull
                                public ActionUpdateThread getActionUpdateThread() {
                                    return ActionUpdateThread.BGT;
                                }
                            });
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new AnAction[0]);
                    }
                };
                return anActionArray;
            }
        };
        objectArray = new AnAction[]{group2, new Separator()};
        AnAction[] anActionArray = super.createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"createConsoleActions(...)");
        return (AnAction[])ArraysKt.plus((Object[])objectArray, (Object[])anActionArray);
    }

    protected void updateFoldings(int startLine, int endLine) {
        FoldingModelEx foldingModel;
        super.updateFoldings(startLine, endLine);
        if (!this.myConsoleSettings.getEnableFoldingForLogConsole()) {
            return;
        }
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        FoldingModel foldingModel2 = this.getEditor().getFoldingModel();
        FoldingModelEx foldingModelEx = foldingModel = foldingModel2 instanceof FoldingModelEx ? (FoldingModelEx)foldingModel2 : null;
        if (foldingModel == null) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> DockerLogConsoleView.updateFoldings$lambda$2(this, foldingModel, document2, startLine, endLine));
    }

    private final void showOldSessionLines(FoldingModelEx $this$showOldSessionLines, Document document) {
        Companion.FoldingPolicy foldingPolicy = this.mySelectedFoldingPolicy;
        Companion.LineInfo firstMatch = null;
        Integer lastMatchEnd = null;
        int n = document.getLineCount();
        for (int line = 0; line < n; ++line) {
            Companion.LineInfo lineInfo;
            if (DockerLogConsoleView.Companion.lineInfoFor(document, line) == null) continue;
            this.hideTimestampsIfNeeded($this$showOldSessionLines, lineInfo);
            if (foldingPolicy == Companion.FoldingPolicy.NONE || lineInfo.getTimestampText().compareTo(String.valueOf(this.oldSessionEndDate)) > 0) continue;
            if (firstMatch == null) {
                firstMatch = lineInfo;
                continue;
            }
            if (firstMatch.getTimestamp() == null || lineInfo.getTimestamp() == null) continue;
            ZonedDateTime zonedDateTime = lineInfo.getTimestamp();
            ZonedDateTime zonedDateTime2 = this.oldSessionEndDate;
            Intrinsics.checkNotNull((Object)zonedDateTime2);
            boolean isLastLine = Intrinsics.areEqual((Object)zonedDateTime, (Object)zonedDateTime2.minus(1L, ChronoUnit.NANOS));
            Function2<ZonedDateTime, ZonedDateTime, Boolean> function2 = foldingPolicy.getMatch();
            ZonedDateTime zonedDateTime3 = firstMatch.getTimestamp();
            Intrinsics.checkNotNull((Object)zonedDateTime3);
            ZonedDateTime zonedDateTime4 = lineInfo.getTimestamp();
            Intrinsics.checkNotNull((Object)zonedDateTime4);
            if (!((Boolean)function2.invoke((Object)zonedDateTime3, (Object)zonedDateTime4)).booleanValue() || isLastLine) {
                if (lastMatchEnd != null) {
                    int foldingEndOffset = isLastLine ? lineInfo.getEndOffset() : lastMatchEnd.intValue();
                    DockerLogConsoleView.Companion.collapse($this$showOldSessionLines.addFoldRegion(firstMatch.getStartOffset(), foldingEndOffset, DockerLogConsoleView.Companion.toPlaceholderText(firstMatch)));
                } else {
                    DockerLogConsoleView.Companion.collapse($this$showOldSessionLines.addFoldRegion(firstMatch.getStartOffset(), firstMatch.getEndOffset(), DockerLogConsoleView.Companion.toPlaceholderText(firstMatch)));
                }
                firstMatch = lineInfo;
                lastMatchEnd = null;
                continue;
            }
            lastMatchEnd = lineInfo.getEndOffset();
        }
    }

    private final void hideTimestampsIfNeeded(FoldingModelEx $this$hideTimestampsIfNeeded, Companion.LineInfo info) {
        block2: {
            if (this.myShowTimestamps) break block2;
            int endOffset = Math.min(info.getStartOffset() + info.getTimestampText().length() + 1, this.getEditor().getDocument().getTextLength());
            FoldRegion oldRegion = $this$hideTimestampsIfNeeded.getFoldRegion(info.getStartOffset(), endOffset);
            if (oldRegion == null) {
                FoldRegion foldRegion = $this$hideTimestampsIfNeeded.createFoldRegion(info.getStartOffset(), endOffset, "", null, true);
                if (foldRegion != null) {
                    FoldRegion it = foldRegion;
                    boolean bl = false;
                    it.setExpanded(false);
                }
            }
        }
    }

    private final void hideOldSessionLines(FoldingModelEx $this$hideOldSessionLines, int startLine, int endLine, Document document) {
        int line = startLine;
        if (line <= endLine) {
            while (true) {
                if (DockerLogConsoleView.Companion.lineInfoFor(document, line) != null) {
                    Companion.LineInfo lineInfo;
                    int endOffset = Math.min(lineInfo.getEndOffset() + 1, document.getTextLength());
                    if (this.oldSessionEndDate != null && lineInfo.getTimestampText().compareTo(String.valueOf(this.oldSessionEndDate)) <= 0) {
                        DockerLogConsoleView.Companion.collapse($this$hideOldSessionLines.createFoldRegion(lineInfo.getStartOffset(), endOffset, "", null, true));
                    }
                    this.hideTimestampsIfNeeded($this$hideOldSessionLines, lineInfo);
                }
                if (line == endLine) break;
                ++line;
            }
        }
    }

    private static final void lambda$1$lambda$0(DockerLogConsoleView this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.myShowFoldingActionGroup = this$0.myConsoleSettings.getEnableFoldingForLogConsole();
        this$0.foldImmediately();
    }

    private static final void updateFoldings$lambda$2(DockerLogConsoleView this$0, FoldingModelEx $foldingModel, Document $document, int $startLine, int $endLine) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        if (this$0.myShowPreviousSessions) {
            this$0.showOldSessionLines($foldingModel, $document);
        } else {
            this$0.hideOldSessionLines($foldingModel, $startLine, $endLine, $document);
        }
    }

    public static final /* synthetic */ boolean access$getMyShowFoldingActionGroup$p(DockerLogConsoleView $this) {
        return $this.myShowFoldingActionGroup;
    }

    public static final /* synthetic */ void access$setMyShowPreviousSessions$p(DockerLogConsoleView $this, boolean bl) {
        $this.myShowPreviousSessions = bl;
    }

    public static final /* synthetic */ boolean access$getMyShowPreviousSessions$p(DockerLogConsoleView $this) {
        return $this.myShowPreviousSessions;
    }

    public static final /* synthetic */ boolean access$getMyShowTimestamps$p(DockerLogConsoleView $this) {
        return $this.myShowTimestamps;
    }

    public static final /* synthetic */ void access$setMyShowTimestamps$p(DockerLogConsoleView $this, boolean bl) {
        $this.myShowTimestamps = bl;
    }

    public static final /* synthetic */ void access$setMySelectedFoldingPolicy$p(DockerLogConsoleView $this, Companion.FoldingPolicy foldingPolicy) {
        $this.mySelectedFoldingPolicy = foldingPolicy;
    }

    public static final /* synthetic */ Companion.FoldingPolicy access$getMySelectedFoldingPolicy$p(DockerLogConsoleView $this) {
        return $this.mySelectedFoldingPolicy;
    }

    static {
        Companion companion = Companion;
        Function2<ZonedDateTime, ZonedDateTime, Boolean> $this$thenCheck$iv = checkYears;
        boolean $i$f$thenCheck = false;
        checkMonths = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getMonth() == d22.getMonth()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        Companion this_$iv = Companion;
        $this$thenCheck$iv = checkMonths;
        $i$f$thenCheck = false;
        checkDays = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getDayOfMonth() == d22.getDayOfMonth()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkDays;
        $i$f$thenCheck = false;
        checkHours = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getHour() == d22.getHour()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkHours;
        $i$f$thenCheck = false;
        checkMinutes = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getMinute() == d22.getMinute()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkMinutes;
        $i$f$thenCheck = false;
        checkSeconds = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getSecond() == d22.getSecond()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e*\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0002J\u0019\u0010\u0012\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JY\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007*\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u00072\u001e\b\u0004\u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007H\u0082\bJ\f\u0010\u001b\u001a\u00020\u0011*\u00020\u0018H\u0002R$\u0010\u0003\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion;", "", "()V", "checkDays", "Lkotlin/Function2;", "Ljava/time/ZonedDateTime;", "", "Lcom/intellij/docker/view/details/TimeChecker;", "checkHours", "checkMinutes", "checkMonths", "checkSeconds", "checkYears", "collapse", "", "Lcom/intellij/openapi/editor/FoldRegion;", "extractTimestampText", "", "getLineText", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/editor/Document;", "index", "", "lineInfoFor", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "thenCheck", "next", "toPlaceholderText", "FoldingPolicy", "LineInfo", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerLogConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,305:1\n1064#2,2:306\n*S KotlinDebug\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n*L\n271#1:306,2\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Function2<ZonedDateTime, ZonedDateTime, Boolean> thenCheck(Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> $this$thenCheck, Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> next2) {
            boolean $i$f$thenCheck = false;
            return (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck, next2){
                final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, Boolean> $this_thenCheck;
                final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, Boolean> $next;
                {
                    this.$this_thenCheck = $receiver;
                    this.$next = $next;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull ZonedDateTime d1, @NotNull ZonedDateTime d2) {
                    Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                    Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                    return (Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2) != false && (Boolean)this.$next.invoke((Object)d1, (Object)d2) != false;
                }
            };
        }

        private final String toPlaceholderText(LineInfo $this$toPlaceholderText) {
            String string = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss").format($this$toPlaceholderText.getTimestamp());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        private final void collapse(FoldRegion $this$collapse) {
            FoldRegion foldRegion = $this$collapse;
            if (foldRegion != null) {
                foldRegion.setExpanded(false);
            }
        }

        private final LineInfo lineInfoFor(Document $this$lineInfoFor, int index) {
            int lineStart = $this$lineInfoFor.getLineStartOffset(index);
            int lineEnd = $this$lineInfoFor.getLineEndOffset(index);
            String lineText = this.getLineText($this$lineInfoFor, index);
            String string = this.extractTimestampText(lineText);
            if (string == null) {
                return null;
            }
            String timestampText = string;
            return new LineInfo(lineStart, lineEnd, lineText, timestampText);
        }

        private final String getLineText(Document $this$getLineText, int index) {
            String string = EditorHyperlinkSupport.getLineText((Document)$this$getLineText, (int)index, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineText(...)");
            return string;
        }

        private final String extractTimestampText(String $this$extractTimestampText) {
            if ($this$extractTimestampText.length() >= 30) {
                boolean bl;
                String text2;
                block3: {
                    String string = $this$extractTimestampText.substring(0, 30);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    text2 = string;
                    String string2 = text2.substring(0, 4);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    CharSequence $this$all$iv = string2;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char p0 = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Character.isDigit(p0)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl && StringsKt.endsWith$default((String)text2, (String)"Z", (boolean)false, (int)2, null)) {
                    return text2;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR'\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$FoldingPolicy;", "", "label", "", "match", "Lkotlin/Function2;", "Ljava/time/ZonedDateTime;", "", "Lcom/intellij/docker/view/details/TimeChecker;", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getLabel", "()Ljava/lang/String;", "getMatch", "()Lkotlin/jvm/functions/Function2;", "toString", "NONE", "SECONDS", "MINUTES", "HOURS", "DAYS", "MONTHS", "YEARS", "intellij.clouds.docker"})
        private static final class FoldingPolicy
        extends Enum<FoldingPolicy> {
            @NotNull
            private final String label;
            @NotNull
            private final Function2<ZonedDateTime, ZonedDateTime, Boolean> match;
            public static final /* enum */ FoldingPolicy NONE;
            public static final /* enum */ FoldingPolicy SECONDS;
            public static final /* enum */ FoldingPolicy MINUTES;
            public static final /* enum */ FoldingPolicy HOURS;
            public static final /* enum */ FoldingPolicy DAYS;
            public static final /* enum */ FoldingPolicy MONTHS;
            public static final /* enum */ FoldingPolicy YEARS;
            private static final /* synthetic */ FoldingPolicy[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private FoldingPolicy(String label2, Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> match) {
                this.label = label2;
                this.match = match;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            @NotNull
            public final Function2<ZonedDateTime, ZonedDateTime, Boolean> getMatch() {
                return this.match;
            }

            @NotNull
            public String toString() {
                return this.label;
            }

            public static FoldingPolicy[] values() {
                return (FoldingPolicy[])$VALUES.clone();
            }

            public static FoldingPolicy valueOf(String value) {
                return Enum.valueOf(FoldingPolicy.class, value);
            }

            @NotNull
            public static EnumEntries<FoldingPolicy> getEntries() {
                return $ENTRIES;
            }

            static {
                String string = DockerBundle.message("DockerLogConsoleView.folding.policy.none", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                NONE = new FoldingPolicy(string, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)((Function2)1.INSTANCE));
                String string2 = DockerBundle.message("DockerLogConsoleView.folding.policy.seconds", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                SECONDS = new FoldingPolicy(string2, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkSeconds);
                String string3 = DockerBundle.message("DockerLogConsoleView.folding.policy.minutes", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                MINUTES = new FoldingPolicy(string3, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkMinutes);
                String string4 = DockerBundle.message("DockerLogConsoleView.folding.policy.hours", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                HOURS = new FoldingPolicy(string4, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkHours);
                String string5 = DockerBundle.message("DockerLogConsoleView.folding.policy.days", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                DAYS = new FoldingPolicy(string5, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkDays);
                String string6 = DockerBundle.message("DockerLogConsoleView.folding.policy.months", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                MONTHS = new FoldingPolicy(string6, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkMonths);
                String string7 = DockerBundle.message("DockerLogConsoleView.folding.policy.years", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                YEARS = new FoldingPolicy(string7, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkYears);
                $VALUES = foldingPolicyArray = new FoldingPolicy[]{FoldingPolicy.NONE, FoldingPolicy.SECONDS, FoldingPolicy.MINUTES, FoldingPolicy.HOURS, FoldingPolicy.DAYS, FoldingPolicy.MONTHS, FoldingPolicy.YEARS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "", "startOffset", "", "endOffset", "text", "", "timestampText", "(IILjava/lang/String;Ljava/lang/String;)V", "getEndOffset", "()I", "getStartOffset", "getText", "()Ljava/lang/String;", "timestamp", "Ljava/time/ZonedDateTime;", "getTimestamp", "()Ljava/time/ZonedDateTime;", "timestamp$delegate", "Lkotlin/Lazy;", "getTimestampText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.docker"})
        private static final class LineInfo {
            private final int startOffset;
            private final int endOffset;
            @NotNull
            private final String text;
            @NotNull
            private final String timestampText;
            @NotNull
            private final Lazy timestamp$delegate;

            public LineInfo(int startOffset, int endOffset, @NotNull String text2, @NotNull String timestampText) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)timestampText, (String)"timestampText");
                this.startOffset = startOffset;
                this.endOffset = endOffset;
                this.text = text2;
                this.timestampText = timestampText;
                this.timestamp$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ZonedDateTime>(this){
                    final /* synthetic */ LineInfo this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final ZonedDateTime invoke() {
                        Object object;
                        Object object2 = this.this$0;
                        try {
                            boolean bl = false;
                            object = Result.constructor-impl((Object)ZonedDateTime.parse(((LineInfo)object2).getTimestampText()).truncatedTo(ChronoUnit.NANOS));
                        }
                        catch (Throwable throwable) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object2 = object;
                        return (ZonedDateTime)(Result.isFailure-impl((Object)object2) ? null : object2);
                    }
                }));
            }

            public final int getStartOffset() {
                return this.startOffset;
            }

            public final int getEndOffset() {
                return this.endOffset;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final String getTimestampText() {
                return this.timestampText;
            }

            @Nullable
            public final ZonedDateTime getTimestamp() {
                Lazy lazy = this.timestamp$delegate;
                return (ZonedDateTime)lazy.getValue();
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.endOffset;
            }

            @NotNull
            public final String component3() {
                return this.text;
            }

            @NotNull
            public final String component4() {
                return this.timestampText;
            }

            @NotNull
            public final LineInfo copy(int startOffset, int endOffset, @NotNull String text2, @NotNull String timestampText) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)timestampText, (String)"timestampText");
                return new LineInfo(startOffset, endOffset, text2, timestampText);
            }

            public static /* synthetic */ LineInfo copy$default(LineInfo lineInfo, int n, int n2, String string, String string2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = lineInfo.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = lineInfo.endOffset;
                }
                if ((n3 & 4) != 0) {
                    string = lineInfo.text;
                }
                if ((n3 & 8) != 0) {
                    string2 = lineInfo.timestampText;
                }
                return lineInfo.copy(n, n2, string, string2);
            }

            @NotNull
            public String toString() {
                return "LineInfo(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", text=" + this.text + ", timestampText=" + this.timestampText + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.endOffset);
                result2 = result2 * 31 + this.text.hashCode();
                result2 = result2 * 31 + this.timestampText.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LineInfo)) {
                    return false;
                }
                LineInfo lineInfo = (LineInfo)other;
                if (this.startOffset != lineInfo.startOffset) {
                    return false;
                }
                if (this.endOffset != lineInfo.endOffset) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.text, (Object)lineInfo.text)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.timestampText, (Object)lineInfo.timestampText);
            }
        }
    }
}

