/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerRootType;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0001\u00a8\u0006\b"}, d2={"getOrCreateScratchFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "content", "", "writeNewContentIfFileExist", "", "intellij.clouds.docker"})
public final class ScratchUtilsKt {
    @RequiresWriteLock
    @NotNull
    public static final VirtualFile getOrCreateScratchFile(@NotNull String path, @NotNull byte[] content2, boolean writeNewContentIfFileExist) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ScratchFileService scratchService = ScratchFileService.getInstance();
        DockerRootType dockerRootType = DockerRootType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerRootType), (String)"getInstance(...)");
        DockerRootType dockerRootType2 = dockerRootType;
        VirtualFile virtualFile3 = scratchService.findFile((RootType)dockerRootType2, path, ScratchFileService.Option.existing_only);
        if (virtualFile3 != null) {
            VirtualFile virtualFile4;
            VirtualFile oldFile = virtualFile4 = virtualFile3;
            boolean bl = false;
            if (writeNewContentIfFileExist) {
                VirtualFileUtil.writeBytes((VirtualFile)oldFile, (byte[])content2);
            }
            virtualFile2 = virtualFile4;
        } else {
            VirtualFile virtualFile5;
            VirtualFile newFile = virtualFile5 = scratchService.findFile((RootType)dockerRootType2, path, ScratchFileService.Option.create_if_missing);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)newFile);
            VirtualFileUtil.writeBytes((VirtualFile)newFile, (byte[])content2);
            VirtualFile virtualFile6 = virtualFile5;
            virtualFile2 = virtualFile6;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile6, (String)"also(...)");
        }
        return virtualFile2;
    }

    public static /* synthetic */ VirtualFile getOrCreateScratchFile$default(String string, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return ScratchUtilsKt.getOrCreateScratchFile(string, byArray, bl);
    }
}

