/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes.deploy;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.runtimes.DockerDeployingRuntime;
import com.intellij.docker.runtimes.DockerFailedRuntime;
import com.intellij.docker.runtimes.DockerRuntimeBase;
import com.intellij.docker.runtimes.DockerRuntimeKt;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.docker.runtimes.deploy.DockerDeployerCallback;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtensionsManager;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerStateProvider;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentTaskImpl;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/runtimes/deploy/DockerDeployToServerStateProvider;", "Lcom/intellij/remoteServer/impl/configuration/deployment/DeployToServerStateProvider;", "()V", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "executor", "Lcom/intellij/execution/Executor;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "source", "Lcom/intellij/remoteServer/configuration/deployment/DeploymentSource;", "config", "Lcom/intellij/remoteServer/configuration/deployment/DeploymentConfiguration;", "DockerState", "intellij.clouds.docker"})
public final class DockerDeployToServerStateProvider
implements DeployToServerStateProvider {
    @Nullable
    public RunProfileState getState(@NotNull RemoteServer<?> server, @NotNull Executor executor, @NotNull ExecutionEnvironment env2, @NotNull DeploymentSource source, @NotNull DeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)env2, (String)"env");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!(config instanceof DockerDeploymentConfiguration)) {
            return null;
        }
        if (!(server.getConfiguration() instanceof DockerCloudConfiguration)) {
            return null;
        }
        return new DockerState(source, env2, (DockerDeploymentConfiguration)config, server);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/runtimes/deploy/DockerDeployToServerStateProvider$DockerState;", "Lcom/intellij/execution/configurations/RunProfileState;", "source", "Lcom/intellij/remoteServer/configuration/deployment/DeploymentSource;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "(Lcom/intellij/remoteServer/configuration/deployment/DeploymentSource;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/docker/DockerDeploymentConfiguration;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerDeployToServerStateProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerDeployToServerStateProvider.kt\ncom/intellij/docker/runtimes/deploy/DockerDeployToServerStateProvider$DockerState\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n50#2:81\n*S KotlinDebug\n*F\n+ 1 DockerDeployToServerStateProvider.kt\ncom/intellij/docker/runtimes/deploy/DockerDeployToServerStateProvider$DockerState\n*L\n56#1:81\n*E\n"})
    private static final class DockerState
    implements RunProfileState {
        @NotNull
        private final DeploymentSource source;
        @NotNull
        private final ExecutionEnvironment env;
        @NotNull
        private final DockerDeploymentConfiguration config;
        @NotNull
        private final RemoteServer<DockerCloudConfiguration> server;

        public DockerState(@NotNull DeploymentSource source, @NotNull ExecutionEnvironment env2, @NotNull DockerDeploymentConfiguration config, @NotNull RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)env2, (String)"env");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(server, (String)"server");
            this.source = source;
            this.env = env2;
            this.config = config;
            this.server = server;
        }

        @Nullable
        public ExecutionResult execute(@Nullable Executor executor, @NotNull ProgramRunner<?> runner) {
            DebugConnector debugConnector;
            Intrinsics.checkNotNullParameter(runner, (String)"runner");
            if (Intrinsics.areEqual((Object)DefaultDebugExecutor.getDebugExecutorInstance(), (Object)executor)) {
                boolean $i$f$serviceOrNull = false;
                Application application = ApplicationManager.getApplication();
                debugConnector = (DebugConnector)(application != null ? application.getService(DebugConnector.class) : null);
            } else {
                debugConnector = null;
            }
            DebugConnector debugConnector2 = debugConnector;
            DeploymentTaskImpl task2 = new DeploymentTaskImpl(this.source, (DeploymentConfiguration)this.config, this.env.getProject(), debugConnector2, this.env);
            DeployToServerRunConfigurationExtensionsManager.getInstance().patchDeploymentTask((DeploymentTask)task2);
            Project project = this.env.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DockerServerRuntimesManager manager = DockerServerRuntimesManager.Companion.getInstance(project);
            DockerUiUtilsKt.select(manager.getServerRuntime$intellij_clouds_docker(this.server));
            manager.getOrCreateConnection(this.server).thenAccept(arg_0 -> DockerState.execute$lambda$0((Function1)new Function1<DockerServerRuntime, Unit>((DeploymentTaskImpl<DockerDeploymentConfiguration>)task2){
                final /* synthetic */ DeploymentTaskImpl<DockerDeploymentConfiguration> $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final void invoke(DockerServerRuntime it) {
                    Intrinsics.checkNotNull((Object)it);
                    DockerRuntimeKt.deploy(it, (DeploymentTask<DockerDeploymentConfiguration>)((DeploymentTask)this.$task), new DockerDeployerCallback<DockerRuntimeBase>(){

                        public void onStarted(@NotNull DockerDeployingRuntime runtime2) {
                            Intrinsics.checkNotNullParameter((Object)runtime2, (String)"runtime");
                            DockerUiUtilsKt.select(runtime2);
                        }

                        public void onError(@NotNull DockerFailedRuntime failedRuntime) {
                            Intrinsics.checkNotNullParameter((Object)failedRuntime, (String)"failedRuntime");
                            DockerUiUtilsKt.select(failedRuntime);
                        }

                        public void onFinished(@NotNull DockerRuntimeBase runtime2) {
                            Intrinsics.checkNotNullParameter((Object)runtime2, (String)"runtime");
                            DockerUiUtilsKt.select(runtime2);
                        }
                    });
                }
            }, arg_0));
            return null;
        }

        private static final void execute$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }
}

