/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes.deploy;

import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.cli.compose.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.cli.DockerCliExecutor;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.debug.DeploymentConfigTransformer;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeCliExecutor;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.DockerDeployingRuntime;
import com.intellij.docker.runtimes.DockerFailedRuntime;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeContextKt;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.DockerRuntimeVirtualFileNavigatable;
import com.intellij.docker.runtimes.deploy.DockerComposeDeployer;
import com.intellij.docker.runtimes.deploy.DockerComposeDeployerKt;
import com.intellij.docker.runtimes.deploy.DockerDeployer;
import com.intellij.docker.runtimes.deploy.DockerDeployerCallback;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.docker.view.details.DockerLoggingHandlerTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001.B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\b%J \u0010&\u001a\u00020#2\u000e\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020(2\u0006\u0010)\u001a\u00020\u000eH\u0016J\u0016\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0082@\u00a2\u0006\u0002\u0010-R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;", "Lcom/intellij/docker/runtimes/deploy/DockerDeployer;", "Lcom/intellij/docker/runtimes/ComposeDeploymentRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "task", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;)V", "cliExecutor", "Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "getCliExecutor", "()Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "<set-?>", "", "composeProjectName", "getComposeProjectName", "()Ljava/lang/String;", "Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer$DeployInfo;", "deployInfo", "getDeployInfo", "()Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer$DeployInfo;", "myMergedEnvironment", "", "runtimeNavigatable", "Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "getRuntimeNavigatable", "()Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "runtimeNavigatableLazy", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Ljava/io/File;", "workDirectory", "getWorkDirectory", "()Ljava/io/File;", "appendDeploymentTask", "", "newDeploymentTask", "appendDeploymentTask$intellij_clouds_docker", "deployAsync", "callback", "Lcom/intellij/docker/runtimes/deploy/DockerDeployerCallback;", "displayName", "doDeploy", "pipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "(Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DeployInfo", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeDeployer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeDeployer.kt\ncom/intellij/docker/runtimes/deploy/DockerComposeDeployer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n50#2:288\n1549#3:289\n1620#3,3:290\n*S KotlinDebug\n*F\n+ 1 DockerComposeDeployer.kt\ncom/intellij/docker/runtimes/deploy/DockerComposeDeployer\n*L\n160#1:288\n167#1:289\n167#1:290,3\n*E\n"})
public final class DockerComposeDeployer
implements DockerDeployer<ComposeDeploymentRuntime> {
    @NotNull
    private final DockerRuntimeContext context;
    @NotNull
    private final ComposeCliExecutor cliExecutor;
    @NotNull
    private final Map<String, String> myMergedEnvironment;
    @NotNull
    private File workDirectory;
    @NotNull
    private String composeProjectName;
    @NotNull
    private DeployInfo deployInfo;
    @NotNull
    private final SynchronizedClearableLazy<DockerRuntimeNavigatable> runtimeNavigatableLazy;

    public DockerComposeDeployer(@NotNull DockerRuntimeContext context, @NotNull DeploymentTask<DockerDeploymentConfiguration> task2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        this.context = context;
        this.cliExecutor = new ComposeCliExecutor(this.context);
        this.myMergedEnvironment = new LinkedHashMap();
        List<File> composeFiles2 = DockerComposeDeployerKt.getComposeFiles(task2);
        this.deployInfo = new DeployInfo(composeFiles2, task2);
        this.workDirectory = DockerComposeDeployerKt.access$computeWorkingDir(composeFiles2);
        this.composeProjectName = DockerComposeDeployerKt.access$computeComposeProjectName(task2, this.context, composeFiles2, this.workDirectory);
        this.myMergedEnvironment.putAll(DockerComposeDeployerKt.access$getTaskEnvironment(task2));
        this.runtimeNavigatableLazy = new SynchronizedClearableLazy((Function0)new Function0<DockerRuntimeNavigatable>(this){
            final /* synthetic */ DockerComposeDeployer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DockerRuntimeNavigatable invoke() {
                Project project = this.this$0.getDeployInfo().getTask().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return new DockerRuntimeVirtualFileNavigatable(project, (Function0<? extends VirtualFile>)((Function0)new Function0<VirtualFile>(this.this$0){
                    final /* synthetic */ DockerComposeDeployer this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final VirtualFile invoke() {
                        File mainFile = (File)CollectionsKt.firstOrNull(this.this$0.getDeployInfo().getComposeFiles());
                        return mainFile != null ? LocalFileSystem.getInstance().findFileByIoFile(mainFile) : null;
                    }
                }));
            }
        });
    }

    @NotNull
    public final ComposeCliExecutor getCliExecutor() {
        return this.cliExecutor;
    }

    @NotNull
    public final File getWorkDirectory() {
        return this.workDirectory;
    }

    @NotNull
    public final String getComposeProjectName() {
        return this.composeProjectName;
    }

    @NotNull
    public final DeployInfo getDeployInfo() {
        return this.deployInfo;
    }

    @NotNull
    public final DockerRuntimeNavigatable getRuntimeNavigatable() {
        return (DockerRuntimeNavigatable)this.runtimeNavigatableLazy.getValue();
    }

    public final void appendDeploymentTask$intellij_clouds_docker(@NotNull DeploymentTask<DockerDeploymentConfiguration> newDeploymentTask) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter(newDeploymentTask, (String)"newDeploymentTask");
        List<File> newComposeFiles = DockerComposeDeployerKt.getComposeFiles(newDeploymentTask);
        File newWorkingDirectory = DockerComposeDeployerKt.access$computeWorkingDir(newComposeFiles);
        if (!FileUtil.filesEqual((File)newWorkingDirectory, (File)this.workDirectory)) {
            DockerComposeDeployerKt.access$getLogger().debug("Merging compose deployments from different folders: current work-dir: " + this.workDirectory + ", requested: " + newWorkingDirectory);
        }
        this.composeProjectName = DockerComposeDeployerKt.access$computeComposeProjectName(newDeploymentTask, this.context, newComposeFiles, newWorkingDirectory);
        this.workDirectory = newWorkingDirectory;
        this.deployInfo = new DeployInfo(newComposeFiles, newDeploymentTask);
        this.myMergedEnvironment.putAll(DockerComposeDeployerKt.access$getTaskEnvironment(newDeploymentTask));
        this.runtimeNavigatableLazy.drop();
    }

    @Override
    public void deployAsync(@NotNull DockerDeployerCallback<? super ComposeDeploymentRuntime> callback2, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        DockerRuntimeContextKt.launch$default(this.context, null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback2, displayName, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DockerComposeDeployer this$0;
            final /* synthetic */ DockerDeployerCallback<? super ComposeDeploymentRuntime> $callback;
            final /* synthetic */ String $displayName;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                this.$displayName = $displayName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        loggingPipe = InternalUtilsKt.makeTerminalPipeWithTty().setShowCursor(false);
                        var4_4 /* !! */  = this.this$0.getDeployInfo().getTask().getProject();
                        deployingRuntime = new DockerDeployingRuntime(loggingPipe, this.this$0, var4_4 /* !! */ ){
                            final /* synthetic */ DockerComposeDeployer this$0;
                            {
                                this.this$0 = $receiver;
                                Intrinsics.checkNotNull((Object)$super_call_param$1);
                                super($loggingPipe, $super_call_param$1);
                            }

                            @NotNull
                            public String getPresentableName() {
                                DeploymentSource deploymentSource = this.this$0.getDeployInfo().getTask().getSource();
                                Intrinsics.checkNotNullExpressionValue((Object)deploymentSource, (String)"getSource(...)");
                                DeploymentConfiguration deploymentConfiguration = this.this$0.getDeployInfo().getTask().getConfiguration();
                                Intrinsics.checkNotNullExpressionValue((Object)deploymentConfiguration, (String)"getConfiguration(...)");
                                return DockerUiUtilsKt.getDeploymentName(deploymentSource, (DockerDeploymentConfiguration)deploymentConfiguration);
                            }

                            @NotNull
                            public DockerLoggingHandlerTab.Piped<DockerRuntime> createTerminalTab$intellij_clouds_docker(@NotNull DockerTabManager tabManager2) {
                                Intrinsics.checkNotNullParameter((Object)tabManager2, (String)"tabManager");
                                return ComposeApplicationRuntime.Companion.createConsoleTab$intellij_clouds_docker(this, tabManager2);
                            }

                            public void stopDeploy() {
                                this.this$0.getCliExecutor().cancelCurrentProcess();
                            }
                        };
                        this.L$0 = loggingPipe;
                        this.L$1 = deployingRuntime;
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(deployingRuntime, null){
                            int label;
                            final /* synthetic */ deployAsync.deployingRuntime.1 $deployingRuntime;
                            {
                                this.$deployingRuntime = $deployingRuntime;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        ComposeApplicationRuntime.Companion.selectConsoleTab$intellij_clouds_docker(this.$deployingRuntime);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        deployingRuntime = this.L$1;
                        loggingPipe = (DockerTerminalPipe.WithTty)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        loggingPipe.clearScreen();
                        this.$callback.onStarted(deployingRuntime);
                        var4_4 /* !! */  = this.this$0;
                        $i$a$-runCatching-DockerComposeDeployer$deployAsync$1$2 = false;
                        this.L$0 = deployingRuntime;
                        this.L$1 = null;
                        this.label = 2;
                        v1 = DockerComposeDeployer.access$doDeploy((DockerComposeDeployer)var4_4 /* !! */ , loggingPipe, (Continuation)this);
                        ** if (v1 != var11_2) goto lbl33
lbl32:
                        // 1 sources

                        return var11_2;
lbl33:
                        // 1 sources

                        ** GOTO lbl41
                    }
                    case 2: {
                        $i$a$-runCatching-DockerComposeDeployer$deployAsync$1$2 = false;
                        deployingRuntime = this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl41:
                            // 2 sources

                            var5_7 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable var6_8) {
                            var5_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_8));
                        }
                        var4_4 /* !! */  = var5_7;
                        var5_7 = this.$callback;
                        var6_9 = this.this$0;
                        var7_10 = this.$displayName;
                        v2 = Result.exceptionOrNull-impl((Object)var4_4 /* !! */ );
                        if (v2 != null) {
                            it = var8_11 = v2;
                            $i$a$-onFailure-DockerComposeDeployer$deployAsync$1$3 = false;
                            v3 = DockerComposeDeployer.access$getContext$p(var6_9);
                            v4 = deployingRuntime;
                            v5 = var6_9.getDeployInfo().getTask();
                            v6 = it.getCause();
                            if (v6 == null) {
                                v6 = it;
                            }
                            var5_7.onError(new DockerFailedRuntime(v3, v4, v5, v6, (Function0<Unit>)((Function0)new Function0<Unit>(var6_9, var5_7, var7_10){
                                final /* synthetic */ DockerComposeDeployer this$0;
                                final /* synthetic */ DockerDeployerCallback<? super ComposeDeploymentRuntime> $callback;
                                final /* synthetic */ String $displayName;
                                {
                                    this.this$0 = $receiver;
                                    this.$callback = $callback;
                                    this.$displayName = $displayName;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.this$0.deployAsync(this.$callback, this.$displayName);
                                }
                            })));
                        }
                        var5_7 = this.$callback;
                        var6_9 = this.this$0;
                        if (Result.isSuccess-impl((Object)var4_4 /* !! */ )) {
                            (Unit)var4_4 /* !! */ ;
                            $i$a$-onSuccess-DockerComposeDeployer$deployAsync$1$4 = false;
                            v7 = DockerComposeDeployer.access$getContext$p(var6_9);
                            v8 = deployingRuntime;
                            v9 = var6_9.getDeployInfo().getTask().getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getProject(...)");
                            var5_7.onFinished((ComposeDeploymentRuntime)((DockerRuntime)new ComposeDeploymentRuntime(v7, var6_9, v8, v9)));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object doDeploy(DockerTerminalPipe.WithTty var1_1, Continuation<? super Unit> var2_2) throws ServerRuntimeException {
        block17: {
            if (!(var2_2 instanceof doDeploy.1)) ** GOTO lbl-1000
            var21_3 = var2_2;
            if ((var21_3.label & -2147483648) != 0) {
                var21_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ DockerComposeDeployer this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return DockerComposeDeployer.access$doDeploy(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (DockerComposeDeployerKt.access$shouldRestartOnDeploy(this.deployInfo, this.composeProjectName, this.context)) {
                        var4_6 = this.deployInfo.getServices();
                        v0 = DockerComposeCliUtil.buildRestartCommand(this.context.getServerConfiguration()).withServices(Arrays.copyOf(var4_6, var4_6.length));
                    } else {
                        v0 = DockerComposeCliUtil.from(DockerComposeCliUtil.buildUpCommand(this.context.getServerConfiguration()), this.deployInfo.getDeployment());
                    }
                    cliBuilder = v0;
                    composeFiles = new Ref.ObjectRef();
                    composeFiles.element = this.deployInfo.getComposeFiles();
                    $i$f$serviceOrNull = false;
                    v1 = ApplicationManager.getApplication();
                    transformer = (DeploymentConfigTransformer)(v1 != null ? v1.getService(DeploymentConfigTransformer.class) : null);
                    if (transformer == null || !transformer.isApplicable(this.deployInfo.getTask())) ** GOTO lbl44
                    var19_12 = composeFiles;
                    $continuation.L$0 = this;
                    $continuation.L$1 = pipe;
                    $continuation.L$2 = cliBuilder;
                    $continuation.L$3 = composeFiles;
                    $continuation.L$4 = var19_12;
                    $continuation.label = 1;
                    v2 = transformer.patchComposeFiles((List)composeFiles.element, this.deployInfo.getTask(), (Continuation<? super List<? extends File>>)$continuation);
                    if (v2 == var22_5) {
                        return var22_5;
                    }
                    ** GOTO lbl43
                }
                case 1: {
                    var19_12 = (Ref.ObjectRef)$continuation.L$4;
                    composeFiles = (Ref.ObjectRef)$continuation.L$3;
                    cliBuilder = (AbstractDockerComposeCmdCliBuilder)$continuation.L$2;
                    pipe = (DockerTerminalPipe.WithTty)$continuation.L$1;
                    this = (DockerComposeDeployer)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl43:
                    // 2 sources

                    var19_12.element = v2;
lbl44:
                    // 2 sources

                    $this$doDeploy_u24lambda_u240 = cliBuilder;
                    $i$a$-with-DockerComposeDeployer$doDeploy$2 = false;
                    var8_14 = (Pair[])composeFiles.element;
                    var9_15 = $this$doDeploy_u24lambda_u240;
                    $i$f$map = false;
                    var11_17 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var16_22 = (File)item$iv$iv;
                        var17_23 = destination$iv$iv;
                        $i$a$-map-DockerComposeDeployer$doDeploy$2$1 = false;
                        var17_23.add(p0.toPath());
                    }
                    var9_15.withFiles((List)destination$iv$iv);
                    $this$doDeploy_u24lambda_u240.withProjectName(this.composeProjectName);
                    $this$doDeploy_u24lambda_u240.withEnvFile(this.deployInfo.getEnvFile());
                    var8_14 = new Pair[]{TuplesKt.to((Object)"COMPOSE_DOCKER_CLI_BUILD", (Object)"1"), DockerCliExecutor.Companion.getENABLE_BUILDKIT_ENV(), DockerCliExecutor.Companion.getDISABLE_CLI_HINTS_ENV()};
                    $this$doDeploy_u24lambda_u240.withEnvironment(MapsKt.mapOf((Pair[])var8_14));
                    $continuation.L$0 = this;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.L$4 = null;
                    $continuation.label = 2;
                    v3 = ComposeCliExecutor.executeCli$default(this.cliExecutor, cliBuilder, null, pipe, this.myMergedEnvironment, (Continuation)$continuation, 2, null);
                    ** if (v3 != var22_5) goto lbl80
lbl79:
                    // 1 sources

                    return var22_5;
lbl80:
                    // 1 sources

                    break block17;
                }
                case 2: {
                    this = (DockerComposeDeployer)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        break block17;
                    }
                    catch (ApiTaskException e) {
                        if (!(e.getCause() instanceof ProcessNotCreatedException)) break;
                        $continuation.L$0 = null;
                        $continuation.L$1 = null;
                        $continuation.L$2 = null;
                        $continuation.L$3 = null;
                        $continuation.L$4 = null;
                        $continuation.label = 3;
                        v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                            int label;
                            final /* synthetic */ DockerComposeDeployer this$0;
                            final /* synthetic */ ApiTaskException $e;
                            {
                                this.this$0 = $receiver;
                                this.$e = $e;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Project project = this.this$0.getDeployInfo().getTask().getProject();
                                        Throwable throwable = this.$e.getCause();
                                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type com.intellij.execution.process.ProcessNotCreatedException");
                                        DockerComposeCliUtil.notifyDockerComposeExecutionFailed(project, (ProcessNotCreatedException)throwable);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v4 == var22_5) {
                            return var22_5;
                        }
                        break block17;
                    }
                }
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
                    break block17;
                }
            }
            DockerComposeDeployerKt.access$getLogger().warn((Throwable)e);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$doDeploy(DockerComposeDeployer $this, DockerTerminalPipe.WithTty pipe, Continuation $completion) {
        return $this.doDeploy(pipe, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ DockerRuntimeContext access$getContext$p(DockerComposeDeployer $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer$DeployInfo;", "", "composeFiles", "", "Ljava/io/File;", "task", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "(Ljava/util/List;Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;)V", "getComposeFiles", "()Ljava/util/List;", "deployment", "getDeployment", "()Lcom/intellij/docker/DockerDeploymentConfiguration;", "downOptions", "Lcom/intellij/docker/DockerComposeDownOptions;", "getDownOptions", "()Lcom/intellij/docker/DockerComposeDownOptions;", "envFile", "", "getEnvFile", "()Ljava/lang/String;", "services", "", "getServices", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getTask", "()Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "intellij.clouds.docker"})
    public static final class DeployInfo {
        @NotNull
        private final List<File> composeFiles;
        @NotNull
        private final DeploymentTask<DockerDeploymentConfiguration> task;
        @NotNull
        private final DockerDeploymentConfiguration deployment;
        @NotNull
        private final DockerComposeDownOptions downOptions;
        @Nullable
        private final String envFile;
        @NotNull
        private final String[] services;

        public DeployInfo(@NotNull List<? extends File> composeFiles2, @NotNull DeploymentTask<DockerDeploymentConfiguration> task2) {
            Intrinsics.checkNotNullParameter(composeFiles2, (String)"composeFiles");
            Intrinsics.checkNotNullParameter(task2, (String)"task");
            this.composeFiles = composeFiles2;
            this.task = task2;
            DeploymentConfiguration deploymentConfiguration = this.task.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)deploymentConfiguration, (String)"getConfiguration(...)");
            this.deployment = (DockerDeploymentConfiguration)deploymentConfiguration;
            this.downOptions = this.deployment.copyComposeDownOptions();
            this.envFile = this.deployment.getEnvFilePath();
            String[] stringArray = ArrayUtilRt.toStringArray((Collection)this.deployment.getServices());
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
            this.services = stringArray;
        }

        @NotNull
        public final List<File> getComposeFiles() {
            return this.composeFiles;
        }

        @NotNull
        public final DeploymentTask<DockerDeploymentConfiguration> getTask() {
            return this.task;
        }

        @NotNull
        public final DockerDeploymentConfiguration getDeployment() {
            return this.deployment;
        }

        @NotNull
        public final DockerComposeDownOptions getDownOptions() {
            return this.downOptions;
        }

        @Nullable
        public final String getEnvFile() {
            return this.envFile;
        }

        @NotNull
        public final String[] getServices() {
            return this.services;
        }
    }
}

