/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerComposeDownOptions;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeCliExecutor;
import com.intellij.docker.runtimes.DockerDeployedRuntime;
import com.intellij.docker.runtimes.DockerDeployingRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.docker.runtimes.DockerRuntimeNavigatable;
import com.intellij.docker.runtimes.deploy.DockerComposeDeployer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.text.StringKt;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B'\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0014J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\rH\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/intellij/docker/runtimes/ComposeDeploymentRuntime;", "Lcom/intellij/docker/runtimes/ComposeApplicationRuntime;", "Lcom/intellij/docker/runtimes/DockerDeployedRuntime;", "context", "Lcom/intellij/docker/runtimes/DockerRuntimeContext;", "deployer", "Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;", "deployingRuntime", "Lcom/intellij/docker/runtimes/DockerDeployingRuntime;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/runtimes/DockerRuntimeContext;Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;Lcom/intellij/docker/runtimes/DockerDeployingRuntime;Lcom/intellij/openapi/project/Project;)V", "composeProjectName", "", "getComposeProjectName", "()Ljava/lang/String;", "getDeployer$intellij_clouds_docker", "()Lcom/intellij/docker/runtimes/deploy/DockerComposeDeployer;", "getDeployingRuntime", "()Lcom/intellij/docker/runtimes/DockerDeployingRuntime;", "executor", "Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "getExecutor", "()Lcom/intellij/docker/runtimes/ComposeCliExecutor;", "loggingPipe", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "getLoggingPipe", "()Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "runtimeNavigatable", "Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "getRuntimeNavigatable", "()Lcom/intellij/docker/runtimes/DockerRuntimeNavigatable;", "task", "Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "getTask", "()Lcom/intellij/remoteServer/runtime/deployment/DeploymentTask;", "workDirectory", "getWorkDirectory", "downCommand", "Lcom/intellij/docker/agent/compose/cli/DockerComposeDownCliBuilder;", "downOptions", "Lcom/intellij/docker/DockerComposeDownOptions;", "redeploy", "", "toString", "Companion", "intellij.clouds.docker"})
public final class ComposeDeploymentRuntime
extends ComposeApplicationRuntime
implements DockerDeployedRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerComposeDeployer deployer;
    @NotNull
    private final DockerDeployingRuntime deployingRuntime;
    @NotNull
    private final ComposeCliExecutor executor;
    @NotNull
    private final DockerTerminalPipe.WithTty loggingPipe;

    public ComposeDeploymentRuntime(@NotNull DockerRuntimeContext context, @NotNull DockerComposeDeployer deployer, @NotNull DockerDeployingRuntime deployingRuntime2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)deployer, (String)"deployer");
        Intrinsics.checkNotNullParameter((Object)deployingRuntime2, (String)"deployingRuntime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(context, project);
        this.deployer = deployer;
        this.deployingRuntime = deployingRuntime2;
        this.executor = this.deployer.getCliExecutor();
        this.loggingPipe = this.getDeployingRuntime().getPipe();
    }

    @NotNull
    public final DockerComposeDeployer getDeployer$intellij_clouds_docker() {
        return this.deployer;
    }

    @Override
    @NotNull
    public DockerDeployingRuntime getDeployingRuntime() {
        return this.deployingRuntime;
    }

    @Override
    @NotNull
    protected ComposeCliExecutor getExecutor() {
        return this.executor;
    }

    @Override
    @NotNull
    protected DockerRuntimeNavigatable getRuntimeNavigatable() {
        return this.deployer.getRuntimeNavigatable();
    }

    @Override
    @NotNull
    protected DockerTerminalPipe.WithTty getLoggingPipe() {
        return this.loggingPipe;
    }

    @Override
    @NotNull
    public DeploymentTask<DockerDeploymentConfiguration> getTask() {
        return this.deployer.getDeployInfo().getTask();
    }

    @Override
    @NotNull
    protected String getWorkDirectory() {
        String string = this.deployer.getWorkDirectory().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Override
    @NotNull
    public String getComposeProjectName() {
        return this.deployer.getComposeProjectName();
    }

    @Override
    public void redeploy() {
    }

    @Override
    @NotNull
    protected DockerComposeDownCliBuilder downCommand(@Nullable DockerComposeDownOptions downOptions) throws ServerRuntimeException {
        DockerComposeDownOptions dockerComposeDownOptions = downOptions;
        if (dockerComposeDownOptions == null) {
            dockerComposeDownOptions = this.deployer.getDeployInfo().getDownOptions();
        }
        return (DockerComposeDownCliBuilder)super.downCommand(dockerComposeDownOptions).withEnvFile(this.deployer.getDeployInfo().getEnvFile());
    }

    @NotNull
    public String toString() {
        return "@" + Integer.toHexString(this.hashCode()) + " id: " + this.getPresentableName() + ", [APP][++]";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/runtimes/ComposeDeploymentRuntime$Companion;", "", "()V", "computeEnvVarAwareProjectName", "", "workDirectory", "Ljava/nio/file/Path;", "envFileName", "computeErasedProjectName", "name", "tryFindProjectNameInEnvFile", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String computeEnvVarAwareProjectName(@NotNull Path workDirectory, @Nullable String envFileName) {
            Intrinsics.checkNotNullParameter((Object)workDirectory, (String)"workDirectory");
            String string = this.tryFindProjectNameInEnvFile(workDirectory, envFileName);
            if (string == null && (string = StringKt.nullize((String)System.getenv("COMPOSE_PROJECT_NAME"), (boolean)true)) == null) {
                string = this.computeErasedProjectName(PathsKt.getName((Path)workDirectory));
            }
            return string;
        }

        public static /* synthetic */ String computeEnvVarAwareProjectName$default(Companion companion, Path path, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.computeEnvVarAwareProjectName(path, string);
        }

        private final String tryFindProjectNameInEnvFile(Path workDirectory, String envFileName) {
            Object v4;
            Object object;
            block4: {
                String string = envFileName;
                if (string == null) {
                    string = ".env";
                }
                Path path = workDirectory.resolve(string);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                VirtualFile virtualFile2 = VfsUtil.findFile((Path)path, (boolean)false);
                if (virtualFile2 == null) {
                    return null;
                }
                VirtualFile file2 = virtualFile2;
                if (file2.isDirectory()) {
                    return null;
                }
                InputStream inputStream = file2.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                object = inputStream;
                Object object2 = Charsets.UTF_8;
                object2 = TextStreamsKt.readLines((Reader)new InputStreamReader((InputStream)object, (Charset)object2));
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)it)).toString(), (String)"COMPOSE_PROJECT_NAME", (boolean)false, (int)2, null)) continue;
                    v4 = t;
                    break block4;
                }
                v4 = null;
            }
            String string = v4;
            return string != null && (object = StringsKt.substringAfter$default((String)string, (String)"=", null, (int)2, null)) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
        }

        static /* synthetic */ String tryFindProjectNameInEnvFile$default(Companion companion, Path path, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.tryFindProjectNameInEnvFile(path, string);
        }

        @NotNull
        public final String computeErasedProjectName(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            CharSequence charSequence = name2;
            Regex regex = new Regex("[^a-zA-Z0-9-_]+");
            String string = "";
            String string2 = StringUtil.toLowerCase((String)regex.replace(charSequence, string));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

