/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.docker.DockerAgentConnector;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentImage;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.agent.impl.DockerResult;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentProgressTaskExecutor;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntimesManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 72\u00020\u0001:\u00017B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010#0\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u0004\u0018\u00010#2\u0006\u0010'\u001a\u00020\u001cJ\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u001cJ\u0010\u0010+\u001a\u0004\u0018\u00010)2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00020\u001cJ\u0011\u0010.\u001a\b\u0012\u0004\u0012\u0002000/\u00a2\u0006\u0002\u00101J\u0011\u00102\u001a\b\u0012\u0004\u0012\u00020)0/\u00a2\u0006\u0002\u00103J\u001b\u00102\u001a\b\u0012\u0004\u0012\u00020)0/2\b\u00104\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00068"}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "", "account", "Lcom/intellij/docker/DockerCloudConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/docker/DockerCloudConfiguration;Lcom/intellij/openapi/project/Project;)V", "getAccount", "()Lcom/intellij/docker/DockerCloudConfiguration;", "agent", "Lcom/intellij/docker/agent/DockerAgent;", "getAgent", "()Lcom/intellij/docker/agent/DockerAgent;", "dockerCommunicator", "Lcom/intellij/docker/agent/cli/DockerCli;", "getDockerCommunicator", "()Lcom/intellij/docker/agent/cli/DockerCli;", "myAgent", "getProject", "()Lcom/intellij/openapi/project/Project;", "asyncBuildImage", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "config", "Lcom/intellij/docker/agent/DockerAgentDeploymentConfig;", "asyncPullImage", "imageName", "", "connect", "scope", "Lkotlinx/coroutines/CoroutineScope;", "connect$intellij_clouds_docker", "createNameOrId2ContainerMapping", "Lcom/intellij/util/Function;", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "doPullImage", "", "findContainerByNameOrId", "containerNameOrId", "findImageByIdPrefix", "Lcom/intellij/docker/agent/DockerAgentImage;", "sha256id", "findImageByName", "findImageByNameOrId", "nameOrId", "getContainers", "", "Lcom/intellij/docker/agent/DockerAgentContainer;", "()[Lcom/intellij/docker/agent/DockerAgentContainer;", "getImages", "()[Lcom/intellij/docker/agent/DockerAgentImage;", "label", "(Ljava/lang/String;)[Lcom/intellij/docker/agent/DockerAgentImage;", "pullImage", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nRemoteDockerRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,219:1\n26#2:220\n12474#3,2:221\n*S KotlinDebug\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime\n*L\n117#1:220\n97#1:221,2\n*E\n"})
public final class RemoteDockerRuntime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerCloudConfiguration account;
    @Nullable
    private final Project project;
    @Nullable
    private DockerAgent myAgent;
    @NotNull
    private static final Logger LOG;

    public RemoteDockerRuntime(@NotNull DockerCloudConfiguration account, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
        this.account = account;
        this.project = project;
        this.myAgent = DockerAgent.Companion.createInstance(DockerMainCoroutineScopeHolder.createChildScope$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, false, 3, null));
    }

    @NotNull
    public final DockerCloudConfiguration getAccount() {
        return this.account;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DockerAgent getAgent() {
        DockerAgent dockerAgent = this.myAgent;
        if (dockerAgent == null) {
            throw new RuntimeException("Not connected");
        }
        return dockerAgent;
    }

    @NotNull
    public final CompletableFuture<RemoteDockerRuntime> connect$intellij_clouds_docker(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return FutureKt.future$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super RemoteDockerRuntime>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = new DockerAgentConnector(this.this$0.getAccount(), this.this$0.getAgent()).connect((Continuation<? super Unit>)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return this.this$0;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return this.this$0;
                        }
                        catch (CancellationException ce) {
                            throw ce;
                        }
                        catch (Exception e) {
                            throw new ServerRuntimeException((Throwable)e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super RemoteDockerRuntime> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final DockerCli getDockerCommunicator() {
        return this.getAgent().getCliFacade().docker();
    }

    @Nullable
    public final RemoteDockerApplicationRuntime findContainerByNameOrId(@NotNull String containerNameOrId) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)containerNameOrId, (String)"containerNameOrId");
        return (RemoteDockerApplicationRuntime)this.createNameOrId2ContainerMapping().fun((Object)containerNameOrId);
    }

    private final Function<String, RemoteDockerApplicationRuntime> createNameOrId2ContainerMapping() {
        DockerAgentContainer[] containers2 = this.getContainers();
        return arg_0 -> RemoteDockerRuntime.createNameOrId2ContainerMapping$lambda$1(containers2, this, arg_0);
    }

    @NotNull
    public final DockerAgentContainer[] getContainers() {
        return (DockerAgentContainer[])BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerAgentContainer[]>, Object>(this, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAgent().obtainContainers((Continuation<? super DockerResult<DockerAgentContainer[]>>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((v1 = (DockerAgentContainer[])((DockerResult)v0).onFailure((Consumer<Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, access$logWarnOrErrorIfTestMode(com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime$Companion java.lang.Throwable ), (Ljava/lang/Throwable;)V)((Companion)RemoteDockerRuntime.Companion)).getOrNull()) == null) {
                            $i$f$emptyArray = false;
                            v1 = new DockerAgentContainer[]{};
                        }
                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DockerAgentContainer[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @NotNull
    public final DockerAgentImage[] getImages() {
        return this.getImages(null);
    }

    @NotNull
    public final DockerAgentImage[] getImages(@Nullable String label2) {
        DockerAgentImage[] dockerAgentImageArray = (DockerAgentImage[])((DockerResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DockerResult<DockerAgentImage[]>>, Object>(this, label2, null){
            int label;
            final /* synthetic */ RemoteDockerRuntime this$0;
            final /* synthetic */ String $label;
            {
                this.this$0 = $receiver;
                this.$label = $label;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DockerAgent.obtainImages$default(this.this$0.getAgent(), this.$label, false, (Continuation)this, 2, null);
                        if (object3 != object2) return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0));
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return ((DockerResult)object3).onFailure(arg_0 -> Companion.access$logWarnOrErrorIfTestMode(RemoteDockerRuntime.Companion, arg_0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DockerResult<DockerAgentImage[]>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null)).getOrNull();
        if (dockerAgentImageArray == null) {
            boolean $i$f$emptyArray = false;
            dockerAgentImageArray = new DockerAgentImage[]{};
        }
        return dockerAgentImageArray;
    }

    @Nullable
    public final DockerAgentImage findImageByNameOrId(@NotNull String nameOrId) {
        Intrinsics.checkNotNullParameter((Object)nameOrId, (String)"nameOrId");
        return StringsKt.startsWith$default((String)nameOrId, (String)"sha256:", (boolean)false, (int)2, null) ? this.findImageByIdPrefix(nameOrId) : this.findImageByName(nameOrId);
    }

    @Nullable
    public final DockerAgentImage findImageByIdPrefix(@NotNull String sha256id) {
        Intrinsics.checkNotNullParameter((Object)sha256id, (String)"sha256id");
        int minimalLookupLength = 6;
        String string = StringUtil.trimStart((String)sha256id, (String)"sha256:");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimStart(...)");
        String lookup = string;
        if (lookup.length() < minimalLookupLength) {
            return null;
        }
        for (DockerAgentImage next2 : this.getImages()) {
            String actualId;
            String nextId = next2.getImageId();
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trimStart((String)nextId, (String)"sha256:"), (String)"trimStart(...)");
            if (!StringsKt.startsWith$default((String)actualId, (String)lookup, (boolean)false, (int)2, null)) continue;
            return next2;
        }
        return null;
    }

    @Nullable
    public final DockerAgentImage findImageByName(@NotNull String imageName2) {
        Intrinsics.checkNotNullParameter((Object)imageName2, (String)"imageName");
        for (DockerAgentImage next2 : this.getImages()) {
            for (String imageTag2 : next2.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag2, (CharSequence)imageName2)) continue;
                return next2;
            }
        }
        return null;
    }

    public final void pullImage(@NotNull String imageName2) throws ServerRuntimeException {
        Intrinsics.checkNotNullParameter((Object)imageName2, (String)"imageName");
        LOG.debug("Pull image {" + imageName2 + "}");
        try {
            this.doPullImage(imageName2);
            LOG.debug("Docker image {" + imageName2 + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName2 + "}", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(@NotNull String imageName2) {
        Intrinsics.checkNotNullParameter((Object)imageName2, (String)"imageName");
        if (this.project == null) {
            throw new NullPointerException();
        }
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.Companion.forImageName(imageName2);
        return this.getAgent().asyncPullImage(repositoryConfig);
    }

    @NotNull
    public final CompletableFuture<BlockingQueue<byte[]>> asyncBuildImage(@NotNull DockerAgentDeploymentConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (this.project == null) {
            throw new NullPointerException();
        }
        return this.getAgent().createImageBuilder().asyncBuildImage(config);
    }

    private final void doPullImage(String imageName2) throws ServerRuntimeException {
        DockerAgentRepositoryConfig repositoryConfig = RemoteDockerRuntime.Companion.forImageName(imageName2);
        DockerAgentProgressTaskExecutor dockerAgentProgressTaskExecutor = DockerAgentProgressTaskExecutor.Companion.getInstance();
        Object[] objectArray = new Object[]{imageName2};
        String string = DockerBundle.message("RemoteDockerRuntime.progress.title.pulling.image", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        dockerAgentProgressTaskExecutor.performSync(string, (Function2<? super DockerAgentProgressCallback, ? super Continuation<? super OngoingProcess>, ? extends Object>)((Function2)new Function2<DockerAgentProgressCallback, Continuation<? super OngoingProcess>, Object>(this, repositoryConfig, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ RemoteDockerRuntime this$0;
            final /* synthetic */ DockerAgentRepositoryConfig $repositoryConfig;
            {
                this.this$0 = $receiver;
                this.$repositoryConfig = $repositoryConfig;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DockerAgentProgressCallback it = (DockerAgentProgressCallback)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.getAgent().pullImageWithProgressCallback(this.$repositoryConfig, it, (Continuation<? super OngoingProcess>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull DockerAgentProgressCallback p1, @Nullable Continuation<? super OngoingProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final RemoteDockerApplicationRuntime createNameOrId2ContainerMapping$lambda$1(DockerAgentContainer[] $containers, RemoteDockerRuntime this$0, String containerNameOrId) {
        Intrinsics.checkNotNullParameter((Object)$containers, (String)"$containers");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)containerNameOrId, (String)"containerNameOrId");
        for (DockerAgentContainer next2 : $containers) {
            if (!StringUtil.equals((CharSequence)containerNameOrId, (CharSequence)next2.getContainerId())) {
                boolean bl;
                block3: {
                    String[] $this$any$iv = next2.getContainerNames();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv;
                        String it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)("/" + containerNameOrId), (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
                if (!bl) continue;
            }
            return RemoteDockerApplicationRuntime.create(this$0, next2);
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
        return Companion.create(config, project);
    }

    static {
        Logger logger2 = Logger.getInstance(RemoteDockerRuntime.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "config", "Lcom/intellij/docker/DockerCloudConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "forImageName", "Lcom/intellij/docker/agent/DockerAgentRepositoryConfig;", "imageName", "", "logWarnOrErrorIfTestMode", "", "ex", "", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nRemoteDockerRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void logWarnOrErrorIfTestMode(Throwable ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(ex);
            } else {
                LOG.warn(ex);
            }
        }

        @JvmStatic
        @NotNull
        public final RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
            RemoteDockerRuntime remoteDockerRuntime;
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            try {
                remoteDockerRuntime = RemoteDockerRuntimesManager.Companion.getInstance(project).createRuntime(config).get();
                Intrinsics.checkNotNull((Object)remoteDockerRuntime);
            }
            catch (ExecutionException ex) {
                Throwable throwable = ex.getCause();
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
                throw ex;
            }
            return remoteDockerRuntime;
        }

        private final DockerAgentRepositoryConfig forImageName(String imageName2) {
            DockerRepoTag dockerRepoTag = DockerRepoTag.fromString(imageName2);
            Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
            DockerRepoTag repoTag = dockerRepoTag;
            DockerAgentRepositoryConfig dockerAgentRepositoryConfig = repoTag.toAgentRepositoryConfig();
            Intrinsics.checkNotNullExpressionValue((Object)dockerAgentRepositoryConfig, (String)"toAgentRepositoryConfig(...)");
            return dockerAgentRepositoryConfig;
        }

        public static final /* synthetic */ void access$logWarnOrErrorIfTestMode(Companion $this, Throwable ex) {
            $this.logWarnOrErrorIfTestMode(ex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

