/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteDebug;

import com.intellij.docker.remoteDebug.RemoteFolderRequest;
import com.intellij.docker.remoteDebug.RemotePortRequest;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServerRequest {
    private final List<RemotePortRequest> myPortRequests;
    private final List<RemoteFolderRequest> myFolderRequests;

    public RemoteServerRequest(@NotNull List<RemotePortRequest> ports, @NotNull List<RemoteFolderRequest> folders) {
        if (ports == null) {
            RemoteServerRequest.$$$reportNull$$$0(0);
        }
        if (folders == null) {
            RemoteServerRequest.$$$reportNull$$$0(1);
        }
        this.myPortRequests = new ArrayList<RemotePortRequest>(ports);
        this.myFolderRequests = new ArrayList<RemoteFolderRequest>(folders);
    }

    public RemotePortRequest[] getPortRequests() {
        return this.myPortRequests.toArray(new RemotePortRequest[0]);
    }

    public RemoteFolderRequest[] getFolderRequests() {
        return this.myFolderRequests.toArray(new RemoteFolderRequest[0]);
    }

    @Nullable
    public RemotePortRequest findMainDebugPortRequest() {
        return this.findPortRequest("port.debugger");
    }

    @Nullable
    public RemotePortRequest findPortRequest(@NotNull String id) {
        if (id == null) {
            RemoteServerRequest.$$$reportNull$$$0(2);
        }
        return (RemotePortRequest)ContainerUtil.find(this.myPortRequests, next2 -> id.equals(next2.getId()));
    }

    @Nullable
    public RemoteFolderRequest findFolderRequest(@NotNull String id) {
        if (id == null) {
            RemoteServerRequest.$$$reportNull$$$0(3);
        }
        return (RemoteFolderRequest)ContainerUtil.find(this.myFolderRequests, next2 -> id.equals(next2.getId()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ports";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folders";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remoteDebug/RemoteServerRequest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPortRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFolderRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Builder {
        private final List<RemotePortRequest> myPortRequests = new LinkedList<RemotePortRequest>();
        private final List<RemoteFolderRequest> myFolderRequests = new LinkedList<RemoteFolderRequest>();

        public Builder withMainPortMapping(@NotNull String presentableName) {
            if (presentableName == null) {
                Builder.$$$reportNull$$$0(0);
            }
            return this.withPortMapping(new RemotePortRequest("port.debugger", presentableName));
        }

        public Builder withPortMapping(@NotNull RemotePortRequest portRequest) {
            if (portRequest == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myPortRequests.add(portRequest);
            return this;
        }

        public Builder withFolderMapping(@NotNull RemoteFolderRequest folderMapping) {
            if (folderMapping == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myFolderRequests.add(folderMapping);
            return this;
        }

        public RemoteServerRequest build() {
            return new RemoteServerRequest(this.myPortRequests, this.myFolderRequests);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "portRequest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderMapping";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/remoteDebug/RemoteServerRequest$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withMainPortMapping";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withPortMapping";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withFolderMapping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

