/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose.process;

import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.compose.cli.DockerComposeCliCmd;
import com.intellij.docker.compose.cli.DockerComposeCliCommands;
import com.intellij.docker.compose.cli.DockerComposeCliParser;
import com.intellij.docker.compose.cli.DockerComposeCliSubCmd;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.cli.DockerComposeExecCmd;
import com.intellij.docker.compose.cli.DockerComposeRunCmd;
import com.intellij.docker.compose.cli.DockerComposeUpCmd;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceExecCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.compose.run.configuration.DockerComposeSettings;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.PtyOptions;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.execution.ParametersListUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a8\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"assertDebugIsAvailable", "", "dockerComposeCliCmd", "Lcom/intellij/docker/compose/cli/DockerComposeCliCmd;", "createComposeServiceCmd", "Lcom/intellij/docker/compose/service/commands/AbstractServiceCmd;", "serviceClient", "Lcom/intellij/docker/compose/service/DockerComposeServiceClient;", "command", "publishPorts", "", "Lcom/intellij/docker/agent/compose/beans/DockerComposePort;", "ptyOptions", "Lcom/intellij/execution/target/PtyOptions;", "getComposeCommandOptions", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getDockerComposeContainer", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerApplicationRuntime;", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "containerNameOrId", "", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerComposeProcessUtil")
public final class DockerComposeProcessUtil {
    @NotNull
    public static final RemoteDockerApplicationRuntime getDockerComposeContainer(@NotNull RemoteDockerRuntime dockerRuntime2, @NotNull String containerNameOrId) throws ServerRuntimeException, RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)dockerRuntime2, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter((Object)containerNameOrId, (String)"containerNameOrId");
        RemoteDockerApplicationRuntime serviceApplicationRuntime = dockerRuntime2.findContainerByNameOrId(containerNameOrId);
        if (serviceApplicationRuntime == null) {
            Object[] objectArray = new Object[]{containerNameOrId};
            throw new RemoteSdkException(DockerBundle.message("DockerComposeProcessUtil.error.container.not.found", objectArray));
        }
        return serviceApplicationRuntime;
    }

    @JvmOverloads
    @NotNull
    public static final AbstractServiceCmd<?> createComposeServiceCmd(@NotNull DockerComposeServiceClient serviceClient, @NotNull DockerComposeCliCmd command, @Nullable List<DockerComposePort> publishPorts, @Nullable PtyOptions ptyOptions) {
        Intrinsics.checkNotNullParameter((Object)serviceClient, (String)"serviceClient");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        DockerComposeCliSubCmd dockerComposeCliSubCmd = command.getSubCmd();
        if (dockerComposeCliSubCmd == null) {
            Object t = serviceClient.upServicesCmd().withPorts(publishPorts);
            Intrinsics.checkNotNullExpressionValue(t, (String)"withPorts(...)");
            return t;
        }
        DockerComposeCliSubCmd subCmd = dockerComposeCliSubCmd;
        Object t = ((AbstractServiceCmd)subCmd.accept(new DockerComposeCliSubCmd.Visitor<AbstractServiceCmd<?>>(serviceClient, publishPorts, ptyOptions){
            final /* synthetic */ DockerComposeServiceClient $serviceClient;
            final /* synthetic */ List<DockerComposePort> $publishPorts;
            final /* synthetic */ PtyOptions $ptyOptions;
            {
                this.$serviceClient = $serviceClient;
                this.$publishPorts = $publishPorts;
                this.$ptyOptions = $ptyOptions;
            }

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeUpCmd upCmd) {
                Intrinsics.checkNotNullParameter((Object)upCmd, (String)"upCmd");
                ComposeServiceUpCmd composeServiceUpCmd = ((ComposeServiceUpCmd)this.$serviceClient.upServicesCmd().withServiceNames(upCmd.getServiceList()).withPorts(this.$publishPorts)).withPtyOptions(this.$ptyOptions);
                Intrinsics.checkNotNullExpressionValue((Object)composeServiceUpCmd, (String)"withPtyOptions(...)");
                return composeServiceUpCmd;
            }

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeRunCmd runCmd) {
                Intrinsics.checkNotNullParameter((Object)runCmd, (String)"runCmd");
                ComposeServiceRunCmd composeServiceRunCmd = this.$serviceClient.runServiceCmd().withPublishPorts(this.$publishPorts).withPtyOptions(this.$ptyOptions);
                Intrinsics.checkNotNullExpressionValue((Object)composeServiceRunCmd, (String)"withPtyOptions(...)");
                return composeServiceRunCmd;
            }

            @NotNull
            public AbstractServiceCmd<?> visit(@NotNull DockerComposeExecCmd execCmd) {
                Intrinsics.checkNotNullParameter((Object)execCmd, (String)"execCmd");
                ComposeServiceExecCmd composeServiceExecCmd = this.$serviceClient.execServiceCmd().withPtyOptions(this.$ptyOptions);
                Intrinsics.checkNotNullExpressionValue((Object)composeServiceExecCmd, (String)"withPtyOptions(...)");
                return composeServiceExecCmd;
            }
        })).withSubcommandOptions(DockerComposeCliCommands.getSubcommandLineOptions(subCmd));
        Intrinsics.checkNotNullExpressionValue(t, (String)"withSubcommandOptions(...)");
        return t;
    }

    public static /* synthetic */ AbstractServiceCmd createComposeServiceCmd$default(DockerComposeServiceClient dockerComposeServiceClient, DockerComposeCliCmd dockerComposeCliCmd, List list2, PtyOptions ptyOptions, int n, Object object) {
        if ((n & 8) != 0) {
            ptyOptions = DockerComposeCliUtil.defaultPtyOptions();
        }
        return DockerComposeProcessUtil.createComposeServiceCmd(dockerComposeServiceClient, dockerComposeCliCmd, list2, ptyOptions);
    }

    @NotNull
    public static final DockerComposeCliCmd getComposeCommandOptions(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        DockerComposeSettings dockerComposeSettings = (DockerComposeSettings)commandLine.getUserData(DockerComposeSettings.KEY);
        if (dockerComposeSettings == null) {
            dockerComposeSettings = new DockerComposeSettings();
        }
        DockerComposeSettings dockerComposeSettings2 = dockerComposeSettings;
        DockerComposeCliParser dockerComposeCliParser = new DockerComposeCliParser();
        String[] stringArray = ParametersListUtil.parseToArray((String)dockerComposeSettings2.getCommandLine());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
        return dockerComposeCliParser.parse(stringArray);
    }

    public static final void assertDebugIsAvailable(@NotNull DockerComposeCliCmd dockerComposeCliCmd) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dockerComposeCliCmd, (String)"dockerComposeCliCmd");
            DockerComposeCliSubCmd dockerComposeCliSubCmd = dockerComposeCliCmd.getSubCmd();
            if (dockerComposeCliSubCmd == null) break block0;
            dockerComposeCliSubCmd.accept(new DockerComposeCliSubCmd.Visitor<Object>(){

                @Nullable
                public Object visit(@NotNull DockerComposeUpCmd upCmd) {
                    Intrinsics.checkNotNullParameter((Object)upCmd, (String)"upCmd");
                    return null;
                }

                @Nullable
                public Object visit(@NotNull DockerComposeRunCmd runCmd) {
                    Intrinsics.checkNotNullParameter((Object)runCmd, (String)"runCmd");
                    return null;
                }

                @NotNull
                public Object visit(@NotNull DockerComposeExecCmd execCmd) {
                    Intrinsics.checkNotNullParameter((Object)execCmd, (String)"execCmd");
                    throw new RuntimeException("Debug is not available for Docker Compose `exec` command");
                }
            });
        }
    }

    @JvmOverloads
    @NotNull
    public static final AbstractServiceCmd<?> createComposeServiceCmd(@NotNull DockerComposeServiceClient serviceClient, @NotNull DockerComposeCliCmd command, @Nullable List<DockerComposePort> publishPorts) {
        Intrinsics.checkNotNullParameter((Object)serviceClient, (String)"serviceClient");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return DockerComposeProcessUtil.createComposeServiceCmd$default(serviceClient, command, publishPorts, null, 8, null);
    }
}

