/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry;

import com.intellij.docker.DockerMainCoroutineScopeHolder;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerRegistryConfigurableKt;
import com.intellij.docker.registry.DockerRegistryConfiguration;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.docker.utils.SingleTaskExecutor;
import com.intellij.docker.view.registry.DockerRegistryProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u000223B%\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020 H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\rH\u0016J\n\u0010&\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010'\u001a\u00020\u0002H\u0016J\b\u0010(\u001a\u00020\tH\u0016J\b\u0010)\u001a\u00020\tH\u0016J\u0010\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020 H\u0016J\u0012\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\rH\u0016J\u000e\u00100\u001a\u00020 H\u0082@\u00a2\u0006\u0002\u00101R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014 \u0016*\t\u0018\u00010\r\u00a2\u0006\u0002\b\u001a0\r\u00a2\u0006\u0002\b\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/docker/registry/DockerRegistryConfigurable;", "Lcom/intellij/openapi/ui/NamedConfigurable;", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "Lcom/intellij/openapi/util/CheckedDisposable;", "registry", "treeUpdater", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "isNew", "", "(Lcom/intellij/docker/registry/DockerRegistryConfiguration;Ljava/lang/Runnable;Z)V", "myConnectionStatusText", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "", "myContentWrapper", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "myIsDisposed", "myMainProvider", "Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "myRegistryCombobox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/docker/registry/DockerRegistryConfigurable$RegistryItem;", "kotlin.jvm.PlatformType", "myRegistryModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "myRegistryName", "Lorg/jetbrains/annotations/Nls;", "myScope", "Lkotlinx/coroutines/CoroutineScope;", "mySingleTaskExecutor", "Lcom/intellij/docker/utils/SingleTaskExecutor;", "apply", "", "applyTo", "createOptionsPanel", "Ljavax/swing/JComponent;", "dispose", "getBannerSlogan", "getDisplayName", "getEditableObject", "isDisposed", "isModified", "refreshContent", "configurator", "Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "reset", "setDisplayName", "name", "testConnection", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "RegistryForComparisonConfiguration", "RegistryItem", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerRegistryConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRegistryConfigurable.kt\ncom/intellij/docker/registry/DockerRegistryConfigurable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,237:1\n13309#2,2:238\n1#3:240\n*S KotlinDebug\n*F\n+ 1 DockerRegistryConfigurable.kt\ncom/intellij/docker/registry/DockerRegistryConfigurable\n*L\n54#1:238,2\n*E\n"})
public final class DockerRegistryConfigurable
extends NamedConfigurable<DockerRegistryConfiguration>
implements CheckedDisposable {
    @NotNull
    private final DockerRegistryConfiguration registry;
    private boolean isNew;
    @NotNull
    private final DockerRegistryProvider myMainProvider;
    private String myRegistryName;
    @NotNull
    private final CoroutineScope myScope;
    @NotNull
    private final SingleTaskExecutor mySingleTaskExecutor;
    @NotNull
    private final CollectionComboBoxModel<RegistryItem> myRegistryModel;
    @NotNull
    private final BorderLayoutPanel myContentWrapper;
    @NotNull
    private final ComboBox<RegistryItem> myRegistryCombobox;
    @NotNull
    private final AtomicProperty<String> myConnectionStatusText;
    private volatile boolean myIsDisposed;

    /*
     * WARNING - void declaration
     */
    public DockerRegistryConfigurable(@NotNull DockerRegistryConfiguration registry, @Nullable Runnable treeUpdater, boolean isNew) {
        void it;
        CoroutineScope coroutineScope;
        Intrinsics.checkNotNullParameter((Object)((Object)registry), (String)"registry");
        super(true, treeUpdater);
        this.registry = registry;
        this.isNew = isNew;
        this.myMainProvider = this.isNew ? DockerRegistryProvider.Companion.getDefaultProvider() : DockerRegistryProvider.Companion.getProvider(this.registry);
        this.myRegistryName = this.registry.getName();
        CoroutineScope coroutineScope2 = coroutineScope = DockerMainCoroutineScopeHolder.createChildScope$default(DockerMainCoroutineScopeHolder.Companion.getInstance(), null, true, 1, null);
        DockerRegistryConfigurable dockerRegistryConfigurable = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), () -> DockerRegistryConfigurable.myScope$lambda$1$lambda$0((CoroutineScope)it));
        dockerRegistryConfigurable.myScope = coroutineScope;
        this.mySingleTaskExecutor = new SingleTaskExecutor(this.myScope);
        this.myRegistryModel = new CollectionComboBoxModel();
        this.myContentWrapper = new BorderLayoutPanel();
        this.myRegistryCombobox = new ComboBox((ComboBoxModel)this.myRegistryModel);
        this.myConnectionStatusText = new AtomicProperty((Object)"");
        Object[] $this$forEach$iv = DockerRegistryProvider.EP_NAME.getExtensions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DockerRegistryProvider provider = (DockerRegistryProvider)element$iv;
            boolean bl2 = false;
            DockerRegistryProvider.Configurator configurator = provider.createConfigurator();
            if (configurator == null) continue;
            Disposer.register((Disposable)((Disposable)this), (Disposable)configurator);
            this.myRegistryModel.add((Object)new RegistryItem(provider, configurator));
        }
        DockerUiUtilsKt.selectBy(this.myRegistryModel, (Function1)new Function1<RegistryItem, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull RegistryItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getProvider(), (Object)myMainProvider);
            }
        });
        Object object = (RegistryItem)this.myRegistryModel.getSelected();
        if (object != null && (object = ((RegistryItem)object).getConfigurator()) != null) {
            Object object2;
            Object configurator = object2 = object;
            boolean bl3 = false;
            configurator.applyRegistryToData(this.registry);
            Object p0 = object2;
            boolean bl4 = false;
            this.refreshContent((DockerRegistryProvider.Configurator)p0);
        }
        this.myRegistryCombobox.addItemListener(arg_0 -> DockerRegistryConfigurable._init_$lambda$4(this, arg_0));
    }

    public boolean isModified() {
        if (this.isNew) {
            return true;
        }
        if (!Intrinsics.areEqual((Object)this.registry.getName(), (Object)this.getDisplayName())) {
            return true;
        }
        DockerRegistryConfiguration currentConfig = new RegistryForComparisonConfiguration();
        try {
            this.applyTo(currentConfig);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !DockerRegistryConfigurableKt.access$isConfigEqual(this.registry, currentConfig) || !this.registry.isPasswordSafe();
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dispose() {
        this.myIsDisposed = true;
    }

    public void apply() {
        this.applyTo(this.registry);
        this.isNew = false;
        Object object = this.myRegistryModel.getSelected();
        Intrinsics.checkNotNull((Object)object);
        ((RegistryItem)object).getProvider().refresh(this.registry);
    }

    private final void applyTo(DockerRegistryConfiguration registry) {
        Object object = this.myRegistryModel.getSelected();
        Intrinsics.checkNotNull((Object)object);
        RegistryItem selected = (RegistryItem)object;
        registry.setRegistryProviderId(selected.getProvider().getId());
        selected.getConfigurator().applyDataToRegistry(registry);
    }

    public void reset() {
        this.setDisplayName(this.registry.getName());
        this.updateName();
        Object object = this.myRegistryModel.getSelected();
        Intrinsics.checkNotNull((Object)object);
        ((RegistryItem)object).getConfigurator().applyRegistryToData(this.registry);
    }

    @Nullable
    public String getDisplayName() {
        return this.myRegistryName;
    }

    public void setDisplayName(@Nullable String name2) {
        this.myRegistryName = name2;
    }

    @NotNull
    public DockerRegistryConfiguration getEditableObject() {
        return this.registry;
    }

    @Nullable
    public String getBannerSlogan() {
        return this.registry.getName();
    }

    @NotNull
    public JComponent createOptionsPanel() {
        BorderLayoutPanel mainPanel2 = new BorderLayoutPanel();
        DockerUiUtilsKt.installActivityListener((Component)mainPanel2, this, this.myScope, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DockerRegistryConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DockerRegistryConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = DockerRegistryConfigurable.access$testConnection(this.this$0, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        ModalityState modalityState = ModalityState.current();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
        BuildersKt.launch$default((CoroutineScope)this.myScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DockerRegistryConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DockerRegistryConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = DockerRegistryConfigurable.access$testConnection(this.this$0, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        JComponent jComponent = (JComponent)this.myRegistryCombobox;
        String string = DockerBundle.message("DockerRegistryConfigurable.registry.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        mainPanel2.addToTop((Component)DockerUiUtilsKt.wrapToLabeledComponent(jComponent, string));
        mainPanel2.addToCenter((Component)this.myContentWrapper);
        JBPanel jBPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(mainPanel2, this){
            final /* synthetic */ BorderLayoutPanel $mainPanel;
            final /* synthetic */ DockerRegistryConfigurable this$0;
            {
                this.$mainPanel = $mainPanel;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$mainPanel){
                    final /* synthetic */ BorderLayoutPanel $mainPanel;
                    {
                        this.$mainPanel = $mainPanel;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.$mainPanel).align(Align.FILL);
                    }
                }), (int)1, null);
                $this$panel.group(DockerBundle.message("DockerRegistryConfigurable.test.connection.text", new Object[0]), false, (Function1)new Function1<Panel, Unit>(this.this$0){
                    final /* synthetic */ DockerRegistryConfigurable this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$group) {
                        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
                        Panel.row$default((Panel)$this$group, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                            final /* synthetic */ DockerRegistryConfigurable this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null).applyToComponent((Function1)new Function1<JEditorPane, Unit>(this.this$0){
                                    final /* synthetic */ DockerRegistryConfigurable this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull JEditorPane $this$applyToComponent) {
                                        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                                        DockerRegistryConfigurable.access$getMyConnectionStatusText$p(this.this$0).afterChange((Disposable)this.this$0, (Function1)new Function1<String, Unit>($this$applyToComponent){
                                            final /* synthetic */ JEditorPane $this_applyToComponent;
                                            {
                                                this.$this_applyToComponent = $this_applyToComponent;
                                                super(1);
                                            }

                                            public final void invoke(@NotNull String text2) {
                                                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                                                this.$this_applyToComponent.setText(text2);
                                            }
                                        });
                                    }
                                });
                            }
                        }), (int)1, null);
                    }
                });
            }
        })).withBorder((Border)new JBEmptyBorder(10));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"withBorder(...)");
        return (JComponent)jBPanel;
    }

    private final void refreshContent(DockerRegistryProvider.Configurator configurator) {
        this.myContentWrapper.removeAll();
        this.myContentWrapper.addToCenter((Component)configurator.createOptionsPanel());
        this.myContentWrapper.revalidate();
        this.myContentWrapper.repaint();
    }

    private final Object testConnection(Continuation<? super Unit> $completion) {
        Object object;
        Object object2 = this.myRegistryModel.getSelected();
        Intrinsics.checkNotNull((Object)object2);
        RegistryItem selected = (RegistryItem)object2;
        DockerRegistryProvider.Configurator configurator = selected.getConfigurator();
        RegistryForComparisonConfiguration tempConfig = new RegistryForComparisonConfiguration();
        configurator.applyDataToRegistry(tempConfig);
        try {
            Unit unit;
            boolean bl = false;
            DockerRegistryProvider.Configurator.Default default_ = configurator instanceof DockerRegistryProvider.Configurator.Default ? (DockerRegistryProvider.Configurator.Default)configurator : null;
            if (default_ != null) {
                default_.validate$intellij_clouds_docker(tempConfig);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl(unit);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable err = throwable2 = throwable;
            boolean bl = false;
            Object[] objectArray = new Object[1];
            String string = err.getMessage();
            if (string == null) {
                string = err.getClass().getName();
            }
            objectArray[0] = string;
            String string2 = CloudBundle.message((String)"cloud.status.cannot.connect", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.myConnectionStatusText.set((Object)string2);
        }
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            String string = CloudBundle.message((String)"task.title.connecting", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.myConnectionStatusText.set((Object)string);
            this.mySingleTaskExecutor.exec((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selected, tempConfig, null){
                int label;
                final /* synthetic */ RegistryItem $selected;
                final /* synthetic */ RegistryForComparisonConfiguration $tempConfig;
                {
                    this.$selected = $selected;
                    this.$tempConfig = $tempConfig;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$selected.getProvider().checkCredentials(this.$tempConfig, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, (Function1)new Function1<Result<? extends Unit>, Unit>(this){
                final /* synthetic */ DockerRegistryConfigurable this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Object $this$exec) {
                    block2: {
                        Throwable throwable;
                        Object object = $this$exec;
                        DockerRegistryConfigurable dockerRegistryConfigurable = this.this$0;
                        if (Result.isSuccess-impl((Object)object)) {
                            Unit it = (Unit)object;
                            boolean bl = false;
                            AtomicProperty atomicProperty = DockerRegistryConfigurable.access$getMyConnectionStatusText$p(dockerRegistryConfigurable);
                            String string = CloudBundle.message((String)"cloud.status.connection.successful", (Object[])new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            atomicProperty.set((Object)string);
                        }
                        object = $this$exec;
                        dockerRegistryConfigurable = this.this$0;
                        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
                        if (throwable2 == null) break block2;
                        Throwable it = throwable = throwable2;
                        boolean bl = false;
                        AtomicProperty atomicProperty = DockerRegistryConfigurable.access$getMyConnectionStatusText$p(dockerRegistryConfigurable);
                        Object[] objectArray = new Object[1];
                        String string = it.getMessage();
                        if (string == null) {
                            string = it.getClass().getName();
                        }
                        objectArray[0] = string;
                        String string2 = CloudBundle.message((String)"cloud.status.cannot.connect", (Object[])objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        atomicProperty.set((Object)string2);
                    }
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final void myScope$lambda$1$lambda$0(CoroutineScope $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        CoroutineScopeKt.cancel$default((CoroutineScope)$it, null, (int)1, null);
    }

    private static final void _init_$lambda$4(DockerRegistryConfigurable this$0, ItemEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = it.getItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.docker.registry.DockerRegistryConfigurable.RegistryItem");
        RegistryItem selectedRegistry = (RegistryItem)object;
        DockerRegistryProvider.Configurator configurator = selectedRegistry.getConfigurator();
        if (!Intrinsics.areEqual((Object)this$0.myMainProvider, (Object)selectedRegistry.getProvider())) {
            RegistryForComparisonConfiguration tempRegistryConfig = new RegistryForComparisonConfiguration();
            configurator.applyRegistryToData(tempRegistryConfig);
        }
        this$0.refreshContent(configurator);
    }

    public static final /* synthetic */ Object access$testConnection(DockerRegistryConfigurable $this, Continuation $completion) {
        return $this.testConnection((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AtomicProperty access$getMyConnectionStatusText$p(DockerRegistryConfigurable $this) {
        return $this.myConnectionStatusText;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/registry/DockerRegistryConfigurable$RegistryForComparisonConfiguration;", "Lcom/intellij/docker/registry/DockerRegistryConfiguration;", "()V", "clearPasswordSafe", "", "getPasswordSafe", "", "setPasswordSafe", "password", "intellij.clouds.docker"})
    private static final class RegistryForComparisonConfiguration
    extends DockerRegistryConfiguration {
        public void setPasswordSafe(@NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.setPassword(password);
        }

        @Nullable
        public String getPasswordSafe() {
            return this.getPassword();
        }

        @Override
        public void clearPasswordSafe() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/docker/registry/DockerRegistryConfigurable$RegistryItem;", "", "provider", "Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "configurator", "Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "(Lcom/intellij/docker/view/registry/DockerRegistryProvider;Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;)V", "getConfigurator", "()Lcom/intellij/docker/view/registry/DockerRegistryProvider$Configurator;", "getProvider", "()Lcom/intellij/docker/view/registry/DockerRegistryProvider;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.clouds.docker"})
    private static final class RegistryItem {
        @NotNull
        private final DockerRegistryProvider provider;
        @NotNull
        private final DockerRegistryProvider.Configurator configurator;

        public RegistryItem(@NotNull DockerRegistryProvider provider, @NotNull DockerRegistryProvider.Configurator configurator) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            this.provider = provider;
            this.configurator = configurator;
        }

        @NotNull
        public final DockerRegistryProvider getProvider() {
            return this.provider;
        }

        @NotNull
        public final DockerRegistryProvider.Configurator getConfigurator() {
            return this.configurator;
        }

        @NotNull
        public String toString() {
            return this.provider.getRegistryName();
        }

        @NotNull
        public final DockerRegistryProvider component1() {
            return this.provider;
        }

        @NotNull
        public final DockerRegistryProvider.Configurator component2() {
            return this.configurator;
        }

        @NotNull
        public final RegistryItem copy(@NotNull DockerRegistryProvider provider, @NotNull DockerRegistryProvider.Configurator configurator) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            return new RegistryItem(provider, configurator);
        }

        public static /* synthetic */ RegistryItem copy$default(RegistryItem registryItem, DockerRegistryProvider dockerRegistryProvider, DockerRegistryProvider.Configurator configurator, int n, Object object) {
            if ((n & 1) != 0) {
                dockerRegistryProvider = registryItem.provider;
            }
            if ((n & 2) != 0) {
                configurator = registryItem.configurator;
            }
            return registryItem.copy(dockerRegistryProvider, configurator);
        }

        public int hashCode() {
            int result2 = this.provider.hashCode();
            result2 = result2 * 31 + this.configurator.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegistryItem)) {
                return false;
            }
            RegistryItem registryItem = (RegistryItem)other;
            if (!Intrinsics.areEqual((Object)this.provider, (Object)registryItem.provider)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configurator, (Object)registryItem.configurator);
        }
    }
}

