/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.agent.DockerRepoTag;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.utils.PatternsKt;
import com.intellij.docker.dockerFile.utils.UtilsKt;
import com.intellij.docker.image.DockerPullIntentionHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/dockerFile/DockerFilePullIntentionHelper;", "Lcom/intellij/docker/image/DockerPullIntentionHelper;", "()V", "pattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "getDockerRepoTag", "Lcom/intellij/docker/agent/DockerRepoTag;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "intellij.clouds.docker.file"})
public final class DockerFilePullIntentionHelper
implements DockerPullIntentionHelper {
    @NotNull
    private final PsiElementPattern.Capture<PsiElement> pattern = PatternsKt.isDockerImagePsiElementPattern();

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.pattern.accepts((Object)element);
    }

    @Override
    @NotNull
    public DockerRepoTag getDockerRepoTag(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        DockerFileFromCommand from;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        DockerFileFromCommand dockerFileFromCommand = from = UtilsKt.findFromCommand(element);
        List<Object> nodes = dockerFileFromCommand != null ? UtilsKt.findImageNodes(dockerFileFromCommand) : null;
        List<PsiElement> list2 = nodes;
        if (list2 == null || (list2 = UtilsKt.getText(list2)) == null) {
            list2 = "";
        }
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString((String)((Object)list2));
        Intrinsics.checkNotNullExpressionValue((Object)dockerRepoTag, (String)"fromString(...)");
        return dockerRepoTag;
    }
}

