/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"checkDockerFile", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "intellij.clouds.docker"})
public final class DockerFileDeploymentValidationKt {
    public static final void checkDockerFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String dockerFile = StringKt.nullize((String)config.getSourceFilePath(), (boolean)true);
        if (dockerFile == null) {
            throw new RuntimeConfigurationException(DockerBundle.message("DockerFileDeploymentSourceType.error.path.required", new Object[0]));
        }
        File file2 = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, dockerFile);
        if (file2 == null || !file2.exists() || !file2.isFile()) {
            Object[] objectArray = new Object[1];
            File file3 = file2;
            String string = file3 != null ? file3.getAbsolutePath() : null;
            if (string == null) {
                string = dockerFile;
            }
            objectArray[0] = string;
            throw new RuntimeConfigurationError(DockerBundle.message("DockerFileDeploymentSourceType.error.dockerfile.does.not.exist", objectArray));
        }
    }
}

