/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.connection;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.connection.DockerConnectionConfigurator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.utils.InternalUtilsKt;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator;", "Lcom/intellij/docker/connection/DockerConnectionConfigurator;", "()V", "id", "", "getId", "()Ljava/lang/String;", "label", "getLabel", "createEditor", "Lcom/intellij/docker/connection/DockerConnectionConfigurator$ContributedEditor;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isEditorModified", "", "editor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/docker/DockerCloudConfiguration;", "baseline", "isShouldBeSelected", "config", "Companion", "MyEditor", "intellij.clouds.docker"})
public final class DockerTcpConnectionConfigurator
implements DockerConnectionConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String label;
    @NotNull
    public static final String ID = "DockerTcpConnectionConfigurator";

    public DockerTcpConnectionConfigurator() {
        this.id = ID;
        String string = DockerBundle.message("DockerCloudConfigurable.tcp.socket.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.label = string;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    public Object createEditor(@NotNull Continuation<? super DockerConnectionConfigurator.ContributedEditor> $completion) {
        return new MyEditor();
    }

    @Override
    public boolean isEditorModified(@NotNull SettingsEditor<DockerCloudConfiguration> editor, @NotNull DockerCloudConfiguration baseline) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        MyEditor myEditor = editor instanceof MyEditor ? (MyEditor)editor : null;
        return myEditor != null ? myEditor.isModified(baseline) : true;
    }

    @Override
    public boolean isShouldBeSelected(@NotNull DockerCloudConfiguration config) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        return DockerConnectionConfigurator.super.isShouldBeSelected(config) || config.getCustomConfiguratorId() == null && !StringsKt.isBlank((CharSequence)config.getApiUrl()) && !((charSequence = (CharSequence)config.getCertificatesPath()) == null || StringsKt.isBlank((CharSequence)charSequence));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator$Companion;", "", "()V", "ID", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator$MyEditor;", "Lcom/intellij/docker/connection/DockerConnectionConfigurator$ContributedEditor;", "(Lcom/intellij/docker/connection/DockerTcpConnectionConfigurator;)V", "myApiUrlTextField", "Ljavax/swing/JTextField;", "myCertificatesPathTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "s", "Lcom/intellij/docker/DockerCloudConfiguration;", "createEditor", "Ljavax/swing/JComponent;", "isModified", "", "config", "resetEditorFrom", "intellij.clouds.docker"})
    private final class MyEditor
    extends DockerConnectionConfigurator.ContributedEditor {
        private JTextField myApiUrlTextField;
        private TextFieldWithBrowseButton myCertificatesPathTextField;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isModified(@NotNull DockerCloudConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            JTextField jTextField = this.myApiUrlTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                jTextField = null;
            }
            if (!Intrinsics.areEqual((Object)InternalUtilsKt.safeTrim(jTextField.getText()), (Object)InternalUtilsKt.safeTrim(config.getApiUrl()))) return true;
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                textFieldWithBrowseButton = null;
            }
            if (Intrinsics.areEqual((Object)textFieldWithBrowseButton.getText(), (Object)config.getCertificatesPath())) return false;
            return true;
        }

        protected void resetEditorFrom(@NotNull DockerCloudConfiguration s) {
            Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
            if (Intrinsics.areEqual((Object)s.getCustomConfiguratorId(), (Object)DockerTcpConnectionConfigurator.this.getId())) {
                String string;
                JTextField jTextField = this.myApiUrlTextField;
                if (jTextField == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                    jTextField = null;
                }
                jTextField.setText(s.getApiUrl());
                TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
                if (textFieldWithBrowseButton == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                    textFieldWithBrowseButton = null;
                }
                if ((string = s.getCertificatesPath()) == null) {
                    string = "";
                }
                textFieldWithBrowseButton.setText(string);
            }
        }

        protected void applyEditorTo(@NotNull DockerCloudConfiguration s) {
            String certificatesPath;
            String apiUrl;
            Intrinsics.checkNotNullParameter((Object)((Object)s), (String)"s");
            JTextField jTextField = this.myApiUrlTextField;
            if (jTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myApiUrlTextField");
                jTextField = null;
            }
            if (StringUtil.isEmpty((String)(apiUrl = InternalUtilsKt.safeTrim(jTextField.getText())))) {
                throw new RuntimeConfigurationError(DockerBundle.message("DockerCloudConfigurable.error.apiUrlRequired", new Object[0]));
            }
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.myCertificatesPathTextField;
            if (textFieldWithBrowseButton == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCertificatesPathTextField");
                textFieldWithBrowseButton = null;
            }
            if (!StringUtil.isEmpty((String)(certificatesPath = InternalUtilsKt.safeTrim(textFieldWithBrowseButton.getText()))) && !new File(certificatesPath).exists()) {
                Object[] objectArray = new Object[]{certificatesPath};
                throw new RuntimeConfigurationError(DockerBundle.message("DockerCloudConfigurable.error.certificatesFolder.missing", objectArray));
            }
            s.setApiUrl(apiUrl);
            s.setCertificatesPath(certificatesPath);
        }

        @NotNull
        protected JComponent createEditor() {
            return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
                final /* synthetic */ MyEditor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Panel $this$panel) {
                    Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ MyEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            String string = DockerBundle.message("DockerCloudConfigurable.engine.url.text", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            $this$row.label(string);
                            Cell cell = $this$row.textField();
                            MyEditor myEditor = this.this$0;
                            Cell it = cell;
                            boolean bl = false;
                            MyEditor.access$setMyApiUrlTextField$p(myEditor, (JTextField)it.getComponent());
                        }
                    }), (int)1, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ MyEditor this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            String string = DockerBundle.message("DockerCloudConfigurable.certificates.folder.text", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            $this$row.label(string);
                            Cell cell = Row.textFieldWithBrowseButton$default((Row)$this$row, null, null, null, null, (int)15, null);
                            MyEditor myEditor = this.this$0;
                            Cell it = cell;
                            boolean bl = false;
                            ((TextFieldWithBrowseButton)it.getComponent()).addBrowseFolderListener(DockerBundle.message("DockerCloudConfigurable.chooser.certificates.title", new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
                            MyEditor.access$setMyCertificatesPathTextField$p(myEditor, (TextFieldWithBrowseButton)it.getComponent());
                        }
                    }), (int)1, null);
                }
            }));
        }

        public static final /* synthetic */ void access$setMyApiUrlTextField$p(MyEditor $this, JTextField jTextField) {
            $this.myApiUrlTextField = jTextField;
        }

        public static final /* synthetic */ void access$setMyCertificatesPathTextField$p(MyEditor $this, TextFieldWithBrowseButton textFieldWithBrowseButton) {
            $this.myCertificatesPathTextField = textFieldWithBrowseButton;
        }
    }
}

