/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.agent.settings.DockerPortSpec;
import com.intellij.docker.composeFile.ComposeInspectionHelper;
import com.intellij.docker.composeFile.i18n.DockerComposeBundle;
import com.intellij.docker.composeFile.model.PortScalarType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFix;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlComposedTypeBase;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase;", "()V", "helper", "Lcom/intellij/docker/composeFile/ComposeInspectionHelper;", "doBuildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "getMetaTypeProvider", "PortsChecker", "intellij.clouds.docker.compose"})
public final class ComposeUnquotedPortsInspection
extends YamlMetaTypeInspectionBase {
    @NotNull
    private final ComposeInspectionHelper helper = new ComposeInspectionHelper();

    @Nullable
    protected YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return this.helper.getMetaTypeProvider(holder);
    }

    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
        return (PsiElementVisitor)new PortsChecker(holder, metaTypeProvider);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker;", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeInspectionBase$SimpleYamlPsiVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "metaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;)V", "visitYAMLSequenceItem", "", "item", "Lorg/jetbrains/yaml/psi/YAMLSequenceItem;", "fieldAndType", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/yaml/psi/YAMLValue;", "Companion", "intellij.clouds.docker.compose"})
    private static final class PortsChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ProblemsHolder holder;
        @NotNull
        private final YamlMetaTypeProvider metaTypeProvider;

        public PortsChecker(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)metaTypeProvider, (String)"metaTypeProvider");
            this.holder = holder;
            this.metaTypeProvider = metaTypeProvider;
        }

        protected void visitYAMLSequenceItem(@NotNull YAMLSequenceItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            YAMLValue yAMLValue = item.getValue();
            YAMLScalar yAMLScalar = yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null;
            if (yAMLScalar == null) {
                return;
            }
            YAMLScalar value = yAMLScalar;
            if (value instanceof YAMLQuotedText) {
                return;
            }
            Object object = this.fieldAndType((YAMLValue)value);
            if (object == null || (object = object.getMetaType()) == null || (object = PortsChecker.Companion.asPortScalarType((YamlMetaType)object)) == null) {
                return;
            }
            Object type = object;
            DockerPortSpec dockerPortSpec = ((PortScalarType)((Object)type)).toDockerPortSpec(value);
            if (dockerPortSpec == null) {
                return;
            }
            DockerPortSpec portSpec = dockerPortSpec;
            if (PortsChecker.Companion.mayBeInterpretedAsBase60(portSpec)) {
                PsiElement psiElement = (PsiElement)value;
                String string = DockerComposeBundle.message("ComposeUnquotedPortsInspection.error.message", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement2 = (PsiElement)value;
                String string2 = DockerComposeBundle.message("ComposeUnquotedPortsInspection.quick.fix", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                localQuickFixArray[0] = new YAMLAddQuoteQuickFix(psiElement2, string2, false, 4, null);
                this.holder.registerProblem(psiElement, string, ProblemHighlightType.ERROR, localQuickFixArray);
            } else {
                PsiElement psiElement = (PsiElement)value;
                String string = DockerComposeBundle.message("ComposeUnquotedPortsInspection.warning.message", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement3 = (PsiElement)value;
                String string3 = DockerComposeBundle.message("ComposeUnquotedPortsInspection.quick.fix", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                localQuickFixArray[0] = new YAMLAddQuoteQuickFix(psiElement3, string3, false, 4, null);
                this.holder.registerProblem(psiElement, string, ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            }
        }

        private final YamlMetaTypeProvider.MetaTypeProxy fieldAndType(YAMLValue $this$fieldAndType) {
            return this.metaTypeProvider.getValueMetaType($this$fieldAndType);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\bH\u0002J\f\u0010\t\u001a\u00020\u0007*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker$Companion;", "", "()V", "asPortScalarType", "Lcom/intellij/docker/composeFile/model/PortScalarType;", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "base60Value", "", "Lkotlin/ranges/IntRange;", "mayBeInterpretedAsBase60", "Lcom/intellij/docker/agent/settings/DockerPortSpec;", "intellij.clouds.docker.compose"})
        @SourceDebugExtension(value={"SMAP\nComposeUnquotedPortsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeUnquotedPortsInspection.kt\ncom/intellij/docker/composeFile/ComposeUnquotedPortsInspection$PortsChecker$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean mayBeInterpretedAsBase60(DockerPortSpec $this$mayBeInterpretedAsBase60) {
                return ((CharSequence)$this$mayBeInterpretedAsBase60.getLocalSpec().getHostIP()).length() == 0 && this.base60Value($this$mayBeInterpretedAsBase60.getLocalSpec().getPortRange()) && this.base60Value($this$mayBeInterpretedAsBase60.getContainerSpec().getPortsRange());
            }

            private final boolean base60Value(IntRange $this$base60Value) {
                return $this$base60Value != null && $this$base60Value.getStart().intValue() == $this$base60Value.getEndInclusive().intValue() && $this$base60Value.getStart() < 60;
            }

            private final PortScalarType asPortScalarType(YamlMetaType $this$asPortScalarType) {
                PortScalarType portScalarType;
                block5: {
                    YamlMetaType yamlMetaType = $this$asPortScalarType;
                    if (yamlMetaType instanceof PortScalarType) {
                        portScalarType = (PortScalarType)$this$asPortScalarType;
                    } else if (yamlMetaType instanceof YamlComposedTypeBase) {
                        Iterable iterable = ((YamlComposedTypeBase)$this$asPortScalarType).getSubTypes();
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTypes(...)");
                        for (YamlMetaType it : iterable) {
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)it);
                            PortScalarType portScalarType2 = Companion.asPortScalarType(it);
                            if (portScalarType2 == null) continue;
                            portScalarType = portScalarType2;
                            break block5;
                        }
                        portScalarType = null;
                    } else {
                        portScalarType = null;
                    }
                }
                return portScalarType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

