/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.DockerRuntimesManager;
import com.intellij.docker.DockerServerRuntimesManager;
import com.intellij.docker.runtimes.ComposeDeploymentRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.ComposeServiceStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ProcessingContext;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\rH\u0000\u001a\u0015\u0010\u0010\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u001a\u0015\u0010\u0017\u001a\u00020\u00112\u000b\u0010\u0012\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0013H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u0011*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001b*\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"TAG_NAME", "", "TAG_SERVICES", "TAG_VERSION", "X_TESTING_TAG", "findFirstNotNullComposeStatus", "Lcom/intellij/docker/runtimes/ComposeServiceStatus;", "project", "Lcom/intellij/openapi/project/Project;", "composeProject", "composeService", "fromComposeFile", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "getComposeProjectName", "element", "isComposeYamlFileName", "", "fileName", "Lorg/jetbrains/annotations/NonNls;", "isDockerComposeYamlFile", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "isDockerComposeYamlFileName", "isFromComposeFile", "isYaml", "contains", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "name", "getTopLevelValue", "intellij.clouds.docker.compose"})
@JvmName(name="ComposeFileUtil")
@SourceDebugExtension(value={"SMAP\nComposeFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeFileUtil.kt\ncom/intellij/docker/composeFile/ComposeFileUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class ComposeFileUtil {
    @NotNull
    public static final String TAG_NAME = "name";
    @NotNull
    public static final String TAG_SERVICES = "services";
    @NotNull
    public static final String TAG_VERSION = "version";
    @NotNull
    private static final String X_TESTING_TAG = "x-testing-root";

    @NotNull
    public static final PatternCondition<PsiElement> fromComposeFile() {
        return (PatternCondition)new PatternCondition<PsiElement>(){

            public boolean accepts(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return ComposeFileUtil.isFromComposeFile(element);
            }
        };
    }

    @Nullable
    public static final ComposeServiceStatus findFirstNotNullComposeStatus(@NotNull Project project, @NotNull String composeProject, @NotNull String composeService2) {
        ComposeServiceStatus composeServiceStatus;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)composeProject, (String)"composeProject");
            Intrinsics.checkNotNullParameter((Object)composeService2, (String)"composeService");
            for (DockerRuntimesManager it : (Iterable)DockerServerRuntimesManager.Companion.getConnectedManagers(project)) {
                boolean bl = false;
                ComposeServiceRuntime composeServiceRuntime = it.findComposeService(composeProject, composeService2);
                ComposeServiceStatus composeServiceStatus2 = composeServiceRuntime != null ? composeServiceRuntime.getServiceStatus() : null;
                if (composeServiceStatus2 == null) continue;
                composeServiceStatus = composeServiceStatus2;
                break block1;
            }
            composeServiceStatus = null;
        }
        return composeServiceStatus;
    }

    public static final boolean isFromComposeFile(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile $this$isFromComposeFile_u24lambda_u241 = element.getContainingFile();
        boolean bl = false;
        return $this$isFromComposeFile_u24lambda_u241 instanceof YAMLFile && ComposeFileUtil.isDockerComposeYamlFile((YAMLFile)$this$isFromComposeFile_u24lambda_u241);
    }

    @Nullable
    public static final String getComposeProjectName(@NotNull PsiElement element) {
        Object object;
        block8: {
            VirtualFile parent;
            block7: {
                Object object2;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (!ComposeFileUtil.isFromComposeFile(element)) {
                    return null;
                }
                VirtualFile virtualFile2 = element.getContainingFile().getOriginalFile().getVirtualFile();
                Object object3 = virtualFile2 != null ? virtualFile2.getParent() : null;
                if (object3 == null) {
                    return null;
                }
                parent = object3;
                try {
                    boolean bl = false;
                    object2 = Result.constructor-impl((Object)parent.toNioPath());
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if ((object = (Path)(Result.isFailure-impl((Object)object2) ? null : object2)) == null) break block7;
                Path path = object;
                boolean bl = false;
                String string = ComposeDeploymentRuntime.Companion.computeEnvVarAwareProjectName$default(ComposeDeploymentRuntime.Companion, path, null, 2, null);
                object = string;
                if (string != null) break block8;
            }
            String string = parent.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            object = ComposeDeploymentRuntime.Companion.computeErasedProjectName(string);
        }
        return object;
    }

    @RequiresReadLock
    public static final boolean isDockerComposeYamlFile(@NotNull YAMLFile yamlFile) {
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        VirtualFile virtualFile2 = yamlFile.getOriginalFile().getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile vFile = virtualFile2;
        String string = vFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (ComposeFileUtil.isDockerComposeYamlFileName(string)) {
            return true;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)yamlFile), () -> ComposeFileUtil.isDockerComposeYamlFile$lambda$4(yamlFile, vFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    public static final boolean isDockerComposeYamlFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerCaseName = string;
        return ComposeFileUtil.isYaml(lowerCaseName) && StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"docker-compose", (boolean)false, (int)2, null);
    }

    public static final boolean isComposeYamlFileName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String lowerCaseName = string;
        return ComposeFileUtil.isYaml(lowerCaseName) && StringsKt.contains$default((CharSequence)lowerCaseName, (CharSequence)"compose", (boolean)false, (int)2, null);
    }

    private static final boolean isYaml(String fileName) {
        return StringsKt.endsWith$default((String)fileName, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".yml", (boolean)false, (int)2, null);
    }

    private static final YAMLMapping getTopLevelValue(YAMLFile $this$getTopLevelValue) {
        if ($this$getTopLevelValue.getDocuments().size() != 1) {
            return null;
        }
        YAMLValue yAMLValue = ((YAMLDocument)$this$getTopLevelValue.getDocuments().get(0)).getTopLevelValue();
        return yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
    }

    private static final boolean contains(YAMLMapping $this$contains, String name2) {
        return $this$contains.getKeyValueByKey(name2) != null;
    }

    private static final CachedValueProvider.Result isDockerComposeYamlFile$lambda$4(YAMLFile $yamlFile, VirtualFile $vFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$yamlFile, (String)"$yamlFile");
        Intrinsics.checkNotNullParameter((Object)$vFile, (String)"$vFile");
        YAMLMapping topLevelValue = ComposeFileUtil.getTopLevelValue($yamlFile);
        if (topLevelValue == null) {
            bl = false;
        } else if (ApplicationManager.getApplication().isUnitTestMode() && ComposeFileUtil.contains(topLevelValue, X_TESTING_TAG)) {
            bl = true;
        } else if (!ComposeFileUtil.contains(topLevelValue, TAG_SERVICES)) {
            bl = false;
        } else {
            String string = $vFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            bl = ComposeFileUtil.isComposeYamlFileName(string) ? true : ComposeFileUtil.contains(topLevelValue, TAG_VERSION) || ComposeFileUtil.contains(topLevelValue, TAG_NAME);
        }
        boolean result2 = bl;
        Object[] objectArray = new Object[]{$yamlFile};
        return new CachedValueProvider.Result((Object)result2, objectArray);
    }
}

