/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.composeFile;

import com.intellij.docker.composeFile.ComposeFileUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public final class ComposeFileServicesIndex {
    private static final String SYNTHETIC_IS_COMPOSE_FILE_FLAG = "type: docker-compose:";
    private static final PsiFileGist<String> GIST = GistManager.getInstance().newPsiFileGist("docker.compose.services", 2, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, ComposeFileServicesIndex::calculateIndex);

    public static boolean isDockerComposeFile(@NotNull YAMLFile yamlFile) {
        VirtualFile theOnlyFile;
        if (yamlFile == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(0);
        }
        if ((theOnlyFile = yamlFile.getOriginalFile().getVirtualFile()) == null) {
            return false;
        }
        return SYNTHETIC_IS_COMPOSE_FILE_FLAG.equals(GIST.getFileData((PsiFile)yamlFile));
    }

    @Nullable
    private static String calculateIndex(PsiFile file2) {
        final Ref result2 = Ref.create();
        file2.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

            public void visitDocument(@NotNull YAMLDocument document) {
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                String fileName = document.getContainingFile().getName();
                Optional.ofNullable(document.getTopLevelValue()).map(ComposeFileServicesIndex::asYamlMapping).ifPresent(topMapping -> {
                    if (ComposeFileUtil.isDockerComposeYamlFileName(fileName)) {
                        result2.set((Object)ComposeFileServicesIndex.SYNTHETIC_IS_COMPOSE_FILE_FLAG);
                    } else {
                        boolean hasName;
                        YAMLKeyValue servicesRoot = topMapping.getKeyValueByKey("services");
                        if (servicesRoot == null) {
                            return;
                        }
                        boolean hasComposeName = ComposeFileUtil.isComposeYamlFileName(fileName);
                        boolean hasVersion = topMapping.getKeyValueByKey("version") != null;
                        boolean bl = hasName = topMapping.getKeyValueByKey("name") != null;
                        if (hasComposeName || hasVersion || hasName) {
                            result2.set((Object)ComposeFileServicesIndex.SYNTHETIC_IS_COMPOSE_FILE_FLAG);
                        }
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/docker/composeFile/ComposeFileServicesIndex$1", "visitDocument"));
            }
        });
        return (String)result2.get();
    }

    @Nullable
    private static YAMLMapping asYamlMapping(@NotNull YAMLValue value) {
        if (value == null) {
            ComposeFileServicesIndex.$$$reportNull$$$0(1);
        }
        return (YAMLMapping)ObjectUtils.tryCast((Object)value, YAMLMapping.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/composeFile/ComposeFileServicesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDockerComposeFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "asYamlMapping";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

