/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationBuilder;
import com.intellij.docker.agent.compose.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBuilder;
import com.intellij.docker.agent.compose.beans.DockerComposeVersion;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1Builder;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2Builder;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2Builder;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.DockerErrorUtilKt;
import com.intellij.docker.compose.DockerComposeIntegrationService;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.docker.compose.configuration.beans.parse.PureDockerComposeConfigurationParser;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceCmdExecUtils {
    private static final Logger LOG = Logger.getInstance(ServiceCmdExecUtils.class);
    public static final String GENERATED_COMPOSE_FILE_SUFFIX = "generated.override";
    public static final String EMPTY_COMMAND = "";
    private static final String DOCKER_COMPOSE_OVERRIDE = "docker-compose.override.";
    private static final String YML_EXTENSION = ".yml";
    private static final Pattern DOCKER_START_PATTERN = Pattern.compile("\\$docker start (?<name>.+)");
    public static final Path TEMP_DIR = Paths.get(PathManager.getTempPath(), new String[0]).resolve("docker_compose");
    private static final Set<String> DOCKER_ENV_VARS = Set.of("DOCKER_HOST", "DOCKER_TLS_VERIFY", "DOCKER_CERT_PATH");
    public static final String BIN_TRUE_CMD = "/bin/true";
    private static final String NETWORK_MODE_NONE = "none";

    private ServiceCmdExecUtils() {
    }

    @NotNull
    public static DockerComposeConfigurationBuilder<?, ?, ?> createConfigurationBuilder(@NotNull List<Path> configurationPaths, final @NotNull Collection<String> volumes, @Nullable DockerCloudConfiguration config) throws IOException {
        if (configurationPaths == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(0);
        }
        if (volumes == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(1);
        }
        String path = configurationPaths.get(0).toAbsolutePath().toString();
        final DockerComposeVersion version2 = PureDockerComposeConfigurationParser.getCachingInstance().parseVersion(path);
        DockerComposeFileConfigurationProvider configurationProvider = DockerComposeFileConfigurationProvider.getInstance();
        List paths = ContainerUtil.map(configurationPaths, x -> x.toAbsolutePath().toString());
        DockerComposeConfigurationBuilder dockerComposeConfigurationBuilder = (DockerComposeConfigurationBuilder)configurationProvider.getConfigFor(paths, config).accept(new DockerComposeConfiguration.Visitor<DockerComposeConfigurationBuilder<?, ?, ?>>(){

            @Override
            public DockerComposeConfigurationV1Builder visit(@NotNull DockerComposeConfigurationV1 configuration) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new DockerComposeConfigurationV1Builder();
            }

            @Override
            public DockerComposeConfigurationBuilder<?, ?, ?> visit(@NotNull DockerComposeConfigurationV2 configuration) {
                if (configuration == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (version2 instanceof DockerComposeVersion.V1) {
                    return new DockerComposeConfigurationV1Builder();
                }
                DockerComposeConfigurationV2Builder builder = new DockerComposeConfigurationV2Builder();
                if (version2 instanceof DockerComposeVersion.Explicit) {
                    builder.withVersion(((DockerComposeVersion.Explicit)version2).getVersion());
                }
                for (String volume2 : volumes) {
                    builder.addVolume(volume2);
                }
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$1", "visit"));
            }
        });
        if (dockerComposeConfigurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(2);
        }
        return dockerComposeConfigurationBuilder;
    }

    @NotNull
    public static Set<String> collectNamedVolumes(DockerVolumeBinding @Nullable [] bindings) {
        if (bindings == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(3);
            }
            return set;
        }
        LinkedHashSet<String> volumes = new LinkedHashSet<String>();
        for (DockerVolumeBinding bind : bindings) {
            String bindPath = bind.getHostPath();
            if (bindPath == null || !DockerComposeUtilsKt.isDockerComposeNamedVolumeBind(bindPath)) continue;
            volumes.add(bindPath);
        }
        LinkedHashSet<String> linkedHashSet = volumes;
        if (linkedHashSet == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    public static File createTempDockerComposeOverrideYml() throws IOException {
        File tempDir2 = TEMP_DIR.toFile();
        File file2 = FileUtil.createTempFile((File)tempDir2, (String)DOCKER_COMPOSE_OVERRIDE, (String)YML_EXTENSION, (boolean)true);
        if (file2 == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @NotNull
    public static String parseServiceContainerName(@NotNull String stdout) {
        if (stdout == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(6);
        }
        String trimmedStdout = StringUtil.trim((String)stdout);
        int last = Math.max(trimmedStdout.lastIndexOf("\n"), trimmedStdout.lastIndexOf("\r"));
        String string = trimmedStdout.substring(last + 1).trim();
        if (string == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String parseDockerStartCmd(@NotNull String s) {
        Matcher matcher;
        if (s == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(8);
        }
        if ((matcher = DOCKER_START_PATTERN.matcher(s)).matches()) {
            return matcher.group("name").trim();
        }
        return null;
    }

    @NotNull
    static Optional<Matcher> matches(@NotNull String s, @NotNull Iterable<Pattern> patterns) {
        if (s == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(9);
        }
        if (patterns == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(10);
        }
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            Optional<Matcher> optional = Optional.of(matcher);
            if (optional == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(11);
            }
            return optional;
        }
        Optional<Matcher> optional = Optional.empty();
        if (optional == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(12);
        }
        return optional;
    }

    @NotNull
    public static ServiceContainers listServiceContainerNames(@NotNull ProcessOutput dockerComposeProcessOutput) {
        if (dockerComposeProcessOutput == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(13);
        }
        LinkedHashSet<String> allServices = new LinkedHashSet<String>();
        List<Pattern> ignorePatterns = Arrays.asList(Pattern.compile("Creating volume \".*\" with .* driver"), Pattern.compile("Creating network \".*\" with .* driver"));
        List<Pattern> upToDatePatterns = Collections.singletonList(Pattern.compile("(?<container>.*) is up-to-date"));
        List<Pattern> patterns = Collections.singletonList(Pattern.compile("(?:Starting|Creating|Recreating) (?<container>.+)"));
        LinkedHashSet<String> upToDateServices = new LinkedHashSet<String>();
        boolean allErrLinesMatched = true;
        for (String line : dockerComposeProcessOutput.getStderrLines()) {
            String serviceContainerName;
            Optional<Matcher> matcher;
            if (!StringUtil.isNotEmpty((String)line)) continue;
            Optional<Matcher> ignoreMatcher = ServiceCmdExecUtils.matches(line, ignorePatterns);
            boolean matched = ignoreMatcher.isPresent();
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, patterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                matched = true;
            }
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, upToDatePatterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                upToDateServices.add(serviceContainerName);
                matched = true;
            }
            if (matched) continue;
            allErrLinesMatched = false;
        }
        if (!allErrLinesMatched && LOG.isDebugEnabled()) {
            LOG.debug("Failed to locate container names in every line of Docker Compose output.\nstderr:\n", new Object[]{dockerComposeProcessOutput.getStderr(), "\nstdout:\n" + dockerComposeProcessOutput.getStdout()});
        }
        return new ServiceContainers(allServices, upToDateServices);
    }

    @NotNull
    public static String extractErrorMessage(@NotNull ServerRuntimeException e) {
        String extracted;
        if (e == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(14);
        }
        if ((extracted = DockerErrorUtilKt.extractDockerErrorMessage(e)) != null) {
            String string = extracted;
            if (string == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(15);
            }
            return string;
        }
        String message = e.getMessage();
        String string = message != null ? message : e.toString();
        if (string == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static List<DockerEnvVar> filterDockerEnvs(@NotNull List<DockerEnvVar> vars) {
        if (vars == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(17);
        }
        ArrayList<DockerEnvVar> list2 = new ArrayList<DockerEnvVar>();
        for (DockerEnvVar var : vars) {
            String name2 = var.getName();
            if (name2 != null && DOCKER_ENV_VARS.contains(name2)) continue;
            list2.add(var);
        }
        ArrayList<DockerEnvVar> arrayList = list2;
        if (arrayList == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static void setupSharedVolume(@NotNull DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder, @NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, @NotNull AbstractServiceCmd<?> cmd, @NotNull List<Path> configurationPaths, DockerVolumeBinding @Nullable [] bindings) {
        SharedVolume sharedVolume;
        if (configurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(19);
        }
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(20);
        }
        if (cmd == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(21);
        }
        if (configurationPaths == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(22);
        }
        if ((sharedVolume = cmd.getSharedVolume()) != null) {
            if (configurationBuilder instanceof DockerComposeConfigurationV1Builder) {
                ServiceCmdExecUtils.setupSharedVolumesFrom(serviceBuilder, cmd, sharedVolume);
            } else if (configurationBuilder instanceof DockerComposeConfigurationV2Builder) {
                DockerComposeConfigurationV2Builder configurationV2Builder = (DockerComposeConfigurationV2Builder)configurationBuilder;
                String version2 = configurationV2Builder.getVersion();
                RemoteDockerRuntime dockerRuntime2 = cmd.getDockerRuntime();
                DockerComposeIntegrationService.getInstance().prePopulateSharedVolume(dockerRuntime2, cmd.getProjectName(), configurationPaths, version2, sharedVolume, cmd.getEnvs());
                ServiceCmdExecUtils.setupSharedServiceVolume(configurationV2Builder, serviceBuilder, bindings, sharedVolume);
            } else {
                throw new IllegalStateException("Unsupported Docker Compose version");
            }
        }
    }

    public static void assertVolumesFromOptionSupported(@NotNull DockerComposeConfigurationBuilder<?, ?, ?> builder) {
        String majorVersion;
        String version2;
        if (builder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(23);
        }
        if (builder instanceof DockerComposeConfigurationV2Builder && (version2 = ((DockerComposeConfigurationV2Builder)builder).getVersion()) != null && !"2".equals(majorVersion = DockerComposeConfigurationParserUtil.getMajorVersion(version2))) {
            throw new IllegalArgumentException("Unsupported docker compose configuration version: " + version2);
        }
    }

    @NotNull
    public static DockerComposeConfigurationV2 setupSharedService(@Nullable String configurationVersion, @NotNull SharedVolume sharedVolume) {
        if (sharedVolume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(24);
        }
        DockerComposeConfigurationV2Builder configurationBuilder = new DockerComposeConfigurationV2Builder();
        configurationBuilder.withVersion(configurationVersion);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create service " + sharedVolume.getServiceName() + " to share " + sharedVolume.getImage() + " image volume " + sharedVolume.getVolumePath() + " using named volume " + sharedVolume.getVolumeName());
        }
        configurationBuilder.addVolume(sharedVolume.getVolumeName());
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl(sharedVolume.getVolumePath(), sharedVolume.getVolumeName(), true);
        DockerComposeServiceV2Builder helpersServiceBuilder = configurationBuilder.addService(sharedVolume.getServiceName());
        ((DockerComposeServiceV2Builder)((DockerComposeServiceV2Builder)((DockerComposeServiceV2Builder)helpersServiceBuilder.withCommand(new String[]{BIN_TRUE_CMD})).withImage(sharedVolume.getImage())).withBindVolumes(new DockerVolumeBinding[]{binding})).withNetworkMode(NETWORK_MODE_NONE);
        DockerComposeConfigurationV2 dockerComposeConfigurationV2 = configurationBuilder.build();
        if (dockerComposeConfigurationV2 == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(25);
        }
        return dockerComposeConfigurationV2;
    }

    private static void setupSharedServiceVolume(@NotNull DockerComposeConfigurationV2Builder configurationBuilder, @NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, DockerVolumeBinding @Nullable [] bindings, @NotNull SharedVolume sharedVolume) {
        if (configurationBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(26);
        }
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(27);
        }
        if (sharedVolume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(28);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Share " + sharedVolume.getImage() + " image volume " + sharedVolume.getVolumePath() + " using named volume " + sharedVolume.getVolumeName());
        }
        configurationBuilder.addVolume(sharedVolume.getVolumeName());
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl(sharedVolume.getVolumePath(), sharedVolume.getVolumeName(), true);
        serviceBuilder.withBindVolumes(ServiceCmdExecUtils.append(bindings, binding, DockerVolumeBinding.class));
    }

    private static void setupSharedVolumesFrom(@NotNull DockerComposeServiceBuilder<?, ?> serviceBuilder, @NotNull AbstractServiceCmd<?> cmd, @NotNull SharedVolume sharedVolume) {
        if (serviceBuilder == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(29);
        }
        if (cmd == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(30);
        }
        if (sharedVolume == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(31);
        }
        LOG.debug("Using volumes_from to share " + sharedVolume + " container volume " + sharedVolume.getVolumePath());
        serviceBuilder.withVolumesFrom(ServiceCmdExecUtils.append(cmd.getVolumesFrom(), ServiceCmdExecUtils.readOnlyVolumesFrom(sharedVolume.getContainer()), DockerVolumesFrom.class));
    }

    @NotNull
    private static DockerVolumesFrom readOnlyVolumesFrom(final @NotNull String container) {
        if (container == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(32);
        }
        return new DockerVolumesFrom(){

            @Override
            public String getContainerId() {
                return container;
            }

            @Override
            public boolean isReadOnly() {
                return true;
            }
        };
    }

    @Contract(pure=true)
    public static <T> T @NotNull [] append(T @Nullable [] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (componentType == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(33);
        }
        if (src == null) {
            Object[] array = (Object[])Array.newInstance(componentType, 1);
            array[0] = element;
            if (array == null) {
                ServiceCmdExecUtils.$$$reportNull$$$0(34);
            }
            return array;
        }
        Object[] objectArray = ArrayUtil.append((Object[])src, element, componentType);
        if (objectArray == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(35);
        }
        return objectArray;
    }

    @NotNull
    public static File writeDockerComposeOverrideYml(@NotNull File generalFile, @NotNull DockerComposeConfiguration configuration) throws IOException {
        if (generalFile == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(36);
        }
        if (configuration == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(37);
        }
        String generalFileName = FilenameUtils.getBaseName((String)generalFile.getName());
        String generalFileDir = generalFile.getAbsoluteFile().getParent();
        String fileName = generalFileName + ".generated.override.yml";
        File file2 = new File(generalFileDir, fileName);
        FileUtilRt.createIfNotExists((File)file2);
        StringWriter writer = new StringWriter();
        writer.write("# " + DockerBundle.message("GeneratedComposeFile.header", new Object[0]) + System.lineSeparator());
        DockerComposeConfigurationSerializer.newInstance().serialize(writer, configuration);
        return ServiceCmdExecUtils.doWriteComposeOverrideYml(file2, writer.toString());
    }

    @NotNull
    private static File doWriteComposeOverrideYml(@NotNull File file2, @NotNull String fileContent) throws IOException {
        if (file2 == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(38);
        }
        if (fileContent == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(39);
        }
        LOG.debug("Writing to ", new Object[]{file2, "\n", fileContent});
        FileUtil.writeToFile((File)file2, (String)fileContent, (Charset)StandardCharsets.UTF_8);
        File file3 = file2;
        if (file3 == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(40);
        }
        return file3;
    }

    @NotNull
    public static File writeDockerComposeOverrideYml(@NotNull DockerComposeConfiguration configuration) throws IOException {
        if (configuration == null) {
            ServiceCmdExecUtils.$$$reportNull$$$0(41);
        }
        File tempFile = ServiceCmdExecUtils.createTempDockerComposeOverrideYml();
        StringWriter stringWriter = new StringWriter();
        DockerComposeConfigurationSerializer.newInstance().serialize(stringWriter, configuration);
        return ServiceCmdExecUtils.doWriteComposeOverrideYml(tempFile, stringWriter.toString());
    }

    static void saveAllDocumentsAsIs() {
        Document[] documents;
        ThreadingAssertions.assertEventDispatchThread();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : documents = fileDocumentManager.getUnsavedDocuments()) {
            fileDocumentManager.saveDocumentAsIs(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 11, 12, 15, 16, 18, 25, 34, 35, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationPaths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 34: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerComposeProcessOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationBuilder";
                break;
            }
            case 20: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBuilder";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 24: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedVolume";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalFile";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNamedVolumes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDockerComposeOverrideYml";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseServiceContainerName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extractErrorMessage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDockerEnvs";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSharedService";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "doWriteComposeOverrideYml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 25: 
            case 34: 
            case 35: 
            case 40: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceContainerName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseDockerStartCmd";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listServiceContainerNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractErrorMessage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterDockerEnvs";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedVolume";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "assertVolumesFromOptionSupported";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedService";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedServiceVolume";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setupSharedVolumesFrom";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readOnlyVolumesFrom";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 36: 
            case 37: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "writeDockerComposeOverrideYml";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doWriteComposeOverrideYml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 11, 12, 15, 16, 18, 25, 34, 35, 40 -> new IllegalStateException(string);
        };
    }

    public static class ServiceContainers {
        @NotNull
        private final Set<String> myAllServices;
        @NotNull
        private final Set<String> myUpToDateServices;

        public ServiceContainers(@NotNull Set<String> allServices, @NotNull Set<String> upToDateServices) {
            if (allServices == null) {
                ServiceContainers.$$$reportNull$$$0(0);
            }
            if (upToDateServices == null) {
                ServiceContainers.$$$reportNull$$$0(1);
            }
            this.myAllServices = allServices;
            this.myUpToDateServices = upToDateServices;
        }

        @NotNull
        public Set<String> getAllServices() {
            Set<String> set = this.myAllServices;
            if (set == null) {
                ServiceContainers.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<String> getUpToDateServices() {
            Set<String> set = this.myUpToDateServices;
            if (set == null) {
                ServiceContainers.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allServices";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upToDateServices";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllServices";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpToDateServices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

