/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeDeserializer;
import com.intellij.docker.agent.compose.beans.DockerComposeVersion;
import com.intellij.docker.compose.configuration.beans.parse.CachingFilesSupplier;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationKey;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationSimpleParser;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationStreamParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser;", "Lcom/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationStreamParser;", "()V", "parseBean", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "reader", "Ljava/io/Reader;", "parseVersion", "Lcom/intellij/docker/agent/compose/beans/DockerComposeVersion;", "Caching", "Companion", "intellij.clouds.docker"})
public final class PureDockerComposeConfigurationParser
implements DockerComposeConfigurationStreamParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private PureDockerComposeConfigurationParser() {
    }

    @Override
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull Reader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object object = DockerComposeDeserializer.Companion.getMapper().readValue(reader, DockerComposeConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (DockerComposeConfiguration)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DockerComposeVersion parseVersion(@NotNull Reader reader) throws IOException {
        DockerComposeVersion dockerComposeVersion;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Closeable closeable = (Closeable)DockerComposeDeserializer.Companion.getMapper().getFactory().createParser(reader);
        Throwable throwable = null;
        try {
            JsonParser parser = (JsonParser)closeable;
            boolean bl = false;
            TreeNode treeNode = parser.getCodec().readTree(parser);
            Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"readTree(...)");
            JsonNode jsonNode = (JsonNode)treeNode;
            Intrinsics.checkNotNull((Object)parser);
            dockerComposeVersion = DockerComposeDeserializer.Companion.getDockerComposeConfigurationVersion(jsonNode, parser);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dockerComposeVersion;
    }

    @JvmStatic
    @NotNull
    public static final PureDockerComposeConfigurationParser getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final DockerComposeConfigurationSimpleParser getCachingInstance() {
        return Companion.getCachingInstance();
    }

    @Service(value={Service.Level.APP})
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0004\"\b\b\u0000\u0010\r*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\r0\u0010H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser$Caching;", "Lcom/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationSimpleParser;", "()V", "myCachingParser", "Lcom/intellij/docker/compose/configuration/beans/parse/CachingFilesSupplier;", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "myCachingVersionParser", "Lcom/intellij/docker/agent/compose/beans/DockerComposeVersion;", "parseBean", "path", "", "parseVersion", "withCaching", "T", "", "func", "Lkotlin/Function1;", "Ljava/io/Reader;", "intellij.clouds.docker"})
    private static final class Caching
    implements DockerComposeConfigurationSimpleParser {
        @NotNull
        private final CachingFilesSupplier<DockerComposeVersion> myCachingVersionParser = this.withCaching((Function1)new Function1<Reader, DockerComposeVersion>((Object)Companion.getInstance()){

            @NotNull
            public final DockerComposeVersion invoke(@NotNull Reader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PureDockerComposeConfigurationParser)this.receiver).parseVersion(p0);
            }
        });
        @NotNull
        private final CachingFilesSupplier<DockerComposeConfiguration> myCachingParser = this.withCaching((Function1)new Function1<Reader, DockerComposeConfiguration>((Object)Companion.getInstance()){

            @NotNull
            public final DockerComposeConfiguration invoke(@NotNull Reader p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PureDockerComposeConfigurationParser)this.receiver).parseBean(p0);
            }
        });

        @Override
        @NotNull
        public DockerComposeConfiguration parseBean(@NotNull String path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.myCachingParser.invoke(new DockerComposeConfigurationKey(CollectionsKt.listOf((Object)path), null));
        }

        @Override
        @NotNull
        public DockerComposeVersion parseVersion(@NotNull String path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.myCachingVersionParser.invoke(new DockerComposeConfigurationKey(CollectionsKt.listOf((Object)path), null));
        }

        private final <T> CachingFilesSupplier<T> withCaching(Function1<? super Reader, ? extends T> func) {
            return new CachingFilesSupplier(new Function1<DockerComposeConfigurationKey, T>(func){
                final /* synthetic */ Function1<Reader, T> $func;
                {
                    this.$func = $func;
                    super(1);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final T invoke(@NotNull DockerComposeConfigurationKey files) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)files, (String)"files");
                    List<String> composeFiles2 = files.getConfigurationFilePaths();
                    Path path = Paths.get((String)CollectionsKt.first(composeFiles2), new String[0]);
                    VirtualFile virtualFile2 = VfsUtil.findFile((Path)path, (boolean)true);
                    if (virtualFile2 != null) {
                        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
                        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
                        Document document = fileDocumentManager2.getCachedDocument(virtualFile2);
                        if (document != null && fileDocumentManager2.isDocumentUnsaved(document)) {
                            boolean $i$f$logger = false;
                            Logger logger2 = Logger.getInstance(PureDockerComposeConfigurationParser.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                            logger2.error("The document for the file " + path + " is unsaved. It must be saved in advance.");
                        }
                    }
                    Closeable closeable = new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8);
                    Function1<Reader, T> function1 = this.$func;
                    Throwable throwable = null;
                    try {
                        InputStreamReader reader = (InputStreamReader)closeable;
                        boolean bl = false;
                        object = function1.invoke((Object)reader);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)object;
                }
            }, null, 2, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser$Companion;", "", "()V", "getCachingInstance", "Lcom/intellij/docker/compose/configuration/beans/parse/DockerComposeConfigurationSimpleParser;", "getInstance", "Lcom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nPureDockerComposeConfigurationParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PureDockerComposeConfigurationParser.kt\ncom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,86:1\n42#2,3:87\n42#2,3:90\n*S KotlinDebug\n*F\n+ 1 PureDockerComposeConfigurationParser.kt\ncom/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser$Companion\n*L\n78#1:87,3\n83#1:90,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PureDockerComposeConfigurationParser getInstance() {
            boolean $i$f$service = false;
            Class<PureDockerComposeConfigurationParser> serviceClass$iv = PureDockerComposeConfigurationParser.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (PureDockerComposeConfigurationParser)object;
        }

        @JvmStatic
        @NotNull
        public final DockerComposeConfigurationSimpleParser getCachingInstance() {
            boolean $i$f$service = false;
            Class<Caching> serviceClass$iv = Caching.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (DockerComposeConfigurationSimpleParser)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

