/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.cli;

import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli;", "", "()V", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeCli.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeCli.kt\ncom/intellij/docker/cli/DockerComposeCli\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,68:1\n11#2:69\n*S KotlinDebug\n*F\n+ 1 DockerComposeCli.kt\ncom/intellij/docker/cli/DockerComposeCli\n*L\n21#1:69\n*E\n"})
public final class DockerComposeCli {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VERSION_COMMAND = "version";
    @NotNull
    private static final String SHORT_FLAG = "--short";
    @NotNull
    private static final Logger logger;

    private DockerComposeCli() {
    }

    @JvmStatic
    @NotNull
    public static final String getVersion(@Nullable ProgressIndicator indicator) throws ExecutionException {
        return Companion.getVersion(indicator);
    }

    @JvmStatic
    private static final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
        return DockerComposeCli.Companion.runCommand(indicator, cmd);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(DockerComposeCli.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/cli/DockerComposeCli$Companion;", "", "()V", "SHORT_FLAG", "", "VERSION_COMMAND", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getVersion", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runCommand", "Lcom/intellij/execution/process/ProcessOutput;", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getVersion(@Nullable ProgressIndicator indicator) throws ExecutionException {
            Object[] objectArray = new String[]{DockerComposeCli.VERSION_COMMAND, DockerComposeCli.SHORT_FLAG};
            GeneralCommandLine generalCommandLine = DockerComposeCliUtil.createDockerComposeCommandline$default(null, 1, null).withParameters((String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
            GeneralCommandLine cmd = generalCommandLine;
            ProcessOutput processOutput2 = this.runCommand(indicator, cmd);
            if (processOutput2.getExitCode() != 0 || processOutput2.isTimeout()) {
                if (processOutput2.isTimeout()) {
                    logger.debug(processOutput2.getStderr() + "\nTimed out");
                    throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.time.out", new Object[0]));
                }
                logger.debug(processOutput2.getStderr() + "\nExit code " + processOutput2.getExitCode());
                objectArray = new Object[]{processOutput2.getExitCode()};
                throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.version.command.nonzero.exit.code", objectArray));
            }
            String string = processOutput2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String stdout = string;
            if (StringsKt.isBlank((CharSequence)stdout)) {
                Object[] objectArray2 = new Object[]{stdout};
                throw new ExecutionException(DockerBundle.message("DockerComposeCli.error.cant.find.version.in.output", objectArray2));
            }
            return ((Object)StringsKt.trim((CharSequence)stdout)).toString();
        }

        public static /* synthetic */ String getVersion$default(Companion companion, ProgressIndicator progressIndicator, int n, Object object) throws ExecutionException {
            if ((n & 1) != 0) {
                progressIndicator = null;
            }
            return companion.getVersion(progressIndicator);
        }

        @JvmStatic
        private final ProcessOutput runCommand(ProgressIndicator indicator, GeneralCommandLine cmd) throws ExecutionException {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(cmd.getCommandLineList(null));
            Process process2 = null;
            try {
                Process process3 = processBuilder.start();
                Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"start(...)");
                process2 = process3;
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
            CapturingProcessHandler processHandler = new CapturingProcessHandler(process2, cmd.getCharset(), cmd.getCommandLineString());
            if (indicator != null) {
                ProcessOutput processOutput2 = processHandler.runProcessWithProgressIndicator(indicator);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcessWithProgressIndicator(...)");
                return processOutput2;
            }
            ProcessOutput processOutput3 = processHandler.runProcess();
            Intrinsics.checkNotNullExpressionValue((Object)processOutput3, (String)"runProcess(...)");
            return processOutput3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

