/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.cli.AsyncCliProcess;
import com.intellij.docker.agent.cli.Cli;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.agent.cli.ProcessResult;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeDeserializer;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.util.DockerComposeData;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u0013\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00142\u0010\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010\u0016\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0007\u001a4\u0010\u0013\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0018H\u0007\u001a\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u001c\u001a\u00020\u0003\u001a\u001c\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u001a\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002\u001a\u0018\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002\u001a\u0018\u0010#\u001a\u0004\u0018\u00010\u001b2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\f\u001a\u000e\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u001b\u001a2\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\b\u0010)\u001a\u0004\u0018\u00010\u001b2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018\u001a8\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\f2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0018\u001a\u0012\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020\u0003H\u0002\u001a\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0003\u001a\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0003H\u0002\u001a,\u00101\u001a\u000202*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u0003H\u0086@\u00a2\u0006\u0002\u00106\u001a\n\u00107\u001a\u00020\u0003*\u00020\u0003\u001a\f\u00108\u001a\u0004\u0018\u000109*\u00020:\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00030<*\u00020=\u001a\u0016\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020?0\u0018*\u00020=\u001a\n\u0010@\u001a\u00020-*\u00020A\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u00020\u00038\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\u00038\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"COMMA_REGEX", "Lkotlin/text/Regex;", "COMPOSE_FILES_LABEL_KEY", "", "COMPOSE_PROJECT_LABEL_KEY", "COMPOSE_PROJECT_NAME_ENV_VAR", "COMPOSE_SERVICE_LABEL_KEY", "COMPOSE_VERSION", "COMPOSE_WORKING_DIR_LABEL_KEY", "DEFAULT_DOCKER_COMPOSE_PROJECT_NAME", "DOCKER_COMPOSE_OVERRIDE_FILENAME", "DOCKER_COMPOSE_SUPPORTED_FILENAMES", "", "getDOCKER_COMPOSE_SUPPORTED_FILENAMES", "()Ljava/util/List;", "HTTPS_URL_SCHEMA", "HTTP_URL_SCHEMA", "TCP_URL_SCHEMA", "WSL_MNT_ROOT", "escapeDollarSigns", "", "command", "([Ljava/lang/String;)[Ljava/lang/String;", "string", "", "envs", "findDockerComposeConfigurationFiles", "Ljava/nio/file/Path;", "configurationPathname", "configurationPathNames", "findDockerComposeConfigurationPath", "folder", "getComposeFilePath", "originPath", "workingDirPath", "getDockerComposeDefaultWorkDir", "configurationFilePaths", "getDockerComposeProjectName", "composeFilePath", "getEffectiveDockerComposeProjectName", "projectName", "workDir", "getWindowsPath", "wslPath", "isDockerComposeNamedVolumeBind", "", "bindPath", "isWindowsAbsolutePath", "path", "composeConfig", "Lcom/intellij/docker/agent/compose/beans/v2/DockerComposeConfigurationV2;", "Lcom/intellij/docker/agent/cli/DockerCli;", "files", "workingDir", "(Lcom/intellij/docker/agent/cli/DockerCli;Ljava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fixApiUrlSchema", "getComposeData", "Lcom/intellij/docker/agent/util/DockerComposeData;", "Lcom/intellij/docker/agent/DockerAgentContainer;", "getServiceNames", "", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "getServices", "Lcom/intellij/docker/agent/compose/beans/DockerComposeServiceBase;", "isComposeFilesLabelSupported", "Lcom/intellij/docker/agent/util/DockerComposeData$Version;", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerComposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 8 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,407:1\n1549#2:408\n1620#2,3:409\n1360#2:447\n1446#2,5:448\n766#2:455\n857#2,2:456\n1360#2:458\n1446#2,5:459\n689#3:412\n722#3,4:413\n11065#4:417\n11400#4,3:418\n37#5,2:421\n37#5,2:453\n37#5,2:464\n1#6:423\n107#7:424\n79#7,22:425\n51#8:466\n43#8:467\n*S KotlinDebug\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n*L\n129#1:408\n129#1:409,3\n373#1:447\n373#1:448,5\n380#1:455\n380#1:456,2\n381#1:458\n381#1:459,5\n191#1:412\n191#1:413,4\n203#1:417\n203#1:418,3\n203#1:421,2\n373#1:453,2\n383#1:464,2\n357#1:424\n357#1:425,22\n389#1:466\n389#1:467\n*E\n"})
public final class DockerComposeUtilsKt {
    @NotNull
    public static final String COMPOSE_SERVICE_LABEL_KEY = "com.docker.compose.service";
    @NotNull
    public static final String COMPOSE_PROJECT_LABEL_KEY = "com.docker.compose.project";
    @NotNull
    public static final String COMPOSE_FILES_LABEL_KEY = "com.docker.compose.project.config_files";
    @NotNull
    public static final String COMPOSE_WORKING_DIR_LABEL_KEY = "com.docker.compose.project.working_dir";
    @NotNull
    public static final String COMPOSE_VERSION = "com.docker.compose.version";
    @NotNull
    private static final String HTTP_URL_SCHEMA = "http://";
    @NotNull
    private static final String HTTPS_URL_SCHEMA = "https://";
    @NotNull
    private static final String TCP_URL_SCHEMA = "tcp://";
    @NotNull
    private static final Regex COMMA_REGEX = new Regex(",");
    @NotNull
    private static final List<String> DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    @NonNls
    @NotNull
    private static final String DOCKER_COMPOSE_OVERRIDE_FILENAME;
    @NonNls
    @NotNull
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
    @NonNls
    @NotNull
    public static final String COMPOSE_PROJECT_NAME_ENV_VAR = "COMPOSE_PROJECT_NAME";
    @NotNull
    private static final String WSL_MNT_ROOT = "/mnt/";

    @NotNull
    public static final List<String> getDOCKER_COMPOSE_SUPPORTED_FILENAMES() {
        return DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    }

    @NotNull
    public static final String fixApiUrlSchema(@NotNull String $this$fixApiUrlSchema) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fixApiUrlSchema, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTP_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTPS_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else {
            object = $this$fixApiUrlSchema;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final DockerComposeData getComposeData(@NotNull DockerAgentContainer $this$getComposeData) {
        List list2;
        int n;
        CharSequence charSequence;
        Regex regex;
        String filesString;
        Object object;
        String workingDir2;
        Intrinsics.checkNotNullParameter((Object)$this$getComposeData, (String)"<this>");
        Map<String, String> containerLabels = $this$getComposeData.getContainerLabels();
        String string = containerLabels.get(COMPOSE_PROJECT_LABEL_KEY);
        if (string == null) {
            return null;
        }
        String project = string;
        String string2 = containerLabels.get(COMPOSE_SERVICE_LABEL_KEY);
        if (string2 == null) {
            return null;
        }
        String service = string2;
        String string3 = containerLabels.get(COMPOSE_VERSION);
        if (string3 == null) {
            return null;
        }
        String version2 = string3;
        String string4 = containerLabels.get(COMPOSE_WORKING_DIR_LABEL_KEY);
        if (string4 == null) {
            string4 = workingDir2 = "";
        }
        if ((object = (filesString = containerLabels.get(COMPOSE_FILES_LABEL_KEY))) != null && (object = (regex = COMMA_REGEX).split(charSequence = (CharSequence)object, n = 0)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string5 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DockerComposeUtilsKt.getComposeFilePath((String)it, workingDir2));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List filePaths = list2;
        DockerComposeData.Version version3 = DockerComposeData.Version.Companion.from(version2);
        if (version3 == null) {
            return null;
        }
        DockerComposeData.Version parsedVersion = version3;
        return new DockerComposeData(service, project, workingDir2, SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)filePaths), (Function1)getComposeData.1.INSTANCE)), parsedVersion);
    }

    private static final String getComposeFilePath(String originPath, String workingDirPath) {
        if (Platform.INSTANCE.isWindows()) {
            if (DockerComposeUtilsKt.isWindowsAbsolutePath(originPath)) {
                return originPath;
            }
            if (StringsKt.startsWith$default((String)originPath, (String)WSL_MNT_ROOT, (boolean)false, (int)2, null)) {
                String string = DockerComposeUtilsKt.getWindowsPath(originPath);
                if (string == null) {
                    string = originPath;
                }
                return string;
            }
            return InternalUtilsKt.toSystemDependentName(workingDirPath + File.separatorChar + originPath);
        }
        return new File(originPath).isAbsolute() ? originPath : InternalUtilsKt.toSystemIndependentName(workingDirPath + File.separatorChar + originPath);
    }

    private static final String getWindowsPath(String wslPath) {
        String string;
        int driveLetterIndex = 5;
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            string = null;
        } else {
            char c = Character.toUpperCase(wslPath.charAt(driveLetterIndex));
            String string2 = wslPath.substring(slashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)(c + ":" + string2), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
        return string;
    }

    public static final boolean isComposeFilesLabelSupported(@NotNull DockerComposeData.Version $this$isComposeFilesLabelSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposeFilesLabelSupported, (String)"<this>");
        return $this$isComposeFilesLabelSupported.compareTo(new DockerComposeData.Version(1, 25, 0)) >= 0;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String escapeDollarSigns(@Nullable String string) {
        String string2;
        String string3 = string;
        if (string3 != null) {
            CharSequence charSequence = string3;
            Regex regex = new Regex("\\$");
            String string4 = "\\$\\$";
            string2 = regex.replace(charSequence, string4);
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final Map<String, String> escapeDollarSigns(@Nullable Map<String, String> envs) {
        Map map2;
        Sequence sequence = envs;
        if (sequence != null && (sequence = MapsKt.asSequence(sequence)) != null) {
            void $this$associateByTo$iv$iv;
            Sequence $this$associateBy$iv = sequence;
            boolean $i$f$associateBy = false;
            Sequence sequence2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                String string = DockerComposeUtilsKt.escapeDollarSigns((String)it.getKey());
                boolean bl2 = false;
                String string2 = DockerComposeUtilsKt.escapeDollarSigns((String)it.getValue());
                map3.put(string, string2);
            }
            map2 = destination$iv$iv;
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String[] escapeDollarSigns(@Nullable String[] command) {
        String[] stringArray;
        if (command != null) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = command;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DockerComposeUtilsKt.escapeDollarSigns((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull List<String> configurationPathNames) throws FileNotFoundException {
        List<Path> list2;
        Intrinsics.checkNotNullParameter(configurationPathNames, (String)"configurationPathNames");
        if (!(!configurationPathNames.isEmpty())) {
            boolean bl = false;
            String string = "Configuration path name list must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        String mainConfigurationPathname = configurationPathNames.get(0);
        if (Files.isDirectory(Paths.get(mainConfigurationPathname, new String[0]), new LinkOption[0])) {
            list2 = DockerComposeUtilsKt.findDockerComposeConfigurationFiles(mainConfigurationPathname);
        } else {
            List list3 = Stream.concat(Stream.of(Paths.get(mainConfigurationPathname, new String[0])), configurationPathNames.stream().skip(1L).map(arg_0 -> DockerComposeUtilsKt.findDockerComposeConfigurationFiles$lambda$5(findDockerComposeConfigurationFiles.2.INSTANCE, arg_0)).filter(arg_0 -> DockerComposeUtilsKt.findDockerComposeConfigurationFiles$lambda$6(findDockerComposeConfigurationFiles.3.INSTANCE, arg_0))).collect(Collectors.toList());
            Intrinsics.checkNotNull(list3);
            list2 = list3;
        }
        return list2;
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull String configurationPathname) throws FileNotFoundException {
        List list2;
        Intrinsics.checkNotNullParameter((Object)configurationPathname, (String)"configurationPathname");
        Path path = Paths.get(configurationPathname, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Intrinsics.checkNotNull((Object)path);
            Path configurationPath = DockerComposeUtilsKt.findDockerComposeConfigurationPath(path);
            Path overrideConfiguration = configurationPath.resolveSibling(DOCKER_COMPOSE_OVERRIDE_FILENAME);
            if (Files.isRegularFile(overrideConfiguration, new LinkOption[0])) {
                Object[] objectArray = new Path[]{configurationPath, overrideConfiguration};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list2 = CollectionsKt.listOf((Object)configurationPath);
            }
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            list2 = CollectionsKt.listOf((Object)path);
        } else {
            throw new FileNotFoundException("Neither folder nor file \"" + path + "\" exists");
        }
        return list2;
    }

    private static final Path findDockerComposeConfigurationPath(Path folder) throws FileNotFoundException {
        for (String filename : DOCKER_COMPOSE_SUPPORTED_FILENAMES) {
            Path configurationPath = folder.resolve(filename);
            if (!Files.isRegularFile(configurationPath, new LinkOption[0])) continue;
            Intrinsics.checkNotNull((Object)configurationPath);
            return configurationPath;
        }
        throw new FileNotFoundException(StringsKt.trimIndent((String)("\n      Can't find a suitable configuration file in this directory. \n      Supported filenames: " + CollectionsKt.joinToString$default((Iterable)DOCKER_COMPOSE_SUPPORTED_FILENAMES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n    ")));
    }

    @NotNull
    public static final String getDockerComposeProjectName(@NotNull Path composeFilePath) {
        Intrinsics.checkNotNullParameter((Object)composeFilePath, (String)"composeFilePath");
        Path parent = composeFilePath.toAbsolutePath().getParent();
        return parent == null || parent.getFileName() == null ? DEFAULT_DOCKER_COMPOSE_PROJECT_NAME : ((Object)parent.getFileName()).toString();
    }

    @Nullable
    public static final Path getDockerComposeDefaultWorkDir(@NotNull List<? extends Path> configurationFilePaths) {
        Path path;
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        Path mainConfigurationFilePath = (Path)CollectionsKt.firstOrNull(configurationFilePaths);
        if (mainConfigurationFilePath == null) {
            path = null;
        } else {
            Path path2;
            try {
                path2 = mainConfigurationFilePath.toAbsolutePath().getParent();
            }
            catch (IOError e) {
                path2 = mainConfigurationFilePath.getParent();
            }
            path = path2;
        }
        return path;
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @NotNull List<? extends Path> configurationFilePaths, @Nullable Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        return DockerComposeUtilsKt.getEffectiveDockerComposeProjectName(projectName, DockerComposeUtilsKt.getDockerComposeDefaultWorkDir(configurationFilePaths), envs);
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @Nullable Path workDir2, @Nullable Map<String, String> envs) {
        String composeProjectName;
        if (projectName != null) {
            return projectName;
        }
        Map<String, String> map2 = envs;
        String string = composeProjectName = map2 != null ? map2.get(COMPOSE_PROJECT_NAME_ENV_VAR) : null;
        if (composeProjectName != null) {
            return composeProjectName;
        }
        return workDir2 == null || workDir2.getFileName() == null ? null : ((Object)workDir2.getFileName()).toString();
    }

    public static final boolean isDockerComposeNamedVolumeBind(@NotNull String bindPath) {
        String path;
        Intrinsics.checkNotNullParameter((Object)bindPath, (String)"bindPath");
        String $this$trim$iv = bindPath;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)(path = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            return false;
        }
        return DockerComposeUtilsKt.isWindowsAbsolutePath(path) ? false : !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)".", (boolean)false, (int)2, null);
    }

    private static final boolean isWindowsAbsolutePath(String path) {
        return Platform.INSTANCE.isWindows() && !(((CharSequence)path).length() == 0) && new File(path).isAbsolute();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object composeConfig(@NotNull DockerCli var0, @NotNull List<String> var1_1, @Nullable String var2_2, @NotNull Continuation<? super DockerComposeConfigurationV2> var3_3) {
        if (!(var3_3 instanceof composeConfig.1)) ** GOTO lbl-1000
        var23_4 = var3_3;
        if ((var23_4.label & -2147483648) != 0) {
            var23_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerComposeUtilsKt.composeConfig(null, null, null, (Continuation<? super DockerComposeConfigurationV2>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$flatMap$iv = (Iterable)files;
                $i$f$flatMap = false;
                var7_10 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$fileArgs$1 = false;
                    var14_26 = new String[]{"-f", it};
                    list$iv$iv = CollectionsKt.listOf((Object[])var14_26);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$toTypedArray$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                fileArgs = thisCollection$iv.toArray(new String[0]);
                v0 = $this$composeConfig;
                $i$f$toTypedArray = new SpreadBuilder(4);
                $i$f$toTypedArray.add((Object)"compose");
                $i$f$toTypedArray.addSpread((Object)fileArgs);
                $i$f$toTypedArray.add((Object)"config");
                $i$f$toTypedArray.add((Object)"--profiles");
                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = workingDir;
                $continuation.L$2 = fileArgs;
                $continuation.label = 1;
                v1 = Cli.execAsyncWithResult$default(v0, CollectionsKt.listOf((Object[])$i$f$toTypedArray.toArray((Object[])new String[$i$f$toTypedArray.size()])), null, null, null, null, workingDir, null, null, (Continuation)$continuation, 222, null);
                if (v1 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl49
            }
            case 1: {
                fileArgs = (String[])$continuation.L$2;
                workingDir = (String)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl49:
                // 2 sources

                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = workingDir;
                $continuation.L$2 = fileArgs;
                $continuation.label = 2;
                v2 = ((AsyncCliProcess)v1).await($continuation);
                if (v2 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl63
            }
            case 2: {
                fileArgs = (String[])$continuation.L$2;
                workingDir = (String)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl63:
                // 2 sources

                if ((execProfiles = (ProcessResult)v2).getExitCode() != 0) {
                    throw new IOException(CollectionsKt.joinToString$default((Iterable)execProfiles.getStdErr(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                $this$filter$iv = StringsKt.lines((CharSequence)CollectionsKt.joinToString$default((Iterable)execProfiles.getStdOut(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
                $i$f$filter = false;
                $i$f$flatMapTo = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (E element$iv$iv : $this$filterTo$iv$iv) {
                    p0 = (String)element$iv$iv;
                    $i$a$-filter-DockerComposeUtilsKt$composeConfig$profiles$1 = false;
                    if (!(StringsKt.isBlank((CharSequence)p0) == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                profiles = (List)destination$iv$iv;
                v3 = $this$composeConfig;
                $i$f$filter = new SpreadBuilder(4);
                $i$f$filter.add((Object)"compose");
                $i$f$filter.addSpread((Object)fileArgs);
                $i$f$filter.add((Object)"config");
                $this$filterTo$iv$iv = profiles;
                var20_30 = $i$f$filter;
                var19_31 = v3;
                $i$f$flatMap = false;
                $i$f$filterTo = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$execConfig$1 = false;
                    var18_34 = new String[]{"--profile", it};
                    list$iv$iv = CollectionsKt.listOf((Object[])var18_34);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                var21_35 = (List)destination$iv$iv;
                $this$toTypedArray$iv = var21_35;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                var20_30.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v4 = Cli.execAsyncWithResult$default(var19_31, CollectionsKt.listOf((Object[])$i$f$filter.toArray((Object[])new String[$i$f$filter.size()])), null, null, null, null, var2_2, null, null, (Continuation)$continuation, 222, null);
                if (v4 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl114
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl114:
                // 2 sources

                $continuation.label = 4;
                v5 = ((AsyncCliProcess)v4).await($continuation);
                if (v5 == var24_6) {
                    return var24_6;
                }
                ** GOTO lbl122
            }
            case 4: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl122:
                // 2 sources

                if ((execConfig = (ProcessResult)v5).getExitCode() != 0) {
                    throw new IOException(CollectionsKt.joinToString$default((Iterable)execConfig.getStdErr(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                $i$f$filter = DockerComposeDeserializer.Companion.getMapper();
                src$iv = new StringReader(CollectionsKt.joinToString$default((Iterable)execConfig.getStdOut(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
                $i$f$readValue = false;
                $i$f$jacksonTypeRef = false;
                return $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<DockerComposeConfigurationV2>(){});
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object composeConfig$default(DockerCli dockerCli, List list2, String string, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return DockerComposeUtilsKt.composeConfig(dockerCli, list2, string, (Continuation<? super DockerComposeConfigurationV2>)continuation);
    }

    @NotNull
    public static final Map<String, DockerComposeServiceBase> getServices(@NotNull DockerComposeConfiguration $this$getServices) {
        Intrinsics.checkNotNullParameter((Object)$this$getServices, (String)"<this>");
        Object t = $this$getServices.accept(new DockerComposeConfiguration.Visitor<Map<String, ? extends DockerComposeServiceBase>>(){

            @NotNull
            public Map<String, DockerComposeServiceV1> visit(@NotNull DockerComposeConfigurationV1 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV1> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }

            @NotNull
            public Map<String, DockerComposeServiceV2> visit(@NotNull DockerComposeConfigurationV2 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV2> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"accept(...)");
        return (Map)t;
    }

    @NotNull
    public static final Set<String> getServiceNames(@NotNull DockerComposeConfiguration $this$getServiceNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getServiceNames, (String)"<this>");
        return DockerComposeUtilsKt.getServices($this$getServiceNames).keySet();
    }

    private static final Path findDockerComposeConfigurationFiles$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Path)$tmp0.invoke(p0);
    }

    private static final boolean findDockerComposeConfigurationFiles$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"docker-compose.yml", "docker-compose.yaml"};
        DOCKER_COMPOSE_SUPPORTED_FILENAMES = CollectionsKt.listOf((Object[])objectArray);
        DOCKER_COMPOSE_OVERRIDE_FILENAME = "docker-compose.override.yml";
        DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";
    }
}

